PROGRAM GRAV;

{---------------------------------------------------------------------------}
{  Logiciel GEOCEAN - module GRAV =                                         }
{  programme principal du  logiciel MODELES      version 1.x du  06/04/96   }
{---------------------------------------------------------------------------}

{---------------------------------------------------------------------------}
{  Institut National de Recherche Pdagogique - PARIS                       }
{  Equipe INRP  TOULOUSE                                                    }
{  S. DUPOUY, C. GROS, R. CULOS, F. BOULANGER, J. TONNELAT, J. Y. GUCHEREAU }
{  Ralisation :                                                            }
{  A R X - Alain, Roger et Xavier CULOS - 6 avenue de Lagarde 31130 BALMA   }
{---------------------------------------------------------------------------}

{---------------------------------------------------------------------------}
{ fichiers spciaux associs au logiciels GEOCEAN                           }
{ *  *       .SMB            symboles                         dans rep PRG  }
{ *  GEOCEAN .CFG            paramtres de configuration      dans rep PRG  }

{ fichiers spciaux associs  ce programme                                 }
{ *  GRAV    .ICN            images, icnes                   dans rep PRG  }
{ *  GRAV    .PAL            palette                          dans rep PRG  }
{ *  GRAV    .TXT            mini documentation du programme  dans rep PRG  }
{ *  GRAV    .AID            texte d'aide                     dans rep PRG  }

{---------------------------------------------------------------------------}
{ fichiers associs aux donnes utilises                                   }
{    *       .GRA            Profil d'anomalies gravimtriques dans rep TRV }
{    *       .GAM            Corps                                          }
{    *       .DAT            Profil sismique                                }
{---------------------------------------------------------------------------}
{ fichiers gnrs                 ( rpert. de travail )                   }
{    *       .GRV            paramtres du travail en cours                 }
{    *       .DXT            Commentaires associs/carte                    }
{    *       .PLT            Code HPGL ou imprimante                        }
{    *       .PCX            Copie cran PCX  N&B                           }
{---------------------------------------------------------------------------}

{$M 65520,0,655360}

USES
   GRAV_REC,         { gestion des recouvrements                            }

   CSI,              { gestion du Clavier, de la Souris et des Icnes       }
   MENUS,            { interface  menus droulants                          }

   GEO_VAR,          { variables globales communes                          }
   GEO_DES,          { procedures div communes                              }

   GRAV_VAR,         { variables globales propres au module                 }
   GRAV_DES,         { graphisme du module                                  }
   GRAV_INI,         { initialisations                                      }

   GRAV_5,           { menu : SORTIES                                       }
   GRAV_4,           { menu : ECRAN                                         }
   GRAV_3,           { menu : LEGENDES                                      }
   GRAV_2,           { menu : GRAV                                          }
   GRAV_1;           { menu : FICHIERS  gestion des rpertoires             }

{---------------------------------------------------------------------------}
(*{$O GRAV_var}        { dfinition des units en recouvrement                }
{$O GRAV_ini}
{$O GRAV_des}*)

{$O geo_var}
{$O geo_des}
{$O Menus}
{$O CSI}
{$O Icones}

{$O periphs}
{$O comment}
{$O dirinfo}
{$O lipar}

{$O graphplt}
{$O edition}
{$O utildivs}
{$O fichiers}
{$O graphism}
{$O rs2322}
{$O sekoplt}
{$O imprim}
{---------------------------------------------------------------------------}

procedure CasMenus;
   var
      Choix             : integer;

   begin
      if changemenus then exit;
      menu (a, b, codeclavier);{ MENU2 }
                               { acquisition d'un choix valide dans un menu }

      if FF1 (codeclavier)     { CSI }
      then                     { appui sur la touche F1 dans un sous-menu   }
         aide (a, b)           { GRAV_INI }
      else begin
         if b > 1
         then
            Choix := 100*a+b;
         case Choix of         { validation d'une option dans un sous-menu  }
            { menu FICHIERS }
            102  : NOUVEAU_FICHIER;                   { 1 }
            103  : OUVRIR_FICHIER;                    { 1 }
            104  : ENREGISTRER_FICHIER;               { 1 }
            105  : ENREGISTRER_SOUS;                  { 1 }
            106  : VOIR_CATALOGUE;                    { menus5 }
            108  : QUITTER;                           { 1 }

            110  : SUPPRIMER_LIEN;                    { 1  p }
            111  : MODIFIER_LIEN;                     { 1  p }
            112  : VOIR_PARAMETRES;                   { 1  p }

            { menu GRAV  }
            202  : d_modele;                          { 2 }
            203  : d_constante;                       { 2 }
            205  : CALCULER;                          { 2 }
            (*  207  : d_poly;                            { 2 }
            208  : d_gravi;                           { 2 } *)

            { menu LEGENDES }
            302  : COMMENTAIRES;                      { 3 }
            303  : AXES;                              { 3 }
            305  : d_params_legende;                  { 3  p }

            { menu  ECRAN }
            402  : visu_commentaires;                 { 4 }
            403  : Visu_numeros;                      {   }
            404  : visu_echelle1;                     { 4 }
            405  : visu_quadr;                        { 4 }
            406  : visu_seismes;                      { 4 }
            407  : visu_contraste;                    { 4 }

            { menu SORTIES }
            502  : COPECRAN;                          { 5 }
            504  : TRACE_GRAPH;                       { 5 }
            507  : geo_PALETTES (nomdumodule);        { GEO_DES }
            508  : CONFIG_PERIPH;                     { GEO_DES }
            509  : IMPR_PARAM;                        { 5  prof }

            { menu AIDES }
            602  : AIDE_MENUS_boites (cheminmodule+nomdumodule+exthlp);                        { ini }
            603  : aide (6, 3);
            604  : aide_geoc;
            605  : aide_module;
            606  : aide_region;
            608  : a_propos;
{            610  : MODEXO;            }
         end;
      end;
   end;

procedure CasIcones;
   begin
      if changemenus then exit;
      action2 := ZonEcran (xs, ys);

      if affichetexte            { appui sur F1 au niveau d'une icne       }
      then
         case Action2 of                               { CSI }
             1 : aide_geoc;             {  }
             2 : version_logiciel;      {  }
             3 : aide (2, 5);           {  }
             4 : aide_module;           {  }
         end
      else begin
         if ((action2 > 5) and (action2 < 11))
            or (action2 = 12)
            or (action2 = 16)
         then begin
            ChangerIcone (Action, Action2, 12);
            Action := action2;
         end;

         case action2 of
             1     : a_propos;
             3     : CALCULER;                                   { CART_2   }
             4     : aide_region;
             5     : SaisirNouveauPoly;
            11     : SupprimerPoly;
            13     : AffecterAttribut;
            14     : Zoomer;
            15     : Dezoomer;
            17, 18 : visu_contraste;
            19, 20 : visu_echelle1;
            21, 22 : visu_seismes;
         end;
      end;
   end;

procedure CasFenetre;
   begin
      if changemenus then exit;
      if visucomm
      then
         Editer_Commentaires (xs, ys, db);

      if db
      then
         SelectionneRoche;

      case action of
         16 : SelectionneRoche;
      end;

      if VisuDensite and not db
      then begin
         ModiPar := true;

    {     case action of
            9 : TirerPoints (xs, ys);        <<plante>>
         end;}

         if RocheCourante <> NIL
         then
            if not (PolyFlotte (RocheCourante) and flottefixe)
            then
               case action of
                   6 : DeplacerPoly   (xs, ys);
                   7 : TirerUnPoint   (xs, ys);
                   8 : Coller         (xs, ys);
                   9 : TirerPoints    (xs, ys);
                  10 : CouperPoly     (xs, ys);
                  12 : SupprimerPoint (xs, ys);
               end;

(*         if DansLaListe (xs, ys)
         then
            case action of
                6 : DeplacerPoly;
            end; *)
      end;
   end;

procedure AutreCas;
   begin
      if changemenus then exit;
   end;

BEGIN                { programme principal }

   iniparam ;        { initialisation des paramtres par dfaut    GRAV_INI }
                     { lecture de fic.CFG                                   }
   inimenus ;        { initialisation de l'interface menus         GRAV_INI }
   iniparam2 ;       { initialisation des paramtres par dfaut    GRAV_INI }
                     { lecture des fichiers .CPS, .SMP, .TXP                }
   iniicones;        { initialisation des icnes                   GRAV_DES }
   inifondecran;     { }
   inisymboles;      { initialisation des symboles                 GRAV_DES }

   inidonnees;       { initialisation des donnes                  GRAV_INI }
   iniecran  ;       { initialisation de l'cran/GRAV              GRAV_DES }
   redess_modele (false);
   if nouveau then inimodele;

   iniaide  ;        { initialisation de l'aide en ligne           GRAV_INI }
                     {      lecture de   fic.HLP                            }

   repeat
      modif_menus;   { modifications fonction des paramtres PAR   GRAV_INI }
      case ZoneDuClick (maxc1, maxc2, maxc3, maxc4) of                                       { GEO_CSI }
         1 : CasMenus  ;
         2 : CasIcones ;
         3 : CasFenetre;
         4 : autreCas  ;
      end;
      if changemenus
      then
         inversemenus;
   until fini;
   fin;                                                          { GRAV_INI }

END.                 { programme principal }


{--- GEOCEAN - GRAV -------------------------- R.C.- INRP - TOULOUSE - 1995 }