PROGRAM installe;
{---------------------------------------------------------------------------}
{  Logiciel GEOCEAN -  INTERFACE UTILISATEUR                                }
{  programme principal du  logiciel INST        version 1.  du  04/05/95    }
{                                                                           }
{---------------------------------------------------------------------------}

{---------------------------------------------------------------------------}
{  Institut National de Recherche Pdagogique : DP 4, N. SALAME  -  PARIS   }
{                          Equipe INRP  TOULOUSE                            }
{  S. DUPOUY, C. GROS, R. CULOS, F. BOULANGER, J. TONNELAT, J. Y. GUCHEREAU }
{ Ralisation :                                                             }
{  A R X - Alain, Roger et Xavier CULOS - 6 avenue de Lagarde 31130 BALMA   }
{---------------------------------------------------------------------------}

{---------------------------------------------------------------------------}
{ fichiers spciaux associs  ce programme dans le rpertoire MNU          }
{    INST    .NST            images, icnes                                 }
{    INST    .PAL            palette                                        }
{    INST    .TXT            prsentation du module                         }
{    INST    .AID            texte d'aide                                   }
{---------------------------------------------------------------------------}


{$M 32000,0,256000}

USES
   crt,
   dos,
   graph,
   souris,
   lipar,
   graphplt,
   graphism,
   icones,
   menus,
   utildivs,

   fichiers,
   periphs,
   CSI,

   menu_fic,
   menu_var,
   inst_fic;

VAR
   place_prg,           { taille disque ncessaire en octets }
   place_mnu,
   place_dnn
                     : longint;

   ch_pk
                     : dirstr;

   u_prg,
   u_mnu,
   u_dnn,
   u_xpl,
   u_ech,
   u_grp
                     : string [2];

   n_prg,
   n_mnu,
   n_dnn,
   n_xpl
                     : namestr;

   r_prg,
   r_mnu,
   r_dnn,

   cheminb,                           { chemin but      fichiers  D et P    }
   cheminm,
   chemind,

   chemins,                           { chemin source   fichiers Zip        }
   chemini                            { chemin source   fichier NST         }
                     : dirstr;

   z                                  { n zone icone                       }
                     : integer;
   confperso
                     : boolean;

procedure dessine_texte_icone (n : integer; t : string);
   var
      co             : word;
      i1, i2,
      i3, i4,
      px, py         : integer;

   begin
      setusercharsize (5, 4, 5, 4);
      settextjustify  (1, 1);

      i1 := xgicone (n);
      i2 := xdicone (n);
      i3 := ybicone (n);
      i4 := yhicone (n);
      px := (i1+i2) div 2;
      py := (i3+i4) div 2;
      setfillstyle  (1, c_icone);  {couleur icones }
      setcolor      (4);

      bar        (i1, i4, i2, i3);
      outtextxy  (px, py, t);
      setusercharsize (3, 2, 3, 2);
      settextjustify  (0, 2);
   end;

procedure ini_icones;
   const
      posybtn        = 50;

   var
      i,
      px, py,
      lx, iy         : integer;
      af1            : string;

   begin
      af1 := ' - F1=aide';
      px  := posxbtn + 2;

      py  := maxy - posybtn + 8 - ty + 2;
      px  := posxbtn + 3;
      bouton_icone ('AIDE technique',          99, px,      py,    29, 29);
      bouton_icone ('FIN',                    100, px+33*2, py,    29, 29);

      iy := 6;
      py := posybtn+iy;
      px := posxbtn+3 ;
      lx := 93 ;
      bouton_icone ('Installation locale complte sur un seul disque'
                                       +af1, 101, px, py,           lx, 2*ty);
      bouton_icone ('Installation locale personnalise'
                                       +af1, 102, px, py+2*ty  +iy, lx, 2*ty);
      bouton_icone ('Installation sur un serveur de rseau'
                                       +af1, 103, px, py+4*ty+2*iy, lx, 2*ty);
      bouton_icone ('Raffrachir une installation'
                                       +af1, 104, px, py+6*ty+3*iy, lx, 2*ty);
      bouton_icone ('Lister les paramtres en cours'
                                           , 105, px, py+8*ty+4*iy, lx, 2*ty);
   end;

procedure dess_icones;
   begin
      dessine_texte_icone ( 99, 'A');
      dessine_texte_icone (100, 'Q');
      dessine_texte_icone (101, 'MONO STD');
      dessine_texte_icone (102, 'MONO PERSO');
      dessine_texte_icone (103, 'RESEAU STD');
      dessine_texte_icone (104, 'BIS');
      dessine_texte_icone (105, 'PARAMETRES');
   end;

procedure inietat (ci, cf : dirstr);
   begin
      letat ('de : '   +ci,  0, 29);
      letat ('vers : ' +cf, 30, 30);
   end;

procedure extr_chemins;
   var
      D              : DirStr;
      N              : NameStr;
      E              : ExtStr;

   begin
      {}
      fsplit (ch_prg, d, n, e);
      cheminb := d;
      r_prg := copy (d, 3, length (d)-2);
      n_prg := n;

      fsplit (ch_mnu, d, n, e);
      cheminm := d;
      r_mnu := copy (d, 3, length (d)-2);
      n_mnu := n;

      fsplit (ch_dnn, d, n, e);
      chemind := d;
      r_dnn := copy (d, 3, length (d)-2);
      n_dnn := n;

      fsplit (ch_xpl, d, n, e);
      n_xpl := n;
      {}
   end;

procedure iniparam (var ok : boolean);
   begin
      { paramtres par dfaut de l'installation }
      chemin_courant (ch_ct, ok);      { chemin absolu explicite }

      if ok and exists (ch_ct+'\'+nominstal + extins)
      then
         chemini := ch_ct
      else begin
         if exists (ch_mnu+'\'+nominstal + extins)
         then begin
            chemini := ch_mnu;
            ok      := true;
         end else
            ok := false;
      end;

      ch_pk  := chemini;

      if not ok
      then begin
         writeln ('--- GEOCEAN : installation initiale -----------------');
         writeln ('---           Fichier d''installation non trouv !');
         writeln ('Il faut se placer dans le rpertoire qui le contient.');
         halt;
      end;

      ini_par_ins (chemini+'\'+nominstal + extins);

      extr_chemins;

      fini      := false;
      modipar   := false;
      ok        := false;
      c_icone   :=  2;
      coulecran := 15;

      { affecter rpertoire configuration graphique   }
      repbgi := maj (getenv ('repbgi'));
      if repbgi = ''
      then begin
         if exists (ch_mnu+'\egavga.bgi')
         then
            repbgi := ch_mnu
         else
            repbgi := chemini;
      end;

      if not rep_dos (repdos)
      then
         repdos := 'c:\dos';
         confperso := false;
   end;

procedure ini_src (var ok : boolean);
   begin
      if ok and exists (ch_ct+'\Zprg.zip')
      then
         chemins := ch_ct
      else
         nom_repert_existant ('Chemin fichiers  extraire', chemins, ok);
   end;

procedure iniplace;
   begin
      place_prg := 1500000;           { taille disque ncessaire en octets }
      place_mnu := 1000000;
      place_dnn := 2000000;
   end;

procedure inimenus;
   begin
      complete      (repbgi);
      ini_menu      (repbgi, 2);
      chargepalette (repbgi+nominstal+extpal, ok);
      setcoulmenu   ( 15 ,      0,        3,      6,
                        0,      1,        2,      6);
   end;
(*
procedure grand_titre  (coul : integer);
   var
      px, py            : integer;
      t1, t2, t3        : string;

   begin
      nouveau_style (1, 0, 4);
      settextjustify (1, 2);
      t1 := 'INSTALLATION';
      t2 := 'DES PROGRAMMES';
      t3 := 'ET DONNEES';

      px := posxbtn div 2;
      py := hauteurmenu+ 3*ty;
      outtextxy  (px, py, t1);
      py := py + 2*ty + textheight (t1);
      outtextxy  (px, py, t2);
      py := py + 2*ty + textheight (t1);
      outtextxy  (px, py, t3);

      ancien_style;
      settextjustify (0, 2);
   end;
*)
procedure fond_ecran (cfe, cfi : word);
   begin
      SetFillStyle (SolidFill, cfe);
      bar       (0, 0,  maxx, maxy-ty);     { couleur fond cran }

      setfillstyle (1, cfi);                { zone icones }
      bar       (posxbtn, 0,             maxx,      maxy-ty);

      setcolor  (4);
      rectangle (4,       hauteurmenu+4, posxbtn-4, maxy-5-2*ty);
   end;

procedure dess_bandeau (c : word);
   var
      lx, py  : integer;

   begin
      nouveau_style (1, 0, 1);
      lx := (posxbtn-1) div 2;
      setfillstyle  (1, 7);
      bar        (0, 0,   posxbtn-1, hauteurmenu);

      setcolor   (c);
      py := hauteurmenu div 2 - 2;
      settextjustify (1, 1);
      outtextxy  (lx, py, 'test I N S T A L L A T I O N');
      ancien_style;
   end;

procedure dess_ecran;
   var
      i              : integer;

   begin
      posxbtn  := 540;    { ncessaire aprs bascule }
      fond_ecran   (15, 7);
      dess_bandeau (4);
      { grand_titre  (4);}

      dess_icones;
      for i :=  99 to 105
      do
         active_icone   (i);
      inietat (chemins, cheminb);
   end;

procedure iniecran;
   begin
      posxbtn  := 540;    { ncessaire pour icones }
      ini_icones;
      dess_ecran;
   end;

procedure finir;
   begin
      parins.fini;
      liberericones;
      ecrantexte;
   end;

procedure voir_pins;
   begin
      parins.boite;                                                 { lipar }
      bte_compl ('paramtres installation', -1, -1, 60, nbo, 60, 10);
   end;

procedure copie_bgi (ci : dirstr; var ok : boolean);
   var
      nb             : integer;

   begin
      complete (ch_mnu);
      complete (ch_prg);
      copier_fichiers (ci+'*.bgi', ch_mnu, nb);
      copier_fichiers (ci+'*.chr', ch_mnu, nb);
      copier_fichiers (ci+'*.bgi', ch_prg, nb);
      copier_fichiers (ci+'*.chr', ch_prg, nb);
      enleve_antislash (ch_mnu);
      enleve_antislash (ch_prg);
   end;

procedure copie_fichiers_annexes   (ci, cf  : dirstr; var ok : boolean);
   var
      nb             : integer;

   begin
      complete (ci);
      complete (cf);
      copier_fichiers (ci+'*.txt',       cf, nb);
      copier_fichiers (ci+'geocean.ico', cf, nb);
      copier_fichiers (ci+'geocean.grp', cf, nb);
   end;

procedure copie_fichiers_donnees    (ci, cf  : dirstr ; var ok : boolean);        { COPY   }
   { extrait tout zdnn.zip et zxpl.zip dans le rpertoire Cf      dj cr }
   { quivaut au Bat ancien }
   var
      nb             : integer;

   begin
      complete (ci);
      complete (cf);
      restorecrtmode;

      if exists (ci+'zdnn.zip')
      then
         extraire_fichiers_zip (ch_pk, ci+'zdnn', '-d -o', '*.*', cf+n_dnn, ok);
      if not ok
      then
         ch_dnn := '';

      if exists (ci+'zxpl.zip')
      then
         extraire_fichiers_zip (ch_pk, ci+'zxpl', '-d -o', '*.*', cf+n_xpl, ok);
      if not ok
      then
         ch_xpl := '';

      inimenus;
      dess_ecran;
   end;

procedure copie_fichiers_prg    (ci, cf  : dirstr ; var ok : boolean);        { COPY   }
   { extrait zprg.zip  et zmnu.zip  dans le rpertoire Cheminp  dj cr }
   { quivaut au Bat ancien }
   var
      nb             : integer;

   begin
      complete (ci);
      complete (cf);
      restorecrtmode;
      if exists (ci+'zprg.zip')
      then
         extraire_fichiers_zip (ch_pk, ci+'zprg', '-d -o', '*.*', cf+n_prg, ok);
      if not ok
      then
         ch_prg := '';

      if exists (ci+'zmnu.zip')
      then
         extraire_fichiers_zip (ch_pk, ci+'zmnu', '-d -o', '*.*', cf+n_mnu, ok);
      if not ok
      then
         ch_mnu := '';

      inimenus;
      dess_ecran;
   end;

procedure copie_fichiers_monostd    (ci, cf  : dirstr ; var ok : boolean);        { COPY   }
   { extrait tout zip dans le rpertoire Cheminp  dj cr }
   { quivaut au Bat ancien }
   var
      nb             : integer;

   begin
      copie_fichiers_donnees (ci, cf, ok);
      copie_fichiers_prg     (ci, cf, ok);
   {   enleve_antislash                  (cf);}
      inietat         (ci+'geocean.bat', cf);
      copier_fichiers (ci+'geocean.bat', cf, nb);
   end;

procedure cfg_monostd (var ok : boolean);
   begin
      enleve_antislash (cheminb);
      question ('Installation standard ... ', cheminb, ok);
      if ok
      then begin
         creer_repert (cheminb, place_dnn+place_prg+place_trv, ok);        { MD      }
         inietat (chemins, cheminb);
         chdir (ch_ct);
      end;

      if ok
      then begin
         copie_fichiers_monostd    (chemins, cheminb, ok);        { pkunzip }
         copie_fichiers_annexes    (chemins, cheminb, ok);
         copie_bgi                 (chemins, ok);
      end;
      nstok   := ok;
      modipar := true;
   end;

procedure copie_fichiers_perso (ci : dirstr; var ok : boolean);
   begin
      complete (ci);
      restorecrtmode;
      if exists (ci+'zprg.zip')
      then
         extraire_fichiers_zip (ch_pk, ci+'zprg', '-d -o', '*.*', ch_prg, ok);
      if not ok
      then
         ch_prg := '';

      if exists (ci+'zmnu.zip')
      then
         extraire_fichiers_zip (ch_pk, ci+'zmnu', '-d -o', '*.*', ch_mnu, ok);
      if not ok
      then
         ch_mnu := '';

      if exists (ci+'zdnn.zip')
      then
         extraire_fichiers_zip (ch_pk, ci+'zdnn', '-d -o', '*.*', ch_dnn, ok);
      if not ok
      then
         ch_dnn := '';

      if exists (ci+'zxpl.zip')
      then
      extraire_fichiers_zip (ch_pk, ci+'zxpl', '-d -o', '*.*', ch_xpl, ok);
      if not ok
      then
         ch_xpl := '';

      inimenus;
      dess_ecran;
      modipar := true;
   end;

procedure cfg_perso      (var ok : boolean);
   var
      i              : integer;

   begin
      confperso := true;
      nom_repert ('Chemin pour Interface menus :', cheminm, ok);
                                    {  saisie dest }
      if ok
      then begin
         creer_repert (cheminm, place_mnu, ok);        { MD     }
         if ok
         then
            inietat (chemins, cheminm);
         chdir (ch_ct);
         ch_mnu := cheminm+'\'+n_mnu;
         r_mnu  := copy (ch_mnu, 3, length (ch_mnu)-1);
         u_mnu  := copy (ch_mnu, 1, 2);
      end;

      if ok
      then begin
         nom_repert ('Chemin pour programmes et donnes :', cheminb, ok);
                                    {  saisie dest }
         if ok
         then begin
            creer_repert (cheminb, place_prg+place_dnn, ok);        { MD     }
            if ok
            then
               inietat (chemins, cheminb);
            chdir (ch_ct);
            ch_prg := cheminb+'\'+n_prg;
            ch_dnn := cheminb+'\'+n_dnn;
            ch_xpl := cheminb+'\'+n_xpl;
         end;
      end;

      if ok
      then begin
       {!! choisir modules/rgions }
         copie_fichiers_perso      (chemins, ok);
         copie_fichiers_annexes    (chemins, cheminm, ok);       { pkunzip }
         copie_bgi                 (chemins, ok);
      end;
      nstok := ok;
   end;

procedure refaire_bat (nomf : dirstr; var ok : Boolean);
   var
      fbat           : text;

   begin
      assign  (fbat, nomf);
      rewriteTxterr (fbat, nomf, ok);
      writeln ( fbat, '@echo off');          { retour dans le rp initial }
      writeln ( fbat, 'rem '+nomlogiciel+'.BAT  - '+datjour);
      writeln ( fbat, 'rem lance '+nomlogiciel+' install sur le DD '+u_mnu);
      writeln ( fbat, 'rem ce programme devrait tre log dans le rpertoire qui contient les');
      writeln ( fbat, 'rem autres fichiers BAT ( condition qu''il figure dans le PATH...)');
      writeln ( fbat, '');
      writeln ( fbat, u_mnu);
      writeln ( fbat, 'CD '+r_mnu);
      writeln ( fbat, '');
      writeln ( fbat, 'Menuex '{+nommenu+nomcfg});
      writeln ( fbat, '');

      close   ( fbat )
   end;

procedure maj_fichiers_inst (var ok : boolean);
   begin
      if ok
      then begin
        { modifie_menu (ok);}
         ecr_par_ins  (ch_mnu+'\'+nominstal+extins);
         if confperso and ok
         then
            refaire_bat  (cheminm+'\'+nomlogiciel+'.BAT', ok);
      end else begin
         { dtruire rep but  }
      end;
   end;

procedure refaire (var ok : boolean);
   begin
      message ('en cours...');
      ok := false;
   end;

procedure voir_params;
   begin
     {     voir_ptrav;}
      voir_pins;
   end;

procedure salut (ok : boolean);
   begin
      if {modipar and }ok
      then
         maj_fichiers_inst (ok);

      if ok
      then
         message3 ('Installation russie',
                   '',
                   'Taper INST pour configurer compltement GEOCEAN')
      else
         message ('Installation interrompue');
   end;

procedure quitter;
   begin
      question ('Voulez vous', 'quitter le programme ', fini);
   end;

procedure aide (x, y : integer);
   begin
      aff_aide (chemini+'\'+nominstal + exthlp, x, y);
   end;

{--------------------------------   INSTALLE   ------------------------------}

BEGIN

   iniparam (ok);
   inimenus;
   iniplace;
   iniecran;
   ini_src  (ok);
   if ok
   then begin
      initaide (chemini+'\'+nominstal + exthlp, ok);
      aide (1,  8) ; { lisez moi }
      repeat
         AttendClick (xs, ys, z, g, d, db);
         z := zonecran (xs, ys);                                      { CSI }

         if z > 98
         then
            marquericone   (z, 4 );

         if affichetexte               { appui sur F1 au niveau d'une icne }
         then
            case z of
                99    : aide (1,  1);  { SOS                     }
               100    : aide (1,  2);  { message ('TOUCHE FIN'); }
               101    : aide (1,  3);  { cfg   mono std          }
               102    : aide (1,  4);  { cfg   mono pers         }
               103    : aide (1,  5);  { cfg   reseau            }
               104    : aide (1,  6);  { cfg   bis               }
               105    : aide (1,  7);  { cfg   voir              }
            end
         else
            case z of
                99    : aide (1,  8);  { lisez_moi       }
               100    : quitter;
               101    : begin
                           aide (1, 3);
                           cfg_monostd   (ok);
                        end;
               102    : begin
                           aide (1, 4);
                           cfg_perso     (ok);
                        end;
               103    : begin
                           aide (1, 5);
                           cfg_perso     (ok);
                        end;
               104    : begin
                           aide (1, 6);
                           refaire       (ok);
                        end;
               105    : voir_params;
            end;
         if z > 98
         then
            marquericone   (z, 7);
      until fini;
   end;
   salut (ok);
   finir;

END.

