UNIT IMPRIM;

{---------------------------------------------------------------------------}
{         bibliothque                                                      }
{                          "drivers" copie d'cran                          }
{                                                               27/01/93    }
{---------------------------------------------------------------------------}
{         d'aprs la revue UTILISATEUR DE L'IBM PC                          }
{                                                                           }
{         et PASCALISSIME                                                   }
{---------------------------------------------------------------------------}
{  A R X - Alain, Roger et Xavier CULOS - 6 avenue de Lagarde  31130 BALMA  }
{---------------------------------------------------------------------------}

(*
*)

INTERFACE

{$O+,F+}

USES
   dos,
   crt,
   graph,
   printer,                  { TP 70   - units  standard Borland           }
   Graphism,                 { ARX     - initialisations graphiques         }
   Rs2322;                   { ARX     - gestion voie srie                 }


Procedure impvga_9C (nport : integer);
   { recopie d'cran vga 4 passes paysage(1/1) sur 9 aiguilles
                                                      pour IBM ou EPSON     }

Procedure Ejecte;       { sur le port courant }
   { saut de page forc                                                     }

Procedure ouvreport;
   { ouverture port : utile avec sortie srie                               }

Procedure fermeport;
   { idem en fermeture                                                      }

Function  ArretDemande : boolean;
   { lecture ESC en cours d'impression                                      }

Procedure impr_HP550C (inverse : boolean ;
                       MinLig, MinCol, MaxLig, MaxCol, nport : Integer);
   { recopie d'cran vgaNB portrait  sur HP 500                             }

Procedure impvga_8    (nport : integer);
   { recopie d'cran vgaNB paysage(1/1) sur 8 aiguilles pour LQ.            }

Procedure impvga_24   (nport : integer);
   { recopie d'cran vgaNB paysage(1/9) sur 24 aiguilles pour LQ.           }

Procedure impvga_8c   (nport : integer);
   { recopie d'cran vga 4 passes paysage(1/1) sur 8 aiguilles pour LQ.     }

Procedure impvga_8c1  (nport : integer);
   { recopie d'cran vga 1 passe  paysage(1/1) sur 8 aiguilles pour LQ.     }

Procedure SauvePCX    (xg, yh, xd, yb : word; nom : string);
   { Enregistrer une image au format PCX                                    }
   { t < 64 Ko }

Function InitImprime  (Imprimante : integer) : boolean;
   { Entre : N de l'Imprimante ( 0 ),
           Sortie : true si aucune erreur sinon false }

{---------------------------------------------------------------------------}
IMPLEMENTATION

CONST
   Port_VGA             = $03CE;
   Esc                  = #27;
   FF                   = #12;
   {   MaxY      = 3389;     nombre maxi de points sur une page A4  300 ppp
       MaxX      = 2338;   }

procedure ouvreport;
   begin
      rewrite (lst);
   end;

procedure fermeport;
   begin
      close   (lst);
   end;

function InitImprime (Imprimante : integer) : boolean;
         { Entre : N de l'Imprimante ( lpt1 = 0 ; lpt2 = 1; lpt3 = 2 ),
           Sortie : true si aucune erreur sinon false }
   var
      Register          : registers;
                        {variable de registre pour appel d'interruption}

   begin
      Register.ax := $200;
      Register.dx := Imprimante;
      intr ($17, Register);
      InitImprime := (Hi (Register.ax) = $90);
      { test bits 7 et 4 : imprimante   disponible et slectionne }
   end;

procedure Envoie       (S : String; nport : integer);
   Var
      i                 : byte;
      impreg            : registers;

   Begin
      impreg.dx := nport;
      For i := 1 to Length(s)
      do begin
          impreg.ax := ord(s[i]);
          intr  ($17, impreg);
      end;
   end;

procedure Ejecte;
   Begin
      Write (Lst, FF);
{       Envoie (Esc+'&l0H');}
   end;

function ArretDemande                                           : boolean;
   VAR
      cc                : char;

   BEGIN
      ArretDemande := FALSE;
      IF NOT Keypressed THEN exit;
      cc := ReadKey;
      IF ord (cc) IN [0, 27] THEN ArretDemande := TRUE;
   END;

procedure impr_HP550C (inverse : boolean ;
                       MinLig , MinCol , MaxLig , MaxCol, nport : Integer);
   (* Unit permettant d'imprimer un cran VGA 640*480 ou 640*350 *)
   (* sur une imprimante HP 550 couleur                           *)
   (* d'aprs PASCALISSIME n56 oct-dc 93                        *)
   {Begin imprime_vga_C (100, false); end; { AVEC/sans inversion vido }

   Type
      Direction         = (Portrait, Paysage);

   Procedure Orientation (Dir : Direction);
      Begin
         Case Dir of
            Portrait : Envoie (Esc+'&l0O', nport);
            Paysage  : Envoie (Esc+'&l1O', nport);
         end;
      end;

   Procedure LstXY (X, Y : Word);
      Var
         X0, Y0         : String [4];

      Begin
         Str (X, X0);
         Str (Y, Y0);
         Envoie (Esc+'*b'+X0+'x'+Y0+'Y', nport)
      end;

   procedure Resolution (X : Word);
      Var
         Ch             : string [3];

      Begin
         Str (X, Ch);
         Envoie (Esc+'*t'+Ch+'R', nport);
      end;

   procedure LstReset;
      Begin
         Envoie (Esc+'E'+Esc+'9', nport) ;
      end;

   {procedure Imprime_Vga_C (Resol: Word; Inverse : Boolean);}
   Const
      GraphMemeOrientation = Esc+'*r0F';
      GraphDepart          = Esc+'*r1A';
      GraphFin             = Esc+'*rbC';

   Var
      ModeVideo         : Byte;
      X, Y              : Word;
      Registres         : Registers;
      Offset            : Word;
      Octet             : byte;
      varbidon          : byte;

   Begin
{      varbidon := mem[$0040:$0008];
      mem[$0040:$0008] := mem[$0040:$000A];
      mem[$0040:$000A] := varbidon;}
      Registres.AH := $0F;
      Intr ($10, Registres);
      ModeVideo := Registres.AL;
      If not (modeVideo in [$10, $12])
      then Write (#7)
      else begin
         PortW [Port_Vga] := $0805;
         PortW [Port_Vga] := $0002;            { mode NB ? }
         PortW [Port_Vga] := $0F07;
         {LstReset;}
         Orientation (Portrait);
{         Case Resol of
            300 : LstXY (850,0);
            150 : LstXY (530,0);
            100 : LstXY (210,0);
            else begin
               Resol := 150;
               LstXY (530, 0)
            end;
         end;
         Resolution (Resol);}
         Resolution (100) ; LstXY (210, 0);
         Envoie (GraphMemeOrientation, nport);
         Envoie (GraphDepart, nport);
         For y := MinLig to MaxLig
         do begin
            Envoie (Esc+'*b80W', nport);
            For X := MinCol div 8 to MaxCol Div 8
            do begin
               Offset := Y*80+X;
{               Envoie(chr(Mem [$A000:Offset]));}
               If Inverse
               then Octet :=      Mem [$A000:Offset]
               else Octet := Not (Mem [$A000:Offset]);
               Envoie (Chr (Octet), nport)
            end;
            If ArretDemande then exit;
         end;
         Envoie (GraphFin, nport);
         {ejecte;}
      end;
   end;

procedure hardcopy (inverse : boolean; mode : byte;
                    MinLig, MinCol, MaxLig, MaxCol, nport : Integer);
   VAR
      i                 : integer;
      nbpin             : byte;

   FUNCTION ConstruitOctet (x, y : integer) : byte;
      CONST
         Bits           : ARRAY [0..7]
                             OF byte = (128, 64, 32, 16, 8, 4, 2, 1);

      VAR
         b              : byte;
         k              : integer;

      BEGIN
         b := 0;
         FOR k := 0 TO 7
         DO
            IF (GetPixel (x, y + k) = 0) OR (y + k > MAXLIG)
            THEN
               b := b OR Bits [k];
         IF inverse
         THEN
            ConstruitOctet := b
         ELSE
            ConstruitOctet := NOT b;
      END;

    PROCEDURE ImprimeLigne (VAR i : integer);
       VAR
          x, y : integer;

       BEGIN
         IF (mode = 1)
         THEN
            Envoie (chr (27)+'L', nport)
         ELSE
            Envoie (chr (27)+'*'+chr (mode), nport);

         Envoie (chr (lo (MAXCOL-MinCol+1))+ chr (Hi (MAXCOL-MinCol + 1)), nport);

         FOR x := MinCol to MAXCOL
         DO BEGIN
            y := nbpin * i;
            Envoie (chr (ConstruitOctet (x, y)), nport);
            IF (nbpin = 24)
            THEN BEGIN
               Envoie (chr (ConstruitOctet (x, y + 8)), nport);
               Envoie (chr (ConstruitOctet (x, y + 16)), nport);
            END;
         END;
         {IF (mode <> 4) THEN }Envoie (#13+#10, nport);
      END;

   BEGIN
      If Mode=150 {jet d'encre}
      then begin
        Impr_HP550C (inverse, MinLig, MinCol, MaxLig, MaxCol, nport);
        exit
        end;
      IF (mode < 7)
      THEN
         nbpin := 8
      ELSE
         nbpin := 24;

      Envoie (chr (27)+'3'+chr (24), nport); {Interligne = 24/180 inches}

      FOR i:= MinLig TO (MAXLIG+1) DIV nbpin
      DO BEGIN
         ImprimeLigne (i);
         IF ArretDemande THEN exit;
      END;
      Envoie (chr (27)+'2', nport); {6 ligne par inch}
   END;


procedure impvga_9c (nport : integer);
   var
      impreg      : registers;
      octet, plan : word;
      c, i        : integer;
      l           : longint;

   begin
      impreg.dx := nport;
      c := 0;
      impreg.ax := $001B;
      intr  ($17, impreg);
      impreg.ax := $0040;
      intr  ($17, impreg);
                     {boucle sur les lignes}
      repeat
         impreg.ax := $001B;
         intr ($17, impreg);
         impreg.ax := $0041;
         intr ($17, impreg);
         impreg.ax := $0000;
         intr ($17, impreg);
         octet := 0; plan := $0004;
         for i := 0 to 3
         do begin  {4 passages }
            l := 38320;
            impreg.ax := $001B;
            intr ($17, impreg);
            impreg.ax := $002A;
            intr ($17, impreg);
            impreg.ax := $0005; {mode 5}
            intr ($17, impreg);
            impreg.ax := $00E0;
            intr ($17, impreg);
            impreg.ax := $0001;
            intr ($17, impreg);
            repeat
               portw [$03CE] := plan+i*256;      { 1 plan chaque fois}
               octet := mem [$A000:l+c];
               impreg.ax := octet;
               intr ($17, impreg);
               l := l-80;
            until l < 0;
            impreg.ax := $000A;
            intr ($17, impreg);
         end;
         impreg.ax := $001B;
         intr ($17, impreg);
         impreg.ax := $0041;
         intr ($17, impreg);
         impreg.ax := $0008;
         intr ($17, impreg);
         impreg.ax := $000A;
         intr ($17, impreg);
         c := c+1;
         If ArretDemande then exit;
      until c = 80;
      impreg.ax := $001B;
      intr ($17, impreg);
      impreg.ax := $0032;
      intr ($17, impreg);
      impreg.ax := $000A;
      intr ($17, impreg);
   end;

procedure impvga_8 (nport : integer);
   var
      impreg      : registers;
      octet, plan : word;
      c, i        : integer;
      l           : longint;

   begin
      c := 0;
      impreg.dx := nport;
      impreg.ax := $001B;
      intr ($17, impreg);
      impreg.ax := $0040;
      intr ($17, impreg);
      impreg.ax := $001B;
      intr ($17, impreg);
      impreg.ax := $0041;
      intr ($17, impreg);
      impreg.ax := $0008;
      intr ($17, impreg);
      repeat
         l := 38320;
         impreg.ax := $001B;
         intr ($17,impreg);
         impreg.ax := $002A;
         intr ($17,impreg);
         impreg.ax := $0000; {mode 0 pour lq500}
         intr ($17, impreg);
         impreg.ax := $00E0;
         intr ($17, impreg);
         impreg.ax := $0001;
         intr ($17, impreg);
         repeat
            octet := 0; plan := $0004;
            for i := 0 to 3
            do begin
               portw [$03CE] := plan+i*256;
               octet := octet or mem [$A000:l+c];
            end;
            impreg.ax := octet;
            intr ($17, impreg);
            l := l-80;
         until l < 0;
         impreg.ax := $000A;
         intr ($17, impreg);
         c := c+1;
         If ArretDemande then exit;
      until c=80;
      impreg.ax := $001B;
      intr ($17, impreg);
      impreg.ax := $0032;
      intr ($17, impreg);
   end;

procedure impvga_8c (nport : integer);
   var
      impreg            : registers;
      octet, plan       : word;
      c, i              : integer;
      l                 : longint;

   begin
      c := 0;
      impreg.dx := nport;
      impreg.ax := $001B;
      intr ($17, impreg);
      impreg.ax := $0040;
      intr ($17, impreg);
                        {boucle sur les lignes}
      repeat
         impreg.ax := $001B;
         intr ($17, impreg);
         impreg.ax := $0041;
         intr ($17, impreg);
         impreg.ax := $0000;
         intr ($17, impreg);
         octet := 0; plan := $0004;
         for i := 0 to 3
         do begin  {4 passages }
            l := 38320;
            impreg.ax := $001B;
            intr ($17, impreg);
            impreg.ax := $002A;
            intr ($17, impreg);
            impreg.ax := $0000; {mode 0 pour lq500}
            intr ($17, impreg);
            impreg.ax := $00E0;
            intr ($17, impreg);
            impreg.ax := $0001;
            intr ($17, impreg);
            repeat
               portw [$03CE] := plan+i*256;      { 1 plan chaque fois}
               octet :=mem [$A000:l+c];
               impreg.ax := octet;
               intr ($17, impreg);
               l := l-80;
            until l < 0;
            impreg.ax := $000A;
            intr ($17, impreg);
         end;
         impreg.ax := $001B;
         intr ($17, impreg);
         impreg.ax := $0041;
         intr ($17, impreg);
         impreg.ax := $0008;
         intr ($17, impreg);
         impreg.ax := $000A;
         intr ($17, impreg);
         c := c+1;
         If ArretDemande then exit;
      until c=80;
      impreg.ax := $001B;
      intr ($17,impreg);
      impreg.ax := $0032;
      intr ($17, impreg);
      impreg.ax := $000A;
      intr ($17, impreg);
   end;

procedure impvga_24 (nport : integer);
   var
      impreg            : registers;
      octet, plan       : word;
      c, i, k           : integer;
      l                 : longint;

   begin
      c := 0;
      impreg.dx := nport;
      impreg.ax := $001B;
      intr ($17, impreg);
      impreg.ax := $0040; {initialise         }
      intr ($17, impreg);
      impreg.ax := $001B;
      intr ($17, impreg);
      impreg.ax := $0033; {avance en n/180  " }
      intr ($17, impreg);
      impreg.ax := $0018; { n= 24             }
      intr ($17, impreg);
      repeat
         l := 38320;
         impreg.ax := $001B;
         intr ($17, impreg);
         impreg.ax := $002A; { *              }
         intr ($17, impreg);
         impreg.ax := $0027;
             {mode 39 -> 24 aiguilles triple densit pour lq500}
         intr ($17, impreg);
         impreg.ax := $00E0; { 480 colonnes   }
         intr ($17, impreg);
         impreg.ax := $0001;
         intr ($17, impreg);
         repeat
            for k := 0 to 2
            do begin
               octet := 0; plan := $0004;
               for i := 0 to 3
               do begin
                  portw [$03CE] := plan+i*256;
                  octet := mem [$A000:l+c+k];
               end;
               impreg.ax := octet;
               intr ($17, impreg);
            end;
            l := l-80;
         until l < 0;
         impreg.ax := $000A;
         intr ($17, impreg);
         c := c+3;
         If ArretDemande then exit;
      until c > 78;
      impreg.ax := $001B;
      intr ($17, impreg);
      impreg.ax := $0032;
      intr ($17, impreg);
   end;

procedure impvga_8c1 (nport : integer);
   var
      impreg            : registers;
      octet, plan       : word;
      c, i, k           : integer;
      l                 : longint;

   begin
      c := 0;
      impreg.dx := nport;
      impreg.ax := $001B;
      intr ($17, impreg);
      impreg.ax := $0040; {initialise         }
      intr ($17, impreg);
      impreg.ax := $001B;
      intr ($17, impreg);
      impreg.ax := $0041; {avance en n/60  " }
      intr ($17, impreg);
      impreg.ax := $0008; { n= 8             }
      intr ($17, impreg);
      repeat
         l := 38320;
         impreg.ax := $001B;
         intr ($17, impreg);
         impreg.ax := $002A; { *              }
         intr ($17, impreg);
         impreg.ax := $0003;
             {mode 3 -> 8 aiguilles quadruple densit pour lq500}
         intr ($17, impreg);
         impreg.ax := $0080; { 480 colonnes * 4=1920   }
         intr ($17, impreg);
         impreg.ax := $0007;
         intr ($17, impreg);
         repeat
            octet :=0; plan := $0004;
            for i := 0 to 3
            do begin
               portw [$03CE] := plan+i*256;
               octet := mem [$A000:l+c];
               impreg.ax := octet;
               intr ($17, impreg);
            end;
            l := l-80;
         until l < 0;
         impreg.ax := $000A;
         intr ($17, impreg);
         c := c+1;
         If ArretDemande then exit;
      until c > 79;
      impreg.ax := $001B;
      intr ($17, impreg);
      impreg.ax := $0032;
      intr ($17, impreg);
   end;

procedure SauvePCX (xg, yh, xd, yb : word; nom : string);
   {------------------------------------------------------------------------}
   { ROLE  Enregistrer une image au format PCX                              }
   {------------------------------------------------------------------------}
   var
      f                    {}
                        : text;
      Plan, i              {}
                        : word;

      d, d1,               {}
      octet             : byte;
      nump,                {}
      ro, ve, bl,          {}
      k, v,                {}
      c, nbp, n, j,        {}
      n1, n2, n3, n4,
      xi, xf,
      tx, ty
                        : integer;
      l                    {}
                        : word;
      deb               : boolean;

   begin
      assign (f, Nom);
      rewrite (f);

      xg := xg - xg mod 8;
      xd := xd + (7- xd mod 8);
      xi := integer (xg div 8);
      xf := integer (xd div 8);
                               {* ENTETE DU PCX }
      ty := (yb-yh+1)                   {480};
      tx := (xd div 8) - (xg div 8) + 1 {80};
      nbp:= 4;

      n1 := (xd-xg)  div 256;
      n2 := (xd-xg) - n1*256;
      n3 := (yb-yh)  div 256;
      n4 := (yb-yh) - n3*256;

      write (f, chr(10),  chr(5),  chr(1),   chr(1),
                chr(0),   chr(0),  chr(0),   chr(0),
                chr(n2),  chr(n1), chr(n4),  chr(n3),
                chr(180), chr(0),  chr(180), chr(0));                 { 1..16}

      for n := 0 to 15
      do begin                                      {17..64}
         getrgbpalette (n, ro, ve, bl);
         ro := round (255 * ro / 63);
         ve := round (255 * ve / 63);
         bl := round (255 * bl / 63);
         write (f, chr(ro), chr(ve), chr(bl));
      end;
      write (f, chr(0),   chr(nbp), chr(80),  chr(0),
                chr(255), chr(255), chr(176), chr(1),
                chr(0),   chr(0),   chr(0),   chr(0),
                chr(0),   chr(0),   chr(0),   chr(0));
                                                                     {65..80}
      {* }
      Plan := $0004; {}
      for l := yh to yb
      do begin
         d := 0;
         for i := 0 to 3
         do begin
            deb := true;
            d1 := 255;
            k  := 1;
            portw[$03CE] := plan + i*256;

            for c := xi to xf
            do begin
               d := mem[$A000:(l*80)+c];
               {* Laisser en noir si y < 80 }
               { if l div 80 < 80 then d := 0; }
               if not deb and (d=d1) then inc (k);
               if ((d <> d1) or (k = 64)) and (not deb) {d1 <> 256}
               then begin
                  if k=1
                  then begin
                     if d1 < 192
                     then write (f, chr (d1))
                     else write (f, chr (193), chr (d1));
                  end else begin
                     if k=64 then k:=63;
                     write (f, chr (192+k), chr (d1));
                     k := 1;
                  end
               end;
               d1 := d;
               deb := false;
            end;

            if k=1
            then begin
               if d1 < 192
               then write (f, chr (d1))
               else write (f, chr (193), chr (d1));
            end else begin
               if k=64 then k := 63;
               write (f, chr (192+k), chr (d1));
               k := 1;
            end;
            if odd (tx)
            then begin
               write (j, chr (0));
            end
         end;
      end;

      close (f);
   end;

END.

{---- IMPRIM ---------------------------------------------------------------}
