{ menu6 }

   {------------------------------------------------------------------------}
   {    MENUP                                                               }
   {              interface graphique  menus droulants                    }
   {                                                            03/05/91    }
   {------------------------------------------------------------------------}

procedure cree_boite (nomf : Pathstr ; var lg, pos : integer);
                     { rend la largeur et la hauteur du texte}
   var
      ftxt              : Text;
      tch               : string;
      ok                : boolean;

   begin
      pos := 1;
      lg  := 0;
      assign       (ftxt, nomf);
      resetTxtErr  (ftxt, nomf, ok);
      while (not (eof (ftxt))) and (pos < maxliste)
      do begin
         readln (ftxt, tch);
         if length (tch) > lg
         then
            lg := length (tch);
         listchaine^[pos] := tch;
         inc    (pos);
      end;
      listchaine^[pos] := '';
      pos := pos-1;
      close (ftxt);
   end;

procedure affich (h, lx, ly, mxx, mxy, x0, y0, nx, ny : integer);
   { position de dpart pour l'affichage : x0, y0 et nx, ny,
     longueur du texte                     y
     dimensions de la fentre texte        lx, ly et mxx, mxy
                             entte :      h                      }
   var
      debx, deby, i     : integer;

   begin
      debx := nx;
      deby := ny;
      setcolor        (c_t_boite_norm );
      setfillstyle (1, c_f_boite_norm );
      i := deby;
      bar (x0+2, y0+h+2, x0+lx-2, y0+ly-2);
      repeat
         {        dx = 6, dy = 6 }
         outtextxy (x0  +6,
                    y0 + h + 2 + (i-deby) * ty,
                    copy (listchaine^ [i], debx, mxx));
         inc (i);
      until (i >= deby+mxy);
   end;

procedure affiche_entete (titre : longchaine; x0, y0, lx, h : integer);
   begin
      setcolor           (c_t_boite_inve);
      setfillstyle (1,  {c_f_boite_inve );} c_t_boite_norm);
                           { menu }              { modules }
      bar             (x0+3,                 y0+3,    x0+lx-3, y0+h-3);
      settextjustify  (1, 1);
      outtextxy       (x0+h +((lx-h) div 2), y0+(h div 2), titre);

      rectangle       (x0+4,                 y0+4,    x0+h-4,  y0+h-4);
      { bouton fermeture }
      setfillstyle    (0, c_t_boite_inve);
      settextjustify  (0, 2);
   end;

procedure bte_compl  (titre                      : chainecar;
                      x0, y0, x, y, mxx, mxy     : integer );

   { boite complte -  1 ligne = titre si non vide
                    -  position initiale du coin sup g de la bote,
                    -  dimensions du texte
                    -  dimensions de la fenetre          }

   var
      p                             : pointer;
      dx, dy, lx, ly,
      bx, by, xok, yok,
      taillep                       : word;
      Touche,
      nx, ny, h, hb,
      xx, yy, supx, supy            : integer;
      chaine                        : string;
      centre, entet, confirm,
      asc_v, asc_h, reaffiche       : boolean;

   procedure affiche_bouton;
      begin
         rectangle (x0+xok,       y0+yok,  x0+xok+bx, y0+yok+by);
         settextjustify (1, 1);
         outtextxy (x0+xok+bx div 2, y0+yok+by div 2, 'OK');
         settextjustify (0, 2);
      end;

   function bouton_ok : boolean;
      begin
         bouton_ok :=
                   (xs > x0+xok) and (xs < x0+xok+bx)
               and (ys > y0+yok) and (ys < y0+yok+by);
      end;

   function bouton_fermeture : boolean;
      begin
         bouton_fermeture :=
               (xs > x0+4)   and (ys > y0+4)
           and (xs < x0+h-4) and (ys < y0+h-4)
           or d;
      end;

   begin
      memok   := true;
      confirm := false;   { pas utilis dans cette version }
      asc_v   := false;
      asc_h   := false;
      supx    := 0;
      supy    := 0;
      nouveau_style   (0, 0, 1);

      if mxx <= 0  then mxx := x;
      if mxy <= 0  then mxy := y;

      if y <= mxy
      then
         mxy   := y
      else begin
         supx  := 2*tx;
         asc_v := true
      end;

      if x <= mxx
      then
         mxx   := x
      else begin
         supy  := 2*tx;
         asc_h := true
      end;

      h     :=  0; { hauteur du titre }
      hb    :=  0; { hauteur libre pour les boutons intrieurs }
      ty    := 12;
      dx    :=  6;
      dy    :=  ty div 2;
      entet := titre <> '';
      if entet
      then
         h  := 2*dy + ty;

      lx    := mxx*tx + dx*2;
      if (posxbtn > 0) and (lx+supx > posxbtn)
      then begin
         lx       := posxbtn-1;
         mxx      := (lx -supx - dx*2) div tx;
         if x > mxx                 { si ncessaire }
         then begin
            supy  := 2*tx;
            asc_h := true
         end;
      end;

      ly   := mxy*ty {+ dy*2} + h;
      if confirm
      then begin
         bx  := 2 * (2*dx +tx);
         by  := 2 * dy + ty;
         hb  := by + dy;
         xok := (lx-bx) div 2;
         yok := ly-by-dy+hb;
      end;

      if (x0 < 0) or (y0 < 0)
      then
         if (POSXBTN = 0)
         then begin
            x0 := (maxx-lx-supx)    div 2;
            y0 := (maxy-ly-supy-hb) div 2;
         end else begin
            x0 := (posxbtn-lx-supx) div 2;
            y0 := (maxy-ly-supy-hb) div 2;
         end;

      taillep := imagesize (0, 0, lx+supx, ly+supy+hb);
      if (taillep < maxavail) and (taillep < maximage)
      then begin
         taillep := imagesize (0, 0, lx+supx, ly+supy+hb);
         getmem (p, taillep);

         ny := 1;
         nx := 1;
         repeat
            reaffiche := false;
            getimage  (x0,    y0,       x0+lx+supx, y0+ly+supy+hb, p^);
            setcolor        (c_t_boite_norm );
            setfillstyle (1, c_f_boite_norm );
            bar       (x0,    y0,       x0+lx,      y0+ly+hb);

            if asc_v
            then
               bar    (x0+lx, y0,       x0+lx+supx, y0+ly+hb);

            if asc_h
            then
               bar    (x0,   y0+ly+hb,  x0+lx,      y0+ly+hb+supy);

            rectangle (x0+1, y0+1,      x0+lx-1,    y0+ly+hb-1);

            if entet
            then
               affiche_entete (titre, x0, y0, lx, h);

            if asc_v
            then
               affiche_ascenseur_v (1, y-mxy+1, x0+lx-1, y0+1, ly+hb-2, -1, ny);
            if asc_h
            then
               affiche_ascenseur_h (1, x-mxx+1, x0+1, y0+ly+hb-1, lx-2, -1, nx);

            affich (h, lx, ly, mxx, mxy, x0, y0, nx, ny);

            if confirm
            then
               affiche_bouton;
            xx := x0;
            yy := y0;
            repeat
               if asc_v
               then
                  ascenseur_v (1, y-mxy+1, x0+lx-1, y0+1, ly+hb-2, -1, ny, Touche);

               if asc_h
               then
                  ascenseur_h (1, x-mxx+1, x0+1, y0+ly+hb-1, lx-2, -1, nx, Touche);

               if (not asc_h) and (not asc_v)
               then begin
                  MontrerSouris;
                  clavsouris (Touche);
                  LirePositionSouris (xs, ys);
                  CacherSouris;
               end;

               affich (h, lx, ly, mxx, mxy, x0, y0, nx, ny);

               if     (xs > x0+h) and (xs < x0+lx)
                  and (ys > y0)   and (ys < y0+2*ty) and (not d)
               then begin
                  dep_rec (xx, yy, lx+supx, ly+supy+hb);
                  LirePositionSouris (xs, ys);
                  reaffiche := true;
                  g := BoutonSourisEnfonce (BoutonGauche);
                  d := BoutonSourisEnfonce (BoutonDroit);
               end;
               if confirm then d := bouton_ok;
               if entet   then d := bouton_fermeture;
            until d or reaffiche;

            putimage (x0, y0, p^, 0);
            x0 := xx;
            y0 := yy;
         until not reaffiche;
         putimage (x0, y0, p^, 0);
         libere   (p);
      end else
         memok := false;
      ancien_style;
   end;

procedure boitinfo (texte : chainecar; x, y, mxx, mxy : integer);
         { titre de la bote  dfilement H et V,
           dimensions du texte,
           dimensions maxi de la fentre sur le texte en "caractres"}

   begin
      bte_compl  (texte, -1, -1, x, y, mxx, mxy);
                       { centr obligatoirement }
   end;

procedure boitep (x0, y0, lx, ly ,nbc, nbl : integer; confirm : boolean);
   { boite simple -  position de la bote, dimensions et nb de lignes   }

   var
      p                 : pointer;
      Touche,
      taillep, dx, dy   : integer;

   procedure affb;
      var
         i              : integer;

      begin
         i := 1;
         repeat
            outtextxy (x0+dx, y0+dy+i*ty, copy (listchaine^[i], 1, nbc));
            inc (i);
         until i = nbl;
      end;

   begin
      dx := 4;
      dy := 1;
      setfillstyle  (1, c_f_boite_norm);
      nouveau_style (0, 0, 1);
      taillep := imagesize (0, 0, lx, ly);
      getmem    (p, taillep);
      getimage  (x0,   y0,   x0+lx,   y0+ly, p^);
      setcolor        (c_t_boite_norm );
      setfillstyle (0, c_f_boite_norm );
      bar       (x0,   y0,   x0+lx,   y0+ly);
      rectangle (x0+1, y0+1, x0+lx-1, y0+ly-1);
      affb;
      if confirm
      then
         ClavSouris (Touche);
      putimage (x0, y0, p^, 0);
      libere   (p);
{      efface_boite (x0, y0, p);}
      ancien_style;
   end;

procedure boite_aide (nomf        : Pathstr;
                      index       : integer;
                      var lg, pos : integer;
                      var titre   : chainecar);
                     { rend la largeur et la hauteur du texte}
   var
      tch               : string;
      ftxt              : text;
      prem              : char;

   begin
      pos   := 0;
      assign (ftxt, nomf);
      reset  (ftxt);
      while pos < index
      do begin
         readln (ftxt, tch);                   { lignes avant index }
         inc (pos)
      end;
      titre := souschaine (tch,']','');   { fin de la ligne indexe }
      lg    := 0;
      readln (ftxt, tch);                      { ligne suivante  }
      if tch = ''
      then
         tch := ' ';
      prem  := tch [1];
      pos   := 1;
      while (not (eof (ftxt))) and (pos < maxliste) and (prem <> '[')
      do begin
         if length (tch) > lg
         then
            lg := length (tch);
         listchaine^[pos] := tch;
         readln (ftxt, tch);
         if tch = ''
         then
            tch := ' ';
         prem := tch [1];
         inc (pos);
      end;
      listchaine^[pos] := '';
      pos := pos -1;
      close (ftxt);
   end;

procedure initaide (nomf : Pathstr; var ok : boolean);
   var
      i, j, pos, err      : integer;
      ftxt                : Text;
      ch, numx, numy      : string;
      prem                : char;

   begin
      ok := false;
      for i := 1 to nbboites
      do
         for j := 1 to nboptions-1
         do
             index_aide^ [i, j] := 0;

      if (not ftxt_present (nomf))
      then
         exit;
      ok := true;
      assign (ftxt, nomf);
      reset  (ftxt);

      pos := 0;
      i   := 0;
      j   := 0;

      while not (eof (ftxt))
      do begin
         readln (ftxt, ch);
         if ch = ''
         then
            ch := ' ';
         prem := ch [1];
         inc (pos);
         while (prem <> '[') and (not (eof (ftxt)))
         do begin
            readln (ftxt,ch);
            if ch = ''
            then
               ch := ' ';
            prem := ch [1];
            inc (pos);
         end;
         if not eof (ftxt)
         then begin
            numx := souschaine (ch, '[', ' ');
            numy := souschaine (ch, ' ', ']');
            val (numx, i, err);
            val (numy, j, err);
            index_aide^ [i, j] := pos
         end
      end;
      close (ftxt);
   end;

procedure aff_aide (nomf : Pathstr; i, j : integer);
   var
      titre         : chainecar;
      index, lg, ht : integer;

   begin
      if (i < 1) or (j < 1) or (i > nbboites) or (j > nboptions)
      then
         exit;

      index   := index_aide^ [i, j];

      if index = 0
      then
         exit;

      laide ('Taper ESC ou Bouton Droit pour continuer ');
      boite_aide (nomf, index, lg, ht, titre );
      {      boitinfo3  (titre_aide, lg, ht, lg, 10 );}

      bte_compl  (titre, -1, -1, lg, ht, 0, 15);
      laide ('');
   end;

procedure bte_simple (titre            : chainecar;
                      x0, y0, nbc, nbl : integer ;
                      confirm          : boolean;
                      var       p      : pointer );

   { boite simple sans dfilement
                   -  ligne 1 = titre si non vide
                   -  position du coin sup g de la bote,
                   -  nb de lignes
                   -  confirm = bouton ok                        }

   var
      centre, entet         : boolean;
      Touche,
      taillep, h,
      dx, dy, lx, ly,
      bx, by, xok, yok      : integer;

   function bouton_ok : boolean;
      begin
         bouton_ok :=
                   (xs > x0+xok)       and (xs < x0+xok+bx)
               and (ys > y0+ly-yok+dy) and (ys < y0+ly-dy);
      end;

   procedure affiche_texte ( i : integer);
      begin
         repeat
            outtextxy (x0+dx, y0+h+dy+ (i-1)*ty,
                       copy (listchaine^[i], 1, nbc));
            inc (i);
         until i = nbl;
      end;

   begin
      nouveau_style (0, 0, 1);
      h   :=  0;
      ty  := 12;
      dx  :=  6;
      dy  :=  6;
      entet := length (titre) > 0;
      if entet
      then
         h := 2*dy + ty;
      lx  := nbc*tx + dx*2;
      ly  := nbl*ty + dy*2 + h;
      if confirm
      then begin
         bx  := 2 * (2*dx +tx);
         by  := 2*dy + ty;
         ly  := ly + by + 2*dy;
         xok := (lx-bx) div 2;
         yok :=  ly-by-dy;
      end;
      if (x0 < 0) or (y0 < 0)
      then
         if posxbtn=0
         then begin
            x0 := (maxx-lx) div 2;
            y0 := (maxy-ly) div 2;
         end else begin
            x0 := (posxbtn-lx) div 2;
            y0 := (maxy-ly) div 2;
         end;
      taillep := imagesize (0, 0, lx, ly);
      getmem    (p, taillep);
      getimage  (x0,   y0,   x0+lx,   y0+ly, p^);
      setcolor        (c_t_boite_norm {colord});
      setfillstyle (1, c_f_boite_norm {colorf});
      bar       (x0,   y0,   x0+lx,   y0+ly);
      rectangle (x0+1, y0+1, x0+lx-1, y0+ly-1);
      if entet
      then begin
         setcolor        (c_t_boite_inve{colorf});
         setfillstyle (1, c_f_boite_inve{colord});
         bar       (x0+3,    y0+3,    x0+lx-3, y0+h-1);
         outtextxy (x0+dx+3, y0+dy+3, copy (titre, 2, nbc));
         setcolor        (c_t_boite_norm {colord});
         setfillstyle (0, c_f_boite_norm {colorf});
      end;
      if confirm
      then begin
         rectangle (x0+xok,       y0+yok,       x0+xok+bx, y0+yok+by);
         outtextxy (x0+xok+dx+dx, y0+yok+dy, 'OK');
      end;

      affiche_texte (1);

      if confirm
      then begin
         MontrerSouris;
         ClavSouris (Touche);
         CacherSouris;
      end else
         ClavSouris (Touche);
      ancien_style;
   end;

{---- MENU6 ----------------------------------------------------------------}
