UNIT MENU_FIC;

   {------------------------------------------------------------------------}
   { logiciel GEOCEAN - modules MENU/CONF/INST                              }
   {                                                                        }
   {                       procdures communes                              }
   {                                                       10/10/94         }
   {------------------------------------------------------------------------}

   (*
   MENU_FIC,                 { MENU    - Initialisations fichiers           }
   *)

INTERFACE

{$O+,F+}

USES
   dos,
   crt,
   graph,                    { TP 70   - units standard Borland            }

   souris,                   { ARX     - gestion de la souris               }
   Graphism,                 { ARX     - initialisations graphiques         }
   Utildivs,                 { ARX     - utilitaires divers                 }
   Icones,                   { ARX     - gestion de icnes                  }
   Graphplt,                 { ARX     - graphisme 2D cran/traceur         }
   Utiledi,                  { ARX     - utilitaires dition                }
   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   Lipar,                    { ARX     - gestion fichiers paramtres        }
   Periphs,                  { ARX     - priphriques, impression, palettes}
   Menus,                    { ARX     - interface menus                    }
   Csi,                      { ARX     - Clavier Souris Icnes              }

   MENU_var;                 { MENU    - variables globales du module       }

{---------------------------------------------------------------------------}
Procedure cadrer;
   { Dfinir la clture                                                     }

Procedure affiche_image;
   { Affiche la carte des fonds ocaniques .IMA                             }

Procedure inimenus_conf;
   { Menus propres au programme de configuration                            }

Procedure inimenus_prof;
   { Menus ALT P et ARX                                                     }

Procedure inimenus_menu;
   { Menus propres  l'interface MENU                                       }

Procedure nouv_bte2;
   { Cre un pointeur pour la liste  Boite2 : liste des rgions /menu       }

Procedure nouv_bte3;
   { Cre un pointeur pour la liste  Boite3 : liste des modules /menu       }

Procedure lire_menus ;
   { Initialise les tableaux menus  partir des listes                      }

Procedure def_icones_modules    (nbi  : integer);
   { Initialise les zones sensibles pour les programmes                     }

Procedure dess_icones_modules   (nbi  : integer);
   { Affichage des icnes reprsentant les modules                          }

Procedure def_icones_region     (nbi  : integer);
   { Initialise les zones sensibles pour les donnes                        }

Procedure dess_icones_region    (nbi  : integer);
   { Affichage des cadres reprsentant les rgions                          }

Procedure dess_icones;
   { Affichage de toutes les icnes                                         }

Procedure def_icones;
   { Dclaration des zones sensibles                                        }

Procedure choix_region          (ndon : integer);
   { Actualise la variable rgion et dsactive certains modules             }

Procedure choix_activite        (nact : integer) ;
   { Actualise la variable prog                                             }

Procedure ini_par_cfg         (nomf : pathstr);
   { Initialise les paramtres lus dans  \geoc_prg\fic.CFG                  }

Procedure ini_par_trv         (nomf : pathstr);
   { Initialise les paramtres lus dans fic.MNU                             }

Procedure iniecran;
   { Initialise l'tat de l'cran en fonction du fichier param par dfaut   }

Procedure choix_reg_act;
   { Initialise rgion et activit                                          }

Procedure identifier_util;
   { comparer util et liste --Groupe ou individu                            }

Function groupexist            (groupe : namestr) : boolean;
   { teste l'existence du GROUPE dans la liste en mmoire                   }

Procedure aff_l_aide;
   { Affiche une ligne d'aide standard                                      }

Procedure VERSION_LOGICIEL;
   { ARX                                                                    }

Procedure aide_geoc;
   { affiche le texte d'aide GEOCEAN                                        }

Procedure aide_mnu;
   { affiche le texte d'aide MENU                                           }

Procedure aide_region         (numreg   : integer);
   { affiche le texte de l'aide sur la rgion                               }

Procedure aide_module         (nummod   : integer);
   { affiche le texte de l'aide sur le programme                            }

Procedure aide                (x, y     : integer);
   { affiche le texte d'aide correspondant.                                 }

Procedure A_PROPOS;
   { affiche nom programme, date, version et noms des auteurs               }

Procedure A_PROPOS2 ;
   { refrences diteur                                                     }

Procedure ref_image ;
   { rfrences image du fond                                               }

Procedure infos_systeme;
   { affiche infos diverses                                                 }

Procedure AIDE_MENUS_b;
   { aide botes                                                            }

Procedure info_misaj;
   { affiche contenu fichier AID                                            }

Procedure info_cfg;
   { affiche contenu fichier AID                                            }

Procedure impr_params         (t    : chainecar; l : lipar.liste);
   { imprime une liste complte de paramtres avec la date et le texte T    }

Procedure voir_penv           (nomf : namestr);
   { affiche les paramtres de ConFiGuration  dans une bote  dfilement   }

Procedure voir_ptrav          (nomf : namestr);
   { affiche les paramtres du MENU dans une bote  dfilement             }

Procedure lire_config         (nomf : pathstr);
   { charge les paramtres d'un fichier de configuration                    }

Procedure ecrire_config       (nomf : pathstr);
   { enregistre les paramtres d'un fichier de configuration                }

Procedure ini_par_ecr;
   { initialise les paramtres de l'cran                                   }

Procedure modif_menus;
   { modifie le texte des menus en fonction des paramtres initiaux         }

Procedure inimenus;
   { initialise les paramtres de l'interface MENUS.                        }

Procedure inversemenus;
   { inverse MENUS LONGS/COURTS                                             }

Procedure iniaide;
   { initialise les paramtres du fichier d'aide.                           }

Procedure ini_par_ins          (nomf      : pathstr);
   { initialise les paramtres de l'installation                            }

Procedure ecr_par_ins          (nomf      : pathstr);
   { enregistre les paramtres de l'installation                            }

Procedure libere_mem;
   { libre les listes diverses                                             }

Procedure quitter              (f         : boolean);
   { demander confirmation avant de stopper l'excution                     }

Function liste_repert          (nomf      : pathstr) : lst_chn ;
   { rend la liste des rpertoires existants                                }

Procedure inserer_nouv_entree_bte (n_bte, bte          : lst_chn ;
                                   li                  : integer);
   { insre une ligne donnes dans BTE en positon li
     var globales modifies : BOITE2/BOITE3                                 }

Procedure lire_par_region (nomf : pathstr ; var n_reg  : lst_chn);
Procedure lire_par_module (nomf : pathstr ; var n_mod : lst_chn);
   { lit un fichier .MN0 : desciption d'une entre au menu                  }

{---------------------------------------------------------------------------}

IMPLEMENTATION

var
   dx, dy               : integer;

   u_grp, r_grp        { unit et rpertoire collectif (sans le groupe)     }
                        : dirstr;

function liste_repert   (nomf : pathstr) : lst_chn ;
   var
      l                 : lst_chn;
      F                 : searchrec;
      nb                : integer;

   begin
      FindFirst (nomf, ReadOnly + Hidden + directory, F);
      nb := 0;
      FindNext (F);
      FindNext (F);
      l := nil;
      WHILE (DosError <> 2) AND (DosError <> 18)
                            AND (nb < Maxliste)
      DO BEGIN
         ajouter_nom_chaine (l, F.name);
         inc      (nb);
         FindNext (F);
      END;
      liste_repert := l;
   end;


procedure iniaide;
   begin
      initaide (ch_mnu+nommenu + exthlp, ok);                       { menus6 }
   end;

procedure inimenus;
   begin
      ini_menu      (repbgi, pol_menu);                             { menus }
     { posxbtn  := 540;}
      chargepalette (ch_mnu+nommenu+extpal, ok);             { graphism }
      setcoulmenu   ( 15 ,      0,        4,      7,
                        0,      8,       14,      6);
                            { 11 jaune   14 bleuVert ple }
   end;

procedure modif_menus;
   { en fonction de la liste des autorisations dans MENU.mnu }
   var
      i                 : integer;

   begin
      if tousperso
      then begin
         if echanges
         then
            textemenu (1,  9, coche+' '+txt_mnu19, txt_mnu19a)
         else
            textemenu (1,  9,      '  '+txt_mnu19, txt_mnu19b);

         if ch_ech <> ''
         then begin
            active (1, 9, true);
         end else
            active (1, 9, false);
      end else begin
         { on peut grer les utilisateurs }
      end;

      if nomdumodule  = nomconf
      then begin
         if ndonnees > 0
         then
            active (4, 7, true)
         else
            active (4, 7, false);

         if nactivite > 0
         then
            active (4, 8, true)
         else
            active (4, 8, false);
      end;

      if prof and (ndonnees > 0)
      then
         for i := 1 to nboptions-1
         do
            active (1, i+1, true)
      else
         for i := 1 to nboptions-1
         do
            active (1, i+1, menu_autorise [i]);

      if prof or menu_autorise [7]
      then
         if exempl
         then begin
            textemenu (1,  7, coche+' '+txt_mnu17, txt_mnu17a);
            active (1, 3, false);
         end else begin
            textemenu (1,  7,      '  '+txt_mnu17, txt_mnu17b);
            active (1, 3, true);
         end;

      if ch_xpl = ''
      then
         active (1, 7, false);

      if ndonnees < 1                      { dsactiver RESUME }
      then
         active (1, 3, false);
   end;

procedure ini_par_ecr;
   begin
      maxc1        := 4;                     { extension maxi clture }
      maxc2        := maxx-4;                { posxbtn-2; }
      maxc3        := hicop+ ty+ 3;          { 2*ty+2 ;   }
      maxc4        := maxy -hauteurmenu;     { -ty div 2;  }
   end;

procedure VERSION_LOGICIEL;
   begin
      message (rc);
   end;

procedure affiche_image;
   var
      p1, p2, p3,
      p4, p5, p6        : pointer;
      t                 : boolean;
      lg, ht,
      px, py            : integer;

   begin
      lg := 211;       { largeur 1/3 }
      ht := 194;       { hauteur 1/2 }
      py := maxy-maxc4 { hauteurmenu };
      px := maxc1;
      loadimage    (ch_mnu+'ocean16.ima',   p1, t);
      loadimage    (ch_mnu+'ocean26.ima',   p2, t);
      loadimage    (ch_mnu+'ocean36.ima',   p3, t);
      loadimage    (ch_mnu+'ocean46.ima',   p4, t);
      loadimage    (ch_mnu+'ocean56.ima',   p5, t);
      loadimage    (ch_mnu+'ocean66.ima',   p6, t);
      if t
      then begin
         putimage     (px,       py,    p1^, 0);
         putimage     (px+lg,    py,    p2^, 0);
         putimage     (px+lg+lg, py,    p3^, 0);
         putimage     (px,       py+ht, p4^, 0);
         putimage     (px+lg,    py+ht, p5^, 0);
         putimage     (px+lg+lg, py+ht, p6^, 0);
         libere       (p1);
         libere       (p2);
         libere       (p3);
         libere       (p4);
         libere       (p5);
         libere       (p6);
      end;
      setfillstyle (1, 6);                        { 4 bleu fonc }
     { bar (maxc1, py+2*ht+18, maxc2+1, maxy-ty);}
      bar (maxc1, maxy-maxc3, maxc2+1, maxy-ty);
   end;

procedure cadrer;
   begin
      cc1 := maxc1;
      cc2 := maxc2;
      cc3 := maxc3;
      cc4 := maxc4;
   end;

procedure textemenuaid (x : integer);
   begin
      textemenu (x,  1, txt_mnu61, '');
      textemenu (x,  2, txt_mnu62,  txt_mnu62a );
      textemenu (x,  3, txt_mnu63,  txt_mnu63a );
      textemenu (x,  4, txt_mnu64,  txt_mnu64a );
      textemenu (x,  5, txt_mnu65,  txt_mnu65a + ' ' + nomdumodule + '.');
     { textemenu (x,  6, txt_mnu66,  txt_mnu66a + ' ' + region      + '.');}
      textemenu (x,  6, txt_mnu66,  txt_mnu66a );

      textemenu (x,  8, txt_mnu68,  txt_mnu68a );
      textemenu (x,  9, txt_mnu69,  txt_mnu69a );
   end;

procedure inimenus_conf;
   var
      i                 : integer;

   begin
      textemenu (4,  1, txt_mnu41, '');
      textemenu (4,  2, txt_mnu42, txt_mnu42a);
      textemenu (4,  3, txt_mnu43, txt_mnu43a);
      textemenu (4,  4, txt_mnu44, txt_mnu44a);

      textemenu (4,  6, txt_mnu46, txt_mnu46a);
      textemenu (4,  7, txt_mnu47, txt_mnu47a);
      textemenu (4,  8, txt_mnu48, txt_mnu48a);

      if not tousperso
      then begin
         textemenu (4,  9, txt_mnu49,  txt_mnu49a);
         textemenu (4, 10, txt_mnu410, txt_mnu410a);
         textemenu (4, 11, txt_mnu411, txt_mnu411a);
      end;
         textemenu (4, 12, txt_mnu412, txt_mnu412a);

      textemenu (5,  1, txt_mnu51,  '');
      textemenu (5,  2, txt_mnu52,  txt_mnu52a);
      textemenu (5,  3, txt_mnu53,  txt_mnu53a+' : '+nomfpar+'.');
      textemenu (5,  4, txt_mnu54,  txt_mnu54a);

      textemenu (5,  6, txt_mnu56,  txt_mnu56a);
      textemenu (5,  7, txt_mnu57,  txt_mnu57a+' : '+nomfcfg+'.');
      textemenu (5,  9, txt_mnu59,  txt_mnu59a);
   end;

procedure inimenus_prof;
   var
      i                 : integer;

   begin
      if (maj (nomutil) = 'ARX') and prof
      then begin
         textemenu (1, 12, txt_mnu112, txt_mnu112a);
{         if (nomdumodule = nomconf)
         then
            textemenu (4,  5, txt_mnu45, txt_mnu45a);}
      end;
   end;

procedure inversemenus;
   begin
      prof := not prof;
      if prof
      then
         inimenus_prof
      else begin
         initmenus;                                                { menus1 }
         inimenus_menu;
         if nomdumodule = nomconf
         then
            inimenus_conf;
         lire_menus;
      end;
   end;

procedure inimenus_menu;
   var
      i                 : integer;

   begin
      textemenu (1,  1, txt_mnu11, '');
      textemenu (1,  2, txt_mnu12, txt_mnu12a);
      textemenu (1,  3, txt_mnu13, txt_mnu13a);
      textemenu (1,  4, txt_mnu14, txt_mnu14a);
      textemenu (1,  5, txt_mnu15, txt_mnu15a);
      textemenu (1,  6, txt_mnu16, txt_mnu16a);

      if tousperso
      then
      {   textemenu (1,  8, txt_mnut18, txt_mnut18a)   ch rpert trav perso }
      else
         textemenu (1,  8, txt_mnu18, txt_mnu18a);    { ch utilisateur }

      textemenu (1, 10, txt_mnu110, txt_mnu110a);

      if nomdumodule = nommenu
      then
         textemenuaid (4)
      else
         textemenuaid (6);
   end;

function nb_lign (bte : lst_chn) : integer;
   { rend le nombre d'entres dans la bote }
   begin
      nb_lign := compte_elements (bte);
   end;

procedure menus_bte (bte : lst_chn; numbte : integer );
   var
      p_ct,
      p_mnu,
      p_ico             : lst_chn;

      nomb,
      sousm             : string [MaxChaine]
                           { chaine de tpu\menus ... utildivs} ;

      taide             : longchaine;
      lign3,
      lign4             : namestr;
      xs, ys,
      ls, hs
                        : t12;

      li                : integer;

   procedure ini_menu_prg (li : integer );
      var
         c1             : string [1];
         er,
         n, cn          : integer;

      begin
         for n := 1 to nboptions-1
         do
            menu_prg [li, n] := true;

         if (lign4 [1] <> '0') and (lign4 <> '') { des progr. sont interdits }
         then
            for n := 1 to length (lign4)
            do begin
               c1 := lign4 [n];
               val (c1, cn, er);

               if (menu_pro [cn] = menu_ico [cn])
                  { prg en cours   prg interdit }
               then
                  menu_prg [li, cn] := false;
            end;

         { else : aucun programme interdit }
      end;

   procedure ini_coord_ico (li : integer );
      var
         er,
         x, y, l, h     : integer;

      begin
         val (xs, x, er);
         val (ys, y, er);
         val (ls, l, er);
         val (hs, h, er);
         if numbte = 2
         then begin   { mettre  jour tableau coord icones rgions }
            menu_ico2 [li , 1] := x;
            menu_ico2 [li , 2] := y;
            menu_ico2 [li , 3] := l;
            menu_ico2 [li , 4] := h;
         end else begin    { mettre  jour tableau coord icones programmes }
            menu_ico3 [li , 1] := x;
            menu_ico3 [li , 2] := y;
            menu_ico3 [li , 3] := l;
            menu_ico3 [li , 4] := h;
         end;
      end;

   begin
      if bte = nil then exit;
      li    := 1;
      p_ct  := bte;
      nomb  := p_ct^.nom^;
      p_ct  := p_ct^.suivant;
      textemenu (numbte, li, nomb, '');

      while (p_ct <> nil) and (li < nboptions)
                { rechercher les lments du  1er niveau }
      do begin
         inc (li);                   { 2.. 12    nb maxi  de lignes au menu }
         sousm  := p_ct^.nom^;                           { option sous menu }
         taide  := p_ct^.elements^.nom^;                 { texte aide   ... }
         textemenu (numbte, li, sousm, taide);

         lign3  := p_ct^.elements^.suivant^.nom^;             { nom rgion  }
         lign4  := p_ct^.elements^.suivant^.suivant^.nom^;    { list N prg }

         p_ico  := p_ct^.elements^.suivant^.suivant^.suivant;
         xs     := p_ico^.nom^;                            { abscisse cran }
         ys     := p_ico^.suivant^.nom^;                         { ordonne }
         ls     := p_ico^.suivant^.suivant^.nom^;                { longueur }
         hs     := p_ico^.suivant^.suivant^.suivant^.nom^;       { hauteur  }

         if numbte = 2
         then begin
            menu_don [li-1] :=  lign3;          { extraire nom de la rgion }
            ini_menu_prg  (li-1); { extr liste progr autoriss de la rgion }
            ini_coord_ico (li-1);   { coord et dimensions des icnes region }
         end else begin
            menu_pro [li-1] :=  lign3;          { nom programme             }
            menu_cmd [li-1] :=  lign4;          { nom fichier de paramtres }
            ini_coord_ico (li-1);  { coord et dim des icnes des programmes }
         end;
         p_ct   := p_ct^.suivant;
      end;

      if li > nboptions-1
      then
         li := li-1;

      menu_lig [numbte] := li;
   end;

procedure ini_menu_fic;
   var
      c1                : string [1];
      er,
      n, cn             : integer;

   begin
      for n := 1 to nboptions-1
      do
         menu_autorise [n] := true;

      if (ope_fic [1] <> '0') and (ope_fic <> '')
      then begin   { des oprations sont interdites }
         ope_fic := copy (ope_fic, 1, nboptions-1);
         for n := 1 to length (ope_fic)
         do begin
            c1 := ope_fic [n];
            val (c1, cn, er);
            menu_autorise [cn] := false;
         end;
      end;
      { else :          aucune opration interdite }
   end;

procedure nouv_bte2;
   begin
      if boite2 = nil
      then begin    { initialiser la boite avec le titre }
         new          (boite2);
         cree_nom_chn (boite2, txt_mnu21);
                       boite2^.suivant  := nil;
                       boite2^.elements := nil;
      end;
   end;

procedure nouv_bte3;
   begin
      if boite3 = nil
      then begin    { initialiser la boite avec le titre }
         new          (boite3);
         cree_nom_chn (boite3, txt_mnu31);
                       boite3^.suivant  := nil;
                       boite3^.elements := nil;
      end;
   end;

procedure dec_icones_modules ;
    { lire les infos du fichier ou calculer une position }
   var
      i, j          : integer;

   begin
      for i := 1 to nboptions-1
      do
         of7ico [i] := 0;   { pas de dcalage }

      for i := 1 to nbmodules     { dfinir les icnes  activer }
      do begin
         j := i;     { dcaler si module inexistant }
         while menu_pro [i] <>  menu_ico [j]
         do begin
            inc (j)
         end;
         of7ico [i]  := j-i;
      end;
      for i := nbmodules+1 to nboptions-1
      do
         of7ico [i] := of7ico [nbmodules];
   end;

procedure lire_menus ;
   var
      i, nbl            : integer;

   begin
      ini_menu_fic ;   { examiner interdictions possibles du menu fichier }
      for i := 1 to nboptions-1 do menu_don [i] := '';
      for i := 1 to nboptions-1 do menu_cmd [i] := '';
      for i := 1 to nboptions-1 do menu_pro [i] := '';
    (*  nouv_bte2;       { new }
      menu_lig [2] := compte_elements (boite2); {nb_lign (boite2);}

      if menu_lig [2] > nboptions
      then
         menu_lig [2] := nboptions;

      nbregions   8 := menu_lig [2]-1;
      menus_bte (boite2, 2);
 *)
      der_icn      := 3+nboptions-1;   { nb icnes systme + nb max rgions }
      nouv_bte3;       { new }
      menu_lig [3] := compte_elements (boite3); {n b_lign (boite3); }

      if menu_lig [3] > nboptions
      then
         menu_lig [3] := nboptions;

      nbmodules    := menu_lig [3]-1;

      menus_bte (boite3, 3);

      { calculer ici of7ico }
      dec_icones_modules ;


      { inversion 06/96 }
      menu_lig [2] := compte_elements (boite2); {nb_lign (boite2);}

      if menu_lig [2] > nboptions
      then
         menu_lig [2] := nboptions;

      nbregions    := menu_lig [2]-1;
      menus_bte (boite2, 2);
   end;

procedure dess_icones_modules (nbi : integer);
   var
      i                 : integer;

   begin
      for i := 1 to nbmodules
      do begin
         active_dess_icone   (i + nbi + of7ico [i]);
      end;
   end;

procedure def_icones_modules (nbi : integer);
    { lire les infos du fichier ou calculer une position }
   var
      num_ico,
      px, py,
      lx, ly,
      hy, i, j          : integer;

   begin
      hy  := hicop;
      for i := 1 to nbmodules     { dfinir les icnes  activer }
      do begin
         px := menu_ico3 [i, 1];
         py := menu_ico3 [i, 2];
         if (px = 0) and (py = 0) or (px < 0) or (py < 0)
         then begin
            px := maxx - licop -2* 4;
            py := (hy+4)*i;
         end;
         lx := menu_ico3 [i, 3];
         ly := menu_ico3 [i, 4];

         if px > maxx-(lx+3)    then px := maxx-(lx+3);
         if px < 3              then px := 3;
         if py > maxy-(ly+ty+3) then py := maxy-(ly+ty+3);
         if px < 3              then py := 3;

(*         j := i;     { dcaler si module inexistant }
         while menu_pro [i] <>  menu_ico [j]
         do begin
            inc (j)
         end;
         of7ico [i]  := j-i;
 *)
         num_ico     := i+nbi+of7ico [i];
         bouton_icone (commentairemenu (3, i+1), num_ico, px, py, lx, ly);
          { avec texte complet du commentaire associ }

         active_icone               (num_ico);
      end;
   (*   for i := nbmodules+1 to nboptions-1
      do
         of7ico [i] := of7ico [nbmodules];
   *)
   end;

procedure dess_icones_region (nbi : integer);
   var
      i                 : integer;

   begin
      for i := 1 to nbregions
      do begin
         active_dess_icone   (i + nbi);
      end;
   end;

procedure def_icones_region (nbi : integer);
   var
      px, py,
      lx, ly,
      i                 : integer;

   begin
      dx := maxc1;
      dy := hauteurmenu;
      for i := 1 to nbregions
      do begin
         px := menu_ico2 [i, 1] +dx ;
         py := menu_ico2 [i, 2] +dy ;
         lx := menu_ico2 [i, 3];
         ly := menu_ico2 [i, 4];
         bouton_icone ( commentairemenu (2, i+1), i+nbi, px, py, lx, ly);
                      { avec texte complet du commentaire }

         active_icone               (i+nbi);
                  { invisibles  car i+nbi > nbicones }
         setcolor  (colord);
         rectangle (px, py, px+lx, py+ly);
         setcolor  (colorf);
      end;
   end;

procedure ChangerIconeg (Action1, Action2, Couleur : integer;
                                         var p_ico : pointer);
   begin
      DemarquerIconeg (action1, p_ico);           { p_ico en entre }
      MarquerIconeg   (Action2, Couleur, p_ico);  { p_ico en sortie }
      Repeat until Not UnboutonSourisEnfonce;
   end;

procedure choix_region (ndon : integer);
   var
      i                 : integer;

   begin
      DemarquerIconeg (zea, picoa);     { activit prcdente }
      zea       := 0;
      nactivite := 0;

      ndonnees := ndon;
      if ndonnees > 0
      then begin
         region    := menu_don [ndonnees] ;        { choix de la rgion }
         if r_trv ='\'
         then
            reptrav   := u_trv+'\'+region
         else begin
            enleve_AntiSlash (r_trv);
            reptrav   := u_trv+r_trv+'\'+region;
         end;
         { activer autres choix possibles seulement : menus }
         for i := 2 to menu_lig [3]
         do
            if (menu_prg [ndonnees, i-1] )
            then begin
               active ( 3, i, true );
               active_icone    (i+2 + of7ico [i-1]);
            end else begin
               active ( 3, i, false );
               inactive_icone  (i+2 + of7ico [i-1]);
            end;

         if (zi >= der_icn) and (zi <= der_icn + nboptions-1)
         then begin
            ChangerIconeg (zed, zi, cod, picod);
            zed := zi;
         end;

         if (nactivite <= 0) or  not (menu_prg [ndonnees, nactivite])
         then begin
            nom_cmd := '';
            ext_cmd := '';
            prog    := '';
         end;
      end else begin
         reptrav := reptemp;
         enleve_AntiSlash (reptrav);
         for i := 2 to menu_lig [3]                { inactiver action }
         do begin
            active ( 3, i, false );
            inactive_icone  (i+2 + of7ico [i-1]);
         end;
      end;
   end;

procedure choix_activite  ( nact : integer ) ;
   var
      i, j, p           : integer;

   begin
      nactivite := nact;
      if nactivite > 0
      then begin
         prog      := menu_pro [nactivite];  { choix du programme }
         nom_cmd   := menu_cmd [nactivite];  { et fichier de params. associ }
         p         := pos ('.', nom_cmd);
         if p > 0
         then begin
            ext_cmd := copy (nom_cmd, p, 4) ;
            nom_cmd := copy (nom_cmd, 1, p-1) ;
         end else
            ext_cmd := '';

         if (zi >= 4) and (zi <= 14)
         then begin
            ChangerIconeg (zea, zi, coa, picoa);
            zea := zi;
         end;
      end;
   end;

procedure impr_params (t : chainecar; l : lipar.liste);
   { procedure duplique GEO_DES }
   var
      nomport           : chainecar;

   begin
      if portimpr = 0  then exit;
      verif_port (portimpr, ok);
      {  revoir pour le rseau : ne pas refermer en cours d'impression }
      if ok
      then begin
         case portimpr of
         1 : nomport := port1 {'LPT1'};
         2 : nomport := port2 {'LPT2'};
      {   3 : nomport := port3 ; }
         end;
         l.ecrit (nomport, t+' '+datjour+' '+nomutil{+' '+titre});
      end;
   end;

procedure lire_config    (nomf : pathstr);
   { procedure duplique GEO_DES }
   begin
      if ftxt_present (nomf)
      then
         parini.lit (nomf);
   end;

procedure ecrire_config  (nomf : pathstr);
   { procedure duplique GEO_DES }
   begin
      parini.ecrit (nomf, datjour+' '+nomutil)
   end;

procedure voir_penv      (nomf : namestr);
   { procedure duplique GEO_DES }
   begin
      parini.boite;                                                 { lipar }
      bte_compl (t_bte_cfg+' : '+nomf,      -1, -1, nbc, nbo, 57, nbo);
                                                                    { menu6 }
   end;

procedure ini_par_cfg    (nomf : pathstr);
   { procedure duplique GEO_DES }
   begin
      parini.init   (false);
      parini.ajoute (Cstring  ('Fichier symboles 1'      , @symb1, 'baton1'  ));
     { parini.ajoute (Cstring  ('fichier symboles 2'     , @symb2, 'baton2'  ));}
      parini.ajoute (Cstring  ('Fichier symboles 3'      , @symb3, 'symboles'));
      parini.ajoute (Cinteger ('Nombre de plumes'        , @nbpl     ,     0 ));
      parini.ajoute (Cinteger ('Numro du port srie'    , @porttab  ,     0 ));
      parini.ajoute (Cinteger ('Numro du port impr.'    , @portimpr ,     1 ));
      parini.ajoute (Cinteger ('Vitesse de transm.'      , @bauds    ,  1200 ));
      parini.ajoute (Cinteger ('Type d''imprimante'      , @qual     ,     0 ));
      parini.ajoute (Cchar    ('Format papier/traceur'   , @formatpapier, '4'));
      parini.ajoute (Cstring  ('Nom variable utilisateur', @nomvaru, 'username'));
      parini.ajoute (Cboolean ('Machine rapide'          , @rapide   ,  False));
      parini.ajoute (Cboolean ('Affichages automatiques' , @reaffiche,  False));
      parini.ajoute (Cboolean ('Bloc monochrome',          @unicolore,  False));
      pol_menu := 2;
      if ftxt_present    (nomf)
      then
         parini.lit (nomf);
   end;

procedure voir_ptrav (nomf : namestr);
   begin
      params.boite;                                                 { lipar }
      bte_compl (t_bte_mnu+' : '+nomf, -1, -1, nbc, nbo, 57, 10);          { menu6 }
   end;

procedure ini_par_trv    (nomf : pathstr);
   { Description menu accueil }

   begin
      params.init   (false);
      params.ajoute (Cstring  ('Chemin rpertoire de travail'     , @ch_grp, 'c:\geocean\geoc_trv'));
      params.ajoute (Cstring  ('Chemin rpertoire des donnes'    , @ch_dnn, ''));
      params.ajoute (Cstring  ('Chemin rpertoire des exemples'   , @ch_xpl, ''));
      params.ajoute (Cstring  ('Chemin rpertoire des programmes' , @ch_prg, ''));
      params.ajoute (Cstring  ('Chemin rpertoire des menus'      , @ch_mnu, ''));
      params.ajoute (Cstring  ('Chemin rpertoire commun'         , @ch_ech, ''));

      { options fichiers ok }
      params.ajoute (Cstring  ('Menu fichier'       , @ope_fic  , '345'));

      { menu rgion }
      params.ajoute (Clst_chn ('Menu donnes'       , @boite2   , nil ));

      { menu activits }
      params.ajoute (Clst_chn ('Menu programmes'    , @boite3   , nil ));

      { params.ajoute (Cboolean ('disquette autorise', @disk_oui , TRUE));}

      { noms des groupes }
      params.ajoute (Clst_chn ('Groupes'            , @list_grp , nil   ));

      if ftxt_present    (nomf)
      then
         params.lit (nomf);
   end;

procedure def_icones;
   var
      i,
      px, py,
      lx, ly            : integer;

    begin
(*      for i := 1 to nboptions-1
      do
         of7ico [i] := 0;   { pas de dcalage }
*)
      px  := maxc2 -licop;
      py  := maxy - (hicop + ty);
      bouton_icone (aidico1,   1, px,   py - 3,  2,  2); { ! }
{      active_icone                  (1);}

      bouton_icone (aidico2,   2, px,   py - 3, licop, hicop);
{      active_icone                  (2);}

      bouton_icone (aidico3,   3, px,   py,  2,  2); { ! }
{      active_icone                  (3);  }
      def_icones_modules (3) ;
      def_icones_region  (der_icn);
   end;

procedure dess_icones;
   begin
      active_dess_icone   (2);
      dess_icones_modules (3) ;
      dess_icones_region  (der_icn);
   end;

{function nb_groupes     : word;
   begin
      nb_groupes := compte_elements (list_grp);
   end;
}
function groupexist    (groupe : namestr) : boolean;
   begin
      groupexist := element_existe (list_grp, groupe);
   end;

procedure ini_noms_groupes (nomu : namestr ; var groupu : namestr ; utilexist : boolean);
   var
      l                 : lst_chn;

   begin
      utilexist := false;
      l  := list_grp;
      while (l <> nil) and not utilexist
      do begin
         utilexist := element_existe (l^.elements, nomu);
         if utilexist
         then
            groupu := l^.nom^;
         l         := l^.suivant;
      end;
   end;

procedure identifier_util;
   { comparer util et liste -- Groupe ou individu }
   var
      i                 : integer;
      chem              : dirstr;
      nomf              : namestr;
      ext               : extstr;
      utilexist,
      groupok           : boolean;

   begin
      echanges  := false;
      exempl    := false;
      groupe    := gcommun;                { utilisateur non trouv... }

      if (nomutil = '')                    { c'est donc un dbut de session }
      then begin
            {! demander identification aussi bien en monoposte qu'en rseau }

         if tousperso
         then begin
            nomutil := getenv (nomvaru);
            nomutil := copy   (nomutil, 1, 8);
         end ;

         if nomutil = ''
         then begin
            laide   (la_id_util);
            i := 0;
            repeat
               inc (i);
               saisie (s_pseudo+' : ', nomutil, 8);
            until (nomutil <> '') or (i > 2);
         end;
         nomutil := maj (nomutil);
         laide  ('');
      end;

          { extraire le nom de l'unit de travail   }
      fsplit (ch_grp, chem, nomf, ext);
      u_grp   := copy (ch_grp, 1, 2);
      r_grp   := copy (chem, 3, length (chem));

      if not tousperso
      then begin                        { travail dans rpertoire collectif }
               { charger liste des groupes pour comparer }
         if nomutil = ''
         then begin
            nomutil := ninconnu;
            groupe  := gcommun                { pas de nom ... }
         end else begin
                  { rechercher couples noms/groupe et comparer }
            ini_noms_groupes (nomutil, groupe, groupok);
            if not groupok
            then
               groupe := gcommun;             { pas dans les listes }
         end;
         u_trv   := u_grp;
         r_trv   := r_grp+groupe;
      end else begin                          { travail personnalis }
         { si possible :
              chacun dans son rpertoire personnel : rseau indispensable,
         sinon situation quivalente  rpert collectif sans scurit }

         { contrler ??          { if control then ... }

         { cas exceptionnel :
              pas d'identification, pas d'accs  un rpertoire personnel ! }
         if (nomutil = '')
         then begin
            nomutil := ninconnu;
            fsplit (reptemp, chem, nomf, ext);
            u_grp   := copy (chem, 1, 2);
            r_grp   := copy (chem, 3, length (chem));
            message (m_trv_tmp);
         end;
         groupe  := '';
         u_trv   := u_grp;
         r_trv   := r_grp;
      end;
          { mmoriser affectation rpertoire de travail }
      u_trv_temp := u_trv;
      r_trv_temp := r_trv;
   end;

procedure IniEcran;
   begin
      affichemenu;                                                 { menus1 }
      def_icones;
      dess_icones;
   end;

procedure choix_reg_act;
   begin
      choix_region   (ndonnees) ;

      if ndonnees > 0
      then begin
         zed := ndonnees + der_icn;
         MarquerIconeg (zed, cod, picod);
      end else
         zed := 0;

      choix_activite (nactivite);

      if nactivite > 0
      then begin
         zea := nactivite+2;
         marquericoneg (zea, coa, picoa);
      end else
         zea := 0;
   end;

procedure aff_l_aide;
   begin
      laide (la_region_module);
   end;

procedure aide_region (numreg : integer);
   { 1..11 }
   var
      reg               : namestr;

   begin
      { extraire le nom de la region }
      reg    := menu_don [numreg] ;        {  choix de la rgion }
      aide_txt (t_pres_region, ch_dnn+reg+'\'+reg+exttxt);
   end;

procedure aide_module (nummod : integer);
   { 1..11 }
   var
      nomdumodu         : namestr;

   begin
      { extraire le nom du module }
      nomdumodu  := menu_pro [nummod];        { choix du programme }
      aide_txt (t_pres_modu,       ch_prg+nomdumodu+exttxt);
   end;

procedure aide_geoc;
   begin
      aide_txt (t_pres_logi,     ch_prg+nomlogiciel+exttxt);
   end;

procedure aide_mnu;
   begin
      aide_txt (t_pres_inter, ch_mnu+nommenu+exttxt);
   end;

procedure aide (x, y : integer);
   begin
      aff_aide (ch_mnu+nommenu + exthlp, x, y-1)
   end;

procedure A_PROPOS ;
   begin
      aff_aide (ch_mnu+nommenu + exthlp, 6, 7);                    { menus6 }
   end;

procedure A_PROPOS2 ;
   begin
      aff_aide (ch_mnu+nommenu + exthlp, 6, 8);                    { menus6 }
   end;

procedure ref_image ;
   begin
      aff_aide (ch_mnu+nommenu + exthlp, 6, 9);                    { menus6 }
   end;

procedure info_misaj;
   { }
   begin
      aff_aide (ch_mnu+nommenu + exthlp, 6, 10);                    { menus6 }
   end;

procedure info_cfg;
   { }
   begin
      aff_aide (ch_mnu+nommenu + exthlp, 6, 11);                    { menus6 }
   end;

procedure infos_systeme;
   begin
      chain := nom_impr+ ' '+n_sur+' '+nom_port;
      message3 (nomutil+' - '+groupe+' '+datjour,
                n_imprimante+' : '+chain,
                n_memdisp   +' : '+memdisponible+' '+n_octets)
   end;

procedure AIDE_MENUS_b ;
   var
      nbb,
      CodeClavier,
      i, x, y           : integer;

      chain             : chainecar;

   procedure active_aide ;
      var
         i, j           : integer;

      begin
         for i := 1 to nbboites
         do
            for j := 1 to nboptions
            do
               active (i, j, true);
      end;

   begin
      x := 1;
      if (nomdumodule = nomconf)
      then
         nbb := 5
      else
         nbb := 3;

      for i := 1 to nbb
      do
         creeliste (titremenu (i, 1),    i);

      utildivs.liste    (l1_a_menu, l2_a_menu, l3_a_menu, 18, chain, x);

      if x > 0
      then begin
         active_aide ;
         repeat until not unboutonsourisenfonce;
         montrersouris;
         SousMenu (-1, -1, x, y, CodeClavier);
         cachersouris;
      end else
         exit ;

      if y > 0
      then begin
         aff_aide (ch_mnu+nommenu+exthlp, x, y-1);
         if x = 2
         then
            aide_region (y-1);
         if x = 3
         then
            aide_module (y-1);
      end;
   end;

procedure ini_par_ins  (nomf : pathstr);
   { Rsultat installations cumules }
   begin
      parins.init   (false);
{      parins.ajoute (Cstring  ('Chemin rpertoire de travail'    , @ch_grp, 'c:\geocean\geoc_trv\'));}
{                                       modifiable  avec conf }
      parins.ajoute (Cstring  ('Chemin rpertoire des programmes', @ch_prg, 'c:\geocean\geoc_prg' ));
      parins.ajoute (Cstring  ('Chemin rpertoire des menus'     , @ch_mnu, 'c:\geocean\geoc_mnu' ));
      parins.ajoute (Cstring  ('Chemin rpertoire des donnes'   , @ch_dnn, 'c:\geocean\geoc_dnn' ));
      parins.ajoute (Cstring  ('Chemin rpertoire des exemples'  , @ch_xpl, 'c:\geocean\geoc_xpl' ));
      parins.ajoute (Cstring  ('Chemin rpertoire des documents' , @ch_doc, 'c:\geocean\geoc_doc' ));
      parins.ajoute (Clst_chn ('Modules installs'               , @list_prg,  nil ));
      parins.ajoute (Clst_chn ('Rgions installes'              , @list_reg,  nil ));
      parins.ajoute (Cboolean ('Gocan sur serveur de fichiers' , @Instreso,  false ));

      if ftxt_present  (nomf)
      then
         parins.lit (nomf);
   end;

procedure ecr_par_ins (nomf  : pathstr);
   begin
      parins.ecrit  (nomf, datjour);
   end;

procedure libere_mem;
   begin
      liberer_liste_chaine (boite2);
      liberer_liste_chaine (boite3);
      liberer_liste_chaine (list_grp);
      liberer_liste_chaine (list_reg);
      liberer_liste_chaine (list_prg);
      params.fini;
   end;

procedure quitter (f : boolean);
   var
      fbat              : text;

   begin
      chain := nomlogiciel+' ?';
      if not f
      then
         question (q1_quitter, chain, fini);

      if fini
      then begin
         assign  (fbat, reptemp+quit_bat);
         rewrite (fbat ) ;
      {   writeln ( fbat, 'mode co80');
         writeln ( fbat, 'set repbgi=');   dans menufini }
         if not tousperso
         then
            writeln (fbat, 'if exist %temp%\'+fic_etat_util+' del %temp%\'+fic_etat_util);

         writeln (fbat, MENUFINI_bat);
                  { ncessaire pour retourner dans le rp initial }
         close   (fbat )
      end;
   end;

procedure lire_par_module (nomf : pathstr ; var n_mod : lst_chn);
   var
      parmodule         : lipar.liste;

   begin
      parmodule.init   (false);
      parmodule.ajoute (Clst_chn (n_module, @n_mod, nil));
      parmodule.lit    (nomf);
      parmodule.fini;
   end;

procedure lire_par_region (nomf : pathstr ; var n_reg  : lst_chn);
   var
      parregion         : lipar.liste;

   begin
      parregion.init   (false);
      parregion.ajoute (Clst_chn (n_region, @n_reg, nil));
      parregion.lit    (nomf);
      parregion.fini;
   end;

procedure inserer_nouv_entree_bte (n_bte, bte          : lst_chn ;
                                   li                  : integer);
   { insre une ligne donnes dans BTE en positon li
     var globales modifies : BOITE2/BOITE3}
   var
      p_pre, p_ct
                        : lst_chn;
{      nbe,                            }
      nb                : integer;

   begin
    {  nbe :=  compte_elements (bte);}
      { insre en queue }
      if li = 0
      then begin
         { rechercher la fin }
         p_ct := der_element (bte);
         { accrocher }
         n_bte^.suivant := nil;
         p_ct^.suivant  := n_bte;
      end else begin
         { insre en li }

(*         while nbe < li        { vrifier  que li existe }
         do begin
            inc (nbe);
            ajouter_nom_chaine (bte ,'');
         end;
*)
         p_ct  := bte;
         p_pre := bte;

         nb    := 0;                  { rechercher N ligne }
         while (nb < li)
         do begin                     { tq }
            inc (nb);                 { 2.. 12   nb maxi  de lignes au menu }
            p_pre  := p_ct;
            p_ct   := p_ct^.suivant;
         end;
         { accrocher }
         n_bte^.suivant := p_ct;
         p_pre^.suivant := n_bte;
      end;
   end;


END.

{--- GEOCEAN - MENU_FIC ------ --------------- R.C.- INRP - TOULOUSE - 1994 }
