UNIT MENU_MNU;

   {------------------------------------------------------------------------}
   { logiciel GEOCEAN - module MENU                                         }
   {                                                                        }
   {                  initialisations communes MENU/INST                    }
   {                                                       10/10/93         }
   {------------------------------------------------------------------------}

INTERFACE

{$O+,F+}

USES
   dos, crt, graph,          { TP 70   - unit  standard                    }
   Graphism,                 { ARX     - initialisations graphiques         }
   Graphplt,                 { ARX     - graphisme 2D cran/traceur         }
   DirInfo,                  { ARX     - Gestion des fichiers ressources    }
   Messarx,                  { ARX     - Textes des Messages de Base        }
   Utildivs,                 { ARX     - utilitaires divers                 }
   Utiledi,                  { ARX     - utilitaires dition                }
   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   Icones,                   { ARX     - gestion de icnes                  }
   Periphs,                  { ARX     - priphriques, impression, palettes}
   Menus,                    { ARX     - interface  menus droulants        }

   MENU_FIC,                 { MENU    - Initialisations fichiers           }
   MENU_VAR;                 { MENU    - variables globales du module       }

   {------------------------------------------------------------------------}

Procedure iniparam;
   { initialise les paramtres MENUS, CFG                                   }

Procedure iniparam2;
   { initialise les paramtres du programme lis  l'utilisateur            }

Procedure rech_precedents;
   { recherche index REGION et PROG choisis prcdemment                    }

Procedure iniIcones;
   { initialise les pointeurs sur les icnes                                }

Procedure fin;
   { restaure l'cran texte.                                                }

Procedure EDITINFO;
   { crer ou modifier le fichier de ressources du rpertoire de travail    }

Procedure copier;
   { copier des fichiers du rpertoire courant vers une disquette           }

Procedure nettoyer;
   { supprimer des fichiers dans le rpertoire courant ou une disquette     }

Procedure transferer;
   { mettre  jour le rpertoire courant                                    }

Procedure voir_catalogue_trv;
   { visualise les fichiers de l'utilisateur dans le contexte REGION        }

Procedure creer_repert_region;
   { teste la prsence du rpertoire et le cre s'il n'existe pas           }

Procedure reprendre ;
   { lance le travail en proposant le choix d'un fichier de paramtres      }

Procedure creer;
   { lance le travail avec le fichier de paramtres par dfaut              }

Procedure lancer;
   { lance le travail en proposant le choix  NOUVEAU/POURSUIVRE             }

Procedure inifondecran;
   { affiche image                                                          }

Procedure change_connexion;
   { changer d''utilisateur  ou de rpertoire perso                         }

Procedure mode_exemples;
   { accs aux exemples            lecture seule depuis les modules         }

Procedure mode_echanges;
   { accs au rpertoire commun    lecture et criture depuis les modules   }

{---------------------------------------------------------------------------}

IMPLEMENTATION

procedure mode_exemples;
   begin
      { interdit si non intalls = nom rpert ch_xpl vide }
      if echanges
      then
{         echanges := false; }
         mode_echanges;
      exempl := not exempl;
      if exempl
      then begin
         message (m_consulte);
         u_trv  := copy (ch_xpl, 1, 2);
         r_trv  := copy (ch_xpl, 3, length (ch_xpl));
         enleve_AntiSlash (r_trv);
      end else begin
         message (m_not_consulte);
         u_trv  := u_trv_temp;
         r_trv  := r_trv_temp;
      end;
      if r_trv ='\'
      then
         reptrav   := u_trv+'\'+region
      else begin
         enleve_AntiSlash (r_trv);
         reptrav   := u_trv+r_trv+'\'+region;
      end;
      DemarquerIconeg (zed, picod);
      nactivite := 0;
      ndonnees  := 0;
      choix_reg_act;
      { inactiver rgions sans exemples }
   end;

procedure mode_echanges;
   begin
      { interdit si non install = nom rpert ch_ech vide }
      if exempl
      then
 {        exempl := false;}
         mode_exemples;
      echanges := not echanges;

      if echanges
      then begin
         message (m_acces_ech);
         u_trv  := copy (ch_ech, 1, 2);
         r_trv  := copy (ch_ech, 3, length (ch_ech));
         enleve_AntiSlash (r_trv);
      end else begin
         message (m_acces_perso);
         u_trv  := u_trv_temp;
         r_trv  := r_trv_temp;
      end;
      if r_trv ='\'
      then
         reptrav   := u_trv+'\'+region
      else begin
         enleve_AntiSlash (r_trv);
         reptrav   := u_trv+r_trv+'\'+region;
      end;
      DemarquerIconeg (zed, picod);
      nactivite := 0;
      ndonnees  := 0;
      choix_reg_act;
   end;

procedure reconnecter;
   begin
      { dsactiver tout }
      DemarquerIconeg (zed, picod);
      nomutil   := '';
      nactivite := 0;
      ndonnees  := 0;
      identifier_util;
      choix_reg_act;
   end;

procedure change_connexion;
  begin
      if tousperso
      then
         { rien }
      else
         reconnecter;
  end;

procedure finir;
   begin
      { restorecrtmode;
      ecrantexte; }
      libere_mem;
   end;

procedure inifondecran;
   begin
      ini_par_ecr;
      cadrer;
      affiche_image;
   end;

procedure rech_ind_region (    reg : namestr;
                           var ind : integer);
   begin
      if reg = '' then exit;
      ok  := false;
      ind := 0;
      while (ind < nbregions) and (not ok)
      do begin
         inc (ind);
         ok := (menu_don [ind] = reg) ;
      end;
      if not ok then ind := 0;
   end;

procedure rech_ind_prog (   pr  : namestr;
                        var ind : integer);
   begin
      if pr = '' then exit;
      pr  := maj (pr);
      ok  := false;
      ind := 0;
      while (ind < nbmodules) and (not ok)
      do begin
         inc (ind);
         ok := menu_pro [ind] = pr ;
      end;
      if not ok then ind := 0;
   end;

procedure rech_precedents;
   begin
      rech_ind_prog   (prog,   nactivite); { module excut appel prcdent }
      rech_ind_region (region, ndonnees);  { rgion utilise ... }
   end;

procedure creer_repert_region;
   { se placer dans le rpertoire de travail associ  la rgion        }
   var
      nb                : integer;
      place             : longint;
      plas              : t12;

   begin
      {$I-}
      { crer le rpertoire rgion  s'il n'existe pas    }
      if r_trv = '\'
      then
         chdir (u_trv+'\'+region)
      else
         chdir (u_trv+r_trv+'\'+region);
      {$I+}
      if ioresult <> 0
      then begin
         chdir (u_trv+r_trv);
        {  message (m_cre_rep_trvr+' '+region);}
         mkdir_err (region, m_cre_rep_region , ok);
      end;
      { sans annoncer le nom du rpert et la place restante sur le disque }
      chdir (ch_ct);
   end;

procedure iniparam;
   var
      chem, chemp       : dirstr;
      nomf              : namestr;
      ext               : extstr;

   begin
      (* rpertoire temporaire REPTEMP affect dans UTILDIVS               *)
      nomfpar  := nommenu;
      ch_par   := '';
      nomfcfg  := nomlogiciel;

      { charger la configuration d'ensemble de MENU ...}
      pol_menu :=   2;

          { rechercher le chemin des donnes du menu }
      chemp    := '';
      if paramcount > 0
      then
         chemp := paramstr (1);
      if chemp <> ''
      then begin
         fsplit (chemp, chem, nomf, ext);
         ch_par  := chem ;
         nomfpar := nomf;               { nom du fichier MENUS }
      end;

      if not ftxt_present (ch_par+nomfpar+extpar)
      then begin
{         ch_par := '';}
         nomfpar := nommenu;
      end;

      if not ftxt_present (ch_par+nomfpar+extpar)
      then begin
         fini := true;
         quitter (true);    { gnre le fichier QUIT }
         libere_mem;
         halt
      end;

      ini_par_trv (ch_par+nomfpar+extpar);
      tousperso := list_grp = nil  ;      { <> nil au dmarrage }

      if paramcount > 2
      then
         chain := paramstr (3);

      complete (ch_grp);             { ajoute vt un \ }
      complete (ch_dnn);
      complete (ch_prg);
      complete (ch_mnu);
      complete (ch_xpl);
      { ch_cfg        ne pas complter ! }

      chemp   := '';
      if (paramcount > 1)
      then
         chemp := paramstr (2);

      if chemp <> ''
      then begin
         fsplit (chemp, chem, nomf, ext);
         nomfcfg := nomf;               { nom du fichier CONFIG }
      end else
         nomfcfg := nomlogiciel;

      ini_par_cfg (ch_prg+nomfcfg+extcfg);

      { affecter rpertoire configuration graphique   }
      repbgi := maj (getenv (NomBgi));
      if repbgi = ''
      then
         repbgi := ch_mnu;
      complete (repbgi);         { ajoute ventuellement un \ }

      nactivite := 0;
      ndonnees  := 0;
   end;

procedure lire_utilisateur;
   var
      f                 : text;

   begin
      chain := reptemp;
      if ftxt_present (chain+fic_etat_util)
      then begin
         assign (f, chain+fic_etat_util);
         reset  (f);
         readln (f, nomutil);
         readln (f, groupe);
         readln (f, region);
         readln (f, prog);             { autres valeurs inutiles ici }
         close  (f);
      end;
   end;

procedure iniparam2;
   var
      i                 : word;
      chem, chemp       : dirstr;
      nomf              : namestr;
      ext               : extstr;

   begin
      { rechercher le chemin courant }
      getdir (0, chemp);
      if chemp = ''
      then
         chemp := ch_mnu;
      enleve_antislash (chemp);
      fsplit (chemp, chem, nomf, ext);
      u_ct  := copy (chem, 1, 2);
      r_ct  := copy (chem, 3, length (chem))+nomf;
      ch_ct := u_ct+r_ct;

      fini  := false;
      prof  := false;

      { Rechercher tat prcdent : rgion, programme, groupe
        Si le nom d'utilisateur est vide, c'est le premier lancement du menu
      utilisateur : il faudra lui demander de s'identifier.
        Si ce nom est affect, on continue avec les mmes paramtres   }

      if nomdumodule = nommenu
      then
         lire_utilisateur;

      if nomdumodule = nomconf      { configuration }
      then begin
         nomutil := ninconnu;
         groupe  := gcommun;
      end;
   end;

procedure iniIcones;
   begin
      if ftxt_present (ch_mnu+nommenu+exticn)
      then
         ActiveListeIcones (ch_mnu+nommenu+exticn)                  { ICONES }
      else begin
         message (m_not_icones);
         halt;
      end;
   end;

procedure editinfo;
   var
      filtr             : pathstr;
      d                 : dirstr;
      n                 : namestr;
      e                 : extstr;

   begin
      filtr := '*.CRT';
      if nactivite > 0
      then
         filtr := '*'+ext_cmd;
      saisie (s_resume, filtr, 12);
      filtrer_indesirables (filtr);
      fsplit (filtr, d, n, e);
      e := maj (e);
      if (n <> 'INFO') and (e <> '') and (e <> '.*') and (e <> '.DIR')
      then
         edite_info (reptrav+'\INFO.DIR', n, e);
   end;

procedure choix_cmd ;
   begin
      dir_info ('', d_travaux, '',
                 reptrav+'\INFO.DIR', '*', ext_cmd, nom_cmd);
   end;

procedure copier;
   var
      ok                : boolean;
      volumeAcopier     : longint;
      nb                : integer;
      chemin            : dirstr;
      nbs,
      filtr             : t12;
      u                 : byte;

   begin
      chemin := 'A:';
      u      := 1;

      if 2 in liste_disques
      then begin
         entier := 1;
         creeliste (n_lecteur+' A:',    1);
         creeliste (n_Lecteur+' B:',    2);
         liste     (l_choisir_dest,
                    l_unite_trv,
                    reptrav,
                    18, chain, entier);
         if entier = 2
         then begin
            chemin := 'B:';
            u      := 2;
         end;
      end;
      if entier =  0 then exit;
      { tester prsence  }
      if dk_present (chemin)
      then begin
         { saisir le filtre }
         laide  (la_modi_copier);
         filtr := '*.*';
         ok := false;
         while not ok
         do begin                                   { test validit du nom }
            saisie (s_f_copier, filtr, 12);
            filtrer_indesirables (filtr);
            ok := nomfichier_seul_ok ( filtr )
         end;

         laide  ('');
            { calculer le volume et le nombre des fichiers }
         volumeAcopier := volume_fichiers (reptrav+'\'+filtr);
            { verifier si la place est disponible }
         if (volumeAcopier = 0)
         then begin
            message (m_not_fichier);
            exit
         end;
         if (diskfree (u) > volumeAcopier)
         then begin
            ok := false;
            if filtr = '*.*'
            then
               question (q1_copier, q2_copier, ok)
            else
               ok := true;

            if ok
            then begin
               copier_fichiers (reptrav+'\'+filtr ,chemin, nb);
               str (nb, nbs);
               message (nbs +' '+m1_copie+' '+filtr+' '+m_copie_s+' '+chemin);
            end
         end else
            message (m_not_place);
      end else
         message (m_err_dk);
   end;

procedure nettoyer;
   var
      ok                : boolean;
      nb                : integer;
      nbs, filtr        : t12;

   begin
      { saisir le filtre }
      laide  (la_modi_eff);
      filtr := '*.*';
      ok := false;
      while not ok
      do begin                                   { test validit du nom }
         saisie (la_modi_eff, filtr, 12);
         filtrer_indesirables (filtr);
         ok := nomfichier_seul_ok ( filtr )
      end;
      laide  ('');

      ok := false;
      if filtr = '*.*'
      then
         question (q1_effacer, q2_effacer, ok)
      else
         ok := true;

      if ok
      then begin
         effacer_fichiers (reptrav + '\' + filtr, nb );
         str (nb, nbs);
         message3 (nbs + ' ' + n_fichiers + ' ' + filtr,
                       m2_efface,
                       reptrav);
      end;
   end;

procedure transferer;
   var
      ok                : Boolean;
      volumeAcopier     : longint;
      nb                : integer;
      chemin            : dirstr;
      nbs,
      filtr             : t12;
      u                 : byte;

   begin
      chemin := 'A:';
      u      := 1;

      if 2 in liste_disques
      then begin
         entier := 1;
         creeliste (n_Lecteur+' A:',    1);
         creeliste (n_Lecteur+' B:',    2);
         liste     (choisir_dk,
                    de_trv,
                    reptrav,
                    18, chain, entier);
         if entier = 2
         then begin
            chemin := 'B:';
            u      := 2;
         end;
      end;
      if entier = 0 then exit;
      { tester prsence  }
      if dk_present (chemin)
      then begin
         { saisir le filtre }
         laide  (la_modi_copier);
         filtr := '*.*';
         ok := false;
         while not ok
         do begin                                   { test validit du nom }
            saisie (s_f_copier, filtr, 12);
            filtrer_indesirables (filtr);
            ok := nomfichier_seul_ok ( filtr )
         end;

         laide  ('');
            { calculer le volume et le nombre des fichiers }
         volumeAcopier := volume_fichiers (chemin+filtr);
            { verifier si la place est disponible }
         if (volumeAcopier = 0)
         then begin
            message (m_not_fichier);
            exit
         end;

         if (diskfree (0) > volumeAcopier)
         then begin
            ok := false;
            if filtr = '*.*'
            then
               question (q1_ecraser, q2_ecraser, ok)
            else
               ok := true;

            if ok
            then begin
               copier_fichiers (chemin+filtr, reptrav+'\', nb);
               str (nb, nbs);
               message3 (nbs +' '+n_fichiers+' '+ filtr   +' '+m1_copie,
                         n_de+' '    + chemin,
                         n_vers+' '  + reptrav);
            end;
         end else
            message (m_not_place);
      end else
            message (m_Err_dk);
   end;

procedure voir_catalogue_trv;
   var
      ok                : boolean;
      chem              : pathstr;
      nf                : namestr;
      filtr             : t12;

   begin
      nf    := '';
      chem  := reptrav+'\';
      laide  (la_modi_filtr);
      filtr := '*.*';
      ok    := false;
      while not ok
      do begin                                   { test validit du nom }
         saisie (n_Filtre, filtr, 12);
         filtrer_indesirables (filtr);
         ok  := nomfichier_seul_ok ( filtr )
      end;
      laide  ('');
      dir    (n_Catalogue, chem, nf, filtr, false);
   end;

procedure suite;
   var
      ok                : boolean;
      fbat              : text;

   begin
      { crer UTILISAT.EUR }
      chain := reptemp;
      assign        (fbat, chain+fic_etat_util);   {  }
      rewritetxterr (fbat, chain+fic_etat_util, ok);
      writeln (fbat, nomutil); { nom de l'utilisateur }
      writeln (fbat, groupe ); { nom du groupe des utilisateurs }
      writeln (fbat, region ); { nom de la rgion }
      writeln (fbat, prog   ); { nom du module }
      writeln (fbat, ch_dnn ); { chemin donnes rgions }
      writeln (fbat, ch_prg ); { chemin programmes module }
      if exempl
      then
         writeln (fbat, ch_xpl ); { chemin exemples INRP }
      close   (fbat);

      enleve_AntiSlash (ch_dnn);
      enleve_AntiSlash (ch_mnu);

      { crer EXECUTE.BAT }
      if (nom_cmd = '*') or (nom_cmd = '')
      then
         nom_cmd := prog;
      assign        (fbat, reptemp+execute_bat);   {  }
      rewritetxterr (fbat, reptemp+execute_bat, ok);
      writeln (fbat, u_trv );
      writeln (fbat, 'CD '+r_trv+'\'+region);
      writeln (fbat, ch_prg+prog+' '+nom_cmd+' '+nomfcfg);
      writeln (fbat, u_ct);
      writeln (fbat, 'CD '+r_ct);
      close   (fbat);

      fini    := true;
   end;

procedure creer;
   begin
      suite;
   end;

procedure reprendre;
   var
      nomf             : namestr;

   begin
      ok := true;
{      ok   := exists (reptrav+'\nul');}
      nomf := nomfcfg;
      if ok and (nom_cmd <> '')
      then
         choix_cmd;  { dir info }
      nomfcfg := nomf;
      nom_cmd := sansext (nom_cmd);
      if ok and (nom_cmd <> '')
      then
         suite
      else begin
         if not exempl
         then begin
            message3 (m1_aucun, m2_aucun, m3_aucun);
            suite;
         end;
      end;
   end;

procedure lancer;
   var
      nbf               : integer;

   begin
      nbf := numeromaxi (reptrav+'\*'+ext_cmd);

      if (nbf <= 0) and not exempl
      then begin
         creer;
         exit;
      end;

      if exempl
      then
         if nbf > 0
         then begin reprendre  end
         else begin message ('pas d''exemple') end

      else begin
         entier := 1;
         creeliste (c_commencer,    1);
         creeliste (c_reprendre,    2);
         liste     (n_region+' : '+region,
                    n_Module+' : '+prog,
                     nomutil, 33, chain, entier);
         case entier of
            1 : creer;
            2 : reprendre;
         end
      end;
   end;

procedure fin;
   begin
      finir;                                                          { des }
   end;

END.

{--- GEOCEAN - MENU_INI ------ --------------- R.C.- INRP - TOULOUSE - 1993 }
