UNIT PERIPHS;

{---------------------------------------------------------------------------}
{        GESTION DES IMPRIMANTES et TRACEURS, des PORTS, des PALETTES       }
{---------------------------------------------------------------------------}
(*
   Periphs,                  { ARX     - priphriques, impression, palettes}
*)

INTERFACE

{$O+,F+}

USES
   crt,
   dos,
   graph,
   printer,                  { TP 70   - units standard  Borland           }

   Messarx,                  { ARX     - Textes des Messages de Base        }
   Souris,                   { ARX     - gestion de la souris               }
   Clavier,                  { ARX     - gestion du clavier                 }
   rs2322,                   { ARX     - gestion ports srie                }
   imprim,                   { ARX     - gestion copies d'cran             }
   Graphism,                 { ARX     - initialisations graphiques         }
   Graphplt,                 { ARX     - graphisme 2D cran/traceur         }
   Utildivs,                 { ARX     - utilitaires divers                 }
   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   Utiledi;                  { ARX     - utilitaires dition                }


CONST
   port0                = 'NUL';
   port1                = 'LPT1';
   port2                = 'LPT2';
   port3                = 'LPT3';
   port4                = 'COM1';
   port5                = 'COM2';

   extpal               = '.PAL';

   n_ecran              = 'ECRAN_';
   extpcx               = '.PCX';
   n_CODEHP             = 'CODEHP';
   extplt               = '.PLT';

   der_impr             = 3;      { 3 imprimantes dfinies }

VAR
   pol_menu,                  { num police menus         }
   portimpr,                  { numro port imprimante   }
   porttab,                   { numero port traceur      }
   nbpl,                      { nombre de plumes traceur }
   qual,                      { type d'imprimante        }
   bauds                      { vitesse srie            }
                        : integer;

{---------------------------------------------------------------------------}

Procedure Imprimecran           (qual : integer);
   { Copie d'cran                                                          }

Procedure sauvepcx16;
   { gnre un fichier PCX }

Procedure cfg_plumes;
   { configure le traceur choix des plumes                                  }

Procedure palettes              (nomf : Pathstr);
   { modifie, sauve   la palette courante   charge une palette existante    }

Procedure mod_qual;
   { Modifier le type d'imprimante                                          }

Procedure cfg_imprimante;
   { Affecte un port pour l'imprimante                                      }

Procedure mod_nbplum;
   { Modifier le type de traceur                                            }

Procedure cfg_traceur;
   { Affecte un port  pour le traceur                                       }

Procedure config_periph;
   { config ports traceur et impr, police caractres et symboles, nb plumes }

Procedure verif_port            (numport         : integer ;
                                 var ok          : boolean);
   { test la prsence du port de sortie                                     }

Procedure ini_port_sortie       (numport, bauds  : integer;
                                 var er          : boolean);
   { initialise LPT1, 2, COM1 ,2              si impossible                 }

Function nom_port                                             : chainecar;
   { REnd le nom complet de l'imprimante                                    }

Function nom_impr                                             : chainecar;
    { Rend le nom du port                                                   }

Procedure palette               (pal             : fixe);
   { modification de la palette courante                                    }

Procedure couleur               (pal             : fixe ;
                                 var cc, cf      : integer);
   { slection d'une couleur de fond et d'une couleur de forme.             }

Procedure plumes                (nbpl            : integer ;
                                 pal             : fixe ;
                                 var couleurb    : palette_base);
   { affectation des plumes du traceur aux couleurs de la palette cte.      }

Procedure unecouleur            (t               : chainecar;
                                 pal             : fixe;
                                 var cc          : integer);
   { slection d'une couleur de forme avec affichage du texte.              }


{---------------------------------------------------------------------------}
Procedure voir_catalogue;
   { parcourt l'arborescence des disques disponibles  partir du chemin ct  }

Procedure repertoire            (comm            : Chainecar;
                                 var chemin      : Pathstr;
                                 var ok          : boolean);
   { slectionner un rpertoire                                             }

Procedure change_repertoire     (var ok          : boolean);
   { change le rpertoire actif - interactif/liste                          }

Procedure nomfichier_entree     (comm            : chainecar;
                                 chemin          : pathstr;
                                 filtr           : namestr;
                                 var nf          : namestr);
   { comm  = commentaire vt vide                                           }
   { filtr = filtre de fichier        nf = nom sans extension               }
   { rend un nom de fichier existant (dans le chemin spcifi )   sans      }
   { extension ;                                                            }
   { si aucun fichier n'est slectionn, le nom par dfaut est conserv.    }

Procedure nomfichier_sortie     (comm            : Chainecar;
                                 chemin          : Pathstr;
                                 var nf          : Namestr;
                                 var ext         : Extstr;
                                 var ok          : boolean);
   { rend un nouveau nom de fichier sans extension, vrifie son existence   }
   { dans le rpertoire spcifi. EXT = nouvelle extension                  }
   { ok : un nouveau nom a t dsign.                                     }

Procedure nomfichier_complet_entree
                                (comm            : Chainecar;
                                 filtr           : Namestr;
                                 var chemin      : Dirstr;
                                 var nf          : Namestr);
   { rend le chemin et le nom avec extension pour un fichier existant.      }

Procedure nomfichier_complet_entr
                                (comm            : Chainecar;
                                 var chemin      : Dirstr;
                                 var nom         : Namestr;
                                 var ext         : Extstr);
   { rend un nouveau nom de fichier ainsi que son chemin                    }
   { et son extension                                                       }
   { ext = filtre en entre                                                 }

Procedure nomfichier_complet_sort
                                (comm            : Chainecar;
                                 var chemin      : Pathstr;
                                 var nom         : Namestr;
                                 var ext         : Extstr);
   { rend un nouveau nom de fichier avec son chemin et son extension,       }
   { Si le fichier existe dj, demande si il doit tre cras,             }
   { ( renvoie un nom vide sinon )                                          }
   { ext sert de filtre en entre;                                          }

Procedure stru5                 (nomf            : Pathstr;
                                 nbess           : integer ;
                                 var strufic     : string;
                                 var nbcol,
                                 nbnum           : integer);
   { nomf : nom complet }
   { rend l'image de la structure d'un fichier de donnes  5 champs maxi   }
   { les deux premiers sont rels et le nombre maxi de champs (NBCOL)       }
   {   r r [.|s|r|e] [.|s|r|e] [.|s|r|e]                                    }
   {   r= rel  .= vide s = chane e= entier                                }

Procedure minmaxf               (nomf            : Pathstr;
                                 nbc, r          : integer;
                                 var minv, maxv  : real);
   { rend les valeurs mini et maxi d'une colonne de valeurs dans un fichier
   {  au format .DAT                                                        }
   { nomfs : nom complet                                                    }
   { nbc   : nombre de colonnes numriques                                  }
   {    r  : rang de la valeur  explorer                                   }

Procedure aide_txt              (titre           : chainecar;
                                 nomf            : Pathstr);
   { }

{ MENUS6 -------------------------------------------------------------------}

Procedure cree_boite            (nomf            : Pathstr;
                                 var lg, pos     : integer);
   { cre une liste de lignes  partir d'un texte et rend ses dimensions.   }

Procedure boitinfo              (texte           : chainecar;
                                 x, y, mxx, mxy  : integer);
   { fentre texte  dfilement                                             }

Procedure boitep                (x0, y0, lx, ly ,nbc, nbl : integer;
                                 confirm                  : boolean);
   { fentre texte simple sans dfilement                                   }

(*Procedure boite_aide     (nomf            : Pathstr;
                          index           : integer;
                          var lg, pos     : integer;
                          var titre       : chainecar);
   { rend la largeur et la hauteur du texte d'aide                          }

Procedure initaide       (nomf            : Pathstr ;
                          var ok          : boolean);
   { lit le fichier d'aide une fois                                         }
   {                et initialise une table d'index de l'aide               }

Procedure aff_aide       (nomf            : Pathstr ;
                          i, j            : integer);
   { affiche le texte d'aide correspondant                                  }
   {            au choix j dans le sous-menu i                              }
   {            dans une fentre  dfilement centre.                      }

*)
Procedure bte_compl             (titre                      : chainecar;
                                 x0, y0, x, y, mxx, mxy     : integer );

   { boite complte -  1 ligne = titre si non vide
                    -  position initiale du coin sup g de la bote,
                    -  dimensions du texte
                    -  dimensions de la fentre                             }

Procedure bte_simple            (titre            : Chainecar;
                                 x0, y0, nbc, nbl : integer ;
                                 confirm          : boolean ;
                                 var p            : pointer);
   { boite simple sans dfilement
                   -  ligne 1 = titre si non vide
                   -  position du coin sup g de la bote,
                   -  nb de lignes
                   -  confirm = bouton ok                                   }

   {------------------------------------------------------------------------}

Function rep_dos                (var rep        : pathstr)      : boolean;
   { rend vrai si Smartdrv existe dans rep                                  }

Procedure chemin_courant        (var chemin     : pathstr;
                                 var ok         : boolean);
   { rechercher le chemin courant CHEMINc                                   }

Procedure changer_repert        (chemini,
                                 cheminb        : pathstr;
                                 var ok         : boolean);
   { se placer  la racine du rpert de destination         }

Procedure nom_repert_existant   (comm           : chainecar;
                                 var chemin     : pathstr;
                                 var ok         : boolean);
   { rend le nom complet d'un CHEMIN  "source"                              }

Procedure nom_repert            (comm           : chainecar;
                                 var chemin     : pathstr;
                                 var ok         : boolean);
   { rend le nom complet du chemin destination CHEMIN par dfaut            }
   { NE cre pas le rpert.  OK = rp valide                                }

Procedure creer_repert          (chemin         : pathstr;
                                 placemini      : longint;
                                 var ok         : boolean);
   { initialiser le rpertoire destination et s'y dplacer                  }

Procedure tuer_repert           (chemin         : pathstr ;
                                 var ok         : boolean);
   { dtruire le rpertoire destination                                     }

Procedure tester_repert         (chemin         : pathstr;
                                 placemini      : longint;
                                 var ok         : boolean);
   { vrifie l'existence du rpertoire, le cre sans bruit, revient         }

(*procedure copie_liste_fichiers (nomfl : namestr; var ok : boolean);*)

{---------------------------------------------------------------------------}

IMPLEMENTATION

TYPE
   rvb                   = array  [0..15]
                              of record
                                 r, v, b : integer
                              end;

VAR
   ok                   : boolean;
   entier,
   nbco                 : integer;
   chain                : chainecar;

procedure chemin_courant        (var chemin     : pathstr;
                                 var ok         : boolean);
   { rechercher le chemin courant CHEMINc           }
   var
      u_ct              : string [2];
      r_ct,
      chemp             : pathstr;
      chem              : dirstr;
      nomf              : namestr;
      ext               : extstr;

   begin
      ok      := false;
      chemp   := '';
      {$I-}
      getdir (0, chemp);
      {$I+}
      if (ioresult=0) and (chemp <> '')
      then begin
         fsplit (chemp, chem, nomf, ext);
         u_ct   := copy (chem, 1 , 2);
         r_ct   := copy (chem, 3, length (chem))+nomf;
         chemin := u_ct+r_ct;
         ok     := true;
      end else begin
         message (m_not_lit);
      end;
   end;

procedure nom_repert_existant   (comm           : chainecar;
                                 var chemin     : pathstr ;
                                 var ok         : boolean);
   { rend le nom complet du CHEMIN  "source" }
   var
      repertexist       : boolean;
      nb                : integer;

   begin
      nb := 0;
      repeat
         chemin      := '';
         repertexist := false;
         repertoire (comm, chemin, repertexist);
         inc (nb);
      until repertexist or (nb > 2);
      ok     := repertexist;
   end;


function NomFichierValide       (nomf           : pathstr)      : boolean;
   var
      d                 : dirstr;
      n                 : namestr;
      e                 : extstr;

   begin
      fsplit  (nomf, d, n, e);
      nomFichiervalide := (n=nomf);
   end;

function NomCheminValide        (var chem       : pathstr)      : boolean;
   var
      d                 : dirstr;
      n                 : namestr;
      e                 : extstr;
      u                 : byte;

   begin
      fsplit   (chem, d, n, e);
      chem := d+n;
      u    := byte (upcase(d [1]))-64;
      nomCheminValide := (length (d) >= 2) {and (length (n) >1)}
                         and (d [2] = ':')
                         and (u in liste_disques);
   end;

function rep_dos                (var rep        : pathstr)      : boolean;
   var
      d                 : dirstr;
      n                 : namestr;
      e                 : extstr;

   begin
      fsplit (rep, d, n, e);
      if exists ( d+'smartdrv.exe')
      then begin
         rep := d;
         rep_dos := true;
      end else begin
         rep := '';
         rep_dos := false;
      end;
   end;

(*procedure nom_repert_dir (comm : string; var chemin : dirstr ; var ok : boolean);
   { Parcourt le disque avant de demander un nom de rpertoire  ajouter }
   { rend le nom complet du chemin destination CHEMIN par dfaut       }
   { NE cre pas le rpert.  OK = rp valide                           }
   var
      u_chm           : string [2];
      repertexist     : boolean;

   begin
      chain       := nomlogiciel;
      repeat
         repertexist := false;
         repertoire (comm, chemin, repertexist);
         if repertexist
         then begin
            u_chm := copy (chemin, 1, 2);
{            enleve_antislash (chemin); }
            saisie     ('REPERTOIRE  CREER sur '+chemin, chain, 12);
            if (chain <> '') and nomfichiervalide (chain)
            then begin
               chemin := chemin+chain;
            end else
               repertexist := false;
         end;
      until repertexist;
      ok := repertexist;
   end; *)

procedure nom_repert            (comm           : chainecar;
                                 var chemin     : pathstr ;
                                 var ok         : boolean);
   { rend le nom complet du chemin destination CHEMIN par dfaut }
   { NE cre pas le rpert.  OK = rp valide                     }

   begin
      ok    := false;
      enleve_antislash (chemin);
      repeat
         chain := chemin;
         laide (m_valid_chemin);
         saisie     (comm{+' '+chemin}, chain,  36);
         filtrer_indesirables (chain);
         laide ('');
         if (chain <> '') and nomcheminvalide (chain)
         then begin
            chemin := chain;
            ok := true
         end;
      until ok;

{      if ok
      then begin
         ok  := true;
         question (comm, chemin, ok);
      end;}
   end;

procedure changer_repert        (chemini,
                                 cheminb        : pathstr;
                                 var ok         : boolean);
   { se placer  la racine du rpert de destination         }
   var
      place             : longint;
      plas              : t12;

   begin
      ok := false;
      {$I-}
      chdir (cheminb);
      {$I+}
      if ioresult = 0
      then begin
      { annoncer le nom du rpert et la place restante sur le disque }
         ok    := true;
         place := diskfree (0);
         str     (place, plas);
         message (n_rep+' '+cheminb+'  '+plas+' '+n_octet);
      end else begin
         message (m_not_repert);
         chdir   (chemini);
      end;
   end;

procedure creer_repert          (chemin         : pathstr;
                                 placemini      : longint ;
                                 var ok         : boolean);
   { initialiser le rpertoire destination       }
   { et s'y dplacer                             }
   var
      place             : longint;
      plas              : t12;
      new               : boolean;

   begin
      ok := false;
      {$I-}       chdir (chemin);       {$I+}
      if ioresult = 0
      then begin
         ok  := true;
         new := false;
      end else begin
         {$I-}         mkdir (chemin);      {$I+}
         if ioresult = 0
         then begin
            new := true;
            ok  := true;
            chdir (chemin);
         end else begin
            message (errd2_2);
         end;
      end;

      if ok
      then begin
         place := diskfree (0);
         str (place, plas);
      {**   if new
         then
            message ('Nouveau rp : '+chemin+'  '+plas+' '+'octets'); **}
         ok :=  place > placemini;
      end;
   end;

procedure tuer_repert           (chemin         : pathstr ;
                                 var ok         : boolean);
   { dtruire le rpertoire destination                                     }
   begin
      ok := false;
      {$I-}       rmdir (chemin);       {$I+}
      if ioresult = 0
      then
         ok := true;
   end;

procedure tester_repert         (chemin         : pathstr;
                                 placemini      : longint ;
                                 var ok         : boolean);
   { initialiser le rpertoire destination       }
   var
      place             : longint;
      plas              : t12;
      new               : boolean;
      ch_ct             : pathstr;

   begin
      enleve_antislash (chemin);
      getdir (0, ch_ct);
      ok := false;
      {$I-}       chdir (chemin);       {$I+}
      if ioresult = 0
      then begin
         ok  := true;
         new := false;
      end else begin
         {$I-}         mkdir (chemin);      {$I+}
         if ioresult = 0
         then begin
            new := true;
            ok  := true;
         end;
      end;
      chdir (ch_ct);
      if ok
      then begin
         place := diskfree (0);
         str (place, plas);
         ok :=  place > placemini;
      end;
   end;

(*procedure copie_liste_fichiers (nomfl : namestr; var ok : boolean);
   var
      f                   : text;
      nomfic, lign        : string;
      i, l , nf           : integer;

   begin
      ok     := false;
      repsrc := ftxt_present (nomfl+extdir);
      if not repsrc then exit;

      assign (f, nomfl+extdir);
      reset  (f);
      i := 0;
      repeat
         readln (f, lign);              { sauter les lignes vides }
         l := length (lign);
      until l > 0 ;

      inc (i);
      nf := 0;
      while (not eof (f))
      do begin
         ok     := false;
         nomfic := copy (lign, 1, 12);
         nomfic [9] := '.';
         laide (nomfic);
         CopyFile (chemins+'\'+nomfic, cheminb+'\'+nomfic, ok );
         if ok  then inc (nf);

         readln (f, lign);
         inc (i);
      end;
      close (f);
      ok := i-1 = nf;
   end; *)

{---------------------------------------------------------------------------}

function nom_impr : chainecar;
   begin
      case qual of
         0 : chain := impr0;
         1 : chain := impr1;
         2 : chain := impr2;
         3 : chain := impr3;
         4 : chain := impr4;
      end;
      nom_impr := chain;
   end;

function nom_port                                               : chainecar;
   begin
      case portimpr of
         0 : chain := port0;
         1 : chain := port1;
         2 : chain := port2;
      end;
      nom_port := chain;
   end;

procedure sauverpal (nomf : pathstr);
   var
      chemin            : dirstr;
      ext               : extstr;

   begin
      chemin := '';
      ext    := '';
      nomfichier_sortie                                    { menus5 }
         (Nomf_palette, '', nomf, ext, ok);

  (*    nomfichier_complet_sort
         ('Nouveau fichier : ', chemin, nomf, ext);         { menus5 }
*)
      if ext  = ''
      then
         ext := extpal;

      if (nomf <>'') and ftxt_present (chemin+nomf+ext)
      then begin
         question (nomf_exist,
                   nomf_ecrase, ok);
         if not ok then nomf := '';
      end;

      if nomf = ''
      then begin
         message (m_annule);
         exit;
      end;
      sauvepalette (concat (chemin, nomf, ext), ok);            { graphism }
      if not ok
      then                                                     { menus2 }
         message (m_not_sauve);
   end;

procedure chargerpal;
   var
      chemin            : Dirstr;
      nomf              : Namestr;
      ext               : Extstr;

   begin
      chemin := '' ;
      nomf   := '*';
      ext    := extpal;
      nomfichier_complet_entr
         (nomf_palette_new, chemin, nomf, ext);         { menus5 }
      if nomf  = ''
      then  begin
         message (m_annule);
         exit;
      end;
      chargepalette (concat (chemin, nomf, ext), ok);       { graphism }
      if not ok
      then                                                  { menus2 }
         message (m_not_palette);
   end;

procedure palettes (nomf : Pathstr);
   begin
      entier := 1;
      creeliste (c_Modifier, 1);                           { utildivs }
      creeliste (c_Charger,  2);
      creeliste (c_Sauver,   3);
      liste (l_pal1 , l_pal2, l_pal3 , 15, chain, entier);
      case entier of
         1 : palette   (pal);                               { graphism }
         2 : chargerpal;
         3 : sauverpal (nomf);
      end;
   end;

procedure cfg_port (t : chainecar; var numport : integer);
   begin
      creeliste (port1, 1);                        { }
      creeliste (port2, 2);
{      creeliste (port3, 3); }
      creeliste (port4, 3);
      creeliste (port5, 4);
      if t = n_traceur
      then
         creeliste (n_Fichier, 5);                 { port = fichier}

      liste     (l_port1, l_port2, t +' ?', 15, chain, numport);

      if numport > 4
      then
         numport := 0;
   end;

procedure cfg_traceur;
   begin
      if nbpl > 0
      then
         cfg_port (n_traceur, porttab);
   end;

procedure cfg_plumes;
   begin
      if nbpl > 0
      then
         plumes (nbpl, pal, couleur_b );
   end;

procedure cfg_imprimante;
   begin
      if qual > 0
      then
         cfg_port (n_imprimante, portimpr);
   end;

procedure mod_polmenu;
   begin
      entier := pol_menu+1;
      creeliste (c_police1, 1);
      creeliste (c_police2, 2);
      creeliste (c_police3, 3);
      liste      (l1_police, l2_police, l3_police, 15, chain, entier);
      pol_menu := entier-1;
   end;

procedure mod_nbplum;
   begin
      case nbpl of
         6 : entier := 1;
         8 : entier := 2;
         0 : entier := 3;
      end;
      creeliste (c_trac1, 1);
      creeliste (c_trac2, 2);
      creeliste (c_trac3, 3);
          liste (l_trac1, l_trac2, l_trac3, 20, chain, entier);
      case entier of
         0 : nbpl := 0;
         1 : nbpl := 6;
         2 : nbpl := 8;
         3 : nbpl := 0;
      end;
   end;

procedure mod_qual;
   begin
      case qual of
         1 : entier := 1;
         2 : entier := 2;
         3 : entier := 3;
         4 : entier := 4;
         0 : entier := 5;
      end;
      creeliste (impr1 , 1);
      creeliste (impr2 , 2);
      creeliste (impr3 , 3);  { DERnire_IMPRimante reconnue}
      creeliste (impr4 , 4);
{      creeliste (impr5' , 5); }
      creeliste (impr6 , 5);


      liste     (l_impr1, l_impr2, l_impr3, 22, chain, entier);

      if entier > (der_impr+1)
      then
         qual := 0
      else
         qual := entier;

   end;

procedure config_periph;
   begin
      entier := 4;
      creeliste (c_peri1, 1);  
      creeliste (c_peri2, 2);
      creeliste (c_peri3, 3);
      creeliste (c_peri4, 4);
      liste     (l_peri1, l_peri2, l_peri3, 25, chain, entier);
      case entier of
         1 : cfg_traceur;
         2 : cfg_imprimante;
         3 : mod_nbplum;
         4 : mod_qual;
      end
   end;

function nomfichiersuivant (nom : namestr; ext : extstr) : t12;
   { nom = 6 premires lettres du nom  }
   { numero 1-99 crasement automatique au del (aprs confirmation) }
   var
      n                 : byte;
      ns                : namestr;

   begin
      n := numeromaxi (nom+'??'+ext)+1;          { fichiers }
      if n > 99 then n := 0;
      str (n:2, ns);
      if n < 10 then ns [1] := '0';
      nomfichiersuivant := nom+ns+ext;
   end;

procedure Imprimecran (qual : integer);
   var
      ok                : boolean;

   begin
      ok := false;
      case qual of
         1 : chain := impr1;
         2 : chain := impr2;
         3 : chain := impr3;
         4 : chain := nomfichiersuivant (n_ecran, extPCX);
      end;
      question (q_ecran1, q_ecran2 +chain +' ?', ok);
      if ok
      then begin
         ouvreport;  { LST }
         case qual of
(*     1 : HardCopy(True,4 ,42,0,MaxY,MaxX);{impvga_9c;     bad }
       2 : HardCopy(True,38,42,0,MaxY,MaxX);{impvga_8c1;      bad }
       3 : impr_HP550C(True,42,0,MaxY,MaxX);{jet  d'encre    noir !!!   }
       5 : HardCopy(True,32,42,0,MaxY,MaxX);{impvga_8;
       3 : impr_laserjet2; { jet d'encre et laser    - pascalissime bad }
       4 : impr_HP550c;    { HP couleur              - rc very bad }*)
          1 : impvga_9c   (portimpr-1);      { 9 aiguilles IBM    RC  }
          2 : impvga_8c1  (portimpr-1);     { 24 EPSON           RC  }
          3 : impr_HP550C (False, 0, 0, MaxY, MaxX, portimpr-1);       {jet  d'encre FB ok ? }
          4 : SauvePCX (0, 0, Maxx, maxy, chain); { XC }
         end;
         if qual < der_impr then ejecte;
         fermeport; { LST }
      end;
   end;

procedure sauvepcx16;
   begin
        SauvePCX (0, 0, Maxx, maxy, 'essai'+extpcx); { XC }
   end;

procedure verif_port (numport : integer ; var ok : boolean);
   var
      er                : boolean;

   begin
      ok := true;
      ini_port_sortie ( numport, bauds, er);
      if er
      then begin
         message (m_not_periph);
         ok := false;
         exit;
      end;
   end;

procedure ini_port_sortie (numport, bauds : integer; var er : boolean);
   var
      chain             : t12 ;

   begin
      er := false;
      case numport of
         0 : begin
               chain := nomfichiersuivant (n_CODEHP, extPLT);
               assign (lst, chain);
             end;
         1 : if initimprime (0)
             then
                assign (lst, port1)
             else
                er := true;
         2 : if initimprime (1)
             then
                assign (lst, port2)
             else
                er := true;
    {     3 : if initimprime (2)
             then
                assign (lst, port3)
             else
                er := true;
    }
         3 : begin
                assign (lst, port4);
                initcom (1, bauds, 0, er)
             end;
         4 : begin
                assign (lst, port5);
                initcom (2, bauds, 0, er)
             end;
     {    6 : begin assign (lst, 'COM3'); initcom (1, bauds, 0, er) end;
         7 : begin assign (lst, 'COM4'); initcom (2, bauds, 0, er) end;}
      end;
   end;

procedure stru5                 (nomf            : Pathstr;
                                 nbess           : integer ;
                                 var strufic     : string;
                                 var nbcol,
                                 nbnum           : integer);
   var
      f                 : text;
      s, s1, s2,
      s3, s4, s5
                        : string;
      p1, p2, p3, p4,
      e3, e4, e5,
      nb, nbc, l,
      err, ere          : integer;
      r3, r4, r5                        : real;
      val3entiere,
      val3reelle, val3s,
      val4entiere,
      val4reelle, val4s,
      val5entiere,
      val5reelle, val5s : boolean;

    begin
       assign (f, nomf);
       reset  (f);
       strufic     := 'rr...';
       val3entiere := false;
       val3reelle  := false;
       val3s       := false;
       val4entiere := false;
       val4reelle  := false;
       val4s       := false;
       val5entiere := false;
       val5reelle  := false;
       val5s       := false;
       nb    := 0;
       nbcol := 0;
       nbnum := 0;
       while (not eof (f)) and (nb <= nbess) do
       begin
          s1  := ''; s2 := ''; s3 := ''; s4 := ''; s5 := '';
          nbc := 0;
          inc  (nb);
          read (f, s);
          s  := s+' ';

          e_b_devant (s);
          l  := length (s);
          p1 := pos  (' ', s);
          s1 := copy (s, 1,  p1-1);
          e_b (s1);
          s  := copy (s, p1, l);
          inc (nbc);

          e_b_devant (s);
          l  := length (s);
          p2 := pos  (' ', s);
          s2 := copy (s, 1,  p2-1);
          e_b (s2);
          s  := copy (s, p2, l);
          inc (nbc);

          if s  <> ' ' then e_b_devant (s);
          l  := length (s);
          p3 := pos  (' ', s);
          s3 := copy (s, 1,  p3-1);
          e_b (s3);
          s  := copy (s, p3, l);

          if s  <> ' ' then e_b_devant (s);
          l  := length (s);
          p4 := pos  (' ', s);
          s4 := copy (s, 1,  p4-1);
          e_b (s4);
          s  := copy (s, p4, l);

          if s  <> ' ' then e_b_devant (s);
          s5 := s;
          if s5 <> ''  then e_b (s5);

          if s3 <> ''
          then begin
             inc (nbc);
             val (s3, r3, err);
             val (s3, e3, ere);

             if nb =1
             then val3reelle  := (err = 0)
             else val3reelle  := (err = 0) and val3reelle;

             if nb =1
             then val3entiere := (ere = 0)
             else val3entiere := (ere = 0) and val3entiere;

             if nb =1
             then val3s       := (err <> 0)
             else val3s       := (err <> 0) and val3s;
          end;

          if s4 <> ''
          then begin
             inc (nbc);
             val (s4, r4, err);

             if nb =1
             then val4reelle  := (err = 0)
             else val4reelle  := (err = 0)  and val4reelle;
             val (s4, e4, ere);

             if nb =1
             then val4entiere := (ere = 0)
             else val4entiere := (ere = 0) and val4entiere;

             if nb =1
             then val4s := (err <> 0)
             else val4s := (err <> 0) and val4s;
          end;

          if s5 <> ''
          then begin
             inc (nbc);
             val (s5, r5, err);

             if nb =1
             then val5reelle  := (err = 0)
             else val5reelle  := (err = 0) and val5reelle;

             val (s5, e5, ere);

             if nb =1
             then val5entiere := (ere = 0)
             else val5entiere := (ere = 0) and val5entiere;

             if nb =1
             then val5s := (err <> 0)
             else val5s := (err <> 0) and val5s;
          end;
          if nb = 1
          then
             nbcol := nbc
          else
             if nbc <= nbcol then  nbcol := nbc;

          readln (f);
       end;
       close (f);

       nbnum := 2;
       if val3reelle
       then begin
          strufic [3] := 'r';
          if val3entiere then strufic [3] := 'e';
          inc (nbnum);
       end else
          if val3s       then strufic [3] := 's';

       if val4reelle
       then begin
          strufic [4] := 'r';
          if val4entiere then strufic [4] := 'e';
          inc (nbnum);
       end else
          if val4s       then strufic [4] := 's';

       if val5reelle
       then begin
          strufic [5] := 'r';
          if val5entiere then strufic [5] := 'e';
          inc (nbnum);
       end else
          if val5s       then strufic [5] := 's';
   end;

procedure minmaxf               (nomf            : Pathstr;
                                 nbc, r          : integer;
                                 var minv, maxv  : real);
   var
      fdat              : text;
      xs, ys, min, max  : real;
      lign              : array [1..5] of real;

   begin
      minv := 1.7e+38;
      maxv := -1.7e+38;

      assign (fdat, nomf);
      reset  (fdat);
      lign [1] := 0;
      lign [2] := 0;
      repeat
         { charger les valeurs d'une ligne dans un tableau }
         read   (fdat, xs);
         read   (fdat, ys);
         lign [3] := 0;
         lign [4] := 0;
         lign [5] := 0;
         if nbc > 2
         then read  (fdat, lign [3]);

         if nbc > 3
         then read  (fdat, lign [4]);

         if nbc > 4
         then read  (fdat, lign [5]);

         { comparer }
         if lign [r] < minv then minv := lign [r];
         if lign [r] > maxv then maxv := lign [r];
         readln (fdat);
      until eof (fdat);
      close (fdat);
   end;

procedure aide_txt              (titre : chainecar; nomf : Pathstr);
   var
      lg, ht            : integer;

   begin
      if ftxt_present (nomf)
      then begin
         laide (la_fermer);
         cree_boite (nomf, lg, ht );
         bte_compl  (titre, -1, -1, lg, ht, 57, 15);
         if not memok
         then
            message (m_not_memoire);
      end;
   end;

   { menus4}
procedure palette (pal : fixe);
   var
      r, v, b, r2,
      v2, b2, i        : real;
      Touche,
      cx, cy, num,
      xi, yi,
      nbcolor, ncase,
      rr, vv, bb,
      nul, j,
      xm,
      x1, x2, x3,
      y1, y2            : integer;
      p                 : pointer;
      ok, abandon       : boolean;
      texte             : t12;
      palini            : palettetype;
      couleurs          : rvb;
      numc              : array [1..16] of integer;

   procedure affichec;
      begin
       {  CacherSouris;  }
         setrgbpalette (numc [ncase], round (r2*i),
                                      round (v2*i),
                                      round (b2*i));
         setfillstyle (SolidFill, c_f_boite_norm);
         str          (round (r2*i), texte);
         bar          (x3+52, y1+112, x3+76, y1+120);
         setcolor     (c_t_boite_norm);
         outtextxy    (x3+52, y1+112, texte);

         str          (round (v2*i), texte);
         bar          (x3+52, y1+122, x3+76, y1+130);
         outtextxy    (x3+52, y1+122, texte);

         str          (round (b2*i), texte);
         bar          (x3+52, y1+132, x3+76, y1+140);
         outtextxy    (x3+52, y1+132, texte);

         bar          (x3+52, y1+102, x3+76, y1+110);
         str          (round (i*100), texte);
         outtextxy    (x3+52, y1+102, texte);
       {  MontrerSouris;}
      end;

   begin
      x1 := 20;
      y1 := maxy-205;
      x2 := x1+100;
      x3 := x2+100;

      y2 := y1+150;

      getpalette    (palini);
      xm      := 300+x1;
      nbcolor := 0;
      ncase   := 1;
      abandon := false;
      ok      := false;

      getmem    (p,
      imagesize (x1-20,              y1-20,         xm,         y2+55));
      getimage  (x1-20,              y1-20,         xm,         y2+55,p^);

      setfillstyle (SolidFill, c_f_boite_norm);
      bar       (x1-20,              y1-20,         xm,         y2+55);
      setcolor  (c_t_boite_norm);
      rectangle (x1-20+1,            y1-20+1,       xm-1,       y2+55-1);

      rectangle (x3+20,              y1,            xm-20,       y1+24);
      rectangle (x3+20,              y1+34,         xm-20,       y1+58);
      rectangle (x3+20,              y1+68,  round((xm+x3)/2)-2, y1+92);
      rectangle (round((xm+x3)/2)+2, y1+68,         xm-20,       y1+92);
      line      (x1, y1, x2, y2);
      line      (x2, y2, x3, y1);
      line      (x3, y1, x1, y1);

      Nouveau_Style (0, 0, 1);

      outtextxy (x1-10, y1-10, n_R);
      outtextxy (x3+5 , y1-10, n_V);
      outtextxy (x2-5 , y2+5 , n_B);
      outtextxy (round ((xm+x3)/2)-28,           y1+10, n_ABANDON);
      outtextxy (round ((xm+x3)/2)-8,            y1+44, n_OK);
      outtextxy (round ((x3+20+(xm+x3)/2)/2)-4,  y1+78, '-');
      outtextxy (round ((xm-20+(xm+x3)/2)/2)-4,  y1+78, '+');
      outtextxy (x3+20, y1+102, n_I+' =');
      outtextxy (x3+20, y1+112, n_R+' =');
      outtextxy (x3+20, y1+122, n_V+' =');
      outtextxy (x3+20, y1+132, n_B+' =');

      for j := 0 to maxcolor do
         if pal [j]
         then begin
            nbcolor := nbcolor+1;
            numc [nbcolor] := j
         end;

      for j:=1 to nbcolor do
      begin
         getrgbpalette (palini.colors [numc [j]], rr, vv, bb);
         couleurs [numc [j]].r := rr;
         couleurs [numc [j]].v := vv;
         couleurs [numc [j]].b := bb;
      end;

      for j := 1 to nbcolor do
      begin
         setfillstyle (SolidFill, numc [j]);
         rectangle (x1-16+round ((xm-x1+16)/nbcolor*(j-1)),   y2+20,
                    x1-20+round ((xm-x1+16)/nbcolor*j)    ,   y2+50);
         bar       (x1-16+round ((xm-x1+16)/nbcolor*(j-1))+1, y2+20+1,
                    x1-20+round ((xm-x1+16)/nbcolor*j)    -1, y2+50-1);
      end;

      num := 5;
      j   := 0;
      getrgbpalette (numc [1], rr, vv, bb);
      if (rr > vv) and (rr >= bb)
      then begin
            i  := rr / 63;
            r2 := 63;
            v2 := vv * 63 / rr;
            b2 := bb * 63 / rr
      end else
         if    (vv >= rr) and (vv > bb)
         then begin
            i  := vv / 63;
            r2 := rr * 63 / vv;
            v2 := 63;
            b2 := bb * 63 / vv
         end else
            if (bb >= vv) and (bb > rr)
            then begin
               i  := bb / 63;
               r2 := rr * 63 / bb;
               v2 := vv * 63 / bb;
               b2 := 63
            end else begin
               i  := rr / 63;
               r2 := 63;
               v2 := 63;
               b2 := 63
            end;
      MontrerSouris;
      affichec;
      repeat   until (not UnBoutonSourisEnfonce);
      repeat
         clavsouris (Touche);
         LirePositionSouris (xs, ys);

         if (xs > x3+20) and (ys > y1)    and
            (xs < xm-20) and (ys < y1+24) or d
         then
            abandon := true;

         if (xs > x3+20) and (ys > y1+34) and
            (xs < xm-20) and (ys < y1+58)
         then
            ok := true;

         if (xs > x3+20)               and (ys > y1+68) and
            (xs < round ((xm+x3)/2)-2) and (ys < y1+92)
         then begin
            i := i-0.005;
            if i < 0 then i := 0;
            affichec
         end;
            if (xs > round ((xm+x3)/2)+2) and (ys > y1+68) and
               (xs < xm-20)               and (ys < y1+92)
            then begin
               i := i+0.005;
               if i > 1 then i := 1;
               affichec
            end;
         if (ys > y2+20) and (ys < y2+55) and
            (xs < xm)    and (xs > x1-20)
         then begin
            cachersouris;
            setcolor (c_f_boite_norm);

            rectangle (x1-16+round ((xm-x1+16)/nbcolor*(ncase-1))-1,
                       y2+20-1,
                       x1-20+round ((xm-x1+16)/nbcolor*ncase) +1,
                       y2+50 +1);

            ncase := trunc ((xs-x1+20) / (xm-x1+20)*nbcolor+1);

            setcolor (15);
            rectangle (x1-16+round ((xm-x1+16)/nbcolor*(ncase-1))-1,
                       y2+20-1,
                       x1-20+round ((xm-x1+16)/nbcolor*ncase) +1,
                       y2+50 +1);

            montrersouris;

            getrgbpalette (numc [ncase], rr, vv, bb);
            if (rr > vv) and (rr >= bb)
            then begin
               i := rr/63;    r2 := 63;       v2 := vv*63/rr; b2 := bb*63/rr
            end else
               if (vv >= rr) and (vv > bb)
               then begin
                  i := vv/63;   r2 := rr*63/vv;  v2 := 63;      b2 := bb*63/vv
               end else
                  if (bb >= vv) and (bb > rr)
                  then begin
                     i := bb/63;   r2 := rr*63/bb;  v2 := vv*63/bb; b2 := 63
                  end else begin
                     i := rr/63;   r2 := 63;        v2 := 63;       b2 := 63
                  end;
            affichec
         end;

         b := (ys-y1) / (y2-y1);
         r := (x3-xs) / (x3-x1) - b/2;
         v := 1-r-b;
         if (b >= 0) and (r >= 0) and (v >= 0) and
            (b <= 1) and (r <= 1) and (v <= 1)
         then begin
            if (b > r) and (b > v) and (b > 0)
            then begin
               r := r/b;
               v := v/b;
               b := 1;
            end else
            if ((v >= r) and (v >= b) and (v > 0))
            then begin
               r := r/v;
               b := b/v;
               v := 1;
            end else
               if (r >= b) and (r >= v) and (r > 0)
               then begin
                  b := b/r;
                  v := v/r;
                  r := 1;
               end;
            r := 63*r;
            v := 63*v;
            b := 63*b;
            r2 := r ;
            v2 := v ;
            b2 := b;
            affichec
         end;
      until ok or abandon;
      CacherSouris;

      if abandon
      then begin
         for j := 1 to nbcolor
         do
            setrgbpalette (numc [j], couleurs [numc [j]].r,
                                     couleurs [numc [j]].v,
                                     couleurs [numc [j]].b);
      end;
      putimage (x1-20, y1-20, p^, 0);
      libere (p);
      Ancien_Style;
   end;

{---------------------------------------------------------------------------}
procedure couleur (pal : fixe; var cc, cf : integer);
   var
      i                 : real;
      Touche,
      x1, x2,
      y1, y2,
      xi, yi,
      cx, cy, num,
      cci, cfi,
      nbcolor, ncase,
      nul, j, xm        : integer;
      p                 : pointer;
      ok, abandon       : boolean;
      palini            : palettetype;
      numc              : array [1..16] of integer;

   begin
      x1 := 0;
      y1 := maxy-60;
      x2 := x1+400;
      y2 := y1+60;

      cci := cc;
      cfi := cf;
      nbcolor := 0;
      ncase   := 1;
      abandon := false;
      ok      := false;

      getmem        (p, imagesize (x1, y1, x2, y2));
      getimage      (              x1, y1, x2, y2,   p^);

      nouveau_style (0, 0, 1);

      setfillstyle  (1, colorf);
      bar           (x1,    y1,    x2,           y2);
      setcolor      (colord);
      rectangle     (x1+1,  y1+1,  x2-1,         y2-1);

      rectangle     (x1+4,  y1+4,  x1+4+(y2-y1), y2-4);
      rectangle     (x2-76, y1+4,  x2-4,         y1+28);
      rectangle     (x2-76, y2-28, x2-4,         y2-4);

      settextjustify (1, 1);
      outtextxy     (x2-42, y1+18, n_ABANDON);
      outtextxy     (x2-42, y2-18, n_OK);

      setfillstyle  (1, cf);
      bar           (x1+5,  y1+5,  x1+3+(y2-y1), y2-5);
      setfillstyle  (1,cc);
      bar           (x1+16, y1+16, x1-8+(y2-y1), y2-16);
      rectangle     (x1+15, y1+15, x1-7+(y2-y1), y2-15);

      getpalette    (palini);

      for j := 0 to 15 do
         if pal [j]
         then begin
            nbcolor := nbcolor+1;
            numc [nbcolor] := j
         end;

      for j := 1 to nbcolor do
      begin
         setfillstyle (1, numc [j]);
         rectangle
           (x1+  (y2-y1)+8+round((x2-80-(x1+8+(y2-y1))+4)/nbcolor*(j-1)), y1+4,
            x1+4+(y2-y1)+  round((x2-80-(x1+8+(y2-y1))+4)/nbcolor* j),    y2-4);
         bar
           (x1+  (y2-y1)+9+round((x2-80-(x1+8+(y2-y1))+4)/nbcolor*(j-1)), y1+5,
            x1+3+(y2-y1)+  round((x2-80-(x1+8+(y2-y1))+4)/nbcolor* j),    y2-5);
      end;

      i := 1;            num := 5;       j := 0;

      MontrerSouris;
      repeat until not UnBoutonSourisEnfonce;
      repeat
         clavsouris (Touche);
         LirePositionSouris (xs, ys);

         if     (xs > x2-76) and (ys > y1+4)
            and (xs < x2-4)  and (ys < y1+28) or d
         then
            abandon := true;

         if     (xs > x2-76) and (ys > y2-28)
            and (xs < x2-4)  and (ys < y2-4)
         then
            ok      := true;

         if     (ys > y1+4)  and (ys < y2-4)
            and (xs < x2-80) and (xs > x1+4+ (y2-y1))
         then begin
            ncase := trunc ((xs- (x1+8+(y2-y1))) /
                            (x2- 80- (x1+8+ (y2-y1))) * nbcolor+1);
            if d then
            begin
               cf := numc[ncase];
               setfillstyle (1, cf);
               bar          (x1+5, y1+5,   x1+3+(y2-y1), y2-5);
               setfillstyle (1,cc);
               bar          (x1+16, y1+16, x1-8+(y2-y1), y2-16);
               rectangle    (x1+15, y1+15, x1-7+(y2-y1), y2-15);
            end;

            if g then
            begin
               cc := numc [ncase];
               setfillstyle (1, cc);
               bar (x1+16, y1+16, x1-8+(y2-y1), y2-16);
            end
         end
      until ok or abandon;

      if abandon
      then begin
         cc := cci;
         cf := cfi
      end;

      CacherSouris;
      putimage      (x1, y1, p^, 0);
      libere (p);
      ancien_style;
   end;

{---------------------------------------------------------------------------}
procedure unecouleur (t : Chainecar; pal : fixe; var cc : integer);
   var
      x1, x2, y1, y2,
      cf                : integer;
      p                 : pointer;

   begin
      cf := colorf;
      nouveau_style (0, 0, 1);
      x1 := 0;
      y1 := maxy-60-2*ty;
      x2 := x1+400;
      y2 := y1     +2*ty;

      getmem   (p, imagesize (x1, y1, x2, y2));
      getimage (              x1, y1, x2, y2,   p^);
      setfillstyle  (1, colorf);
      bar           (x1,    y1,    x2,    y2);
      setcolor      (colord);
      rectangle     (x1+1,  y1+1,  x2-1,  y2-1);
      settextjustify (1, 1);
      outtextxy     ((x1+x2) div 2 , (y1+y2) div 2 , t);
      ancien_style;

      couleur       (pal, cc, cf);

      putimage               (x1, y1,           p^, 0);
      libere   (p);
   end;

{---------------------------------------------------------------------------}
procedure plumes (nbpl : integer ; pal : fixe; var couleurb : palette_base);
   var
      i, at             : real;
      Touche,
      x1, x2,
      y1, y2,
      xi, yi,
      cx, cy,
      num,
      cci, cfi,
      nbcolor, ncase,
      inter,
      xcentre, ycentre,
      numplume,
      nul, j, k, xm     : integer;
      p                 : pointer;
      ok, abandon       : boolean;
      texte             : t12;
      numc              : array [1..16] of integer;
      s                 : couleur_palette;
      plini             : palette_base;

   begin
      numplume := 1;
      x1 := 0;          y1 := maxy-88;
      x2 := x1+436;     y2 := y1+88;
      xs := 400;        ys := y1+68;
      nbcolor := 0;
      ncase   := 1;
      abandon := false;
      ok      := false;

      getmem   (p, imagesize (x1, y1, x2, y2));
      getimage               (x1, y1, x2, y2, p^);

      nouveau_style (0, 0, 1);

      { dessin de la boite }
      setfillstyle (1, colorf);
      bar       (x1,            y1,      x2,             y2);
      setcolor  (colord);
      rectangle (x1+1,          y1+1,    x2-1,           y2-1);
      rectangle (x1+4,          y1+4,    x1+4+(y2-y1)-8, y2-4);
      rectangle (x2-76,         y2-2*28, x2-4,y2-32);
      rectangle (x2-76,         y2-28  , x2-4,y2-4);

      outtextxy (x2-68,         y2-28-18, n_ABANDON);
      outtextxy (x2-36,         y2-18,    n_OK);
      outtextxy (x1+(y2-y1)+26, y1+14, choix_plumes);

      { dessin du barillet porte-plumes }
      xcentre := x1+4+ (y2-y1-8) div 2;
      ycentre := y1+4+ (y2-y1-8) div 2;
      for j := 1 to nbpl do
      begin
         str (j, texte);
         circle    (round ( xcentre+ 26 * cos (j*(2*pi/nbpl)) ),
                    round ( ycentre- 26 * sin (j*(2*pi/nbpl)) ),9);
         outtextxy (round ( xcentre+ 26 * cos (j*(2*pi/nbpl)) -4 ),
                    round ( ycentre- 26 * sin (j*(2*pi/nbpl)) -4 ),texte);
      end;

         circle (round ( xcentre+ 26*cos (numplume* (2*pi/nbpl)) ),
                 round ( ycentre- 26*sin (numplume* (2*pi/nbpl)) ),10);

      { copie des valeurs initiales des plumes dans plini }
      for s := noir  to blanc
      do  plini [s, hp6] := couleurb [s, hp6];

      { recherche des couleurs autorisees }
      for j := 0 to 15
      do
         if pal [j]
         then begin
            nbcolor := nbcolor+1;
            numc [nbcolor] := j
         end;

      { affichage de la palette en cours }
      inter := trunc ((x2-76- (x1+y2-y1)) / nbcolor ) ;
      for j := 1 to nbcolor
      do begin
         setfillstyle (1, numc [j]);
         s   := noir;
         for k := 1 to numc [j]
         do  s := succ (s);
         str (couleur_b [s, hp6], texte);
         rectangle
              (x1  +y2-y1  + inter * (j-1), y2-2*28,
               x1-4+y2-y1  + inter * j,     y2-32);
         bar  (x1  +y2-y1+1+ inter * (j-1), y2-2*28+1,
               x1-5+y2-y1  + inter * j,     y2-33);
         rectangle
              (x1  +y2-y1  + inter * (j-1), y2-28,
               x1-4+y2-y1  + inter * j,     y2-4);
         outtextxy
              (x1-4+y2-y1  + inter * (j-1)+inter div 2, y2-12, texte);
      end;

      { saisie }
      i   := 1;
      num := 5;
      j   := 0;
      MontrerSouris;
      repeat   until (not UnBoutonSourisEnfonce);
      repeat
         clavsouris (Touche);
         LirePositionSouris (xs, ys);

         abandon := (xs > x2-76) and (ys > y2-2*28) and
                    (xs < x2-4)  and (ys < y2-32)   or d;

         ok      := (xs > x2-76) and (ys > y2-28)   and
                    (xs < x2-4)  and (ys < y2-4);

         {                             choix d'une COULEUR de la palette }
         if (ys > y1+28) and (ys < y2-28) and
            (xs < x2-80) and (xs > x1+(y2-y1))
         then begin
            ncase := trunc (nbcolor * ((xs-(x1+y2-y1)) / (nbcolor*inter)))+1;
            if ncase > nbcolor then ncase := nbcolor;
            if g
            then begin
               s := noir;
               for k := 1 to numc [ncase]
               do
                  s := succ (s);
               couleurb [s, hp6] := numplume;
               str (numplume, texte);
               setfillstyle (colorf, 1);
               bar (x1+1+(y2-y1) + inter * (ncase-1),             y2-27,
                    x1-5+(y2-y1) + inter * ncase,                 y2-5);
               outtextxy
                   (x1-4+(y2-y1) + inter * (ncase-1)+inter div 2, y2-12, texte);
            end;
         end;

         {                                    choix d'un numero de PLUME }
         if (ys > y1+4)         and (ys < y2-4) and
            (xs < x1+(y2-y1-4)) and (xs > x1+4)
         then begin
            CacherSouris;
            setcolor (colorf);
            circle (round ( xcentre + 26 *cos (numplume*(2*pi/nbpl)) ),
                    round ( ycentre - 26 *sin (numplume*(2*pi/nbpl)) ), 10);
            if ((xs-xcentre) = 0) and ((ycentre-ys) = 0)
            then xs := xs+1;

            if abs (xs-xcentre) < abs (ycentre-ys)
            then begin
               at := pi/2-arctan ((xs-xcentre)/(ycentre-ys));
               if ycentre-ys < 0 then at := at+pi;
            end else begin
               at := arctan ((ycentre-ys)/(xs-xcentre));
               if xs-xcentre < 0 then at := at+pi;
            end;
            if at < 0 then at := at+2*pi;
            numplume := round (nbpl*at / (2*pi));
            if numplume = 0 then numplume := nbpl;
            setcolor (colord);
            circle (round (xcentre+ 26*cos (numplume * (2 * pi /nbpl))),
                    round (ycentre- 26*sin (numplume * (2 * pi /nbpl))), 10);
            MontrerSouris;
         end;
      until ok or abandon;

      {                                                           sortie }
      if abandon
      then      { recopie des valeurs initiales des plumes dans couleurb }
         for s:= noir  to blanc
         do  couleurb [s, hp6] := plini [s, hp6];

      CacherSouris;
      putimage      (x1, y1, p^, 0);
      libere (p);
      ancien_style;
   end;

{--- MENU4 -----------------------------------------------------------------}

procedure voir_catalogue;
   var
      chem              : Pathstr;
      nf,
      filtr             : Namestr;

   begin
      nf    := '';
      chem  := '';
      filtr := '*.*';
      laide  (la_filtre);
      saisie (n_filtre   + ' :', filtr, 12);
      filtrer_indesirables (filtr);
      dir    (n_Catalogue+ ' :', chem, nf, filtr, false);
      laide  ('');
   end;

procedure repertoire            (comm            : Chainecar;
                                 var chemin      : Pathstr;
                                 var ok          : boolean);
   var
      nf                : namestr;
      filtr             : namestr;
      chemini           : dirstr;

   begin
      if comm = ''
      then
         comm := choix_repert+' : ';
      ok      := true;
      chemini := chemin;
      nf      := ''  ;
      filtr   := '*.';
      dir   (comm, chemin, nf, filtr, false);
      if nf = ''
      then begin
         chemin := chemini;
         ok     := false
      end;
   end;

procedure change_repertoire     (var ok : boolean);
   var
      chemin            : dirstr;
      l                 : integer;

   begin
      chemin := '';
      repertoire ('', chemin, ok);
      if ok
      then begin
         l     := length (chemin);
         if (l > 3)
         then
            if (chemin [l] = '\')
            then
               chemin := copy (chemin, 1, l-1 );
         chdir (chemin);
      end;
   end;

procedure nomfichier_entree     (comm            : chainecar;
                                 chemin          : pathstr;
                                 filtr           : namestr;
                                 var nf          : namestr);
   begin
      dir  (comm, chemin, nf, filtr, true);
      nf := sansext (nf);
   end;

procedure nomfichier_sortie     (comm            : Chainecar;
                                 chemin          : Pathstr;
                                 var nf          : Namestr;
                                 var ext         : Extstr;
                                 var ok          : boolean);
   var
      D                 : dirstr;
      nomi,
      N                 : namestr;
      exti,
      E                 : extstr;
{      p                 : integer; }

   begin
      nomi   := nf;
      exti   := ext;
 {     p := 0;
      repeat
         saisie (comm, nf, 12);
         p := pos (' ', nf);
      until p = 0;}

      saisie (comm, nf, 12);
      filtrer_indesirables (nf);

      fsplit (nf, D, N, E);
      ext    := E;
      if ext = ''
      then
         ext := exti;
      nf     := N;
      nf     := sansext (nf);

      if exists {ftxt_present} (chemin+nf+ext)
      then
         question (nf+ext+' '+q_exist, q_ecrase, ok)
      else
         ok := true;

      if not ok
      then
         nf := nomi;

      nf := maj (nf);
   end;

procedure nomfichier_complet_entree
                                (comm            : Chainecar;
                                 filtr           : Namestr;
                                 var chemin      : Dirstr;
                                 var nf          : Namestr);
   begin
      dir  (comm, chemin, nf, filtr, false);
   end;

procedure nomfichier_complet_entr
                                (comm            : Chainecar;
                                 var chemin      : Dirstr;
                                 var nom         : Namestr;
                                 var ext         : Extstr);

   { = OUVRIR fichier existant avec une extension qq  si ext='.*'}
   var
      nom12             : t12;

   begin
      nom12 := nom;
      dir  (comm, chemin, nom12, ext, false);
      ext  := extension (nom12);
      nom  := sansext   (nom12);
   end;

procedure nomfichier_complet_sort
                                (comm            : Chainecar;
                                 var chemin      : Pathstr;
                                 var nom         : Namestr;
                                 var ext         : Extstr);
   { = NOUVEAU fichier  crer }

   var
      chemini,
      exti              : extstr;
      ok, valid         : boolean;
      D                 : dirstr;
      N                 : namestr;
      E                 : extstr;

   begin
      ok      := false;
      chemini := chemin;
      exti    := ext;

      saisie ( comm, nom, 12);
      filtrer_indesirables (nom);
      fsplit ( nom, D, N, E);
      ext     := E;
      nom     := N;
      if (nom = '') or (ext = '') or (ext = '.')
                    or (ext = '*') or (ext = '.*')
      then
         ext := exti;

      if nom = '' then exit;

      repertoire ('', chemin, valid);

      if valid
      then begin
         if ftxt_present (chemin+nom+ext)
         then
            question (chemin+nom+ext+' '+q_exist, q_ecrase, ok)
         else ok := true;

         if not ok then nom := '';
      end;
   end;
{---- MENU5 ----------------------------------------------------------------}

{---- MENU6 ----------------------------------------------------------------}
procedure cree_boite (nomf : Pathstr ; var lg, pos : integer);
                     { rend la largeur et la hauteur du texte}
   var
      ftxt              : Text;
      tch               : string;
      ok                : boolean;

   begin
      pos := 1;
      lg  := 0;
      assign       (ftxt, nomf);
      resetTxtErr  (ftxt, nomf, ok);
      while (not (eof (ftxt))) and (pos < maxliste)
      do begin
         readln (ftxt, tch);
         if length (tch) > lg
         then
            lg := length (tch);
         listchaine^[pos] := tch;
         inc    (pos);
      end;
      listchaine^[pos] := '';
      pos := pos-1;
      close (ftxt);
   end;

procedure affich (h, lx, ly, mxx, mxy, x0, y0, nx, ny : integer);
   { position de dpart pour l'affichage : x0, y0 et nx, ny,
     longueur du texte                     y
     dimensions de la fentre texte        lx, ly et mxx, mxy
                             entte :      h                      }
   var
      debx, deby, i     : integer;

   begin
      debx := nx;
      deby := ny;
      setcolor        (c_t_boite_norm );
      setfillstyle (1, c_f_boite_norm );
      i := deby;
      bar (x0+2, y0+h+2, x0+lx-2, y0+ly-2);
      repeat
         {        dx = 6, dy = 6 }
         outtextxy (x0  +6,
                    y0 + h + 2 + (i-deby) * ty,
                    copy (listchaine^ [i], debx, mxx));
         inc (i);
      until (i >= deby+mxy);
   end;

procedure affiche_entete (titre : chainecar; x0, y0, lx, h : integer);
   begin
      setcolor        (c_t_boite_inve);      { titre }
      fixecoulentete  ;
      bar             (x0+3,                 y0+3,    x0+lx-3, y0+h-3);
      settextjustify  (1, 1);
      outtextxy       (x0+h +((lx-h) div 2), y0+(h div 2), titre);

      rectangle       (x0+4,                 y0+4,    x0+h-4,  y0+h-4);
      { bouton fermeture }
      setfillstyle    (0, c_t_boite_inve);
      settextjustify  (0, 2);
   end;

procedure bte_compl  (titre                      : chainecar;
                      x0, y0, x, y, mxx, mxy     : integer );

   { boite complte -  1 ligne = titre si non vide
                    -  position initiale du coin sup g de la bote,
                    -  dimensions du texte
                    -  dimensions de la fenetre          }

   var
      p                 : pointer;
      dx, dy, lx, ly,
      bx, by, xok, yok,
      taillep           : word;
      Touche,
      nx, ny, h, hb,
      xx, yy,
      supx, supy        : integer;
      centre, entet,
      confirm,
      asc_v, asc_h,
      reaffiche         : boolean;

   procedure affiche_bouton;
      begin
         rectangle (x0+xok,       y0+yok,  x0+xok+bx, y0+yok+by);
         settextjustify (1, 1);
         outtextxy (x0+xok+bx div 2, y0+yok+by div 2, n_OK);
         settextjustify (0, 2);
      end;

   function bouton_ok : boolean;
      begin
         bouton_ok :=
                   (xs > x0+xok) and (xs < x0+xok+bx)
               and (ys > y0+yok) and (ys < y0+yok+by);
      end;

   function bouton_fermeture : boolean;
      begin
         bouton_fermeture :=
               (xs > x0+4)   and (ys > y0+4)
           and (xs < x0+h-4) and (ys < y0+h-4)
           or d;
      end;

   begin
      memok   := true;
      confirm := false;   { pas utilis dans cette version }
      asc_v   := false;
      asc_h   := false;
      supx    := 0;
      supy    := 0;
      nouveau_style   (0, 0, 1);

      if mxx <= 0  then mxx := x;
      if mxy <= 0  then mxy := y;

      if y <= mxy
      then
         mxy   := y
      else begin
         supx  := 2*tx;
         asc_v := true
      end;

      if x <= mxx
      then
         mxx   := x
      else begin
         supy  := 2*tx;
         asc_h := true
      end;

      h     :=  0; { hauteur du titre }
      hb    :=  0; { hauteur libre pour les boutons intrieurs }
      ty    := 12;
      dx    :=  6;
      dy    :=  ty div 2;
      entet := titre <> '';
      if entet
      then
         h  := 2*dy + ty;

      lx    := mxx*tx + dx*2;
      if (posxbtn > 0) and (lx+supx > posxbtn)
      then begin
         lx       := posxbtn-1;
         mxx      := (lx -supx - dx*2) div tx;
         if x > mxx                 { si ncessaire }
         then begin
            supy  := 2*tx;
            asc_h := true
         end;
      end;

      ly   := mxy*ty {+ dy*2} + h;
      if confirm
      then begin
         bx  := 2 * (2*dx +tx);
         by  := 2 * dy + ty;
         hb  := by + dy;
         xok := (lx-bx) div 2;
         yok := ly-by-dy+hb;
      end;

      if (x0 < 0) or (y0 < 0)
      then
         if (POSXBTN = 0)
         then begin
            x0 := (maxx-lx-supx)    div 2;
            y0 := (maxy-ly-supy-hb) div 2;
         end else begin
            x0 := (posxbtn-lx-supx) div 2;
            y0 := (maxy-ly-supy-hb) div 2;
         end;

      taillep := imagesize (0, 0, lx+supx, ly+supy+hb);
      if (taillep < maxavail) and (taillep < maximage)
      then begin
         taillep := imagesize (0, 0, lx+supx, ly+supy+hb);
         getmem (p, taillep);

         ny := 1;
         nx := 1;
         repeat
            reaffiche := false;
            getimage  (x0,    y0,       x0+lx+supx, y0+ly+supy+hb, p^);
            setcolor        (c_t_boite_norm );
            setfillstyle (1, c_f_boite_norm );
            bar       (x0,    y0,       x0+lx,      y0+ly+hb);

            if asc_v
            then
               bar    (x0+lx, y0,       x0+lx+supx, y0+ly+hb);

            if asc_h
            then
               bar    (x0,   y0+ly+hb,  x0+lx,      y0+ly+hb+supy);

            rectangle (x0+1, y0+1,      x0+lx-1,    y0+ly+hb-1);

            if entet
            then
               affiche_entete (titre, x0, y0, lx, h);

            if asc_v
            then
               affiche_ascenseur_v (1, y-mxy+1, x0+lx-1, y0+1, ly+hb-2, -1, ny);
            if asc_h
            then
               affiche_ascenseur_h (1, x-mxx+1, x0+1, y0+ly+hb-1, lx-2, -1, nx);

            affich (h, lx, ly, mxx, mxy, x0, y0, nx, ny);

            if confirm
            then
               affiche_bouton;
            xx := x0;
            yy := y0;
            repeat
               if asc_v
               then
                  ascenseur_v (1, y-mxy+1, x0+lx-1, y0+1, ly+hb-2, -1, ny, Touche);

               if asc_h
               then
                  ascenseur_h (1, x-mxx+1, x0+1, y0+ly+hb-1, lx-2, -1, nx, Touche);

               if (not asc_h) and (not asc_v)
               then begin
                  MontrerSouris;
                  clavsouris (Touche);
                  LirePositionSouris (xs, ys);
                  CacherSouris;
               end;

               affich (h, lx, ly, mxx, mxy, x0, y0, nx, ny);

               if     (xs > x0+h) and (xs < x0+lx)
                  and (ys > y0)   and (ys < y0+2*ty) and (not d)
               then begin
                  dep_rec (xx, yy, lx+supx, ly+supy+hb);
                  LirePositionSouris (xs, ys);
                  reaffiche := true;
                  g := BoutonSourisEnfonce (BoutonGauche);
                  d := BoutonSourisEnfonce (BoutonDroit);
               end;
               if confirm then d := bouton_ok;
               if entet   then d := bouton_fermeture;
            until d or reaffiche;

            putimage (x0, y0, p^, 0);
            x0 := xx;
            y0 := yy;
         until not reaffiche;
         putimage (x0, y0, p^, 0);
         libere   (p);
      end else
         memok := false;
      ancien_style;
   end;

procedure boitinfo (texte : chainecar; x, y, mxx, mxy : integer);
         { titre de la bote  dfilement H et V,
           dimensions du texte,
           dimensions maxi de la fentre sur le texte en "caractres"}

   begin
      bte_compl  (texte, -1, -1, x, y, mxx, mxy);
                       { centr obligatoirement }
   end;

procedure boitep (x0, y0, lx, ly ,nbc, nbl : integer; confirm : boolean);
   { boite simple -  position de la bote, dimensions et nb de lignes   }

   var
      p                 : pointer;
      Touche,
      taillep, dx, dy   : integer;

   procedure affb;
      var
         i              : integer;

      begin
         i := 1;
         repeat
            outtextxy (x0+dx, y0+dy+i*ty, copy (listchaine^[i], 1, nbc));
            inc (i);
         until i = nbl;
      end;

   begin
      dx := 4;
      dy := 1;
      setfillstyle  (1, c_f_boite_norm);
      nouveau_style (0, 0, 1);
      taillep := imagesize (0, 0, lx, ly);
      getmem    (p, taillep);
      getimage  (x0,   y0,   x0+lx,   y0+ly, p^);
      setcolor        (c_t_boite_norm );
      setfillstyle (0, c_f_boite_norm );
      bar       (x0,   y0,   x0+lx,   y0+ly);
      rectangle (x0+1, y0+1, x0+lx-1, y0+ly-1);
      affb;
      if confirm
      then
         ClavSouris (Touche);
      putimage (x0, y0, p^, 0);
      libere   (p);
{      efface_boite (x0, y0, p);}
      ancien_style;
   end;

(*
procedure boite_aide (nomf        : Pathstr;
                      index       : integer;
                      var lg, pos : integer;
                      var titre   : chainecar);
                     { rend la largeur et la hauteur du texte}
   var
      tch               : string;
      ftxt              : text;
      prem              : char;

   begin
      pos   := 0;
      assign (ftxt, nomf);
      reset  (ftxt);
      while pos < index
      do begin
         readln (ftxt, tch);                   { lignes avant index }
         inc (pos)
      end;
      titre := souschaine (tch,']','');   { fin de la ligne indexe }
      lg    := 0;
      readln (ftxt, tch);                      { ligne suivante  }
      if tch = ''
      then
         tch := ' ';
      prem  := tch [1];
      pos   := 1;
      while (not (eof (ftxt))) and (pos < maxliste) and (prem <> '[')
      do begin
         if length (tch) > lg
         then
            lg := length (tch);
         listchaine^[pos] := tch;
         readln (ftxt, tch);
         if tch = ''
         then
            tch := ' ';
         prem := tch [1];
         inc (pos);
      end;
      listchaine^[pos] := '';
      pos := pos -1;
      close (ftxt);
   end;

procedure initaide (nomf : Pathstr; var ok : boolean);
   var
      i, j, pos, err    : integer;
      ftxt              : Text;
      ch, numx, numy    : string;
      prem              : char;

   begin
      ok := false;
      for i := 1 to nbboites
      do
         for j := 1 to nboptions-1
         do
             index_aide^ [i, j] := 0;

      if (not ftxt_present (nomf))
      then
         exit;
      ok := true;
      assign (ftxt, nomf);
      reset  (ftxt);

      pos := 0;
      i   := 0;
      j   := 0;

      while not (eof (ftxt))
      do begin
         readln (ftxt, ch);
         if ch = ''
         then
            ch := ' ';
         prem := ch [1];
         inc (pos);
         while (prem <> '[') and (not (eof (ftxt)))
         do begin
            readln (ftxt, ch);
            if ch = ''
            then
               ch := ' ';
            prem := ch [1];
            inc (pos);
         end;
         if not eof (ftxt)
         then begin
            numx := souschaine (ch, '[', ' ');
            numy := souschaine (ch, ' ', ']');
            val (numx, i, err);
            val (numy, j, err);
{            if (i <> 0) and (j <> 0) then index_aide^ [i, j] := pos}
            index_aide^ [i, j] := pos
         end
      end;
      close (ftxt);
   end;

procedure aff_aide (nomf : Pathstr; i, j : integer);
   var
      titre             : chainecar;
      index, lg, ht     : integer;

   begin
      if (i < 1) or (j < 1) or (i > nbboites) or (j > nboptions)
      then
         exit;

      index   := index_aide^ [i, j];

      if index = 0
      then
         exit;

      laide (la_esc_bd);
      boite_aide (nomf, index, lg, ht, titre );
      {      boitinfo3  (titre_aide, lg, ht, lg, 10 );}

      bte_compl  (titre, -1, -1, lg, ht, 57, 15);
      laide ('');
   end;
*)
procedure bte_simple (titre            : chainecar;
                      x0, y0, nbc, nbl : integer ;
                      confirm          : boolean;
                      var       p      : pointer );

   { boite simple sans dfilement
                   -  ligne 1 = titre si non vide
                   -  position du coin sup g de la bote,
                   -  nb de lignes
                   -  confirm = bouton ok                        }

   var
      centre, entet     : boolean;
      Touche,
      taillep, h,
      dx, dy, lx, ly,
      bx, by, xok, yok  : integer;

   function bouton_ok : boolean;
      begin
         bouton_ok :=
                   (xs > x0+xok)       and (xs < x0+xok+bx)
               and (ys > y0+ly-yok+dy) and (ys < y0+ly-dy);
      end;

   procedure affiche_texte ( i : integer);
      begin
         repeat
            outtextxy (x0+dx, y0+h+dy+ (i-1)*ty,
                       copy (listchaine^[i], 1, nbc));
            inc (i);
         until i = nbl;
      end;

   begin
      nouveau_style (0, 0, 1);
      h   :=  0;
      ty  := 12;
      dx  :=  6;
      dy  :=  6;
      entet := length (titre) > 0;
      if entet
      then
         h := 2*dy + ty;
      lx  := nbc*tx + dx*2;
      ly  := nbl*ty + dy*2 + h;
      if confirm
      then begin
         bx  := 2 * (2*dx +tx);
         by  := 2*dy + ty;
         ly  := ly + by + 2*dy;
         xok := (lx-bx) div 2;
         yok :=  ly-by-dy;
      end;
      if (x0 < 0) or (y0 < 0)
      then
         if posxbtn=0
         then begin
            x0 := (maxx-lx) div 2;
            y0 := (maxy-ly) div 2;
         end else begin
            x0 := (posxbtn-lx) div 2;
            y0 := (maxy-ly) div 2;
         end;
      taillep := imagesize (0, 0, lx, ly);
      getmem    (p, taillep);
      getimage  (x0,   y0,   x0+lx,   y0+ly, p^);
      setcolor        (c_t_boite_norm {colord});
      setfillstyle (1, c_f_boite_norm {colorf});
      bar       (x0,   y0,   x0+lx,   y0+ly);
      rectangle (x0+1, y0+1, x0+lx-1, y0+ly-1);
      if entet
      then begin
         setcolor        (c_t_boite_inve{colorf});
         setfillstyle (1, c_f_boite_inve{colord});
         bar       (x0+3,    y0+3,    x0+lx-3, y0+h-1);
         outtextxy (x0+dx+3, y0+dy+3, copy (titre, 2, nbc));
         setcolor        (c_t_boite_norm {colord});
         setfillstyle (0, c_f_boite_norm {colorf});
      end;
      if confirm
      then begin
         rectangle (x0+xok,       y0+yok,       x0+xok+bx, y0+yok+by);
         outtextxy (x0+xok+dx+dx, y0+yok+dy, n_OK);
      end;

      affiche_texte (1);

      if confirm
      then begin
         MontrerSouris;
         ClavSouris (Touche);
         CacherSouris;
      end else
         ClavSouris (Touche);
      ancien_style;
   end;

procedure sauvetemp    (nomf : pathstr; var ok : boolean);
   begin
      copyfile  (nomf, reptemp+tempo_txt, ok);
   end;

{---- MENU6 ----------------------------------------------------------------}


END.
{--- ARX - PERIPHS --------------------------- R.C.- INRP - TOULOUSE - 1993 }
