UNIT curseurs;

{---------------------------------------------------------------------------}
{         ARX                                                               }
{                          Unite CURSEURS                                   }
{                                                               30/05/93    }
{---------------------------------------------------------------------------}

(*
   Curseurs,                 { ARX     - Potentiomtres simples et doubles  }
*)

INTERFACE

{$O+,F+}

USES
   Crt,
   Graph,                    { TP7     - units standard Borland            }
   Clavier,                  { ARX     - gestion du clavier                 }
   Souris,                   { ARX     - Souris seule                       }
   Graphism,                 { ARX     - initialisations graphiques         }
   Graphplt,                 { ARX     - initialisations graphiques         }
   Icones,                   { ARX     - Icnes                             }
   Utildivs;                 { ARX     - utilitaires divers                 }
                                   { utile ici seulement pour recalc coord  }

Procedure cal_donnee (pasv, donnee_min, donnee_max : real;
                      var donnee                   : real);
   { calcule la DONNEE arrondie  PASVS                                     }

Procedure initformat (f_d                          : t12 ;
                      var f_dt, f_dp               : byte);
   { initialise le format des affichages                                    }

Procedure formater   (x                            : real;
                      t,  p                        : integer;
                      var s                        : t12) ;
   { Transtypage x --> s avec formatage  t = nb chiffres ; p = nb dcimales }

Procedure dess_curseur_2 (titre, unite, f_d        : t20;
                          numero,
                          coulb, coultexte,
                          coulicone, coulbouton    : word;
                          x, y, dx, dy             : integer;
                          pasv,
                          donnee_min, donnee_max,
                          donnee_deb, donnee_fin   : real);
   { dessine double curseur horizontal                                      }

Procedure modif_donnee   (numero,
                          coulb, coultexte,
                          coulicone, coulbouton    : word;
                          f_d                      : t12;
                          pasv,
                          donnee_min, donnee_max   : real;
                      var donnee_deb, donnee_fin   : real);
   { Saisie des positions des curseurs                                      }

Procedure dess_curseur_1 (titre, unite, f_d        : t20;
                          numero,
                          coultexte,
                          coulicone, coulbouton    : word;
                          x, y, dx, dy             : integer;
                          pasv,
                          donnee_min, donnee_max   : real;
                          var donnee               : real);
   { dessine curseur simple horizontal                                      }

Procedure modif_donnee_1 (numero,
                          coultexte, coulicone,
                          coulbouton               : word;
                          pasv,
                          donnee_min, donnee_max   : real;
                          var donnee               : real);
   { Saisie de la position du curseur seul                                  }

{---------------------------------------------------------------------------}

IMPLEMENTATION

VAR
   bou1,                  { bouton seul }
   cadr1,
   binf, bsup,            { double bouton }
   cadre                : limites;

   format_dt,              { nb chiffres total }
   format_dp               { nb dcimales      }
                        : byte;

   xs,  ys,                {  position souris }
   dim, di2,               { course du curseur }
   xgi, xdi,               { coord icone }
   yhi, ybi
                        : integer;

   ch                      { donne formate }
                        : string;


procedure formater (x  : real ; t,  p  : integer ; var s  : t12) ;
   begin
      str (x :t:p, s) ;
      if pos ('.', s)  > (t-1)
      then
         s  :=  copy (s, 1, pos ('.', s) -1)
      else
         s  :=  copy (s, 1, t) ;
      while length (s)  < t
      do
         s  :=  ' '+s;
   end;

procedure initformat (f_d : t12; var f_dt, f_dp : byte);
   var
      erreur            : integer;

   begin
      if pos (':', f_d)  > 0
      then begin
         val (copy (f_d, 1, pos (':', f_d) -1) , f_dt, erreur) ;
         val (copy (f_d, pos (':', f_d) +1, 2) , f_dp, erreur) ;
      end else begin
         val (f_d, f_dt, erreur) ;
         f_dp  :=  0;
      end;
   end;

procedure redess (lim : limites; coul1, coul2 : word);
   begin
      with lim
      do begin
         fixecoul  (coul1) ;
         rectangle ( xg,  yh,    xd,     yb ) ;
         coulbar   (1, coul2) ;
         bar       ( xg+1, yh+1,  xd-1,  yb-1 ) ;
      end;
   end;

procedure decale (coulb, coulicone, coulbouton : word ;
                  var lim               : limites;
                  x                     : integer;
                  bout, cadre           : limites) ;
   { dcale le BOUT de la distance X (pixels)
            de la position initiale LIM  dans les limites BOUT, CADRE }
   var
      y1, y2            : integer;

   begin
      with lim
      do begin
         y1  :=  (yh+yb)  div 2 - 1;
         y2  :=  y1+2;

         coulbar  (1, coulb) ;
         bar       (xg,  yh, xd, yb);
         if xd < bout.xg
         then begin
            if xg+x <= cadre.xg+2
            then
               x  :=  cadre.xg+2-xg;

            if xd+x >= bout.xg
            then
               x  :=  bout.xg-xd-1;

            if x > 0
            then begin
               coulbar (1, coulb) ;
               bar (xd+1, y1, xd+x, y2) ;
            end else begin
               coulbar (1, coulicone) ;
               bar (xd+x, y1, xd,   y2) ;
            end;

         end else begin
            if xd+x >= cadre.xd-2
            then
               x  :=  cadre.xd-2-xd;

            if xg+x <= bout.xd
            then
               x  :=  bout.xd-xg+1;

            if x < 0
            then begin
               coulbar (1,  coulb) ;
               bar (xg-1, y1, xg+x, y2) ;
            end else begin
               coulbar (1, coulicone) ;
               bar (xg+x, y1, xg,   y2) ;
            end;
         end;

         xg  :=  xg+x;
         xd  :=  xd+x;
         fixecoul (coulicone) ;
         rectangle ( xg,  yh,  xd,  yb) ;
         coulbar (1, coulbouton) ;
         bar  (xg+1,  yh+1,  xd-1,  yb-1) ;
      end;
   end;

procedure fixe_lims (var l : limites; xg, yh, xd, yb :integer) ;
   begin
      l.xg  :=  xg;
      l.xd  :=  xd;
      l.yh  :=  yh;
      l.yb  :=  yb;
      rectangle ( xg,  yh,  xd,  yb ) ;
      bar ( xg+1,  yh+1,  xd-1,  yb-1 ) ;
   end;

procedure cal_donnee (pasv, donnee_min, donnee_max : real;
                        var donnee                 : real);
   begin
      if donnee < donnee_min then donnee := donnee_min;
      if donnee > donnee_max then donnee := donnee_max;
      donnee := round (donnee/pasv) *pasv;
   end;

procedure aff_donnee_d (coulb, coulbouton            : word;
                        donnee                       : real);
   begin
      coulbar (1, coulb) ;
      bar (xgi+1,     yhi +28,
           xdi-1-di2, yhi +37 ) ;
      fixecoul (coulbouton) ;

      settextjustify (0, 2);
      formater  (donnee, format_dt, format_dp, ch) ;
      outtextxy (xgi+2, yhi + 28, ch) ;
   end;

procedure aff_donnee_f (coulb, coulbouton            : word;
                        donnee                       : real);
   begin
      coulbar (1, coulb) ;
      bar (xgi+1+di2, yhi +28,
           xdi-1,     yhi +37 ) ;
      fixecoul (coulbouton) ;

      settextjustify (2, 2);
      formater  (donnee, format_dt, format_dp, ch) ;
      outtextxy (xdi-2, yhi + 28, ch) ;
   end;

procedure calc_donnee ( coulb, coulbouton            : word;
                        pasv, donnee_min, donnee_max : real;
                        var donnee_deb, donnee_fin   : real);
   begin
      donnee_deb  :=  donnee_min+ (donnee_max-donnee_min)
                                * (binf.xg-cadre.xg-2) /dim;
      donnee_fin  :=  donnee_min+ (donnee_max-donnee_min)
                                * (bsup.xg-cadre.xg-2) /dim;

      coulbar (1, coulb) ;
      bar (xgi+1,     yhi +28,
           xdi-1,     yhi +37 ) ;
      fixecoul (coulbouton) ;

      settextjustify (0, 2);
      donnee_deb := round (donnee_deb/pasv) *pasv;
      formater  (donnee_deb, format_dt, format_dp, ch) ;
      outtextxy (xgi+2,                  yhi + 28, ch) ;

      settextjustify (2, 2);
      donnee_fin := round (donnee_fin/pasv) *pasv;
      formater  (donnee_fin, format_dt, format_dp, ch) ;
      outtextxy (xdi-2,                  yhi + 28, ch) ;
   end;

procedure dess_curseur_2 (titre, unite, f_d            : t20;
                          numero,
                          coulb, coultexte,
                          coulicone, coulbouton        : word;
                          x, y, dx, dy                 : integer;
                          pasv,
                          donnee_min, donnee_max,
                          donnee_deb, donnee_fin       : real);

   function deplace_b (donnee : real) : integer;
      begin
         deplace_b :=  -1 * round (donnee * dim / (donnee_max-donnee_min));
      end;

   begin
      initformat (f_d, format_dt, format_dp);
      xgi := xgicone (numero);
      xdi := xdicone (numero);
      yhi := yhicone (numero);
      ybi := ybicone (numero);
      dim :=  (cadre.xd-cadre.xg-4-binf.xd+binf.xg) ;
      di2 := (xdi-xgi) div 2;
      setusercharsize (1, 1, 1, 1);
      coulbar  (1, coulb) ;
      bar                       ( x, y, x+dx, y+dy );
      fixecoul     (coulicone) ;
      rectangle                 ( x, y, x+dx, y+dy ) ;

      { titre }
      fixecoul     (coulbouton) ;
      settextjustify (1, 2);
      outtextxy (x+dx div 2, y+1 , titre);

      { units }
      settextjustify (1, 0);
      outtextxy (x+dx div 2, y+dy-3 , unite);

      { barre horizontale }
      fixecoul  (coulicone) ;
      fixe_lims (cadre, x    + 3,  y  + 14,
                        x+dx - 3,  y  + 26);

      { boutons }
      fixecoul        (coulicone) ;
      coulbar (1, coulbouton) ;
      fixe_lims (bsup,  x+dx -10,  y  + 16,
                        x+dx - 5,  y  + 24) ;

      fixe_lims (binf,  x+dx -16,  y  + 16,
                        x+dx -11,  y  + 24) ;

      dim      := cadre.xd -cadre.xg-4 -binf.xd +binf.xg ;
      if donnee_deb > donnee_min
      then
         decale (coulb, coulicone, coulbouton,
                 binf, (deplace_b (donnee_max-donnee_deb))+6, bsup, cadre)
      else
         decale (coulb, coulicone, coulbouton,
                 binf, -100,  bsup, cadre);

      if donnee_fin < donnee_max
      then
         decale (coulb, coulicone, coulbouton,
                 bsup, (deplace_b (donnee_max-donnee_fin))-1, binf, cadre) ;

      cal_donnee
         (pasv, donnee_min, donnee_fin, donnee_deb);
      aff_donnee_d
         (coulb, coultexte, donnee_deb);

      cal_donnee
         (pasv, donnee_deb, donnee_max, donnee_fin);
      aff_donnee_f
         (coulb, coultexte, donnee_fin);

      setusercharsize (3, 2, 3, 2);
   end;

procedure modif_donnee  (numero,
                         coulb, coultexte,
                         coulicone, coulbouton   : word;
                         f_d                     : t12;
                         pasv,
                         donnee_min, donnee_max  : real;
                     var donnee_deb, donnee_fin  : real);
   var
      xi,
      nbint,
      code, dx, dpx,
      xdep, ydep,
      xmem, ymem
                        : integer;
      BoutonInf
                        : boolean;

   function deplace_b (donnee : real) : integer;
      begin
         deplace_b := round (donnee * dim / (donnee_max-donnee_min));
      end;

   function souris_dx  (xi, xs : integer) : integer;
      begin
         if (xs-xi) > 0
         then souris_dx := 1
         else
           if (xs-xi) < 0
           then  souris_dx := -1
           else  souris_dx := 0;
         { - (binf.xd+binf.xg) div 2}
      end;

   begin
      initformat (f_d, format_dt, format_dp);
      xgi := xgicone (numero);
      xdi := xdicone (numero);
      yhi := yhicone (numero);
      ybi := ybicone (numero);
      dim := (cadre.xd-cadre.xg-4-binf.xd+binf.xg) ;
      di2 := (xdi-xgi) div 2;
      setusercharsize (1, 1, 1, 1);
      xmem  :=  0;
      ymem  :=  0;
      BoutonInf := false;

      nbint := trunc ((donnee_max - donnee_min) / pasv);
      montrersouris;
      repeat
         code := 0;
         lirepositionsouris (xs, ys);
         if UnBoutonSourisEnfonce  and dans (xs, ys, binf)
         then begin
            BoutonInf := true;
            repeat
               cachersouris;
        {       xi := xs;}
               lirepositionsouris (xs, ys);
        {       dpx := souris_dx (xi, xs);
               decale
                   (coulb, coulicone, colord,
                    binf, dpx* deplace_b (pasv), bsup, cadre) ;
               donnee_deb := dpx*pasv+donnee_deb;
               cal_donnee
                   (pasv, donnee_min, donnee_fin, donnee_deb);
               aff_donnee_d
                   (coulb, coultexte,
                    donnee_deb);               }
               decale
                   (coulb, coulicone, colord,
                    binf, xs- (binf.xd+binf.xg)  div 2, bsup, cadre) ;
               calc_donnee
                   (coulb, coultexte,
                    pasv, donnee_min, donnee_max, donnee_deb, donnee_fin);
               MontrerSouris;
            until not  UnBoutonSourisEnfonce ;
         end else
            if UnBoutonSourisEnfonce and dans (xs, ys, bsup)
            then begin
               BoutonInf := false;
               repeat
                  CacherSouris;
                  xi := xs;
           {       xi := xs;}
                  lirepositionsouris (xs, ys);
          {        dpx := souris_dx (xi, xs);
                  decale
                     (coulb, coulicone, colord,
                      bsup, dpx*deplace_b (pasv), binf, cadre) ;
                  donnee_fin := dpx*pasv+donnee_fin;
                  cal_donnee
                     (pasv, donnee_deb, donnee_max, donnee_fin);
                  aff_donnee_f
                     (coulb, coultexte,
                      donnee_fin); }
                  decale
                     (coulb, coulicone, colord,
                      bsup, xs- (bsup.xd+bsup.xg) div 2, binf, cadre) ;
                  calc_donnee
                     (coulb, coultexte,
                      pasv, donnee_min, donnee_max, donnee_deb, donnee_fin);
                  MontrerSouris;
               until not  UnBoutonSourisEnfonce ;
            end;

         if ToucheClavier (Code)
         then begin
            cachersouris;
            case Code of
               FleG : dx :=-1;
               FleD : dx := 1;
               Tab  : BoutonInf := not BoutonInf;
            end;

            if boutonInf
            then begin
               redess (binf, coulicone, colord);
               redess (bsup, coulicone, coulbouton)
            end else begin
               redess (binf, coulicone, coulbouton);
               redess (bsup, coulicone, colord)
            end;
            if (Code = FleG) or (code = FleD)
            then
               if boutonInf
               then begin
                  decale
                     (coulb, coulicone, colord,
                      binf, dx*deplace_b (pasv), bsup, cadre) ;
                  donnee_deb := dx*pasv+donnee_deb;
                  cal_donnee
                     (pasv, donnee_min, donnee_fin, donnee_deb);
                  aff_donnee_d
                     (coulb, coultexte,
                      donnee_deb);
               end else begin
                  decale
                     (coulb, coulicone, colord,
                      bsup, dx*deplace_b (pasv), binf, cadre) ;
                  donnee_fin := dx*pasv+donnee_fin;
                  cal_donnee
                     ({dx*}pasv, donnee_deb, donnee_max, donnee_fin);
                  aff_donnee_f
                     (coulb, coultexte,
                      donnee_fin);
               end;
            montrersouris;
         end;
      until (code = esc) or (UnBoutonSourisEnfonce
                            and not
                              (dans (xs, ys, binf) or dans (xs, ys, bsup) ) )
                         or (code = CR);
      cachersouris;
      redess (binf, coulicone, coulbouton);
      redess (bsup, coulicone, coulbouton);
      setusercharsize (3, 2, 3, 2);
   end;

{===========================================================================}
procedure aff_donnee_1  ( coulb, coulbouton        : word;
                          donnee                   : real);
   begin
      coulbar (1, coulb);
      bar (xgi+1,            yhi +28,
          (xgi+xdi) div 2,   ybi -1);
      fixecoul (coulbouton) ;

      settextjustify (0, 0);
      formater  (donnee, format_dt, format_dp, ch);
      outtextxy (xgi+2,             ybi-4, ch);
   end;

procedure decale_1 (coulicone, coulbouton : word ;
                    var lim               : limites;
                          x               : integer;
                    cadr1                 : limites) ;
   { dcale le BOUT de la distance X (pixels)
            de la position initiale LIM  dans les limites du CADRE }
   var
      y1, y2            : integer;

   begin
      with lim
      do begin
         y1  := (yh+yb) div 2 - 1;
         y2  := y1+2;

         coulbar (1, coulboite);    { effacer le bouton en cours }
         bar    (xg,  yh, xd, yb);

         if xg+x <= cadr1.xg+2 then x := cadr1.xg+2-xg;
         if xd+x >= cadr1.xd-2 then x := cadr1.xd-2-xd;

         xg  :=  xg+ x;
         xd  :=  xd+ x;

         fixecoul  (coulicone) ;
         rectangle ( xg,  yh,  xd,  yb ) ;
         coulbar (1, coulbouton) ;
         bar ( xg+1,  yh+1,  xd-1,  yb-1 ) ;
      end;
   end;

procedure calc_donnee_1 ( coulbouton                   : word;
                          pasv, donnee_min, donnee_max : real;
                          var donnee                   : real);
   begin
      donnee      :=  donnee_min+ (donnee_max-donnee_min)
                                * (bou1.xg-cadr1.xg-2) /dim;

      cal_donnee (pasv, donnee_min, donnee_max, donnee);

      aff_donnee_1
            (coulboite, coulbouton, donnee);
   end;

procedure dess_curseur_1 (titre, unite, f_d            : t20;
                          numero,
                          coultexte, coulicone, coulbouton : word;
                          x, y, dx, dy                 : integer;
                          pasv, donnee_min, donnee_max : real;
                          var donnee                   : real);

   function deplace_b (d : real) : integer;
      begin
         deplace_b :=  -1 * round (d * dim / (donnee_max-donnee_min));
      end;

   begin
      xgi := xgicone (numero);
      xdi := xdicone (numero);
      yhi := yhicone (numero);
      ybi := ybicone (numero);
      dim         :=  (cadr1.xd-cadr1.xg-4-bou1.xd+bou1.xg);
      initformat (f_d, format_dt, format_dp);
      setusercharsize (1, 1, 1, 1);
      coulbar (1, coulboite) ;
      bar                       ( x, y, x+dx, y+dy );
      fixecoul     (coulicone) ;
      rectangle                 ( x, y, x+dx, y+dy ) ;

      { titre }
      fixecoul     (coulbouton) ;
      settextjustify (1, 2);
      outtextxy (x+dx div 2, y+1 , titre);

      { units }
      settextjustify (2, 0);
      outtextxy (x+dx-2, y+dy-4, unite) ;

      { barre horizontale }
      fixecoul     (coulicone) ;
      fixe_lims (cadr1, x    + 3,  y  + 14,
                        x+dx - 3,  y  + 26);

      { un bouton }
      fixecoul        (coulicone) ;
      coulbar (1, coulbouton) ;
      fixe_lims (bou1  ,x+dx -10,  y  + 16,
                        x+dx - 5,  y  + 24) ;

      decale_1 (coulicone, coulbouton,
                bou1, deplace_b (donnee_max-donnee), cadr1) ;

{      calc_donnee_1
               (coultexte ,
                pasv, donnee_min, donnee_max, donnee); }

      aff_donnee_1
               (coulboite, coultexte, donnee);


      setusercharsize (3, 2, 3, 2);
   end;

procedure modif_donnee_1 (numero,
                          coultexte, coulicone, coulbouton : word;
                          pasv, donnee_min, donnee_max     : real;
                          var donnee                       : real);
   var
      code, dx,
      xdep, ydep,
      xmem, ymem
                        : integer;
      fini
                        : boolean;

   function deplace_b (d : real) : integer;
      begin
         deplace_b   :=  round (d * dim / (donnee_max-donnee_min));
      end;

   begin
      xgi := xgicone (numero);
      xdi := xdicone (numero);
      yhi := yhicone (numero);
      ybi := ybicone (numero);
      dim :=  (cadr1.xd-cadr1.xg-4-bou1.xd+bou1.xg);
      setusercharsize (1, 1, 1, 1);
      fini  :=  false;
      xmem  :=  0;
      ymem  :=  0;
      montrersouris;
      REPEAT
         code  := 0;
         lirepositionsouris (xs, ys);
         if UnBoutonSourisEnfonce  and dans (xs, ys, bou1)
         then begin
            repeat
               cachersouris;
               lirepositionsouris (xs, ys);
               decale_1
                     (coulicone, colord,
                      bou1, xs- (bou1.xd+bou1.xg)  div 2, cadr1) ;
               calc_donnee_1
                     (coultexte,
                      pasv, donnee_min, donnee_max, donnee);
               montrersouris;
            until not  UnBoutonSourisEnfonce ;
            fini  :=  true;
         end;
         if ToucheClavier (Code)
         then begin
            cachersouris;
            case Code of
               FleG : dx := -1;
               FleD : dx := 1;
            end;
            if (Code = FleG) or (Code = FleD)
            then begin
               decale_1
                     (coulicone, colord,
                      bou1, dx*deplace_b (pasv), cadr1) ;
               donnee      :=  dx * pasv+donnee;
               cal_donnee (pasv, donnee_min, donnee_max, donnee);
               aff_donnee_1
                     (coulboite, coultexte, donnee);
               montrersouris;
            end;
         end;
      until (Code = esc) or (UnBoutonSourisEnfonce
                            and not dans (xs, ys, bou1))
                         or (code = CR);
      redess (bou1, coulicone, coulbouton);
      setusercharsize (3, 2, 3, 2);
      cachersouris;
   end;

END.

{--- ARX ----- CURSEURS ---------------------- R.C.-------- TOULOUSE - 1994 }
