UNIT GRAPH3D;

{---------------------------------------------------------------------------}
{         bibliothque                                                      }
{                       procdures graphiques 3D                            }
{                                                               juillet 92  }
{---------------------------------------------------------------------------}
{  A R X - Alain, Roger et Xavier CULOS - 6 avenue de Lagarde 31130 BALMA   }
{---------------------------------------------------------------------------}

(*
   Graph3d,                  { ARX     - Calcul projections 3D              }
                             {         - procdures graphiques 3D           }
*)

INTERFACE

{$O+,F+}

USES
   Graphplt;                 { ARX     - graphisme 2D cran/traceur         }

TYPE
   GenreDeProjection    = (perspective, parallele);

VAR
   projection           : GenreDeProjection;

   rho,                                { paramtres bloc : dist obj/obs.    }
   theta,                              {            direction observateur   }
   phi,                                {            hauteur observateur     }
   de,                                 {            dist cran/observateur  }
   xobs, yobs, zobs,                   { position observateur               }
   xc,   yc,   zc,                     { position point                     }
   divZ,                               { coef aplatissement du bloc         }
   Xsoleil,
   Ysoleil,
   Zsoleil                             { position du soleil                 }
                        : real;

Procedure fenetre      (f1, f2, f3, f4 : real);
   { }

Procedure cloture      (c1, c2, c3, c4 : integer);
   { }

Procedure initialiseProjection;
   { }

Procedure projette     (x, y, z : real);
   { Met  jour Xproj, Yproj }

Function  abscisse  : integer;
   { Rend val arrondie de Xproj }

Function  ordonnee  : integer;
   { Rend val arrondie de Yproj   }

Procedure tracevers3d  (x, y, z : real);
   { Dessine ligne dans la couleur cte }

Procedure deplaceEn3d  (x, y, z : real);
   { Dplace et dessine un point }

Procedure deplaceEn3dT (x, y, z : real);
   { Dplace et stoppe aux limites de la clture }

procedure triangle3d   (x1, y1, z1,
                        x2, y2, z2,
                        x3, y3, z3 : real;
                        co         : word);
   { Dessine un triangle plein avec la trame courante                       }

Procedure carre3d      (x1, y1, z1,
                        x2, y2, z2,
                        x3, y3, z3,
                        x4, y4, z4 : real;
                        co         : word);
   { Dessine un carr plein avec la trame courante                          }

Procedure direc_soleil (thetaSol, phiSol : real);
   { Calcule la position du soleil                                          }
   { angles en                                                             }
   { theta : azimuth. droite origine sort de l'ecran, sens trigo            }
   { phi   : hauteur                                                        }

Procedure axes;
   { Dessine les 3 axes }

Procedure place_centre (x, y, z : real);
   { Modifie la position du centre de rotation du bloc          }

Procedure d3_d2 (x3, y3, z3 : real ; var x, y : integer);
   { Rend abcisse et ordonne fenetre cte pour la vue 3d courante }

{---------------------------------------------------------------------------}
IMPLEMENTATION

CONST
   rapxy                = 1;

VAR
   xproj,   yproj,                      { projection dans fenetre 2d         }
   aux1, aux2, aux3, aux4,
   aux5, aux6, aux7, aux8   : real;

{*********************** FENETRE *******************************************}
procedure fenetre      (f1, f2, f3, f4 : real);
   begin
      graphplt.fenetre (f1, f2, f3, f4);
   end;

{*********************** CLOTURE *******************************************}
procedure cloture      (c1, c2, c3, c4 : integer);
   begin
      graphplt.cloture (c1, c2, c3, c4);
   end;

{*********************** PLEINE CLOTURE ************************************}
procedure pleinecloture;
   begin
      graphplt.pleinecloture;
   end;

{*********************** INITIALISE PROJECTION *****************************}
procedure initialiseProjection;
   var
      th, ph            : real;

   begin
      th   := pi*theta/180;
      ph   := pi*  phi/180;
      aux1 := sin (th);
      aux2 := sin (ph);
      aux3 := cos (th);
      aux4 := cos (ph);
      aux5 := aux3*aux2;
      aux6 := aux1*aux2;
      aux7 := aux3*aux4;
      aux8 := aux1*aux4;
   end;

{*********************** PROJETTE ******************************************}
procedure projette     (x, y, z : real);
   begin
      x := x-xc;
      y := y-yc;
      z := (z-zc)/divZ;
      xobs := -x*aux1+y*aux3;
      yobs := -x*aux5-y*aux6+z*aux4;
      if projection = perspective
      then begin
         zobs  := -x*aux7-y*aux8-z*aux2+rho;
         xproj := de*xobs/zobs;
         yproj := de*yobs/zobs
      end else begin
         xproj := de*xobs;
         yproj := de*yobs
      end
   end;

{*********************** ABSCISSE ****************************************}
function abscisse : integer;    { Ecran }
   begin
      abscisse := integer(round (xproj*rapxy){ - ((Xdfen-xgfen)/2)});
   end;

{*********************** ORDONNEE ****************************************}
function ordonnee : integer;     { Ecran }
   begin
      ordonnee := integer(round ({((yhfen-ybfen)/2) -}yproj));
   end;

{*********************** TRACE VERS ****************************************}
procedure tracevers3d  (x, y, z : real);   { Utilisateur }
   begin
      projette (x, y, z);
      tracevers (abscisse, ordonnee);
   end;

{*********************** DEPLACE EN ****************************************}
procedure deplaceEn3d  (x, y, z : real);    { Utilisateur }
   begin
      projette (x, y, z);
      deplaceenl (abscisse, ordonnee);
   end;

procedure deplaceEn3dT (x, y, z : real);    { Utilisateur }
   begin
      projette (x, y, z);
      deplaceenT (abscisse, ordonnee);
   end;

{*********************** TRIANGLE ******************************************}
procedure triangle3d   (x1, y1, z1,
                        x2, y2, z2,
                        x3, y3, z3 : real;
                        co         : word);
   begin
      projette (x1, y1, z1);
      x1 := Abscisse;
      y1 := Ordonnee;
      projette (x2, y2, z2);
      x2 := Abscisse;
      y2 := Ordonnee;
      projette (x3, y3, z3);
      x3 := Abscisse;
      y3 := Ordonnee;

      Triangle (x1, y1, x2, y2, x3, y3, co);
   end;

{*********************** CARRE *********************************************}
procedure carre3d      (x1, y1, z1,
                       x2, y2, z2,
                       x3, y3, z3,
                       x4, y4, z4 : real;
                       co         : word);
   begin
      projette (x1, y1, z1);
      x1 := Abscisse;
      y1 := Ordonnee;
      projette (x2, y2, z2);
      x2 := Abscisse;
      y2 := Ordonnee;
      projette (x3, y3, z3);
      x3 := Abscisse;
      y3 := Ordonnee;
      projette (x4, y4, z4);
      x4 := Abscisse;
      y4 := Ordonnee;

      Carre (x1, y1, x2, y2, x3, y3, x4, y4, co);
   end;

{*********************** DIREC SOLEIL **************************************}
procedure direc_soleil (thetaSol, phiSol : real);
   begin
      thetaSol := pi*thetaSol/180;
      phiSol   := pi*phiSol/180;
      Xsoleil  := cos (thetaSol) * cos (phisol);
      Ysoleil  := sin (thetaSol) * cos (phisol);
      Zsoleil  := sin (phiSol);
   end;

{*********************** AXES **********************************************}
procedure axes;
   begin
      deplaceen3d (0, 0, 0); tracevers3d (10,  0,  0);
      deplaceen3d (0, 0, 0); tracevers3d ( 0, 10,  0);
      deplaceen3d (0, 0, 0); tracevers3d ( 0,  0, 10)
   end;

{*********************** PLACE CENTRE **************************************}
procedure place_centre (x, y, z : real);
{ dfinit le point (du repre objet) qui sera plac au centre de la cloture }
   begin
      xc := x;
      yc := y;
      zc := z;
   end;

procedure d3_d2 (x3, y3, z3 : real ; var x, y : integer);
   begin
      projette (x3, y3, z3);
      x := abscisse ;
      y := ordonnee ;
   end;

END.
{---------------------------------------------------------------------------}
