UNIT LIPAR;

{---------------------------------------------------------------------------}
{         bibliothque                                                      }
{                          lecture fichiers paramtres                      }
{                                                                03/09/91   }
{---------------------------------------------------------------------------}
{  ARX - Alain, Roger et Xavier CULOS - 6 av de Lagarde 31130 BALMA         }
{---------------------------------------------------------------------------}
(*
   Lipar,                    { ARX     - gestion fichiers paramtres        }
   pourrait utiliser FICHIERS pour contrler compltement les erreurs ES...
   Il suffit en gnral de tester la faisabilit avant d'appeler les
   procdures LISTE.LIT et LISTE.ECRIT
                   prsence du fichier et accessibilit
                   place en criture
*)

INTERFACE

{$O+,F+}

USES
   dos,
   graph,                    { TP 70   - units standard Borland            }
   Utildivs,                 { ARX     - utilitaires divers                 }
   Messarx,                  { ARX     - Textes des Messages de Base        }
   Fichiers;                 { ARX     - Gestion des fichiers et erreurs    }

TYPE
   Pnoeud               = ^noeud;
   Pvariable            = ^variable;

   Pboolean             = ^boolean;
   Pshortint            = ^shortint;
   Pbyte                = ^byte;
   Pinteger             = ^integer;
   Pword                = ^word;
   Plongint             = ^longint;
   Preal                = ^real;
   Pchar                = ^char;
   Pstring              = ^string;
   Plst_chn             = ^lst_chn;

   PVboolean            = ^v_boolean;
   PVshortint           = ^v_shortint;
   PVbyte               = ^v_byte;
   PVinteger            = ^v_integer;
   PVword               = ^v_word;
   PVlongint            = ^v_longint;
   PVreal               = ^v_real;
   PVchar               = ^v_char;
   PVstring             = ^v_string;
   PVlst_chn            = ^v_lst_chn;


   { types de donnes }

   lst_chn              = ^chaine;

   chaine               = record
                             nom       : Pstring;
                             elements,
                             suivant   : lst_chn;
                          end;


   { objets }

   liste     = object
                  trie    : boolean;
                  l       : Pnoeud;
                  max     : byte;

                  procedure init    (trier : boolean);
                  procedure ajoute  (p     : Pvariable);
                  function  cherche (v     : string) : Pvariable;
                  procedure lit     (nomf  : pathstr);
                  procedure ecrit   (nomf  : pathstr;  dat  : string);
                  procedure boite;
                  procedure fini;
               end;

   noeud     = record
                  objet   : Pvariable;
                  suivant : Pnoeud;
               end;

   variable  = object
                  nom     : Pstring;
                  ptr     : pointer;

                  constructor init (v : string; ptrv : pointer);
                  procedure   L;    virtual;
                  procedure   E;    virtual;
                  procedure   T;    virtual;
                  destructor  fini; virtual;
               end;

   v_boolean = object (variable)
                  constructor init (v : string; b : Pboolean; d : boolean);
                  procedure   L;    virtual;
                  procedure   E;    virtual;
                  procedure   T;    virtual;
               end;

   v_shortint= object (variable)
                  constructor init (v : string; i : Pshortint;d : shortint);
                  procedure   L;    virtual;
                  procedure   E;    virtual;
                  procedure   T;    virtual;
               end;

   v_byte    = object (variable)
                  constructor init (v : string; i : Pbyte;    d : byte);
                  procedure   L;    virtual;
                  procedure   E;    virtual;
                  procedure   T;    virtual;
               end;

   v_integer = object (variable)
                  constructor init (v : string; i : Pinteger; d : integer);
                  procedure   L;    virtual;
                  procedure   E;    virtual;
                  procedure   T;    virtual;
               end;

   v_word    = object (variable)
                  constructor init (v : string; i : Pword;    d : word);
                  procedure   L;    virtual;
                  procedure   E;    virtual;
                  procedure   T;    virtual;
               end;

   v_longint = object (variable)
                  constructor init (v : string; i : Plongint; d : longint);
                  procedure   L;    virtual;
                  procedure   E;    virtual;
                  procedure   T;    virtual;
               end;

   v_real    = object (variable)
                  constructor init (v : string; r : Preal;    d : real);
                  procedure   L;    virtual;
                  procedure   E;    virtual;
                  procedure   T;    virtual;
               end;

   v_char    = object (variable)
                  constructor init (v : string; s : Pchar;    d : char);
                  procedure   L;    virtual;
                  procedure   E;    virtual;
                  procedure   T;    virtual;
               end;

   v_string  = object (variable)
                  constructor init (v : string; s : Pstring;  d : string);
                  procedure   L;    virtual;
                  procedure   E;    virtual;
                  procedure   T;    virtual;
               end;

   v_lst_chn = object (variable)
                  constructor init (v : string; ls: Plst_chn; d : lst_chn);
                  procedure   L;    virtual;
                  procedure   E;    virtual;
                  procedure   T;    virtual;
               end;

VAR
   nbc,                                { !! nb car  sur la ligne }
   nbo                                 { nb objets  de la bote  }
                        : byte;

{---------------------------------------------------------------------------}

Function Cboolean (v : string; b : Pboolean;  d : boolean) : PVboolean;

Function Cshortint(v : string; i : Pshortint; d : shortint): PVshortint;

Function Cbyte    (v : string; i : Pbyte;     d : byte)    : PVbyte;

Function Cinteger (v : string; i : Pinteger;  d : integer) : PVinteger;

Function Cword    (v : string; i : Pword;     d : word)    : PVword;

Function Clongint (v : string; i : Plongint;  d : longint) : PVlongint;

Function Creal    (v : string; r : Preal;     d : real)    : PVreal;

Function Cchar    (v : string; s : Pchar;     d : char)    : PVchar;

Function Cstring  (v : string; s : Pstring;   d : string)  : PVstring;

Function Clst_chn (v : string; ls: Plst_chn;  d : lst_chn) : PVlst_chn;


{---------------------------------------------------------------------------}
   { gestion des listes }

Procedure modif_nom_chn         (l      : lst_chn ; nom : string);
   { modifie la valeur du champ nmo                                         }

Procedure cree_nom_chn          (l      : lst_chn ; nom : string);
   { cre un lment                                                        }

Function element_existe         (l      : lst_chn ; nom : string) : boolean;
   { rend VRAI si nom est trouv                                            }

Function der_element            (l      : lst_chn)                : lst_chn;
   { rend le dernier pointeur <> nil                                        }

Function p_element              (l      : lst_chn ; nom : string) : lst_chn;
   { rend le pointeur sur l'lment  NIL si non trouv                      }

Function compte_elements        (l      : lst_chn)                 : integer;
   { rend le nombre d'lments au premier niveau                            }

Procedure trier_elements_liste  (var l  : lst_chn);
   { trie le champ ELEMENTS.nom de la liste (croissant)                     }

Procedure supprimer_nom_chaine  (var l  : lst_chn; nom : string);
   { libre rcursivement un lment de la liste                            }

Procedure ajouter_nom_chaine    (var l  : lst_chn; nom : string);
   { cre et ajoute un lment en queue de liste                            }

Procedure liberer_liste_chaine  (var l  : lst_chn);
   { libre une liste rcursivement                                         }

{---------------------------------------------------------------------------}

IMPLEMENTATION

TYPE
   ens                  = set of char;

CONST
   e                    : ens = ['(', ')', ';'];

VAR
   ok                   : boolean;
   f                    : text;
   chain                : string;

procedure epure                 (var s : string);
   const
      e                 : ens = [#10, #13, ' '];

   var
      i                 : integer;

   begin
      i := 1;
      while  (i <= length (s)) and (s [i] in e)
      do
         i := i+1;
      i := i-1;
      delete (s, 1, i);

      i := length (s);
      while (i>= 1) and (s [i] in e) do i := i-1;
      i := i+1;
      delete (s, i, length (s)-i+1);
   end;

procedure lire_mot              (var s          : string;
                                 var e          : ens;
                                 var a          : char);
   begin
      read (f, a);
      s := '';
      if not (a in e)
      then
         if not eof (f)
         then begin
            repeat
               s := s+a;
               read (f, a);
            until (a in e) or eof (f);
            epure (s);
         end;
   end;

function lire                   (var res : string;
                                 lim     : string)              : boolean;
   var
      test,
      fin               : boolean;
      a                 : char;
      i                 : integer;

   begin
      test := false;

      if eoln (f)
      then begin
         read (f, a, a);
      end else begin
         fin := false;
         res := '';
         repeat
            read (f, a);
            if test
            then begin
               if  (a = lim [i])
               then begin
                  i := i+1;
                  if i > length (lim)
                  then
                     fin := true;
               end else begin
                  res  := res+copy (lim, 1, i);
                  test := false;
               end;
            end else begin
               if  (a = lim [1])
               then begin
                  i := 2;
                  if 2 > length (lim)
                  then
                     fin := true;
                  test := true;
               end else begin
                  res := res+a;
               end;
            end;

            if eoln (f)
            then begin
               read (f, a, a);
               if not fin
               then begin
                  fin := true;
                  if test
                  then
                     res := res+copy (lim, 1, i);
                  test := false;
               end;
            end;
         until fin;
         if test
         then
            epure (res);
      end;
      lire := test;
   end;

procedure ajouter_nom_chaine    (var  l         : lst_chn ;
                                 nom            : string);
   { cre et ajoute un lment en queue }

   var
      p_ct,
      n_el              : lst_chn;

   begin
      new          (n_el);
      cree_nom_chn (n_el, nom);
                    n_el^.suivant  := nil;
                    n_el^.elements := nil;

      { chaner en queue }
      if l = nil
      then
         l := n_el
      else begin
         p_ct  := l;
         while p_ct^.suivant <> nil
         do
            p_ct   := p_ct^.suivant;
         p_ct^.suivant := n_el;
      end;
   end;

procedure supprimer_nom_chaine  (var l : lst_chn; nom : string);
   var
      p_ct, p_pre       : lst_chn;
      trouve            : boolean;

   begin
      if l = nil
      then
         exit;

      if l^.nom^ <> nom
      then begin            { ce n'est pas le premier }
         p_ct    := l;
         p_pre   := l;
         trouve  := false;

         while not trouve and (p_ct <> nil)
         do begin
            p_pre  := p_ct;
            p_ct   := p_ct^.suivant;
            trouve := p_ct^.nom^ = nom;
         end;

         if trouve
         then begin
            p_pre^.suivant := p_ct^.suivant;
            { librer tout en dessous }
            p_ct^.suivant := nil;
            liberer_liste_chaine (p_ct);
         end;
      end else begin  { supprimer le premier lment }
         p_ct := l;
         l    := l^.suivant;
         p_ct^.suivant := nil;
         liberer_liste_chaine (p_ct);
      end;
   end;

procedure modif_nom_chn         (l : lst_chn; nom : string);
   begin
      freemem (l^.nom, length (l^.nom^) +1);
      getmem  (l^.nom, length (nom) +1);
      l^.nom^ := nom;
   end;

procedure cree_nom_chn          (l : lst_chn; nom : string);
   begin
      getmem  (l^.nom, length (nom) +1);
      l^.nom^ := nom;
   end;

function element_existe         (l  : lst_chn ; nom : string) : boolean;
   {}
   var
      ok                : boolean;

   begin
      ok := false;
      while (l <> nil) and not ok
      do begin
         ok := l^.nom^=nom;
         l  := l^.suivant;
      end;
      element_existe := ok;
   end;

function der_element    (l  : lst_chn)  : lst_chn;
   var
      p_ct              : lst_chn;

   begin
      p_ct := l;
      while (l <> nil)
      do begin
         p_ct := l;
         l    := l^.suivant;
      end;
      der_element := p_ct;
   end;

function p_element              (l : lst_chn ; nom : string) : lst_chn;
   { rend le pointeur sur l'lment  NIL si non trouv  }
    var
      p                 : lst_chn;
      ok                : boolean;

   begin
      p  := nil;
      ok := false;
      while (l <> nil) and not ok
      do begin
         ok := l^.nom^=nom;
         if ok then p := l;
         l  := l^.suivant;
      end;
      p_element := p;
   end;

function compte_elements        (l : lst_chn) : integer;
   var
      nbe               : integer;

   begin
      nbe  := 0;
      while l <> nil
      do begin
         l := l^.suivant;
         inc (nbe)
      end;
      compte_elements := nbe;
   end;

procedure trier_elements_liste  (var l : lst_chn);
   var
      ante,
      p_ct, p_pre,
      p_suiv            : lst_chn;
      inv               : boolean;
      v1, v2            : real;
      err               : integer;

   begin
      if l = nil then exit;
      repeat
          inv   := false;
          p_pre := l;
          p_ct  := l^.suivant;
          ante  := l;
          while p_ct <> nil
          do begin
             val (p_pre^.elements^.nom^, v1, err);
             val (p_ct^.elements^.nom^, v2, err);
             if v1 > v2
             then begin
                p_suiv          := p_ct^.suivant;
                p_ct^.suivant   := p_pre;
                p_pre^.suivant  := p_suiv;
                if p_pre = l
                then
                   l := p_ct
                else
                   ante^.suivant := p_ct;

                p_ct := p_pre;
                p_pre := p_ct;
                inv  := true;
             end;
             ante  := p_pre;
             p_pre := p_ct;
             p_ct  := p_ct^.suivant;
          end;
      until not inv;
   end;

function lire_chn : lst_chn;
   var
      n                 : lst_chn;
      s                 : string;
      a                 : char;
      nul               : boolean;

   begin
      n := nil;
      lire_mot (s, e, a);

      if a = '('
      then begin
         new (n);
         getmem (n^.nom, length (s) + 1);
         n^.nom^ := s;
         n^.elements := lire_chn;
         n^.suivant  := nil;
         lire_mot (s, e, a);
         if      a=';' then n^.suivant := lire_chn
{         else if a='(' then erreur};
      end else begin
         case a of
            ')' : begin
                     if s<>''
                     then begin
                        new(n);
                        getmem (n^.nom, length (s)+1);
                        n^.nom^ := s;
                        n^.elements := nil;
                        n^.suivant  := nil;
                     end;
                  end;

            ';' : begin
                     if s<>''
                     then begin
                        new(n);
                        getmem (n^.nom, length (s)+1);
                        n^.nom^ := s;
                        n^.elements := nil;
                        n^.suivant  := lire_chn;
                     end;
                  end;
         end;
      end;

      lire_chn := n;
   end;

function nb                     (n : integer) : string;
   var
      s                 : string;
      i                 : integer;

   begin
      s := '';
      for i := 1 to n do s := s+' ';
      nb := s;
   end;

procedure liberer_liste_chaine ( var l : lst_chn);
   begin
      if (l <> nil)
      then begin
         liberer_liste_chaine (l^.elements);
         liberer_liste_chaine (l^.suivant);
         if length (l^.nom^ ) > 0
         then
            freemem (l^.nom, length (l^.nom^)+1);
         dispose (l);
         l := nil;
      end;
   end;

procedure aff_chn               (n : lst_chn ; d : integer);
   begin
      if n = nil
      then begin
        { writeln (f);}
         write   (f , {nb (d),} ')');   {      ecrit par alain }
      end else begin
         write (f, nb (d+3), n^.nom^);

         if n^.elements <> nil
         then begin
            {writeln (f, '('); }    { alain }
            writeln (f);
            write   (f,  nb (d+3), '(');       { rc }
            aff_chn (n^.elements, d+3);     { rc }
         end;

         if n^.suivant  <> nil
         then
            writeln (f,';');
         aff_chn (n^.suivant, d);
      end;
   end;

procedure ecrire                (s : string ; l : byte);
   var
      i                 : byte;

   begin
      write (f, s);
      for i  :=  1 to l+1-length (s)
      do
         write (f, ' ');
      write (f, ' :=  ') ;
   end;

procedure erreur                (s : string);
   begin
      { cette variable a dj t dclare ! }
      restorecrtmode;
      writeln  (mt_erreur_variable+' ', s, ' '+mt_erreur_variables);
      runerror (999);
   end;

procedure liste.init            (trier : boolean);
   begin
      l    := nil;
      max  := 0;
      trie := trier;
   end;

procedure liste.ajoute          (p : pvariable);
   var
      n1, n2            : Pnoeud;

   begin
      new (n1);
      n1^.objet   := p;
      if length (p^.nom^) > max
      then
         max := length (p^.nom^);

      if trie
      then begin
         if (l = nil) or (n1^.objet^.nom^ < l^.objet^.nom^)
         then begin
            n1^.suivant := l;
            l           := n1;
         end else
            if   (n1^.objet^.nom^ = l^.objet^.nom^)
            then begin
               erreur (n1^.objet^.nom^);
            end else begin
               n2 := l;

               while (n2^.suivant <> nil) and
                     (n1^.objet^.nom^ > n2^.suivant^.objet^.nom^)
               do
                  n2 := n2^.suivant;

               if (n2^.suivant <> nil) and
                  (n1^.objet^.nom^ = n2^.suivant^.objet^.nom^)
               then
                  erreur (n1^.objet^.nom^)
               else begin
                  n1^.suivant := n2^.suivant;
                  n2^.suivant := n1;
               end;
            end;
      end else begin
         if (l = nil)
         then begin
            n1^.suivant := nil;
            l           := n1;
         end else
            if   (n1^.objet^.nom^ = l^.objet^.nom^)
            then begin
               erreur (n1^.objet^.nom^);
            end else begin
               n2 := l;

               while (n2^.suivant <> nil)
               do begin
                  n2 := n2^.suivant;
                  if (n1^.objet^.nom^ = n2^.objet^.nom^)
                     then erreur (n1^.objet^.nom^);
               end;

               n1^.suivant := nil;
               n2^.suivant := n1;
            end;
      end;
   end;

function  liste.cherche         (v : string) : pvariable;
   var
      n                 : pnoeud;

   begin
      n := l;
      while (n <> nil) and (maj (n^.objet^.nom^) <> maj (v))
      do
         n := n^.suivant;
      if n = nil
         then
            cherche := nil
         else
            cherche := n^.objet;
   end;

procedure liste.lit             (nomf : pathstr);
   var
      nom               : string;
      p                 : pvariable;
      ok                : boolean;

   begin
      if nomf = ''
      then begin
         nomf := 'CON';
         writeln (mt_entrer_par);
      end;

      assign (f, nomf);
      resettxterr (f, nomf, ok);
      if not ok then exit;

      repeat
      { liminer les commentaires, reconnatre le nom et L la donne. }
         if lire (nom, ':=')
         then begin
            p := cherche (nom);
            if p <> nil then p^.L;
         end;
      until eof (f);

      close (f);
   end;

procedure liste.ecrit           (nomf : pathstr ; dat : string);
   var
      nom               : string;
      n                 : Pnoeud;
      p                 : Pvariable;
      ok                : boolean;

   begin
      if nomf = ''    then nomf  :=  'CON';
      assign        (f, nomf);
      rewritetxterr (f, nomf, ok);
      if not ok then exit;

      writeln (f, ';'+nomf+ ' - '+dat);
                                    { nom du fichier et date en commentaire }
      n := l;
      while n <> nil
      do begin
         ecrire (n^.objet^.nom^, max);
         n^.objet^.E;
         n := n^.suivant;
      end;
      writeln (f, ';--------------------------------------- '+nomf);
      close   (f);
   end;

procedure liste.boite ;
   var
      nom               : string;
      n                 : Pnoeud;
      p                 : Pvariable;

   function blancs : string;
      var
         bl             : string;
         i              : byte;

      begin
         bl := '';
         for i := 1 to max+1-length (nom)
         do
             bl := bl +' ';
         blancs := bl;
      end;

   begin
      n   := l;
      nbo := 0;
      nbc := max;
      while n <> nil
      do begin
         inc (nbo);
         nom := n^.objet^.nom^;
         listchaine^ [nbo] := nom + blancs + ':=';
         n^.objet^.T;
         n := n^.suivant;
      end;
      inc (nbo);
      listchaine^ [nbo] := '';
   end;

procedure liste.fini;
   var
      n                 : pnoeud;

   begin
      while l <> nil
      do begin
         n := l^.suivant;
         dispose (l^.objet, fini);
         dispose (l);
         l := n;
      end;
   end;

constructor variable.init (v : string; ptrv : pointer);
   begin
      epure (v);
      getmem (nom, length (v) +1);
      nom^ := v;
      ptr := ptrv;
   end;

procedure   variable.L;
   var
      a                 : char;

   begin
      repeat
         read (f, a);
      until (a = ';') or eof (f);
   end;

procedure   variable.E;
   begin
      writeln (f,' ;');
   end;

procedure   variable.T;
   begin
      listchaine^ [nbo] := listchaine^ [nbo]+ chain;
      if length (listchaine^ [nbo]) > nbc
      then
         nbc := length (listchaine^ [nbo]);
   end;

destructor  variable.fini;
   begin
      freemem (nom, length (nom^) + 1);
   end;

function Cboolean (v : string; b : Pboolean;  d : boolean) : PVboolean;
   begin
      Cboolean  := new (PVboolean, init (v, b, d));
   end;

function Cshortint(v : string; i : Pshortint; d : shortint): PVshortint;
   begin
      Cshortint := new (PVshortint, init (v, i, d));
   end;

function Cbyte    (v : string; i : Pbyte;     d : byte)    : PVbyte;
   begin
      Cbyte     := new (PVbyte   , init (v, i, d));
   end;

function Cinteger (v : string; i : Pinteger;  d : integer) : PVinteger;
   begin
      Cinteger  := new (PVinteger, init (v, i, d));
   end;

function Cword    (v : string; i : Pword;     d : word)    : PVword;
   begin
      Cword     := new (PVword,    init (v, i, d));
   end;

function Clongint (v : string; i : Plongint;  d : longint) : PVlongint;
   begin
      Clongint  := new (PVlongint, init (v, i, d));
   end;

function Creal    (v : string; r : Preal;     d : real)    : PVreal;
   begin
      Creal     := new (PVreal  ,  init (v, r, d));
   end;

function Cchar    (v : string; s : Pchar;     d : char)    : PVchar;
   begin
      Cchar     := new (PVchar  ,  init (v, s, d));
   end;

function Cstring  (v : string; s : Pstring;   d : string)  : PVstring;
   begin
      Cstring   := new (PVstring , init (v, s, d));
   end;

function Clst_chn (v : string; ls: Plst_chn;  d : lst_chn) : PVlst_chn;
   begin
      Clst_chn  := new (PVlst_chn, init (v, ls, d));
   end;

constructor v_boolean.init (v : string; b : Pboolean;  d : boolean);
   begin
      variable.init (v, b);
      b^ := d;
   end;

constructor v_shortint.init(v : string; i : Pshortint; d : shortint);
   begin
      variable.init (v, i);
      i^ := d;
   end;

constructor v_byte.init    (v : string; i : Pbyte;     d : byte);
   begin
      variable.init (v, i);
      i^ := d;
   end;

constructor v_integer.init (v : string; i : Pinteger;  d : integer);
   begin
      variable.init (v, i);
      i^ := d;
   end;

constructor v_word.init    (v : string; i : Pword;     d : word);
   begin
      variable.init (v, i);
      i^ := d;
   end;

constructor v_longint.init (v : string; i : Plongint;  d : longint);
   begin
      variable.init (v, i);
      i^ := d;
   end;

constructor v_real.init    (v : string; r : Preal;     d : real);
   begin
      variable.init (v, r);
      r^ := d;
   end;

constructor v_char.init    (v : string; s : Pchar;     d : char);
   begin
      variable.init (v, s);
      s^ := d;
   end;

constructor v_string.init  (v : string; s : Pstring;   d : string);
   begin
      variable.init (v, s);
      s^ := d;
   end;

constructor v_lst_chn.init (v : string; ls: Plst_chn; d : lst_chn);
   begin
      variable.init (v, ls);
      ls^ := d;
   end;

procedure v_shortint.L; var i : Pshortint absolute ptr;
   begin
      read (f, i^);
      variable.L;
   end;

procedure v_byte.L;     var i : Pbyte     absolute ptr;
   begin
      read (f, i^);
      variable.L;
   end;

procedure v_integer.L;  var i : Pinteger  absolute ptr;
   begin
      read (f, i^);
      variable.L;
   end;

procedure v_word.L;     var i : Pword     absolute ptr;
   begin
      read (f, i^);
      variable.L;
   end;

procedure v_longint.L;  var i : Plongint  absolute ptr;
   begin
      read (f, i^);
      variable.L;
   end;

procedure v_real.L;     var r : Preal     absolute ptr;
   begin
      read (f, r^);
      variable.L;
   end;

procedure v_boolean.L;
   var
      b                 : Pboolean absolute ptr;
      a                 : char;
      s                 : string;

   begin
      b^ := false;
      repeat read (f, a) until (a <> ' ') or eof (f);

      if (not eof (f)) and (a <> ';')
      then begin
         s := '';
         repeat
            s := s+upcase (a);
            read(f, a)
         until (a in [';', ' ']) or eof (f);

         b^ :=  (s = 'TRUE') or (s = 'T')
             or (s = 'VRAI') or (s = 'V');

         if a <> ';'
         then
            variable.L;
      end;
   end;

procedure v_char.L;
   var
      s                 : Pchar absolute ptr;
      a                 : char;
      p                 : byte;

   begin
      repeat read (f, a) until (a in ['''', ';', '#']) or eof (f);

      case a of
         '''': read (f, s^);
         '#' : begin
                  read (f, p);
                  s^ := chr (p);
               end;
      else
         s^ := chr (0);
      end;

      if a <> ';' then variable.L;
   end;

procedure v_string.L;
   var
      s                 : Pstring absolute ptr;
      a                 : char;
      fin               : boolean;

   begin
      repeat read (f, a)
      until
          (a in ['''', ';']) or eof (f);

      if a = ''''
      then begin
         s^  := '';
         fin := false;
         repeat
            read (f, a);
            if a <> ''''
            then begin
               s^ := s^+a;
            end else begin
               a := ' ';
               if not eof (f)
               then
                  read (f, a);

               if a <> ''''
               then
                  fin := true
               else
                  s^ := s^+a;
            end;
         until fin;
      end;

      if a <> ';'
      then
         variable.L;
   end;

procedure v_lst_chn.L;
   var
      ls                : Plst_chn absolute ptr;
      s                 : string;
      a                 : char;

   begin
      lire_mot (s, lipar.e, a);
      if a = '(' then ls^ := lire_chn
                 else ls^ := nil;
      variable.L;
   end;

procedure v_boolean.E;  var b : Pboolean  absolute ptr;
   begin
      write (f, b^);
      variable.E;
   end;

procedure v_shortint.E; var r : Pshortint absolute ptr;
   begin
      write (f, r^);
      variable.E;
   end;

procedure v_byte.E;     var r : Pbyte     absolute ptr;
   begin
      write (f, r^);
      variable.E;
   end;

procedure v_integer.E;  var r : Pinteger  absolute ptr;
   begin
      write (f, r^);
      variable.E;
   end;

procedure v_word.E;     var r : Pword     absolute ptr;
   begin
      write (f, r^);
      variable.E;
   end;

procedure v_longint.E;  var r : Plongint  absolute ptr;
   begin
      write (f, r^);
      variable.E;
   end;

procedure v_real.E;     var r : Preal     absolute ptr;
   begin
      write (f, r^:0:2);
      variable.E;
   end;

procedure v_char.E;
   var
      s                 : Pchar absolute ptr;

   begin
      if (ord (s^) < 33) or (ord (s^) > 127)
      then
         write (f, '#', ord (s^))
      else
         write (f, '''', s^, '''');

      variable.E;
   end;

procedure v_string.E;
   var
      s                 : Pstring absolute ptr;
      i                 : byte;

   begin
      write (f,'''');
      for i := 1 to length (s^)
      do
         if s^[i] = '''' then write (f, '''''')
                         else write (f, s^ [i]);
      write (f, '''');
      variable.E;
   end;

procedure v_lst_chn.E;
   var
      ls                : Plst_chn absolute ptr;

   begin
      writeln (f);
      write   (f, '(');    {rc}
      aff_chn (ls^, 0);
      variable.E;
   end;

procedure v_boolean.T;  var b : Pboolean  absolute ptr;
   begin
      if b^
      then chain := VRAI
      else chain := FAUX;
      variable.T;
   end;

procedure v_shortint.T; var r : Pshortint absolute ptr;
   begin
      str (r^, chain);
      variable.T;
   end;

procedure v_byte.T;     var r : Pbyte     absolute ptr;
   begin
      str (r^, chain);
      variable.T;
   end;

procedure v_integer.T;  var r : Pinteger  absolute ptr;
   begin
      str (r^, chain);
      variable.T;
   end;

procedure v_word.T;     var r : Pword     absolute ptr;
   begin
      str (r^, chain);
      variable.T;
   end;

procedure v_longint.T;  var r : Plongint  absolute ptr;
   begin
      str (r^, chain);
      variable.T;
   end;

procedure v_real.T;     var r : Preal     absolute ptr;
   begin
      str (r^:0:2, chain);
      variable.T;
   end;

procedure v_char.T;
   var
      s                 : Pchar absolute ptr;

   begin
      if (ord (s^) < 33) or (ord (s^) > 127)
      then begin
         str (ord (s^), chain);
         chain := '#'+ chain;
      end else
         chain := s^;
      variable.T;
   end;

procedure v_string.T;
   var
      s                 : Pstring absolute ptr;

   begin
      chain := s^;
      variable.T;
   end;

procedure v_lst_chn.T;
   var
      ls                : Plst_chn absolute ptr;

   function listedesnoms : string;
      var
         p              : lst_chn;
         l              : string;
         lg             : word;

      function abrege (coef : integer) : string;
         var
            p           : lst_chn;
            l           : string;
            ln          : word;

         begin
             if coef <= 0
             then
                abrege := l;

             p  := ls^;
             l  := '';
             while p <> nil
             do begin
                if (p^.nom^ <> Region) and (p^.nom^ <> Activite)
                then begin
                   ln := length (p^.nom^) ;
                   l  := l+' '+copy (p^.nom^, 1, ln div coef);
                end;
                p  := p^.suivant;
             end;
             abrege := l;
         end;

      begin
         p  := ls^;
         listedesnoms := liste_vide;
         l  := '';
         while p <> nil
         do begin
            if (p^.nom^ <> Region) and (p^.nom^ <> Activite)
            then
               l  := l+' '+p^.nom^;
            p  := p^.suivant;
         end;

         lg := length (l);

         if lg > maxcar div  2
         then
            l := abrege (lg div (maxcar div 2));

         listedesnoms := l;
      end;

   begin
      chain  := listedesnoms;                 { la liste entire }
      variable.T;
   end;

END.

{--- LIPAR -------------------------------------------------- ARX - BALMA --}
