UNIT Modele;

         {ͻ}
         {   Gestion des polygones                            }
         {   Version 1.0                                      }
         {͹}
         {                                                    }
         {                                                    }
         {                                                    }
         {ͼ}

   (*
   Modele,                   { ARX     - Gestion des "roches"               }
   *)

INTERFACE
   {========================================================================}

USES
   Graph,
   Objects,                  { TP 70   - units standard Borland            }
   Graphplt,                 { ARX     - graphisme 2D cran/traceur         }
   Polygon;                  { ARX     - Gestion des polygones              }

TYPE
   {------------------------------------------------------------------------}
   { Objet Roche }
   PRoche = ^TRoche;    { N 502 }
   TRoche = object (TPoly)
      Densite           { Densite de la roche }
                        : real;
      Couleur           {}
                        : integer;
      constructor Init;
      constructor load  (var S : TStream);
      procedure   Store (var S : TStream);
      procedure   Sommets;
      procedure   Dessiner; virtual;
      procedure   Peindre;  virtual;
      procedure   Effacer;
      procedure   Afficher (t : string; coul : word);
      procedure   Marquer;  virtual;
   end;

   {------------------------------------------------------------------------}
   { Objet modele }
   PModele = ^TModele;  { N 503 }
   TModele = object (TCollection)
      constructor Init;
      constructor load  (var S : TStream);
      procedure   Store (var S : TStream);
      function    SegmentCoupe  (Point1, Point2: PPoint) : boolean;
      function    Coupe         (P    : PRoche) : boolean;
      function    PolyContenant (x, y : real)   : pointer;
      function    Contient      (x, y : real)   : boolean;
      procedure   Peindre;  virtual;
      procedure   Dessiner; virtual;
      procedure   Borner;
      destructor  fini;
   end;

   {------------------------------------------------------------------------}

TYPE
   TTraceVers     = Procedure (x, y      : real);
   TDeplaceEn     = Procedure (x, y      : real);
   TCercle        = Procedure (xc, yc, r : real);
   TPolygonePlein = Procedure (n         : integer; var p : polygone);

Procedure Recensement;
   {}

Procedure DefTraceVers     (PTraceVers : TTraceVers);
   {}

Procedure DefDeplaceEn     (PDeplaceEn : TDeplaceEn);
   {}

Procedure DefCercle        (PCercle    : TCercle);
   {}

Procedure DefPolygonePlein (PPolygonePlein : TPolygonePlein);
   {}

Procedure DupliquerRoche   (var P1, P2 : PRoche);
   {}

Procedure DupliquerModele  (var M1, M2 : PModele);
   {}

   {========================================================================}
IMPLEMENTATION

CONST

   RRoche : TStreamRec = (
      ObjType : 502;
      VmtLink : Ofs (TypeOf(TRoche)^);
      Load    : @TRoche.Load;
      Store   : @TRoche.Store );

   RModele : TStreamRec = (
      ObjType : 503;
      VmtLink : Ofs (TypeOf(TModele)^);
      Load    : @TModele.Load;
      Store   : @TModele.Store );

   Epsilon  = 1.2345E-38;
   Epsilon2 = 5.4321E-38;

VAR
   VCercle : TCercle;

procedure Recensement;
begin
   Polygon.Recensement;
   RegisterType (RRoche);
   RegisterType (RModele);
end;

procedure DefTraceVers (PTraceVers : TTraceVers);
begin
   Polygon.DefTraceVers (PTraceVers);
end;

procedure DefDeplaceEn (PDeplaceEn : TDeplaceEn);
begin
   Polygon.DefDeplaceEn (PDeplaceEn);
end;

procedure DefCercle (PCercle : TCercle);
begin
   VCercle := PCercle;
end;

procedure DefPolygonePlein (PPolygonePlein : TPolygonePlein);
begin
   Polygon.DefPolygonePlein (PPolygonePlein);
end;

procedure CercleNul (xc, yc, r : real); far;
begin
end;

constructor TRoche.Init;
   {------------------------------------------------------------------------}
   { ROLE Initialiser l'objet.                                              }
   {------------------------------------------------------------------------}
var
   i : integer;

begin
   {* INITIALISATION DE L'ANCETRE }
   TPoly.Init;
   {* INITIALISATION DES VALEURS }
   Densite := 2;
   Couleur := 1;
end;

constructor TRoche.load (var S : TStream);
   {------------------------------------------------------------------------}
   { ROLE Charger l'objet  partir du flux S.                               }
   {------------------------------------------------------------------------}
begin
   {* LECTURE DE L'ANCETRE }
   TRoche.Load (S);
   {* LECTURE DES DONNEES PROPRES A L'OBJET }
   S.read (Densite, sizeof (Densite));
   S.read (Couleur, sizeof (Couleur));
end;

procedure  TRoche.Store (var S : TStream);
   {------------------------------------------------------------------------}
   { ROLE Sauver l'objet dans le flux S.                                    }
   {------------------------------------------------------------------------}
begin
   {* SAUVEGARDE DE L'ANCETRE }
   TPoly.Store (S);
   {* SAUVEGARDE DES DONNEES }
   S.write (Densite, sizeof (Densite));
   S.write (Couleur, sizeof (Couleur));
end;

procedure  TRoche.Sommets;
   {------------------------------------------------------------------------}
   { ROLE                                                                   }
   {------------------------------------------------------------------------}
   procedure Appel (P : PPoint); far;
   begin
      Rectangle (XCloture(P^.x)-1, YCloture(P^.y)-1,
                 XCloture(P^.x)+1, YCloture(P^.y)+1);
   end;

begin
   Contour.ForEach (@Appel);
end;

procedure  TRoche.Dessiner;
   {------------------------------------------------------------------------}
   { ROLE                                                                   }
   {------------------------------------------------------------------------}
begin
   TPoly.Dessiner;
   Sommets;
end;

procedure  TRoche.Peindre;
   {------------------------------------------------------------------------}
   { ROLE Peint la roche avec sa couleur (contour de la couleur courante)   }
   {------------------------------------------------------------------------}
begin
   SetFillStyle (SolidFill, Couleur);
   TPoly.Peindre;
   Sommets;
end;

procedure  TRoche.Effacer;
   {------------------------------------------------------------------------}
   { ROLE                                                                   }
   {------------------------------------------------------------------------}
begin
   TPoly.Peindre;
   TPoly.Dessiner;
   Sommets;
end;

procedure  TRoche.Marquer;
   {------------------------------------------------------------------------}
   { ROLE                                                                   }
   {------------------------------------------------------------------------}
   procedure AppelCercle (P : PPoint); far;
   begin
      VCercle (P^.x, P^.y, 5);
   end;

begin
   Contour.ForEach (@AppelCercle);
end;

procedure  TRoche.Afficher;
{------------------------------------------------------------------------}
{ ROLE                                                                   }
{------------------------------------------------------------------------}

begin
   fixetrait  (0);
   fixecoul   (coul);
   setusercharsize (4, 3, 4, 3);
   DeplaceEnT (x, y);
   TTexte     (t, 1, 1);
   setusercharsize (3, 2, 3, 2);
end;

constructor TModele.Init;
   {------------------------------------------------------------------------}
begin
   TCollection.Init (0, 1);
end;

constructor TModele.load (var S : TStream);
   {------------------------------------------------------------------------}
begin
   TCollection.Load (S);
end;

procedure  TModele.Store (var S : TStream);
   {------------------------------------------------------------------------}
begin
   TCollection.Store (S);
end;

procedure TModele.Dessiner;
   {------------------------------------------------------------------------}
   procedure AppelDessine (P : PObjetGraphique); far;
   begin
      P^.Dessiner;
   end;
begin
   ForEach (@AppelDessine);
end;

procedure TModele.Peindre;
   {------------------------------------------------------------------------}
   procedure Appel (P : PRoche); far;
   begin
      P^.Peindre;
   end;

begin
   ForEach (@Appel);
end;

function TModele.SegmentCoupe    (Point1, Point2: PPoint) : boolean;
   {------------------------------------------------------------------------}
var
   Coup                  : boolean;

   procedure TestCoup (T : PPoly); far;
   var
      n : integer;
      x, y : real;
   begin
      if T^.SegmentCoupe (Point1, Point2, x, y) then Coup := true;
   end;

begin
   Coup := false;
   ForEach (@Testcoup);
   SegmentCoupe := Coup;
end;

function TModele.Coupe (P : PRoche) : boolean;
   {------------------------------------------------------------------------}
var
   i,
   np1, np2 : integer;
   pt1, pt2 : PPoint;

begin
   Coupe := false;
   for i := 1 to P^.count
   do begin
      np1 := i-1;
      np2 := i mod P^.count;
      pt1 := P^.at (np1);
      pt2 := p^.at (np2);
      if SegmentCoupe (pt1, pt2)
      then begin
         Coupe := true;
         exit;
      end;
   end;
end;

function TModele.PolyContenant (x, y : real) : pointer;
   {------------------------------------------------------------------------}
var
   TC : PPoly;

   procedure Test (T : PPoly); far;
   begin
      if T^.Contient (x, y) then TC := T;
   end;

begin
   TC := NIL;
   ForEach (@Test);
   PolyContenant := TC;
end;

function TModele.Contient (x, y : real) : boolean;
   {------------------------------------------------------------------------}
var
   TC : boolean;

   procedure Test (T : PPoly); far;
   begin
      if T^.Contient (x, y) then TC := true;
   end;

begin
   TC := false;
   ForEach (@Test);
   Contient := TC;
end;

procedure TModele.Borner;
   procedure AppelBorner (P: PRoche); far;
   begin
      P^.Borner;
   end;

begin
   ForEach (@AppelBorner);
end;

destructor TModele.Fini;
   {------------------------------------------------------------------------}
var
   i, n  : integer;
   Roche : PRoche;

begin
   n := Count-1;
   for i:=0 to n
   do begin
      Roche := at (0);
      Dispose (Roche, fini);
      AtDelete (0);
   end;
   TCollection.done;
end;

procedure DupliquerRoche (var P1, P2 : PRoche);
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
var
   npt     : integer;
   pt1, pt : PPoint;

begin
   P2 := new (PRoche, init);
   for npt := 1 to P1^.count
   do begin
      pt1 := P1^.at (npt-1);
      pt  := new (PPoint, init);
      pt^ := pt1^;
      P2^.insert (pt);
   end;
   p2^.Densite := p1^.Densite;
   p2^.Couleur := p1^.Couleur;
   p2^.xmini := p1^.xmini;
   p2^.xmaxi := p1^.xmaxi;
   p2^.ymini := p1^.ymini;
   p2^.ymaxi := p1^.ymaxi;
   p2^.x := p1^.x;
   p2^.y := p1^.y;
end;

procedure DupliquerModele (var M1, M2 : PModele);
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
var
   nbr     : integer;
   r1, r   : PRoche;

begin
   M2 := new (PModele, init);
   for nbr := 1 to M1^.count
   do begin
      r1 := M1^.at (nbr-1);
      DupliquerRoche (r1, r);
      M2^.insert (r);
   end;
end;

   {========================================================================}

BEGIN

   DefCercle (CercleNul);

END.
