UNIT GRAV_VAR;

   {------------------------------------------------------------------------}
   {      logiciel GEOCEAN                                                  }
   {                  variables globales du module GRAV                     }
   {                                                   10/10/93             }
   {------------------------------------------------------------------------}

INTERFACE

{$O+,F+}

USES
   dos,
   Objects,                  { TP 70   - units standard Borland            }
   Graphism,                 { ARX     - initialisations graphiques         }
   Polygon,                  { ARX     - gestion des objets graphiques      }
   Modele,                   { ARX     - Gestion des "roches"               }

   GEO_var;                  { GEO     - variables globales communes        }

CONST
   repexo         = 'exo_grv'; { Nom du rpertoire des exos                 }
   extCOR         = '.GAM';    { Fichier corps                              }
   extGRA         = '.GRA';    { Fichier anomalies gravimtriques           }
   extvs          = '.DAT';    { Extension profils sismiques                }
   DistanceLimite =     5;     { Distance limite de fermeture des polygones }
   FinPoly        =  9999.99;  { Terminateur liste couples de points        }
   NbMaxStations  =   120;     { nombre stations sur un profil              }
   NbMaxPoints    =   360;     { nombre max points calculs sur un profil   }
   dc1            =     2.9;   { densit par dfaut de la couche 1          }
   dc2            =     3.3;   { sert au test de modif des couches          }
   dc3            =     3.25;  { sert au test de modif des couches          }
   pc1            =    -7;     { profondeurs modle  3 couches             }
   pc2            =   -70;     {                                            }
   pc3            =  -300;     {                                            }

   {$I grav_msg.pas}           { constantes des messages en Franais        }

TYPE
   DesCouches           = Array [1..5]
                             of record
                                Profondeur,
                                Densite      : real;
                          end;

   S                    = array [1..NbMaxStations]
                             of real;

VAR
   LeModele,               { Liste des polygones initiaux           }
   Contrastes              { Liste des polygones dcoups / couches }
                        : PModele;

   RocheCourante           { Corps = polygone + attributs           }
                        : PRoche;

   PointCourant            { }
                        : PPoint;

   FichierModele           { }
                        : TBufStream;

   Couches                 { structure de rfrence                         }
                        : DesCouches;

   NbCouches,              { Nombre de couches                              }
   NbStations              { Nombre de stations dans le profil              }
                        : integer;

   stationX,               { abscisses des stations }
   StationY,               { Ordonnes des stations }
   mesure,                 { Anomalies observes    }
   Ecart,                  { Ecart type/mesure      }
   anomalie,               { Anomalies calcules    }
   anomalie_t              { Anomalies translates  }
                        : ^s;

   py_xy,                  { }
   py_densite,             { }
   py_legend,              { }
   Codasks,                { code ascii des symboles pour les sismes       }
   Action,                 { N icne action en cours                       }
   Action2,                {  }
   cc5, cc6                { Clture courbes                                }
                        : integer;

   c_courbe1,              { couleur courbe calcule                        }
   c_courbe2,              { couleur courbe observe                        }
   c_symb,                 { couleur sismes                                }
   c_err,                  { couleur barre  erreur                          }
   c_couche,               { couleur limites couches                        }
   c_poly,                 { couleur polygones                              }
   c_texte,                { couleur affichage numros /densits            }
   c_texte2,               { couleur affichage valeurs  droite             }
   traitc1,                { type trait                                     }
   traitc2,                {   "   "                                        }
   traitlimite,            {                                                }
   traitgrille,            {                                                }
   co
                        : word;

   x1,  x2,  y1,  y2,      { extrmits ancien profil                       }
   x01, x02, y01, y02,     { extrmits nouveau profil                      }
   h_min, h_max,           { min et max symboles sismes                    }
   min_v, max_v,           { min et max prof sismes                        }
   deltaconst,             { Constante additive  l'anomalie                }
   DeltaAnomalie,          { valeur de la translation                       }
   rapz,                   { rapport zoom                                   }
   fc5, fc6                { clture courbes                                }
                        : real;

   calculok,               { Profil dj calcul                            }
   profil_coherent,        { Anciens fichiers de mmes extrmits           }
   nouveau,                { Nouveau profil                                 }
   sis,                    { Sismes calculs                               }
   affnumero,              { V = numros demands/ F = densits             }
   exo,                    { V = mode exo demand                           }
   flottefixe,             { V = polygone de l'eau indformable             }
  { Zoom,                    }
   translate,              { translation auto de la courbe calcule         }
   modif_modele,           { modif du modle de base PROFIL.gam  (EAU )     }
   visuseismes,            { }
   visudensite,            { }
   visucourb,              { }
   echelle1                { }
                        : boolean;

   nomfc                   { nom du fichier modle (corps)                  }
                        : namestr;

IMPLEMENTATION

BEGIN

   nomdumodule    := 'GRAV';
   extPAR         := '.GRV';

END.

{ GEOCEAN - GRAV_VAR ------------------------- R.C.- INRP - TOULOUSE - 1995 }

