UNIT CART_INI;

   {------------------------------------------------------------------------}
   { logiciel GEOCEAN - module CART                                         }
   {                                                                        }
   {                          initialisations                               }
   {                                                                        }
   {------------------------------------------------------------------------}

INTERFACE

{$O+,F+}

USES
   dos, crt, graph,          { TP 70   - units  standard  Borland          }
   Lipar,                    { ARX     - gestion fichiers paramtres        }
   Graphism,                 { ARX     - initialisations graphiques         }
   GraphUti,                 { ARX     - utilitaires graphiques             }
   Dirinfo,                  { ARX     - Gestion des fichiers de ressources }
   Periphs,                  { ARX     - Gestion des priphriques          }
   Utildivs,                 { ARX     - utilitaires divers                 }
   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   Icones,                   { ARX     - gestion de icnes                  }
   Menus,                    { ARX     - interface menus                    }
   Symboles,                 { ARX     - traitement des donnes ponctuelles }
   Curseurs,                 { ARX     - Potentiomtres simples et doubles  }
   GRILLES,                  { ARX     - lecture des grilles                }

   GEO_var,                  { GEO     - variables globales communes        }
   GEO_DES,                  { GEO     - procdures graph. communes         }

   CART_var,                 { CART    - variables globales du module       }
   CART_des;                 { CART    - affichages propres au module       }

Procedure iniparam;
   { initialise les paramtres de configuration  du programme.              }

Procedure iniparam2;
   { initialise les paramtres de travail                                   }

{Procedure recalc_interv_courbes;}
   { calcul automatique de l'quidistance                                   }

Procedure inidonnees;
   { charge les fichiers de donnes                                         }

Procedure ini_noms;
   { charge et recalcule les coordonnes des noms                           }

Procedure inimenus;
   { initialise les paramtres de l'interface MENUS.                        }

Procedure modif_menus;
   { modifie le texte des menus en fonction des paramtres initiaux         }

Procedure iniIcones;
   { initialise les pointeurs sur les icnes                                }

Procedure inversemenus;
   { inverse MENUS LONGS/COURTS                                             }

Procedure iniaide;
   { initialise les paramtres du fichier d'aide.                           }

Procedure fin;
   { restaure l'cran texte.                                                }

Procedure lire_parametres ;
   { Procedure ini_par_trv (nomf : pathstr);                                 }
   { initialisation des paramtres de travail                               }
   { Procedure ini_par_symb (nomf : pathstr);                                }
   { initialisation des paramtres d'un ensemble de symboles reprsentant
     un fichier de donnes                                                  }

Procedure ecrire_parametres (resume : boolean);
   { Enregistre les paramtres de travail en cours
                               des symboles
                               des commentaires
        si RESUME   met  jour INFO.DIR                                     }

Procedure ini_par_trv (nomf : pathstr);
   { initialisation des paramtres de travail                               }

Procedure voir_ptrav;
   { visualise la liste  complte des paramtres du travail en cours        }

{---------------------------------------------------------------------------}

IMPLEMENTATION

procedure iniIcones;
   begin
      laide (La_lit_Icones);

      if ftxt_present (cheminmodule+nomdumodule+exticn)
      then begin
         ActiveListeIcones (cheminmodule+nomdumodule+exticn);                { ICONES }
         def_icones;
      end else begin
         message (m_not_icones);
         halt;
      end;
      laide ('');
   end;

procedure voir_ptrav;
   begin
      params.boite;                                                  { lipar }
      bte_compl (t_btepar, -1, -1, nbc, nbo, 0, 10); { menu6 }
   end;

procedure ini_par_trv  (nomf : pathstr);
   begin
      params.init (false);
   { configuration donnes : modifiables par l'installateur }
      params.ajoute (Cstring  ('fichier de donnes'    , @nomfd,     '' ));
      params.ajoute (Cstring  ('fichier contours'      , @nomfcart , '' ));
{      params.ajoute (Cstring  ('fichier fond de carte' , @nomffond , '' ));}
      params.ajoute (Creal    ('abs g carte'           , @cor1     ,  0 ));
      params.ajoute (Creal    ('abs d carte'           , @cor2     ,  0 ));
      params.ajoute (Creal    ('ord b carte'           , @cor3     ,  0 ));
      params.ajoute (Creal    ('ord h carte'           , @cor4     ,  0 ));
      params.ajoute (Cstring  ('titre'                 , @titre    , '' ));
      params.ajoute (Cstring  ('titr1'                 , @titr1    , 'Longitude'));
      params.ajoute (Cstring  ('titr2'                 , @titr2    , 'Latitude'));
      params.ajoute (Cstring  ('texte grad. intrieure', @unitxy   , 'degrs'));

   { autres params : modifiables par l'utilisateur }
   { carte }
      params.ajoute (Cinteger ('abs gauche cloture'     , @cc1      ,    0 ));
      params.ajoute (Cinteger ('abs droite cloture'     , @cc2      ,    0 ));
      params.ajoute (Cinteger ('ord basse  cloture'     , @cc3      ,    0 ));
      params.ajoute (Cinteger ('ord haute  cloture'     , @cc4      ,    0 ));
      params.ajoute (Creal    ('abs gauche fenetre'     , @fc1      , -190 ));
      params.ajoute (Creal    ('abs droite fenetre'     , @fc2      , +190 ));
      params.ajoute (Creal    ('ord basse  fenetre'     , @fc3      ,  -90 ));
      params.ajoute (Creal    ('ord haute  fenetre'     , @fc4      ,  +90 ));

   { affichages divers }
      params.ajoute (Cboolean ('tiquettes visibles'    , @etiquettes  , true));
      params.ajoute (Cboolean ('commentaires visibles'  , @visucomm    , false));
      params.ajoute (Cboolean ('contours visibles'      , @visucontours, true));
      params.ajoute (Cboolean ('grille visible'         , @visugrille  , false));
      params.ajoute (Cboolean ('symboles visibles'      , @visusymb    , false));
      params.ajoute (Cboolean ('courbes visibles'       , @visucourbes , false));
      params.ajoute (Cboolean ('zones visibles'         , @visuzones   , false));
      params.ajoute (Cboolean ('toponymie visible'      , @visutoponym , true));
      params.ajoute (Cboolean ('prvisu courbes'        , @previsu     , true ));

   { courbes }
      params.ajoute (Creal    ('courbe infrieure'      , @minc        ,   0 ));
      params.ajoute (Creal    ('courbe suprieure'      , @maxc        ,   0 ));
      params.ajoute (Creal    ('quidistance'           , @equidist    ,   0 ));
      params.ajoute (Cinteger ('frq. courbes matres'  , @freq        ,   5 ));
      params.ajoute (Clst_chn ('zones de couleur'       , @z_coul      ,  nil ));
      params.ajoute (Cinteger ('couleur tiquettes'     , @c_etiqs     ,  12 ));
      params.ajoute (Cinteger ('couleur courbes'        , @c_crb       ,  11 ));
      params.ajoute (Cinteger ('couleur c. matresses'  , @c_crbm      ,  13 ));
      params.ajoute (Cinteger ('type trait contours'    , @traitcont   ,   0 ));
      params.ajoute (Cinteger ('couleur contours'       , @c_carte     , c_carte));
      params.ajoute (Cinteger ('type trait courbes'     , @traitcrb    ,   0 ));
      params.ajoute (Cinteger ('type trait c. matr.'   , @traitcm     ,   0 ));
      params.ajoute (Cinteger ('type trait grille'      , @traitgrille ,   3 ));
      params.ajoute (Cinteger ('couleur grille'         , @c_grille    , c_grille));
      params.ajoute (Creal    ('hauteur tiquettes'     , @h_etiq      ,   2 ));
      params.ajoute (Creal    ('dist. mini entre tiqs' , @dmin        ,  10 ));
      params.ajoute (Cinteger ('nombre de points intermdiaires', @nbpi,   1 ));

   { graduations externes }
      params.ajoute (Creal    ('interv entre graduations', @inter_xy   ,   1 ));
      params.ajoute (Cinteger ('nb dcimales'            , @nbdec_xy   ,   0 ));
      params.ajoute (Cinteger ('nb tirets intermdiaires', @nbti_xy    ,   4 ));
      params.ajoute (Cinteger ('hauteur tirets en mm'    , @htir_xy    ,   3 ));
      params.ajoute (Cinteger ('hauteur tiquettes grad.', @hcar_xy    ,   3 ));

   { toponymie }
      params.ajoute (Cstring  ('nom fichier toponymie'   , @nomftop    ,  region ));
      params.ajoute (Creal    ('hauteur texte'           , @haut_t     ,   3 ));
      params.ajoute (Cinteger ('couleur symboles'        , @coul_t     ,   2 ));

   { symboles associs }
      params.ajoute (Cstring  ('fichier donnes ponctuelles', @nomfvs  ,  '' ));
      params.ajoute (Cstring  ('fichier paramtres symboles', @nomfps  ,  '' ));

   { commentaires associs }
      params.ajoute (Cstring  ('nom fichier commentaires'   , @nomfcomm,  '' ));

      if ftxt_present (nomf)
      then
         params.lit (nomf);

      visufond    := false;
      visugrad    := false   ;     { graduations tj effaces         }
      modipar     := false   ;     { modif en cours params           }
      visuzonesmb := false;
      visusymb    := (nomfvs  <> '') and visusymb;
      visutoponym := (nomftop <> '') and visutoponym;
      { angl_t      := 0; }
      align_t     := 1;
      nbpg_t      := 0;
      fond_t      := false;
      deux_d      := true;   { reprer les fichiers toponymie }
   end;

procedure ecrire_parametres (resume : boolean);
   begin
      laide (la_ecr_par);

      nomfps   := nomfpar;
      nomfcomm := nomfpar;
{      nomftop  := nomfpar;}

      chain := '';
     { if (prof and (nomfpar = nomdumodule))
      then
         chain := chemindonnees;}

      { tester place disponible  sur le disque courant }
      { tester accs rseau et accs fichier }

      params.ecrit  (chain+nomfpar + extpar, datjour+ ' ' +nomutil);
         { travail en cours }

      parsymb.ecrit (chain+nomfps  + extps,  datjour+ ' ' +nomutil);
         { symboles }

      ecrit_par_COMM (chain+nomfcomm + extcom);
         { commentaires }

(*      if prof
      then begin
         ok := false;
         question ('Faut-il enregistrer '+nomftop,
                   'dans le rpertoire de donnes ?', ok);
         if ok
         then begin
            ecrit_toponymie (chemindonnees+nomftop+exttop);
            edite_info      (chemindonnees+nomfinfod, nomftop, exttop);
        { tester mise  jour infod }
         end else
            message ('Toponymie non enregistre !');
      end else
*)
      ecrit_par_noms  (nomftop+exttop);
      { toponymie }

      if resume
      then
         edite_info (nomfinfo, nomfpar, extpar);      { rsum / dirinfo }
      laide ('');
   end;

procedure lire_parametres;
   begin
      laide (la_lit_par);
      chain := '';
      if (maj (nomfpar) = nomdumodule)
         and not exists (nomfpar+extpar)
    {     and not ftxt_present (nomfpar+extpar)}
      then
         chain := chemindonnees;
{test rseau : chain := cheminexemples+region+'\';  }
      ini_par_TRV  (chain+nomfpar + extpar);  { charger les paramtres de travail }
      if titre    = ''
      then
         titre    := maj (region);

      if nomfcomm = ''
      then
         nomfcomm := nomfpar;
      ini_par_COMM (chain+nomfcomm + extcom); { commentaires }

      laide ('');
   end;

procedure iniparam;
   var
      chem, chemp     : dirstr;
      nomf            : namestr;
      ext             : extstr;

   begin
      help_txt_enligne (paramstr (1));

      { charger la configuration d'ensemble de GEOC }

      lire_utilisateur (paramstr (0));
        { nomutil = nomutil+groupe, region, ch prg, ch dnn }

      chemindonnees := chemindonnees+region+'\';
      exempl := numeromaxi (cheminexemples+region+'\*'+extpar) > 0;

      chemp   := '';
      nomfpar := nomdumodule;
      if paramcount > 0
      then
         chemp := paramstr (1);
      if chemp <> ''                { chercher le nom du fichier de travail }
      then begin
         fsplit (chemp, chem, nomf, ext);
         nomfpar := nomf;
      end;

      { charger la configuration d'ensemble de GEOC }
      { sans deuxime paramtre : config GEOCEAN }
      { avec deuxime  si <> geocean chemin et nom ok
                       sinon         config GEOCEAN }

      chemincfg  := cheminmodule;
      nomfcfg    := nomlogiciel;
      if paramcount > 1
      then
         chemp := paramstr (2);
      if chemp <> ''                { chercher le nom du fichier de CFG }
      then begin
         fsplit (chemp, chem, nomf, ext);
         if (nomf <> '') and (maj (nomf) <> maj (nomlogiciel))
         then begin
            nomfcfg := nomf;
            if chem <> ''
            then
               chemincfg := chem
         end;
      end;
      complete    (chemincfg);
      { charger la configuration d'ensemble de GEOC }
      ini_par_cfg (chemincfg+nomfcfg+extcfg);
      { si le fichier n'est pas trouv : paramtres par dfaut }

      { affecter rpertoire configuration graphique   }
      repbgi := maj (getenv (NomBgi));
      if repbgi = ''
      then
         repbgi := cheminmodule;
      complete (repbgi);                       { ajoute ventuellement un \ }
   end;

procedure iniparam2;
   begin
      fini    := false;
      prof    := false;
      lire_parametres;
   end;

procedure recalc_interv_courbes;
   var
      dminmax           : real;

   begin
      { prparer mini-maxi courbes et quidistance }
      dminmax := lagrille.maxzg-lagrille.minzg;
      if dminmax    < 11
      then cminmax := 1
      else
         if dminmax    < 110
         then cminmax := 10
         else
            if dminmax    < 1100
            then cminmax := 100
            else
               if dminmax    < 15000
               then cminmax := 1000
               else
                  if dminmax    < 110000
                  then cminmax := 10000
                  else cminmax := 100000;

      if ((freq <= 0) or (equidist <= 0))
      then
         if (minc >= maxc)      { viter div par 0 }
         then begin
            minc := trunc (lagrille.minzg/cminmax)*cminmax;
            maxc := trunc (lagrille.maxzg/cminmax)*cminmax;
         end;

                             { viter trop de courbes }
      if    (equidist < (lagrille.maxzg-lagrille.minzg)/100)
         or (equidist > (lagrille.maxzg-lagrille.minzg)/2)
      then
         {equidist := round ((lagrille.maxzg-lagrille.minzg)/2);}
         equidist := cminmax;

                             { viter frquence trop grande }
      if freq < 1
      then
         freq := 1;

      pasequi := cminmax / 20;
      cal_donnee (equidist, lagrille.minzg ,lagrille.maxzg, minc );
      cal_donnee (equidist, lagrille.minzg ,lagrille.maxzg, maxc );

      if cminmax = equidist
      then begin
         equidist := equidist / 2;
      end;
   end;

procedure inidonnees;
   var
      i                 : integer;

   begin
      chain := '';
      if (maj (nomfpar) = nomdumodule)
      then
         chain := chemindonnees;
      { charger les valeurs  reprsenter }
      if ftxt_present (chemindonnees+nomfd+extgrd)
      then begin
         lire_grille (Lagrille, nomfd);
         recalc_interv_courbes;
      end else begin
         i := 0;
         repeat
            inc (i);
            chang_grille (Donnees_ini, '',
                          Choix_grille, '',
                          Lagrille, nomfd);
         until (nomfd <> '') or (i > 2);

         if nomfd = ''
         then begin
            message (m_not_donnees);
            finir;
            halt;
         end else
            recalc_interv_courbes;
      end;

      { charger le fichier contours     }
      if ftxt_present (chemindonnees+nomfcart+extbln)
      then
         lire_contour (chemindonnees+nomfcart+extbln)
      else
         chang_contour;

(*      { charger un fond de carte  }
      if not ftxt_present (nomffond+extblf)
      then
         chang_fondcarte ('', nomffond); { pas d'affichage immdiat }*)

      { VALEURS PONCTUELLES ET PARAMETRES ASSOCIES }
      { charger le fichier de paramtres en cours sans l'afficher }

{ test reseau : chain := cheminexemples + region+'\';}

      ini_par_SYMB     (chain+nomfps+extps);
      ini_par_SYMBd    (chemindonnees+nomfvs+extps);  { libells colonnes }
      initextes_titres;

      if (ftxt_present (chemindonnees+nomfvs+extvs))
              {and (ftxt_present (nomfps+extps))}
      then begin
         laide (la_lit_points);
         if strufic = ''
         then begin
            ini_valeurs_symb (chemindonnees+nomfvs+extvs, 0);
                     { en second : impratif }
         end;
      end else begin
         change_points;
      end;
      cal_donnee (pasvs, min_v, max_v, borne_inf );
      cal_donnee (pasvs, min_v, max_v, borne_sup );
      visusymb    := (nomfvs  <> '') and visusymb;
      laide ('');
   end;

procedure ini_noms;
   begin
      ini_par_noms;
      if (nomftop = region) and
         (ftxt_present  (chemindonnees+nomftop+exttop))
      then begin
         append_Noms    (chemindonnees+nomftop+exttop);
         Noms^.modifier (nbpg_t, coul_t, haut_t);
      end else begin
         if  (ftxt_present (nomftop+exttop))
         then begin
            Noms^.lit      (nomftop+exttop, true);
            Noms^.modifier (nbpg_t, coul_t, haut_t);
      {   end else begin
            nomftop := '';
            chang_noms ;
            recalculer_toponymie_2d; }
         end;
      end;
      visutoponym := (noms <> nil) and visutoponym;
   end;

procedure inimenus_prof;
   begin
      textemenufichierprof;

      textemenu (2, 10, txt_mnu210, txt_mnu210a);
      textemenu (2, 11, txt_mnu211, txt_mnu211a);
      textemenu (2, 12, txt_mnu212, txt_mnu212a);

      textemenu (3, 10, txt_mnu310, txt_mnu310a);

      textemenu (4, 12, txt_mnu412, txt_mnu412a);
   end;

procedure inimenus_eleve;
   begin
      textemenufichier;

      textemenu (2,  1, nomu_cart,  '');
      textemenu (2,  2, txt_mnu22,  txt_mnu22a);
      textemenu (2,  4, txt_mnu24,  txt_mnu24a);
      textemenu (2,  6, txt_mnu26,  txt_mnu26a);

      textemenu (2,  8, txt_mnu28,  txt_mnu28a);
      textemenu (2,  9, txt_mnu29,  txt_mnu29a);

      textemenu (3,  2, txt_mnu32,  txt_mnu32a);
      textemenu (3,  3, txt_mnu33,  txt_mnu33a);
      textemenu (3,  4, txt_mnu34,  txt_mnu34a);
    {  textemenu (3,  5, 'Symboles...',
                        'Modifie les attributs courants des symboles');}
      textemenu (3,  7, txt_mnu37,  txt_mnu37a);
      textemenu (3,  8, txt_mnu38,  txt_mnu38a);
      textemenu (3,  9, txt_mnu39,  txt_mnu39a);
   end;

procedure modif_menus;
   begin
      changeiconesmb;
      if ((nomfpar <> nomdumodule) or prof)
      then
         active (1, 4, true)
      else
         active (1, 4, false);

      if exempl        { sans bascule }
      then begin
         active (1,  2, false);
         active (1,  4, false);
         active (1,  5, false);
         active (1, 10, false);
         active (1, 11, false);
         active (2,  8, false);
         active (2,  9, false);
         active (3,  2, false);
         active (3,  9, false);
      end;

      if visuzones
      then begin
{         active    (2,  2, false); }                  { paramtres courants }
         textemenu (2,  3, coche+' '+txt_mnu23,  txt_mnu23a);
         active    (2,  4, true);
      end else begin
{         active    (2,  2, true); }                  { paramtres courants }
         textemenu (2,  3, '  '     +txt_mnu23,  txt_mnu23ab);
         active    (2,  4, false);
      end;
      if  (nb_zones (z_coul) >= 10)
      then
         active (2, 4, false);

      if (rang_v < 3) or (typedat = 1)
      then begin
         visuzonesmb := false;
         active (3, 6, false);
      end else
         active (3, 6, true);

      if visugrad or not gradauto
      then
         active (3,  3, true)           { axes }
      else
         active (3,  3, false);

      if visuzonesmb
      then begin
       {  active    (3,  5, false); }                  { paramtres courants }
         textemenu (3,  6, coche+' '+txt_mnu36, txt_mnu36a);
         active    (3,  7, true);                    { ajouter zone        }
      end else begin
{         active    (3,  5, true);    }
         textemenu (3,  6, '  '     +txt_mnu36, txt_mnu36ab);
         active    (3,  7, false);
      end;

      if  (nb_zones (z_smb) >= 10)
      then
         active (3, 7, false);

      if (rang_v < 3) or (typedat = 1)
      then
         active (3, 6, false)
      else
         active (3, 6, true);

      if visuzones or visuzonesmb
      then begin
         { voir ini zones}
      end else begin
         modi_bouton (aidico101,
                             101, ce1, maxy-ce4, ce2-ce1, ce4-ce3);
         active_icone (101);
      end;

      if visucomm
      then begin
         textemenu (4,  2, coche+' '+txt_mnu42, txt_mnu42a);
         active (3, 2, true);
         Dessiner_Commentaires (false, true, false);
      end else begin
         textemenu (4,  2,      '  '+txt_mnu42, txt_mnu42ab);
         active (3, 2, false);
      end;

      if annotations^.count = 0
      then begin
         visucomm := false;
         active (3 , 2, true);
      end;

      if visugrad
      then
         textemenu (4,  3, coche+' '+txt_mnu43, txt_mnu43a)
      else
         textemenu (4,  3,      '  '+txt_mnu43, txt_mnu43ab);

      if visucontours
      then
         textemenu (4,  4, coche+' '+txt_mnu44, txt_mnu44a)
      else
         textemenu (4,  4,      '  '+txt_mnu44, txt_mnu44ab);

      If visusymb
      then
         textemenu (4,  5, coche+' '+txt_mnu45, txt_mnu45a)
      else
         textemenu (4,  5,      '  '+txt_mnu45, txt_mnu45ab);

      If visutoponym
      then begin
         textemenu (4,  7, coche+' '+txt_mnu47, txt_mnu47a);
         active    (3, 10 , true);
      end else begin
         textemenu (4,  7,      '  '+txt_mnu47, txt_mnu47ab);
         active    (3, 10, false);
      end;

      if noms^.count = 0
      then begin
         visutoponym := false;
         active (3 , 10, true);
      end;

      If visugrille
      then
         textemenu (4,  8, coche+' '+txt_mnu48, txt_mnu48a)
      else
         textemenu (4,  8,      '  '+txt_mnu48, txt_mnu48ab);

      if visucourbes
      then
         textemenu (4,  9, coche+' '+txt_mnu49, txt_mnu49a)
      else
         textemenu (4,  9,      '  '+txt_mnu49, txt_mnu49ab);

      if etiquettes
      then
         textemenu (4, 11, coche+' '+txt_mnu411, txt_mnu411a)
      else
         textemenu (4, 11,      '  '+txt_mnu411, txt_mnu411ab);

(*      if visufond
      then
         textemenu (4, 10, coche+' Fond de carte',
                           'Le fond de carte est affich')
      else
         textemenu (4, 10, '  Fond de carte',
                           'Le fond de carte est masqu');
*)
      if nomftop = ''
      then begin
         active (2, 12, false);
         active (3,  8, false);
         active (4,  7, false);
      end else begin
         active (2, 12, true);
         active (3,  8, true);
         active (4,  7, true);
      end;

      if nomffond = ''
      then begin
         active    (4, 10, false);         { contours}
{         active    (2,  9, false);          }
      end else begin
         active    (4, 10, true);
{         active    (2,  9, true);           }
      end;

      if nomfcart = ''
      then begin
         active    (3,  4, false);         { contours}
         active    (4,  4, false);         { }
      end else begin
         active    (3,  4, true);
         active    (4,  4, true);
      end;

      if nomfvs = ''
      then begin
 {        active    (3,  5, false);}
         active    (3,  6, false);         {}
         active    (3,  7, false);         {}
         active    (4,  5, false);         { }
         inactive_icone (5);
         inactive_icone (6);
      end else begin
{         active    (3,  5, true);
         active    (3,  6, true);
         active    (3,  7, true);
         active    (4,  6, true);
         changeiconesmb;}
      end;
      modif_menu_cfg; { modifie le menu SORTIES }
      aff_mem;
   end;

procedure inimenus;
   begin
      ini_menu      (repbgi, pol_menu);                             { menus }
      posxbtn := 541;
      chargepalette (cheminmodule + nomdumodule + extpal, ok);   { graphism }
      setcoulmenu   (fondmenu, txtmenu,  txtnorm, txtnon,
                     txtoui,   fondnorm, fondoui, fondaide);
      inimenus_eleve;
      if prof
      then
         inimenus_prof;
   end;

procedure inversemenus;
   begin
      if not prof
      then
         inimenus_prof
      else begin
         initmenus;                                                { menus1 }
         inimenus_eleve;
      end;
      prof := not prof;
   end;

procedure iniaide;
   begin
      initaide (cheminmodule + nomdumodule + exthlp, ok);                             { menus6 }
   end;

procedure fin;
   begin
      finir;                                                          { des }
   end;


END.

{--- GEOCEAN - CART_INI ------ --------------- R.C.- INRP - TOULOUSE - 1995 }
