UNIT Edition;

        {ͻ}
        {   Bibliothque  EDITION                            }
        {   Version Objets                                   }
        {͹}
        {                                                    }
        {   Mai 1993                                         }
        {                                                    }
        {ͼ}
(*
   Edition,                  { ARX     - saisie/dition paramtres          }
*)

{ Gre les ditions en mode graphique d'entiers, de rels, de chanes.      }
{ Gre aussi l'dition de liste de paramtres de type quelconque.           }
{ Voir les exemples dcrits dans le programme EDITION.TST                   }

INTERFACE

{$O+,F+}

{===========================================================================}
USES

   Objects,
   Graph,                    { TP 70   - units standard Borland            }

   Graphism,                 { ARX     - initialisations graphiques         }
   Souris,                   { ARX     - gestion de la  souris              }
   Clavier,                  { ARX     - gestion du clavier                 }
   Messarx                   { ARX     - Textes des Messages de Base        }
   ;

{===========================================================================}

TYPE
   PReal                = ^real;      {}
   Pinteger             = ^integer;   {}
   PString              = ^String;    {}
   PByte                = ^Byte;      {}
   PBoolean             = ^Boolean;   {}

   visusmb              = procedure (px, py, kod : integer);
   TMAJ                 = procedure;

{---------------------------------------------------------------------------}
   { Objet abstrait anctre des objets de saisie typs.}

   PZoneSaisie          = ^TZoneSaisie;
   TZoneSaisie          = object (TObject)
      Nom,                            { Nom (chane) associe  la variable }
      Unite,                          { Unit de la variable                }
      Texte             : string;     { Valeur (transforme en chane)      }
      px, py,                         { Position (en pixel)                 }
      long              : integer;    { Longueur (en nombre de car.)        }
      CNom,
      Ctexte, Cfond     : word;       { Couleur du texte et du fond         }

      MAJ               : TMAJ;

      constructor init      (x, y, l     : integer;
                             ct, cf      : word;
                             ch, nm, unt : string);

      procedure   MiseAJour (m : TMAJ);

      procedure   Efface    (c           : integer);
      procedure   Edite     (var PosCur,
                             codesortie  : integer);            virtual;
      function    Contient  (x, y        : integer)     : boolean;
      procedure   Cadrer;                                       virtual;
      procedure   AfficheTout;
      procedure   AfficherTout;                                 virtual;
      procedure   AfficheValeur;
      procedure   Afficher;                                     virtual;
      destructor  Fini;                                         virtual;
   end;

{---------------------------------------------------------------------------}
   { Objet pour l'dition de chanes de caractres }

   PZoneChaine      = ^TZoneChaine;
   TZoneChaine      = object (TZoneSaisie)
      Valeur        : PString;
      constructor init  (x, y, l   : integer;
                         ct, cf    : word;
                         v         : PString;
                         nm, unt   : string);
      procedure   edite (var Poscur, CodeSortie : integer);     virtual;
      procedure   AfficherTout;                                 virtual;
      procedure   afficher;                                     virtual;
      destructor  fini;                                         virtual;
   end;

{---------------------------------------------------------------------------}
{    Objet pour l'dition de rels                                          }

   PZoneReel        = ^TZoneReel;
   TZoneReel        = object (TZoneSaisie)
      Valeur        : Preal;     {}
      Decimales     : integer;   {}

      constructor Init  (x, y, l, d     : integer;
                         ct, cf         : word;
                         v              : Preal;
                         nm, unt        : string);

      procedure   edite (var PosCur     : integer;
                         var codesortie : integer);             virtual;
      procedure   AfficherTout;                                 virtual;
      procedure   afficher;                                     virtual;
      destructor  fini;                                         virtual;
   end;

{---------------------------------------------------------------------------}
   { Objet pour l'dition d'entiers }

   PZoneEntier      = ^TZoneEntier;
   TZoneEntier      = object (TZoneSaisie)
      Valeur        : Pinteger;
      constructor Init  (x, y, l        : integer;
                         ct, cf         : word;
                         v              : Pinteger;
                         nm, unt        : string);

      procedure   edite (var PosCur     : integer;
                         var codesortie : integer);             virtual;
      procedure   AfficherTout;                                 virtual;
      procedure   afficher;                                     virtual;
      destructor  fini;                                         virtual;
   end;

{---------------------------------------------------------------------------}
   { Objet pour l'dition de couleurs }

   PZoneCouleur     = ^TZoneCouleur;
   TZoneCouleur     = object (TZoneSaisie)
      Valeur        : Pbyte;
      NbCou         : byte;
      Coul          : array [1..16] of byte;
      Couls         : array [0..15] of boolean;

      constructor Init (x, y            : integer;
                        v               : Pbyte;
                        nm, unt         : string;
                        T               : array of boolean);
      procedure   edite (var PosCur     : integer;
                         var codesortie : integer);             virtual;
      procedure  AfficherTout;                                  virtual;
      procedure  afficher;                                      virtual;
      destructor fini;                                          virtual;
   end;

{---------------------------------------------------------------------------}
   { Objet pour l'dition de Liste de chanes }

   PZoneListe       = ^TZoneListe;
   TZoneListe       = object (TZoneSaisie)
      Valeur        : Pbyte;
      Liste         : TCollection;
      Largeur       : integer;

      constructor Init (x, y            : integer;
                        ct, cf          : word;
                        v               : Pbyte;
                        nm, unt         : string);

      procedure   edite (var PosCur     : integer;
                       var codesortie   : integer);             virtual;
      procedure   Cadrer;                                       virtual;
      procedure   AfficherTout;                                 virtual;
      procedure   afficher;                                     virtual;
      destructor  fini;                                         virtual;
   end;

{---------------------------------------------------------------------------}
   { Objet pour l'dition de boolens (case  cocher) }

   PZoneBooleen     = ^TZoneBooleen;
   TZoneBooleen     = object (TZoneSaisie)
      Valeur        : Pboolean;
      constructor Init (x, y            : integer;
                        ct, cf          : word;
                        v               : Pboolean;
                        nm, unt         : string);
      procedure   edite (var PosCur     : integer;
                         var codesortie : integer);             virtual;
      procedure   AfficherTout;                                 virtual;
      procedure   afficher;                                     virtual;
      destructor  fini;                                         virtual;
   end;
{---------------------------------------------------------------------------}
   { Objet pour la validation de la boite de saisie }

   PZoneOK          = ^TZoneOK;
   TZoneOK          = object (TZoneSaisie)
  {    Valeur : Pboolean;}
      constructor Init  (x, y           : integer;
                         ct, cf         : word;
                         nm, unt        : string);
      procedure   AfficherTout;                                 virtual;
      procedure   edite (var PosCur     : integer;
                         var codesortie : integer);             virtual;
      procedure   afficher;                                     virtual;
      destructor  fini;                                         virtual;
   end;

{---------------------------------------------------------------------------}
   { Objet pour l'dition de symboles }

   PZoneSymboles    = ^TZoneSymboles;
   TZoneSymboles    = object (TZoneSaisie)
      Valeur        : Pbyte;
      Nbsmb         : byte;
      lx            : integer;
      affichersmb   : visusmb;
      adr           : pointer;
      constructor Init  (x, y           : integer;
                         ct, cf         : word;
                         v              : Pbyte;
                         nm, unt        : string;
                         affichersymb   : visusmb;
                         adr_coul       : pointer);

      procedure   edite (var PosCur     : integer;
                         var codesortie : integer);             virtual;
      procedure   AfficherTout;                                 virtual;
      procedure   afficher;                                     virtual;
      destructor  fini;                                         virtual;
   end;

{---------------------------------------------------------------------------}
{    Objet pour l'dition d'une liste de paramtres de tout types,          }
{      (voir ci-dessus)                                                     }

   PBoiteSaisie     = ^TBoiteSaisie;
   TBoiteSaisie     = object (TObject)
      px1, py1,
      px2, py2      : integer;        {}
      ccadre, cfond,
      CTitre        : word;           {}
      Titre         : string;         {}
      ListeZones    : PCollection;    {}

      constructor init (x1, y1, cc, cf, ct : integer;
                        t : string);
      procedure   Affiche;
      procedure   Efface (c              : byte);
      procedure   Ajoute (Z              : PZoneSaisie);
      procedure   edite  (num, poscur    : integer;
                          var CodeSortie : integer);
      procedure   editeF (num, poscur    : integer;
                          var CodeSortie : integer);
      function    NumeroContenant (x, y  : integer)     : integer;
      procedure   Vider;
      destructor  fini;                                         virtual;
   end;

Const
   Milieu               = -1;

{===========================================================================}
IMPLEMENTATION

procedure MAJNul;
   begin
   end;


constructor TZoneSaisie.init;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      px     := x;
      py     := y;
      long   := l;
      texte  := ch;
      Nom    := nm;
      Unite  := unt;
      Ctexte := ct;
      CFond  := cf;
      CNom   := CTexte;
      MiseAJour (MAJNul);
   end;

procedure TZoneSaisie.MiseAJour (m : TMAJ);
   begin
      MAJ    := m;
   end;

procedure TZoneSaisie.efface;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      SetFillStyle (SolidFill, c);
      Bar (px-2, py, px+long*tx, py+ty);
   end;

procedure TZoneSaisie.cadrer;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
   end;

procedure TZoneSaisie.edite;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   Var
      PosCur2, co       : integer;
      Insert, fin       : boolean;
      Texte2            : string;

   {------------------------------------------------------------------------}
   procedure AfficherCurseur (Chaine : string; Pos : integer);
      var
         dx, dy, l, tc  : integer;
         i              : pointer;

   begin
      if Pos > Length (Chaine)
      then begin
         dx := TextWidth ('A');
         l  := TextWidth (Chaine)-1;
      end else begin
         dx := textwidth (Chaine[pos]);
         if pos=1
         then
            l := -1
         else
            l := TextWidth (Copy (Chaine, 1, Pos-1))-1;
      end;
      dy := TextHeight ('A');
      if insert
      then
         tc := dy-2
      else
         tc := 0;

      getmem   (i,    imagesize (0, tc, dx, dy));
      getimage (px+l, py+tc, px+l+dx, py+dy, i^);
      putimage (px+l, py+tc, i^, 4);
      freemem  (i,    imagesize (0, tc, dx, dy));
   end;

   {------------------------------------------------------------------------}
   procedure EffacerCurseur (Chaine : string; Pos : integer);
   begin
      AfficherCurseur (Chaine, Pos);
   end;

   {------------------------------------------------------------------------}
   procedure traitercode (code : integer; var stop : boolean);
   (*role:traitement du code specifie*)
      var
         i              : integer;

      {---------------------------------------------------------------------}
      procedure avancercurseur (var positioncourante : integer);
         begin
            if positioncourante < long
            then
               positioncourante := positioncourante + 1;
         end;

      {---------------------------------------------------------------------}
      procedure reculercurseur (var positioncourante : integer);
         begin
            if positioncourante > 1
            then
               positioncourante := positioncourante - 1;
         end;

      {--------------------------------------------------------------------}
      procedure Delete (positionCourante : integer);
      { Role : efface le caractre courant... }
      { M A J globale : Texte }
         var
            i           : integer;

         begin
            for i := positioncourante to long-1
            do
               texte [i] := texte[i+1];
            texte [long] := ' ';
         end;

   { Corps de la procdure TraiterCode }
   begin
      case code of
         cr, esc, fleh, fleb, tab, shtab, ctrlfleg, ctrlfled : stop := true;
         BS       : begin
                       if PosCur > 1
                       then begin
                          reculercurseur (PosCur);
                          delete (poscur);
                       end;
                    end;
         CodeHome : posCur := 1;
         CodeEnd  : begin
                       PosCur := Long;
                       while (Texte [PosCur] = ' ') and (PosCur>0)
                          do dec (PosCur);
                       if PosCur < Long then inc(PosCur);
                    end;
         Ins      : begin
                       EffacerCurseur (texte, PosCur);
                       insert := not insert;
                       AfficherCurseur (texte, PosCur);
                    end;
         Del      : Delete  (posCur);
         fled     : avancercurseur (poscur);
         fleg     : reculercurseur (poscur);
         32..126,
         128..255 : begin
                       if insert
                       then
                          for i := Long downto poscur+1
                             do texte [i] := texte [i-1];
                       texte [poscur]:=caractereclavier (code);
                       avancercurseur (poscur);
                    end;
      end;

   end;

   {------------------------------------------------------------------------}
   begin { Corps de Edite }
      Efface (CFond);
      Insert := false;

      if PosCur < 1
      then
         PosCur := Length (texte)+1;

      {2.ajuster la taille de la chane et l'afficher en inverse vido}

       if Length (Texte) > 1
       then
          while Texte [1]=' '
             do Texte := copy (Texte, 2, length (texte)-1);

       if length (Texte) > long
       then
          Texte := copy (Texte,1,long)
       else
          While Length (Texte) < long
             do Texte := Texte + ' ';

       if PosCur > (length (Texte) +1)
       then
          PosCur := length (Texte)+1;
       if PosCur > long
       then
          PosCur := long;

       setcolor (ctexte);
       OutTextXY (px, py, Texte);
       AfficherCurseur (Texte, PosCur);

      {3.attendre la frappe d'une touche, dont on renverra le code en sortie}

       fin := false;
       while (not fin)
       do begin
          MontrerSouris;

          repeat until (Toucheclavier (codesortie)) or UnBoutonSourisEnfonce;
          CacherSouris;

          if UnBoutonSourisEnfonce
          then begin
             fin := true;
             CodeSortie := 0;
          end else begin
             PosCur2 := PosCur;
             Texte2  := Texte;
             traitercode (codesortie, fin);
             EffacerCurseur (Texte2, PosCur2);
             setcolor (CFond);
             OutTextXY (px, py, Texte2);
             setcolor (ctexte);
             OutTextXY (px, py, Texte);
             AfficherCurseur (Texte, PosCur);
          end;
       end;

      {4.rafficher la chane en vido normale}
      EffacerCurseur (Texte, PosCur);

      {6.limine les espace en queue et tte}
       while (Texte [1] = ' ') and (Length (texte) > 1)
          do Texte := copy (Texte, 2, length (texte)-1);
       while(Texte [length (Texte)]=' ')
          do Texte := copy (Texte, 1, length (Texte)-1);

   end;

procedure TZoneSaisie.afficheTout;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      Efface (Cfond);
      SetColor (CNom);
      OutTextXY (px - tx*length (nom)-tx, py, Nom);
      OutTextXY (px + tx*long + tx, py, Unite);
      Afficher;
   end;

procedure TZoneSaisie.afficherTout;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
   end;

function TZoneSaisie.Contient (x, y : integer) : boolean;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      if (x >= px-2) and (x <= px+long*tx) and (y >= py) and (y <= py+ty)
      then
         Contient := true
      else
         Contient := false;
   end;

procedure TZoneSaisie.afficher;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      SetColor (Ctexte);
      OutTextXY (px, py, Texte);
   end;

procedure TZoneSaisie.AfficheValeur;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      SetColor (Ctexte);
      OutTextXY (px, py, Texte);
   end;

destructor TZoneSaisie.fini;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      TObject.done;
   end;

constructor TZoneChaine.init;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      TZoneSaisie.init (x, y, l, ct, cf, v^, nm, unt);
      Valeur := v;
   end;

procedure TZoneChaine.edite;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      valeuri           : string;

   begin
      Afficher;
      Valeuri := texte;
      TZoneSaisie.edite (posCur, CodeSortie);
      if CodeSortie = ESC
      then Valeur^ := ValeurI
      else Valeur^ := texte;
      maj;
   end;

procedure TZoneChaine.afficher;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      Texte := Valeur^;
      AfficheValeur;
   end;

procedure TZoneChaine.afficherTout;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      Texte := Valeur^;
      AfficheTout
   end;

destructor TZoneChaine.fini;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      TZoneSaisie.fini;
   end;

constructor TZoneReel.init;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      ch                : string;

   begin
      str (v^:l:d, ch);
      TZoneSaisie.init (x, y, l, ct, cf, ch, nm, unt);
      decimales := d;
      Valeur := v;
   end;

procedure TZoneReel.Edite;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   Var
       ch2              : string;
       err              : integer;
       fin              : boolean;
       ValeurI          : real;

   begin {!EditerReel simul!}
      ValeurI := Valeur^;
      Afficher;
      ch2 := texte;
      fin := false;
      repeat
         {2. Editer la chane obtenue}
         TZoneSaisie.Edite (PosCur, codesortie);

         if CodeSortie = ESC
         then begin
            fin := true;
            valeur^ := ValeurI;
            setcolor (CFond);
            outtextxy (px, py, texte);
            setcolor (ctexte);
            outtextxy (px, py, ch2);
         end else begin
            {3. convertir chane en rel}
            val (texte, valeur^, err);

            { Tester validit }
            if err = 0 then fin := true;
         end;

      until fin;
      setcolor (CFond);
      outtextxy (px, py, texte);
      str (valeur^:long:Decimales, texte);
      SetColor (CTexte);
      outtextxy (px, py, texte);
      maj;
   end;

procedure TZoneReel.afficher;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      str (valeur^:long:Decimales, texte);
      AfficheValeur;
   end;

procedure TZoneReel.afficherTout;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      str (valeur^:long:Decimales, texte);
      AfficheTout;
   end;

destructor TZoneReel.fini;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      TZoneSaisie.done;
   end;

constructor TZoneEntier.init;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      ch                : string;

   begin
      str (v^:l, ch);
      TZoneSaisie.init (x, y, l, ct, cf, ch, nm, unt);
      Valeur := v;
   end;

procedure TZoneEntier.Edite;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   Var
      ch2               : string;
      err               : integer;
      fin               : boolean;
      ValeurI           : integer;

   begin {!EditerReel simul!}
      ValeurI := Valeur^;
      Afficher;
      ch2 := texte;
      fin := false;
      repeat
         {2. Editer la chane obtenue}
         TZoneSaisie.Edite (PosCur, codesortie);

         if CodeSortie = ESC
         then begin
            fin := true;
            valeur^ := ValeurI;
            setcolor (CFond);
            outtextxy (px, py, texte);
            setcolor (ctexte);
            outtextxy (px, py, ch2);
         end else begin
            {3. convertir chane en rel}
            val (texte, valeur^, err);

            { Tester validit }
            if err = 0
            then
               fin := true;
         end;

      until fin;
      setcolor (CFond);
      outtextxy (px, py, texte);
      str (valeur^:long, texte);
      SetColor (CTexte);
      outtextxy (px, py, texte);
      maj;
   end;

procedure TZoneEntier.afficher;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      str (valeur^:long, texte);
      AfficheValeur;
   end;

procedure TZoneEntier.afficherTout;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      str (valeur^:long, texte);
      AfficheTout;
   end;

destructor TZoneEntier.fini;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      TZoneSaisie.done;
   end;

constructor TZoneCouleur.init;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      ch                : string;
      i                 : byte;

   begin
      str (v^, ch);
      TZoneSaisie.init (x, y, 2, 0, 0, ch, nm, unt);
      NbCou := 0;
      for i := 0 to 15
      do begin
         Couls [i] := T [i];
         if T[i]
         then begin
            inc (NbCou);
            Coul [NbCou] := i;
         end;
      end;
      Valeur := v;
   end;

procedure TZoneCouleur.Edite;
   {------------------------------------------------------------------------}
   { Souris doit tre cache en entre                                      }
   {------------------------------------------------------------------------}
   Var
      xs, ys,
      x0, y0,
      largeur,
      hauteur,
      rangx,
      selection,
      i,
      err
                        : integer;
      sortie,
      fin
                        : boolean;
      ValeurI
                        : byte;
      z
                        : pointer;

   procedure SauverFond;
      begin
         x0 := px;
         y0 := py;
         largeur := nbcou*tx;
         hauteur := ty;
         if x0+nbcou*tx > maxx
            then x0 := maxx-nbcou*tx;
         if y0+ty > maxy
            then y0 := maxy-ty;
         getmem (z, imagesize (x0, y0, x0+nbcou*tx, y0+ty));
         getimage (x0, y0, x0+nbcou*tx, y0+ty, z^);
      end;

   procedure AfficherCouleurs;
      var
         i              : integer;

      begin
         for i := 1 to NbCou
         do begin
            setfillstyle (solidfill, coul[i]);
            Bar (x0+(i-1)*tx, y0, x0+i*tx, y0+ty);
            setcolor (15);
            rectangle (x0+(i-1)*tx, y0, x0+i*tx, y0+ty);
         end;
      end;

   begin
      Afficher;
      ValeurI := Valeur^;
      fin := false;
      SauverFond;
      codesortie := 0;
      {* Mise  jour slection et affichage }
      selection := 1;

      for i:=1 to NbCou
         do if coul[i] = valeur^
         then
            selection := i;

      repeat
         {* Edition }
         sortie := false;
         {* Affichage des couleurs }
         AfficherCouleurs;

         setcolor (15);
         rectangle (x0+(selection-1)*tx+1, y0+1, x0+selection*tx-1, y0+ty-1);
         setcolor (0);
         rectangle (x0+(selection-1)*tx,   y0,   x0+selection*tx,   y0+ty);
         montrersouris;
         repeat
            if (codesortie = FleD) or (codesortie = FleG)
            then begin
               cachersouris;
               { effacer marqueur de slection }
               setcolor (coul[selection]);
               rectangle (x0+(selection-1)*tx+1, y0+1, x0+selection*tx-1, y0+ty-1);
               setcolor (15);
               rectangle (x0+(selection-1)*tx, y0, x0+selection*tx, y0+ty);

               { modifier slection }
               if codesortie = FleD
               then
                  selection := (selection mod NbCou) + 1;
               if codesortie = FleG
               then
                  selection := (selection + NbCou - 2) mod NbCou + 1;

               { afficher marqueur de slection }
               setcolor (15);
               rectangle (x0 +(selection-1)*tx+1, y0+1,
                          x0 +selection*tx-1,     y0+ty-1);
               setcolor (0);
               rectangle (x0 +(selection-1)*tx,   y0,
                          x0 +selection*tx,       y0+ty);
               montrersouris;
            end;
            codesortie := 0;
         until (Toucheclavier (codesortie)) or UnBoutonSourisEnfonce;
         cachersouris;

         {* Sortie de l'dition }
         MontrerSouris;
         if CodeSortie = ESC
         then begin
            fin     := true;
            valeur^ := ValeurI;
         end else begin
            {* Traitement du choix }
            valeur^ := coul[selection];
            if (codesortie = CR) or (codesortie = FleH)
                                 or (codesortie = FleB)
            then begin
               { OK clavier }
               valeur^ := coul[selection];
            end;
            if unBoutonSourisEnfonce
            then begin
               LirePositionSouris (xs, ys);
               rangx := (xs-x0) div tx + 1;
               if (rangx > 0) and (rangx <= NbCou) and
                  (ys >= y0) and (ys <= y0 + ty)
               then begin
                     { OK souris }
                     valeur^ := coul[rangx];
                     selection := rangx;
               end else begin
                  fin := true;
               end;
            end;
         end;
         CacherSouris;
         fin := not ((xs > x0) and (xs < x0+largeur)
                 and (ys > y0) and (ys < y0+hauteur))
            and unboutonsourisenfonce or (codesortie = esc)
                                      or (codesortie = FleB)
                                      or (codesortie = FleH)
                                      or (codesortie = TAB)
                                      or (codesortie = ShTAB)
                                      or (codesortie = CR)
      until fin;

      putimage (x0, y0, z^, NormalPut);
      libere (z);
      Afficher;
      MAJ;
   end;

procedure TZoneCouleur.afficher;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      setfillstyle (solidfill, valeur^);
      Bar (px-2, py, px+long*tx, py+ty);
      setcolor (15);
      rectangle (px-2, py, px+long*tx, py+ty);
   end;

procedure TZoneCouleur.afficherTout;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      str (valeur^:long, texte);
      AfficheTout;
   end;

destructor TZoneCouleur.fini;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      TZoneSaisie.done;
   end;

constructor TZoneListe.init;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      ch                : string;
      i                 : byte;

   begin
      str (v^, ch);
      TZoneSaisie.init (x, y, 2, ct, cf, ch, nm, unt);
      Liste.init (0, 1);
      Valeur := v;
   end;

procedure TZoneListe.Edite;
   {------------------------------------------------------------------------}
   { Souris doit tre cache en entre }
   {------------------------------------------------------------------------}
   Var
       larg,
       xs, ys,
       x0, y0,
       rangy,
       selection,
       hauteur,
       err
                        : integer;
       sortie,
       fin
                        : boolean;
       ch
                        : PString;
       z
                        : pointer;
       valeurI
                        : byte;

   procedure sauverfond;
      var
         i              : integer;

      begin
         x0 := px;
         y0 := py;
         hauteur := liste.count*ty+ty;
         largeur := 0;
         for i := 0 to Liste.count-1
         do begin
            ch := liste.at (i);
            if textwidth (ch^) > largeur
               then largeur := textwidth (ch^);
         end;
         largeur := largeur + 2*tx;
         if x0+largeur > maxx then x0 := maxx-largeur;
         if y0+hauteur > maxy then y0 := maxy-hauteur;
         getmem (z, imagesize (x0, y0, x0+largeur, y0+hauteur));
         getimage (x0, y0, x0+largeur, y0+hauteur, z^);
      end;

   procedure AfficherListe;
      var
         i              : integer;

      begin
         setfillstyle (solidfill, CFond);
         bar (x0, y0, x0+largeur, y0+hauteur);
         setcolor (15);
         rectangle (x0, y0, x0+largeur, y0+hauteur);
         setcolor (CTexte);
         for i := 0 to liste.count-1
         do begin
            ch := liste.at (i);
            outtextxy (x0+tx, y0+ty*i+ty- ty div 2, ch^);
         end;
      end;

   begin
      Afficher;
      ValeurI := Valeur^;
      fin     := false;
      {* Affichage des chanes }
      SauverFond;
      codesortie := 0;
      repeat
         {* Edition }
         sortie := false;
         AfficherListe;

         {* Mise  jour slection et affichage }
         setfillstyle (1, CTexte);
         bar (x0+1, y0+valeur^*ty- ty div 2,
              x0+largeur-1, y0+(valeur^+1)*ty- ty div 2);
         ch := liste.at (valeur^-1);
         setcolor (CFond);
         outtextxy (x0+tx, y0+valeur^*ty- ty div 2, ch^);

         {* Lecture souris }
         montrersouris;
         repeat
            if (codesortie = FleH) or (codesortie = FleB)
            then begin
               cachersouris;
               { effacer marqueur de slection }
               setfillstyle (1, CFond);
               bar (x0+1, y0+valeur^*ty- ty div 2,
                    x0+largeur-1, y0+(valeur^+1)*ty- ty div 2);
               ch := liste.at (valeur^-1);
               setcolor (CTexte);
               outtextxy (x0+tx, y0+valeur^*ty- ty div 2, ch^);

               { modifier slection }
               if codesortie = FleB
               then
                  valeur^ := (valeur^ mod liste.count) + 1;

               if codesortie = FleH
               then
                  valeur^ := (valeur^ + liste.count - 2) mod liste.count + 1;

               { afficher marqueur de slection }
               setfillstyle (1, CTexte);
               bar (x0+1, y0+valeur^*ty- ty div 2,
                    x0+largeur-1, y0+(valeur^+1)*ty- ty div 2);
               ch := liste.at (valeur^-1);
               setcolor (CFond);
               outtextxy (x0+tx, y0+valeur^*ty- ty div 2, ch^);
               montrersouris;
            end;

            codesortie := 0;
         until (Toucheclavier (codesortie)) or UnBoutonSourisEnfonce;

         {* Sortie de l'dition }
         {* souris montre }
         if CodeSortie = ESC
         then begin
            fin := true;
            valeur^ := ValeurI;
         end else begin
            {* Traitement du choix }
            if (codesortie = 0)
            then begin
               LirePositionSouris (xs, ys);
               rangy := (ys-y0-ty div 2) div ty + 1;
               if (rangy > 0) and (rangy <= liste.count) and
                  (xs >= x0) and (xs <= x0 + largeur)
               then begin
                  { OK souris }
                  valeur^ := rangy;
               end else begin
                  fin := true;
               end;
            end;
         end;
         CacherSouris;

         fin := not ((xs > x0) and (xs < x0+Largeur)
                 and (ys > y0) and (ys < y0+Hauteur))
              and unboutonsourisenfonce or (codesortie = esc)
                                        or (codesortie = FleG)
                                        or (codesortie = FleD)
                                        or (codesortie = TAB)
                                        or (codesortie = ShTAB)
                                        or (codesortie = CR)
      until fin;

      putimage (x0, y0, z^, NormalPut);
      libere (z);
      Afficher;
      MAJ;
   end;

procedure TZoneListe.cadrer;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      ch                : PString;
      i                 : integer;

   begin
      largeur := 0;
      for i := 0 to Liste.count-1
      do begin
         ch := liste.at (i);
         if textwidth (ch^) > largeur
         then
            largeur := textwidth (ch^);
      end;
      largeur := largeur + 2*tx;
      long    := (largeur-2*tx) div tx;
   end;

procedure TZoneListe.afficher;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      ch                : PString;

   begin
      cadrer;
      ch := liste.at (Valeur^-1);
      setfillstyle (solidfill, CFond);
      Bar       (px-2, py, px+largeur-2*tx, py+ty);
      setcolor  (15);
      rectangle (px-2, py, px+largeur-2*tx, py+ty);
      setcolor  (CTexte);
      outtextxy (px, py, ch^);
   end;

procedure TZoneListe.afficherTout;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      str (valeur^:long, texte);
      AfficheTout;
   end;

destructor TZoneListe.fini;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      Liste.deleteall;
      Liste.done;
      TZoneSaisie.done;
   end;

constructor TZoneBooleen.init;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      ch                : string;
      i                 : byte;

   begin
      TZoneSaisie.init (x, y, 1, ct, cf, '', nm, unt);
      Valeur := v;
   end;

procedure TZoneBooleen.Edite;
   {------------------------------------------------------------------------}
   { Souris doit tre cache en entre }
   {------------------------------------------------------------------------}
   Var
       xs, ys,
       err
                        : integer;
       sortie,
       fin,
       ValeurI
                        : boolean;

   begin
      Afficher;
      ValeurI := Valeur^;
      fin     := false;

      {* Edition }
      sortie := false;
      setcolor (0);
      rectangle (px-2, py, px+tx, py+ty);
      setcolor (15);
      rectangle (px-2+1, py+1, px+tx-1, py+ty-1);

      {* Lecture souris et clavier }
      MontrerSouris;
      repeat
         repeat
            until (Toucheclavier (codesortie)) or UnBoutonSourisEnfonce;
         fin := Unboutonsourisenfonce or (codesortie = esc)
                                      or (codesortie = FleB)
                                      or (codesortie = FleH)
                                      or (codesortie = FleG)
                                      or (codesortie = FleB)
                                      or (codesortie = TAB)
                                      or (codesortie = ShTAB)
                                      or (codesortie = 32)
                                      or (codesortie = ShTAB)
                                      or (codesortie = CR)

      until fin;
      CacherSouris;

      {* Sortie de l'dition }
      if CodeSortie = ESC
      then begin
         fin := true;
         valeur^ := ValeurI;
      end else begin
         {* Traitement du choix }
         if (codesortie = 32)
         then begin
            { OK clavier }
            valeur^ := not valeur^;
         end else begin
            LirePositionSouris (xs, ys);
            if (xs >= px) and (xs <= px + tx) and
               (ys >= py) and (ys <= py + ty)
            then begin
                  { OK souris }
                  valeur^ := not valeur^;
            end else begin
               fin := true;
               valeur^ := ValeurI;
            end;
         end;
      end;
      Afficher;
      MAJ;
   end;

procedure TZoneBooleen.afficher;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      setfillstyle (solidfill, cfond);
      Bar (px-2, py, px+tx, py+ty);
      setcolor  (ctexte);
      rectangle (px-2, py, px+tx, py+ty);
      if Valeur^
      then
         setcolor (ctexte)
      else
         setcolor (cfond);
      line (px-2+1, py+1, px+tx-1, py+ty-1);
      line (px-2+1, py+ty-1, px+tx-1, py+1);
   end;

procedure TZoneBooleen.afficherTout;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      AfficheTout;
   end;

destructor TZoneBooleen.fini;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      TZoneSaisie.done;
   end;

procedure TZoneOK.Edite;
   {------------------------------------------------------------------------}
   { Souris doit tre cache en entre }
   {------------------------------------------------------------------------}
   Var
       xs, ys,
       err
                        : integer;
       sortie,
       fin
                        : boolean;

   begin
      Afficher;
      fin := false;

      {* Edition }
      sortie := false;
      setfillstyle (solidfill, cfond);
      Bar       (px-2, py, px+long*tx, py+ty);
      rectangle (px-2, py, px+long*tx, py+ty);
      setcolor  (ctexte);
      outtextxy (px + (tx * (long - 7)) div 2, py, 'VALIDER');

      {* Lecture souris et clavier }
      MontrerSouris;
      repeat
         repeat
         until (Toucheclavier (codesortie)) or UnBoutonSourisEnfonce;
         fin := unboutonsourisenfonce or (codesortie = esc)
                                      or (codesortie = FleB)
                                      or (codesortie = FleH)
                                      or (codesortie = FleG)
                                      or (codesortie = FleB)
                                      or (codesortie = TAB)
                                      or (codesortie = ShTAB)
                                      or (codesortie = 32)
                                      or (codesortie = ShTAB)
                                      or (codesortie = CR)
      until fin;
      CacherSouris;
      Afficher;
   end;

constructor TZoneOK.init;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      ch                : string;
      i                 : byte;

   begin
      TZoneSaisie.init (x, y, 1, ct, cf, '', nm, unt);
   end;

procedure TZoneOK.afficher;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      setfillstyle (solidfill, ctexte);
      Bar       (px-2, py, px+long*tx, py+ty);
      setcolor  (cfond);
      rectangle (px-2, py, px+long*tx, py+ty);
      outtextxy (px + (tx * (long - 7)) div 2, py, valid);
   end;

procedure TZoneOK.afficherTout;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      AfficheTout;
   end;

destructor TZoneOK.fini;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      TZoneSaisie.done;
   end;

constructor TZoneSymboles.init;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      ch                : string;
      i                 : byte;

   begin
      lx     := 2*tx;
      TZoneSaisie.init (x, y, 2, ct, cf, ch, nm, unt);
      Valeur := v;
      nbsmb  := 8;
      affichersmb:= affichersymb;
      adr    := adr_coul;
      {ou self.affichersymb:=affichersymb}
   end;

procedure TZoneSymboles.Edite;
   Var
      largeur,
      hauteur,
      xs, ys,
      x0, y0,
      rangx,
      i,
      err
                        : integer;

      sortie,
      fin
                        : boolean;
      ValeurI
                        : byte;
      z
                        : pointer;

   procedure sauverfond;
      begin
         x0 := px;
         y0 := py;
         largeur := nbsmb*lx;
         hauteur := lx;
         if x0+nbsmb*lx > maxx
         then
            x0 := maxx-nbsmb*lx;
         if y0+lx > maxy
         then
            y0 := maxy-lx;
         getmem (z, imagesize (x0, y0, x0+nbsmb*lx, y0+lx));
         getimage             (x0, y0, x0+nbsmb*lx, y0+lx, z^);
      end;

   procedure AfficherSymboles ;
      var
         i              : integer;

      begin
         for i := 1 to NbSmb
         do begin
            setfillstyle (solidfill, Cfond);
            Bar         (x0+(i-1)*lx, y0, x0+i*lx, y0+lx);
            setcolor (15);
            rectangle   (x0+(i-1)*lx, y0, x0+i*lx, y0+lx);
            setcolor (byte(adr^));
            affichersmb (x0+(i-1)*lx +lx div 2,          y0+lx, i-1);
         end;
      end;

   begin
      if Valeur^ >= NbSmb
      then
         Valeur^ := NbSmb-1;
      if Valeur^ < 0
      then
         Valeur^ := 0;
      Afficher;
      ValeurI := Valeur^;
      fin := false;
      SauverFond;
      codesortie := 0;
      {* Mise  jour slection et affichage }
 {     valeur^:=valeur^+1;}
      repeat
         {* Edition }
         sortie := false;
         {* Affichage des couleurs }
         AfficherSymboles;

         setcolor (15);
         rectangle (x0+(valeur^)*lx+1, y0+1, x0+(valeur^+1)*lx-1, y0+lx-1);
         setcolor (0);
         rectangle (x0+(valeur^)*lx,   y0,   x0+(valeur^+1)*lx,   y0+lx);

         {* Lecture souris }
         montrersouris;
         repeat
            if (codesortie = FleD) or (codesortie = FleG)
            then begin
               cachersouris;
               { effacer marqueur de slection }
               setcolor ( cfond );
               rectangle (x0+(valeur^)*lx+1, y0+1, x0+(valeur^+1)*lx-1, y0+lx-1);
               setcolor ( 15);
               rectangle (x0+(valeur^)*lx, y0, x0+(valeur^+1)*lx, y0+lx);

               { modifier slection }
               if codesortie = FleD
               then
                  valeur^ := ((valeur^ + 1) mod NbSmb);
               if codesortie = FleG
               then
                  valeur^ := (valeur^ + NbSmb - 1) mod NbSmb;

               { afficher marqueur de slection }
               setcolor (15);
               rectangle (x0+(valeur^)*lx+1, y0+1, x0+(valeur^+1)*lx-1, y0+lx-1);
               setcolor (0);
               rectangle (x0+(valeur^)*lx, y0, x0+(valeur^+1)*lx, y0+lx);
               montrersouris;
            end;
            codesortie := 0;
         until (Toucheclavier (codesortie)) or UnBoutonSourisEnfonce;

         {* Sortie de l'dition }
         { souris montre }
         if CodeSortie = ESC
         then begin
            fin := true;
            valeur^ := ValeurI;
         end else begin
            {* Traitement du choix }
            if (codesortie = CR) or (codesortie = FleH)
                                 or (codesortie = FleB)
            then begin
               { OK clavier }
               valeur^ := valeur^;
            end else begin
               if unboutonsourisenfonce
               then begin
                  LirePositionSouris (xs, ys);
                  rangx := (xs-x0) div lx ;
                  if (rangx >= 0) and (rangx < NbSmb) and
                     (ys >= y0) and (ys <= y0 + lx)
                  then begin
                        { OK souris }
                        valeur^ := rangx;
                  end else begin
                     fin := true;
                  end;
               end;
            end;
         end;
         CacherSouris;
         fin := not ((xs > x0) and (xs < x0+largeur)
                 and (ys > y0) and (ys < y0+hauteur))
              and unboutonsourisenfonce or (codesortie = esc)
                                        or (codesortie = FleB)
                                        or (codesortie = FleH)
                                        or (codesortie = TAB)
                                        or (codesortie = ShTAB)
                                        or (codesortie = CR)
      until fin;

      putimage (x0, y0, z^, NormalPut);
      libere (z);
      Afficher;
      MAJ;
   end;


(*procedure TZoneSymboles.Edite;
   Var
      largeur,
      hauteur,
      xs, ys,
      x0, y0,
      rangx,
      selection,
      i,
      err
               : integer;
      sortie,
      fin
               : boolean;
      ValeurI
               : byte;
      z
               : pointer;

  procedure sauverfond;
     begin
        x0 := px;
        y0 := py;
        largeur := nbsmb*lx;
        hauteur := ty;
        if x0+nbsmb*lx > maxx then x0 := maxx-nbsmb*lx;
        if y0+ty > maxy then y0 := maxy-ty;
        getmem (z, imagesize (x0, y0, x0+nbsmb*lx, y0+ty));
        getimage             (x0, y0, x0+nbsmb*lx, y0+ty, z^);
     end;

  procedure AfficherSymboles ;
     var
        i : integer;

     begin
        for i := 1 to NbSmb
        do begin
           setfillstyle (solidfill, Cfond);
           Bar         (x0+(i-1)*lx, y0, x0+i*lx, y0+ty);
           setcolor (15);
           rectangle   (x0+(i-1)*lx, y0, x0+i*lx, y0+ty);
           setcolor (byte(adr^));
           affichersmb (x0+(i-1)*lx +tx,          y0+ty, i-1);
        end;
     end;

  begin
     Afficher;
     ValeurI := Valeur^;
     fin := false;
     SauverFond;
     codesortie := 0;
     repeat
        {* Edition }
        sortie := false;
        {* Affichage des couleurs }
        AfficherSymboles;

        {* Mise  jour slection et affichage }
        selection := valeur^+1;
        setcolor (15);
        rectangle (x0+(selection-1)*lx+1, y0+1, x0+selection*lx-1, y0+ty-1);
        setcolor (0);
        rectangle (x0+(selection-1)*lx,   y0,   x0+selection*lx,   y0+ty);

        {* Lecture souris }
        montrersouris;
        repeat
           if (codesortie = FleD) or (codesortie = FleG)
           then begin
              cachersouris;
              { effacer marqueur de slection }
              setcolor ( cfond );
              rectangle (x0+(selection-1)*lx+1, y0+1, x0+selection*lx-1, y0+ty-1);
              setcolor ( 15);
              rectangle (x0+(selection-1)*lx, y0, x0+selection*lx, y0+ty);

              { modifier slection }
              if codesortie = FleD
              then selection := (selection mod NbSmb) + 1;
              if codesortie = FleG
              then selection := (selection + NbSmb - 2) mod NbSmb + 1;

              { afficher marqueur de slection }
              setcolor (15);
              rectangle (x0+(selection-1)*lx+1, y0+1, x0+selection*lx-1, y0+ty-1);
              setcolor (0);
              rectangle (x0+(selection-1)*lx, y0, x0+selection*lx, y0+ty);
              montrersouris;
           end;
           codesortie := 0;
        until (Toucheclavier (codesortie)) or UnBoutonSourisEnfonce;


        {* Sortie de l'dition }
        { souris montre }
        if CodeSortie = ESC
        then begin
           fin := true;
           valeur^ := ValeurI;
        end else begin
           {* Traitement du choix }
           if (codesortie = CR) or (codesortie = FleH) or (codesortie = FleB)
           then begin
              { OK clavier }
              valeur^ := selection-1;
           end else begin
              LirePositionSouris (xs, ys);
              rangx := (xs-x0) div lx + 1;
              if (rangx > 0) and (rangx <= NbSmb) and
                 (ys >= y0) and (ys <= y0 + ty)
              then begin
                    { OK souris }
                    valeur^ := rangx-1;
              end else begin
                 fin := true;
              end;
           end;
        end;
        CacherSouris;
        fin := not ((xs > x0) and (xs < x0+largeur)
                 and (ys > y0) and (ys < y0+hauteur))
             and unboutonsourisenfonce or (codesortie = esc)
                                       or (codesortie = FleB)
                                       or (codesortie = FleH)
                                       or (codesortie = TAB)
                                       or (codesortie = ShTAB)
                                       or (codesortie = CR)
     until fin;

     putimage (x0, y0, z^, NormalPut);
     libere (z);
     Afficher;
     MAJ;
  end;
*)
procedure TZoneSymboles.afficher;
   {------------------------------------------------------------------------}
   { afficher le symbole courant }
   {------------------------------------------------------------------------}
   begin
      if Valeur^ >= NbSmb
      then
         Valeur^ := NbSmb-1;
      if Valeur^ < 0
      then
         Valeur^ := 0;
      setfillstyle (solidfill, cfond);
      Bar       (px-2, py, px+long*tx, py+ty);
      setcolor  (15);
      rectangle (px-2, py, px+long*tx, py+ty);
      setcolor (byte(adr^));
      affichersmb  (px-2+tx, py+ty, valeur^);
   end;

procedure TZoneSymboles.afficherTout;
   {------------------------------------------------------------------------}
   { afficher la liste des symboles }
   {------------------------------------------------------------------------}
   begin
      str (valeur^:long, texte);
      AfficheTout;
   end;

destructor TZoneSymboles.fini;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      TZoneSaisie.done;
   end;
   {------------------------------------------------------------------------}

constructor TBoiteSaisie.Init (x1, y1, cc, cf, ct : integer; t : string);
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      TObject.init;
      px1 := x1;     py1 := y1;
      ccadre := cc;  cfond := cf;  CTitre := ct;
      Titre  := t;
      ListeZones := new (PCollection, init (0,1));
   end;

procedure TBoiteSaisie.Vider;
   {-----------------------------------------------------------------------}
   {-----------------------------------------------------------------------}
   procedure AppelFini (Z : PZoneSaisie); far;
      begin
         Dispose (Z, fini);
      end;

   begin
      ListeZones^.foreach (@AppelFini);
      ListeZones^.DeleteAll;
   end;

destructor TBoiteSaisie.Fini;
   {-----------------------------------------------------------------------}
   {-----------------------------------------------------------------------}
   begin
      ListeZones^.DeleteAll;
      Dispose (ListeZones, done);
      TObject.done;
   end;

procedure TBoiteSaisie.Ajoute (Z : PZoneSaisie);
   {-----------------------------------------------------------------------}
   {-----------------------------------------------------------------------}
   begin
      ListeZones^.Insert (Z);
   end;

procedure TBoiteSaisie.Affiche;
   {-----------------------------------------------------------------------}
   {-----------------------------------------------------------------------}
   procedure AppelAffiche (Z : PZoneSaisie); far;
      begin
         Z^.Afficher;
      end;

   begin
      ListeZones^.ForEach (@AppelAffiche);
   end;

procedure TBoiteSaisie.Efface;
  {-----------------------------------------------------------------------}
  {-----------------------------------------------------------------------}
   procedure AppelEfface (Z : PZoneSaisie); far;
      begin
         Z^.Efface (c);
      end;

   begin
      ListeZones^.ForEach (@AppelEfface);
   end;

procedure TBoiteSaisie.Edite (num, poscur : integer; var CodeSortie : integer);
   {-----------------------------------------------------------------------}
   { En entre, la souris doit tre cache.                                }
   {-----------------------------------------------------------------------}
   var
      nul,
      nz,
      xs, ys,
      x,  y             : integer;
      z                 : PZoneSaisie;
      d, g,
      fin               : boolean;

   begin
      { AFFICHAGE DES ZONES }
      for nz := 0 to ListeZones^.Count-1
      do begin
         z := ListeZones^.at (nz);
         if z^.px = 0
         then
            z^.px := px1 + tx + tx*length(z^.nom) + tx;
         if z^.py = 0
         then
            z^.py := py1 +ty + (nz+1) * (ty+2);
         z^.Afficher;
      end;

      { EDITION }
      if (num <= 0) or (num > ListeZones^.count)
      then
         num := 1;

      fin := false;
      repeat
         z := ListeZones^.at (num-1);
         poscur := 1;
         CodeSortie := 0;
         z^.Edite (poscur, CodeSortie);

         { SELECTION PAR LA SOURIS }
         if BoutonSourisEnfonce (BoutonGauche)
         then begin
            repeat until not UnBoutonSourisEnfonce;
            LirePositionSouris (xs, ys);
            for nz := 1 to ListeZones^.Count
            do begin
               z := ListeZones^.at (nz-1);
               if z^.Contient (xs, ys)
               then begin
                  num := nz;
                  fin := (typeof (z^) = typeof (TZoneOK))
               end;
            end;
         end;
    (*      { pour grer ESC avec le BD

              toujours relachs !!!                }
           LireDernierRElachementSouris (BoutonGauche,nul,nul,nul);
           LireDernierrelachementSouris (BoutonDroit, nul,nul,nul);
           g := not (BoutonSourisEnfonce (BoutonGauche));
           d := not (BoutonSourisEnfonce (BoutonDroit));
           if g then codesortie := CR;
           if d then codesortie := ESC; *)
       { if BoutonSourisEnfonce (BoutonDroit)
         Then
            codesortie := ESC;}


         if (CodeSortie = ShFleD) or (CodeSortie = Tab) or
            (CodeSortie = FleB) or (CodeSortie = FleD) or (CodeSortie = CtrlFleD)
         then inc (num);

         if (CodeSortie = ShFleG) or (CodeSortie = ShTab) or
            (CodeSortie = FleH) or (CodeSortie = FleG) or (CodeSortie = CtrlFleG)
         then dec (num);

       {  if (BoutonSourisEnfonce (BoutonDroit))  then codesortie := ESC;
                toujours nul... }

         if (BoutonSourisEnfonce (BoutonDroit))  or
            (CodeSortie = CR) or (CodeSortie = ESC)
         then fin := true;

         num := ((num-1+ListeZones^.count) mod ListeZones^.Count) + 1;

         for nz := 1 to ListeZones^.Count
         do begin
            z := ListeZones^.at (nz-1);
            z^.AfficherTout;
         end;
      until fin;
   end;

(*procedure TBoiteSaisie.EditeF (num, poscur : integer; var codesortie : integer);
{------------------------------------------------------------------------}
{ En entre, la souris doit tre cache.                                 }
{------------------------------------------------------------------------}
var
   l, larg,
   x, y,
   nz,
   taille : word;
   image  : pointer;
   z      : PZoneSaisie;
   Valide : PZoneOK;

begin
   {* calcul des limites }
   Valide := new (PZoneOK, init (0, 0, CFond, CTitre, ' ', ' '));
   Valide^.long := 1;
   Ajoute (Valide);

   larg := 5*tx;
   l := textwidth (Titre) + 4*tx;
   if l > larg then larg := l;
   for nz := 0 to ListeZones^.Count-1
   do begin
      z := ListeZones^.at (nz);
      z^.Cadrer;
      l := TextWidth (z^.nom) + TextWidth (z^.unite) + tx * z^.long + 5 * tx;
      if l > larg then larg := l;
   end;
   Valide^.long := (larg div tx) - 2;
   px2 := px1 + larg;
   py2 := py1 + (ListeZones^.Count+3) * ty + ty;

   if px1 = Milieu then begin
      px1 := (maxx div 2) - (larg div 2);
      px2 := (maxx div 2) + (larg div 2);
   end;

   if py1 = Milieu then begin
      py1 := (maxy div 2) - (((ListeZones^.Count+3) * ty) div 2);
      py2 := (maxy div 2) + (((ListeZones^.Count+3) * ty) div 2 + ty);
   end;

   taille := imagesize (px1, py1, px2, py2);
   getmem (image, taille);
   getimage (px1, py1, px2, py2, image^);

   {* Affichage du cadre }
   SetColor (CCadre);
   SetFillStyle (SolidFill, CFond);
   Bar (px1, py1, px2, py2);
   Rectangle (px1, py1, px2, py2);

   {* }
   x := px1+( (px2-px1)-textwidth(titre) ) div 2;
   y := py1 + 2;
   SetColor (CTitre);
   OuttextXY (x, y, Titre);

   for nz := 0 to ListeZones^.Count-1 do begin
      z := ListeZones^.at (nz);
      if z^.px = 0 then
         z^.px := px1 + tx + tx*length(z^.nom) + tx;
      if z^.py = 0 then
         z^.py := py1 +ty + (nz+1) * (ty+2);
      if typeof(z^) = typeof(TZoneOK) then begin
         z^.py := z^.py + ty div 2;
         z^.px := z^.px - 3*tx div 2;
      end;
      z^.AfficherTout;
   end;

   Edite (num, poscur, CodeSortie);

   {Efface la boite}
   putimage (px1, py1, image^, 0);
   libere (image);

   ListeZones^.delete (Valide);
   dispose (Valide, fini);
end;
  *)

procedure TBoiteSaisie.EditeF (num, poscur : integer; var codesortie : integer);
   {------------------------------------------------------------------------}
   { En entre, la souris doit tre cache.                                 }
   {------------------------------------------------------------------------}
   var
      dy,
      l, larg, haut,
      x, y,
      nz,
      taille            : word;
      image             : pointer;
      z                 : PZoneSaisie;
      Valide            : PZoneOK;

   begin
      {* calcul des limites }
      Valide := new (PZoneOK, init (0, 0, CFond, CTitre, ' ', ' '));
      Valide^.long := 1;
      Ajoute (Valide);

      larg := 2*tx;
      haut := 2*ty;
      dy := ty;
      for nz := 0 to ListeZones^.Count-1
      do begin
         z := ListeZones^.at (nz);
         if z^.px <= 0
         then
            z^.px := tx + tx*length(z^.nom) + tx;
         if z^.py = 0
         then
            z^.py := dy + ty + ty div 2;
         if typeof(z^) = typeof (TZoneOK)
         then begin
            z^.py := z^.py + ty div 2;
            z^.px := z^.px - 3*tx div 2;
         end;
         l := {(z^.px-px1) +} TextWidth (z^.unite) + tx * z^.long + 5 * tx;

         if (z^.px +l > larg)
         then
            larg := z^.px+l;

         if z^.py > haut
         then
            haut := z^.py;
         dy := z^.py;
      end;

      haut := haut + 2*ty;
      if larg < 5*tx   then larg := 5*tx;
      if haut < 4*ty   then haut := 4*ty;

      l := textwidth (Titre) + 4*tx;
      if l > larg      then larg := l;

      for nz := 0 to ListeZones^.Count-1
      do begin
         z := ListeZones^.at (nz);
         z^.Cadrer;
      end;

      if px1 = Milieu
      then begin
         px1 := (maxx div 2) - (larg div 2);
      end;
      px2 := px1 + larg;

      if py1 = Milieu
      then begin
         py1 := (maxy div 2) - (((ListeZones^.Count+3) * ty) div 2);
      end;
      py2 := py1 + haut;

      Valide^.long := (larg div tx) - 2;

      taille := imagesize (px1, py1, px2, py2);
      getmem (image, taille);
      getimage (px1, py1, px2, py2, image^);

      {* Affichage du cadre }
      SetColor (CCadre);
      SetFillStyle (SolidFill, CFond);
      Bar (px1, py1, px2, py2);
      Rectangle (px1, py1, px2, py2);

      {* }
      x := px1+( (px2-px1)-textwidth(titre) ) div 2;
      y := py1 + 2;
      SetColor (CTitre);
      OuttextXY (x, y, Titre);

      for nz := 0 to ListeZones^.Count-1
      do begin
         z := ListeZones^.at (nz);
         z^.px := z^.px + px1;
         z^.py := z^.py + py1;
         z^.AfficherTout;
      end;

      CodeSortie := 0;
      Edite (num, poscur, CodeSortie);

      {Efface la boite}
      putimage (px1, py1, image^, 0);
      libere (image);

      ListeZones^.delete (Valide);
      dispose (Valide, fini);
   end;

function TBoiteSaisie.NumeroContenant (x, y : integer) : integer;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      Z                 : PZoneSaisie;
      i                 : integer;

   begin
      NumeroContenant := -1;
      for i := 0 to ListeZones^.count-1
      do begin
         Z  := ListeZones^.at (i);
         if Z^.Contient (x, y)
         then begin
            NumeroContenant := i+1;
            exit;
         end;
      end;
   end;


END.
{--- ARX - EDITION --------------------------- R.C.- INRP - TOULOUSE - 1993 }
