Unit Etab;

INTERFACE
Uses Crt;

FUNCTION ChampEtab(p_numero:byte):string;
PROCEDURE Etablissement_affiche;

IMPLEMENTATION

  VAR StrEtab:string[230];
  CONST NbArguments=10;  {Il doit y avoir autant de $ dans StrCrypt       }
        LgCode=50;       {Il doit y avoir autant de #0 en tte de StrCrypt}

CONST
      StrCrypt:string[230]='00000000000000000000000000000000000000000000000000'
      +'l''tablissement acqureur et$'
      +'ses personnels dans le cadre de$'
      +'leurs prparations de cours.$'
      +'CNDP, 29 rue d''Ulm$75230 PARIS CEDEX 05$$$$$$';
VAR   byte0a:array[0..255] of byte absolute StrCrypt;

{ ------------------------------------------------------------------------
  Renvoie la chane de caractres que constitue le champ de rang p_numero
  (sans le $ de fin de chane).
  Renvoie la chane vide si p_numero dpasse la valeur de NbArguments
  (nombre maxi de paramtres).
  ------------------------------------------------------------------------ }
FUNCTION ChampEtab(p_numero:byte):string;
VAR l_deb,l_fin:byte;
begin
  if p_numero>NbArguments then begin ChampEtab:=''; exit; end;
  l_deb:=1;
  while p_numero>1 do
    begin
    if StrEtab[l_deb]='$' then Dec(p_numero);
    Inc(l_deb);
    end;
  l_fin:=l_deb;
  while StrEtab[l_fin]<>'$' do Inc(l_fin);
  ChampEtab:=copy(StrEtab,l_deb,l_fin-l_deb)
end;

{ ------------------------------------------------------------------------
  Procdure d'affichage par dfaut des 5 premiers paramtres. Ils sont
  affichs 1 par ligne en commenant par la ligne o se trouve le curseur,
  au moment de l'appel ; ils sont aligns  gauche sur la colonne courante
  curseur au moment de l'appel.
  ------------------------------------------------------------------------ }
PROCEDURE Etablissement_affiche;
VAR l_x,i:byte;
begin
  l_x:=wherex;                 { mmo de colonne de dpart}
  for i:=1 to 6 do
    if ChampEtab(i)<>''
    then begin
         write(ChampEtab(i));
         gotoxy(l_x,wherey+1);
         end;
end;

{ ------------------------------------------------------------------------
  Dcode la chane encrypte dans StrCrypt, situe  la position LgCode+1
  (en commenant  compter les positions  partir de 1), et encrypte de
  manire cyclique  l'aide des LgCode premiers octets de la chane
  (tous de valeur 0 lors de la compilation du produit).
  Le rsultat de ce dcodage est rang dans une variable chane StrEtab.
  C'est cette chane qui sera utilise par la fonction ChampEtab, pour
  renvoyer les contenus des champs successifs.
  ------------------------------------------------------------------------ }
PROCEDURE Etablissement_decode;
VAR i,compteur:byte;
begin
  compteur:=0;
  i:=LgCode;                    { i pointe avant premier caractre de StrCrypt
                                   dcrypter }
  while compteur<NbArguments do
    begin
    Inc(i);
    if i=231
    then begin
         writeln('fichier altr !');
         Halt(1);
         end;
        {
        construction de la chane dcrypte, StrEtab, par soustraction
        au caracatre de rang i, de la chane encrypte, du caractre de
        mme rang, modulo LgCode (avec un dcalage de 1, d au comptage des
        positions  partir de 1 et non 0), de la mme chane (StrCrypt).
        }
    StrEtab[i-LgCode]:=chr(byte0a[i]-byte0a[(i-1) mod LgCode + 1]+48);
       {
       si caractre dcrypt est un '$', alors fin du champ courant et
       incrmentation du compteur de champs
       }
    if StrEtab[i-LgCode]='$' then Inc(compteur);
       {
       si fin de chane et pas le nombre de champs prvus, alors Halt car ce
       cas ne doit absolument pas se produire. Il est signe d'altration du
       fichier excutable.
       }
    end;
    StrEtab[0]:=chr(i-LgCode);   { mise  jour longueur chane dcrypte ;
                                   on pourrait la ngliger                }
end;


BEGIN
{ ------------------------------------------------------------------------
  en turbo pascal, il y a du code d'initialisation, excut au chargement,
  pour chaque unit indpendante (UNIT).
  Ce code est facultatif mais je l'utilise, ici, pour affranchir le pro-
  grammeur de l'appel au dcryptage, et encapsuler davantage le traitement.
  Les deux seules choses visibles de l'extrieur sont la fonction ChampEtab
  et la procdure Etablissement_affiche.
  ------------------------------------------------------------------------ }
  Etablissement_decode;
END.
