UNIT ExO_DES;

   {------------------------------------------------------------------------}
   {      logiciel PROG                                                     }
   {                      procdures graphiques du module                   }
   {                                             version 0.0 du  22/07/92   }
   {                                             rvise le      29/01/93   }
   {                                             rvise le      20/04/93   }
   {                                             rvise le      17/08/94   }
   {------------------------------------------------------------------------}

INTERFACE

{$O+,F+}

USES
   DOS,Graph,                { TP 70   - unit  standard              }
   Graphism,                 { ARX     - initialisations graphiques   }
   Utildivs,                 { ARX     - utilitaires divers           }
   csi,
   Souris,                   { ARX     - gestion de la souris         }
   Graphplt,                 { ARX     - graphisme 2D cran/traceur   }
   Graphuti,                 { ARX     - utilitaires graphiques       }
   Graphsg,                  { ARX     - symboles et graduations      }
   DirInfo,
   fichiers,
   CursExOc,
   Symboles,                 { ARX     - traitement des donnes ponctuelles }
   Curseurs,                 { ARX     - Potentiomtres simples et doubles  }
   Menus,                    { ARX     - interface menus              }
   Icones,
   GEO_var,                  { GEO     - variables globales communes  }
   GEO_des,                  { GEO     - procdures graph. communes   }
   ExO_var,                  { PROG    - variables globales du module }
   MathH, Igrf_, Fourier_;   { HUCHON  - Calculs                      }
{---------------------------------------------------------------------------}
procedure Dessiner_Noms (trac, cadre, fond : boolean);
Procedure ClotureControle(c1, c2, c3, c4 : integer);
   { dfinit la zone occupe sur l'cran: contrle que la fenetre n'a pas une
     dimension nulle et appelle GRAPHPLT.CLOTURE}

Procedure TraceInversions(AgeG,AgeC,AgeD : Real; CoulNorm,CoulInv : Word);
{procedure fenetrecloturecrantrac (trac : boolean);
procedure pleinecrantrac (trac : boolean);}
Procedure IniCalcul; {Pour calculer lorsqu'on n'a pas de profil observ}
        { ********* }
Procedure CalculsInitiaux(Index : Boolean);
        { ************** }
Procedure SOUS_ECHANTIL(xt : real);
        { ************* }
Procedure CALCUL;
        { ****** }
Procedure TRACE_RESULTAT(Recadre:boolean);
        { ************** }
Procedure REVERS (PAge,OAge:real;var ta:t2MaxInvers;var isgv,isgj,k:integer);
{         ******
  Calcul des inversions magntiques entre 2 ges donnes
  En entree:
     page ---> age le plus recent
     oage ---> age le plus ancien
  En sortie:
     ta   ---> tableau des ages des inversions, du recent vers
               le plus ancien. page et oage sont les bornes de
               ce tableau si ces ages ne coincident pas avec des
               inversions vraies.
     k    ---> nombre d'elements du tableau ta
     isgv ---> polarites des blocs extremes  ancien(v) et jeune(j)
     isgj            -1   inverse
                     +1   normal
----------------------------------------------------------------------}
Procedure INTAIM (xa: t2MaxInvers; n, isg, nf, nz: integer; aim: real;
         {******}  var data : t1024; var pas, xt: real);
{  Initialisation du profil d'aimantation en signaux +aim,-aim avant FFT
--------------------------------------------------------------------------}
Procedure INTINV (ta: t2MaxInvers; n, idors: integer;
         {******}var ninv: integer; var xa: t2MaxInvers;var xl, xd:real);
{  Geometrie du modele: positionnement de toutes les frontieres de blocs
   et calcul de l'indice de polarite.
   APPELS: Procedure LECVEL(incluse) ===> lecture des vitesses de spreading
   En entree:
     ta    --> tableau des ages des inversions, du recent vers
               le plus ancien. page et oage sont les bornes de
               ce tableau si ces ages ne coincident pas avec des
               inversions vraies.
     n     --> nombre d'elements du tableau ta
     idors -->  = 1   dorsale symetrique
                  2   dorsale non symetrique
                  3   pas de dorsale - des ages jeunes vers les ages anciens
                  4   pas de dorsale - des ages anciens vers les ages vieux
   En sortie:
     ninv ---> nombre total de frontieres
     xa   ---> coordonnees en km des frontieres de bloc, la premiere
               etant prise comme origine
     isg0 ---> indice de polarite du premier bloc : -1   inverse
                                                    +1   normal
     xl   ---> longueur du profil en km
     xd   ---> position de la ride si elle est presente
----------------------------------------------------------------------}

{Procedure LECVEL (ta: t2MaxInvers; n: integer; var x: t2MaxInvers);
---------------------------------------------------------------------
     lecture des vitesses de spreading et calcul des coordonnees
     des inversions magntiques. voir les subroutines varvel et
     onevel pour plus de details.
en entree:
     ta   ---> tableau des ages des inversions en ma du recent vers
               l'ancien en ma.
     n    ---> nombre total d'inversions.
en sortie:
     x    ---> coordonnees en km, origine en ta(n) c'est a dire
               axe oriente vers les ages les plus jeunes
Procedures appeles: VARVEL (incluse)===> Vitesse de preading variable
                     ONEVEL (incluse)===> Vitesse de spreading constante
----------------------------------------------------------------------}

{Procedure ONEVEL (ta: t2MaxInvers; n: integer; vel: real; var x: t2MaxInvers);
---------------------------------------------------------------------
  Coordonnees des inversions magnetiques suivant un axe,
calculees a partir du tableau des ages des inversions
et de la vitesse de spreading constante.
  En entree:
     ta   ---> ages des inversions en Ma du recent vers l'ancien.
     n    ---> nombre total d'inversions.
     vel  ---> vitesse de spreading en km/Ma (cm/an)
  En sortie:
     x    ---> coordonnees en km, origine en ta(n) c'est a dire                           c
               axe oriente vers les ages recents.
----------------------------------------------------------------------}

{Procedure VARVEL (ta: t2MaxInvers; n, nv: integer; v, tv: t30; var x: t2MaxInvers);
---------------------------------------------------------------------

  Coordonnees des inversions magnetiques suivant un axe calculees a partir
du tableau des ages des inversions  et de la vitesse de spreading variable
dans le temps
  En entree:
     ta   ---> ages des inversions en Ma du recent vers l'ancien.
     n    ---> nombre total d'inversions.
     nv   ---> nombre de vitesses de spreading differentes
     tv   ---> ages des changements de vitesse, en Ma, de l'ancien vers le
               recent.
     v    ---> tableau des vitesses en km/ma (cm/an)
  En sortie:
     x    ---> coordonnees en km, origine en ta(n) c'est a dire
               axe oriente vers les ages recents.
----------------------------------------------------------------------}
{Procedure CalculeDecDipActuel (var dec, dip,alat, along, day, amonth, year: real);
{         *******************
  Demande latitude, longitude et jour, mois, annee et calcule les
  paramtres en sortie:
                       dec : dclinaison du champ magntique
                       dip : inclinaison

  Fonction appele  : GIgrf (Unit IGRF_)
(*Procedure appele : YANN (Unit IGRF)*)
------------------------------------------------------------------------------}

{Procedure CalculeDecDipRemanent (var decr,dipr,flat: real);
{         *********************
  Demande la latitude de formation et retourne en sortie:
    decr : dclinaison du champ rmanent
    dipr : inclinaison
  Procdures appeles: aucune
------------------------------------------------------------------------------}

Procedure SKEWNESS (azim, dec, dip, decr, dipr: real; var teta, fac: real);
{         ********
En entre : azim       : azimuth du profil
            dec,  dip  : declinaison et inclinaison du champ actuel
            decr, dipr :                                     remanent
En sortie : teta       : skewness
            fac        : facteur multiplicatif
Procedure appele : fonction PROJ (incluse)
--------------------------------------------------------------------------}

Procedure Retrace(Calculer,Fond,ReCadre,Modif : Boolean);
          { ***** }
Function AgeIndexEch(XIndex:Real):real;
        { ********** }
Procedure CoordIndex;
        { ********** }
Function Age(X : Real):Real;
        { *** }
{Procedure Trace_Observe;
        { ********** }
Procedure Trace_Observe_Echelle(Echelle : Boolean);
        { ********************** }
Procedure Echelle;

Function AbcisseTerrain(AbcisseAffichage : Integer):real;
Function AbcisseAffichage(AbcisseTerrain : real):Integer;
Procedure AfficheLimite(Mx : Integer);
Procedure ReAfficheLimites;
Procedure Dess_Bathy (trac,nouv : Boolean; Var aff : boolean);
Procedure Dess_Contour (trac, aff : boolean);
{Procedure Fond_Boite_Fenetre(c1, c2, c3, c4, coul : integer);}
Procedure fond_boite (c1, c2, c3, c4, coul : integer);
        { ********** }
Function Oui(Texte1,Texte2 : Chaine): Boolean;

Procedure recalc_ecran;
   { recalcule les coordonnes pour un cran autre que VGA                  }

Procedure graduer_exterieur_xy;
   { dessine les graduations externes en X et Y                             }

Procedure def_icones;
Procedure dess_age_limite(Active : Boolean);
Procedure dess_icones;
   { affiche les icnes                                                     }
procedure IniFondEcran;
procedure inietat;
procedure ages;
procedure VERSION_LOGICIEL;
procedure ajoute_symboles (trac, eff : boolean);
{
procedure voir_essai;
procedure aff_min_max;

  {------------------------------------------------------------------------}
IMPLEMENTATION

procedure Dessiner_Noms (trac, cadre, fond : boolean);
Begin If Noms=Nil then begin CacherSouris;
                             Message('Pas de toponymie');
                             MontrerSouris end else
      if VisuToponym then Geo_Des.Dessiner_Noms (trac, cadre, fond)
end;

Procedure ClotureControle(c1, c2, c3, c4 : integer);
   { dfinit la zone occupe sur l'cran: contrle que la fenetre n'a pas une
     dimension nulle et appelle GRAPHPLT.CLOTURE}
Begin If(XdFen>XgFen)and(YhFen>YbFen)then Cloture(c1,c2,c3,c4) end;
(*
         i:=NbMaxInvers; t:=Inv[i]; Normal:=True;
         While (t<0)and(t<AgeG) do begin
         {recherche l'inversion la plus ancienne  gauche}
               Dec(i);  Normal := not Normal; t:=-Inv[i] end;
         If t=AgeG then Normal := Not Normal else t:=AgeG;
         While (i>1)and(t<-AgeC) do begin Dec(i);
           If Normal then CoulBar(SolidFill,CoulNorm)
                     else CoulBar(SolidFill,CoulInv);
           If Inv[i]>AgeC then begin
              Bar(XCloture(t),YCloture(0),XCloture(-Inv[i]),YCloture(1));
              t :=-inv[i]; normal:=not normal end
           else begin
              Bar(XCloture(t),YCloture(0),XCloture(-AgeC),  YCloture(1));
              t :=-AgeC
           end
         end;

         t:=0;i:=1;Normal :=False;
         While (i<NbMaxInvers)and(t<AgeC) do begin
         {recherche l'inversion la plus rcente  droite}
           Inc(i);  Normal := not Normal; t:=Inv[i] end;
         If t=AgeC then Normal := Not Normal else t:=AgeC;
         While (i<NbMaxInvers)and(t<AgeD) do begin Inc(i);
           If Normal then CoulBar(SolidFill,CoulNorm)
                     else CoulBar(SolidFill,CoulInv);
           If Inv[i]<AgeD then begin
              Bar(XCloture(t),YCloture(0),XCloture(Inv[i]),YCloture(1));
              t := inv[i]; normal:=not normal end
           else begin
              Bar(XCloture(t),YCloture(0),XCloture(AgeD),YCloture(1));
              t := AgeD
           end;
         end;

Procedure FenetreClotureInversions(AgeG,AgeD : Real);
Begin Fenetre (AgeG,AgeD, 0,1);
      ClotureControle (MaxC1, MaxC2, BasFenetreEchelle,BasFenetreObserve-Ecart);
end;
*)

Procedure TraceInversions(AgeG,AgeC,AgeD : Real; CoulNorm,CoulInv : Word);
{Type TabInvers : Array[1..2*MaxInvers]of Real;
Var PTAb : ^TabInvers;}
Var t  : Real;
    {BasFenetreEchelle, BasFenetreObserve,}
    XIndex,i  : integer;
    Normal : Boolean;

Procedure ChercheAGauche(AgeG,AgeD:Real);
Begin i:=NbMaxInvers; t:=-Inv[i]; Normal:=False;
      While (t<0)and(t<AgeG) do begin
            {recherche l'inversion la plus ancienne}
            Dec(i);  Normal := not Normal; t:=-Inv[i] end;
      If t=AgeG then Normal := Not Normal else begin t:=AgeG;inc(i) end;
      While (i>1)and(t<AgeD) do begin Dec(i);
            If Normal then CoulBar(SolidFill,CoulNorm)
                      else CoulBar(SolidFill,CoulInv);
            If -Inv[i]<AgeD then begin
               Bar(XCloture(t),YCloture(0),XCloture(-Inv[i]),YCloture(1));
               t :=-inv[i]; normal:=not normal end
            else begin
               Bar(XCloture(t),YCloture(0),XCloture(AgeD),  YCloture(1));
               t :=AgeD
            end
      end; XIndex:=XCloture(AgeD);
end;

Procedure ChercheADroite(AgeG, AgeD:Real);
begin t:=0; i:=1; Normal:=False; XIndex:=XCloture(AgeG);
      While (t<Inv[NbMaxInvers])and(t<AgeG) do begin
            {recherche l'inversion la plus rcente}
            Inc(i);Normal := not Normal;t:=Inv[i] end;
      If t=AgeG then Normal := Not Normal else begin t:=AgeG;Dec(i) end;
      While (i<NbMaxInvers)and(t<AgeD) do begin Inc(i);
            If Normal then CoulBar(SolidFill,CoulNorm)
                      else CoulBar(SolidFill,CoulInv);
            If Inv[i]<AgeD then begin
               Bar(XCloture(t),YCloture(0),XCloture(Inv[i]),YCloture(1));
               t := inv[i]; normal:=not normal end
            else begin
               Bar(XCloture(t),YCloture(0),XCloture(AgeD),YCloture(1));
               t := AgeD
            end;
      end;
end;

Procedure IniFenetre(AgeG,AgeD : Real);
Begin Fenetre (AgeG,AgeD, 0,1);
      ClotureControle (MaxC1, MaxC2, BasFenetreEchelle,BasFenetreObserve-Ecart);
      Fond_Boite (MaxC1,MaxC2,BasFenetreEchelle,BasFenetreObserve-Ecart,Coulboite);
      {Bordure(C_Bord);}
end;

Begin {BasFenetreEchelle := MaxC3       + 3*ty + ecart;
      BasFenetreObserve := BasFenetreEchelle + 2*ty + ecart;}
      If (AgeG<-AgeC)and(AgeD>AgeC)then begin {Segment  cheval sur l'ge minimum}
         IniFenetre (AgeG,AgeD-2*AgeC);
         ChercheAGauche(AgeG,-AgeC);
         ChercheADroite(AgeC, AgeD);
         {AgeIndexEch:=XUtilisateur(XIndex);
         If AgeIndexEch>-AgeC then AgeIndexEch := AgeIndexEch+2*AgeC
                              else AgeIndexEch := -AgeIndexEch;}
      end else
      if AgeG>=AgeC then begin {tout  droite}
         IniFenetre (AgeG,AgeD);
         ChercheADroite(AgeG, AgeD);
         {AgeIndexEch:=XUtilisateur(XIndex);}
      end else
      if AgeD<=AgeC then begin {tout  gauche}
         IniFenetre (AgeG,AgeD);
         ChercheAGauche(AgeG,AgeD);
         {AgeIndexEch:=abs(XUtilisateur(XIndex));}
      end; FixeCoul(C_Bord);
      GraduePlt(0,0,4,3,0,0,0,'ma','','Echelle magntique',3,3,4,1,3);
      PleineCloture; XdAj:=AbcisseTerrain(XIndex);XIndexTerrain:=XdAj;
end;

procedure inietat;
   var
      txtn, fondm, fondn : word;
      GClot,DClot,HClot,BClot : Word;
      GFen, DFen, HFen, BFen  : real;
   begin {fondn :=  numcouleur (coulfondnorm);                 fond  }
      GClot:=xgclot;DClot:=xdclot;HClot:=yhclot;BClot:=ybclot;
      GFen:= xgfen; DFen:= xdfen; HFen:= yhfen; BFen :=ybfen;
      PleineCloture;
      fondn := fondnorm; txtn  := txtnorm; fondm := fondmenu;
      Iconetxt (nomutil,        112, txtn, fondm, fondn);
      Iconetxt (Region+ExtReg,  113, txtn, fondm, fondn);
      Iconetxt (SansExt(nomfPar)+ExtPar, 114, txtn, fondm, fondn);
      Iconetxt (SansExt(nomfd)+ExtObs,   115, txtn, fondm, fondn);
      if copie_en_cours
      then Iconetxt (Datjour      , 116, txtn, fondm, fondn)
      else Iconetxt (Memdisponible, 116, txtn, fondm, fondn);
        {  Iconetxt (texte          i    cotxt    coext     coint           }
      Fenetre(GFen, DFen, BFen, HFen);
      ClotureControle(GClot,DClot,BClot,HClot);
   end;

procedure aff_etat  (n : byte);
   begin
      case n of
         1 : message ('Groupe et Utilisateur : '+ nomutil + ' le '+ datjour);
         2 : message ('Paramtres de rgion : ' + nomfpar+'.PAR');
         3 : message ('Paramtres travail : '   + nomfpar+extpar);
         4 : message ('Profil : ' + SansExt(nomfd)+ExtObs);
         5 : message ('mmoire disponible : ' + memdisponible +' octets');
      end;
   end;

procedure icone_etat;
var i, dx, py, hy : integer;
begin { icnes prdfinies pour l'affichage de la ligne d'tat }
      dx := posxbtn div 5; py := maxy - 2*ty -2; hy := maxy -   ty -4;
      { bouton 1 identique }
      bouton_icone ('Identification de l''utilisateur',
                                          112, 0,    py, dx -3, ty);
      { bouton 2 ExOc }
      bouton_icone ('Nom du fichier de paramtres de rgion',
                                          113, dx,   py, dx -3, ty);
      { bouton 3 EXOC }
      bouton_icone ('Nom du fichier de paramtres de travail en cours de modification',
                                          114, dx*2, py, dx -3, ty);
      { bouton 4 EXOC }
      bouton_icone ('Nom du fichier de donnes',
                                          115, dx*3, py, dx -3, ty);
      { bouton 5  commun }
      bouton_icone ('Mmoire disponible actuellement',
                                          116, dx*4, py, dx -3, ty);
      for i := 112 to 116
      do begin
         active_icone (i);
      end
   end;

procedure ini_par_ecr;
   begin
      maxc1        := 1;           { extension maxi clture }
      maxc2        := posxbtn-4;
      maxc3        := 2*ty+4;
      maxc4        := maxy -hauteurmenu - 3;
   end;

Procedure def_icones;
var px, py : integer;

begin px  := posxbtn;
      py  := maxy - (30 + ty);
      bouton_icone ('A propos ...',       1, px,    py,    48, 30);
      bouton_icone ('Version ...',        2, px+49, py,    48, 50);
      bouton_icone ('Calculer',           3, px,    py-53, 96, 50);
      py :=  hauteurmenu+3;
      bouton_icone ('Region...',          4, px,    py,    96, 30);
      Inc(py,33+3);
      bouton_icone ('Modle avec dorsale symtrique',
                                          5, px,    py, 46, 30);
      bouton_icone ('Modle avec dorsale dissymtrique',
                                          6, px+50, py, 46, 30);
      Inc(py,33);
      bouton_icone ('Modle sans dorsale - Age croissant vers la droite' ,
                                          7, px   , py, 46, 30);
      bouton_icone ('Modle sans dorsale - Age croissant vers la gauche',
                                          8, px+50, py, 46, 30);
      Inc(py,33);
      bouton_icone ('Vitesse d''expansion',
                                          9, px,    py, 46, 30);
      bouton_icone ('Position ou ge des changements de vitesse',
                                         10, px{+50}, py+2*33, 46, 30);
      Inc(py,33);
      bouton_icone ('Position du profil calcul par rapport  l''observ',
                                         11, px,    py, 46, 30);
      bouton_icone ('Abcisse de la dorsale',
                                         101, px+50,py, 46, 30);
      Inc(py,33*2);
      bouton_icone ('Aimantation volumique',
                                         12, px,    py, 46, 30);
      bouton_icone ('Epaisseur de la couche aimante',
                                         13, px+50, py, 46, 30);
      Inc(py,33);
      bouton_icone ('Bathymtrie moyenne',
                                         14, px,    py, 46, 30);
      bouton_icone ('Largeur de la zone d''intrusion',
                                         15, px+50, py, 46, 30);
      {Inc(py,33);}
      bouton_icone ('Azimut de la dorsale',
                                         16, px+50, py-4*33, 46, 30);
      bouton_icone ('Latitude de formation',
                                         17, px+50, py-2*33, 46, 30);
      Inc(py,33);
      bouton_icone ('Age des limites temporelles de calcul du modle',
                    100, px , py, 96 , 3*ty);
      Inc(py,3*ty+3);
      bouton_icone ('Abcisse de l''index et Age des terrains',
                    102, px , py, 96 , 2*ty);
      ini_par_ecr; BasFenetreEchelle := MaxC3 + 3*ty + ecart;
      bouton_icone ('Echelle des inversions',
                   111,MaxC1,MaxY-BasFenetreEchelle-Ecart-2*ty,MaxC2-MaxC1,2*ty);
      bouton_icone ('Limites d''affichage de l''echelle des inversions',
                   110,MaxC1,MaxY-BasFenetreEchelle+Ecart,MaxC2-MaxC1,3*ty);
      icone_etat;
end;

Procedure ages;
begin
      If IconeActive (100) then begin
         modif_donnee(100,
                        coulboite, coul_t, c_bord, c_symb,
                        '5:2',pas_age,
                        PAgeReg,OAgeReg{0,162},
                        PAge, OAge);
         If Etape=EtapeAjusteModele then Retrace(True,False,False,True)
         else If VisuEchelle then begin
                 dess_curseur_3 ('Limites','Ma','5:2',110,
                    coulboite, coul_t, c_bord, c_symb,
                    {xgicone (110), yhicone (110), MaxC2-MaxC1, 3*ty,}
                    Pas_Age, -OAge, PAge, OAge, AgeG, AgeD, True);
                 TraceInversions(AgeG,PAge,AgeD,C_normale,C_inverse) end;
      end;
end;

Procedure dess_age_limite(Active : Boolean);
Var c2,c3,c4: Word;
begin If Active then begin active_icone (100);
                           c2:=coul_t; c3:=c_bord; c4:=c_symb end
                else begin Inactive_icone(100);
                           c2:= 0;      c3:= 0;     c4:= 0     end;
      dess_curseur_2 ('Limites', 'Ma', '5:2' , 100,
                      CoulBoite, c2, c3, c4,
                      xgicone (100), yhicone (100), 96, 3*ty,
                      Pas_Age, PAgeReg,OAgeReg{0, 162}, PAge, OAge);
    end;

Procedure dess_icones;
   { affiche les icnes                                                     }
   var
      i : integer;

   begin
      for i := 1 to 17
      do active_dess_icone (i);
      dess_age_limite(true);
   end;


Procedure IniCalcul; {Pour calculer lorsqu'on n'a pas de profil observ}
        { ********* }
Begin CacherSouris;Message('En cours');MontrerSouris end;

procedure aff_ind (t1, t2 : string; ctxt : word);
   var
      px, py : integer;

   begin
      { effacer }
      px  := posxbtn;
      py  := hauteurmenu+33*8+3*ty+3+4+2;
      if ecran
      then begin
         coulbar   (1, coulboite);
         bar       (px, py, maxx-4, py+30);
      end;
      { texte }
      px  := (maxx+posxbtn+2) div 2;
      FixeCoul (ctxt);
      setusercharsize (1, 1, 1, 1);
      settextjustify (1, 1 );
      py := py + 7;
      outtextxy (px , py, t1);
      py := py + 15;
      outtextxy (px , py, t2);
      setusercharsize (3, 2, 3, 2);
      settextjustify (0, 2);
   end;

procedure eff_ind ;
   var
      px, py : integer;

   begin
      { effacer }
      px  := posxbtn+2;
      py  := hauteurmenu+ 33*8+3+3*ty;
      coulbar (1, coulecran);
      bar       (px, py, maxx, py+30);
   end;

Function AgeIndexEch(XIndex:Real):real;
Var x : Real;
Begin If (AgeG<-PAge)and(AgeD>PAge) then begin
         x:=AgeG+(XIndex-MaxC1)*(AgeD-AgeG)/(MaxC2-MaxC1);
         If x>-PAge then AgeIndexEch := x+2*PAge
                    else AgeIndexEch := -x end
                                    else
         AgeIndexEch:=abs(AgeG)+(XIndex-MaxC1)*(AgeD-AgeG)/(MaxC2-MaxC1);
end;

Procedure CoordIndex;
Var ch : String[6];Index : real;
    ch1, ch2 : string;
begin Index := AbcisseTerrain(XIndex);fixecoul (coul_t);
      SetWriteMode(NormalPut);Graph.SetLineStyle(SolidLn, 0, NormWidth);
      Str(Index:6:2,ch);
      ch1 := 'x= '+ch+' Km';
      If VisuEchelle or(Etape>EtapeDonneesInitiales) then begin
         If VisuEchelle then Str(AgeIndexEch(XIndex):6:2,ch)
                        else Str(Age(Index):6:2,ch);
         ch2 := 't= '+ch + ' Ma' end else ch2 := '' ;
      aff_ind (ch1, ch2, coul_t);
end;

Function Age(X : Real):Real;
Var i : byte; L,A : Real;
Begin A := PAge; L := XdAj; i := 1;
      If X>XdAj then begin
         While (i<NvD)and(X>LimD^[i].P.ap)do begin
               A := A+(LimD^[i].P.ap-L)/LimD^[i].V.ap/10;
               L := LimD^[i].P.ap; System.Inc(i); end;
         If IDors=4 then Age := PAge
                    else Age := A+(X-L)/LimD^[i].V.ap/10 end
                else begin
         While (i<NvG)and(X<LimG^[i].P.ap)do begin
               A := A+(L-LimG^[i].P.ap)/LimG^[i].V.ap/10;
               L := LimG^[i].P.ap; System.Inc(i); end;
         If IDors=3 then Age := PAge
                    else Age := A+(L-X)/LimG^[i].V.ap/10 end
end;

const marge = 1.2;

Procedure visu_l2  (var pro : PlotArray{pro2}; nbp : integer;co : word);
   { Affiche la ligne dfinie dans les 2 premires colonnes }
   var
      i           : integer;
      l, p        : real;

   begin
      fixecoul (co);
      for i := 1 to nbp
      do begin
         l := pro [i, 1];
         p := pro [i, 2];
         while (p >= Grilles.v_indef) and (i < nbp)
         do begin
            inc (i);
            l := pro [i, 1];
            p := pro [i, 2];
         end;
         if p < Grilles.v_indef then deplaceen (l, p);
         while (p <  Grilles.v_indef) and (i < nbp)
         do begin
            inc (i);
            l := pro [i, 1];
            p := pro [i, 2];
            if p < Grilles.v_indef then tracevers (l, p);
         end
      end;
   end;

Procedure CalculeDecDipActuel (var dec, dip, alat, along : real;
                                   day,amonth, year : Integer);
var   tm{,xm,ym,zm,hm,date}  : real;
      Tampon : String;
Const alti = 0.0; { niveau de la mer }
begin tm:=GIgrf (ALat,ALong,Alti,day,AMonth,Year,Dec,Dip,Tampon);
      If Tampon<>'' then Message(Tampon);
{  if (day = 0.0) then date := year + (amonth + 0.5     ) / 12.0
                 else date := year + (amonth + day/30.0) / 12.0;
  YANN (date,alti,alat,along,tm,xm,ym,zm,hm,dec,dip);}
end;

Procedure CalculeDecDipRemanent (var decr,dipr,flat: real);
begin
  dipr := arctan (2.0 * tan(flat*rad)) / rad;
  decr := 0.0;
end;

Procedure SKEWNESS (Azim, dec, dip, decr, dipr: real; var teta, fac: real);
var dipp, diprp : real;

    function PROJ (azim,dec,dip: real): real;
    var {dip2, }dif, p : real;
    begin dif  := azim - dec;
          p := ATan2 (TAN(dip),cos(dif));
          if (p < 0) then proj := p + pi else proj:=p;
{         dip2 := RMODULO (dip+Pi2,Pi2);
         dif  := azim - dec;
         if (abs(dif-pis2) <= epsil) then p := pis2
                                     else p := arctan (TAN(dip2)/cos(dif));
         if (p    < 0.0) then p := p + pi;
         if (dip2 > Pi ) then PROJ := p + Pi else PROJ := p;
}
    end;

begin { --------------- Debut procedure SKEWNESS ------------------------}
  dipp  := PROJ (azim,dec,dip);
  diprp := PROJ (azim,decr,dipr);
  teta  := dipp + diprp - pi; If Diprp = 0 then Diprp := epsil;
  fac   :=  sin (dip) * sin (dipr) / sin (dipp) / sin (diprp);
end;

Procedure CalculsInitiaux(Index : Boolean);
Var i : byte;
Begin       if (page > oage) then ECHANGER (page,oage);
            base := top + epa;
            If Index then XIndex :=AbcisseAffichage(XdAj);
            {***modif le 15/7***}
            For i:=1 to NvG do LimG^[i].V.ap:=LimG^[i].V.re/proj;
            For i:=1 to NvD do LimD^[i].V.ap:=LimD^[i].V.re/proj;
            If IDors=1 then
               For i:=1 to NvD do LimD^[1].V.re := LimG^[1].V.re;
            CalculeDecDipActuel(decAD, dipAD, Lat,Long,Jour,Mois,Annee);
            DecA := DecAD * rad; DipA := DipAD * Rad;
            CalculeDecDipRemanent(decrD, diprD, FLat);
            DecR := DecRD * rad; DipR := DipRD * Rad;
            Active(2,5,True);Active(5,5,True);
            {Proj := Cos((AzimProfilObs-AzimProfilCalc)*rad);
            LimD^[1].V.ap:=LimD^[1].V.re;LimD^[1].V.re:=LimD^[1].V.re*Proj;
            LimG^[1].V.ap:=LimG^[1].V.re;LimG^[1].V.re:=LimG^[1].V.re*Proj;}
end;

Procedure REVERS (PAge,OAge:real;var TA:t2MaxInvers;var isgv,isgj,k:integer);
var i, j : integer;
begin
     i:=1; k:=1; TA[1] := PAge;
     While Inv[i]<=PAge do inc(i);
     if odd(i) then isgj := -1 else isgj := 1;
     While (i<=NbMaxInvers) and (Inv[i]<=OAge) do begin
           inc(k); Ta[k]:=Inv[i]; inc(i) end;
     if odd(i) then isgv := 1 else isgv := -1;
     if (k = 1)           then isgj := isgv; {pas d'inversion dans le profil}
     if (i<=NbMaxInvers) and (oage <> Inv[i])  then begin
        inc(k); {on ne termine pas sur une frontire}
        isgv  := -isgv; ta[k] := oage; end;
end; { Fin de procedure REVERS }

Procedure INTAIM (xa: t2MaxInvers; n, isg, nf, nz: integer; aim: real;
                  var data : t1024; var pas, xt: real);
var x0, isg0 : real;
    i,k      : integer;
begin
  pas :=  (xa[n]-xa[1]) / (nf-2*nz-1);
  xt  := -pas * (nz-1);
  x0  :=  xa[1];
  for i := 1 to nz do data[i] := 0.0;
  k    := 1;
  isg0 := -isg;
  for i := nz+1 to nf-nz{-1} do begin
    if (k <> n) then if (x0 >= xa[k]) then begin isg0 := -isg0;
                                                 Inc(k);{k:=k+1} end;
    data[i] := aim * isg0;
    x0 := x0 + pas;
  end;
  for i := nf-nz+1 to nf do data[i] := 0.0;
end;

Procedure INTINV (ta: t2MaxInvers; n, idors: integer;
          var ninv: integer; var xa: t2MaxInvers; var xl, xd : real);
Var  x1, x2: t2MaxInvers; xt    : real; i     : integer;

Procedure LECVEL (Nv : Integer; Var Lim : t30Lim; ta: t2MaxInvers; n: integer; var x: t2MaxInvers);
{---------------------------------------------------------------------}
Var v,tv : t30;i : Integer;
Procedure ONEVEL (ta: t2MaxInvers; n: integer; vel: real; var x: t2MaxInvers);
{---------------------------------------------------------------------}
var f : real;
    i : integer;
begin
  f    := vel * 10.0 ; x[1] := 0.0;
  for i := 2 to n do x[i] := x[i-1] + f * (ta[n-i+2]-ta[n-i+1]);
end; { Fin de la procedure ONEVEL }

Procedure VARVEL (ta: t2MaxInvers; n, nv: integer; v, tv: t30; var x: t2MaxInvers);
{---------------------------------------------------------------------}
Var i,j : integer;
Begin tv[nv] := ta[1]; x[1] := 0; i := 2;
      For j := 1 to nv do begin
          If j>1 then
             begin x[i]:=x[i]+v[j]*10*(tv[j-1]-ta[n-i+1]);inc(i) end;
          While ta[n-i+1]>tv[j] do begin
                x[i]:=x[i-1]+v[j]*10*(ta[n-i+2]-ta[n-i+1]);inc(i) end;
          x[i]:=x[i-1]+v[j]*10*(ta[n-i+2]-tv[j]) end;
end;

begin { ------------ Dbut procedure LECVEL ---------------------}
  If Apparente then
     For i:=1 to nv do begin
         Lim[i].V.re := Lim[i].V.ap * Proj ;
         Lim[i].P.re := Lim[i].P.ap * Proj end else
     For i:=1 to nv do begin
         Lim[i].V.ap := Lim[i].V.re / Proj ;
         Lim[i].P.ap := Lim[i].P.re / Proj end;
  if (Nv > 1) then begin  { vitesses variables }
    for i := 1 to nv-1 do tv[i] := Age(Lim[nv-i].P.re);
    for i := 1 to nv   do  v[i] := Lim[nv-i+1].V.re;
    VARVEL (ta,n,nv,v,tv,x); end
  else { vitesse constante }ONEVEL (ta,n,Lim[1].V.re,x);
end; { Fin de la procedure LECVEL }

Begin { ------------- Debut de procedure INTINV ------------------------------ }
  Case IDors of
  3,4 : begin { Pas de dorsale }
    ninv := n;
    Case idors of
    3 : begin LECVEL (NvD,LimD^,ta,n,x1); xt := x1[n]; {Jeune->ancien}
        for i := 1 to n do xa[i] := xt - x1[n-i+1]; xd := 0; end;
    4 : begin LECVEL (NvG,LimG^,ta,n,x1);              {Ancien->Jeune}
        for i := 1 to n do xa[i] := x1[i]; xd := x1[n]; end;end;{Case}
    xl := x1[n]; end;{ Pas de dorsale }
  1,2 : begin { Avec dorsale }
    ninv := 2 * n - 2;
    Case idors of
    1 : begin LECVEL (NvG,LimG^,ta,n,x1);{Dorsale symtrique}
              xd := x1[n]; xl := 2.0 * xd;
              for i := 1 to n-1  do xa[i] :=      x1[i];
              for i := n to ninv do xa[i] := xl - x1[2*n-i-1];
              for i := 1 to NvD  do LimD^[i].V.re := LimG^[i].V.re end;
    2 : begin LECVEL (NvG,LimG^,ta,n,x1);{dorsale non symetrique}
              LECVEL (NvD,LimD^,ta,n,x2);
              for i := 1 to n-1  do xa[i] := x1[i];
              xl := x1[n] + x2[n]; xd := x1[n];
              for i := n to ninv do xa[i] := xl - x2[2*n-i-1]; end;end;
    end;{ Avec dorsale }
  end;  { Case IDors }
end;    { IntInv }

Procedure CALCUL;
        { ****** }
Var {XLoc1,XLoc2,RR  : real;}
    i, ixd, nf2, nfp1, nfp2 : integer;
    gaus1,gaus2     : ^t1026;     { filtre gaussien                    }
    x, x1, x2, xx   : ^t1026;     { profils intermediaires             }
    ta              : ^t2MaxInvers;      { ages des inversions                      }
    xa              : ^t2MaxInvers;      { coord. des frontires de blocs           }
begin ChangerCurseur(sablier);
  New(Gaus1); New(Gaus2); New(x); New(x1); New(x2);
  New(xx);    New(ta);    New(xa);
  SKEWNESS (AzimProfilCalc*rad, decA, dipA, decr, dipr, teta, fac); { calcul du facteur de }
  TetaD:=Teta*Deg;
  nf2  := nf div 2; nfp1 := nf + 1; nfp2 := nf + 2;
  REVERS (page,oage,ta^,isgv,isgj,n); { calcul des ages des inversions }
  if (idors = 3) then isg := isgj else isg := isgv;
  INTINV (ta^,n,idors,ninv,xa^,xl,xd);          { calcule geometrie de modele }
  aim := aim * 1.0e+5;
  INTAIM (xa^,ninv,isg,nf,nz,aim,data^,pas,xt); { initialise profil aimantation }
  aim := aim / 1.0e+5;
  for i := 1 to nf do xx^[i] := data^[i];
  FFT (xx^,nf,1); { transforme de Fourier du profil d'aimantation }
  if (sig > epsil) then begin                { avec filtre gaussien }
    ff := -2.0 * pi * pi * sig * sig;
    s  :=  0.0;
    ps :=  1.0 / nf / pas;
    for i := 1 to nf2 do begin {RR := ff*s*s; if RR>-11357 then Gaus1^[2*i-1] := exp0(RR)
                                                           else Gaus1^[2*i-1] :=0;}
        Gaus1^[2*i-1] := exp0(ff*Sqr(s));
        Gaus1^[2*i]   := 0.0;
        s := s + ps; end;
    Gaus1^[nfp1] := 0.0;
    Gaus1^[nfp2] := 0.0;

        fft(gaus1^,nf,-1);
        c0:=2.0/(1.0+pas/sqrt(pi2)/sig);
        Case Idors of
        4 : { Pas de dorsale ancien vers jeune }
          for i:=1 to nf2 do begin
            gaus1^[i]:=gaus1^[i]*c0;
            gaus1^[nf2+i]:=0.0;
          end;
        3 : { Pas de dorsale jeune vers ancien }
          for i:=1 to nf2 do begin
            gaus1^[i]:=0.0;
            gaus1^[nf2+i]:=gaus1^[nf2+i]*c0;
          end;
        1,2 : { Avec dorsale }
          for i:=1 to nf2 do begin
            gaus1^[i]:=gaus1^[i]*c0;
            gaus1^[nf2+i]:=0.0;
            gaus2^[i]:=0.0;
            gaus2^[nfp1-i]:=gaus1^[i];
          end;
        end;
        Case IDors of
        3,4 : begin                   { Pas de dorsale }
          fft(gaus1^,nf,1);
          For i:=1 to nf2 do begin    {convolution aimantation - filtre }
            i2:=2*i;
            i1:=i2-1;
            x^[i1]:=xx^[i1]*Gaus1^[i1]-xx^[i2]*Gaus1^[i2];
            x^[i2]:=xx^[i1]*Gaus1^[i2]+xx^[i2]*Gaus1^[i1];
          end;
          x^[nfp1]:=0.0;
          x^[nfp2]:=0.0;
          For i:=1 to nfp2 do xx^[i]:=x^[i];{xx^[i]:=x1^[i];}
          fft(xx^,nf,-1); end;        { transforme de Fourier inverse du profil filtr }
        1,2 : begin                   { Avec dorsale }
          fft(gaus1^,nf,1);
          fft(gaus2^,nf,1);
          For i:=1 to nf2 do begin    {convolution aimantation - filtre }
            i2:=2*i; i1:=i2-1;
            x1^[i1]:=xx^[i1]*gaus1^[i1]-xx^[i2]*gaus1^[i2];
            x1^[i2]:=xx^[i1]*gaus1^[i2]+xx^[i2]*gaus1^[i1];
            x2^[i1]:=xx^[i1]*gaus2^[i1]-xx^[i2]*gaus2^[i2];
            x2^[i2]:=xx^[i1]*gaus2^[i2]+xx^[i2]*gaus2^[i1];
          end;
          x1^[nfp1]:=0.0; x1^[nfp2]:=0.0;
          x2^[nfp1]:=0.0; x2^[nfp2]:=0.0;
          fft(x1^,nf,-1);             { transforme de Fourier inverse du profil filtr }
          fft(x2^,nf,-1);
          ixd:=Trunc((xd-xt)/pas)+1;
          For i:=1 to ixd do begin
            xx^[i]:=x1^[i];
            x^[i] :=x1^[i];
          end;
          For i:=ixd+1 to nf do begin
            xx^[i]:=x2^[i];
            x^[i] :=x2^[i];
          end;
          fft(x^,nf,1);
        end; end; { Case Idors }
    end
  else                                { pas de filtre gaussien }
    begin
    for i := 1 to nf do x^[i] := xx^[i];end;
  ps := pi2 / nf / pas;               { calcul de l'anomalie }
  s  := 0.0;
  c1 := pi2 * cos(teta);
  c2 := pi2 * -sin(teta);
  for i := 1 to nf2 do begin
    exptb :=exp0(-top * s)-exp0(-base * s);
    i2    :=  2 * i;
    i1    := i2 - 1;
    y1    := c1 * exptb;
    y2    := c2 * exptb;
    z^[i1] := x^[i1] * y1 - x^[i2] * y2;
    z^[i2] := x^[i1] * y2 + x^[i2] * y1;
    s := s + ps;
  end;
  z^[nfp1] := 0.0;
  z^[nfp2] := 0.0;
  FFT (z^,nf,-1); { transforme de Fourier inverse --> anomalie }
  Exo_var.zmin := 10000.0;
  Exo_var.zmax := - Exo_var.zmin;
  for i := 1 to nf do begin xkm^[i] := (i-1) * pas + xt;
                            z^[i]   := z^[i]*fac;
                            Exo_var.zmin := AMIN (Exo_var.zmin,z^[i]);
                            Exo_var.zmax := AMAX (Exo_var.zmax,z^[i]);
  end;
                                           { profil d'aimantation normalise }
  dy := (Exo_var.zmax - Exo_var.zmin) / aim / 1.0e6; { facteur de normalisation }
{  datamin := data^[1] * dy; datamax := datamin;}
  if (sig < epsil) then                              { sans filtre }
    for i := 1 to nf do begin data^[i] := data^[i] * dy;
{                              datamin := AMIN (datamin,data^[i]);
                              datamax := AMAX (datamax,data^[i]);}
                        end
  else                                                    { avec filtre }
    for i := 1 to nf do begin data^[i] := xx^[i] * dy;
{                              datamin := AMIN (datamin,data^[i]);
                              datamax := AMAX (datamax,data^[i]);}
                        end;
  Dispose(xa); Dispose(ta);    Dispose(xx);  Dispose(x2); Dispose(x1);
  Dispose(x);  Dispose(Gaus2); Dispose(Gaus1);
  ChangerCurseur(fleche);
end;

Procedure SOUS_ECHANTIL(xt : real);
        { ************* }
Var i,j:integer;istep:real;
begin
  istep := nf / MaxPlotGlb;      { sous echantillonnage pour trace }
  datamin := data^[1]{ * dy}; datamax := datamin+Epsil;
  for j := 1 to MaxPlotGlb do begin
       i:=round(j*istep);
       datano^ [j,1] := xkm^ [i]/Proj+xt;
       datano^ [j,2] :=   z^ [i];
       dataim^ [j,1] := xkm^ [i]/Proj+xt;
       dataim^ [j,2] := data^[i];
       If (j>1) and (IStep>=2) then
          If (DatAim^[j-1,2]<>data^[i-1]) and
             (dataim^ [j,2] = dataim^ [j-1,2]) then
             dataim^ [j,2] := data^[i-1];
       datamin := AMIN (datamin,data^[i]);
       datamax := AMAX (datamax,data^[i]);
  end;
end;

Procedure Fond_Boite_Fenetre(c1, c2, c3, c4, coul : integer);
Var   FillInfo: FillSettingsType; i : byte;
   begin
      if ecran
      then begin
         GetFillSettings(FillInfo);
         coulbar (solidfill, coul);
         bar (c1,c3,c2,c4);
         With FillInfo do SetFillStyle(Pattern,Color);
      end;
   end;



Procedure TRACE_RESULTAT(Recadre : Boolean);
        { ************** }
Var i,j,l : Integer;Ch : String[4];
    BasFenetre1,BasFenetre2,BasFenetre3,BasFenetre4 :Integer;
Const UnitesVitesse='cm/a';
      Ecart=3;

begin CacherSouris;
      BasFenetre1:= 3*MaxY Div 4;
      BasFenetre2:= MaxY div 2;
      BasFenetre3:= MaxY div 4;
      BasFenetre4:= MaxC3 + ty + ecart;
      BasLimite  := MaxY-maxc3-ty;
      If Recadre then begin
         xpmin := AMIN (xobsmin,xkm^[1]+XdAj-Xd);
         xpmax := AMAX (xobsmax,xkm^[nf]+XdAj-Xd);
         zpmin := AMIN (zobsmin,{data}zmin);
         zpmax := AMAX (zobsmax,{data}zmax); { mini maxi pour le plot des profils }
{         ClotureControle(0,  GetMaxX, 62, GetMaxY-42);
         Fond_Boite(0,  GetMaxX, 62, GetMaxY-42, NumCouleur(CoulFond_e));
{Bathymtrie}
         If BathyMax<>BathyMin then begin
            Fenetre (xpmin, xpmax, bathymax, BathyMin);
            ClotureControle (MaxC1, MaxC2,BasFenetre1 ,MaxC4);
            Fond_Boite (MaxC1, MaxC2,BasFenetre1,MaxC4, coulboite);
            Bordure(C_Bord);Axes;FixeCoul(C_Bord);
            GraduePlt(0,0,4,3,0,3,0,'km','km','Bathymtrie',2,3,3,1,1{2});
            Visu_l2(Bathy^,NObs,C_Bathy) end; {PleineCloture;
{Profil observ}
         Fenetre (xpmin, xpmax, zpmin*marge, zpmax*marge);
         ClotureControle (MaxC1, MaxC2,BasFenetre2,BasFenetre1-Ecart);
         Fond_Boite (MaxC1, MaxC2,BasFenetre2,BasFenetre1-Ecart, coulboite);
         Bordure(C_Bord);Axes;FixeCoul(C_Bord);
         GraduePlt(0,0,4,3,0,3,0,'km','nanoTesla','Profil observ',2,3,3,1,1{2});
         Visu_l2(DatObs^,NObs,c_observe); {PleineCloture;}end
      else begin ReafficheLimites; {Effacement des limites existantes}
           Graph.SetLineStyle(DashedLn, 0, NormWidth);FixeCoul(C_Index);
           SetWriteMode(XOrPut); AfficheLimite(XIndex);
           Graph.SetLineStyle(SolidLn, 0, NormWidth);SetWriteMode(NormalPut) end;
{Profil calcul}
      Fenetre (xpmin, xpmax, zpmin*marge, zpmax*marge);
      ClotureControle (MaxC1, MaxC2,BasFenetre3,BasFenetre2-Ecart);
      Fond_Boite (MaxC1, MaxC2,BasFenetre3,BasFenetre2-Ecart,coulboite);
      Bordure(C_Bord);Axes;FixeCoul(C_Bord);
      GraduePlt(0,0,4,3,0,3,0,'km','nanaoTesla','Profil calcul',2,3,3,1,1{2});
      Visu_l2(Datano^,MaxPlotGlb,c_calcule); {PleineCloture;
{Profil d'aimantation}
      Fenetre (xpmin, xpmax, DataMin*marge, DataMax*marge);
      l:=TextWidth('00.0'+UnitesVitesse);
      ClotureControle (MaxC1, MaxC2, BasFenetre4,BasFenetre3-Ecart);
      Fond_Boite (MaxC1, MaxC2, BasFenetre4,BasFenetre3-Ecart, coulboite);
      Bordure(C_Bord);Axes;FixeCoul(C_Bord);
      GraduePlt(0,0,4,3,0,3,0,'km','','Profil d''aimantation',2,3,3,1,1{2});
      Visu_l2(Dataim^,MaxPlotGlb,C_Aimant);

      For i:= 1 to NvD-1 do LimD^[i].A := AbcisseAffichage(LimD^[i].P.ap);
      For i:= 1 to NvG-1 do LimG^[i].A := AbcisseAffichage(LimG^[i].P.ap);
{Affichage des vitesses}{coulbar (SolidFill,Coulecran);Bar(0,MaxC3,MaxX,MaxC3+h);}
      ClotureControle (MaxC1, MaxC2, MaxC3,BasFenetre4-Ecart);
      Fond_Boite(MaxC1,MaxC2,MaxC3,BasFenetre4-Ecart,CoulEcran);
      FixeCoul(C_Aimant);j:=AbcisseAffichage(XdAj);
      Case IDors of 1 : begin Str(LimG^[1].V.re:4:1,Ch);
         Fond_Boite_Fenetre(j-(l div 2),j+(l div 2),0,ty,coulboite);{Bar(j,MaxC3,j+l,MaxC3+h);}
         OutTextXY(j-(l div 2),1,Ch+UnitesVitesse) end;
                    2 : begin Str(LimG^[1].V.re:4:1,Ch);
         Fond_Boite_Fenetre(j-l,j+l,0,ty,coulboite);{Bar(j-l,MaxC3,j+l,MaxC3+h);}
         OutTextXY(j-l,1,Ch+UnitesVitesse); Str(LimD^[1].V.re:4:1,Ch);
         OutTextXY(j,1,Ch+UnitesVitesse) end;
                    3 : begin Str(LimD^[1].V.re:4:1,Ch);
         Fond_Boite_Fenetre(j,j+l,0,ty,coulboite);{Bar(j-l,MaxC3,j+l,MaxC3+h);}
         OutTextXY(j,1,Ch+UnitesVitesse) end;
                    4 : begin Str(LimG^[1].V.re:4:1,Ch);
         Fond_Boite_Fenetre(j-l,j,0,ty,coulboite);{Bar(j-l,MaxC3,j+l,MaxC3+h);}
         OutTextXY(j-l,1,Ch+UnitesVitesse) end; end;
      For i:= 1 to NvD-1 do begin j:=LimD^[i].A;Str(LimD^[i+1].V.re:4:1,Ch);
          Fond_Boite_Fenetre(j,j+l,0,ty,coulboite);{Bar(j,MaxY-70,j+l,MaxY-70-h);}
          OutTextXY(j,1,Ch+UnitesVitesse); end;
      For i:= 1 to NvG-1 do begin j:=LimG^[i].A;Str(LimG^[i+1].V.re:4:1,Ch);
          Fond_Boite_Fenetre(j-l,j,0,ty,coulboite);{Bar(j-l,MaxY-70,j,MaxY-70-h);}
          OutTextXY(j-l,1,Ch+UnitesVitesse); end;
{Limites de blocs} PleineCloture; ReafficheLimites;
      XIndex:=AbcisseAffichage(XIndexTerrain);
      Graph.SetLineStyle(DashedLn, 0, NormWidth);FixeCoul(C_Index);
      SetWriteMode(XOrPut); AfficheLimite(XIndex);
      Graph.SetLineStyle(SolidLn, 0, NormWidth);SetWriteMode(NormalPut);
      Etape:=EtapeAjusteModele;CoordIndex; MontrerSouris;
end;

Procedure Retrace(Calculer,Fond,ReCadre,Modif : Boolean);
        { ******* }
Function IlFautRecadrer: Boolean;
        { ************** }
Begin IlFautRecadrer :=
         (xpmin <> AMIN (xobsmin,xkm^[1]+XdAj-Xd)) or
         (xpmax <> AMAX (xobsmax,xkm^[nf]+XdAj-Xd)) or
         (zpmin <> AMIN (zobsmin,zmin)) or
         (zpmax <> AMAX (zobsmax,zmax)){ mini maxi pour le plot des profils }
end;

begin If Calculer then CALCUL;         { Calcul du profil magntique et du profil d'aimantation }
      SOUS_ECHANTIL(XdAj-Xd/Proj);
      If Fond then begin ClotureControle(maxc1,maxc2,maxc3,maxc4);CacherSouris;
         Fond_Boite(maxc1,maxc2,maxc3,maxc4, coulecran);
         MontrerSouris; end;
      TRACE_RESULTAT(ReCadre or IlFautRecadrer);Hypotheses.Init(True,Modif);
      if visucomm then dessiner_commentaires (false{traceur},
                                              false{cadre},
                                              false{remplissage});
end; { ReTrace }

Procedure Trace_Observe_Echelle(Echelle : Boolean);
        { ********** }
{Var   BasFenetreBathy,BasFenetreObserve,BasFenetreEchelle :Integer;
Const Ecart=3;}
begin  XpMin := XObsMin; XPMax := XObsMax; AgeG:=-162;AgeD:=162;
   Fenetre(FC1,FC2,FC3,FC4);
   ClotureControle(maxc1,maxc2,maxc3,maxc4);
   Fond_Boite(maxc1,maxc2,maxc3,maxc4, coulecran);
   BasFenetreEchelle := MaxC3       + 3*ty + ecart;
   If Echelle then begin
      BasFenetreObserve := BasFenetreEchelle + 2*ty + ecart;
      BasFenetreBathy   := (BasFenetreObserve+MaxC4)div 2+Ecart;
   end else begin
      BasFenetreBathy   := MaxY Div 2;
      BasFenetreObserve := MaxC3 end;
   BasLimite := MaxY-BasFenetreObserve;
{Bathymtrie}
   If BathyMax<>BathyMin then begin
      Fenetre (xobsmin, xobsmax, bathymax, BathyMin);
      ClotureControle (MaxC1, MaxC2, BasFenetreBathy,MaxC4);
      Fond_Boite (MaxC1, MaxC2, BasFenetreBathy,MaxC4, coulboite);
      Bordure(C_Bord);Axes;FixeCoul(C_Bord);
      GraduePlt(0,0,4,3,0,3,0,'km','km','Bathymtrie',2,3,3,1,1{2});
      Visu_l2(Bathy^,NObs,C_Bathy) end;
{Profil observ}
   Fenetre (xobsmin, xobsmax, zobsmin*marge, zobsmax*marge);
   ClotureControle (MaxC1, MaxC2, BasFenetreObserve,BasFenetreBathy-Ecart);
   Fond_Boite (MaxC1, MaxC2, BasFenetreObserve,BasFenetreBathy-Ecart,Coulboite);
   Bordure(C_Bord);Axes;FixeCoul(C_Bord);
   GraduePlt(0,0,4,3,0,3,0,'km','nanoTesla','Profil observ',2,3,3,1,1{2});
   Visu_l2(DatObs^,NObs,c_observe);
   If Echelle then begin {Echelle des inversions}
      Fenetre (xobsmin, xobsmax, zobsmin*marge, zobsmax*marge);
      ClotureControle (MaxC1, MaxC2, BasFenetreEchelle,BasFenetreObserve-Ecart);
      Fond_Boite (MaxC1, MaxC2,  BasFenetreEchelle,BasFenetreObserve-Ecart,Coulboite);
      Bordure(C_Bord);{Axes;FixeCoul(C_Bord);
      GraduePlt(0,0,4,3,0,3,0,'km','','Echelle des inversions',2,3,3,1,1);
      {Visu_l2(DatObs^,NObs,c_observe); }
      PleineCloture;
      {bouton_icone ('Limites d''affichage de l''echelle des inversions',
                   110,MaxC1,MaxY-(BasFenetreEchelle-Ecart),MaxC2-MaxC1,3*ty);}
      active_icone (110);Active_Icone(111);VisuEchelle :=True;
      dess_curseur_3 ('Limites','Ma','5:2',110,
                    coulboite, coul_t, c_bord, c_symb,
                    {xgicone (110), yhicone (110), MaxC2-MaxC1, 3*ty,}
                    Pas_Age, -OAge, PAge, OAge, AgeG, AgeD, True);
      TraceInversions(AgeG,PAge,AgeD,C_Normale,c_Inverse{C_Aimant});
      dess_age_limite(True);
      LimG^[1].V.ap:=(XObsMax-XObsMin)/(AgeD-AgeG-PAge-PAge)/10;
      LimD^[1].V.ap:=LimG^[1].V.ap;{LimG^[1].V:=LimG^[1].Vp;LimD^[1].V:=LimG^[1].V;
      XIndex:= AbcisseAffichage((XObsMin+XObsMax)/2);Etape:=EtapeDonneesInitiales;}
   end else begin PleineCloture; VisuEchelle:=False;
      Inactive_Icone(110); Inactive_Icone(111); end;
   SetWriteMode(XORPut);Graph.SetLineStyle(DashedLn, 0, NormWidth);
   FixeCoul(C_Index); AfficheLimite(XIndex);CoordIndex;
   VisuCarte:=False;
end;

Procedure Echelle;
   begin
      modif_donnee_3(110,
                     coulboite, coul_t, c_bord, c_symb,
                     pas_age,-OAge,PAge,OAge,
                     AgeG,AgeD,True);
      LimG^[1].V.ap:=(XObsMax-XObsMin)/(AgeD-AgeG-PAge-PAge)/10;
      LimD^[1].V.ap:=LimG^[1].V.ap;{LimG^[1].V :=LimG^[1].Vp; LimD^[1].V :=LimG^[1].V;}
      CoordIndex;
      If Etape=EtapeAjusteModele then Retrace(True,False,False,ModiParamCalcul)
         else TraceInversions(AgeG,PAge,AgeD,C_Normale,C_Inverse{C_Aimant});
   end;

Function AbcisseTerrain(AbcisseAffichage : Integer):real;
Begin AbcisseTerrain :=
      XpMin+(AbcisseAffichage-MaxC1)*(XpMax-XpMin)/(MaxC2-MaxC1){592} end;

Function AbcisseAffichage(AbcisseTerrain : real):Integer;
Begin AbcisseAffichage :=
      Round(MaxC1+(AbcisseTerrain-XpMin)*(MaxC2-MaxC1)/(XpMax-XpMin)) end;

Procedure ReAfficheLimites;
Var i : Integer;
Begin SetWriteMode(XORPut);
      Graph.SetLineStyle(DashedLn ,0, NormWidth);FixeCoul(C_Limite);
      For i := 1 to NvG-1 do Line(LimG^[i].A,MaxY-MaxC3-ty,LimG^[i].A,MaxY-MaxC4);
      For i := 1 to NvD-1 do If LimD^[i].A <> AbcisseAffichage(XdAj) then
                             Line(LimD^[i].A,MaxY-MaxC3-ty,LimD^[i].A,MaxY-MaxC4);
      Graph.SetLineStyle(SolidLn,0, NormWidth);FixeCoul(c_bord);
      SetWriteMode(NormalPut);
end;

Procedure AfficheLimite(Mx : Integer);
begin
      {CacherSouris;}
      Line(MX,{MaxY-maxc3-ty}BasLimite,MX,MaxY-Maxc4);
      {MontrerSouris}
end;

{procedure fenetrecloturecrantrac (trac : boolean);
   begin
      if trac
      then begin
         ini_traceur;
         ecran   := false;
      end else begin
         ecran   := true;
         traceur := false
      end;
      fenetre (Cor1, Cor2, Cor3, Cor4);
      ClotureControle (cc1, cc2, cc3, cc4);
   end;
}
{procedure pleinecrantrac (trac : boolean);
   begin
      if trac
      then begin
         libere_traceur;
         ecran   := true
      end;
      pleinecloture;
   end;
}
procedure dess_fond (nomf : Pathstr; coc, coe : word; t : real);
Type  PMait             = ^TMait;
      TMait              = record x    : real;
                                  suiv : PMait;
                          end;

var   fic               : text;
      d                 : dirstr;
      n                 : namestr;
      e                 : extstr;
      Mait              : PMait;

   Procedure TrouveCourbesM (nomf : dirstr);
   var x,y,d,ar       : real;
       a,a1           : t12;
       M              : PMait;
       E              : integer;
   begin if not ftxt_present (nomf) then exit;
         assign  (fic, nomf);reset   (fic);
         readln  (fic, a);      { lecture bidon premire ligne commentaires }
         If eof(fic)then exit;
         readln   (fic, x, y,    d,    a);          { lire      }
         Val(a,ar,E);
         New(Mait);Mait^.x:=ar;Mait^.suiv:=Nil;M:=Mait;
         while (not (eof (fic))) do begin a1:=a;
            Repeat readln (fic, x, y, d, a); until (a1<>a)or(eof(fic));
            If a1<>a then begin Val(a,ar,E);
               New(M^.suiv);M:=M^.suiv;M^.x:=ar;M^.suiv:=Nil end;
         end;
         close   (fic);
      end;

   procedure dess_bln (nomf : dirstr ; co,ce : word);
      { travaille directement  partir du fichier : pas de mmorisation }
      { et prend en compte la valeur indfinie }
      var
         nbst, i, E     : integer;
         l, p, ar       : real;
         typ            : t12;
         M              : PMait;

      begin
         if not ftxt_present (nomf)
         then
            exit;
         assign  (fic, nomf);
         reset   (fic);
         fixecoul (co);
         while (not (eof (fic)))
         do begin         { lire une ligne }
            readln (fic, nbst, typ);    { lire entte : nb points, altitude }
            M:=Mait;Val(Typ,ar,E);
            While (M<>Nil)and(ar<>M^.x) do M:=M^.Suiv;
            If M<>Nil then fixecoul(ce) else fixecoul(co);
            if nbst > 1
            then begin
               i := 1;
               readln (fic, l, p);
               while i < nbst
               do begin
                  while (p >= Grilles.v_indef) and (i < nbst)
                  do begin { sauter val indfinies }
                     readln (fic, l, p);
                     inc    (i);
                  end;
                  deplaceen       (l, p);     { se dplacer sur le premier pt }
                  while (p < Grilles.v_indef) and (i < nbst)
                  do begin
                     inc    (i);
                     readln (fic, l, p);
                     tracevers   (l, p);
                  end
               end
            end
         end;
         While Mait<>Nil do begin M:=Mait;Mait:=Mait^.Suiv;Dispose(M) end;
         close (fic);
      end;

   procedure dess_eti (nomf : dirstr ; co : word; t : real);
      var
         x, y,    d     : real;
         a              : t12;

      begin
         if not ftxt_present (nomf)
         then
            exit;

        {         t  := 2;}
         initialiser_parametres_symbct
            (1,       t,      1,   0,  0,  65);
         assign  (fic, nomf);
         reset   (fic);
         fixetrait (0);
         readln  (fic, a);      { lecture bidon premire ligne commentaires }
         while (not (eof (fic)))
         do begin               { lire/dessiner une tiquette }
            readln   (fic, x, y,    d,    a);          { lire      }
            e_b_devant (a);                            { enlever espaces }
            etiquette_crb (x, y, t, d, co, a);         { dessiner tiquette }
         end;
         close   (fic);
      end;

   begin { cloture et fenetre en cours }
      fsplit (nomf, d, n, e);
      nomf := d+n; Mait:=Nil;
      TrouveCourbesM (nomf+exteti);
      dess_bln (nomf+extblf, coc,coe);
      dess_eti (nomf+exteti, coe, t);
   end;

Procedure Dess_Bathy (trac,nouv : Boolean; Var aff : boolean);
Begin If aff then begin;
         If Nouv then begin
            NomFCrb{NomFBathy}:='';
            dir_info                                                  { dirinfo }
             ('','Fichier courbes : ','', Chemindonnees, '*',ExtCrb, NomFCrb);
            NomFCrb :=  sansext   (NomFCrb)
         end;
         if NomFCrb <> '' then begin fenetrecloturecrantrac (trac);
            Dess_fond (CheminDonnees+NomFCrb,c_crb,c_etiqs,h_etiq);
            PleineCloture end
         else begin Aff := Not Aff;
               message('Pas de fichier de courbes accessible'); end;
      end
end;


Procedure Dess_Contour (trac, aff : boolean);
Var FCart      : Text;
    NbSt,i     : Integer;
    l,p        : Real;
Begin If FTxt_Present(CheminDonnees+NomFCart) then begin
      fenetrecloturecrantrac (trac);
      if aff then fixecoul (C_Carte)
             else fixecoul (CoulBoite);
      Assign(FCart,CheminDonnees+NomFCart);ReSet(FCart);
      While Not(EOF(FCart)) do begin
            ReadLn(FCart,NbSt);
            If NbSt>1 then begin ReadLn(FCart,l,p);DeplaceEn(l,p);
               For i := 2 to NbSt do begin ReadLn(FCart,l,p);TraceVers(l,p);
      end;end;end; Close(FCart); pleinecrantrac (trac) end;
end;

procedure fond_boite (c1, c2, c3, c4, coul : integer);
Var   FillInfo: FillSettingsType; i : byte;
   begin
      if ecran
      then begin
         GetFillSettings(FillInfo);
         coulbar (solidfill, coul);
{      bar (cc1, maxy-cc4, cc2, maxy-maxc3);}
         bar (0, 0, c2-c1, c4-c3);
         With FillInfo do SetFillStyle(Pattern,Color);
      end;
   end;

Function Oui(Texte1,Texte2 : Chaine): Boolean;
Var Reponse : Boolean;
Begin Question(Texte1,Texte2,Reponse);Oui := Reponse end;

procedure recalc_ecran;
   begin
      if (coef_x <> 1) or (coef_y <> 1)
      then begin
         cc1 := round (cc1 * coef_x);
         cc2 := round (cc2 * coef_x);
         cc3 := round (cc3 * coef_y);
         cc4 := round (cc4 * coef_y);
      end;
      If cc4<>cc3
      then coef_c := (cc2-cc1) / (cc4-cc3) else coef_c := 1;
   end;

procedure graduer_exterieur_xy;
   var
      px,   py,
      dx,   dy,
      dxg,  dyg : real;  { mm }

   begin
      fenetre (fc1, fc2, fc3, fc4);
      pleinecloture;
      traceur := false;                { sur l'cran seul }
      {bordure (blanc);}
      ClotureControle (cc1, cc2, cc3, cc4);
      axes;
      gradueplt (5, 5, 4, 2, 0, 2, 0,'' ,'' ,'' ,1 ,1 ,4 ,1 ,1);

      prep_graduation_2d (px, py, dx, dy);
                                    { calculer position et dimensions en mm }
      fenetre         (0, trunc (papier_x), 0, trunc (papier_y));
      cloturemilli    (0, trunc (papier_x), 0, trunc (papier_y));
                     { en millimtres position x, y, taille   x, y }
      bordure (c_bord);
      dxg := 1;       { initialiser les dcalages : modifier px et py }
      dyg := 1;

      graduer_xy (      1,                      { sens }
                        px,                     { coin g graphe mm }
                        py-dyg,                 { coin g }
                        dx,                     { largeur cartouche mm }
                        0,                      { hauteur cartouche (0 si 2d) }
                        fc1,                     { min fentre graduation }
                        fc2,                     { max                    }
                        5,                      { intervalle entre tiquettes }
                        3,                      { hauteur tiret mm }
                        4,                      { nb tirets intermdiaires }
                        2, {++0,                   { format des nombres }
                        c_bord,
                        c_bord,
                        1,
                        3,'Longitudes'{++});

      graduer_xy (      -1,                     { sens }
                        px-dxg,                 { coin g graphe mm }
                        py,                     { coin g }
                        0.001,                    { largeur cartouche mm }
                        dy,                     { hauteur cartouche (0 si 2d) }
                        fc3,                     { min fentre graduation }
                        fc4,                     { max                    }
                        5,                      { intervalle entre tiquettes }
                        2,                      { hauteur tiret mm }
                        1,                      { nb tirets intermdiaires }
                        2, {++0,                   { format des nombres }
                        c_bord,
                        c_bord,
                        1,
                        3,'Latitudes'{++});

      fenetre (fc1, fc2, fc3, fc4);
      pleinecloture;
   end;



FUNCTION LeadingZero(w : WORD) : STRING;
VAR s : STRING;
BEGIN Str(w:0,s);
      if Length(s) = 1 then s := '0' + s;
      LeadingZero := s;
END;

Function DateFich(NomF : PathStr):String;
VAR DirInfo: SearchRec;
  f: TEXT;
  h, m, s, hund : WORD; { Pour  GetTime}
  ftime : LONGINT;      { Pour  Get/SetFTime}
  dt    : DateTime;     { Pour  Pack/UnpackTime}

BEGIN FindFirst(NomF,Archive,DirInfo);
      UnpackTime(DirInfo.Time,dt);
      WITH dt DO DateFich := LeadingZero(Day)+'/'+LeadingZero(Month)+'/'+LeadingZero(Year);
{      WITH dt DO DateFich := Chaine(Day:2)+'/'+Chaine(Month:2)+'/'+Chaine(Year:4);}
end;

Procedure AfficheDateFich(X,Y,Horiz,Vert : Word;NomFi : PathStr);
Var AncienStyle : TextSettingsType;
BEGIN GetTextSettings(AncienStyle);
      SetTextJustify(Horiz, Vert);
      SetTextStyle(DefaultFont,HorizDir,1);
      OutTextXY(X,Y,DateFich(NomFi));
      WITH AncienStyle DO BEGIN SetTextJustify(Horiz, Vert);
                                SetTextStyle(Font, Direction, CharSize);
      END;
end;

procedure VERSION_LOGICIEL;
   begin
      message ('Logiciel GOcan - INRP  '+DateFich(ParamStr(0))+' - F. Borie');
   end;

procedure IniFondEcran;
   begin
{      ini_par_ecr; { report avant la dfinition des icones...}
      ini_format (formatpapier) ;   { initialise format de papier / traceur }
      inicoul_cfg;
      fond_ecran (coulecran);         {= coulecran=coulboite  }
      affichemenu;
      dess_icones;
      ini_titre;                                     { affiche titre rgion }
      {AfficheDateFich(MaxX,4,RightText,TopText,ParamStr(0));}
   end;

procedure ajoute_symboles (trac, eff : boolean);
   { dessiner seulement symboles sans rgnrer toutes les courbes }
   begin
      fenetrecloturecrantrac (trac );
      ChangerCurseur   (Sablier);
      montrersouris;
      voir_symboles    (chemindonnees+nomfvs+extvs, eff) ;
      ChangerCurseur   (fleche);
      cachersouris;
      pleinecrantrac   (trac);
   end;

(*procedure voir_essai;
   begin
      fini_zones;
      ini_zones;

      if previsu { visucourbes }
      then
         voir_essai_courbes
      else
         voir_essai_symboles;
   end;

procedure aff_min_max;
   begin
      if previsu { visucourbes }
      then begin
         dess_curseur_2 (titr3,     unitz,             fdg, 100,
                         coulboite, c_crbm,  c_bord, c_crb,
                         xgicone (100), yhicone (100), ce2-ce1, 3*ty,
                         equidist, lagrille.minzg, lagrille.maxzg, minc, maxc);
         active_icone   (100);
      end else begin
         if rang_v > 2
         then begin
            active_icone   (100);
            dess_curseur_2 (nomfvs, libcol+' '+unitval, fdp, 100,
                         coulboite, c_crbm,  c_bord, coul_s,
                         xgicone (100), yhicone (100), ce2-ce1, 3*ty,
                         pasvs,  min_v,   max_v,  borne_inf,  borne_sup);
         end else begin
            eff_min_max;
            inactive_icone (100);
         end;
      end;
   end;
*)
end.

(*Procedure Trace_Observe;
        { ********** }
begin  XpMin := XObsMin; XPMax := XObsMax;
   Fenetre(FC1,FC2,FC3,FC4);
   ClotureControle(maxc1,maxc2,maxc3,maxc4);
   Fond_Boite(maxc1,maxc2,maxc3,maxc4, coulecran);
{Bathymtrie}
   If BathyMax<>BathyMin then begin
      Fenetre (xobsmin, xobsmax, bathymax, BathyMin);
      ClotureControle (MaxC1, MaxC2, (MaxY Div 2)+10,MaxC4);
      Fond_Boite (MaxC1, MaxC2, (MaxY Div 2)+10,MaxC4, coulboite);
      Bordure(C_Bord);Axes;FixeCoul(C_Bord);
      GraduePlt(0,0,4,3,0,3,0,'km','km','Bathymtrie',2,3,3,1,1{2});
      Visu_l2(Bathy^,NObs,C_Bathy) end; {PleineCloture;
{Profil observ}
   Fenetre (xobsmin, xobsmax, zobsmin*marge, zobsmax*marge);
   ClotureControle (MaxC1, MaxC2, MaxC3, MaxY DIV 2);
   Fond_Boite (MaxC1, MaxC2, MaxC3, MaxY DIV 2,Coulboite);
   Bordure(C_Bord);Axes;FixeCoul(C_Bord);
   GraduePlt(0,0,4,3,0,3,0,'km','nanoTesla','Profil observ',2,3,3,1,1{2});
   Visu_l2(DatObs^,NObs,c_observe); PleineCloture;VisuCarte:=False;
   Inactive_Icone(110)
end;
*)
