UNIT MENUS;

   {------------------------------------------------------------------------}
   {    MENUS                                                               }
   {              interface graphique  menus droulants                    }
   {              ergonomie windows                                         }
   {                                                rvision le 23/1/93     }
   {------------------------------------------------------------------------}

   (*
   Menus,                    { ARX     - interface  menus droulants        }
   *)

INTERFACE

{$O+,F+}

USES
   dos,
   crt,
   graph,                    { TP 7.0  - standard Borland                   }

   Messarx,                  { ARX     - Textes des Messages de Base        }
   Graphism,                 { ARX     - initialisations graphiques         }
   Souris,                   { ARX     - gestion de la souris               }
   Clavier,                  { ARX     - gestion du clavier                 }
   Utildivs,                 { ARX     - utilitaires divers                 }

   Fichiers,                 { ARX     - gestion des fichiers               }
   Periphs;                  { ARX     - gestion des rriphriques          }

CONST
   Default              =   0;
   Triplex              =   1;
   Small                =   2;
   Sanserif             =   3;
   Gothic               =   4;
   nbboites             =   6;
   nboptions            =  12;

VAR
   Menuclavier                            { appel menu par ALT..}
                        : boolean;

   coche                                  { symbole options menu actives }
                        : char;

{ --------------------------------------------------------------------------}

Procedure initmenus;
   { initialise les tableaux de gestion des menus                           }

Procedure LibererMenus;
   { }

Procedure active                (x, y     : integer;
                                 e        : boolean);
   { bascule : active ou dsactive une option du menu.                      }

Procedure setcoulmenu           (c1, c2, c3, c4, c5, c6, c7, c8 : word);
   { initialise les couleurs utilises par les menus                        }
   {   barre menus  texte : c1,
        "           fond  : c2,  garder 0 si possible !
       boite        texte normal      : c3,
        "           texte inactif     : c4,
        "           texte slectionn : c5,
        "           fond normal       : c6,
        "           fond slectionn  : c7,
       Aide         barre d'aide      : c8.                                 }

Procedure ini_menu              (rep_bgi : Pathstr;
                                 pl      : integer);
   { initialisation des variables utilises par menus.                      }

Function HauteurMenu                                       : integer;
   { Renvoie la hauteur de la barre des menus en pixel.                     }

{ --------------------------------------------------------------------------}

Procedure textemenu             (x, y        : integer;
                                 texte       : chaine;
                                 commentaire : longchaine);
   { Initialise le texte d'une option et le commentaire associ  [72]       }

Procedure raz_option_menu       (x, y        : integer);
   { Met  jour le nombre d'options dans la boite x       (-1)              }

Function commentairemenu        (x, y        : integer)    : longchaine;
   { Rend le texte initialis par textemenu                                 }

Function titremenu              (x, y        : integer)    : chaine;
   { Rend le texte du titre initialis par textemenu                        }

Procedure razmenu;
   { efface tout les menus (remise  zero des variables)                    }

Procedure affichemenu;
   { affiche la barre du menu                                               }

Procedure sousmenu              (lmenu, hmenu, x : integer ;
                                 var y           : integer;
                                 var CodeClavier : integer);
   { affiche  une bote de slection en lmenu, hmenu (cran)                }
   { attend clic        : valider option
            ou flches  : slectionner
            ou F1       : aide                                              }

Procedure menu                  (var x, y, CodeClavier : integer);
   { attend l'action de la souris ou du clavier pour slectionner une       }
   { option et la valider ou annuler.                                       }
   { rend x = N bote,  x = Nsous menu, Codeclavier = num. touche         }

Procedure AIDE_MENUS_boites     (nomf                 : Pathstr);
   { aide sans bascule : accs par une bote liste et sous menu habituel    }

Procedure boite_aide     (nomf            : Pathstr;
                          index           : integer;
                          var lg, pos     : integer;
                          var titre       : chainecar);
   { rend la largeur et la hauteur du texte d'aide                          }

Procedure initaide       (nomf            : Pathstr ;
                          var ok          : boolean);
   { lit le fichier d'aide une fois                                         }
   {                et initialise une table d'index de l'aide               }

Procedure aff_aide       (nomf            : Pathstr ;
                          i, j            : integer);
   { affiche le texte d'aide correspondant                                  }
   {            au choix j dans le sous-menu i                              }
   {            dans une fentre  dfilement centre.                      }

{ MENUS --------------------------------------------------------------------}

IMPLEMENTATION

TYPE
   option               = record
                             titre       : chaine     { string [35] };
                             commentaire : longchaine { string [72] };
                             etat        : boolean;
                          end;

   Tindex_aide          = array [1.. nbboites, 1..nboptions] of integer;
   Tmenu1               = array [1.. nbboites, 1..nboptions] of option;
   Tlong                = array [1.. nbboites, 1.. 3]        of integer;

VAR
   index_aide           : ^Tindex_aide;
   menu1                : ^Tmenu1;
   long                 : ^TLong;

   relache,
   fini                 : boolean;

   LigneAide,
   p, c                 : pointer;

   lmenu,
   hmenu,
   lgmenu               : integer;

{---------------------------------------------------------------------------}

function HauteurMenu : integer;
   begin
      HauteurMenu := ty + dd0 + 1;
   end;

procedure active;
   begin
      if menu1^ [x, y].titre <> ''
      then
         menu1^ [x, y].etat := e
      else
         menu1^ [x, y].etat := false;
   end;

procedure setcoulmenu           (c1, c2, c3, c4, c5, c6, c7, c8 : word);
   begin
      colord           := c1; { 15 }
      colorf           := c2; {  0 }
      c_t_boite_norm   := c3; {  7 ou valeur dans fichier d'environnement }
      c_t_boite_inac   := c4; { 15 }
      c_t_boite_inve   := c5; {  0 }
      c_f_boite_norm   := c6;
      c_f_boite_inve   := c7;
      c_barre          := c8;
   end;

procedure initmenus;
   var
      i, j              : integer;

   begin
      for i := 1 to nbboites
      do begin
         long^ [i, 1] := 1;
         long^ [i, 2] := 1;
         long^ [i, 3] := tx;
         for j := 1 to nboptions
         do begin
            menu1^ [i, j].etat        := false;
            menu1^ [i, j].titre       := '';
            menu1^ [i, j].commentaire := '';
         end;
      end;
      hmenu := hauteurmenu+2;
   end;

procedure textemenu;
   begin
      menu1^ [x, y].titre := texte;               { nom de rubrique       }
      menu1^ [x, y].etat  := true ;               {     accessible        }
      menu1^ [x, y].commentaire := commentaire;   { aide associe         }

      if (length (texte) > Long^ [x, 2])
      then Long^ [x, 2] := length (texte);        { long en caractres    }

      if (textwidth (texte) > Long^ [x, 3])
      then Long^ [x, 3] := textwidth (texte);     { long maxi en pixels   }

      if (y-1) > Long^ [x, 1]
      then Long^ [x, 1] := y-1;                   { nb de rubriques       }
   end;

procedure raz_option_menu (x, y : integer);
   begin
      long^ [x, 1] := long^[x, 1]-1;
   end;

function commentairemenu (x, y : integer) : longchaine;
   begin
      commentairemenu := menu1^[x, y].commentaire;
   end;

function titremenu       (x, y : integer) : chaine;
   begin
      titremenu := menu1^[x, y].titre;
   end;

procedure razmenu;
   var
      i, j              : byte;

   begin
      for i := 1 to nbboites
      do begin
         Long^ [i, 1] := 1;
         Long^ [i, 2] := 1;
         Long^ [i, 3] := tx;
         for j := 1 to nboptions
         do begin
            menu1^ [i, j].etat        := false;
            menu1^ [i, j].titre       := '';
            menu1^ [i, j].commentaire := '';
         end;
      end;
   end;

procedure affichemenu;
   var
      i                 : integer;

   begin
{         getimage     (0, 0, maxx, ty + dd0 ,t^);}
      setfillstyle (SolidFill, colord);
      setcolor     (colord);
      bar          (0, 0, maxx, ty + dd0);
      setcolor     (colorf);
      for i := 1 to nbboites
      do begin
         if not menu1^ [i, 1].etat
         then setcolor (c_t_boite_inac);

         if (menu1^ [i, 1].titre = '')
            or
            (not menu1^[i, 1].etat and (maxcolor < 15))
         then
            line ((i-1)*lgmenu+d0,
                   ty div 2,
                  (i-1)*lgmenu+d0 +textwidth (menu1^ [i, 1].titre),
                   ty div 2);

         outtextxy   ((i-1)*lgmenu+d0, d0, menu1^ [i, 1].titre);
         setcolor (colorf);
      end;
   end;

{  procedure effacemenu;
   begin
      putimage (0, 0, t^, 0);
   end;
procedure RetablirLigneAide;
   begin
      PutImage (0, maxy-ty, LigneAide^, 0);
   end; }

procedure afficheboite (lmenu, hmenu, x : integer);
   var
      i, px, py
                        : integer;
      taille            : word;

   begin
      setcolor     (c_t_boite_norm);
      settextjustify (0, 2);
      setlinestyle   (0, 0, 1);
      px := lmenu + long^ [x, 3]      + 2 * tx;
      py := hmenu + long^ [x, 1] * ty + dd0*2;

      taille := imagesize (lmenu, hmenu, px, py);
      getmem    (p, taille);
      getimage  (lmenu, hmenu , px, py, p^);

      setfillstyle (SolidFill, c_f_boite_norm);
      bar       (lmenu, hmenu , px, py);
      rectangle (lmenu, hmenu , px, py);

      setcolor (c_t_boite_norm);
      for i := 2 to (long^[x, 1]+1)
      do begin
         if not menu1^[x, i].etat
         then
            setcolor (c_t_boite_inac);

         if (menu1^[x, i].titre='')
            or
            (not menu1^[x, i].etat and (maxcolor < 15))
         then
            line (lmenu+dd0,                  (i-2)*ty+hmenu+dd0+ty div 2,
                  lmenu+long^[x, 3]+2*tx-dd0, (i-2)*ty+hmenu+dd0+ty div 2);

         outtextxy (lmenu+tx,                   (i-2)*ty+hmenu+dd0,
                    menu1^[x,i].titre);
         setcolor (c_t_boite_norm);
      end;
   end;

procedure effaceboite (lmenu, hmenu, x : integer);
   begin
      putimage (lmenu, hmenu, p^, 0);
      libere   (p);
   end;

procedure sousmenu    (lmenu, hmenu, x : integer ;
                       var y           : integer;
                       var CodeClavier : integer);
   var
      i, j, x1, y1, y2  : integer;
      sortie, fin,
      test, test2       : boolean;
      Desactive,
      Touche            : boolean;

   begin
      if (lmenu < 0) and (hmenu < 0)
      then begin
         lmenu := maxx div 2 - (long^ [x, 3] div 2) - tx;
         hmenu := maxy div 2 - (long^ [x, 1] div 2) * ty;
      end;

      x1 := x;
      y1 := 2;

      { Recherche de la premire option active }
      desactive := false;
      if not Menu1^[x1, y1].etat
      then begin
         inc (y1);
         while (not Menu1^ [x1, y1].etat) and (y1 > 2)
         do begin
            y1 := (y1-1) mod (Long^ [x1, 1]) +2;
            desactive := true;
         end;
      end;
      (*       { exit si il n'y en a pas }
      if ((y1=2) and desactive) or (not Menu1[x1,1].etat) then begin
         exit;
      end;  *)

      CacherSouris;
      afficheboite (lmenu, hmenu , x);
      y := y1;

      { Inversion vido }

      if Menu1^ [x1, y].etat
      then begin
         setfillstyle (SolidFill, c_f_boite_inve);
         bar       (lmenu+dd0,                   (y1-2)*ty+hmenu+dd0 -1,
                    lmenu+long^[x1, 3]+2*tx-dd0, (y1-2)*ty+hmenu+dd0+ty);
         setcolor  (c_t_boite_inve);
         outtextxy (lmenu+tx,                    (y -2)*ty+hmenu+dd0,
                    menu1^[x1, y].titre);
      end;

      setfillstyle (SolidFill, c_barre);
      bar (0, maxy-ty, maxx, maxy);

      MontrerSouris;
      sortie  := false;
      fin     := false;
      CodeClavier := 0;
      Touche  := false;
      relache := not BoutonSourisEnfonce (BoutonGauche);
      repeat
         if touche
         then
            case CodeClavier of
               FleH : begin
                         y2 := y;
                         repeat
                            y := (y-3+Long^ [x1, 1]) mod (Long^ [x1, 1]) +2;
                         until Menu1^ [x1, y].etat or (y = y2);
                      end;
               FleB : begin
                         y2 := y;
                         repeat
                            y := (y-1) mod (Long^ [x1, 1]) +2;
                         until Menu1^ [x1, y].etat or (y = y2);
                      end;
            end
         else begin
            LirePositionSouris (xs, ys);
            y :=  trunc ((ys-hmenu-dd0)/ty)+2;
         end;

         test2 := false;
         if (xs > lmenu+dd0) and
            (xs < lmenu+long^ [x, 3]+2*tx-dd0) and
            (y <> y1)
         then
            test2 := true;

         if (((y > 1) and (y1 > 1)) and
             ((y  < long^ [x , 1]+d0) and
              (y1 < long^ [x1, 1]+d0)) and test2)
             or touche
         then begin
            CacherSouris;
            if (y1 > 1) and (y1 < long^ [x1, 1]+2)
                        and (menu1^ [x1, y1].etat)
            then begin
               setfillstyle (SolidFill, c_f_boite_norm);
               bar (lmenu+dd0,                    (y1-2)*ty+hmenu+dd0 -1,
                    lmenu+long^ [x1, 3]+2*tx-dd0, (y1-2)*ty+hmenu+dd0 +ty);
               setcolor (c_t_boite_norm);
               outtextxy (lmenu+tx, (y1-2)*ty+hmenu+dd0, menu1^ [x1, y1].titre);

               setfillstyle (SolidFill, c_barre);
               bar (0, maxy-ty, maxx, maxy);
            end;
            if (y > 1) and (y < long^ [x, 1]+2)
                       and (menu1^ [x, y].etat)
            then begin
               setfillstyle (SolidFill, c_f_boite_inve);
               bar (lmenu+dd0,                   (y-2)*ty+hmenu+dd0 -1,
                    lmenu+long^ [x, 3]+2*tx-dd0, (y-2)*ty+hmenu+dd0 +ty);
               setcolor (c_t_boite_inve);
               outtextxy (lmenu+tx,              (y-2)*ty+hmenu+dd0,
                          menu1^ [x, y].titre);

             {  setcolor  (colord);
               outtextxy (0, maxy-ty, menu1^[x, y].commentaire);}
               setcolor     (c_t_boite_norm);
               settextjustify (1, 2);
               outtextxy    (maxx div 2, maxy-ty + 1,
                             menu1^ [x, y].commentaire);
               settextjustify (0, 2);
            end;
            MontrerSouris;
            x1    := x;
            y1    := y;
            test2 := false;
            test  := true;
         end else begin
            y := y1;
            x := x1
         end;
         fin := sortie;

         if (not relache) and (not BoutonSourisEnfonce (BoutonGauche))
            then sortie := true;

         g := BoutonSourisEnfonce (BoutonGauche);
         while (not fin) and (relache and not g)
         do begin
            Touche := ToucheClavier (CodeClavier);
            if Touche
            then begin
               g := true;
               sortie := (CodeClavier = CR) or (CodeClavier = ESC)
            end else begin
               g := BoutonSourisEnfonce (BoutonGauche);
               sortie := true;
            end;
         end;
         LirePositionSouris (xs, ys);
         if (not touche) and (ys < ty+dd0)
                         and ((xs < (x1-1) * (maxx div nbboites))
                         or   (xs > 3+x1   * (maxx div nbboites)))
         then begin
            fin := true;
            relache := false
         end;

         if    (CodeClavier = FleD) or (CodeClavier = FleG)
            or (CodeClavier = CR)   or (CodeClavier = ESC)
            or (CodeClavier = F1)
         then
            fin := true;
      until fin;

      if Touche
      then begin
         if (CodeClavier = ESC)
         then
            y := 0;
      end else
         if (xs < lmenu) or (xs >= lmenu+long^ [x, 3]+2*tx)
                         or (ys >  long^ [x, 1]*ty + hmenu)
                         or (ys <  hmenu)
         then
            y := 0;

      CacherSouris;
      effaceboite (lmenu, hmenu, x);
      setfillstyle (SolidFill, c_barre);
      bar   (0, maxy-ty, maxx, maxy);
      MontrerSouris;
   end;

procedure menu;
   var
      sousmen, fleche   : boolean;
      xx                : integer;

   begin
      getmem (c, imagesize (0, maxy-ty, maxx, maxy));
      getimage             (0, maxy-ty, maxx, maxy, c^);{mm la ligne AIDE}
      setfillstyle (SolidFill, c_barre { ColorF });
      bar                  (0, maxy-ty, maxx, maxy);    { efface  ... }
      CodeClavier := 0;
      y    := 1;
      fini := false;
      Relache := false;
      MontrerSouris;
      Fleche  := false;
      repeat
         SousMen := false;
         LirePositionSouris (xs, ys);
         Relache := Relache or (Not BoutonSourisEnfonce (BoutonGauche));
         if Fleche
         then
            y := 0
         else begin
            y :=  trunc ((ys-hmenu-dd0)/ty);  { rc 07/06}

            if y <= 1
            then
               x := 0;
            if x = 0
            then begin
               x := 1+ (xs div (maxX div nbboites));
               if x > nbboites
               then
                  x := nbboites;
            end else
               y := 2;
         end;
         if menuclavier
         then begin
            x := 1;
            y := 2;
            menuclavier := false;
         end ;
         lmenu := (x-1)*lgmenu;

         if lmenu > maxx - long^ [x, 3]-2*tx-1
         then
            lmenu := maxx-long^ [x,3]-2*tx-1;

       {  if x > nbboites-1
         then lmenu := maxx-long^ [x, 3]-2*tx-1;   }

         if Menu1^ [x, 1].etat
         then begin
            Fleche := false;
            SousMenu (lmenu, hmenu, x, y, CodeClavier);
            if (ys > hauteurMenu) or (CodeClavier = CR)
            then begin
               Relache := true{ else relache := false};
               SousMen := true;
            end else
               SousMen := false;

            Case CodeClavier of
               FleD : begin
                         xx := x;
                         repeat
                            xx := xx mod nbboites + 1
                         until Menu1^ [xx, 1].etat or (xx = x);
                         x       := xx;
                         SousMen := false;
                         Fleche  := true;
                      end;

               FleG : begin
                         xx := x;
                         repeat
                            xx := (xx+nbboites-1) mod nbboites;
                            if xx = 0
                            then
                               xx := nbboites;
                         until Menu1^ [xx, 1].etat or (xx = x);
                         x       := xx;
                         SousMen := false;
                         Fleche  := true;
                      end;

               F1   : begin
                         SousMen := true;
                         Fleche  := false;
                      end;

            end;
         end;
      until (Relache and BoutonSourisEnfonce (BoutonGauche))
            or (Relache and SousMen);

      if not sousmen
      then y := 0;

      if     (CodeClavier <> F1)
         and (CodeClavier <> CR)
         and ((xs > lmenu+long^ [x, 3]+tx) or (xs < lmenu-tx))
      then
         y := 0;

      if (y > long^ [x, 1]+1)
      then
         y := 0;

      if y > 0
      then
         if not menu1^ [x, y].etat
         then
            y := 0;

      CacherSouris;
      putimage (0, maxy-ty, c^, 0);          { rtablit la ligne d'aide }
      libere   (c);
      setfillstyle  (SolidFill, c_t_boite_norm)
   end;

procedure active_aide ;
   var
       i, j             : integer;

   begin
      for i := 1 to nbboites
      do
         for j := 1 to nboptions
         do
            active (i, j, true);
   end;

procedure AIDE_MENUS_boites (nomf : Pathstr);
   var
      CodeClavier,
      i, x, y           : integer;
      chain             : chainecar;

   begin
      x := 1;
      for i := 1 to 5
      do
         creeliste (titremenu (i, 1),    i);

      liste     (l_menu1, l_menu2 , l_menu3, 12, chain, x);

      if x > 0
      then begin
         active_aide ;
         repeat until not unboutonsourisenfonce;
         montrersouris;
         SousMenu (-1, -1, x, y, CodeClavier);
         cachersouris;
      end else
         exit ;

      if y > 0
      then
         aff_aide (nomf, x, y-1);
   end;

procedure boite_aide (nomf        : Pathstr;
                      index       : integer;
                      var lg, pos : integer;
                      var titre   : chainecar);
                     { rend la largeur et la hauteur du texte}
   var
      tch               : string;
      ftxt              : text;
      prem              : char;

   begin
      pos   := 0;
      assign (ftxt, nomf);
      reset  (ftxt);
      while pos < index
      do begin
         readln (ftxt, tch);                   { lignes avant index }
         inc (pos)
      end;
      titre := souschaine (tch,']','');   { fin de la ligne indexe }
      lg    := 0;
      readln (ftxt, tch);                      { ligne suivante  }
      if tch = ''
      then
         tch := ' ';
      prem  := tch [1];
      pos   := 1;
      while (not (eof (ftxt))) and (pos < maxliste) and (prem <> '[')
      do begin
         if length (tch) > lg
         then
            lg := length (tch);
         listchaine^[pos] := tch;
         readln (ftxt, tch);
         if tch = ''
         then
            tch := ' ';
         prem := tch [1];
         inc (pos);
      end;
      listchaine^[pos] := '';
      pos := pos -1;
      close (ftxt);
   end;

procedure initaide (nomf : Pathstr; var ok : boolean);
   var
      i, j, pos, err    : integer;
      ftxt              : Text;
      ch, numx, numy    : string;
      prem              : char;

   begin
      ok := false;
      for i := 1 to nbboites
      do
         for j := 1 to nboptions-1
         do
             index_aide^ [i, j] := 0;

      if (not ftxt_present (nomf))
      then
         exit;
      ok := true;
      assign (ftxt, nomf);
      reset  (ftxt);

      pos := 0;
      i   := 0;
      j   := 0;

      while not (eof (ftxt))
      do begin
         readln (ftxt, ch);
         if ch = ''
         then
            ch := ' ';
         prem := ch [1];
         inc (pos);
         while (prem <> '[') and (not (eof (ftxt)))
         do begin
            readln (ftxt, ch);
            if ch = ''
            then
               ch := ' ';
            prem := ch [1];
            inc (pos);
         end;
         if not eof (ftxt)
         then begin
            numx := souschaine (ch, '[', ' ');
            numy := souschaine (ch, ' ', ']');
            val (numx, i, err);
            val (numy, j, err);
{            if (i <> 0) and (j <> 0) then index_aide^ [i, j] := pos}
            index_aide^ [i, j] := pos
         end
      end;
      close (ftxt);
   end;

procedure aff_aide (nomf : Pathstr; i, j : integer);
   var
      titre             : chainecar;
      index, lg, ht     : integer;

   begin
      if (i < 1) or (j < 1) or (i > nbboites) or (j > nboptions)
      then
         exit;

      index   := index_aide^ [i, j];

      if index = 0
      then
         exit;

      laide (la_fermer);
      boite_aide (nomf, index, lg, ht, titre );

      bte_compl  (titre, -1, -1, lg, ht, 57, 15);
      laide ('');
   end;

procedure ini_menu              (rep_bgi : Pathstr ; pl : integer);
   var
      i,
      st, bt            : integer;

   begin
      new (Index_Aide);
      new (Menu1);
      new (Long);
      inigraph (rep_bgi);
      SetPolMenu (Pl);
      Ini_stylemenu;
      ReinitialiserSouris;
      for i := 0 to maxcolor
      do
         pal [i] := true;
      lgmenu := trunc (maxx / nbboites);   { ou nbboites, mais trop d'talement ...}

      setcoulmenu (15, 0, 15, 7, 0, 0, 15, 0);

      setlinestyle (0, 0, 1);
      setcolor (colord);
      initmenus;
      lesdisques;
      coche := chr (251);
   end;

Procedure LibererMenus;
   begin
      Dispose (Index_Aide);
      Dispose (Menu1);
      Dispose (Long);
   end;


END.

{--- MENUS -------------------------------------------------- ARX - BALMA --}
