{ menu5}
   {------------------------------------------------------------------------}
   {    MENUP                                                               }
   {              interface graphique  menus droulants                    }
   {                                                            03/05/91    }
   {------------------------------------------------------------------------}

procedure voir_catalogue;
   var
      chem              : Pathstr;
      nf,
      filtr             : Namestr;

   begin
      nf    := '';
      chem  := '';
      filtr := '*.*';
      laide  ('Modifier le filtre des fichiers et valider');
      saisie ('Filtre :', filtr, 12);
      dir    ('Catalogue :', chem, nf, filtr, false);
      laide  ('');
   end;

procedure repertoire            (comm            : Chainecar;
                                 var chemin      : Pathstr;
                                 var ok          : boolean);
   var
      nf                : namestr;
      filtr             : namestr;
      chemini           : dirstr;

   begin
      if comm = ''
      then
         comm := 'Choisir un rpertoire : ';
      ok      := true;
      chemini := chemin;
      nf      := ''  ;
      filtr   := '*.';
      dir   (comm, chemin, nf, filtr, false);
      if nf = ''
      then begin
         chemin := chemini;
         ok     := false
      end;
   end;

procedure change_repertoire (var ok : boolean);
   var
      chemin                 : dirstr;
      l                      : integer;

   begin
      chemin := '';
      repertoire ('', chemin, ok);
      if ok
      then begin
         l     := length (chemin);
         if (l > 3)
         then
            if (chemin [l] = '\')
            then chemin := copy (chemin, 1, l-1 );
         chdir (chemin);
      end;
   end;

procedure nomfichier_entree     (comm            : chainecar;
                                 chemin          : pathstr;
                                 filtr           : namestr;
                                 var nf          : namestr);
   begin
      dir  (comm, chemin, nf, filtr, true);
      nf := sansext (nf);
   end;

procedure nomfichier_sortie     (comm            : Chainecar;
                                 chemin          : Pathstr;
                                 var nf          : Namestr;
                                 var ext         : Extstr;
                                 var ok          : boolean);
   var
      nomi,
      exti              : string;
      D                 : dirstr;
      N                 : namestr;
      E                 : extstr;
      p                 : integer;

   begin
      nomi   := nf;
      exti   := ext;
      p := 0;
      repeat
         saisie (comm, nf, 12);
         p := pos (' ', nf);
      until p = 0;
      fsplit (nf, D, N, E);
      ext    := E;
      if ext = '' then ext := exti;
      nf     := N;
      nf     := sansext (nf);

      if ftxt_present (chemin+nf+ext)
      then
         question (nf+ext+' existe ', 'Faut-il craser ce fichier ?', ok)
      else
         ok := true;

      if not ok
      then
         nf := nomi;

      nf := maj (nf);
   end;

procedure nomfichier_complet_entree
                                (comm            : Chainecar;
                                 filtr           : Namestr;
                                 var chemin      : Pathstr;
                                 var nf          : Namestr);
   begin
      dir  (comm, chemin, nf, filtr, false);
   end;

procedure nomfichier_complet_entr
                                (comm            : Chainecar;
                                 var chemin      : Pathstr;
                                 var nom         : Namestr;
                                 var ext         : Extstr);

   { = OUVRIR fichier existant avec une extension qq  si ext='.*'}

   begin
      dir  (comm, chemin, nom, ext, false);
      ext  := extension (nom);
      nom  := sansext   (nom);
   end;

procedure nomfichier_complet_sort
                                (comm            : Chainecar;
                                 var chemin      : Pathstr;
                                 var nom         : Namestr;
                                 var ext         : Extstr);
   { = NOUVEAU fichier  crer }

   var
      chemini,
      exti              : extstr;
      ok, valid         : boolean;
      D                 : dirstr;
      N                 : namestr;
      E                 : extstr;

   begin
      ok      := false;
      chemini := chemin;
      exti    := ext;

      saisie ( comm, nom, 12);
      fsplit ( nom, D, N, E);
      ext     := E;
      nom     := N;
      if (nom = '') or (ext='') or (ext='.') or (ext='*') or (ext='.*')
         then ext := exti;
      if nom = '' then exit;

      repertoire ('', chemin, valid);
      if valid
      then begin
         if ftxt_present (chemin+nom+ext)
         then
            question ( chemin+nom+ext+' existe dj.',
                      'Faut-il craser ce fichier ?',ok)
         else ok := true;

         if not ok then nom := '';
      end;
   end;

{---- MENU5 ----------------------------------------------------------------}




