UNIT MENU_VAR;

   {------------------------------------------------------------------------}
   {      logiciel GEOCEAN                                                  }
   {                       variables globales du module MENU                }
   {                                                   10/10/93             }
   {------------------------------------------------------------------------}

   (*
   MENU_VAR,                 { MENU    - variables globales du module       }
   *)

INTERFACE

{$O+,F+}

USES
   Dos,
   Lipar,                    { ARX     - gestion fichiers paramtres        }
   Utildivs,                 { ARX     - utilitaires divers                 }
   Menus;                    { ARX     - interface menus                    }

CONST
   extmn0               = '.MN0';        { Menus initiaux                   }
   extpar               = '.MNU';        { Menus                            }
   exthlp               = '.AID';        {              texte aide          }
   exticn               = '.ICN';        {              icnes              }
   exttxt               = '.TXT';        { Textes associs/rgion /module   }
   extcfg               = '.CFG';        { Configuration d'ensemble         }
   gcommun              = 'PUBLIC';      { Groupe inconnu                   }
   ninconnu             = 'ANONYME';     { Utilisateur inconnu              }
   nomlogiciel          = 'GEOCEAN';     { nom de l'ensemble des modules    }
   nommenu              = 'MENU';        { prog interface menus             }
   nomconf              = 'CONF';        { prog configuration menus         }
   nominst              = 'INST';        { prog premire installation       }
   nombgi               = 'REPBGI';      { nom du rpertoire BGI            }
   fic_etat_util        = 'UTILISAT.EUR';{ nom fichier session  de travail  }
   execute_bat          = 'EXECUTE.BAT'; { nom fichier bat intermdiaire    }
   quit_bat             = 'QUIT.BAT';    { nom fichier bat sortie           }
   MENUFINI_bat         = 'MENUFINI.BAT';{ nom fichier intermdiaire sortie }
   hicop                = 50;            { hauteur icnes                   }
   licop                = 86;            { longueur icnes                  }
   cod                  = 12;            { donnes rgions                  }
   coa                  = 11;            { activits                        }
   place_trv            = 100000;        { place pour espaces travail (oct) }

   {$I menu_msg.pas}  { messages en franais }

TYPE
   t_noms               = array [1..nboptions-1 ] of namestr;

   coord_icones         = array [1..nboptions-1,
                                 1..4]            of integer;

VAR
   picoa, picod              { pointeurs sur icnes actives                 }
                        : pointer;

   list_reg,                 { liste des rgions dj installes            }
   list_prg,                 { liste des programmes dj installs          }

   boite2,                   { menu 2 : rgions                             }
   boite3,                   { menu 3 : activits                           }
   list_grp                  { liste des groupes                            }
                        : lst_chn;

   menu_lig                  { nombre de lignes par bote                   }
                        : array [1..nbboites]     of byte;

   menu_autorise             { options autorises dans le menu fichiers     }
                        : array [1..nboptions-1]  of boolean;

   menu_prg                  { regions, progr possibles                     }
                        : array [1..nboptions-1,
                                 1..nboptions-1]  of boolean;

   of7ico                    { dcalages des icnes modules                 }
                        : array [1..nboptions-1]  of word ;

   menu_ico,                 { noms des icnes modules                      }

   menu_don,                 { noms des rgions                             }
   menu_cmd,                 { noms des fichiers de paramtres              }
   menu_pro                  { noms des programmes                          }
                        : t_noms;

   menu_ico2,                { coordonnes des icnes des donnes (rgions) }
   menu_ico3                 { coordonnes des icnes des modules (progr.)  }
                        : coord_icones; { x, y, l, h}

   repbgi,                   { repertoire *.BGI *.CHR                       }
   ch_grp,                   { chemin rpert travail ("collectif" ou priv) }
   ch_ech,                   { chemin rpert commun (changes)              }
   ch_mnu,                   { chemin complet du rp. MENU   *.EXE *.OVR    }
   ch_cfg,                   { chemin complet du rp. CFG                   }
   ch_dnn,                   { chemin et rp. des donnes (sans la rgion)  }
   ch_xpl,                   { chemin et rp. des exemples (  idem       )  }
   ch_doc,                   {                de la documentation           }
   ch_prg,                   { chemin du rp. des programmes (sans module)  }
   ch_par,                   { chemin fichiers MNU, CFG, NST                }
   ch_ct,                    { chemin courant                               }
   reptrav,                  { nom complet : Unit+Rpert+Groupe\           }
   r_trv_temp,               { var temporaire                               }
   r_trv,                    { unit et rpertoire de travail               }
   r_ct                      { unit et rep courant                         }
                        : pathstr;

   nomutil,                  { nom de l'utilisateur                         }
   nomvaru,                  { nom de la variable "username"                }
   prog,                     { nom du module                                }
   region,                   { nom de la rgion                             }
   groupe,                   { nom du groupe de travail "collectif"         }
   nom_cmd,                  { nom du fichier de paramtres sans extension  }
   nomfcfg,                  { nom du fichier de configuration de GEOCEAN   }
   nomdumodule,              { }
   symb1,
   {symb2,}
   symb3,                    { fichiers symboles             .SMB           }
   nomfpar                   { nom du fichier MENU pass en paramtre       }
                        : namestr;

   ext_cmd                   { extension fichiers de paramtres             }
                        : extstr;

   u_ct,                     { unit courante                               }
   u_trv,                    { unit de travail                             }
   u_trv_temp                { var temp Unit                               }
                        : string [2];

   ope_fic                   { oprations autorises sur les fichiers       }
                        : t12;

   chain                     { var temporaire                               }
                        : string;

   der_icn,                  { num. dernire icne fichier                  }
   zea, zed,                 { num. action icne activit, icne donnes    }
   nbgroupes,                { nombre de groupes prdfinis y compris PUBLIC}
   nbregions,                { nombre de zones de donnes au menu 1 au moins}
   nbmodules,                { nombre de programmes au menu       1 au moins}
                             { maxi dpend de la cte NBOPTIONS dans MENUS   }
   nbbtes,                   { nombre de botes du menu                     }
   ndonnees,                 { numro option donnes                        }
   nactivite,                { numro option activit                       }
   maxc1, maxc2,
   maxc3, maxc4,             { extension maxi clture                       }
   cc1,   cc2,
   cc3,   cc4,               { clture courante                             }
   codeclavier,              { code touche enfonce                         }
   a, b                      { position menu                                }
                        : integer;

   modini,                   { modif CFG/options en cours                   }
   modipar,                  { modif MENU en cours                          }
   echanges,                 { bascule accs au rpertoire commun           }
   exempl,                   { bascule accs aux exemples INRP              }

   instreso,                 { installation rseau demande                 }
   tousperso,                { pas de groupe associ aux noms des           }
                             { utilisateurs                                 }
                             { = espace priv sur le rseau
                                 gr par var env. DOS  (HOME DIR par ex    }

   unicolore,                { bloc limite NUAG une seule couleur           }
   rapide,                   { micro rapide > triangles BLOCS               }
   reaffiche,                { raffichage automatique demand              }
   fini,                     { sortie demande                              }
   prof,                     { mode prof = menus complets                   }
   ok,                       { var temporaire                               }
   TraitementAutorise        { autorise la modlisation das cart,bloc et coup   }
                        : boolean;

   parins,                   { paramtres d'installation                    }
   parini,                   { de CFG                                       }
   params                    { de MNU                                       }
                        : lipar.liste;

IMPLEMENTATION
var
   i                    : integer;

BEGIN

   nomdumodule      := 'MENU';
   prg_menu         := True;

   menu_ico [1]     := 'CART';  { icnes dfinies dans MENU.ICN }
   menu_ico [2]     := 'BLOC';
   menu_ico [3]     := 'NUAG';
   menu_ico [4]     := 'COUP';
   menu_ico [5]     := 'GRAV';
   menu_ico [6]     := 'EXOC';
   for i := 7 to nboptions-1
   do
       menu_ico [i] := '';

END.

{ GEOCEAN - MENU_VAR ------------------------- R.C.- INRP - TOULOUSE - 1993 }

