UNIT CART_DES;

   {------------------------------------------------------------------------}
   {      logiciel CART                                                     }
   {                      procdures graphiques du module                   }
   {                                                                        }
   {------------------------------------------------------------------------}

   (*
   CART_DES,         { graphisme du module                                  }
   *)

INTERFACE

{$O+,F+}

USES
   dos,
   Graph,                    { TP 70   - unit  standard Borland            }
   Souris,                   { ARX     - gestion de la  souris              }
   Clavier,                  { ARX     - gestion du clavier                 }
   Edition,                  { ARX     - saisie/dition paramtres          }
   Graphism,                 { ARX     - initialisations graphiques         }
   Messarx,                  { ARX     - Textes des Messages de Base        }
   Utildivs,                 { ARX     - utilitaires divers                 }
   Graphplt,                 { ARX     - graphisme 2D cran/traceur         }
   Graphsg,                  { ARX     - symboles et graduations            }

   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   Graphuti,                 { ARX     - utilitaires graphiques             }
   Icones,                   { ARX     - Gestion ICONES                     }
   Curseurs,                 { ARX     - potentiomtres horizontaux         }
   Symboles,                 { ARX     - traitement des donnes ponctuelles }
   Lipar,                    { ARX     - Lecture et affectation params      }

   Menus,                    { ARX     - interface menus                    }

   GRILLES,                  { ARX     - lecture des grilles                }
   COURBCAL,                 { ARX     - Calcul des courbes et zones        }
   COURBDES,                 { ARX     - Trac des courbes de niveau        }

   GEO_var,                  { GEO     - variables globales communes        }
   GEO_des,                  { GEO     - procdures graph. communes         }

   CART_var;                 { CART    - variables globales du module       }

{---------------------------------------------------------------------------}
Procedure edi_min_max;
   { Edition Minimum et maximum intervalle                                  }

Procedure aff_min_max;
   { Affiche double curseur                                                 }

Procedure edi_equi;
   { Edition intervalle courbes                                             }

Procedure choix_param_courbes;
   { Saisie paramtres frqence et couleurs                                 }

Procedure choix_param_etiqs;
   { Saisie paramtres tiquettes des courbes                               }

Procedure choix_param_autres (var cc1, cc2, tt1 : byte; var d : real;
                              var n : integer);
   { Saisie intervalle entre tiquettes                                     }

Procedure ajoute_grille (trac, eff : boolean);
   { redessine la grille                                                    }
   {           dans la fentre principale                                   }

Procedure efface_carte;
   { efface la carte si possible                                            }

Procedure modi_aff_carte;
   { dessine fentre graphique complte avec contour                        }

Procedure efftout;
   { efface la carte                                                        }
   { et libre les pointeurs sur la griile                                  }

Procedure recalc_ecran;
   { recalcule les coordonnes pour un cran autre que VGA                  }

Procedure inifondecran;
   { initialise l'tat de l'cran en fonction du fichier CFG                }

Procedure iniecran;
   { initialise l'tat de l'cran en fonction du fichier param par dfaut   }

Procedure finir;
   { sort en rtablissant l'cran texte                                     }

Procedure graduer_exterieur_xy (trac, eff : boolean);
   { dessine les graduations externes en X et Y                             }

Procedure ajoute_symboles      (trac, eff : boolean);
   { dessiner seulement symboles sans rgnrer toutes les courbes          }

Procedure ajoute_contours      (trac, eff : boolean);
   { dessiner seulement les contours sans rgnrer toutes les courbes      }

Procedure dess_courbes         (trac, sauver : boolean);
   { recalcule et redessine entirement les courbes de niveau               }
   { si trac=V alors sortie TRACEUR sinon sortie ECRAN                      }

Procedure reconstruire_courbes (trac : boolean);
   { visualise un fichier de courbes                                        }
   { recherche la description des courbes dans le fichier existant NOMFCRB
     au format BLN ou BLZ et raffiche avec les autres paramtres courants. }

Procedure voir_essai;
   { Visualise  essai symboles ou essai courbes                             }

Procedure def_icones;
   { Fixe l'ordre la position et la taille des zones sensibles              }

Procedure def_icones_smb;
   { Fixe ...  pour les icnes symboles }

Procedure changeiconesmb;
   { Bascule l'activation des 2 icnes  }

Procedure dess_icones;
   { affiche les icnes                                                     }

Procedure ajoute_une_zone_c;
   { Dfinit une nouvelle zone de couleurs et l'ajoute  la liste           }

Procedure ajoute_une_zone_s;
   { Dfinit une nouvelle zone de symboles et l'ajoute  la liste           }

Procedure edi_zone             (num  : integer);
   { Edite une zone                                                         }

Procedure redess_carte         (trac : boolean);
   { Redessine la carte complte                                            }

Procedure redess_tout;
   { R affiche tout l'cran aprs une inversion de couleurs                }

Procedure Effacer_tout_redessiner;
   { Efface toute la zone centrale puis raffiche la carte                  }

{---------------------------------------------------------------------------}

IMPLEMENTATION

var
   couletic             : word;
   minc0,
   mx, my, coef_hl      : real;
   nbc, nbd             : byte;

procedure def_icones;
   var
      px, py            : integer;

   begin
      px  := posxbtn;
      py  := maxy - (30 + ty);
      bouton_icone (aidico1,   1, px,  py,       96,     30);

      bouton_icone (aidico2,   2, px+94, py-2,    2,      2);

      bouton_icone (aidico3,   3, px,  py-53,    96,     50);

      py :=  hauteurmenu+6;
      bouton_icone (aidico4,   4, px,  py,       96,     30);

      bouton_icone ('',            101, ce1, maxy-ce3, ce2-ce1, 1);
      bouton_icone ('',            102, ce1, maxy-ce3, ce2-ce1, 1);
      bouton_icone ('',            103, ce1, maxy-ce3, ce2-ce1, 1);
      bouton_icone ('',            104, ce1, maxy-ce3, ce2-ce1, 1);
      bouton_icone ('',            105, ce1, maxy-ce3, ce2-ce1, 1);
      bouton_icone ('',            106, ce1, maxy-ce3, ce2-ce1, 1);
      bouton_icone ('',            107, ce1, maxy-ce3, ce2-ce1, 1);
      bouton_icone ('',            108, ce1, maxy-ce3, ce2-ce1, 1);
      bouton_icone ('',            109, ce1, maxy-ce3, ce2-ce1, 1);
      bouton_icone ('',            110, ce1, maxy-ce3, ce2-ce1, 1);

      icone_etat;
   end;

procedure def_icones_smb;
   var
      px, py            : integer;

   begin
      px := posxbtn;
      py := maxy-ce3+5;
      bouton_icone (aidico5,  5, px,    py, 44,   30);
      bouton_icone (aidico6,  6, px+50, py, 44,   30);

      py := py+ 30 + 4;
      bouton_icone (aidico100, 100, ce1 , py, ce2 - ce1, 3*ty);

      py := py +3*ty +4;
      bouton_icone (aidico111, 111, ce1 , py, ce2 - ce1, 5*ty div 2);

      active_icone (100);

      active_icone (111);
   end;

procedure dess_icones;
   var
      i                 : integer;

   begin
      for i := 1 to 6
      do
         active_dess_icone (i);
      inactive_icone (5);
   end;


procedure eff_min_max;
   begin
      coulbar (SolidFill, coulecran);
      bar (xgicone (100), yhicone (100), xdicone (100), ybicone (100) );
   end;

procedure eff_equi;
   begin
      coulbar (SolidFill, coulecran);
      bar (xgicone (111), yhicone (111), xdicone (111), ybicone (111) );
   end;

procedure aff_equi;
   begin
      if previsu { visucourbes }
      then
         dess_curseur_1 (n_Equidistance, unitz, fdg, 111,
                         c_crbm,  c_bord, c_crb,
                         xgicone (111), yhicone (111), ce2-ce1, 5*ty div 2,
                         pasequi , pasequi {10 ? min }, cminmax,
                         equidist );
   end;

procedure changeiconesmb;
   begin
      if previsu
      then begin                            { courbes }
         inactive_icone (5);
         active_icone   (6);
         active_icone   (111);
         aff_equi;
      end else begin                        { symboles }
         active_icone   (5);
         inactive_icone (6);
         inactive_icone (111);
         eff_equi;
      end;
   end;

procedure aff_min_max;
   begin
      if previsu { visucourbes }
      then begin
         dess_curseur_2 (titr3,     unitz,             fdg, 100,
                         coulboite, c_crbm,  c_bord, c_crb,
                         xgicone (100), yhicone (100), ce2-ce1, 3*ty,
                         equidist, lagrille.minzg, lagrille.maxzg, minc, maxc);
         active_icone   (100);
      end else begin
         if rang_v > 2
         then begin
            active_icone   (100);
            dess_curseur_2 (nomfvs, libcol+' '+unitval, fdp, 100,
                         coulboite, c_crbm,  c_bord, coul_s,
                         xgicone (100), yhicone (100), ce2-ce1, 3*ty,
                         pasvs,  min_v,   max_v,  borne_inf,  borne_sup);
         end else begin
            eff_min_max;
            inactive_icone (100);
         end;
      end;
   end;

procedure essai_courbe_etiqs (alt   : real; coul, couletic, trait : integer);
   begin
      formater       (alt, nbc, nbd, chain) ;
      fixecoul       (coul);
      fixetrait      (trait);

      deplaceen      (fe1,   alt);
      tracevers      (fe2/3, alt);
      fixecoul       (couletic);
      fixetrait      (0);

      justifie_texte (chain, 0, 1, mx, my);
      deplaceent     (fe2/3,   alt+my);
      ecrire_texte   (chain); { traceur et/ou cran }
   end;

procedure    ecris_min (min : real) ;
   begin
      deplaceenl      (fe1,     min);
      tracevers       (fe2/6,   min);

      formater   (min, nbc, nbd, chain) ;
      justifie_texte (chain, 2, 0, mx, my);
      my := my * coef_hl;
      deplaceent     (fe2+mx/xrap,   min+my);
      ecrire_texte   (chain);                  { traceur et/ou cran }
   end;

procedure    ecris_max (max : real);
   begin
      deplaceenl      (fe1,     max);
      tracevers       (fe2/6,   max);

      formater   (max, nbc, nbd, chain) ;
      justifie_texte (chain, 2, 2, mx, my);
      my := my * coef_hl;
      deplaceent     (fe2+mx/xrap, max+my);
      ecrire_texte   (chain);
   end;

procedure    ecris_minv (min : real);
   begin
      formater       (min, nbc, nbd, chain) ;
      justifie_texte (chain, 0, 0, mx, my);
      my := my * coef_hl;
      deplaceent     (fe1,   min+my/4);
      ecrire_texte   (chain);                    { traceur et/ou cran }
   end;

procedure    ecris_maxv (max : real);
   begin
      formater       (max, nbc, nbd, chain) ;
      justifie_texte (chain, 0, 2, mx, my);
      my := my * coef_hl;
      deplaceent     (fe1,   max+5*my/4);
      ecrire_texte   (chain);
   end;

procedure ecris_params;  { lgende des paramtres des courbes }
   begin
      coef_hl := (lagrille.maxzg-lagrille.minzg) / (fe2-fe1);
      { pour modifier l'chelle des hauteurs dans cette fentre
        de visualisation }
      fixecoul   (c_crbm);
      fixetrait  (0);
      ecris_min  (minc);
      ecris_max  (maxc);
      fixecoul   (c_crb);
      ecris_minv (lagrille.minzg);
      ecris_maxv (lagrille.maxzg);
   end;

procedure ecris_params_valeur;   { lgende des zones de symboles }
   begin
      initialiser_parametres_courants (1, h_etiq, 0, 0, 65);
      coef_hl := (max_v-min_v) / (fe2-fe1);
      { pour modifier l'chelle des hauteurs dans cette fentre
        de visualisation }
      fixecoul  (c_crbm);
      fixetrait (0);
      ecris_min  (borne_inf);
      ecris_max  (borne_sup);
      fixecoul  (c_crb);
      ecris_minv (min_v);
      ecris_maxv (max_v);
   end;

procedure dessine_z_symb;
   var
      nb, i, k, c       : integer;
      h, a, alt, altm   : real;

   begin                          { travail dans la fentre papier en mm }
      nb  := nb_zones (z_smb);
      alt := borne_inf;
      for i := 1 to nb
      do begin
         alt  := altmini_zone   (z_smb, i, borne_inf);
         altm := altmaxi_zone   (z_smb, i, borne_sup);

         if  altm > alt
         then begin
            c   := couleur_zone (z_smb, alt, borne_inf, borne_sup);
            k   := code_zone    (z_smb, alt, borne_inf, borne_sup);
            h   := taille_zone  (z_smb, alt, borne_inf, borne_sup);
            a   := angle_zone   (z_smb, alt, borne_inf, borne_sup);
            initialiser_parametres_courants (1, h_etiq,   0,    0, 65);
                                    { fonte, taille, dir, incl, rf haut car}
            essai_courbe_etiqs  (alt, c, c, 0);

            voir_un (3, c, k, h, a, fe1+(fe2-fe1)/2, alt+(altm-alt)/2 );
         end;
      end;
   end;

procedure voir_param_symb;
   var
      bi, bs            : real;
      k                 : integer;

   begin
      k   := codaski;    { code unique courant }
      if visuzonesmb
      then
         dessine_z_symb
      else begin
         case typedat of
            1, 4 : voir_un (3, coul_s, k, 3, angl_s,
                               fe1 + (fe2-fe1)*3/4,
                               min_v + (max_v-min_v) /2);
            6 : begin
                   bi := borne_inf;
                   if bi < min_v
                   then
                      bi := min_v;
                   bs := borne_sup;
                   if bs > max_v
                   then
                      bs := max_v;
                   voir_un (3, coul_s, k, h_min, angl_s,
                               fe1 + (fe2-fe1)/2,
                               bi + (max_v-min_v) /10);
                   voir_un (3, coul_s, k, h_max, angl_s,
                               fe1 + (fe2-fe1)/2,
                               bs - (max_v-min_v) /10);
                end;
         end;
      end;
   end;

procedure eff_boite_essai;
   begin
      pleinecloture;
      if ecran
      then begin
         coulbar (1, coulecran);
         bar       (ce1, maxy-ce4, ce2, maxy-ce3);
      end;
   end;

procedure boite_essai_symboles;
   begin
      ecran   := true;
      traceur := false;
      fenetre (fe1, fe2, min_v, max_v);
      cloture (ce1+2, ce2-2, ce3+2,   ce4-2);
      if ecran
      then begin
         coulbar (1, coulboite);
         bar       (0, 0, ce2-ce1-4, ce4-ce3-4);
      end;
      fixetrait (0);
      pleinecloture;
      fixecoul  (c_bord);
      rectangle (ce1, maxy-ce4, ce2, maxy-ce3);
      fenetre   (fe1, fe2, min_v, max_v);
      cloture   (ce1+2, ce2-2, ce3+2,   ce4-2);
      nbc := 4; nbd := 1;
   end;

procedure voir_essai_symboles ;
         { typedat=5; zones}
   begin
      if nomfvs <> ''
      then begin
         boite_essai_symboles;
         voir_param_symb;
         if rang_v > 2
         then
            ecris_params_valeur; { zones}
         fenetre (fc1, fc2, fc3, fc4);
         pleinecloture;
      end;
   end;

procedure essai_lignes;
   begin
      fixetrait (traitgrille);
      fixecoul  (c_grille);
      deplaceen (fe2*4/5, lagrille.minzg );
      tracevers (fe2*4/5, lagrille.maxzg );
      fixetrait (0);
   end;

procedure essai_contours;
   begin
      fixetrait (traitcont);
      fixecoul  (c_carte);
      deplaceen (fe2*3/5, lagrille.minzg );
      tracevers (fe2*3/5, lagrille.maxzg );
      fixetrait (0);
   end;

procedure boite_essai_courbes;
   begin
      ecran   := true;
      traceur := false;
      fenetre (fe1, fe2, lagrille.minzg, lagrille.maxzg);
      cloture (ce1+2, ce2-2, ce3+2, ce4-2);
      { forcer echelle des symboles }
      initialiser_parametres_courants (1, h_etiq,   0,    0, 65);
                                    { fonte, taille, dir, incl, rf haut car}
      if ecran
      then begin
         coulbar (1, coulboite);
         bar          (0, 0, ce2-ce1-4, ce4-ce3-4);
      end;
      fixetrait (0);
      fixecoul (c_bord);
      pleinecloture;
      rectangle (ce1, maxy-ce4, ce2, maxy-ce3);

      fenetre (fe1, fe2, lagrille.minzg, lagrille.maxzg);
      cloture (ce1+2, ce2-2, ce3+2, ce4-2);
      nbc := 6;
      nbd := 0;
   end;

procedure traitcoul_crbz ( alt                  : real ;
                           var coulc,  coulm,
                               couletic         : word {couleur_palette};
                           var traitc, traitm   : integer);
   var
      tr, co            : integer;

   begin
      if visuzones and (z_coul <> nil)
      then begin
         co     := couleur_zone (z_coul, alt, minc, lagrille.maxzg);
         tr     := trait_zone   (z_coul, alt, minc, lagrille.maxzg);

         if co < 0
         then coulc  := c_crb           { en dehors d'une zone }
         else coulc  := co;

         if tr < 0
         then traitc := traitcrb
         else traitc := tr;

         couletic := coulc;
         coulm    := coulc;                   { choix arbitraire }
         traitm   := traitc;
      end else begin
         couletic := c_etiqs;
         coulc    := c_crb;
         coulm    := c_crbm;
         traitc   := traitcrb;
         traitm   := traitcm;
      end;
   end;

function minimum_provisoire_pour_zero : real;
   var
      m                 : real;
      n, i              : integer;

   begin
      n := trunc ((0 -lagrille.minzg) / (equidist*freq)) +1;
      m := 0 -equidist*freq*n;
      minimum_provisoire_pour_zero := m;
   end;

procedure voir_param_courbes ;
   var
      nbz,                   { nombre de zones de couleur   }
      nbcourbes,             { nombre de courbes  dessiner }
      nbc, i,                { n courbe en cours           }
      traitc, traitm         { type des traits              }
                        : integer;

      courbe_maitre          { la courbe courante est une c. matresse }
                        : boolean;

      alt                    { altitude courbe en construction }
                        : real;

      coulc, coulm           { couleurs des courbes }
                        : word;

   procedure essai_courbe_seule (alt   : real;
                                 coul  : word;
                                 trait : integer);
      begin
         fixecoul  (coul);
         fixetrait (trait);
         deplaceen (fe1,    alt);
         tracevers (fe2/2,  alt);
      end;

   procedure voir_essai_courbe (alt                      : real;
                                coulc,  coulm, couletic  : word;
                                traitc, traitm           : integer);
      begin
         if visuzones and (z_coul <> nil)
         then
            courbe_maitre := alt_mini_zone (z_coul, alt, minc, maxc)
         else
            courbe_maitre := nbc mod  (freq) = 0;

         fixetrait (traitc);
         if courbe_maitre
         then begin
            if etiquettes
            then begin
               fixetrait (0);
               essai_courbe_etiqs (alt, coulm, couletic, traitm)
                                                 { courbe maitresse et tiq }
            end else
               essai_courbe_seule (alt, coulm, traitm);  { courbe matresse }
         end else
               essai_courbe_seule (alt, coulc, traitc);     { courbe simple }
      end;

   begin { voir_param_courbes }
                                     { travail dans la fentre papier en mm }

      if maxc > lagrille.maxzg
      then
         maxc := lagrille.maxzg;

      if equidist <= 0
      then
         exit;

      if visuzones
      then begin
         nbz := nb_zones (z_coul);
         nbcourbes := 1 + trunc ((maxc - minc) / equidist);
         nbc       := 0;
         while (nbc < nbcourbes) and (nbz > 0)
         do begin
            alt  := equidist * nbc + minc;
            if    (alt >= altmini_zone (z_coul, 1, minc))
            then begin
               traitcoul_crbz    (alt, coulc, coulm, couletic, traitc, traitm);
               voir_essai_courbe (alt, coulc, coulm, couletic, traitc, traitm);
            end;
            inc (nbc);
         end;
      end else begin
         minc0     := minimum_provisoire_pour_zero;
         nbcourbes := 1 + trunc ((maxc - minc0) / equidist);
         nbc       := 0;
         while nbc < nbcourbes
         do begin
            alt  := equidist * nbc + minc0;
            if    (alt >= minc)
            then begin
               traitcoul_crbz    (alt, coulc, coulm, couletic, traitc, traitm);
               voir_essai_courbe (alt, coulc, coulm, couletic, traitc, traitm);
            end;
            inc (nbc);
         end;
      end;
   end;

procedure voir_essai_courbes
         { (fe1, fe2 : real; ce1, ce2, ce3, ce4 : integer)};
   begin
      boite_essai_courbes;
      voir_param_courbes;
      ecris_params;
      { if visucontours then  essai_contours;  }
      { if visugrille   then  essai_lignes;    }
      fenetre (fc1, fc2, fc3, fc4);
      pleinecloture;
   end;

procedure maj_bouton (z : lst_chn ;  n : integer; minc, maxc : real);
   var
      pyh, pyb  : integer;

   begin
      pyh := ycloture (altmaxi_zone (z, n, maxc));
      pyb := ycloture (altmini_zone (z, n, minc));
      modi_bouton (n_Zone +' '+ nom_element (z, n),
                    100+n, ce1, maxy-ce4+pyh, ce2-ce1, pyb-pyh);
      active_icone (100+n);
   end;

procedure  fini_zones;
   var
      i                 : integer;

   begin
      for i := 1 to nbmaxzones
      do
         inactive_icone (100+i);
   end;

procedure  ini_zones ;
   var
      nbz, i            : integer;

   begin
      if previsu { visucourbes }
      then begin
         nbz    := nb_zones (z_coul);
         fenetre (fe1, fe2, lagrille.minzg, lagrille.maxzg);
         cloture (ce1, ce2, ce3, ce4);
         for i := 1 to nbz
         do
            maj_bouton (z_coul, i, minc, maxc);
         pleinecloture;
      end else begin
         nbz    := nb_zones (z_smb);
         fenetre (fe1, fe2, min_v, max_v);
         cloture (ce1, ce2, ce3, ce4);
         for i := 1 to nbz
         do
            maj_bouton (z_smb, i, borne_inf, borne_sup);
         pleinecloture;
      end;

      if visuzones or visuzonesmb
      then begin
         for i := nbz+1 to nbmaxzones
         do
            modi_bouton (b_aj_zone,
                          100+i, ce1, maxy-ce4, ce2-ce1, 1);
         if nbz < 1
         then begin
            modi_bouton (b_Aj_zone,
                          101,   ce1, maxy-ce4, ce2-ce1, ce4-ce3);
            active_icone (101);
         end;
      end else begin
         modi_bouton (aidico101,
                       101, ce1, maxy-ce4, ce2-ce1, ce4-ce3);
         active_icone (101);
      end;
   end;

procedure edi_min_max;
   begin
      if previsu { visucourbes }
      then begin
         modif_donnee  (100, coulboite, c_crbm,  c_bord, c_crb,
                        fdg,
                        equidist,
                        lagrille.minzg, lagrille.maxzg, minc, maxc);
         voir_essai_courbes;
      end else begin
         if rang_v > 2
         then begin
            modif_donnee  (100, coulboite, c_crbm,  c_bord, coul_s,
                           fdp,
                           pasvs,
                           min_v, max_v,             borne_inf, borne_sup);
            voir_essai_symboles;
         end;
      end;
      aff_min_max; { ajuste les positions des curseurs en fonction du pas }
      ini_zones;
   end;

procedure edi_equi;
   begin
      modif_donnee_1 (111, c_crbm,  c_bord, c_crb,
                      pasequi, pasequi, cminmax,
                      equidist);

      { recadrer min et max en fonction de l'quidistance }
      cal_donnee (equidist, lagrille.minzg ,lagrille.maxzg, minc );
      cal_donnee (equidist, lagrille.minzg ,lagrille.maxzg, maxc );

      aff_min_max;
      voir_essai_courbes;
   end;

procedure dessine_suite;
   { axes, bordure, lignes de rappel et graduation interne complte }
   {                VISULIGNES          LEGEND                      }
   const
      tiret = 4;
      posx  = 1;
      posy  = 1;
      post  = 4;
      extx  = 1;
      exty  = 1;

   var
      ixy   : real;
      nbdec : integer;

   begin
      if gradauto
      then begin
         ixy   := 0;
         nbdec := nbdec_xy;
      end else begin
         ixy   := inter_xy;
         nbdec := nbdec_xy;
      end;
      fixetrait (0);
      fixecoul  (c_bord);
      axes;
      bordure   (c_bord);

      if visugrille
      then begin
         fixecoul       (c_grille);
         fixetrait      (traitgrille);
         dessine_lignes (ixy, ixy);
      end;

      fixetrait (0);
      fixecoul  (c_bord);
      if not visugrad
      then
         gradueplt (ixy, ixy, tiret,
                    0, nbdec, 0, nbdec,
                    unitxy,  unitxy, '' {titre},
                    posx,   posy,  post,
                    extx,   exty )
      else
         gradue    (ixy, ixy);
   end;

procedure ajoute_symboles (trac, eff : boolean);
   { dessiner seulement symboles sans rgnrer toutes les courbes }
   begin
      fenetrecloturecrantrac (trac );
      ChangerCurseur   (Sablier);
      montrersouris;
      voir_symboles    (chemindonnees+nomfvs+extvs, eff) ;
      ChangerCurseur   (fleche);
      cachersouris;
      pleinecrantrac   (trac);
   end;

procedure ajoute_grille (trac, eff : boolean);
   var
      ixy               : real;
      nbdec             : integer;

   begin
      if gradauto
         then ixy   := 0
         else ixy   := inter_xy;
      fenetrecloturecrantrac (trac);
      fixetrait (traitgrille);
      if eff
         then fixecoul (coulboite)
         else fixecoul (c_grille);
      fixetrait      (traitgrille);
      dessine_lignes (ixy, ixy);
      fixetrait (0);
      fenetre (fc1, fc2, fc3, fc4);
      pleinecrantrac  (trac);
   end;

procedure ajoute_contours (trac, eff : boolean);
   { dessiner seulement les contours sans rgnrer toutes les courbes }
   begin
      fenetrecloturecrantrac (trac);
      if eff
      then  begin
         fixecoul  (coulboite);
         fixetrait (0);
      end else begin
         fixecoul  (c_carte);
         fixetrait (traitcont);
      end;
      dess_contour ;

      fixetrait (0);
      pleinecrantrac (trac);
   end;

procedure choix_param_autres (var cc1, cc2, tt1 : byte;
                              var d : real;
                              var n : integer);
   var
      e1,
      touche, poscur    : integer;
      r1                : real;
      co1, co2, t1      : byte;
      b1                : boolean;
      zr1               : PZoneReel;
      ze1               : PZoneEntier;
      zc1, zc2          : Pzonecouleur;
      ZB1               : PZoneBooleen;
      boite             : PBoiteSaisie;

   begin
      co1    := cc1;
      co2    := cc2;
      t1     := tt1;
      r1     := d;
      e1     := n;
      b1     := visugrille; { quadrillage }

      { Bord }
      Zc1    := new (PZoneCouleur,
                init (     0,      0,                             @cc1,
                n_bordcarte, n_couleur, pal));
      Zc1^.Cnom := colorf;

      { Quadrillage }
      ZB1    := new (PZoneBooleen,
                init (     0,     4*ty,        fondmenu, coulboite, @visugrille,
                n_quadrillage, ''));
      ZB1^.Cnom := colorf;

      Zs1    := new (PZoneSymboles,
                init ( 16*tx,     4*ty,      fondmenu, coulboite, @tt1,
                '', n_trait, DessinerTraits, @cc2));
      Zs1^.Cnom  := txtmenu;
      Zs1^.NbSmb := 3;

      Zc2    := new (PZoneCouleur,
                init ( 25*tx,     4*ty,                           @cc2,
                '', n_couleur, pal));

      { intervalle  }
      zr1    := new (PZoneReel,
                init (     0,      0,  2,   0, txtmenu, fondmenu, @d,
                n_intervalle, '5..50 mm'));

      { autres }
      ze1    := new (PZoneEntier,
                init (     0,      0,       1, txtmenu, fondmenu, @n,
                n_niveauliss, '1..3'));

      boite  := new (PBoiteSaisie,
                init (milieu, milieu, 15,      fondnorm, txtnorm,
                t_autrespar));
      { diter le tout }
      poscur := 1;
      boite^.ajoute (zc1);  { ligne 1 }
      boite^.ajoute (zb1);  { ligne 2 }
      boite^.ajoute (zs1);
      boite^.ajoute (zc2);
      boite^.ajoute (zr1);  { l     3 }
      boite^.ajoute (ze1);  { l     4 }
      laide (aidedit);
      boite^.editeF (1, Poscur, Touche);
      laide ('');
      boite^.vider;
      dispose (boite, fini);

      if (touche = ESC) {or (touche = 0)}
      then begin
         cc1        := co1;
         cc2        := co2;
         tt1        := t1;
         d          := r1;
         visugrille := b1;
         n          := e1;
      end;                                 { rtablir les valeurs initiales }
      if n >  3 then n  :=  3;
      if d <  5 then d  :=  5;
      if d > 50 then d  := 50;
  end;

procedure choix_param_courbes_suit (var cc1, cc2, tt1, tt2 : byte);
   var
      touche, poscur,
      r4,  i            : integer;
      co1, co2,
      t1, t2            : byte;
      z2                : PZoneReel;
      zc1, zc2          : Pzonecouleur;
      z4                : Pzoneentier;
      boite             : PBoiteSaisie;

   begin
      co1    := cc1;
      co2    := cc2;
      t1     := tt1;
      t2     := tt2;
      r4     := freq;

      { courbes }
      Zs1    := new (PZoneSymboles,
                init ( 0,     2*ty,    fondmenu, coulboite,      @tt1,
                n_courbes, '', DessinerTraits, @cc1));
      Zs1^.NbSmb := 3;

      Zc1    := new (PZoneCouleur,
                init ( 30*tx, 2*ty,                              @cc1,
                '', '', pal));
      { matresses }
      Zs2    := new (PZoneSymboles,
                init ( 0, 7*ty div 2,  fondmenu, coulboite,      @tt2,
                n_courbesm, '', DessinerTraits2, @cc2));
      Zs2^.NbSmb := 3;

      Zc2    := new (PZoneCouleur,
                init ( 30*tx, 7*ty div 2,                        @cc2,
                '', '', pal));

      z4     := new (PZoneEntier,
                init ( 0,     5*ty, 2,    txtmenu, fondmenu,     @freq,
                n_frequence, '1..10'));

      { dition du tout }
      poscur := 1;
      boite  := new (PBoiteSaisie,
                init (milieu, milieu, 15,     fondnorm, txtnorm,
                t_courbes));

      boite^.ajoute (zs1);
      boite^.ajoute (zc1);
      boite^.ajoute (zs2);
      boite^.ajoute (zc2);
      boite^.ajoute (z4);

      laide (aidedit);
      boite^.editeF (1, Poscur, Touche);
      laide ('');

      boite^.vider;
      dispose (boite, fini);

      if (touche = ESC) {or (touche = 0)}
      then begin
         cc1     := co1;
         cc2     := co2;
         tt1     := t1;
         tt2     := t2;
         freq    := r4;
      end;                                 { rtablir les valeurs initiales }
      if freq <=  0 then freq :=  1;
      if freq >  10 then freq := 10;
   end;

procedure choix_param_etiqs_suit (var cc3 : byte;
                                  var h   : real);
   var
      touche, poscur    : integer;
      r2                : real;
      co3               : byte;
      z2                : PZoneReel;
      zc3               : Pzonecouleur;
      boite             : PBoiteSaisie;

   begin
      co3    := cc3;
      r2     := h;

      { tiquettes }
      z2     := new (PZoneReel,
                init ( 0,     2*ty,  4, 1, txtmenu, fondmenu, @h,
                n_hauteur   , '1..10 mm'));
      Zc3    := new (PZoneCouleur,
                init ( 30*tx, 2*ty,                           @cc3,
                '', '', pal));

      { dition du tout }
      poscur := 1;
      boite  := new (PBoiteSaisie,
                init (milieu, milieu, 15,     fondnorm, txtnorm,
                t_etiqs));

      boite^.ajoute (z2);
      boite^.ajoute (zc3);

      laide (aidedit);
      boite^.editeF (1, Poscur, Touche);
      laide ('');

      boite^.vider;
      dispose (boite, fini);

      if (touche = ESC) {or (touche = 0)}
      then begin
         cc3     := co3;
         h       := r2;
      end;                                 { rtablir les valeurs initiales }
      if h <  0 then h  :=  1;
      if h > 10 then h  := 10;             { contrler limites              }
   end;

procedure choix_param_courbes;
   var
      cc1, cc2, cc3,
      tt1, tt2          : byte;

   begin
      cc1          := byte (c_crb);
      cc2          := byte (c_crbm);
      cc3          := byte (c_etiqs);
      tt1          := byte (traitcrb);
      tt2          := byte (traitcm) ;

      choix_param_courbes_suit (cc1, cc2, tt1, tt2);

      traitcrb     := tt1;
      traitcm      := tt2;
      c_crb        := cc1;
      c_crbm       := cc2;
      c_etiqs      := cc3;
   end;

procedure choix_param_etiqs;
   var
      cc3               : byte;

   begin
      cc3          := byte (c_etiqs);

      choix_param_etiqs_suit (cc3, h_etiq);

      c_etiqs      := cc3;
   end;

(*procedure choix_param_courbes;
   var
      touche, poscur, r4 : integer;
      r1, r2, r3, em     : real;
      z1, z2, z3         : PZoneReel;
      z4                 : Pzoneentier;
      boite              : PBoiteSaisie;

   begin
      em     :=  lagrille.maxzg-lagrille.minzg; { quidistance maximum }
      poscur := 1;
      r1     := minc;
      r2     := maxc;
      r3     := equidist;
      r4     := freq;
      if equidist = 0
      then
         equidist := trunc (em / 5);
      if freq     = 0
      then
         freq     := 4;
      if (minc >= maxc)
      then begin
         minc := lagrille.minzg;
         maxc := lagrille.maxzg;
      end;

      boite := new (PBoiteSaisie,
               init (milieu, milieu, 15,   fondnorm, txtnorm,
               'Niveaux'));
      z1    := new (PZoneReel,
               init (     0,      0, 9, 1, txtmenu, fondmenu, @minc,
               'Minimum      ', unitz));
      boite^.ajoute (z1);
      z2    := new (PZoneReel,
               init (     0,      0, 9, 1, txtmenu, fondmenu, @maxc,
               'Maximum      ', unitz));
      boite^.ajoute (z2);
      z3    := new (PZoneReel,
               init (     0,      0, 9, 1, txtmenu, fondmenu, @equidist,
               'Equidistance ', unitz));
      boite^.ajoute (z3);

      z4    := new (PZoneEntier,
               init (     0,      0, 2,    txtmenu, fondmenu, @freq,
               '1 courbe matresse /', ''));
      boite^.ajoute (z4);

      laide (' TAB change de champ/ESC annule tout/ENTREE valide tout');
      boite^.editeF (1, Poscur, Touche);
      laide ('');

      boite^.vider;
      dispose (boite, fini);

      if (touche = ESC) {or (touche = 0)}
      then begin
         minc     := r1;
         maxc     := r2;
         equidist := r3;                   { rtablir les valeurs initiales }
         freq     := r4;
      end;

      if freq     <=  0 then freq     :=  1;
      if freq     >  10 then freq     := 10;
      if equidist <   2 then equidist :=  2;           { viter la valeur 1 }
      if equidist >  em then equidist := em;
   end;
*)

procedure recalc_ecran;
   begin
      if (coef_x <> 1)
      then begin
         maxc1   := round (maxc1   * coef_x);
         maxc2   := round (maxc2   * coef_x);
         cc1     := round (cc1     * coef_x);
         cc2     := round (cc2     * coef_x);
         ce1     := round (ce1     * coef_x);
         ce2     := round (ce2     * coef_x);
      end;
      if (coef_y <> 1)
      then begin
         maxc3   := round (maxc3   * coef_y);
         maxc4   := round (maxc4   * coef_y);
         cc3     := round (cc3     * coef_y);
         cc4     := round (cc4     * coef_y);
         ce3     := round (ce3     * coef_y);
         ce4     := round (ce4     * coef_y);
      end;
      coef_c := (cc2-cc1) / (cc4-cc3);
   end;

procedure cadrer;
   { SI cc2<= cc1 ou cc4<=cc3 ou hors limites...
     calcule cc2 et cc4 en fonction
         de la position du coin bas-gauche ( cc1, cc3 dans .PAR)
         et de l'extension maxi clture (maxC2, maxC4 dans .CFG)            }
   var
      coeff, coefc      : real;

   begin
      if cc1 < maxc1 then cc1 := maxc1;
      if cc2 > maxc2 then cc2 := maxc2;
      if cc3 < maxc3 then cc3 := maxc3;
      if cc4 > maxc4 then cc4 := maxc4;

      if (cc2 <= cc1) or (cc4 <= cc3)
      then begin
    {     coeff := (cor2  - cor1) / (cor4  - cor3) * (coef_x / coef_y);}
         coeff := (fc2  - fc1) / (fc4  - fc3) * (coef_x / coef_y);

         coefc := (maxc2 - cc1 ) / (maxc4 - cc3);
         if (coeff > coefc)
         then begin
            cc2 := maxc2;
            cc4 := cc3 + round ((maxc2-cc1) / coeff)
         end else begin
            cc4 := maxc4;
            cc2 := cc1 + round ((maxc4-cc3) * coeff)
         end;
      end;
   end;

procedure libere_mem;
   begin
      LaGrille.Liberer;
      liberercontour;
      liberer_jeu_symb (1);
{      liberer_jeu_symb (2);}
      liberer_jeu_symb (3);
      liberericones;
      liberer_zones    (z_coul);
      parini.fini;
      liberer_SMB      (z_smb);
      liberer_commentaires;
      liberer_noms;
      params.fini;
  end;

procedure finir;
   begin
     { restorecrtmode;
      ecrantexte;}
      libere_mem;
   end;

procedure fond_boite ;
   begin
      if ecran
      then begin
         coulbar (1, coulboite );     { ncessaire pour prparer copie}
         bar (0, 0, cc2-cc1, cc4-cc3);
      end;
   end;

procedure effcart;
  begin
      pleinecloture;
      coulbar (SolidFill, coulecran);
      bar (cc1, maxy-cc4, cc2, maxy-maxc3);
   end;

procedure efface_carte;
   begin
      if ecran then effcart
   end;

procedure efftout;
   begin
      ecran := true;
      eff_boite_essai;
      eff_min_max;
      eff_equi;
      { geo_des.effacer_commentaires;}
      effcart;
      if visugrad
      then
         visugrad  := false;

      liberer_commentaires;
      LaGrille.Liberer;
      liberercontour;
      liberer_zones (z_coul);
      liberer_smb (z_smb);
      liberer_noms;
      params.fini;
   end;

procedure ini_coord_etiqs;
   begin
      l_cordetiq := nil;
   end;

procedure lib_coord_etiqs;
   var
      p_ct, p_sui       : surcord;

   begin
      p_sui  := l_cordetiq;
      p_ct   := l_cordetiq;
      while p_ct <> nil
      do begin
         p_sui := p_ct^.suiv;
         dispose   (p_ct);
         p_ct  := p_sui;
      end;
      l_cordetiq := nil;
   end;

procedure dess_etiqs;
   var
      p_ct, p_sui       : surcord;
      alts              : t12;

   begin
      fixetrait (0);
      initialiser_parametres_symbct
          (1,       h_etiq,      1,   0,  0,  65);
      { fonte cte, taille,      dx, dy, incl,  rf haut car }
      { par dfaut : police et taille uniforme et direction horizontale... }
      p_sui  := l_cordetiq;
      p_ct   := l_cordetiq;
      while p_ct <> nil
      do begin
         str (round (p_ct^.a), alts);
         alts  := alts;
         etiquette_crb
            (p_ct^.x, p_ct^.y, h_etiq , p_ct^.f, couletic, alts);
         p_sui := p_ct^.suiv;
         p_ct  := p_sui;
      end;
   end;

procedure construire_courbes (sauver, trac : boolean);
   var
      alts              : t12;
      alt               : real;
      nbcourbes,
      nbc,
      nbz,
      traitc,
      traitm,
      t
                        : integer;
      stop,
      courbe_maitre     : boolean;
      crb               : surcourbe;
      coulc, coulm      : word;

   begin
      montrersouris;

      if maxc > lagrille.maxzg
      then
         maxc := lagrille.maxzg;

      if equidist <= 0
      then
         exit;

      if visuzones
      then begin
         nbz       := nb_zones (z_coul);
         nbcourbes := 1 + trunc ((maxc - minc) / equidist);
      end else begin
         minc0     := minimum_provisoire_pour_zero;
         nbcourbes := 1 + trunc ((maxc - minc0) / equidist);
      end;

      if etiquettes
      then
         ini_coord_etiqs;

      nbc  := 0;
      t    := 0;
      stop := toucheclavier (t);
      stop := (t = ESC) ;
      while (nbc < nbcourbes) and not stop
      do begin
         if visuzones
         then
            alt  := equidist * nbc + minc
         else
            alt  := equidist * nbc + minc0 ;

         if    (not visuzones and (alt >= minc))
            or (visuzones and (nbz > 0) and (alt >= altmini_zone (z_coul, 1, minc)))
         then begin
            if visuzones and (z_coul <> nil)
            then
               courbe_maitre := alt_mini_zone (z_coul, alt, minc, maxc)
            else
               courbe_maitre := nbc mod  (freq) = 0;

            init_courbe    (crb);
            calcule_courbe (ALT, crb);   { m.a.j. courbe courante crb^ }

            if crb^.br <> nil
            then begin            { il y a au moins un double brin }
               if sauver
               then
                  sauver_courbe   (alt, crb, nomfcrb+extcrb, blz);
                                          { true = format BLZ ; false = BLN }
               lisser_courbe      (crb, nbpi );

               traitcoul_crbz     (alt,
                                   coulc,  coulm, couletic,
                                   traitc, traitm);
               cachersouris;

               if uneparune
               then begin
                  bordure   (c_bord);
               end;

               if courbe_maitre
               then begin
                  fixetrait (traitm);
                  fixecoul  (coulm);
                  if etiquettes
                  then
                     rechercher_etiquettes (alt, dmin, crb);

                  dessine_une_courbe   (alt, crb, traceur and etiquettes);
               end else begin
                  fixetrait (traitc);
                  fixecoul  (coulc);
                  dessine_une_courbe (alt, crb, false);
               end;

               if uneparune
               then begin
                  pleinecloture;
                  str (round (alt), alts);
                  laide   (m_suivante + alts+ ' - ' +la_uneparune);
                  ttextxy (10, maxy- 15, alts);

                  entree;
                  fenetrecloturecrantrac (trac);
                  fond_boite;
               end;

               montrersouris;
            end;
            libere_courbe (crb);
         end;
         cachersouris;
         stop := toucheclavier (t);
         stop := (t = ESC);
         inc (nbc);
      end;

      if etiquettes
      then begin
         dess_etiqs;
         if sauver
         then
            sauver_etiquettes (nomfcrb+exteti);
         lib_coord_etiqs;
      end;
   end;

procedure charge_courbes (nomfcrb : dirstr; extcrb, exteti : extstr);
   { recherche la description des courbes dans le fichier existant NOMFCRB
     au format BLN ou BLZ et raffiche avec les autres paramtres courants.}
   var
      f                 : text;
      alt,
      alts              : real;
      t,                               { code touche }
      nbpli,
      nbcourbes,
      nbc,
      inter_cm                         { distance entre courbes matresses }
                        : integer;
      stop,
      finf,
      courbe_maitre     : boolean;
      crb               : surcourbe;

   begin                               { charge courbes }
      if not ftxt_present (nomfcrb+extcrb)
      then
         exit;
      nbc      := 0;
      assign   (f, nomfcrb+extcrb);
      reset    (f);
      inter_cm := round ((freq) * equidist);
      readln   (f, nbpli, alt);
                           { une troisime valeur pourrait constituer ident.}
      finf     := eof (f);

      t        := 0;
      stop     := false;
      while not finf and not stop
      do begin
         init_courbe    (crb);
         charger_courbe (ALT, nbpli, crb, f, blz, alts, finf);
             { m.a.j. ALTs et courbe courante crb^ }
         if not finf
         then begin
            if nbc = 1
            then
               equidist := alts-alt;

            if visuzones and (z_coul <> nil)
            then
               courbe_maitre :=  alt_mini_zone (z_coul, alt, minc, maxc)
            else
               courbe_maitre := round (alt) mod inter_cm = 0;

            if crb^.br <> nil
            then begin
               { il y a au moins un double brin }
               lisser_courbe      (crb, nbpi);
               if courbe_maitre
               then begin
                  fixetrait (traitcm);
                  fixecoul  (c_crbm);
                  dessine_une_courbe (alt, crb, false)
               end else begin
                  fixetrait (traitcrb);
                  fixecoul  (c_crb);
                  dessine_une_courbe (alt, crb, false);
               end;
            end;
         end;
         alt  := alts;
         libere_courbe (crb);
         stop := toucheclavier (t);
         stop := (t = ESC);
         inc (nbc);
      end;
      close (f);

      if ftxt_present (nomfcrb+exteti)
      then begin
         ini_coord_etiqs;
         if ftxt_present (nomfcrb+exteti)
         then
            charger_etiquettes (nomfcrb+exteti);
         dess_etiqs;
         lib_coord_etiqs;
         etiquettes := true;
      end;
   end;

procedure dess_contour_g;
   begin
      dess_contour;
      dessine_suite;
   end;

procedure modi_aff_carte;
   begin
      ecran   := true;
      traceur := false;
      boite_graph_variable (titre,
                  false,                               { fermeture active   }
                  true,                                { cloture variable   }
                  true,                                { asc. vertical      }
                  true,                                { asc. horizontal    }
                  true,                                { bote mobile       }
                  false,                               { rapport x/y fixe   }
                  0.03,                                { rapport zoom       }
                  cor1, cor2, cor3, cor4,              { fentre maxgrille  }
                  maxc1, maxc2, maxc3, maxc4,          { max clture        }
                  fc1,  fc2 , fc3,  fc4,               { fentre cte        }
                  cc1,  cc2,  cc3,  cc4,               { clture cte        }
                  coulboite,                           { couleur du fond    }
                  c_carte,                             { couleur du trait   }
                  dess_contour_g,                      { procedure dessin   }
                  ok);                                 { mmoire suffisante }
      if not ok
      then
         message (m_not_memoire);
   end;

procedure ini_par_ecr;
   begin
      maxc1        := 1;             { extension maxi clture }
      maxc2        := posxbtn-2;
      maxc3        := 2*ty + 4 ;
      maxc4        := maxy - hauteurmenu - 6;


      ce1          := posxbtn;     { cloture essai courbes }
      ce2          := maxx - 3;                { }
      ce3          := maxy - (ty +30 +50+ 5*ty + 5*ty div 2+ 5*3);              { }
      ce4          := maxy - (40+hauteurmenu);

      fe1          := 0;             { fentre essai courbes                }
      fe2          := 200;           {  }
   end;

{procedure ini_zone_1c;
   begin
      if z_coul = nil
      then
         ajoute_z (2, region, '', z_coul, minc, maxc, ok);
   end;
}
procedure IniEcran;
   begin
      cadrer;
      recalc_ecran;                  { recalculer les cltures /coef_y      }
      ini_zone_1 (2, c_crbm, n_courbes,  z_coul, minc,      maxc);
      ini_zone_1 (4, coul_s, n_symboles, z_smb,  borne_inf, borne_sup);
      voir_essai;
      aff_min_max;
      aff_equi;
      inietat ;          { crit infos sur la ligne d'tat }
   end;

procedure inifondecran;
   begin
      ini_par_ecr;
      def_icones_smb;
      ini_format (formatpapier) ;   { initialise format de papier / traceur }
      inicoul_cfg;
      fond_ecran  (coulecran);
      affichemenu;
      dess_icones;
      ini_titre;                { affiche titre rgion }
   end;

procedure grad_exterieur_xy (cetiqx, cetiqy : word { couleur_palette});
   var
      px,   py,                                    { v t }
      dx,   dy,
      DXG,  DYG         : real;  { mm }        { dcalages du cartouche }
      ixy               : real;
      nbdec             : word;

   begin
      ixy   := inter_xy;
      nbdec := nbdec_xy;
      if gradauto
      then begin
         ixy := 0;
         recalculerunitx (ixy, nbdec);
      end;

      prep_graduation_2d (px, py, dx, dy);
                                    { calculer position et dimensions en mm }
      fenetre         (0, trunc (papier_x), 0, trunc (papier_y));
      cloturemilli    (0, trunc (papier_x), 0, trunc (papier_y));
                              { en millimtres position x, y, taille   x, y }

      dxg     := 1;         { initialiser les dcalages : modifier px et py }
      dyg     := 1;

      graduer_xy ( 1,                      { sens                           }
                   px,                     { coin g graphe mm               }
                   py-dyg,                 { coin g                         }
                   dx,                     { largeur cartouche mm           }
                   0,                      { hauteur cartouche (0 si 2d)    }
                   fc1,                    { min fentre graduation         }
                   fc2,                    { max                            }
                   ixy,                    { intervalle entre tiquettes    }
                   htir_xy,                { hauteur tiret mm               }
                   nbti_xy,                { nb tirets intermdiaires       }
                   nbdec,                  { nb dcimales                   }
                   cetiqx,
                   cetiqx,
                   1,
                   hcar_xy,
                   titr1);

      graduer_xy ( -1,                     { sens                           }
                   px-dxg,                 { coin g graphe mm               }
                   py,                     { coin g                         }
                   0.001,                  { largeur cartouche mm           }
                   dy,                     { hauteur cartouche (0 si 2d)    }
                   fc3,                    { min fentre graduation         }
                   fc4,                    { max                            }
                   ixy,                    { intervalle entre tiquettes    }
                   htir_xy,                { hauteur tiret mm               }
                   nbti_xy,                { nb tirets intermdiaires       }
                   nbdec,                  { nb dcimales                   }
                   cetiqy,                 {    }
                   cetiqy,                 { }
                   1,                      { police pour graduations        }
                   hcar_xy,
                   titr2);                 { }
   end;

procedure graduer_exterieur_xy (trac, eff : boolean);
   var
      cetiqx,
      cetiqy            : word;     { var temporaires        }

   begin
      cetiqx := c_axex;
      cetiqy := c_axey;
      if trac
      then begin
         ini_traceur;
         ecran   := false
      end else begin
         if eff
         then begin
            cetiqx  :=  coulecran;
            cetiqy  :=  coulecran;
            fixecoul (coulecran);
         end;
         ecran   := true;
         traceur := false
      end;
      fenetre (fc1, fc2, fc3, fc4);
      pleinecloture;
      cloture (cc1, cc2, cc3, cc4);

      grad_exterieur_xy (cetiqx, cetiqy);

      pleinecrantrac (trac);
      if ecran
      then
         inietat ;
   end;

procedure tracer_commentaires ;
   var
      denom,
      px,   py,
      DXG,  DYG         : real;  { mm }        { dcalages du cartouche }

   begin
      ecran  := false;
      fenetre         (0, trunc (papier_x), 0, trunc (papier_y));
      cloturemilli    (0, trunc (papier_x), 0, trunc (papier_y));
                              { en millimtres position x, y, taille   x, y }
      denom :=   (fc2-fc1) * degkm * 1000000
              / (xutilisateur (cc2)- xutilisateur (cc1))    ;
      denom := trunc (denom /1000) * 1000  ;
      str (denom:0:0, chain);

      fixecoul   ( coul_t );
      initialiser_parametres_courants (1, hcar_xy*2,   0,   15, 65);
                                    { fonte, taille, dir, incl, rf haut car}
      deplaceenl (hcar_xy, papier_y - 2 * hcar_xy);
      ecrire_texte (maj (titre) + '    '+n_ECH+chain);

      initialiser_parametres_courants (1, hcar_xy,   0,   0, 65);
                                    { fonte, taille, dir, incl, rf haut car}
      deplaceenl (hcar_xy, hcar_xy);
      ecrire_texte (nomfpar+ ' -  '+ nomutil+ ' -  '+  datjour );
   end;

procedure dess_symboles;
   begin
       if  not (visuzonesmb and (nb_zones (z_smb) =0))
       then
          voir_symboles  (chemindonnees+nomfvs+extvs, false);
   end;

procedure dess_courbes (trac, sauver : boolean);
   var
      co                : word;

   begin
      fenetrecloturecrantrac (trac);
      fond_boite;
      ChangerCurseur (Sablier);

      if visucourbes
      then
         construire_courbes (sauver, trac);

      fixetrait (traitcont);
      fixecoul  (c_carte);
      if visucontours
      then
         dess_contour;

      if visusymb
      then
         dess_symboles;

      if not uneparune
      then
         dessine_suite;
      uneparune := false;

      ChangerCurseur (fleche);
      fixetrait (0);
      fenetre (fc1, fc2, fc3, fc4);
      pleinecrantrac (trac);
      laide ('');
   end;

(* utile avec options sauvegarde des courbes *)
procedure reconstruire_courbes (trac : boolean);
   begin
      fenetrecloturecrantrac (trac);
      fond_boite;
      charge_courbes (nomfcrb, extcrb, exteti);
      pleinecrantrac (trac);
     {  voir_param_courbes;}
   end;

procedure voir_essai;
   begin
      fini_zones;
      ini_zones;

      if previsu { visucourbes }
      then
         voir_essai_courbes
      else
         voir_essai_symboles;
   end;

procedure ajoute_une_zone_c;
   var
      nbz               : integer;
      ok                : boolean;

   begin
      nbz    := nb_zones (z_coul);
      if nbz < nbmaxzones
      then begin
         ajoute_z (2, n_courbes, unitz, z_coul,
                  lagrille.minzg, lagrille.maxzg, ok) ;
         if ok
         then
            ini_zones;
      end else
         message (m_tropzones);
   end;

procedure ajoute_une_zone_s;
   var
      nbz               : integer;
      ok                : boolean;

   begin
      nbz    := nb_zones (z_smb);
      if nbz < nbmaxzones
      then begin
         ajoute_z (4, n_symboles, unitval, z_smb,
                  min_v, max_v, ok);
         if ok
         then
            ini_zones;
      end else
         message (m_tropzones);
   end;

procedure  edi_zone (num : integer);
   var
      ok, suppr         : boolean;
      nbz               : integer;

   begin
      if previsu { visucourbes }
      then begin
         if visuzones and visucourbes
         then begin
            nbz    := nb_zones (z_coul);
            if nbz > 0
            then begin
               modifie_z  (2, num, n_courbes, unitz, z_coul,
                              lagrille.minzg, lagrille.maxzg, ok, suppr );
               if ok
               then begin
                  if suppr
                  then
                     ini_zones
                  else begin
                     fenetre (fe1, fe2, lagrille.minzg, lagrille.maxzg);
                     cloture (ce1, ce2, ce3, ce4);
                     maj_bouton (z_coul, num, minc, maxc);
                     pleinecloture;
                  end;
               end;
            end else
                ajoute_une_zone_c ;
         end else begin  { courbes uniformes }
            choix_param_courbes;
         end;
      end else begin
         if visuzonesmb and visusymb
         then begin
            nbz    := nb_zones (z_smb);
            if nbz > 0
            then begin
               modifie_z  (4, num, n_symboles, unitval, z_smb,
                              min_v, max_v,        ok, suppr);
               if ok
               then begin
                  if suppr
                  then
                     ini_zones
                  else begin
                     fenetre (fe1, fe2, min_v, max_v);
                     cloture (ce1, ce2, ce3, ce4);
                     maj_bouton (z_smb, num, borne_inf, borne_sup);
                     pleinecloture;
                  end;
               end;
            end else
               ajoute_une_zone_s;
         end else     { symb uniformes }
            choix_symboles (modipar);
      end;
      voir_essai ;
      aff_min_max;
      aff_equi;
      modipar := true;
   end;

procedure redess_carte (trac : boolean);
   begin
      dess_courbes             (trac, false);   { contours et symboles }

      if visutoponym
      then
         dessiner_noms         (trac, true, false);

      if visucomm
      then
         dessiner_commentaires (trac, true, false);

      if visugrad
      then
         graduer_exterieur_xy  (trac, false);
   end;

procedure redess_tout ;
   begin
      if not copie_en_cours
      then begin
         affichemenu;
         dess_icones;
      end;
      ini_titre;
      voir_essai;
      aff_min_max;
      aff_equi;
      inietat ;
      redess_carte (false)
   end;

procedure Effacer_tout_redessiner;
   begin
      copie_en_cours := false;
      fond_ecran  (coulecran);
      redess_tout;
      modicomm := false;
   end;

END.

{--- GEOCEAN - CART_DES ---------------------- R.C.- INRP - TOULOUSE - 1995 }

