'***********************************************************************
'                       Example to interface the
'                  PKWARE Data Compression Library (TM)
'                                 with
'            Microsoft QuickBasic (R) 4.5 and PDS Basic 7.1
'        Copyright 1991-92, By PKWARE Inc.  All Rights Reserved.
'***********************************************************************

DEFINT A-Z

DECLARE Sub Bimplode CDECL (BYVAL CompSize As Integer,_  'Dictionary Size
                            BYVAL CompType As Integer)   'Compression Type

DECLARE Function Bexplode CDECL ()                       'FAR Buffer

DECLARE Sub GetBuf   CDECL (BYVAL p1     As Integer,_    'FAR Buffer
                            BYVAL p2     As Integer,_    'FAR Buffer
                            BYVAL Size   As Integer,_    'Size of Data
                            BYVAL Offset As Integer)     'Buffer Offset

DECLARE Sub SaveBuf  CDECL (BYVAL p1   As Integer,_      'FAR Buffer
                            BYVAL p2   As Integer,_      'FAR Buffer
                            BYVAL Size As Integer)       'Size of Data

DECLARE Function pkgetmem CDECL (BYVAL ii As Long)

DECLARE SUB      pkrelmem CDECL ()

TYPE Buffer                       ' Temporary buffer needed
   PKData as String * 2048        ' 2K in size
END TYPE

DIM SHARED Buffer    As Buffer    ' Allocate Temporary Buffer
DIM SHARED FileSize  As Long      ' For Saving File Size
DIM OrigSize         As Long      ' Uncompressed File Size
DIM SHARED xx        As Integer

CompSize = 4096                   ' 1024, 2048 and 4096 are legal values
CompType = 0                      ' ASCII = 1  or  Binary = 0

PRINT
PRINT "PKWARE (R) Data Compression Library (TM) Demonstration.  Phone (414)354-8699"
PRINT "For Microsoft (R) Basic 4.5 and 7.x Compiler               FAX (414)354-8559"
PRINT "Copyright 1991-92 by PKWARE Inc.  All Rights Reserved."
PRINT

OPEN "TEST.in"  FOR BINARY as #1  ' Open File for input

FileSize = LOF(1)                 ' Get the File Size
OrigSize = FileSize               ' Remember the Uncompressed Size

If FileSize = 0 Then              ' If TEST.IN doesn't exist, print help
   PRINT "Usage  : Bimplode"
   PRINT
   PRINT "IMPLODE compresses a file called TEST.IN into a file called TEST.CMP. The"
   PRINT "file TEST.CMP is then expanded back to it's uncompressed size in TEST.EXT."
   PRINT
   END
Endif

OPEN "TEST.cmp" FOR OUTPUT as #2  ' Open the output file

PRINT "Imploding.  TEST.IN  => TEST.CMP"

' Call the "C" function.  Pass the Work Buffer, the Dictionary Size
' and the Compression Type

xx = pkgetmem(35256)

If xx = 0 Then
   PRINT "Unable to allocate the 35256 bytes required to compress"
   END
Endif

CALL Bimplode (CompSize, CompType)
CALL pkrelmem

CLOSE #1                          ' Close the Input File
CLOSE #2                          ' Close the Output File

' File has been compressed.  Now extract the file

OPEN "TEST.cmp"  FOR BINARY as #1 ' Open the Compressed File
FileSize = LOF(1)                 ' Get the Compressed Files Size

PRINT "Done.  Original File Size";OrigSize;
PRINT "   Compressed Size";FileSize;
PRINT
PRINT "Exploding.  TEST.CMP => TEST.EXT"

OPEN "TEST.ext" FOR OUTPUT as #2  ' Open the Destination File

' Call the "C" function.

xx = pkgetmem(12574)
If xx <> 1 Then
   PRINT "Unable to allocate the 12574 bytes required to extract"
   END
Endif

ExpErr = Bexplode
CALL pkrelmem

If ExpErr <> 0 Then
   PRINT "Error in Compressed File"
Endif
PRINT "Done."

CLOSE #1                          ' Close the Input File
CLOSE #2                          ' Close the Output File

END

' ThisFunction is called from a "C" function.
' The number of bytes to read is passed

FUNCTION ReadBasic (Size as Integer)

   If (Size > FileSize) Then      ' Adjust Size if necessary
      Size = FileSize
   Endif

   If (Size > 2048) Then          ' If the Size requested is larger than
      Size = 2048                 ' the temporary work buffer, adjust the
   Endif                          ' size to match the Buffer size

   FileSize = FileSize - Size     ' Number of bytes remaining in the file
   ReadBasic = Size               ' Set the Return value

   If (Size > 0) Then
      GET #1,,Buffer              ' Read data from the file
   Endif

   ' Call a "C" function that copies the data from Buffer to the Work Buffer
   CALL SaveBuf(VARPTR(Buffer), VARSEG(Buffer), Size)
END FUNCTION

' ThisFunction is called from a "C" function.
' The number of bytes to write is passed

SUB WriteBasic (Size as Integer)
   Offset = 0                     ' Initialize offset into buffer

   ' At this point, we don't know what "Size" is equal to.  The following
   ' code will handle putting 2K chunks of data onto the disk until "Size"
   ' bytes have been written.

   While (Size > 0)               ' Do until Size = 0
      If (Size > 2048) Then       ' If Size > Buffer Size, then adjust
         CSize = 2048
      Else
         CSize = Size             ' Adjusting not necessary
      Endif

      Size = Size - CSize         ' Size = Size - Current piece of data

      ' Call the "C" routine.  Pass the Work Buffer, the size of the data,
      ' and the offset into the buffer.

      CALL GetBuf(VARPTR(Buffer), VARSEG(Buffer), CSize, Offset)

      Offset = Offset + CSize     ' Adjust the Offset

      x = varptr(Buffer.PKData)   ' Write the Data to the disk

			' Using a 3rd party I/O function that can
			' simply dump Csize bytes from the Buffer
			' would be much more efficient.

			' This generic compatible code essentially
			' reads and write one byte at a time from the
			' buffer to the file.
      i = 0
      j = (Csize \ 4)	' Unroll loop 4 times for slightly better speed.
      for k = 1 to j
         print #2,chr$(peek(x+i));chr$(peek(x+i+1));chr$(peek(x+i+2));chr$(peek(x+i+3));
	 i = i + 4
      next k
      for k = 1 to (Csize mod 4)
	print #2,chr$(peek(x+i));
	i = i + 1
      next k
   Wend
END SUB
