/***********************************************************************
*                        Example to interface the
*                  PKWARE Data Compression Library (TM)
*                                 with
*            Microsoft QuickBasic (R) 4.5 and PDS Basic 7.1
*          Copyright 1991, By PKWARE Inc.  All Rights Reserved.
************************************************************************/
#include <stdio.h>
#include <dos.h>
#include <memory.h>
#include <malloc.h>

#include "implode.h"

#define MSC 1

#ifdef MSC
   #pragma intrinsic (memcpy)
#endif

extern int pascal WriteBasic(unsigned short int *);
extern int pascal ReadBasic(unsigned short int *);

unsigned far pascal Read_C(char far *buff, unsigned short int far *size);
void far pascal Write_C(char far *buff, unsigned short far *size);

static char far *BufPtr, far *buffer = NULL;

void Bimplode(int CompSize, int CompType)
{
   implode(Read_C, Write_C, buffer, &CompType, &CompSize);
}

int Bexplode()
{
   return(explode(Read_C, Write_C, buffer));
}

/* Called from implode() or explode(), which then calls back to BASIC */
unsigned far pascal Read_C(char far *buff, unsigned short int far *size)
{
   int i;

   BufPtr = buff;                          /* Save buffer ptr */
   i = *size;
   return(ReadBasic(&i));
}

/* Called from implode() or explode(), which then calls back to BASIC */
void far pascal Write_C(char far *buff, unsigned short far *size)
{
   int i;

   BufPtr = buff;                          /* Save buffer ptr */
   i = *size;
   WriteBasic(&i);
}

#ifndef MSC
void far pascal pk_copy(char far *dest, char far *src, int count)
{
   if (count)
   {
      do
      {
         *dest++ = *src++;
      }
      while (--count);
   }
}
#endif

/* Copy the data from the BASIC Buffer into the PKWARE Buffer */
void SaveBuf(char far *buf, int Size)
{
#ifdef MSC
   memcpy(BufPtr, buf, Size);
#else
   pk_copy(BufPtr, buf, Size);
#endif
}

/* Get the data from the PKWARE Buffer, and put it into the BASIC Buffer */
void GetBuf(char far *buf, int Size, int Offset)
{
#ifdef MSC
   memcpy(buf, BufPtr+Offset, Size);
#else
   pk_copy(buf, BufPtr+Offset, Size);
#endif
}

int pkgetmem(unsigned long lsize)
{

_asm
  { mov bx,word ptr lsize
    add bx,15
    mov cl,4
    shr bx,cl
    mov ah,0x48
    int 0x21
    mov bx,0
    jc no_mem
    mov word ptr buffer+2,ax
    inc bx
no_mem:
    xchg ax,bx
  }
}

void pkrelmem()
{
_asm
  { xor ax,ax
    xchg word ptr [buffer+2],ax
    test ax,ax
    je exit

    mov es,word ptr [buffer+2]
    mov ah,0x49
    int 0x21
exit:
  }
}
