/***********************************************************************
*                        Example to interface the
*                  PKWARE Data Compression Library (TM)
*                                 with
*                      Clipper Summer '87 and 5.0
*          Copyright 1991, By PKWARE Inc.  All Rights Reserved.
************************************************************************/


/*
Make sure you compile LARGE model.
*/

#include "extend.h"
#include "implode.h"

#define IMBUFSIZE 35256U
#define EXBUFSIZE 12574U

extern int pascal r_data( void );
extern int pascal w_data( void );

static unsigned int PK_Size, PK_Dsize, PK_Ctype;
static char far *PK_Buffer;

/* Substitute memcpy() or some other routine for additional speed */
static void near pascal pkcopy(char far *dest,char far *src,int count)
{
   if (count)
   {
      do 
      {
         *dest++ = *src++;
      }
      while (--count);
   }
}

/*  Return the number of bytes to read */
CLIPPER pk_getsize( void )
{
   _retni((unsigned) PK_Size );
}

/*  Return the buffer address and number of bytes to write */
CLIPPER pk_getbuf( void )
{
   _retclen( PK_Buffer, (unsigned) PK_Size );
}

/*  Copy the contents of a Clipper buffer into the PKWARE buffer */
CLIPPER pk_setbuf( void )
{
   if ( PCOUNT > 1 )
      PK_Size = (unsigned) _parni( 2 );
   pkcopy( PK_Buffer, _parc( 1 ), (unsigned) PK_Size );
   _ret();
}

/*  Called by the implode() function. */
void far pascal write_buff( char far *buffer, unsigned short far *size )
{
   PK_Size = (unsigned) *size;                   /* Set global            */
   PK_Buffer = buffer;                           /* Set global            */
   w_data();                                     /* Call Clipper function */
}

unsigned far pascal read_buff( char far *buffer, unsigned short far *size )
{
   PK_Size = (unsigned) *size;                   /* Set global            */
   PK_Buffer = buffer;                           /* Set global            */

   r_data();                                     /* Call Clipper function */
   return(PK_Size);                              /* Return bytes read     */
}

CLIPPER pk_implode( void )
{
   char far *buf;

   PK_Dsize = _parni( 1 );                       /* Set dictionary size  */
   PK_Ctype = _parni( 2 );                       /* Set compression type */

   buf = _exmgrab( (unsigned int) IMBUFSIZE );
   implode( read_buff, write_buff, buf, &PK_Ctype, &PK_Dsize );
   _exmback( buf, (unsigned int) IMBUFSIZE );
   _retl(0);
}

CLIPPER pk_explode( void )
{
   char far *buf;

   buf = _exmgrab( (unsigned int) EXBUFSIZE );   /* Allocate memory */
   explode( read_buff, write_buff, buf );        /* Explode data    */
   _exmback( buf, (unsigned int) EXBUFSIZE );    /* Free memory     */
   _retl(0);
}
