(* -- programme prsent et expliqu dans magazine     *)
(* -- PASCALISSIME numro 34 - Novembre 1989           *)

(* -- disponible  l'INSTITUT PASCAL                   *)
(* -- 26 Rue Lamartine, 75009 PARIS - (16) 42.85.10.82 *)

(* -- (C) Copyright MNEMODYNE 1989                     *)

(*$r+*)

program huffman;
  type t_string_80= string[80];
       t_pt_cellule= ^t_cellule;
       t_cellule= record
                    lettre: char;
                    gauche, droite: t_pt_cellule;
                  end;
       t_code= record
                 code: byte;
                 nombre_bits: integer;
               end;
  var g_choix: char;
      g_frequence: array[#0..#255] of integer;
      g_racine: t_pt_cellule;
      g_code: array[#0..#255] of t_code;
      g_message: t_string_80;
      g_message_code: array[0..255] of integer;
  type t_string_2= string[2];
       t_string_4= string[4];

  function f_octet_hexadecimal(p_octet: byte): t_string_2;
    const kt_hex: array[0..15] of char= '0123456789ABCDEF';
    begin
      f_octet_hexadecimal:= kt_hex[p_octet div 16]+ kt_hex[p_octet mod 16];
    end; 

  function f_entier_hexadecimal(p_entier: integer): t_string_4;
    begin
      f_entier_hexadecimal:= f_octet_hexadecimal(hi(p_entier))
                             + f_octet_hexadecimal(lo(p_entier));
    end; 

  procedure entre_message;
    begin
      write('message <PASCALISSIME> ? '); readln(g_message);
    end; 

  procedure calcule_frequence;
    var l_indice: integer;
    begin
      fillchar(g_frequence, sizeof(g_frequence), 0);
      for l_indice:= 1 to length(g_message) do
        g_frequence[g_message[l_indice]]:=
          g_frequence[g_message[l_indice]]+ 1;
    end; 

  procedure affiche_frequences;
    var l_lettre: char;
    begin
      for l_lettre:= #0 to #255 do
        if g_frequence[l_lettre]<> 0
          then write(l_lettre, ':', g_frequence[l_lettre], ' ');
      writeln;
    end; 

  procedure construis_arbre_du_code;
    type t_table= record
                    frequence: integer;
                    pointeur: t_pt_cellule;
                  end;
    var l_indice: integer;
        l_nombre_lettres: integer;
        l_table: array[0..255] of t_table;
        l_indice_plus_petite, l_indice_seconde_plus_petite: integer;

    procedure initialise_table_de_construction;
      var l_lettre: char;
      begin
        fillchar(l_table, sizeof(l_table), 0);
        l_nombre_lettres:= 0;
        for l_lettre:= #0 to #255 do
           if g_frequence[l_lettre]<> 0
            then begin
                with l_table[l_nombre_lettres] do
                begin
                  frequence:= g_frequence[l_lettre];
                  new(pointeur);
                  with pointeur^ do
                  begin
                    lettre:= l_lettre;
                    gauche:= nil; droite:= nil;
                  end;
                end;
                l_nombre_lettres:= l_nombre_lettres+ 1;
              end;
      end; 

    procedure affiche_table_de_construction;
      var l_indice: integer;
          l_ligne: integer;

      procedure liste_arbre(p_pointeur: t_pt_cellule);
        begin
          if p_pointeur<> nil
            then begin
                write('(');
                liste_arbre(p_pointeur^.gauche);
                if (p_pointeur^.gauche= nil) and (p_pointeur^.droite= nil)
                  then write(p_pointeur^.lettre, ' ')
                  else write('.');
                liste_arbre(p_pointeur^.droite);
                write(')');
              end;
        end; 

      begin 
        for l_indice:= 0 to l_nombre_lettres- 1 do
          with l_table[l_indice] do
          begin
            write(l_indice: 2, ' ', frequence: 2, ': ');
            liste_arbre(pointeur);
            writeln;
          end;
      end; 

    procedure cherche_deux_plus_petites_frequences;
      var l_indice: integer;
      begin
        if l_table[0].frequence< l_table[1].frequence
          then begin
              l_indice_plus_petite:= 0;
              l_indice_seconde_plus_petite:= 1;
            end
          else begin
              l_indice_plus_petite:= 1;
              l_indice_seconde_plus_petite:= 0;
            end;
        for l_indice:= 2 to l_nombre_lettres- 1 do
        begin
          if l_table[l_indice].frequence< l_table[l_indice_plus_petite].frequence
            then begin
                l_indice_seconde_plus_petite:= l_indice_plus_petite;
                l_indice_plus_petite:= l_indice;
              end
            else
              if l_table[l_indice].frequence< l_table[l_indice_seconde_plus_petite].frequence
                then l_indice_seconde_plus_petite:= l_indice;
        end;
        writeln(' frqu1: ', l_table[l_indice_plus_petite].frequence, 
                 ', frq2: ', l_table[l_indice_seconde_plus_petite].frequence);
      end; 

    procedure cree_arbre_des_deux_petites;
      var l_pointeur: t_pt_cellule;
      begin
        with l_table[l_indice_plus_petite] do
        begin
          frequence:= frequence+ l_table[l_indice_seconde_plus_petite].frequence;
          new(l_pointeur);
          with l_pointeur^ do
          begin
            gauche:= pointeur;
            droite:= l_table[l_indice_seconde_plus_petite].pointeur;
          end;
          pointeur:= l_pointeur;
          if l_indice_seconde_plus_petite< l_nombre_lettres- 1
            then l_table[l_indice_seconde_plus_petite]:= l_table[l_nombre_lettres- 1];
          l_nombre_lettres:= l_nombre_lettres- 1;
        end;
        affiche_table_de_construction;
      end; 

    begin 
      initialise_table_de_construction;
      while l_nombre_lettres> 1 do
      begin
        cherche_deux_plus_petites_frequences;
        cree_arbre_des_deux_petites;
      end;
      g_racine:= l_table[0].pointeur;
    end; 

  procedure liste_arbre(p_pointeur: t_pt_cellule);
    begin
      if p_pointeur<> nil
        then begin
            write('(');
            liste_arbre(p_pointeur^.gauche);
            if (p_pointeur^.gauche= nil) and (p_pointeur^.droite= nil)
              then write(p_pointeur^.lettre, ' ')
              else write('.');
            liste_arbre(p_pointeur^.droite);
            write(')');
          end;
    end; 

  procedure affiche_arbre_de_decodage(p_pointeur: t_pt_cellule; p_code: t_string_80);
    begin
      if p_pointeur<> nil
        then begin
            affiche_arbre_de_decodage(p_pointeur^.gauche, p_code+ '0');
            if (p_pointeur^.gauche= nil) and (p_pointeur^.droite= nil)
              then writeln(p_pointeur^.lettre, ' ', p_code);
            affiche_arbre_de_decodage(p_pointeur^.droite, p_code+ '1');
          end;
    end; 

  procedure construis_la_table_de_codage;

    procedure construis(p_pointeur: t_pt_cellule; p_nombre_bits, p_code: byte);
      begin
        if p_pointeur<> nil
          then begin
              construis(p_pointeur^.gauche, p_nombre_bits+ 1, p_code shl 1);
              if (p_pointeur^.gauche= nil) and (p_pointeur^.droite= nil)
                then
                  with g_code[p_pointeur^.lettre] do
                  begin
                    nombre_bits:= p_nombre_bits;
                    code:= p_code;
                  end;
              construis(p_pointeur^.droite, p_nombre_bits+ 1, p_code shl 1+ 1);
           end;
      end; 

    begin 
      fillchar(g_code, sizeof(g_code), 0);
      construis(g_racine, 0, 0);
    end; 

  procedure affiche_code;
    var l_lettre: char;
    begin
      for l_lettre:= #0 to #255 do
        with g_code[l_lettre] do
          if nombre_bits<> 0
            then write(l_lettre, ':', nombre_bits, '= ', code, ' ');
      writeln;
    end; 

  procedure code_message;
    var l_indice_message: integer;
        l_indice_sortie, l_bit_sortie, l_entier: integer;
        l_masque: array[0..15] of integer;
        l_bits_disponibles: integer;
        l_bits_en_surplus: integer;

    procedure initialise_masques;
      var l_bit: integer;
      begin
        fillchar(l_masque, sizeof(l_masque), 0);
        for l_bit:= 1 to 15 do
        begin
          l_masque[l_bit]:= l_masque[l_bit- 1] shl 1+ 1;
        end;
      end; 

    procedure affiche_code_emis(p_nombre_bits, p_code: byte);
      var l_bit: integer;
      begin
        write(p_code, ' ');
      end; 

    begin 
      initialise_masques;
      l_indice_sortie:= 2; l_bit_sortie:= 0; l_entier:= 0;
      for l_indice_message:= 1 to length(g_message) do
        with g_code[g_message[l_indice_message]] do
        begin
          affiche_code_emis(nombre_bits, code);
          if l_bit_sortie+ nombre_bits<= 16
            then begin
                l_entier:= l_entier shl nombre_bits+ code;
                l_bit_sortie:= l_bit_sortie+ nombre_bits;
                if l_bit_sortie= 16
                  then begin
                      g_message_code[l_indice_sortie]:= l_entier;
                      l_indice_sortie:= l_indice_sortie+ 1;
                      l_bit_sortie:= 0; l_entier:= 0;
                    end;
              end
            else begin
                l_bits_en_surplus:= (l_bit_sortie+ nombre_bits)- 16;
                l_entier:= (l_entier shl (nombre_bits- l_bits_en_surplus))
                    + (code shr l_bits_en_surplus);
                g_message_code[l_indice_sortie]:= l_entier;
                l_indice_sortie:= l_indice_sortie+ 1;
                l_entier:= 0;
                l_entier:= code and l_masque[l_bits_en_surplus];
                l_bit_sortie:= l_bits_en_surplus;
              end;
        end; 
      if l_bit_sortie<> 0
        then begin
            l_entier:= l_entier shl (16- l_bit_sortie);
            g_message_code[l_indice_sortie]:= l_entier;
          end
        else begin
            l_indice_sortie:= l_indice_sortie- 1;
            l_bit_sortie:= 16;
          end;
      g_message_code[0]:= l_indice_sortie;
      g_message_code[1]:= l_bit_sortie;
      writeln;
    end; 

  procedure affiche_message_code;
    var l_indice: integer;
        l_entier: integer;
        l_masque: array[0..15] of integer;

    procedure initialise_masques;
      var l_bit: integer;
      begin
        fillchar(l_masque, sizeof(l_masque), 0);
        l_masque[0]:= 1;
        for l_bit:= 1 to 15 do
        begin
          l_masque[l_bit]:= l_masque[l_bit- 1] shl 1;
        end;
      end; 

    procedure affiche_les_bits(p_entier: integer);
      var l_bit: integer;
      begin
        for l_bit:= 15 downto 0 do
          if (p_entier and l_masque[l_bit])<> 0
            then write('1')
            else write('0');
      end; 

    begin 
      initialise_masques;
      for l_indice:= 2 to g_message_code[0] do
        write('$', f_entier_hexadecimal(g_message_code[l_indice]), ' ');
      writeln;
      for l_indice:= 2 to g_message_code[0] do
      begin
        l_entier:= g_message_code[l_indice];
        affiche_les_bits(l_entier); write('-');
      end;
      writeln;
    end; 

  procedure decode_message;
    var l_indice_code, l_bit_code: integer;
        l_entier: integer;
        l_masque: array[0..15] of integer;
        l_pointeur: t_pt_cellule;

    procedure initialise_masques;
      var l_bit: integer;
      begin
        fillchar(l_masque, sizeof(l_masque), 0);
        l_masque[0]:= 1;
        for l_bit:= 1 to 15 do
        begin
          l_masque[l_bit]:= l_masque[l_bit- 1] shl 1;
        end;
      end; 

    procedure affiche_les_bits(p_entier: integer);
      var l_bit: integer;
      begin
        for l_bit:= 15 downto 0 do
          if (p_entier and l_masque[l_bit])<> 0
            then write('1')
            else write('0');
      end; 

    function f_lis_bit: integer;
      var l_bit: integer;
      begin
        if l_bit_code= 0
          then begin
              l_entier:= g_message_code[l_indice_code];
              l_indice_code:= l_indice_code+ 1;
              l_bit_code:= 16;
            end;
        l_bit_code:= l_bit_code- 1;
        if l_entier and l_masque[l_bit_code]= 0
          then l_bit:= 0
          else l_bit:= 1;
        f_lis_bit:= l_bit;
        write(l_bit);
      end; 

    begin 
      initialise_masques;
      l_indice_code:= 2;
      l_bit_code:= 0;
      repeat
        l_pointeur:= g_racine;
        while (l_pointeur^.gauche<> nil) and (l_pointeur^.droite<> nil) do
          if f_lis_bit= 0
            then l_pointeur:= l_pointeur^.gauche
            else l_pointeur:= l_pointeur^.droite;
        write(' = ', l_pointeur^.lettre, ' ');
      until (l_indice_code> g_message_code[0]) and (16- l_bit_code>= g_message_code[1]);
      writeln;
    end; 

  procedure initialise;
    begin
      g_racine:= nil;
      g_message:= 'PASCALISSIME';
      g_message_code[0]:= 0;
    end; 

  begin 
    initialise;
    repeat
      writeln;
      writeln(g_message);
      writeln('Entre, Frquences, Affiche frquences, Code, Liste code, ');
      writeln('construis Table, affiche table cOde');
      write('code Message, affIche message cod, Dcode message, Quitte ? ');
      read(kbd, g_choix); writeln(g_choix);
      case g_choix of
        'a' : affiche_frequences;
        'c' : construis_arbre_du_code;
        'd' : decode_message;
        'e' : entre_message;
        'f' : calcule_frequence;
        'i' : affiche_message_code;
        'l' : liste_arbre(g_racine);
        'm' : code_message;
        'o' : affiche_code;
        't' : begin
                affiche_arbre_de_decodage(g_racine, '');
                construis_la_table_de_codage;
              end;
      end;
    until g_choix= 'q';
  end. 
