{***********************************************************************
                        Example to interface the
                   PKWARE Data Compression Library (TM)
                                  with
                              Turbo Pascal
           Copyright 1990-91, By PKWARE Inc.  All Rights Reserved.
 ***********************************************************************
}


program Compress;
{
   Demonstration program that shows how to use the
   PKWARE Data Compression Library

   This program takes a file called TEST.IN and compresses the file to
   a new file called TEST.CMP.  It then takes the TEST.CMP file and expands
   it back to it's original size, but to a file called TEST.EXT.

   Please Note: Very little error checking is done.
}

{$I-,S+}
{$M 8192,0,655360}
{$L IMPLODE.OBJ}

uses dos;

const
  CMP_BINARY = 0;
  CMP_ASCII  = 1;

type
  BuffType = packed array [1..35256] of char;
  IntFunc = function(var Buff:BuffType; var bSize:Word): Word;

var
  DictionarySize:  Word;
  CompressionType: Word;
  FromFile:        File;
  ToFile:          File;
  Buffer:          Bufftype;
  Result:          Integer;
  Exploding:       Integer;
  OrigFile:        SearchRec;

function Implode(Read:IntFunc;
                 Write:IntFunc;
                 var Buf:BuffType;
                 var Ctype:Word;
                 var bSize:Word): Integer; far; external;

function Explode(Read:IntFunc;
                 Write:IntFunc;
                 var Buf:BuffType): Integer; far; external;


function ReadData(var Buffer : BuffType; var BufferSize : Word): Word; far;
var BytesRead:Word;
begin
   BlockRead(FromFile, Buffer, BufferSize, BytesRead);
   ReadData := BytesRead;
end;


function WriteData(var Buffer : BuffType; var BytesRead : Word): Word; far;
var byteswritten:Word;
begin
  BlockWrite(ToFile, Buffer, BytesRead, BytesWritten);
  WriteData := BytesWritten;
end;


begin
  writeln;
  writeln('PKWARE Data Compression Libraries Example');
  writeln;

  Assign(FromFile,'TEST.IN');     { Open input file        }
  Reset(FromFile,1);
  Assign(ToFile,'TEST.CMP');      { Create output file     }
  Rewrite(ToFile,1);

  writeln('Imploding file   TEST.IN  => TEST.CMP');

  DictionarySize  := 4096;
  CompressionType := CMP_BINARY;

  result:=implode(ReadData, WriteData, Buffer,CompressionType,DictionarySize);

  Close(FromFile);
  Close(ToFile);

  Assign(FromFile,'TEST.CMP');    { Open input file        }
  Reset(FromFile,1);
  Assign(ToFile,'TEST.EXT');      { Create output file     }
  Rewrite(ToFile,1);

  writeln('Exploding file   TEST.CMP => TEST.EXT');
  result := explode(ReadData, WriteData, Buffer);

  Close(FromFile);
  Close(ToFile);

  writeln('Done!');

  if (result <> 0) then
    writeln('Error in compressed data!');
end.
