UNIT GEO_DES;

{---------------------------------------------------------------------------}
{         GEOCEAN                                                           }
{                          Procdures communes                              }
{                                                               30/01/93    }
{---------------------------------------------------------------------------}

(*
   GEO_DES,                  { GEO     - procdures graph. communes         }
*)

INTERFACE

{$O+,F+}

USES
   crt,
   dos,
   graph,
   printer,                  { TP 70   - units standard  Borland           }

   Souris,                   { ARX     - gestion de la souris               }
   Clavier,                  { ARX     - gestion du clavier                 }
   Graphism,                 { ARX     - initialisations graphiques         }
   Messarx,                  { ARX     - Textes des Messages de Base        }

   Graphplt,                 { ARX     - graphisme 2D cran/traceur         }
   Edition,                  { ARX     - saisie/dition paramtres          }
   Utildivs,                 { ARX     - utilitaires divers                 }
   UtilEdi,
   GraphSg,                  { ARX     - symboles et graduations            }
   Icones,                   { ARX     - gestion de icnes                  }
   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   Lipar,                    { ARX     - gestion fichiers paramtres        }

   Periphs,                  { ARX     - Gestion des priphriques          }
   GraphUti,                 { ARX     - utilitaires graphiques             }
   DirInfo,                  { ARX     - Gestion des fichiers ressources    }
   Comment,                  { ARX     - gestion des textes/page            }
   Menus,                    { ARX     - interface menus                    }
   Symboles,                 { ARX     - interface symboles et zones        }

   GRILLES,                  { ARX     - lecture des grilles                }

   GEO_var,                  { GEO     - variables globales communes        }
   MathBase,                 { Ducamp-Reverchon  - Traiement de fonctions mathmatiques}
   Fonction;                 { Ducamp-Reverchon  - Traitement de fonctions formelles}

{--- GEO_DES ---------------------------------------------------------------}

CONST
  {$I Sablier.cur}
                   (*  {$I Main.cur} *)
  {$I Texte.cur}


Procedure help_txt_enligne      (ch                 : string);
   { affiche comment dmarrer sur commande =   MODU /?|?|help               }

Procedure calculer_degkm        (xm, ym             : real);
   { calcule le coefficient de correction degkm_r au point xm ym ()        }

(*Function question_travail                                     : string;
   { inutilis }                                                        *)

Procedure lire_utilisateur      (ch                 : pathstr);
   { lit le fichier UTILISAT.EUR et affecte nomutil+groupe, region          }

Procedure aff_mem ;
   { affiche la mmoire disponible                                          }

Procedure inietat ;
   { initialise la ligne d'tat                                             }

Procedure icone_etat;
   { dessine les icnes de la ligne d'tat                                  }

Procedure choix_action          (var choi           : integer);
   { Rend 1 ou 2                                                            }

Procedure textemenufichierprof;
   { Dfinit les entres communes du MENU  prof                             }

Procedure textemenufichier;
   { Dfinit les entres communes du MENU  lve                            }

Procedure lire_config;
   { charge fichier de configuration du logiciel   . CFG                    }

Procedure ecrire_config;
   { sauve  fichier de configuration du logiciel   . CFG                    }

Procedure voir_penv;
   { affiche la liste des paramtres de configuration                       }

Procedure voir_psymb;
   { affiche la liste des paramtres des symboles                           }

Procedure liberer_smb           (var z_smb          : lst_chn);
   { libre pointeurs sur les zones de symboles et la liste de paramtres   }

Procedure inisymboles;
   { initialise un jeu de symboles                                          }

Procedure ini_par_cfg           (nomf               : pathstr);
   { initialisation des paramtres d'environnement                          }

Procedure inicoul_cfg;
   { initialise les variables couleur de base  et interdit qq couleurs      }

Procedure libcoul_cfg;
   { Toutes couleurs autorises momentanment pour Palette en mode prof     }

Procedure geo_PALETTES (nompal : namestr);
   { Appelle Palettes en librant toute a palette                           }

Procedure fond_commentaires     (m1, m2, m3, m4     : word);
   { Repeint la zone dans la couleur du fond                                }

Procedure fond_ecran            (co                 : word);
   { Initialise tout l'cran..                                              }

Procedure ini_titre;
   { Affiche le titre REGION dans l'icne 4 }

Procedure choix_reel            (t                  : chainecar ;
                                 min, max           : real;
                                 var r              : real);
   { Rend un rel contraint par min et max                                  }

Procedure choix_axes            (var htir, hcar,
                                 nbti, nbdec        : integer;
                                 var inter_e        : real);
   { dfinit les paramtres d'affichage des axes x, y et z                  }

Procedure choix_3couleurs_trait (comm               : chainecar;
                                 var cc1, cc2, cc3, tt1 : byte);
Procedure choix_couleur_trait   (comm               : Chainecar;
                                 var cc1, tt1       : byte);
   { saisie CC1 : couleur  et tt1 : type de trait                           }

Procedure modif_menu_cfg;
   { initialise menu 5  SORTIES  et couleurs                                }

Procedure lire_contour          (nomf               : Pathstr);
   { Libre contour prcdent et initialise nouveau depuis le disque        }

Procedure dess_fond             (nomf               : Pathstr;
                                 coc, coe           : word;
                                 t                  : real);
   { Dessine un fond de carte depuis le disque dans la cloture/fenetre cte  }

Procedure chang_contour;
   { Recherche un autre fichier CONTOURS : liste INFO                       }

Procedure chang_fondcarte       (comm               : Chainecar ;
                                 var nomf           : Pathstr);
   { Recherche un autre fond des carte   : liste INFO                       }

Procedure retailler;
   { Redfinit la fentre en de des coordonnes maxi de la grille         }

Procedure lire_grille           (var Grille         : TGrille;
                                 nomfg              : Pathstr;
                                 Traitement : Boolean);
   { Libre grille prcdente et initialise nouvelle depuis le disque       }

Procedure chang_grille          (com1, comm, com2   : chainecar;
                                 filtrenom          : namestr;
                                 var Grille         : TGrille;
                                 var nomfg          : namestr;
                                 traitement         : boolean);
   { Recherche une autre GRILLE : liste INFOD                               }

Procedure impr_params           (t                  : Chainecar;
                                 l                  : lipar.liste);
   { imprime une liste complte de paramtres avec la date et le texte T    }

Function zonetat                (x, y               : integer)  : boolean;
   { rend VRAI si x et y dans la pemire ligne d'tat                       }

{Procedure chang_palette (var nomfp : string);}
   { Recherche une autre palette dans le rpertoire repbgi/CFG }

Procedure chang_nom_trav_donnees (comm      : chainecar;
                                  var local : boolean;
                                  var nomf  : namestr;
                                  ext       : extstr);
   { change de fichier existant choisi d'abord en local puis REGION         }

Procedure change_points ;
   { change le fichier symboles courant                                     }

Procedure fenetrecloturemilli;
   { Initialise le repre page                                              }

Procedure fenetrecloturecrantrac (trac              : boolean);
   { Initialise la fentre/clture courante                                 }

Procedure ecrantrac             (trac               : boolean);
   { Initialise vt le traceur et les boolens TRACEUR et ECRAN             }

Procedure pleinecrantrac        (trac               : boolean);
   { Rtablit le pleine clture                                             }

Procedure aide_geoc;
   { Affiche le texte (.txt) li au logiciel                                }

Procedure aide_region;
   { Affiche le texte (.txt) li  la rgion                                }

Procedure aide_module;
   { Affiche le texte (.txt) li au module                                  }

Procedure aide                  (x, y               : integer);
   { affiche le texte d'aide correspondant.                                 }

Procedure A_PROPOS;
   { affiche nom programme, date, version et noms des auteurs               }

Procedure VERSION_LOGICIEL;
   { affiche la version du logiciel                                         }

Procedure fond_noir             (num_cf             : word);
   { Bascule fond cran traits Couleur --> noir (ou blanc )                 }

Procedure fond_couleur          (num_cf             : word);
   { Bascule fond cran traits Noir --> couleur                             }

Procedure aff_l_aide;
   { Affiche la ligne d'aide standard   F1....  }

{*  ----- COMMENTAIRES -------- textes lis  l'utilisateur -------------- *}
{                               repre papier                               }

Procedure ini_par_comm          (nomf               : pathstr);
   { initialisation des commentaires                                        }

Procedure Ecrit_par_comm        (nomf               : pathstr);
   { des commentaires                                                       }

Procedure chang_comm            (var nomf           : namestr);
   { Recherche un autre fichier COMMENTAIRES : liste INFO                   }

Procedure Saisir_commentaire    (var s              : t30;
                                 var cc1            : word;
                                 var suppr,
                                     rappel         : boolean;
                                 lier               : boolean );
   { Saisie paramtres des commentaires }

Procedure Editer_Commentaires   (x, y               : integer;
                                 dblclc             : boolean);
   { Edite l'objet texte qui a t dsign                                  }

Procedure Dessiner_Commentaires (trac,
                                 cadre,
                                 fond               : boolean);
   { Affiche les commentaires dans le repre
     PAPIER= ECRAN limit   la zone hors ICONES
     trac : traceur / cadre : calcul du cadre / fond : remplissage          }

Procedure liberer_commentaires;
   { libre la collection                                                   }

Procedure Effacer_Commentaires;
   { Efface l'cran et raffiche tout                                       }

Procedure Ajouter_commentaires  (lie : boolean);
   { ajoute une ligne de texte                                              }


{ ---- TOPONYMIE -------- textes lis  la rgion ------------------------- }
{                         repre CARTE                                      }
Procedure chang_noms ;
   { Recherche une autre description des lieux                              }

Procedure choix_toponymie       (var change         : boolean);
   { Saisie des paramtres HAUT_t, COUL_t                                   }

Procedure Ini_par_Noms;
   { Initialise la liste                                                    }

Procedure prepare_label         (xp, yp             : real;
                                 var mx, my         : real;
                                 es                 : t12);
   { calcule les dcalages dans la fentre cte, en fonction des var globales
     align_t, xrap, yrap  (angl_t  inutile) }

Procedure Append_Noms           (nomf               : pathstr);
   { Lit le fichier  x, y, texte dans le rpertoire de donnes              }

Procedure Dessiner_Noms         (trac,
                                 cadre,
                                 fond               : boolean);
   { Dessine tous les noms de la liste                                      }

Procedure Effacer_Noms;
   { Efface dans la couleur du fond                                         }

Procedure Liberer_noms;
   { Libre la liste                                                        }

Procedure Editer_Noms           (x, y                : integer;
                                 dblclc              : boolean);
   { Modifie les attributs et les coordonnes/carte                         }

Procedure ecrit_toponymie       (nomf                : pathstr);
   { Enregistrement de la toponymie sur fichier/donnes                     }

Procedure Ecrit_par_noms        (nomf                : pathstr);
   { Enregistrement de la toponymie sur fichier/travail                     }

Procedure Ajouter_noms ;
   { Allonge la liste                                                       }

Procedure recalculer_toponymie_2d;
   { Adapte les coordonnes papier  la nouvelle clture                    }

Procedure voir_catalogue;
   { cf periphs }

Procedure config_periph;
   { cf periphs }

{---------------------------------------------------------------------------}

IMPLEMENTATION

procedure help_txt_enligne (ch : string);
   begin
      if (ch = '/?') or (maj (ch) = 'HELP') or (ch = '?')
      then begin
         writeln (nomlogiciel+' '+ nomdumodule);
         writeln ('');
         writeln (mt_help1+' '+nomlogiciel);
         writeln (mt_help2);
         writeln (mt_help3);
         writeln ('');
         writeln (mt_help4);
         halt;
      end;
   end;

procedure aff_l_aide;
   begin
      laide (la_f1);
   end;

procedure VERSION_LOGICIEL;
   begin
      message (rc);
   end;

procedure lire_utilisateur (ch : pathstr); { nomutil+groupe, region }
   var
      f                 : text;
      d                 : dirstr;
      n                 : namestr;
      e                 : extstr;

   begin
      if exists (reptemp+'\'+fic_etat_util)
      then begin
         cheminexemples := '';
         assign (f, reptemp+'\'+fic_etat_util);
         reset  (f);
         readln (f, nomutil);
         readln (f, chain);
            nomutil := chain+' '+nomutil;
            nomutil := copy (nomutil, 1, 12);
            nomutil := maj  (nomutil);

         readln (f, region);
         readln (f, chain);              { nom du module }
         readln (f, chemindonnees);
            complete (chemindonnees);

         readln (f, cheminmodule);
            complete (cheminmodule);

         if not eof (f)
         then begin
            readln (f, cheminexemples);
            complete (cheminexemples);
         end;
         close (f);
      end else begin
         writeln (mt_chemin_donnees);
         readln  (chemindonnees);
         enleve_antislash (chemindonnees);
         fsplit  (chemindonnees, d, n, e);
         chemindonnees := d;
         region        := n;

         fsplit  (ch, d, n, e);
         cheminmodule := d;
         writeln (mt_chemin_progr+ cheminmodule);
      end;
   end;

procedure aff_mem ;
   begin
      if copie_en_cours
      then
         Iconetxt (Datjour,                    116, txtnorm, fondmenu, fondnorm)
      else
         Iconetxt (Memdisponible+' '+n_octets, 116, txtnorm, fondmenu, fondnorm);
        {  Iconetxt (texte                     i    cotxt    coext     coint    }
   end;

procedure inietat;
   begin
      Iconetxt (nomutil, 112, txtnorm, fondmenu, fondnorm);
      Iconetxt (nomfpar, 113, txtnorm, fondmenu, fondnorm);
      if nomdumodule = nom_nuag
      then
         Iconetxt (nomfvs, 114, txtnorm, fondmenu, fondnorm)
      else
         Iconetxt (nomfd,  114, txtnorm, fondmenu, fondnorm);

      if nomdumodule = nom_cart
      then
         Iconetxt (nomfvs, 115, txtnorm, fondmenu, fondnorm)
      else
         if nomdumodule = nom_coup
         then
            Iconetxt (nomfd2, 115, txtnorm, fondmenu, fondnorm)
         else
            if nomdumodule = nom_grav
            then begin
               if airlibre
               then
                  chain := n_airlibre
               else
                  chain := n_bouguer;
               Iconetxt (chain, 115, txtnorm, fondmenu, fondnorm);
            end else
               Iconetxt ('',    115, txtnorm, fondmenu, fondnorm);

      aff_mem;
   end;

procedure icone_etat;
   var
      i, dx, py, hy     : integer;

   begin
      { icnes prdfinies pour l'affichage de la ligne d'tat }
      dx := posxbtn div 5;
      py := maxy - 2*ty -2;
      hy := maxy -   ty -4;

      { bouton 1 identique }
      bouton_icone (aidico112, 112,  0,   py, dx -3, ty);
      { bouton 2 identique }
      bouton_icone (aidico113, 113, dx,   py, dx -3, ty);
      if nomdumodule = nom_cart
      then begin
        { bouton 3 CART }
         bouton_icone (aidico114, 114, dx*2, py, dx -3, ty);
        { bouton 4 CART }
         bouton_icone (aidico115, 115, dx*3, py, dx -3, ty)
      end else
         if nomdumodule = nom_coup
         then begin
            { bouton 3 COUP }
            bouton_icone (aidico114c, 114, dx*2, py, dx -3, ty);
            { bouton 4 COUP }
            if airlibre
            then begin
               if nomfd2 = nom_graval
               then
                  bouton_icone (aidico115gal, 115, dx*3, py, dx -3, ty)
               else
                  bouton_icone (aidico115gab, 115, dx*3, py, dx -3, ty)
            end else
               bouton_icone (aidico115gbg, 115, dx*3, py, dx -3, ty);
         end else
            if nomdumodule = nom_grav
            then begin
               { bouton 3 GRAV  }
               bouton_icone (aidico114g,  114, dx*2, py, dx -3, ty);
               { bouton 4 GRAV  }
               bouton_icone (aidico115g,  115, dx*3, py, dx -3, ty);
            end else begin
               { bouton 3 BLOC  }
               bouton_icone (aidico114b,  114, dx*2, py, dx -3, ty);
               { bouton 4 BLOC  }
               bouton_icone ('',          115, dx*3, py, dx -3, ty);
            end;

      { bouton 5  commun }
      bouton_icone (aidico116 , 116, dx*4, py, dx -3, ty);
      for i := 112 to 116
      do
         active_icone (i);
   end;

procedure choix_action (var choi : integer);
   begin
      choi := 1;
      creeliste (n_effacer, 1);
      creeliste (n_Afficher, 2);
      utildivs.liste     ('', l_action, '', 15, chain, choi);
   end;

procedure textemenufichier;
   begin
      textemenu (1,  1, txt_mnu11,  '');
      textemenu (1,  2, txt_mnu12,  txt_mnu12a);
      textemenu (1,  3, txt_mnu13,  txt_mnu13a);
      textemenu (1,  4, txt_mnu14,  txt_mnu14a);
      textemenu (1,  5, txt_mnu15,  txt_mnu15a);

      textemenu (1,  6, txt_mnu16,  txt_mnu16a);

      textemenu (1,  8, txt_mnu18,  txt_mnu18a);

      textemenu (3,  1, txt_mnu31,  '');

      textemenu (4,  1, txt_mnu41,  '');

      textemenu (5,  1, txt_mnu51,  '');

      textemenu (6,  1, txt_mnu61,  '');
      textemenu (6,  2, txt_mnu62,  txt_mnu62a );
      textemenu (6,  3, txt_mnu63,  txt_mnu63a );
      textemenu (6,  4, txt_mnu64,  txt_mnu64a );
      textemenu (6,  5, txt_mnu65,  txt_mnu65a + ' ' + nomdumodule + '.');
      textemenu (6,  6, txt_mnu66,  txt_mnu66a + ' ' + region      + '.');
      textemenu (6,  8, txt_mnu68,  txt_mnu68a );
   end;

procedure textemenufichierprof;
   begin
      textemenu (1, 10, txt_mnu110, txt_mnu110a);
      textemenu (1, 11, txt_mnu111, txt_mnu111a);
      textemenu (1, 12, txt_mnu112, txt_mnu112a);

      textemenu (5,  7, txt_mnu57,  txt_mnu57a);
      textemenu (5,  8, txt_mnu58,  txt_mnu58a);
      textemenu (5,  9, txt_mnu59,  txt_mnu59a);
   end;

procedure lire_config ;
   begin
      if ftxt_present (chemincfg + nomfcfg + extcfg)
      then
         parini.lit (chemincfg + nomfcfg + extcfg);
   end;

procedure ecrire_config ;
   begin
      parini.ecrit (chemincfg + nomfcfg+ extcfg, datjour+' '+nomutil)
   end;

procedure voir_penv;
   begin
      parini.boite;
      { lipar }
      bte_compl (t_bte_cfg,      -1, -1, nbc, nbo, 0, 10);
      { menu6 }
   end;

procedure voir_psymb;
   begin
      parsymb.boite;
      bte_compl (t_bte_smb,     -1, -1, nbc, nbo, 0, 10);
   end;

procedure inisymboles;
   begin
      laide (la_lit_smb);
      if ftxt_present (cheminmodule+symb1+extsmb)
      then
         initialiser_jeu_symb (cheminmodule+symb1+extsmb, 1)
      else
         message (m_fichier+' '+symb1+' '+m_fichiers);
                                { textes simples et accents }
      {if ftxt_present (symb2+extsmb)
      then initialiser_jeu_symb (symb2+extsmb, 2);}
                                { titres majuscules seules }

      if ftxt_present (cheminmodule+symb3+extsmb)
      then
         initialiser_jeu_symb (cheminmodule+symb3+extsmb, 3)
      else
         message (m_fichier+' '+symb3+' '+m_fichiers);
      { paramtres pour symboles centrs, tiquettes des pts. de mesure... }
      laide ('');
   end;

procedure ini_par_cfg (nomf  : pathstr);
   begin
      InhiberBreak;
      parini.init (false);
      parini.ajoute (Cstring  ('Fichier symboles 1'    , @symb1, 'baton1'  ));
     { parini.ajoute (Cstring  ('Fichier symboles 2'    , @symb2, 'baton2'  ));}
      parini.ajoute (Cstring  ('Fichier symboles 3'    , @symb3, 'symboles'));
      parini.ajoute (Cinteger ('Nombre de plumes'      , @nbpl     ,     0 ));
      parini.ajoute (Cstring  ('Valeur indfinie'      , @vindef , '9999.9'));
      parini.ajoute (Cinteger ('Numro du port srie'  , @porttab  ,     0 ));
      parini.ajoute (Cinteger ('Numro du port impr.'  , @portimpr ,     1 ));
      parini.ajoute (Cinteger ('Vitesse de transm.'    , @bauds    ,  1200 ));
      parini.ajoute (Cinteger ('Type d''imprimante'    , @qual     ,     0 ));
      parini.ajoute (Cchar    ('Format papier/traceur' , @formatpapier, '4'));
      parini.ajoute (Cword    ('Couleur barre menus'   , @fondmenu ,    15 ));
      parini.ajoute (Cword    ('Couleur texte menus'   , @txtmenu  ,     0 ));
      parini.ajoute (Cword    ('Couleur texte normal'  , @txtnorm  ,     3 ));
      parini.ajoute (Cword    ('Couleur texte inactif' , @txtnon   ,     6 ));
      parini.ajoute (Cword    ('Couleur texte slect'  , @txtoui   ,     0 ));
      parini.ajoute (Cword    ('Couleur fond normal'   , @fondnorm ,     1 ));
      parini.ajoute (Cword    ('Couleur fond slect'   , @fondoui  ,     2 ));
      parini.ajoute (Cword    ('Couleur barre aide'    , @fondaide ,     6 ));
      parini.ajoute (Cword    ('Couleur botes'        , @coulboite,     7 ));
      parini.ajoute (Cword    ('Couleur cran'         , @coulecran,     6 ));
      parini.ajoute (Cword    ('Couleur carte'         , @c_carte  ,    14 ));
      parini.ajoute (Cword    ('Couleur grille'        , @c_grille ,    13 ));
      parini.ajoute (Cword    ('Couleur bord'          , @c_bord   ,     3 ));
      parini.ajoute (Cword    ('Couleur titre'         , @c_titr   ,     5 ));
      parini.ajoute (Cword    ('Couleur axex'          , @c_axex   ,     2 ));
      parini.ajoute (Cword    ('Couleur axey'          , @c_axey   ,     2 ));
      parini.ajoute (Cword    ('Couleur icnes'        , @c_icone  ,     7 ));
      parini.ajoute (Cboolean ('Machine rapide'        , @rapide   ,  False));
      parini.ajoute (Cboolean ('Affichages automatiques', @reaffiche, False));
      parini.ajoute (Cboolean ('Bloc monochrome',       @unicolore,   False));
      parini.ajoute (Cboolean ('Traitement autoris'   , @TraitementAutorise,True));

      if ftxt_present (nomf)
      then
         parini.lit (nomf);

      pol_menu       := 2;
      val (vindef, v_indef, entier);
      copie_en_cours := false;
      gradauto       := true;
      modicomm       := false;
      {moditop        := false;}
   end;

   {------------------------------------------------------------------------}
   {              commentaires et toponymie                                 }
   {------------------------------------------------------------------------}

procedure ini_par_comm  (nomf : pathstr);
   { initialisation des commentaires                                        }
   begin
      Annotations := new (PListeComment, init);
      annotations^.lit (nomfcomm + extcom, true);
   end;

procedure ini_par_Noms;
   { initialisation de la toponymie  partir d'un fichier simple           }
   begin
      Noms := new (PListeComment, init);
   end;

procedure prepare_label (xp, yp : real; var mx, my : real; es : t12);
   { calcule les dcalages dans la fentre cte, en fonction des var globales
     align_t, xrap, yrap  (angl_t  inutile) }
   var
      h, v              : byte;

   begin
      initialiser_parametres_courants (1, haut_t, {angl_t}0,   0,   65);
      case align_t of
         1 : begin h := 0; v := 0 end;
         2 : begin h := 0; v := 1 end;
         3 : begin h := 0; v := 2 end;
         4 : begin h := 1; v := 0 end;
         5 : begin h := 1; v := 1 end;
         6 : begin h := 1; v := 2 end;
         7 : begin h := 2; v := 0 end;
         8 : begin h := 2; v := 1 end;
         9 : begin h := 2; v := 2 end;
      end;
      justifie_texte (es, h, v, mx, my);
      mx := mx/xrap;
      my := my/xrap;
   end;

procedure append_Noms (nomf  : pathstr);
   var
      fdat              : text;
      nom               : PCommentaire;
      xs,  ys           : integer;
      mx,  my,
      x0,  y0,
      xc , yc           : real;
      t                 : t30;

   begin
      if Ftxt_Present (nomf)
      then begin
         assign (fdat, nomf);
         resetTxtErr  (fdat, nomf, ok);
         repeat
            read   (fdat, xc);
            read   (fdat, yc);
            read   (fdat, t);                { dernier champ = texte possible }
            e_b_devant (t);
            e_b (t);
            fenetrecloturecrantrac (false);
            xs  := xecran (xc);
            ys  := yecran (yc);

            fenetrecloturemilli;
            x0  := xutilisateur (xs);
            y0  := yutilisateur (ys);

            mx  := 0;
            my  := 0;
            if align_t > 1
            then
               prepare_label (x0, y0, mx, my, t);

            Nom := new (PCommentaire,
                      init (X0+mx, Y0+my, x0, y0, xc, yc,
                          Haut_t, 0, 0, coul_t, 1, 0,          false, t));
                                            {     0 poigne    2dim }
            Noms^.insert (Nom);

            readln (fdat);
         until eof (fdat);
         close (fdat);
      end;
      pleinecloture;
   end;

procedure recalculer_toponymie_2d;
   begin
      if nomftop <> ''
      then begin
         fenetrecloturecrantrac (false);
         noms^.recadrer;
         pleinecloture;
      end;
   end;

procedure ecrit_par_comm (nomf : pathstr);
   { enregistrement des commentaires  sur fichier                           }
   begin
      if annotations^.count > 0
      then
         Annotations^.Ecrit (nomf, true)
      else
         if exists (nomf)
         then
            effacefichier (nomf, ok);
   end;

procedure ecrit_toponymie (nomf : pathstr);
   { enregistrement de la toponymie sur fichier/donnes                    }
   begin
      if noms^.count > 0
      then
         Noms^.Ecritp       (nomf)
      else
         if exists (nomf)
         then
            effacefichier (nomf, ok);
   end;

procedure ecrit_par_noms (nomf : pathstr);
   { enregistrement de la toponymie sur fichier/travail                    }
   begin
     if noms^.count > 0
     then
        Noms^.Ecrit        (nomf, deux_d)
     else
        if exists (nomf)
        then
           effacefichier (nomf, ok);
   end;

procedure inicoul_cfg;
   begin
      { couleurs interdites dans tous les modules }
      if nomdumodule <> nom_nuag
      then begin
         pal [coulecran] := false;         { gris :  }
         pal [coulboite] := false;         { gris : fond cran }
      end;
      pal  [0] := false;
      pal [15] := false;
  end;

procedure libcoul_cfg;
   { Toutes couleurs autorises momentanment pour Palette en mode prof     }
   begin
      pal [coulecran] := true;         { gris :  }
      pal [coulboite] := true;         { gris : fond cran }
      pal  [0] := true;
      pal [15] := true;
  end;

procedure geo_PALETTES (nompal : namestr);
   begin
      libcoul_cfg;
      palettes (nompal);
      inicoul_cfg;
   end;

procedure modif_menu_cfg;
   begin
      if prof
      then begin
         if nomdumodule = nom_cart then chain := nomm_Cart;
         if nomdumodule = nom_bloc then chain := nomm_Bloc;
         if nomdumodule = nom_nuag then chain := nomm_Nuag;
         if nomdumodule = nom_coup then chain := nomm_Coup;
         if nomdumodule = nom_grav then chain := nomm_Grav;
         if nomdumodule = nom_exoc then chain := nomm_Exoc;

         if (nomdumodule <> nom_nuag)
         then begin
            if (porttab > 0)
            then begin
               textemenu (5,  4,
                   txt_mnu541+ ' ' + chain,                   txt_mnu54a )
            end else begin
               textemenu (5,  4,
                   txt_mnu542+ ' ' + chain+ ' '+ txt_mnu542s, txt_mnu54a2)
            end;
         end else
            active (5, 4, false);

         if nbpl > 0                          { traceur prsent dans la config }
         then begin
            active    (5,  4, true);                            { tracer carte }
            active    (5,  5, true);                            { choix plumes }
         end else begin
            active    (5,  4, false);
            active    (5,  5, false);
         end;
      end;

      if qual > 0
      then begin
         if qual <= der_impr
         then
            textemenu (5,  2, txt_mnu52,  txt_mnu52a)
         else begin
            if qual = der_impr+1
            then
               textemenu (5,  2, txt_mnu522,  txt_mnu522a)
            else
               textemenu (5,  2, txt_mnu523,  txt_mnu523a)
         end
      end else
         textemenu (5,  2, txt_mnu521, txt_mnu521a);

   end;

procedure fond_commentaires (m1, m2, m3, m4 : word);
   begin
      coulbar (SolidFill, coulecran);
      bar (m1, maxy-m3, m2, maxy-m4);     { couleur fond cran }
   end;

procedure fond_ecran (co : word);
   begin
      coulbar (SolidFill, co);
      bar (0, 0, maxx, maxy);             { couleur fond cran }
   end;

procedure lire_contour (nomf : pathstr);
   begin
      laide (la_lit_contours);
      { si ncessaire... }
      liberercontour;
      ini_contour  (nomf);
      laide ('');
   end;

procedure dess_fond (nomf : Pathstr; coc, coe : word; t : real);
   var
      fic               : text;
      d                 : dirstr;
      n                 : namestr;
      e                 : extstr;

   procedure dess_bln (nomf : dirstr ; co : word);
      { travaille directement  partir du fichier : pas de mmorisation }
      { et prend en compte la valeur indfinie }
      var
         nbst, i        : integer;
         l, p           : real;
         typ            : t12;

      begin
         if not ftxt_present (nomf)
         then
            exit;
         assign  (fic, nomf);
         reset   (fic);
         fixecoul (co);
         while (not (eof (fic)))
         do begin         { lire une ligne }
            readln (fic, nbst, typ);    { lire entte : nb points, altitude }
            if nbst > 1
            then begin
               i := 1;
               readln (fic, l, p);
               while i < nbst
               do begin
                  while (p >= v_indef) and (i < nbst)
                  do begin { sauter val indfinies }
                     readln (fic, l, p);
                     inc    (i);
                  end;
                  deplaceen       (l, p);     { se dplacer sur le premier pt }
                  while (p < v_indef) and (i < nbst)
                  do begin
                     inc    (i);
                     readln (fic, l, p);
                     tracevers   (l, p);
                  end
               end
            end
         end;
         close (fic);
      end;

   procedure dess_eti (nomf : dirstr ; co : word; t : real);
      var
         x, y,    d     : real;
         a              : t12;

      begin
         if not ftxt_present (nomf)
         then
            exit;

        {         t  := 2;}
         initialiser_parametres_symbct
            (1,       t,      1,   0,  0,  65);
         assign  (fic, nomf);
         reset   (fic);
         fixetrait (0);
         readln  (fic, a);      { lecture bidon premire ligne commentaires }
         while (not (eof (fic)))
         do begin               { lire/dessiner une tiquette }
            readln   (fic, x, y,    d,    a);          { lire      }
            e_b_devant (a);                            { enlever espaces }
            etiquette_crb (x, y, t, d, co, a);         { dessiner tiquette }
         end;
         close   (fic);
      end;

   begin
      { cloture et fenetre en cours }
      fsplit (nomf, d, n, e);
      nomf := d+n;
      dess_bln (nomf+extblf, coc);
      dess_eti (nomf+exteti, coe, t);
   end;

procedure chang_contour;
   var
      d                 : dirstr;
      n                 : namestr;
      e                 : extstr;

   begin
      nomfcart := '';
      dir_info                                                    { dirinfo }
         (Donnees_ini,
          '',
          Choix_contour,
          chemindonnees+nomfinfod, '*', extBLN, chain);
      fsplit (chain, d, n, e );

      if n <> ''
      then begin
         nomfcart := n;
         lire_contour (chemindonnees+nomfcart+extbln);
      end;
   end;

procedure chang_nom_trav_donnees (comm      : chainecar;
                                  var local : boolean;
                                  var nomf  : namestr;
                                  ext       : extstr);
   var
      d              : dirstr;
      n              : namestr;
      e              : extstr;
      c              : integer;

   begin
      local    := false;
      dir_info                                               { dirinfo }
         (donnees_util, comm, donnees_ini2,
          nomfinfo, '*', ext, chain);
      fsplit (chain, d, n, e );

      if n <> ''
      then begin                 {  un fichier existe localement }
         nomf  := n;
         local := true;
      end else begin             {  rechercher dans les donnes }
         dir_info                                               { dirinfo }
            (Donnees_ini, '', comm,
             chemindonnees+nomfinfod, '*', ext, chain);
         fsplit (chain, d, n, e );

{         if n <> ''
         then }                   { else pas de changement }
             nomf := n;
      end;
   end;

procedure chang_fondcarte (comm : Chainecar ; var nomf : Pathstr);
   var
      local             : boolean;

   begin
      chang_nom_trav_donnees (Choix_fond+comm,
                               local, nomf, extblf);
      if local
      then
         nomf := nomf
      else
         nomf := chemindonnees+nomf;
   end;

(*   var
      d              : dirstr;
      n              : namestr;
      e              : extstr;
      c              : integer;

   begin
      nomffond := '';
      dir_info                                               { dirinfo }
         ('Donnes utilisateur',
          '',
          'Choisir un fond de carte : ',
         nomfinfo, '*', extblf, chain);
      fsplit (chain, d, n, e );

      if n <> ''
      then begin                 {  un fichier existe localement }
         nomffond := n;
      end else begin             {  rechercher dansles donnes }
         dir_info                                               { dirinfo }
            ('Donnes initiales',
             '',
             'Choisir un fond de carte : ',
            chemindonnees+nomfinfod, '*', extblf, chain);
         fsplit (chain, d, n, e );
         if n <> ''
         then                   { else pas de changement }
             nomffond := d+n;
      end;
   end; *)

procedure retailler;
   begin
      if  fc1 < cor1
      then
         fc1 := cor1;

      if (fc2 <= cor1) or (fc2 > cor2)
      then
         fc2 := cor2;

      if fc3 < cor3
      then
         fc3 := cor3;

      if (fc4 <= cor3) or (fc4 > cor4)
      then
         fc4 := cor4;
   end;

function long_km (c1, c2, c3, c4 : real) : real;
   { calcule la longueur en km  partir des coordonnes en degrs }
   const
      pi                =    3.141592654;
      rad               =    0.017453292;
                            { facteur mult. pour conversion degr->radian }

   var
      l0, l1            : real;

   begin
   {        Sqrt(Sqr(Lat1-Lat0)+Sqr(Long1*Cos(rad*Lat1)-Long0*Cos(rad*Lat0)));}
      l0 := Sqrt (Sqr (c4  -c3) +Sqr (c2 * Cos (rad*c4) -c1*Cos (rad*c3)));
      l1 := 6400*Pi/180* l0;
      long_km := l1;
   end;

procedure calculer_degkm (xm, ym : real);
   { calcule le coefficient de correction degkm_r au point xm ym () }
   var
      l1                : real;

   begin
      l1      := long_km (xm, xm+1, ym, ym+1);
      degkm_r := l1 / (degkm*1.414);
   end;

procedure lire_grille (var Grille : TGrille; nomfg : pathstr;
                       Traitement : Boolean);
   Var choix              : Integer;
       Coeff1,Coeff2      : Real;
       chain              : ChaineCar;
       PCoeff1,PCoeff2    : PZoneReel;
       Boite              : PBoiteSaisie;

   procedure renommer;
      begin
         if maj (nomfg) = maj (n_TOPO)
         then begin
{              case choi of
              1 : begin}
                  titr3 := n_altitude;
                  unitz := n_metre;{ end;
              2,3: begin
                  titr3 := n_age;
                  unitz := 'Ma' end;
              4 : begin
                  titr3 := nomfg;
                  unitz := n_unit end;
              end{case}; fdg   := '6:0';
         end else begin
            if copy (maj (nomfg), 1, 4) =nom_grav
            then begin
               titr3 := n_Gravimetrie;
               unitz := 'mgal';
               fdg   := '4:0';
            end else begin
            if copy (maj (nomfg), 1, 4) =nom_ages
               then begin
                    case ChoixModele of
                    1 :   begin titr3 := n_Age;
                                unitz := 'Ma'; end;
                    2,3 : begin titr3 := n_altitude;
                                unitz := n_metre; end;
                    4,5 : begin titr3 := n_Flux;
                                unitz := 'mW/m'; end;
                    6 :   begin titr3 := n_Litho;
                                unitz := 'km'; end;
                    7 :   begin titr3 := nomfg;
                                unitz := n_unit; end;
                    end;{case ChoixModele}
                    fdg   := '7:2';   {Format de donnes dans la grille}
               end else begin
                   titr3 := nomfg;
                   unitz := n_unit;
                   fdg   := '6:0';
               end;
            end;
         end;
      end;

   Procedure FonctionLibre;
   begin repeat {entre de texte d'une fonction de traitement}
            laide(l_Fonction);
            saisie (m_Fonction,TexteFonction,50);
            ok := compileFonction(TexteFonction,f1);
            If not ok then begin
               question (e_Fonction+TexteFonction,c_Fonction,ok);
               ok:=not ok end;
         until not traitement or ok;
   end;

   begin
{      If traitement and ((copy (maj (nomfg), 1, 4) =nom_ages)
                      or (copy (maj (nomfg), 1, 4) =maj(n_topo))) then begin}
      If traitement and (copy (maj (nomfg), 1, 4) =nom_ages) then begin
         laide(l_Traitement);
         ChoixModele := 1;
         creeliste (m_Aucun,            1);
         creeliste (MST+'(<70Ma)',      2);
         creeliste (MST+'(>70Ma)',      3);
{         If (copy (maj (nomfg), 1, 4) =nom_ages) then begin}
         creeliste (MFT+'(<120Ma)',     4);
         creeliste (MFT+'(>120Ma)',     5);
         creeliste (m_Accretion,        6);
         creeliste (m_Formule,          7);{end else
         creeliste ('Entrer une formule libre',               4); }
         utildivs.liste (t_Traitement,
                         copy (maj (nomfg), 1, 4)+t_Chargement,
                         '', 40, chain, ChoixModele);
         Case ChoixModele of
              1 : TexteFonction:= '';
              2 : begin {subsidence thermique<70Ma}
                  If (TexteFonction <>'') and
                     CompileFonction(TexteFonction,f1)
                     then begin Coeff1:=evalue(f1,0);Coeff2:=evalue(f1,1) end
                     else begin Coeff1:=2700;Coeff2:=0.116;end;
                  repeat
                    LAide(l_parametres);
                    Boite := new (PBoiteSaisie,
                               init (milieu, milieu,40,FondNorm,TxtNorm,
                                    MST+'(<70Ma)'));
                    PCoeff1 := new (PZoneReel,init (0, 0, 5, 0, TxtMenu,
                             FondMenu,@Coeff1,m_Profondeur_dorsale,n_metre));
                    boite^.ajoute (PCoeff1);
                    PCoeff2 := new (PZoneReel,init (0, 0, 5, 3,TxtMenu,
                             FondMenu,@Coeff2,m_Coeff_Diff,'km/Ma'));
                    boite^.ajoute (PCoeff2);
                    boite^.editeF (1, 1, Choix);
                    dispose (boite, fini);
{                    If (copy (maj (nomfg), 1, 4) =nom_ages) then}
                    TexteFonction := '-('+ChReel(Coeff1,8,3)+
                                     '+1000*SQR('+ChReel(Coeff2,8,3)+'*x))';{ else
                    TexteFonction := '('+ChReel(Coeff1,8,3)+'-x)^2/('
                                        +ChReel(Coeff2,8,3)+'*1000000)';     }
                  until compileFonction (TexteFonction,f1);
                  end;
              3 : Repeat {subsidence thermique>70Ma}
      {              If (copy (maj (nomfg), 1, 4) =nom_ages) then }
                    TexteFonction := '-(6400-3200*exp(-t/62.8))'{else
                    TexteFonction := '-(Ln((6.4-x)/3.2)/62800)'};
                  until compileFonction (TexteFonction,f1);
              4 : {If (copy (maj (nomfg), 1, 4) =nom_ages) then}
                  begin {Flux thermique<120Ma}
                  If (TexteFonction <>'') and
                     CompileFonction(TexteFonction,f1)
                     then begin Coeff1:=evalue(f1,0); end
                     else begin Coeff1:=473 end;
                  repeat
                    LAide(l_parametre);
                    TexteFonction :='473';
                    Saisie(m_Flux_dors,TexteFonction,12);
                    TexteFonction := TexteFonction+'/sqr(x+1)';
                  until compileFonction (TexteFonction,f1);
                  end {else FonctionLibre};
              5 : {Flux thermique>120Ma}
                  repeat TexteFonction := '33.5+67*exp(-t/62.8)';
                  until compileFonction (TexteFonction,f1);
              6 : begin {Accrtion de la lithosphre}
                  If (TexteFonction <>'') and
                     CompileFonction(TexteFonction,f1)
                     then begin Coeff1:=evalue(f1,0); end
                     else begin Coeff1:=11 end;
                  repeat
                    LAide(l_Parametre);
                    TexteFonction :=ChReel(Coeff1,8,3);
                    Saisie(m_epaiss_dors,TexteFonction,12);
                    TexteFonction := TexteFonction+'*sqr(x+1)';
                  until compileFonction (TexteFonction,f1);
                  end;
              7 : FonctionLibre;
         end{case ChoixModele}; end
      {else TexteFonction:=''};
      If TexteFonction<>'' then begin
         DetruitFonction(f1);compileFonction(TexteFonction,f1) end;
      laide (la_lit_grd);
      Grille.init;
      If (copy (maj (nomfg), 1, 4) =nom_ages) then
         Grille.Charger (chemindonnees+nomfg+extgrd,
                         cor1, cor2, cor3, cor4, TexteFonction) else
         Grille.Charger (chemindonnees+nomfg+extgrd,
                         cor1, cor2, cor3, cor4,'') ;
      if nomdumodule = nom_bloc
      then
         Grille.Remplacer (1.70141e+38, Grille.MinZG);

      retailler;
      calculer_degkm ((cor1+cor2) /2, (cor3+cor4) /2);
      renommer;
   end;

(*function question_travail                                  : string;
   begin
      if nomdumodule = nom_nuag
      then
         question_travail := 'Choisir un ensemble de points'
      else
         if nomdumodule = nom_cart
         then
            question_travail := 'Choisir une carte '
         else
            if nomdumodule = nom_coup
            then
               question_travail := 'Choisir un profil'
            else
               if nomdumodule = nom_grav
               then
                  question_travail := 'Choisir un modle gravimtrique'
               else
                  if nomdumodule = nom_exoc
                  then
                     question_travail := 'Choisir un modle magntique'
                  else
                     if nomdumodule = nom_bloc
                     then
                        question_travail := 'Choisir un bloc'
                     else
                        question_travail := '';
   end;
*)

procedure chang_grille (com1, comm, com2 : chainecar;
                        filtrenom        : namestr;
                        var Grille       : TGrille;
                        var nomfg        : namestr;
                        traitement       : boolean);
   var
      nomf               : t12;

   begin
      dir_info                                               { dirinfo }
         (com1, comm, com2,
          chemindonnees+nomfinfod, filtrenom+'*', extgrd, nomf);
      nomf :=  sansext (nomf);
      if nomf <> ''
      then begin
         nomfg    := nomf;
         Grille.liberer;
   {      cor1 := 0;
         cor2 := 0;
         cor3 := 0;
         cor4 := 0;}
         lire_grille (grille, nomfg, traitement);
      end;
   end;

procedure chang_noms ;
   var
      local             : boolean;
      nomf              : namestr;

   begin
      nomf := nomftop;
      chang_nom_trav_donnees (choix_toponym,
                               local, nomf, exttop);

      if nomf <> ''
      then begin                 { else pas de changement }
         nomftop := nomf;
         liberer_noms;
         ini_par_noms;
         if local
         then
            Noms^.lit   (nomftop+exttop,  deux_d)
         else
            append_noms (chemindonnees+nomftop+exttop);
         Noms^.modifier (nbpg_t, coul_t, haut_t);
      end;
   end;

procedure chang_comm (var nomf : namestr);
   begin
      dir_info                                               { dirinfo }
            (d_comm1, d_comm2, d_comm3,
             nomfinfo, '*', extcom, chain);
      nomf :=  sansext (chain);
      if nomf <> ''
      then begin
         nomfcomm := nomf;
         liberer_commentaires;
         ini_par_COMM (nomfcomm + extcom); { commentaires }
      end;
   end;

(*procedure chang_palette (var nomfp : string);
   begin
      dir_info                                               { dirinfo }
            ('Palette ? ', nomfinfo, '*', extpal, nomf);
      nomf :=  sansext (nomf);

      if nomf <> ''
      then begin
         nomfp    := nomf;
         chargepalette (nomfp + extpal, ok);         { graphism }
      end;
   end;        *)

procedure impr_params (t : Chainecar; l : lipar.liste);
   var
      nomport           : t12;

   begin
      if portimpr = 0  then exit;
      verif_port (portimpr, ok);
      {  revoir pour le rseau : ne pas refermer en cours d'impression }
      if ok
      then begin
         case portimpr of
            1 : nomport := port1;
            2 : nomport := port2;
        {    3 : nomport := port3;}
         end;
         l.ecrit (nomport, t+' '+datjour+' '+nomutil+' '+titre);
      end;
   end;

procedure ini_titre;
   var
      px, py,
      co                : integer;

   begin
      px := XGIcone (4) + 48;
      py := YHIcone (4) + 12;
      if ecran and (nomdumodule = nom_grav)
      then begin
         coulbar (1, coulboite);
         bar (px-46, py-11, px+46, py+12);
      end;
      fixecoul  (c_titr);
      settextjustify (1, 1);
      outtextxy (px,   py,  titre);
      settextjustify (0, 2);
   end;

function zonetat (x, y : integer) : boolean;
   begin
      zonetat := (y > maxy-2*ty) and (y < maxy-ty) and (x < posxbtn);
   end;

procedure choix_couleur_trait (comm : Chainecar; var cc1, tt1 : byte);
   var
      i,
      touche, poscur    : integer;
      co1   , t1        : byte;
      zc1               : Pzonecouleur;
      boite             : PBoiteSaisie;

   begin
      co1    := cc1;
      t1     := tt1;

      Zs1    := new (PZoneSymboles,
                init ( 0,     2*ty,         txtnorm, coulboite, @tt1,
                '', '', DessinerTraits, @cc1));
      Zs1^.Cnom  := fondmenu;
      Zs1^.NbSmb := 3;

      Zc1    := new (PZoneCouleur,
                init (12*tx,   2*ty,                           @cc1,
                '', '                 ', pal));

      boite  := new (PBoiteSaisie,
                init (milieu, milieu, 15,   fondnorm, txtnorm,
                comm));
      { diter le tout }
      poscur := 1;
      boite^.ajoute (zs1);
      boite^.ajoute (zc1);

      laide (aidedit);
      boite^.editeF (1, Poscur, Touche);
      boite^.vider;
      dispose (boite, fini);
      laide ('');

      if (touche = ESC)
      then begin
         cc1     := co1;
         tt1     := t1;
      end;                                 { rtablir les valeurs initiales }
  end;

procedure choix_3couleurs_trait (comm : Chainecar;
                                 var cc1, cc2, cc3, tt1 : byte);
   var
      i,
      touche, poscur    : integer;
      co1, co2, co3,
      t1                : byte;
      zc1, zc2, zc3     : Pzonecouleur;
      boite             : PBoiteSaisie;

   begin
      co1    := cc1;
      co2    := cc2;
      co3    := cc3;
      t1     := tt1;

      Zc1    := new (PZoneCouleur,
                init (0,      2*ty,                           @cc1,
                b_Contours, '   ', pal));
      Zs1    := new (PZoneSymboles,
                init (21*tx,   2*ty,         txtnorm, coulboite, @tt1,
                '', '', DessinerTraits, @cc1));
      Zs1^.Cnom  := fondmenu;
      Zs1^.NbSmb := 2;


      Zc2    := new (PZoneCouleur,
                init (0,   0,                           @cc2,
                b_courbesf, '   ', pal));

      Zc3    := new (PZoneCouleur,
                init (0,   0,                           @cc3,
                b_etiqs, '   ', pal));

      boite  := new (PBoiteSaisie,
                init (milieu, milieu, 15,   fondnorm, txtnorm,
                comm));
      { diter le tout }
      poscur := 1;
      boite^.ajoute (zs1);
      boite^.ajoute (zc1);
      boite^.ajoute (zc2);
      boite^.ajoute (zc3);
      laide (aidedit);
      boite^.editeF (1, Poscur, Touche);
      boite^.vider;
      dispose (boite, fini);
      laide ('');

      if (touche = ESC)
      then begin
         cc1     := co1;
         cc2     := co2;
         cc3     := co3;
         tt1     := t1;
      end;                                 { rtablir les valeurs initiales }
  end;

procedure choix_axes (var htir, hcar, nbti, nbdec : integer;
                      var inter_e                 : real);
   var
      e1, e2, e3, e4,
      touche, poscur    : integer;
      r5, im            : real;
      cc1, cc2          : byte;
      s1, s2, s3        : t12;
      z1, z2, z3, z4    : PZoneEntier;
      z5                : pzoneReel;
      zs1, zs2, zs3     : PZoneChaine;
      zc1, zc2          : Pzonecouleur;
      boite             : PBoiteSaisie;

   begin
      im  := (fc2 - fc1) / 2;     { intervalle maxi entre deux graduations }
      e1  := htir;
      e2  := hcar;
      e3  := nbti;
      e4  := nbdec;
      r5  := inter_e;
      s1  := titr1;
      s2  := titr2;
      s3  := titr3;
      cc1 := byte (c_axex);
      cc2 := byte (c_axey);
      poscur := 1;
      boite  := new (PBoiteSaisie,
                init ( milieu, milieu, 15,  fondnorm, txtnorm,
                t_axesxyz));

      if visugrad
      then begin
         z1     := new (PZoneEntier,
                   init (  0,   0,   2,   txtmenu, fondmenu, @htir,
                   b_htirets, 'mm'));
         boite^.ajoute (z1);

         z2     := new (PZoneEntier,
                   init (  0,   0,   2,   txtmenu, fondmenu, @hcar,
                   b_hetiqs, 'mm'));
         boite^.ajoute (z2);

         z3     := new (PZoneEntier,
                   init (  0,   0,   2,   txtmenu, fondmenu, @nbti,
                   b_nbtirets, ''));
         boite^.ajoute (z3);
      end;

      if not gradauto
      then begin
         z4  := new (PZoneEntier,
                init (  0,   0,   2,    txtmenu, fondmenu, @nbdec,
                b_nbdeci, ''));
         boite^.ajoute (z4);

         z5  := new (PZoneReel,
                init (  0,   0,   5,   2, txtmenu, fondmenu, @inter_e,
                b_interv, unitxy));
         boite^.ajoute (z5);
      end;

{      if visugrad
      then begin   }
         { nom }
         zs1     := new (PZoneChaine,
                    init (     0,      0,  str12, txtmenu, fondmenu, @titr1,
                    b_axex, ''));
         boite^.ajoute (zs1);
         { couleur }
         Zc1     := new (PZoneCouleur,
                    init (     0,      0,                         @cc1,
                    b_couleur, '', pal));
         boite^.ajoute (zc1);

         { nom }
         zs2     := new (PZoneChaine,
                    init (     0,      0, str12 , txtmenu, fondmenu, @titr2,
                    b_axey, ''));
         boite^.ajoute (zs2);
         { couleur }
         Zc2     := new (PZoneCouleur,
                    init (     0,      0,                         @cc2,
                    b_Couleur, '', pal));
         boite^.ajoute (zc2);
{      end;           }

      { nom }
      zs3      := new (PZoneChaine,
                  init (     0,      0,  str12,   txtmenu, fondmenu, @titr3,
                  b_AxeZ, ''));
      boite^.ajoute (zs3);

      laide (aidedit);
      boite^.editeF (1, Poscur, Touche);
      laide ('');

      boite^.vider;
      dispose (boite, fini);

      if (touche = ESC) {or (touche = 0)}
      then begin
         htir    := e1;
         hcar    := e2;
         nbti    := e3;
         cc1     := c_axex;
         cc2     := c_axey;
         titr1   := s1;
         titr2   := s2;
         titr3   := s3;
         if not gradauto
         then  begin
            nbdec   := e4;
            inter_e := r5;
         end;
      end;
      { ajuster en fonction des limites }
      if htir    <  0 then htir    :=  0;
      if htir    > 10 then htir    := 10;
      if hcar    <  0 then hcar    :=  0;
      if hcar    > 10 then hcar    := 10;
      if nbti    > 10 then nbti    := 10;
      if not gradauto
      then begin
         if nbdec   > 10 then nbdec   := 10;
         if inter_e <  0 then inter_e :=  0;
         if inter_e > im then inter_e := im;
      end;
      c_axex     := cc1;
      c_axey     := cc2;
   end;

procedure choix_reel (t : Chainecar ; min, max : real; var r :  real);
  var
      touche, poscur    : integer;
      z1                : pzoneReel;
      boite             : PBoiteSaisie;
      chmin, chmax      : t12;

   begin
      str (min:10:3, chmin);
      str (max:10:3, chmax);
      poscur := 1;

      boite  := new (PBoiteSaisie,
                    init ( milieu, milieu, 15,  fondnorm, txtnorm,
                    t));
      z1  := new (PZoneReel,
                    init (  0,   0,   8,   1,   txtmenu,  fondmenu, @r,
                    chmin, chmax));
      boite^.ajoute (z1);

      laide (aidedit);
    {  repeat}
         boite^.editeF (1, Poscur, Touche);
    {  until (r >= min) and (r < max);}
      laide ('');
      boite^.vider;
      dispose (boite, fini);
   end;

procedure choix_axe  (XYZ : t12; var titre : t12);
   var
      touche, poscur    : integer;
      s1                : t12;
      z1                : pzoneChaine;
      boite             : PBoiteSaisie;

   begin
      s1     := titre;
      poscur := 1;
      boite  := new (PBoiteSaisie,
                    init ( milieu, milieu, 15,  fondnorm, txtnorm,
                    n_axe+' '+xyz));
      z1     := new (PZoneChaine,
                    init ( 0,      0,      str12,  txtmenu, fondmenu, @titre,
                    ' ', ' '));
      boite^.ajoute (z1);

      laide (aidedit);
      boite^.editeF (1, Poscur, Touche);
      laide ('');
      boite^.vider;
      dispose (boite, fini);
      if (touche = ESC) {or (touche = 0)}
      then
         titre   := s1;
   end;

{ FICHIERS VALEURS PONCTUELLES }
procedure liberer_SMB      (var z_smb : lst_chn);
   begin
      liberer_liste_chaine (z_smb);
      parsymb.fini;
      parsymbd.fini;
   end;

procedure change_points ;
   var
      i, rg             : byte;

   begin
      liberer_liste_chaine (z_smb);
      parsymb.fini;
      if nomdumodule = nom_cart
      then
         ini_par_SYMB    (nomfps+extps);

      if nomfvs = ''
      then begin
         { demander nom nouveau fichier valeurs  reprsenter  .DAT         }
         laide (la_fich_exist);
         i := 0;
         repeat
            inc (i);
            if nomdumodule <> nom_nuag then i := 3;
            dir_info                                                 { dirinfo }
               (d_points1, d_points2,  d_points3,
                chemindonnees+nomfinfod,
                '*', extvs, chain);
            nomfvs := sansext (chain);
         until (nomfvs <> '') or (i > 2);
         laide ('');
      end;

      { Initialisation paramtres structure nouveau fichier val ponctuelles }
      if nomfvs <> ''
      then begin
         laide (la_lit_points);
         parsymbd.fini;
         ini_par_SYMBd    (chemindonnees+nomfvs+extps);
         if nomdumodule  = nom_nuag
         then
            rg := 4
         else
            rg := 0;
            { pour forcer le rang sans avoir  choisir }
         if maj (copy (nomfvs, 1, 4)) = 'VOLC'
         then begin
            if nomdumodule = nom_cart
            then rg := 4
            else
               if nomdumodule = nom_nuag
               then
                  rg := 3;
         end;

         ini_valeurs_symb (chemindonnees+nomfvs+extvs, rg);

         laide ('');
      end else begin
         if nomdumodule = nom_nuag
         then begin
             message (m_not_donnees);
             halt;
         end;{ else begin
             message ('Pas de fichier slectionn');
         end; }
      end;
   end;

procedure ecrantrac (trac : boolean);
   begin
      if trac
      then begin
         ini_traceur;
         ecran   := false;
      end else begin
         ecran   := true;
         traceur := false
      end;
   end;

procedure fenetrecloturemilli;
   begin
      fenetre         (0, trunc (papier_x), 0, trunc (papier_y));
      cloturemilli    (0, trunc (papier_x), 0, trunc (papier_y));
   end;

procedure fenetrecloturecrantrac (trac : boolean);
   begin
      ecrantrac (trac);
      fenetre   (fc1, fc2, fc3, fc4);
      cloture   (cc1, cc2, cc3, cc4);
   end;

procedure pleinecrantrac (trac : boolean);
   begin
      if trac
      then begin
         libere_traceur;
         ecran   := true
      end;
      pleinecloture;
   end;

procedure choix_toponymie (var change : boolean);
   var
      cc1            : byte;                 { rangs dans liste 0..2}
      i,
      touche, poscur : integer;
      r3             : real;
      b2             : Boolean;
      z3             : PZoneReel;
      zc1            : Pzonecouleur;
      zb2            : Pzonebooleen;
      boite          : PBoiteSaisie;

   begin
      change := true;
      r3     := haut_t;
      cc1    := coul_t;
      b2     := fond_t;
      { angle_t  := 0;}
      { align_t  := 0;}
      poscur := 1;
      boite  := new (PBoiteSaisie,
                init (milieu, milieu, 15,  c_f_boite_norm, c_t_boite_norm,
                n_Toponymie));

      Zc1    := new (PZoneCouleur,
                init (     0,      0,       @cc1,
                b_couleur, '', pal));
      boite^.ajoute (zc1);

      z3    :=  new (PZoneReel,
             init (  0,   0,  4, 1, colorf, colord, @haut_t,
             b_Hauteur, 'mm'));
      boite^.ajoute (z3);

      if nomdumodule = nom_bloc
      then begin
         Zb2    := new (PZoneBooleen,
                   init (0,  0, c_t_boite_inve, c_f_boite_inve,     @fond_t,
                         b_fondeffac, ''));
         boite^.ajoute (zb2);
      end;

      laide (aidedit);
      boite^.editeF (1, Poscur, Touche);
      laide ('');

      boite^.vider;
      dispose (boite, fini);

      if (haut_t < hcarmin) or (haut_t > hcarmax)
      then
         haut_t  := r3;

      if (touche = ESC)  {or (touche = 0)}
      then begin                           { rtablir les valeurs initiales }
         haut_t   := r3;
         cc1      := coul_t;
         fond_t   := b2;
         change   := false;
      end;
      coul_t   := cc1;
      noms^.modifier (nbpg_t, coul_t, haut_t);
   end;

procedure saisir_commentaire (var s             : t30;
                              var cc1           : word;
                              var suppr, rappel : boolean;
                              lier              : boolean );
   var
      poscur, touche : integer;
      s1             : t30;
      co1            : byte;
      zt1            : PZonechaine;
      zc1            : PZonecouleur;
      zb1, zb2, zb3  : PZoneBooleen;
      boite          : PBoiteSaisie;
      b2, b3         : boolean;

   begin
      s1     := s;
      co1    := cc1;
      b2     := rappel;
      b3     := lier;

      boite  := new (PBoiteSaisie,
                     init (milieu, milieu, 15,   fondnorm, txtnorm,
                           t_texte));
      { diter le tout }
      zt1    := new (PZoneChaine,
                init (0,  0, str30, c_t_boite_inve, c_f_boite_inve, @s1,
                      '', ''));
      boite^.ajoute (zt1);

      if not lier
      then begin
         Zc1    := new (PZoneCouleur,
                        init (0,  0,                             @cc1,
                              '', '', pal));
         boite^.ajoute (zc1);
      end;

    {  if nomdumodule <> nom_bloc
      then begin}
      Zb2    := new (PZoneBooleen,
                init (0,  0, c_t_boite_inve, c_f_boite_inve,     @rappel,
                     n_lignes, ''));
         boite^.ajoute (zb2);
{      end;       }

      if not suppr
      then begin
         Zb1 := new (PZoneBooleen,
                     init (0,  0, c_t_boite_inve, c_f_boite_inve, @suppr,
                     n_detr_texte, ''));
         boite^.ajoute (zb1);
      end;

      poscur := 1;
      laide (aidedit);
      boite^.editeF (1, Poscur, Touche);
      boite^.vider;
      dispose (boite, fini);
      laide ('');

      if (touche = ESC)
      then begin
         cc1     := co1;
         s1      := s;
         suppr   := false;
         rappel  := b2;
      end;                                 { rtablir les valeurs initiales }
      s := s1;
  end;

procedure Editer_Noms (x, y : integer; dblclc : boolean);
   var
      nom               : PCommentaire;
      texte             : t30;
      coult             : word;
      Touche            : integer;
      lier              : boolean;
      xi, yi            : real;

   begin
      lier   := true;
      ok     := false;
      nom    := nil;
      fenetrecloturemilli;
      if Noms^.Contient (XUtilisateur (x), YUtilisateur (y), Nom)
      then begin
         if dblclc
         then begin
            Nom^.Tracer (CoulBoite, true, false);
            ok := false;
            saisir_commentaire (Nom^.texte, Nom^.couleur, ok, Nom^.lr, lier);
            if not Nom^.lr    { supprimer ligne de rappel prcdente }
            then begin
               Nom^.x0 := Nom^.x;
               Nom^.y0 := Nom^.y;
            end;
            if not ok
            then
               Nom^.Afficher (true, false);
                                         { "cadre", fond}
         end else
            if Nom <> NIL
            then begin
               pleinecloture;
               laide (la_comment);
               fenetrecloturemilli;
               Nom^.Tracer (CoulBoite, true, false);
               SetColor (15 xor coulboite);
               xi := nom^.x0;
               yi := nom^.y0;
               Nom^.Editer
                  (touche, maxc1, maxy-maxc4, maxc2-maxc1 ,maxc4-maxc3, lier);
       {        if Nom^.lr
               then begin
                  Nom^.x0 := xi;
                  Nom^.y0 := yi;
               end; }
               if not Nom^.lr
               then begin
                  Nom^.x0 := Nom^.x;
                  Nom^.y0 := Nom^.y;
               end;
               ok := (touche = DEL);
               if not ok
               then
                  Nom^.Afficher (true, false);
               laide ('');
            end;
         { modifier les coordonnes du texte /carte }

         fenetrecloturemilli;
         xs := xecran (Nom^.x);
         ys := yecran (Nom^.y);

         fenetrecloturecrantrac (false);
         if not nom^.lr
         then begin
            Nom^.xu := xutilisateur (xs);
            Nom^.yu := yutilisateur (ys);
         end;
         modipar  := true;
         modicomm := true;
       {  moditop  := true;}
      end;

      if Nom <> nil
      then
         if ok or (nom^.texte='')
         then
            Noms^.free (nom);
      PleineCloture;
   end;

procedure Editer_Commentaires (x, y : integer; dblclc : boolean);
   var
      comm              : PCommentaire;
      texte             : t30;
      coult             : word;
      Touche            : integer;

   begin
      ok   := false;
      comm := nil;
      fenetrecloturemilli;
      if Annotations^.Contient (XUtilisateur (x), YUtilisateur (y), comm)
      then begin
         if dblclc
         then begin
            Comm^.Tracer (CoulBoite, true, False);
            ok := false;
            saisir_commentaire
               (comm^.texte , comm^.couleur, ok, comm^.lr, false);
            if not Comm^.lr
            then begin
               Comm^.x0 := Comm^.x;
               Comm^.y0 := Comm^.y;
            end;
            if not ok
            then
               Comm^.Afficher (true, false);
         end else
            if Comm <> NIL
            then begin
               laide (la_comment);
               Comm^.Tracer (CoulBoite, true, false);
               SetColor (15 xor coulboite);
               Comm^.Editer
                  (touche, maxc1, maxy-maxc4, maxc2-maxc1 ,maxc4-maxc3, false);
               if not Comm^.lr
               then begin
                  Comm^.x0 := Comm^.x;
                  Comm^.y0 := Comm^.y;
               end;
               ok := (touche = DEL);
               if not ok
               then
                  Comm^.Afficher (true, false);
               laide ('');
            end;
         modicomm := true;
         modipar  := true;
      end;
   {   Comm^.xu := 0;
      Comm^.yu := 0;  }

      if comm <> nil
      then
         if ok or (comm^.texte = '')
         then
            Annotations^.free (Comm);
      PleineCloture;
   end;

procedure Dessiner_Noms (trac, cadre, fond : boolean);
   begin
      ecrantrac      (trac);
      fenetrecloturemilli;
      Noms^.Afficher (cadre, fond);
      pleinecrantrac (trac);
   end;

procedure Effacer_Noms ;
   begin
      ecrantrac      (false);
      fenetrecloturemilli;
      Noms^.Effacer ;
      pleinecrantrac (false);
   end;

procedure Dessiner_Commentaires (trac, cadre, fond : boolean);
   begin
      ecrantrac      (trac);
      { visucomm := true; }
      fenetrecloturemilli;
      Annotations^.Afficher (cadre, fond);
      pleinecrantrac (trac);
   end;

procedure liberer_noms;
   begin
      if noms <> NIL
      then begin
         dispose (noms, done);
         noms := nil;
      end;
   end;

procedure liberer_commentaires;
   begin
      if annotations <> NIL
      then begin
         dispose (annotations, done);
         annotations := nil;
      end;
   end;

procedure Effacer_Commentaires;
   begin
      ecrantrac      (false);
      fenetrecloturemilli;
      Annotations^.Effacer ;
      pleinecrantrac (false);
   end;

procedure ajouter_noms ;
   var
      nom               : PCommentaire;
      suppr             : boolean;
      xc, yc,
      x0, y0            : real;    { coord temp }

   begin
      laide (la_Choisir_pos);
      LimiterDeplacementSouris (maxc1, maxy-maxc4, maxc2-maxc1 ,maxc4-maxc3);
      MontrerSouris;
      ChangerCurseur (Texte);
      repeat
         until not UnBoutonSourisEnfonce;
      repeat
         until BoutonSourisEnfonce (BoutonGauche);
      CacherSouris;
      lirepositionsouris (xs, ys);

      fenetrecloturecrantrac (false);
      xc  := xutilisateur (xs);
      yc  := yutilisateur (ys);

      fenetrecloturemilli;
      x0  := xutilisateur (xs);
      y0  := yutilisateur (ys);

      nom := new (PCommentaire,
                   init (X0, Y0, x0, y0, xc, yc,
                          3,  0,  0,  0,  1, nbpg_t, false, ''));
      Noms^.insert (nom);
      PleineCloture;
      ChangerCurseur (Fleche);
      suppr        := true;
      nom^.couleur := coul_t;
      nom^.taille  := haut_t;
      Saisir_Commentaire (nom^.texte, nom^.couleur, suppr,
                          nom^.lr, true);

      if (nom^.texte = '')
      then
         noms^.free (nom);
            { laisse 8 octets de trop ... }

      {   dispose (Comm, done);
            ?? provoque une erreur          }
      Dessiner_noms  (false, true, false);

      laide   ('');
      LibererDeplacementSouris;
   end;

procedure ajouter_commentaires ;
   var
      comm              : PCommentaire;
      suppr             : boolean;
      xc, yc,
      x0, y0            : real;    { coord temp }

   begin
      laide (la_Choisir_pos);
      LimiterDeplacementSouris (maxc1, maxy-maxc4, maxc2-maxc1 ,maxc4-maxc3);
      MontrerSouris;
      ChangerCurseur (Texte);
      repeat
         until not UnBoutonSourisEnfonce;
      repeat
         until BoutonSourisEnfonce (BoutonGauche);
      CacherSouris;
      lirepositionsouris (xs, ys);

      fenetrecloturemilli;
      x0 := xutilisateur (xs);
      y0 := yutilisateur (ys);

      Comm := new (PCommentaire,
                   init (X0, Y0, x0, y0, 0, 0,
                         3, 0, 0, 0, 1, 2, false,''));
      Annotations^.insert (Comm);
      PleineCloture;
      ChangerCurseur (Fleche);
      suppr         := true;
      Comm^.couleur := txtnorm;
      Saisir_Commentaire (Comm^.texte, Comm^.couleur, suppr,
                          Comm^.lr, false);

      if (comm^.texte = '')
      then
         Annotations^.free (Comm);
            { laisse 8 octets de trop ... }
        {   dispose (Comm, done);          ?? provoque une erreur          }

      laide ('');
      LibererDeplacementSouris;
   end;

procedure aide_region;
   begin
      aide_txt (titre,       chemindonnees + region     + exttxt)
   end;

procedure aide_geoc;
   begin
      aide_txt (nomlogiciel, cheminmodule + nomlogiciel + exttxt);
   end;

procedure aide_module;
   begin
      aide_txt (nomlogiciel, cheminmodule + nomdumodule + exttxt);
   end;

procedure aide (x, y : integer);
   begin
      aff_aide (cheminmodule + nomdumodule + exthlp,  x, y-1);     { menus6 }
   end;

procedure A_PROPOS;
   begin
      aff_aide (cheminmodule + nomdumodule + exthlp,  6,  7);                       { menus6 }
   end;

procedure fond_noir  (num_cf : word);
   begin
      copie_en_cours := true;
      if qual = der_impr+1         { PCX noir/Blanc }
      then begin
         maxcolor := 0 ;
         fcouleur (1, 6, 7, num_cf );
      end else begin
         maxcolor := 2;            { PCX blanc/Noir }
         fcouleur (1, 6, 7, num_cf );
      end;
      fond_ecran  (coulecran);
     {  pas indispensable si on n'affiche pas les menus...
        setcoulmenu   (15,      0,      15,       15,
                        0,      0,      15,       coulecran);     }
   end;

procedure fond_couleur (num_cf : word);
   begin
      copie_en_cours := false;
      maxcolor := 15;
      fcouleur (1, 6, 7, num_cf );
      fond_ecran  (coulecran);
      {  indispensable si on a tout bascul en 2 couleurs !!
          setcoulmenu   (fondmenu, txtmenu,  txtnorm, txtnon,
                         txtoui,   fondnorm, fondoui, fondaide);     }
   end;

procedure voir_catalogue;
   begin
      periphs.voir_catalogue;
   end;

procedure config_periph;
   begin
      periphs.config_periph;
   end;

END.

{--- GEOCEAN - GEO_DES ----------------------- R.C.- INRP - TOULOUSE - 1995 }
