UNIT GRAV_DES;

   {------------------------------------------------------------------------}
   {      logiciel GEOCEAN                                                  }
   {                      procdures graphiques du module                   }
   {------------------------------------------------------------------------}

INTERFACE

{$O+,F+}

USES
   Crt,
   Dos,
   Graph,                    { TP 70   - units standard Borland            }
   Souris,                   { ARX     - gestion de la  souris              }
   Clavier,                  { ARX     - gestion du clavier                 }
   Edition,                  { ARX     - saisie/dition paramtres          }
   Graphism,                 { ARX     - initialisations graphiques         }
   Messarx,                  { ARX     - Textes des Messages de Base        }

   Graphplt,                 { ARX     - graphisme 2D cran/traceur         }
   Utildivs,                 { ARX     - utilitaires divers                 }

   Graphsg,                  { ARX     - symboles et graduations            }
   Utiledi,                  { ARX     - utilitaires dition                }
   Icones,                   { ARX     - gestion de icnes                  }
   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   Graphuti,                 { ARX     - utilitaires graphiques             }

   Curseurs,                 { ARX     - potentiomtres                     }
   Menus,                    { ARX     - interface menus                    }

   Symboles,                 { ARX     - gestion des symboles               }

   POLYGON,                  { ARX     - Gestion des polygones              }
   MODELE,                   { ARX     - Gestion des "roches"               }

   GEO_var,                  { GEO     - variables globales communes        }
   GEO_des,                  { GEO     - procdures graph. communes         }

   GRAV_var;                 { GRAV    - variables globales du module       }

CONST
  {$I Croix.cur}

VAR
   exty                 : integer;

{---------------------------------------------------------------------------}

Procedure Calculer;
   { relance le calcul avec les paramtres courants                         }

Procedure aff_densite        (t1, t2 : t12 ; ctxt : word);
   { affiche la valeur de la densit/contraste de la roche courante         }

Procedure eff_densite ;
   { efface la valeur de la densit de la roche courante                    }

Procedure choix_params;
   { Saisie paramtres du modle de rfrence                               }

Procedure choix_params_legende (var cc1, cc2, cc3, cc4, cc5, tt1, tt2 : byte;
                                var r : real;
                                var g : boolean);
   { }

Procedure choix_params_axes  (var cc1, cc2, cc3, tt1 : byte);
   { Saisie paramtres           limite couche, bord, axes, trait limites   }

Procedure efface_modele;
   { efface la carte si possible                                            }

Procedure dess_profil_sismi  (trac : boolean);
   { ajoute le profil sismique }

Procedure dess_modele        (trac : boolean);
   { dessine le modle d'corce                                             }

Procedure dess_courbes       (trac : boolean);
   { dessine le rsultat des calculs                                        }

Procedure efftout;
   { efface la carte                                                        }
   { et libre les pointeurs sur la griile                                  }

Procedure inicoul_cfg;
   { initialise les variables couleur de base                               }

{Procedure inicoul_trv;
    initialise des couleurs modifiables                                    }

Procedure recalc_ecran;
   { recalcule les coordonnes pour un cran autre que VGA                  }

Procedure dess_icones;
   { affiche les icnes                                                     }

Procedure InifondEcran;
   { }

Procedure IniModele;
   { initialise un nouveau modle                                           }

Procedure iniecran;
   { initialise l'tat de l'cran en fonction du fichier param par dfaut   }

Procedure finir;
   { sort en rtablissant l'cran texte                                     }

Procedure Zoomer;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}

Procedure Dezoomer;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}

Procedure SaisirNouveauPoly;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}

Function AppartALaCloture    (x, y   : integer)                 : boolean;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}

Procedure TirerUnPoint       (xs, ys : integer);
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}

Procedure DeplacerPoly       (xs, ys : integer);
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}

Procedure CouperPoly         (xs, ys : integer);
  {------------------------------------------------------------------------}
  {------------------------------------------------------------------------}

Procedure Coller             (xs, ys : integer);
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}

Procedure TirerPoints        (xs, ys : integer);
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}

Procedure SupprimerPoly;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}

Procedure SupprimerPoint     (xs, ys : integer);
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}

Procedure AffecterAttribut;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}

Function DansLaListe         (x, y : integer)                   : boolean;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}

Procedure SelectionneRoche;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}

Procedure MarquerRocheCourante;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}

Procedure DemarquerRocheCourante;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}

Procedure Effacer_Commentaires;
   { Efface toute la zone centrale puis raffiche la carte                  }

Procedure ajoute_grille      (trac, eff : boolean);
   { redessine la grille                                                    }
   {           dans la fentre principale                                   }

Function PolyFlotte          (R         : PRoche)               : boolean;
   { vrai si densit = 0 ou 1.03                                            }

Procedure Legende            (trac      : boolean);
   { }

Procedure redess_modele      (trac      : boolean);
   { }

Procedure redess_tout;
   { redessine aprs inversion couleurs                                     }

Procedure Effacer_tout_redessiner;
   { Efface toute la zone centrale puis raffiche la carte                  }

{---------------------------------------------------------------------------}

IMPLEMENTATION

var
   at1, at2             : integer; { mmorise type trait avant changement }

procedure GenererContrastes;
   { dcoupe les polygones en fonction du modle de rfrence en cours      }
   const
      Epsilon              = 0.000001;

   var
      NouvelleRoche,
      Roche                : PRoche;
      PointBis, Point2Bis,
      Point0,
      Point, Point1,
      Point2, NouveauPoint : PPoint;
      touche : char;
      abscisse,
      ix, iy               : real;
      n,
      np1, np2,
      nr, np,              { Compteur de roches, de points }
      c                    : integer;
      coupe,               { vrai si intersection trouve }
      YaModif, trouve      : boolean;

   function Intersection (x1, y1, x2, y2, Prof : real; var x : real) : boolean;
      begin
         if y1 = y2
         then
            Intersection := false
         else
            if ((y1 <= Prof) and (y2 <= prof))
               or ((y1 >= Prof) and (y2 >= prof))
            then
               Intersection := false
            else
               x := ((x2-x1)*(Prof-y1)/(y2-y1)) + x1;
      end;

   begin
      { COPIER LA LISTE DE POLYGONES }
      if contrastes <> NIL
      then Dispose (Contrastes, fini);

      DupliquerModele (LeModele, Contrastes);

      { DECALER LES ORDONNEES DES POINTS DE EPSILON SI ELLES SONT SUR UNE LIMITE }
      for nr := 0 to Contrastes^.count-1
      do begin
         Roche := Contrastes^.at (nr);
         for np := 0 to Roche^.count-1
         do begin
            Point := Roche^.at (np);
            for c := 1 to NbCouches
            do begin
               if Point^.y = Couches [c].Profondeur
               then begin
                  if Roche^.y > Couches [c].Profondeur
                  then Point^.y := Point^.y + 2*Epsilon
                  else Point^.y := Point^.y - 2*Epsilon
               end;
            end;
         end;
      end;

      { AJOUTER LES POINTS CORRESPONDANTS AUX LIMITES }
      for nr := 0 to Contrastes^.count-1
      do begin
         Roche := Contrastes^.at (nr);
         np := 0;
         repeat
            Point := Roche^.at (np);
            Point2 := Roche^.at ((np + 1) mod Roche^.count);
            c:=1;
            coupe := false;
            repeat
               if Intersection (Point^.x, Point^.y, Point2^.x, Point2^.y,
                                Couches[c].Profondeur, ix)
               then begin
                  coupe := true;
                  NouveauPoint := new (PPoint, init);
                  NouveauPoint^.x := ix;
                  NouveauPoint^.y := Couches[c].Profondeur;

                  if np = Roche^.count
                  then
                     Roche^.Contour.Insert (NouveauPoint)
                  else
                     Roche^.Contour.AtInsert (np + 1, NouveauPoint);
               end;
               inc (c);
            until (c > NbCouches) or coupe;
            if not coupe then inc (np);
         until np = Roche^.count;
      end;

      { DECOUPER LES POLYGONES }
      repeat
         nr := 0;
         YaModif := false;
         while (not yamodif) and (nr < Contrastes^.count)
         do begin
            Roche := Contrastes^.at (nr);
            { Recherche d'un point limite }
            np := 0;
            Point0 := Roche^.at (np);
            repeat
               Point := Roche^.at (np);
               trouve := false;
               for c := 1 to NbCouches
               do begin
                  if Point^.y = Couches [c].Profondeur
                  then
                     Trouve := true;
               end;
               if not trouve
               then inc (np);
            until (np = Roche^.count) or trouve;

            if trouve
            then begin
               YaModif := true;

               if Point0^.y > Point^.y
               then begin
                  { RECHERCHE DU POINT LE PLUS PROCHE A DROITE (Point2) }
                  inc (np);
                  Point1 := Roche^.at (np);
                  abscisse := cor2;
                  Point2 := NIL;
                  repeat
                     if (Point1^.x > Point^.x) and (Point1^.x < abscisse)
                        and (Point1^.y = Point^.y)
                     then begin
                        abscisse := Point1^.x;
                        Point2 := Point1;
                     end;
                     np := (np+1) mod Roche^.count;
                     Point1 := Roche^.at (np);
                  until Point1 = Point;
                  if Point2 <> NIL
                  then begin
                     Point2Bis := new (PPoint, init);
                     PointBis  := new (PPoint, init);
                     Point2Bis^ := Point2^;
                     PointBis^  := Point^;
                     Point2^.y := Point2^.y + Epsilon;
                     PointBis^.y  := PointBis^.y  - Epsilon;
                     Point2Bis^.y := Point2Bis^.y - Epsilon;
                  end;
                  Point^.y  := Point^.y  + Epsilon;
               end else

               if Point0^.y < Point^.y
               then begin
                  { RECHERCHE DU POINT LE PLUS PROCHE A GAUCHE (Point2) }
                  np := Roche^.indexof (Point);
                  np := (np+1) mod Roche^.count;
                  Point1 := Roche^.at (np);
                  abscisse := cor1;
                  Point2 := NIL;
                  repeat
                     if (Point1^.x < Point^.x) and (Point1^.x > abscisse)
                        and (Point1^.y = Point^.y)
                     then begin
                        abscisse := Point1^.x;
                        Point2 := Point1;
                     end;
                     np := Roche^.indexof (Point1);
                     np := (np+1) mod Roche^.count;
                     Point1 := Roche^.at (np);
                  until Point1 = Point;
                  if Point2 <> NIL
                  then begin
                     Point2Bis := new (PPoint, init);
                     PointBis  := new (PPoint, init);
                     Point2Bis^ := Point2^;
                     PointBis^  := Point^;
                     Point2^.y := Point2^.y - Epsilon;
                     PointBis^.y  := PointBis^.y  + Epsilon;
                     Point2Bis^.y := Point2Bis^.y + Epsilon;
                  end;
                  Point^.y  := Point^.y  - Epsilon;
               end;

               {}
   {            NouvelleRoche := new (PRoche, init);
               np1 := Roche^.indexof (Point);
               np2 := Roche^.indexof (Point2);
               for np := 0 to np2-np1-1 do begin
                  n := (np+np1+1) mod Roche^.count;
                  NouvelleRoche^.insert (Roche^.at (n));
                  Roche^.AtDelete (n);
               end;
               NouvelleRoche^.insert (Point2Bis);
               NouvelleRoche^.insert (PointBis);}

               if Point2 <> NIL
               then begin
                  NouvelleRoche := new (PRoche, init);
                  np := Roche^.indexof (Point);
                  np := (np + 1) mod Roche^.count;
                  NouvelleRoche^.insert (Point2Bis);
                  NouvelleRoche^.insert (PointBis);
                  repeat
                     NouvelleRoche^.insert (Roche^.at (np));
                     np := (np + 1) mod Roche^.count;
                  until np = Roche^.indexof (Point2);
                  NouvelleRoche^.couleur := Roche^.couleur;
                  NouvelleRoche^.Densite := Roche^.Densite;
                  NouvelleRoche^.Borner;

                  Contrastes^.insert (NouvelleRoche);

                  { Effacer les points de la premire roche qui ont t }
                  {    transfrs sur la deuxime }
                  Point1 := Point;
                  np := Roche^.indexof (Point);
                  np := (np + 1) mod Roche^.count;
                  repeat
                     Roche^.AtDelete (np);
                     np := np mod Roche^.count;
                  until Roche^.at (np) = Point2;
                  Roche^.Borner;
               end;
            end;
            inc (nr);
         end;
      until not YaModif;

      { CALCUL DES CONTRASTES }
      np := 0;
      while np < Contrastes^.count
      do begin
         Roche := Contrastes^.at (np);
         c := 1;
         while (Roche^.y < Couches [c].Profondeur) do inc(c);

         { Si Bouguer (d=0) alors (Cont. = Valeur modle - densit eau)  }
         if Roche^.Densite = 0
         then
            Roche^.Densite := Couches [c].Densite - 1.03
         else
            Roche^.Densite := Roche^.Densite - Couches [c].Densite;

         if Roche^.Densite = 0
         then begin
            contrastes^.delete (Roche);
            dispose (Roche, fini)
         end else
            inc (np);
      end;
   end;

procedure Calculer;
   const
      K                 = 6.67E-3;

   var
      Poly              : PRoche;
      p1, p2            : PPoint;
      dx,
      x, y,
      Fac1, Fac2,
      ggg,  Alpha,
      Beta, Gamma,
      dx1, dx2,
      dy1, dy2,
      lg, ld,                       { limites 1/50 fentre.
                                      Au del -> extension des polygones }
      rg1, rg2,
      resg, supg        : real;
      F                 : text;
      np, npt,
      Station           : integer;
      ok                : boolean;
      CasG, CasD        : byte;

   procedure arct (rn, d : real; var r : real);
   {----------------------------------------------------------------------}
   {----------------------------------------------------------------------}
   begin
      if d = 0
      then begin
         if rn = 0 then r:=0;
         if rn < 0 then r := -pi/2;
         if rn > 0 then r:=pi/2;
      end else
         if d>0
         then
            r := arctan (rn/d)
         else
            if rn>=0
            then
               r := arctan(rn/d)+pi
            else
               r := arctan(rn/d)-pi;
   end;

   procedure difarc (n1, d1, n2, d2 : real; var res : real);
   {----------------------------------------------------------------------}
   {----------------------------------------------------------------------}
   var
      r1, r2, r3        : real;

   begin
      arct (n1, d1, r1);
      arct (n2, d2, r2);
      r3 := r1-r2;
      if abs (r3) <= pi
      then
         res := r3
      else
         if r3<0
         then
            res := r3+2*pi
      else
         res := r3-2*pi;
   end;

   procedure calc (xx1, yy1, xx2, yy2 : real);
   {----------------------------------------------------------------------}
   {----------------------------------------------------------------------}
   begin
      dx1 := xx1 - x;
      dy1 := yy1 - y;
      rg1 := dx1*dx1+dy1*dy1;
      dx2 := xx2 - x;
      dy2 := yy2 - y;
      rg2 := dx2*dx2+dy2*dy2;

      Alpha := dx2-dx1;
      Beta  := dx1*dy2-dx2*dy1;
      gamma := dy2-dy1;

      if beta=0
      then
         supg := 0
      else begin
         Difarc (dy1, dx1, dy2, dx2, resg);
         fac1 := Beta/(Alpha*Alpha+Gamma*Gamma);
         Fac2 := Alpha*Resg + Gamma*ln(rg2/rg1)/2;
         supg := fac1*fac2;
      end;

      ggg := ggg+supg;
   end;

   begin
      laide (la_calcul);
      calculok := true;
      MontrerSouris;
      ChangerCurseur (Sablier);

      GenererContrastes;
{      contrastes := lemodele;}

      { MISE A ZERO DE L'ANOMALIE }
      for station := 1 to NbStations
      do
         Anomalie^[Station] := 0;

      { POUR CHAQUE POLYGONE p }
      for np := 1 to Contrastes^.count
      do begin
         Poly := Contrastes^.at (np-1);
         { POUR CHAQUE STATION s }
         for Station := 1 to NbStations
         do begin
            x := StationX^[Station];
            y := StationY^[Station];

            ggg := 0;

            { CALCUL POUR CHAQUE POINT i (Gp) }
            for npt := 1 to Poly^.count
            do begin
               p1 := Poly^.at (npt-1);
               p2 := Poly^.at (npt mod Poly^.count);
(*               lg := fc1+((fc2-fc1)/50);
               ld := fc2-((fc2-fc1)/50); *)

               { lg = limite gauche au del de laquelle la structure }
               {       est tire. ld = limite droite.               }
               lg := cor1+ 2*(StationX^[2]-StationX^[1]);
               ld := cor2- 2*(StationX^[2]-StationX^[1]);
               dx := (cor2-cor1);

               CasG := byte (P1^.x <= lg) + 2*byte (P2^.x <= lg);
               CasD := byte (P1^.x >= ld) + 2*byte (P2^.x >= ld);

               { si un point a gauche }
               if CasG > 0
               then begin
                  case CasG of
                     { seulement premier point  gauche }
                     1 : Calc (P1^.x-dx, P1^.y, P1^.x,    P1^.y);
                     { seulement deuxime point  gauche }
                     2 : Calc (P2^.x,    P2^.y, P2^.x-dx, P2^.y);
                     { deuxime point seulement  gauche }
                     3 : Calc (P1^.x-dx, P1^.y, P2^.x-dx, P2^.y);
                  end;
                  { Calcul du segment normal si chevauchement }
                  if CasG <> 3
                  then
                     Calc (P1^.x, P1^.y, P2^.x, P2^.y);

               end else begin
                  case CasD of
                     { seulement premier point  droite }
                     1 : Calc (P1^.x+dx, P1^.y, P1^.x,    P1^.y);
                     { seulement deuxime point  droite }
                     2 : Calc (P2^.x,    P2^.y, P2^.x+dx, P2^.y);
                     { deuxime point seulement  droite }
                     3 : Calc (P1^.x+dx, P1^.y, P2^.x+dx, P2^.y);
                  end;
                  { Calcul du segment normal si chevauchement }
                  if CasD <> 3
                  then
                     Calc (P1^.x, P1^.y, P2^.x, P2^.y);
               end;
            end;

            { MISE A JOUR DE L'ANOMALIE POUR UNE STATION }
            anomalie^[station] := anomalie^[station] - 40*(ggg * Poly^.Densite)/3;
         end;
      end;

      changerCurseur (fleche);
      CacherSouris;
      if modicomm
      then
         Effacer_tout_redessiner
      else
         dess_modele (false);
      laide ('');
   end;

procedure affiche_legende (trac : boolean);
   var
      px, py            : integer;

   begin
      setusercharsize (4, 3 ,4, 3);
      if trac
      then
         taille_car_trac (0, 0, 4);

      chain := n_ano;
      fixecoul       (c_texte2);
      px := posxbtn+2;
      py := py_legend;
      outtextxy   (px, py, chain); { traceur et/ou cran }

      chain := n_anocalc ;
      fixecoul       (c_courbe1);
      fixetrait      (traitc1);
      outtextxy   (px+30, py+15 , chain); { traceur et/ou cran }
      line        (px,    py+25, px+25, py+25);

      chain := n_anoobs ;
      fixecoul       (c_courbe2);
      fixetrait      (traitc2);
      outtextxy   (px+30, py+26, chain); { traceur et/ou cran }
      setusercharsize (3, 2, 3, 2);
      line        (px,    py+36, px+25, py+36);
   end;

function PolyFlotte (R : PRoche) : boolean;
   begin
      str (R^.densite:4:2, chain);
      PolyFlotte := (chain = '0.00') or (chain = '1.03');
   end;

procedure choix_params;
   var
      Boite             : PBoiteSaisie;
      zr                : PZoneReel;
      PosCur,
      Touche,
      i                 : integer;

   begin
      laide (aidedit);
      str (nbcouches , chain);
      repeat
         Saisie (s_nb_couches, chain, 1);
         val (chain, NbCouches, entier);
      until (NbCouches > 0) and (NbCouches <= 5);

      for i := 1 to 4
      do
         if Couches [i+1].Profondeur >  Couches [i].Profondeur
         then
            Couches [i+1].Profondeur := Couches [i].Profondeur;

      boite := new (PBoiteSaisie,
               init ( milieu, milieu, 15,  CoulBoite, 0,
                      t_structure));

      for i := 1 to NbCouches
      do begin
         str (i, chain);
         zr    := new (PZoneReel,
                       init (  0,   0,   6, 1, 0, 15, @Couches [i].Profondeur,
                       b_profondeur+chain, unitl));
         boite^.ajoute (zr);
         zr    := new (PZoneReel,
                       init (  0,   0,   4, 2, 0, 15, @Couches [i].Densite,
                       b_densite+chain, ''));
         boite^.ajoute (zr);
      end;

      boite^.editeF (1, Poscur, Touche);

      laide ('');

      if Couches [1].Densite < 1
      then
         Couches [1].Densite := 1;

      for i := 1 to 4
      do begin
         if Couches [i+1].Densite < 1
         then
            Couches [i+1].Densite := 1;

         if Couches [i+1].Profondeur >  Couches [i].Profondeur
         then
            Couches [i+1].Profondeur := Couches [i].Profondeur;
      end;

      boite^.vider;
      dispose (boite, fini);

      cor3 := Couches [NbCouches].Profondeur;
{      fc3  := cor3;}
      retailler;
   end;

procedure choix_params_legende (var cc1, cc2, cc3, cc4, cc5, tt1, tt2 : byte;
                                var r : real;
                                var g : boolean);
   var
      i,
      touche, poscur    : integer;
      r1                : real;
      t1,  t2,
      co1, co2,
      co3, co4, co5     : byte;
      b1                : boolean;
      zb1               : PZoneBooleen;
      z1                : PZoneReel;
      zc1, zc2,
      zc3, zc4, zc5     : Pzonecouleur;
      boite             : PBoiteSaisie;

   begin
      co1 := cc1;
      co2 := cc2;
      co3 := cc3;
      co4 := cc4;
      co5 := cc5;
      t1  := tt1;
      t2  := tt2;
      b1  := g;
      r1  := r;

      { couleur }
      Zs1    := new (PZoneSymboles,
                init (0, 0, fondmenu, coulboite, @tt1,
                b_c_calc, '', DessinerTraits, @cc1));
      Zs1^.Cnom  := txtmenu;
      Zs1^.NbSmb := 2;

      Zc1    := new (PZoneCouleur,
                init (22*tx, 5*ty div 2,                 @cc1,
                '      ', '', pal));
      Zc1^.Cnom := colorf;


      Zs2    := new (PZoneSymboles,
                init (0, 0, fondmenu, coulboite, @tt2,
                b_c_obs, '', DessinerTraits, @cc2));
      Zs2^.Cnom  := txtmenu;
      Zs2^.NbSmb := 2;

      Zc2    := new (PZoneCouleur,
                init (22*tx,  4* ty,                     @cc2,
                '      ', '', pal));
      Zc2^.Cnom := colorf;

      Zc3    := new (PZoneCouleur,
                init (0,      0,                         @cc3,
                b_relief, '', pal));
      Zc3^.Cnom := colorf;

      Zc4    := new (PZoneCouleur,
                init (0,      0,                         @cc4,
                b_foyers, '', pal));
      Zc4^.Cnom := colorf;

      Zc5    := new (PZoneCouleur,
                init (0,      0,                         @cc5,
                b_bord_poly, '', pal));
      Zc5^.Cnom := colorf;

      z1     := new (PZoneReel,
                init (0,      0,  5,  2,  txtmenu, fondmenu,  @r,
                b_rapport, ''));

{      zb1    := new (PZoneBooleen,
                init (0,      0,  txtmenu, fondmenu,          @g,
                'Graduation automatique ' , ''));
}      boite  := new (PBoiteSaisie,
                init (milieu, milieu, 15,      fondnorm, txtnorm,
                t_autres));
      { diter le tout }
      poscur := 1;
      boite^.ajoute (zs1);
      boite^.ajoute (zc1);
      boite^.ajoute (zs2);
      boite^.ajoute (zc2);
      boite^.ajoute (zc3);
      boite^.ajoute (zc4);
      boite^.ajoute (zc5);
      boite^.ajoute (z1);

      laide (aidedit);
      boite^.editeF (1, Poscur, Touche);
      laide ('');

      boite^.vider;
      dispose (boite, fini);

      if (touche = ESC) {or (touche = 0)}
      then begin
         r   := r1;
         cc1 := co1;
         cc2 := co2;
         cc3 := co3;
         cc4 := co4;
         cc5 := co5;
         tt1 := t1;
         tt2 := t2;
      end;                                 { rtablir les valeurs initiales }
   end;

procedure choix_params_axes (var cc1, cc2, cc3, tt1 : byte);
   var
      i,
      touche, poscur    : integer;
      t1,
      co1, co2, co3     : byte;
      zc1, zc2, zc3     : Pzonecouleur;
      boite             : PBoiteSaisie;

   begin
      co1 := cc1;
      co2 := cc2;
      co3 := cc3;
      t1  := tt1;

      { couleur }
      Zs1    := new (PZoneSymboles,
                init (0, 0, fondmenu, coulboite, @tt1,
                b_limites, '', DessinerTraits, @cc1));
      Zs1^.Cnom  := txtmenu;
      Zs1^.NbSmb := 2;

      Zc1    := new (PZoneCouleur,
                init (26*tx, 5*ty div 2,                 @cc1,
                '', '', pal));
      Zc1^.Cnom := colorf;


      Zc2    := new (PZoneCouleur,
                init (0,  0,                             @cc2,
                b_bord_fen, '', pal));
      Zc2^.Cnom := colorf;

      Zc3    := new (PZoneCouleur,
                init (0,      0,                         @cc3,
                b_axes, '', pal));
      Zc3^.Cnom := colorf;

      boite  := new (PBoiteSaisie,
                init (milieu, milieu, 15,      fondnorm, txtnorm,
                t_axes));
      { diter le tout }
      poscur := 1;
      boite^.ajoute (zs1);
      boite^.ajoute (zc1);
      boite^.ajoute (zc2);
      boite^.ajoute (zc3);

      laide (aidedit);
      boite^.editeF (1, Poscur, Touche);
      laide ('');

      boite^.vider;
      dispose (boite, fini);

      if (touche = ESC) {or (touche = 0)}
      then begin
         cc1 :=  co1;
         cc2 :=  co2;
         cc3 :=  co3;
         tt1 :=  t1;
      end;                                 { rtablir les valeurs initiales }
   end;

procedure recalc_ecran;
   begin
      if (coef_x <> 1)
      then begin
         maxc1   := round (maxc1   * coef_x);
         maxc2   := round (maxc2   * coef_x);
         cc1     := round (cc1     * coef_x);
         cc2     := round (cc2     * coef_x);
      end;
      if (coef_y <> 1)
      then begin
         maxc3   := round (maxc3   * coef_y);
         maxc4   := round (maxc4   * coef_y);
         cc3     := round (cc3     * coef_y);
         cc4     := round (cc4     * coef_y);
         cc5     := round (cc5     * coef_y);
         cc6     := round (cc6     * coef_y);
      end;
      coef_c := (cc2-cc1) / (cc4-cc3);
   end;

procedure cadrer;
   { SI cc2<= cc1 ou cc4<=cc3 ou hors limites...
     calcule cc2 et cc4 en fonction
         de la position du coin bas-gauche ( cc1, cc3 dans .PAR)
         et de l'extension maxi clture (maxC2, maxC4 dans .CFG)            }
   var
      coeff, coefc      : real;

   begin
      cc1 := maxc1;
      cc2 := maxc2;
      cc3 := maxc3;
      cc6 := maxc4;

      cc4 := trunc(2*(cc6-cc3)/3) + cc3;
      cc5 := cc4 + 2*ty;

      if (echelle1) or ((cc2 <= cc1) or (cc6 <= cc3))
      then begin
         echelle1 := true;
           {+  2*(StationX^[2]-StationX^[1])}
         coeff := (fc2  - fc1)  / (fc4   - fc3) * (coef_x / coef_y);
{         coefc := (maxc2 - cc1) / (maxc4 - cc3); }
         coefc := (maxc2 - cc1) / (cc4 - cc3);
         if (coeff > coefc)
         then begin
            cc2 := maxc2;
            cc3 := cc4 - round ((maxc2-cc1) / coeff)
         end else begin
            cc3 := maxc3;
            cc2 := cc1 + round ((cc4-cc3) * coeff)
         end;
      end;
      recalc_ecran;
   end;

procedure inicoul_cfg;
   begin
      geo_des.inicoul_cfg;
   end;

procedure libere_mem;
   begin
      liberer_jeu_symb (1);
{      liberer_jeu_symb (2);}
      liberer_jeu_symb (3);
      liberericones;
{      liberermodele           }
{      liberercourbes          }
      params.fini;
      parini.fini;
      liberer_commentaires;
   end;

procedure finir;
   begin
    {  restorecrtmode;
      ecrantexte;     }
      libere_mem;
   end;

procedure effmodele;
  begin
      pleinecloture;
      coulbar (SolidFill, coulecran);
      bar (cc1, maxy-cc6, maxc2, maxy-maxc3);
   end;

procedure efface_modele;
   begin
      if ecran then effmodele;
   end;

procedure Libere_modele;
   begin
      if LeModele   <> NIL then dispose (LeModele,   fini);
      if Contrastes <> NIL then dispose (Contrastes, fini);
      LeModele      := NIL;
      Contrastes    := NIL;
      RocheCourante := NIL;
   end;

procedure efftout;
   begin
      ecran := true;
      geo_des.effacer_commentaires;

      liberer_commentaires;
      Libere_modele;
      params.fini;
   end;

procedure dessymb (s : integer ; h : real; co : word);
   begin
      fixecoul  (co);
      initialiser_parametres_courants (3, h,   0,   0, 32);
                                    { fonte, taille, dir, incl, rf hauteur }
      dessine_un_symb (s);
   end;

procedure dess_sismi ;
   var
      fentree           : text;
      h_s, l, z, m      : real;
      nomf              : pathstr;

   begin
      nomf := nomfd+extvs;
      if exempl
      then
         nomf := cheminexemples+region+'\'+nomf;

    {  if exo
      then
         nomf := chemindonnees+repexo+nomf;}

      if not ftxt_present (nomf)
      then
          exit;

      assign (fentree, nomf);
      reset  (fentree);
      while  (not (eof (fentree)))
      do begin
         readln (fentree, l, z, m);
         while (not (eof (fentree))) and (Dans_Fenetre (l, z))
         do begin
            deplaceenl (l, z);
            {!! recalculer la hauteur en fonction de m }
            h_s := h_min + (h_max - h_min) * (m - 4) / (9 - 4);
            dessymb (codasks, h_s, c_symb);
            readln  (fentree, l, z, m);
         end;
      end;
      close (fentree);
   end;

procedure dess_couches;
   var
      c              : integer;
      toit           : real;

   begin
      toit := 0;
      fixetrait (traitlimite);
      fixecoul  (c_couche);
      for c := 1 to NbCouches
      do begin
         if c > 1
         then
            toit := Couches[c-1].profondeur;
         { Limite de la couche }
         DeplaceEn (fc1, Couches[c].profondeur);
         TraceVers (fc2, Couches[c].profondeur);
         { Densit  gauche si texte entre dans la fentre }
        (* if  (Couches[c].profondeur+     2/yrap > fc3)
         and (Couches[c].profondeur+(ty+2)/yrap < fc4)
         then begin
            setusercharsize (5, 4 ,5, 4);
            if traceur then  taille_car_trac (0, 0, 4);
            str (Couches[c].densite:0:2, chain);
            DeplaceEnL (fc1+2/xrap, Couches[c].profondeur+2/yrap);
            TTexte (chain, 0, 0);
         end; *)
         {Densit  droite }
         if  (Couches [c].profondeur+     2/yrap > fc3)
         and (Couches [c].profondeur+(ty+2)/yrap < fc4)
         then begin
         {   fixecoul  (c_courbe1);}
            setusercharsize (5, 4 ,5, 4);
            if traceur
            then
               taille_car_trac (0, 0, 4);
            str (Couches [c].densite:0:2, chain);
            DeplaceEnL (fc2-2/xrap, (toit+Couches [c].profondeur)/2 {+2/yrap});
            TTexte (chain, 2, 0);
         end;
      end;
      setusercharsize (3, 2 ,3, 2);

      { tracer limite droite du modle }
      fixetrait (2);
      fixecoul  (c_axex);
      DeplaceEn (cor1+StationX^ [NbStations]+2*(StationX^[2]-StationX^[1]), fc3);
      TraceVers (cor1+StationX^ [NbStations]+2*(StationX^[2]-StationX^[1]), fc4);
      fixetrait (0);
   end;

procedure ajoute_grille (trac, eff : boolean);
   var
      ixx, ixy          : real;

   begin
      if gradauto
      then begin
         ixx   := 0;
         ixy   := 0;
      end else begin
         ixy   := inter_xy;
         ixx   := ixy/2;
      end;
      fenetrecloturecrantrac (trac);
      fixetrait (traitgrille);
      if eff
      then
         fixecoul (coulboite)
      else
         fixecoul (c_grille);
      fixetrait      (traitgrille);
      dessine_lignes (ixx, ixy);
      fixetrait (0);
      pleinecrantrac  (trac);
   end;

procedure dessine_suite;
   { axes, bordure, lignes de rappel et graduation interne complte }
   {                VISULIGNES          LEGEND                      }

   const
      tiret             = 4;
      posx              = 1;
      posy              = 1;
      post              = 4;
      extx              = 1;

   var
      ixx, ixy          : real;
      nbdec             : integer;
      txtmodel          : t12; { texte affich dans la fentre modle     }

   begin
      if gradauto
      then begin
         ixy   := 0;
         ixx   := 0;
         nbdec := 0;
      end else begin
         ixy   := inter_xy;
         ixx   := ixy/2;
         nbdec := nbdec_xy;
      end;
      fixetrait (0);
      fixecoul  (c_axex);
      axes;
      bordure   (c_bord);

      dess_couches;

      if visugrille
      then begin
         fixetrait (traitgrille);
         fixecoul  (c_grille);
         dessine_lignes (ixx, ixy);
      end;
      fixetrait (0);
      fixecoul  (c_axex);

      if visudensite
      then
         txtmodel := n_densite
      else
         txtmodel := n_Contrastes;
      gradueplt (ixx,      ixy,     tiret,
                 0, nbdec, 0, nbdec,
                 unitxy,   unitxy,  txtmodel,
                 posx,     posy,    post,
                 extx,     exty );

      fixetrait (0);
      bordure   (c_bord);

      if visuseismes
      then
         dess_sismi;
   end;

procedure ini_par_ecr;
   begin
      maxc1        := 1;           { extension maxi clture }
      maxc2        := posxbtn-4;   { laisser place pour cadre icnes}
      maxc3        := 2*ty+4;
      maxc4        := maxy -hauteurmenu -ty div 3;
   end;

procedure dess_icones;
   var
      i                 : integer;

   begin
      for i := 1 to 22
      do
         Active_dess_icone (i);
   end;

procedure InifondEcran;
   begin
      ini_par_ecr;
      inicoul_cfg;
      fond_ecran (coulecran);
      affichemenu;                                                 { menus1 }
      dess_icones;
      ini_titre;                                     { affiche titre rgion }
      ini_format (formatpapier) ;   { initialise format de papier / traceur }
   end;

procedure IniEcran;
   begin
      cadrer;                   { cadrer et recalculer les cltures /coef_y }
      inietat ;                           { crit infos sur la ligne d'tat }
   end;

procedure IniModele;
   function ParamsModifies : boolean;
      begin
         ParamsModifies := ((Couches [1].densite <> dc1)
                           and (Couches [1].profondeur <> pc1))
                        or ((Couches [2].densite <> dc2)
                           and (Couches [2].profondeur <> pc2))
                        or ((Couches [3].densite <> dc3)
                           and (Couches [3].profondeur <> pc3))
                        or (nbcouches <> 3);
      end;

   begin
      if not ParamsModifies
      then begin
         choix_params; {  lancer systmatiquement avec un Nouveau }
         Dezoomer;
         redess_modele (false)
      end
   end;

procedure fond_boite ;
   begin
      if ecran
      then begin
         coulbar (1, coulboite);
         bar (0, 0, cc2-cc1, cc4-cc3);
      end;
   end;

procedure fond_boite2;
   {-----------------------------------------------------------------}
   {-----------------------------------------------------------------}
   begin
      if ecran
      then begin
         coulbar (1, coulboite);
         bar (0, 0, cc2-cc1, cc6-cc5);
      end;
   end;

procedure fond_boite3;
   {-----------------------------------------------------------------}
   {-----------------------------------------------------------------}
   begin
      if ecran
      then begin
         coulbar (1, coulecran);
         bar (0, 0, cc2-cc1, cc5-cc4-6);
      end;
   end;

procedure dess_profil_sismi (trac : boolean);
   begin
      fenetrecloturecrantrac (trac);
      dess_sismi;
      pleinecrantrac (trac);
   end;

procedure efface_constante;
   begin
      PleineCloture;
      coulbar (1, coulecran) ;
      bar     (posxbtn, py_legend+45,
               maxx,    py_legend+45+15);
      fenetre (fc1, fc2, fc5, fc6);
      cloture (cc1, cc2, cc5, cc6);
   end;

procedure affiche_constante (c : real);
   begin
      PleineCloture;
      setusercharsize (1, 1, 1, 1);
      if translate
      then begin
         fixecoul (c_courbe1);
         str (DeltaAnomalie:8:1, chain)
      end else begin
         fixecoul (c_texte);
         str (DeltaConst:8:1, chain);
      end;
      chain := n_Cte+ ' : ' +chain+' '+unitg;
      settextjustify (0, 2);
      outtextxy   (posxbtn, py_legend+45, chain); { traceur et/ou cran }
      setusercharsize (3, 2, 3, 2);
      fenetre (fc1, fc2, fc5, fc6);
      cloture (cc1, cc2, cc5, cc6);
   end;

procedure dess_courbes (trac : boolean);
   const
      tiret             = 4;
      posx              = 1;
      posy              = 1;
      post              = 3;    { titre en B  D }
      extx              = 1;    { intr }
      exty              = 2;    { extr }

   var
      Station
                        : integer;
      GMaxi, GMini,
      MoyCalc, MoyMesu  : real;
      ixy               : real;
      NbDec             : integer;

   procedure PrepCalcul;
      var
         station        : integer;

      begin
         { CALCUL DES MOYENNES POUR TRANSLATION }
         MoyCalc := 0;
         MoyMesu := 0;
         for Station := 1 to NbStations
         do begin
            MoyCalc := MoyCalc + (Anomalie^[Station]/NbStations);
            if calculok
            then
               MoyMesu := MoyMesu + (Mesure^[Station]  /NbStations);
         end;
         if calculok
         then begin
            DeltaAnomalie := MoyMesu - MoyCalc;
            calculok := false;
         end;

         { TRANSLATION DE L'ANOMALIE CALCULEE }
         if translate
         then
            for Station := 1 to NbStations
            do
               Anomalie_t^[Station] := Anomalie^[Station] + DeltaAnomalie
         else
            for Station := 1 to NbStations
            do
               Anomalie_t^[Station] := Anomalie^[Station] + DeltaConst;

         { CALCUL DU MINI ET MAXI }
         GMaxi := anomalie^[1];
         GMini := GMaxi;
         for Station := 1 to NbStations
         do begin
            if anomalie_t^[Station] > GMaxi then GMaxi := anomalie_t^[Station];
            if anomalie_t^[Station] < GMini then GMini := anomalie_t^[Station];
            if Mesure^[Station]   > GMaxi then GMaxi := Mesure^[Station];
            if Mesure^[Station]   < GMini then GMini := Mesure^[Station];
         end;
         GMaxi := GMaxi + 0.1 * (GMaxi-GMini);
         GMini := GMini - 0.1 * (GMaxi-GMini);
      end;

   procedure affichercalcul;
      var
         station        : integer;

      begin
         { AFFICHAGE DANS LA CLOTURE COURANTE }
         DeplaceEn (StationX^[1], Anomalie_t^[1]);
         fixetrait (traitc1);
         fixecoul  (c_courbe1);
         for Station := 2 to NbStations
         do
            Tracevers (StationX^[Station], Anomalie_t^[Station]);

         DeplaceEn (StationX^[1], Mesure^[1]);
         fixetrait (traitc2);
         fixecoul  (c_courbe2);
         for Station := 2 to NbStations
         do
            Tracevers (StationX^[Station], Mesure^[Station]);

         fixetrait (0);
         fixecoul  (c_err);
         for Station := 1 to NbStations
         do begin
            DeplaceEn (StationX^[Station], Mesure^[Station]-Ecart^[Station]);
            TraceVers (StationX^[Station], Mesure^[Station]+Ecart^[Station]);
         end;
(*
 { rc : pour ne pas prendre en compte les stations des extrmits
             et minimiser les effets des structures latrales hors profil     }

         { AFFICHAGE DANS LA CLOTURE COURANTE }
         DeplaceEn (StationX^[2], Anomalie^[2]);
         fixetrait (traitc1);
         fixecoul (coulcourbe1);
         for Station := 3 to NbStations-1
         do
            Tracevers (StationX^[Station], Anomalie^[Station]);

         DeplaceEn (StationX^[2], Mesure^[2]);
         fixetrait (traitc2);
         fixecoul (coulcourbe2);
         for Station := 3 to NbStations-1
         do
            Tracevers (StationX^[Station], Mesure^[Station]);

         fixetrait (0);
         fixecoul (coulerreur);
         for Station := 2 to NbStations-1
         do begin
            DeplaceEn (StationX^[Station], Mesure^[Station]-Ecart^[Station]);
            TraceVers (StationX^[Station], Mesure^[Station]+Ecart^[Station]);
         end;
         *)
      end;

   procedure ecrire_legende;
      var
         mx, my         : real;

      begin
         efface_constante;
         affiche_constante (deltaanomalie);

         { tracer limite droite du modle }
         fixetrait (2);
         fixecoul  (c_axex);
         DeplaceEn (cor1+StationX^ [NbStations]+2*(StationX^[2]-StationX^[1]), fc5);
         TraceVers (cor1+StationX^ [NbStations]+2*(StationX^[2]-StationX^[1]), fc6);
         fixetrait (0);
      end;

   begin
      if gradauto
      then begin
         ixy   := 0;
         nbdec := 0;
      end else begin
         ixy   := inter_xy;
         nbdec := nbdec_xy;
      end;

      ecrantrac (trac);

      PrepCalcul;

      fc5 := GMini;
      fc6 := Gmaxi;

      fenetre (fc1, fc2, fc5, fc6);
      cloture (cc1, cc2, cc5, cc6);
      fond_boite2;
      fixetrait (0);
      fixecoul  (c_axex);
      axes;
      AfficherCalcul;
      fixecoul  (c_axex);
      ixy := 0;
      gradueplt (ixy, ixy, tiret,
                 0, nbdec, 0, nbdec,
                 unitxy,  unitg, '',
                 posx,    posy,  post,
                 extx,    exty );
      Ecrire_legende;
      Bordure   (C_bord);
      pleinecrantrac (trac);
   end;

procedure dess_relief (trac : boolean);
   var
      ld                : string;

      Station
                        : integer;
      GMaxi, GMini,
      fc8, fc7
                        : real;

   function longitud (a : real) : string;
      begin
         if (a > 0)
         then ld := 'E'
         else Ld := 'W';
         longitud := ld;
      end;

   function latitud  (a : real) : string;
      begin
         if (a > 0)
         then ld := 'N'
         else Ld := 'S';
         latitud := ld;
      end;

   procedure aff_extremites;
      var
         l              : string;
         nbc, nbd       : integer;
         mx, my,
         coef_hl        : real;

      begin
         setusercharsize (5, 4, 5, 4);
         nbc := 4;
         nbd := 1;
         fixecoul   (c_bord);
         l := longitud (x1);
         formater   (x1, nbc, nbd, chain) ;
         deplaceenl     (fc1 ,   (fc8-fc7)/2 );
        { ttexte   (n_Long+' : '+chain+ ' '+ u_angle , 0, 0);}
         ttexte   (chain+' '+l , 0, 0);
                          { traceur et/ou cran }

         l := latitud (y1);
         formater   (y1, nbc, nbd, chain) ;
         deplaceenl     (fc1,   (fc8-fc7)/2 );

{         ttexte   (n_lat+' : '+chain+ ' '+ u_angle , 0, 2);}
         ttexte   (chain+ ' '+ l , 0, 2);
                  { traceur et/ou cran }

         l := longitud (x2);
         formater   (x2, nbc, nbd, chain) ;
         deplaceenl     (fc2,   (fc8-fc7)/2);
 {        ttexte   (chain, 2, 0);       }
         ttexte   (chain+' '+l, 2, 0);           { traceur et/ou cran }

         l := latitud (y2);
         formater   (y2, nbc, nbd, chain) ;
         deplaceenl     (fc2,   (fc8-fc7)/2);
{         ttexte   (chain, 2, 2);        }
         ttexte   (chain+' '+l, 2, 2);           { traceur et/ou cran }
         setusercharsize (3, 2, 3, 2);
      end;

   procedure afficher;
      var
         station        : integer;

      begin
         { AFFICHAGE DANS LA CLOTURE COURANTE }
         DeplaceEn (StationX^[1], StationY^[1]);
         fixecoul  (c_carte);
         for Station := 2 to NbStations
         do
            Tracevers (StationX^[Station], StationY^[Station]);
      end;

   begin
      ecrantrac (trac );

      fc8 := 0;
      for Station := 1 to NbStations
      do begin
         if StationY^[Station] > fc8
         then
            fc8 := StationY^[Station];
      end;
      fc7 := 0;

      if fc8 <> 0
      then begin
         ok := true
      end else begin
         ok := false;
         fc8 := 100;
{         fenetre (fc1, fc2, fc7, fc8);
         cloture (cc1, cc2, cc4+3, cc5-3);
         fond_boite3;
         if not exo then Aff_extremites;}
      end;
      fenetre (fc1, fc2, fc7, fc8);
      cloture (cc1, cc2, cc4+3, cc5-3);
      fond_boite3;
      if ok then Afficher;
     { if not exo
      then}
         Aff_extremites;

      pleinecrantrac (trac);
  end;

procedure dess_densites (trac : boolean);
{--------------------------------------------------------------------}
{--------------------------------------------------------------------}
   procedure Appel (R : PRoche); far;
      begin
         if trac
         then begin
            R^.Dessiner;
            fixecoul (R^.Couleur);
         end else begin
            fixecoul (c_poly);
            if not copie_en_cours
            then
               R^.Peindre
            else
               R^.dessiner;
         end;

         if affnumero
         then begin
            str (LeModele^.indexof (R) + 1, chain);
            R^.Afficher (chain, c_texte)
         end else begin
            str (R^.densite:4:2, chain);
            R^.Afficher (chain, c_texte);
         end;

(*         setusercharsize (4, 3, 4, 3);
         DeplaceEnT (R^.x, R^.y);
         TTexte (chain, 1, 1);
         setusercharsize (1, 1, 1, 1); *)
      end;

   begin
      if LeModele <> NIL
      then
         LeModele^.ForEach (@Appel);
   end;

procedure dess_Contrastes (trac : boolean);
   {--------------------------------------------------------------------}
   {--------------------------------------------------------------------}
   const
      { dgrad de trame pour les contrastes }
      gris : array [1..5] of fillpatterntype =
             ( ($FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF),
               ($FF, $DD, $FF, $77, $FF, $DD, $FF, $77),
               ($55, $AA, $55, $AA, $55, $AA, $55, $AA),
               ($00, $22, $00, $88, $00, $22, $00, $88),
               ($00, $20, $00, $02, $00, $20, $00, $02) );

   procedure AppelM (R : PRoche); far;
      { dessiner uniquement les contours }
      begin
         if not trac
         then begin
            fixecoul (R^.Couleur);
            R^.Dessiner;
         end;
      end;

   procedure Appel (R : PRoche); far;
      { dessiner les polygones en contrastes }
      var
         c           : byte;

      begin
         if trac
         then begin
            fixecoul (R^.Couleur);
            R^.Dessiner;
         end else begin
            c := 1;
            while (R^.y < Couches [c].Profondeur) do inc (c);

            setfillpattern (gris [c], R^.Couleur);
            setfillstyle   (UserFill, R^.Couleur);

            fixecoul (C_poly);
            if not copie_en_cours
            then
               R^.Effacer
            else
               R^.dessiner;
            fixecoul (C_bord);
         end;

         if affnumero
         then
            str (Contrastes^.indexof (R) + 1, chain)
         else
            str (R^.densite:4:2, chain);

         DeplaceEnL (R^.x, R^.y);
         TTexte (chain, 1, 1);
      end;

   begin
      if LeModele   <> NIL then LeModele^.ForEach   (@AppelM);
      if Contrastes <> NIL then Contrastes^.ForEach (@Appel);
   end;

procedure dess_modele (trac : boolean);
   begin
      affiche_legende (false);
      ecrantrac (trac);

      fenetre (fc1, fc2, fc3, fc4);
      Efface_modele;
      eff_densite;
      cloture (cc1, cc2, cc3, cc4);
      fond_boite;

      if visudensite
      then
         dess_densites (trac)
      else
         dess_contrastes (trac);

      dessine_suite;
      dess_courbes (trac);
      dess_relief  (trac);


      if VisuDensite and ecran and not copie_en_cours
      then
         MarquerRocheCourante;

      pleinecrantrac (trac);
   end;

procedure SelectionneRoche;
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
var
   Roche                : PRoche;
   x, y,
   nr                   : integer;
   xx, yy               : real;

begin
   LirePositionSouris (x, y);
   fenetre (fc1, fc2, fc3, fc4);
   Cloture (cc1, cc2, cc3, cc4);
   DemarquerRocheCourante;
   xx := XUtilisateur (x);
   yy := YUtilisateur (y);
   if visudensite
   then
      RocheCourante := LeModele^.PolyContenant (xx, yy)
   else
      RocheCourante := Contrastes^.PolyContenant (xx, yy);
   if ecran
   then
      MarquerRocheCourante;
   PleineCloture;
end;

procedure aff_densite (t1, t2 : t12; ctxt : word);
   var
      px, py            : integer;

   begin
      { effacer }
      px  := posxbtn+2;
      py  := py_densite;{hauteurmenu+42 + 33*4 +4;}
      if ecran
      then begin
         coulbar (1, coulecran);
         bar     (px, py, maxx, py+15);
      end;
      { texte }
      px  := (maxx+posxbtn+2) div 2;
      fixecoul (c_texte2);
      setusercharsize (1, 1, 1, 1);
      settextjustify (1, 1 );
      py := py + 7;
      outtextxy (px , py, t1+t2);
{      py := py + 15;
      outtextxy (px , py, t2);}
      setusercharsize (3, 2, 3, 2);
      settextjustify (0, 2);
   end;

procedure eff_densite ;
   var
      px, py            : integer;

   begin
      { effacer }
      px  := posxbtn+2;
      py  := py_densite; {hauteurmenu+ 42 + 33*4 +4;}
      coulbar (1, coulecran) ;
      bar     (px, py, maxx, py+15);
   end;

procedure MarquerRocheCourante;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      if RocheCourante <> NIL
      then begin
         fixecoul(c_poly);
         fenetre (fc1, fc2, fc3, fc4);
         Cloture (cc1, cc2, cc3, cc4);
         RocheCourante^.Marquer;
         PleineCloture;

         if RocheCourante^.Densite = 0
         then
            chain := '  1.03'
         else
            str (RocheCourante^.Densite:6:2, chain);

         if visudensite
         then
            aff_densite (n_dens,  chain, c_courbe2)
         else
            aff_densite (n_contr , chain, c_courbe2);
      end;
   end;

procedure DemarquerRocheCourante;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      if RocheCourante <> NIL
      then begin
         Iconetxt ('',            115, txtnorm, fondmenu, fondnorm);
         fenetre (fc1, fc2, fc3, fc4);
         Cloture (cc1, cc2, cc3, cc4);
         fixecoul (coulboite);
         RocheCourante^.Marquer;
         eff_densite;
      end;
   end;

Function AppartALaCloture (x, y : integer) : boolean;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
      begin
         fenetre (fc1, fc2, fc3, fc4);
         Cloture (cc1, cc2, cc3, cc4);
         AppartALaCloture := GraphPlt.AppartALaCloture (x, y);
         PleineCloture;
      end;

procedure EffacerCoordonnees;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
      var px, py     : integer;

   begin
      PleineCloture;
      px  := posxbtn+1;
      py  := py_xy ;{hauteurmenu+42+258 }
      { remplissage }
      coulbar (1, coulecran);
      bar       (px, py, maxx, py+30);

      (*   { cadre }
         SetColor (coext);
         Rectangle (b^.lim.xg, b^.lim.yh, b^.lim.xd, b^.lim.yb);
      *)
      fenetre (fc1, fc2, fc3, fc4);
      Cloture (cc1, cc2, cc3, cc4);
   end;

procedure AfficherCoordonnees (x, y : real);
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      T1, t2            : t12;
      px, py            : integer;

   begin
      PleineCloture;
      str (x:6:2, t1);   t1 := 'x = '+t1;
      str (y:6:2, t2);   t2 := 'y = '+t2;
      px  := posxbtn + 1;
      py  := py_xy;{hauteurmenu+42+258; 322}
      { effacer }
      coulbar (1, coulecran);
      bar       (px, py, maxx, py+30);
      { texte }
      px := posxbtn+4; {(maxx+posxbtn+2) div 2;}
      fixecoul (c_texte);
      setusercharsize (4, 3, 4, 3);
      settextjustify (0, 2);
      outtextxy (px , py, t1);
      py := py + 15;
      outtextxy (px , py, t2);
      setusercharsize (3, 2, 3, 2);
      settextjustify  (0, 2);
      fenetre (fc1, fc2, fc3, fc4);
      Cloture (cc1, cc2, cc3, cc4);
   end;

procedure ChangeRepere  (xt, yt           : integer;
                         var xc, yc       : real);
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      Xc := XUtilisateur (xt);
      Yc := YUtilisateur (yt);
   end;

procedure AfficherMire (x, y : real);
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      xx, yy            : integer;

   begin
      SetColor (2 Xor CoulBoite);
      SetWriteMode (XOrPut);
      xx := XCloture (x);
      yy := YCloture (y);
      line (cc1, yy, cc2, yy);
      line (xx, 0, xx, cc4-cc3);
   (*   DeplaceEn (x, fc3);
      TraceVers (x, fc4);
      DeplaceEn (fc1, y);
      TraceVers (fc2, y);*)
      SetWriteMode (NormalPut);
   end;

procedure EffacerMire (x, y : real);
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      AfficherMire (x, y);
   end;

function distance (xx1,yy1,xx2,yy2 : real) : real;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      d1, d2            : real;

   begin
      xx1 := XCloture (xx1);
      xx2 := XCloture (xx2);
      yy1 := YCloture (yy1);
      yy2 := YCloture (yy2);
      d1 := xx2-xx1;
      d1 := d1*d1;
      d2 := yy2-yy1;
      d2 := d2*d2;
      distance := sqrt (d1+d2)
   end;

function PointDuPoly (x, y : real; LePoly : PRoche;
                       var Preced, LePoint, suiv : PPoint) : boolean;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      PDP               : boolean;
      Point             : PPoint;
      npt,
      nptprec,
      nptsuiv           : integer;

   begin
      PDP := false;
      for npt := 0 to LePoly^.count-1
      do begin
         Point := LePoly^.at (npt);
         ok := (Distance (x, y, Point^.x, Point^.y) < DistanceLimite);
         if ok
         then begin
            nptprec := (npt+LePoly^.count-1) mod LePoly^.count;
            nptsuiv := (npt+1) mod LePoly^.count;
            Preced  := LePoly^.at (nptprec);
            Suiv    := LePoly^.at (nptsuiv);
            LePoint := LePoly^.at (npt);
            PDP := true;
         end;
      end;
      PointDuPoly := PDP;
   end;

function PointDuModele (x, y : real; var LePoint : PPoint) : boolean;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      PDP               : boolean;
      Point             : PPoint;
      LePoly            : PRoche;
      npp, npt,
      nptprec,
      nptsuiv           : integer;

   begin
      PDP := false;
      for npp := 0 to LeModele^.count-1
      do begin
         lepoly := LeModele^.at (npp);
         for npt := 0 to LePoly^.count-1
         do begin
            Point := LePoly^.at (npt);
            ok := (Distance (x, y, Point^.x, Point^.y) < DistanceLimite);
            if ok
            then begin
               LePoint := LePoly^.at (npt);
               PointDuModele := true;
               exit;
            end;
         end;
      end;
      PointDuModele := PDP;
   end;

procedure LimiterXY (var x, y : real);
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      if x < fc1
      then
         x := fc1
      else
         if x > fc2 then x := fc2;

      if y < fc3
      then
         y := fc3
      else
         if y > fc4 then y := fc4;
   end;

procedure SaisirNouveauPoly;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      T                 : PRoche;
      Point, Point2     : PPoint;
      xs, ys            : integer;

      x2, y2,
      x0, y0,
      x,  y,
      D                 : real;
      Ajoute, fin,
      DblClick,
      ok                : boolean;

   begin
      fenetre (fc1, fc2, fc3, fc4);
      Cloture (cc1, cc2, cc3, cc4);
      DemarquerRocheCourante;
      Repeat until not UnBoutonSourisEnfonce;

      { PREMIER POINT }
      LirePositionSouris (xs, ys);
      ChangeRepere (xs, ys, x2, y2);
      AfficherMire (x2, y2);

      RocheCourante := new (PRoche, init);
      LeModele^.insert (RocheCourante);

      repeat
         Repeat
            LirePositionSouris (xs, ys);
            ChangeRepere (xs, ys, x, y);

            LimiterXY (x, y);

            AfficherCoordonnees (x, y);

            EffacerMire (x2, y2);
            AfficherMire (x, y);
            x2 := x;
            y2 := y;
            if ToucheClavier (CodeClavier)
            then
               if CodeClavier = ESC
               then begin
                  EffacerMire (x, y);
                  EffacerCoordonnees;
                  LeModele^.Delete (RocheCourante);
                  dispose (RocheCourante, fini);
                  RocheCourante := NIL;
                  PleineCloture;
                  exit
               end;

         until UnBoutonSourisEnfonce;

         T := LeModele^.PolyContenant (x, y);
         if T <> NIL then beep;
      until (T = NIL);
      zap;

      SetColor (15);
      Cercle (x, y, 2);
      Cercle (x, y, 3);

      EffacerMire (x2, y2);
      x0 := x;
      y0 := y;
      Point := new (PPoint, init);
      Point^.x := x;
      Point^.y := y;
      RocheCourante^.insert (Point);

      {* POUR LES AUTRES POINTS, REPETER }
      repeat
         repeat until not UnBoutonSourisEnfonce;

         Point2 := new (PPoint, init);

         { Tracer le segment avec le dplacement de la souris }
         ok := false;
         Repeat
            LirePositionSouris (xs, ys);
            ChangeRepere (xs, ys, Point2^.x, Point2^.y);
            LimiterXY (Point2^.x, Point2^.y);

            {* AFFICHER MIRE, SEGMENT ET COORDONNEES }
            AfficherMire (Point2^.x, Point2^.y);
            AfficherCoordonnees (Point2^.x, Point2^.y);
            SetWriteMode (XOrPut);
            setcolor (C_Bord xor CoulBoite);
            DeplaceEn (Point^.x, Point^.y);    { affiche }
            TraceVers (Point2^.x, Point2^.y);
            SetWriteMode (NormalPut);

            {* TEST SI BOUTON ENFONCE ET SI SEGMENT NON SECANT }
            if UnBoutonSourisEnfonce and
               LeModele^.SegmentCoupe (Point, Point2)
            then beep;

            ok := UnBoutonSourisEnfonce and
                 ((xs<>0) or (ys<>0)) and
                 (not LeModele^.SegmentCoupe (Point, Point2)) and
                 ((Point^.x <> Point2^.x) or (Point^.y <> Point2^.y));

            if ok then begin
               repeat until not unboutonsourisenfonce;
               delay (100);
               DblClick := UnBoutonSourisEnfonce;
            end;

            {* SCRUTE LE CLAVIER POUR ESCAPE }
            if ToucheClavier (CodeClavier)
            then
               if CodeClavier = ESC
               then begin
                  { liberer points, effacer }
                  EffacerMire (Point2^.x, Point2^.y);
                  EffacerCoordonnees;
                  LeModele^.Delete (RocheCourante);
                  dispose (RocheCourante, fini);
                  RocheCourante := NIL;
                  Dess_Modele (false);
                  PleineCloture;
                  exit
               end;

            {* EFFACER SEGMENT ET MIRE }
            delay (10);
            x2 := Point2^.x; y2 := Point2^.y;
            EffacerMire (Point2^.x, Point2^.y);
            SetWriteMode (XOrPut);
            setcolor (C_Bord xor CoulBoite);
            DeplaceEn (Point^.x, Point^.y);
            TraceVers (Point2^.x, Point2^.y);   { efface  }
            SetWriteMode (NormalPut);
         until ok;
         {* JUSQU'A BOUTON ENFONCE ET SEGMENT NON SECANT }
         zap;

         D := Distance (Point2^.x, Point2^.y, x0, y0); { en pixel }

         ajoute := true;
         fin    := false;

         {* TESTE LA DISTANCE AVEC LE PREMIER POINT }
         if (D<DistanceLimite) and (RocheCourante^.count > 2)
         then begin
            fin := true;
            Point2^.x := x0;
            Point2^.y := y0;
            ajoute := not LeModele^.SegmentCoupe (Point, Point2);
         end else
         {* TESTE LE DOUBLE CLICK }
         if (DblClick) and (RocheCourante^.count > 2)
         then begin
            fin := true;
            Point2^.x := x0;
            Point2^.y := y0;
            ajoute := not LeModele^.SegmentCoupe (Point, Point2);
         end;

         if not ajoute
         then begin
            dispose (Point2, done);
            fin := false;
         end else begin
            SetColor (C_Bord);
            DeplaceEn (Point^.x, Point^.y);
            TraceVers (Point2^.x, Point2^.y);
            if fin
            then
               dispose (point2, done)
            else begin
               RocheCourante^.insert (Point2);
               Point := Point2;
            end;
         end;
      until fin;
      RocheCourante^.Couleur := random(6)+8;
      RocheCourante^.Orienter;
      RocheCourante^.Borner;

      pleinecloture;
      AffecterAttribut;

      EffacerCoordonnees;
      PleineCloture;
      modif_modele := true;
   end;

procedure DeplacerPoly;
   {--------------------------------------------------------------------}
   {--------------------------------------------------------------------}
   var
      Poly              : PRoche;
      P, pp             : PPoint;
      npt,
      x0, y0
                        : integer;
      dx2, dy2,
      dx, dy            : real;

      AnnulerDeplacement : boolean;

   begin
      CacherSouris;
      fenetre (fc1, fc2, fc3, fc4);
      Cloture (cc1, cc2, cc3, cc4);
(*      DemarquerRocheCourante;
      LirePositionSouris (x0, y0);
*)
      x0 := xs;
      y0 := ys;

      if RocheCourante^.Contient (XUtilisateur(xs), YUtilisateur(ys))
      then begin
         if not (PolyFlotte (RocheCourante) and flottefixe)
         then begin
            LeModele^.delete (RocheCourante);
            DupliquerRoche (RocheCourante, Poly);

            { EFFACER LE POLY }
            DemarquerRocheCourante;
            SetWriteMode (0);
            SetColor (CoulBoite);
            SetFillStyle (SolidFill, CoulBoite);
            Poly^.Effacer;

            SetWriteMode (1);
            SetColor (c_poly Xor CoulBoite);

            dx := 0;
            dy := 0;
            repeat
               Poly^.Dessiner; { Affiche }
               dx2 := dx;
               dy2 := dy;
               LirePositionSouris (xs, ys);
               dx := XUtilisateur (xs) - XUtilisateur (x0);
               dy := YUtilisateur (ys) - YUtilisateur (y0);
               AnnulerDeplacement := false;
               Poly^.Dessiner; { Efface }

               { Deplacement }
               for npt := 1 to Poly^.count
               do begin
                  P := Poly^.at (npt-1);
                  pp := RocheCourante^.at (npt-1);
                  P^.x := pp^.x + dx;
                  P^.y := pp^.y + dy;
                  if (P^.x > fc2) or (p^.x < fc1) or (p^.y < fc3) or (p^.y > fc4)
                  then
                     AnnulerDeplacement := true;
               end;
               if AnnulerDeplacement
               then
                  for npt := 1 to Poly^.count
                  do begin
                     P    := Poly^.at (npt-1);
                     pp   := RocheCourante^.at (npt-1);
                     P^.x := pp^.x + dx2;
                     P^.y := pp^.y + dy2;
                     dx   := dx2;
                     dy   := dy2;
                  end;
            until (not BoutonSourisEnfonce(BoutonGauche));

            if LeModele^.Coupe (Poly)
            then begin
               dispose (Poly, fini);
               Beep;
            end else begin
               dispose (RocheCourante, fini);
               RocheCourante := Poly;
            end;

            LeModele^.insert (RocheCourante);
            RocheCourante^.Borner;
         end;
      end;

      SetWriteMode (0);
      FixeCoul (c_poly);
      LeModele^.Peindre;
      RocheCourante^.Borner;

{     fenetre (fc1, fc2, fc3, fc4);
      Cloture (cc1, cc2, cc3, cc4);
}
      if affnumero
      then begin
         str (LeModele^.indexof (Rochecourante) + 1, chain);
         RocheCourante^.Afficher (chain, c_texte)
      end else begin
         str (RocheCourante^.densite:4:2, chain);
         RocheCourante^.Afficher (chain, c_texte);
      end;
      MarquerRocheCourante;

      MontrerSouris;
      PleineCloture;
      modif_modele := true;
   end;

procedure TirerUnPoint (xs, ys : integer);
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      PolyBidon         : PRoche;
      p, p2, p3         : PPoint;
      nbi, x, y         : integer;
      x1, x2, y1, y2    : real;
      boucle,
      finPoly           : boolean;

   begin
      CacherSouris;
      fenetre (fc1, fc2, fc3, fc4);
      Cloture (cc1, cc2, cc3, cc4);

      if PointDuPoly
         (XUtilisateur(xs), YUtilisateur(ys), RocheCourante, p2, p, p3)
      then begin
         DemarquerRocheCourante;
         SetFillStyle (SolidFill, CoulBoite);
         SetColor (c_poly);
         RocheCourante^.Effacer;
         RocheCourante^.Dessiner;

         x1 := p^.x;
         y1 := p^.y;
         FinPoly := false;

         setwritemode (1);
         setcolor (c_poly Xor CoulBoite);

         repeat
            DeplaceEn (p2^.x, p2^.y);  TraceVers (x1, y1); { effacer }
            DeplaceEn (x1, y1);        TraceVers (p3^.x, p3^.y);
            LirePositionSouris (xs, ys);
            x1 := XUtilisateur(xs);
            y1 := YUtilisateur(ys);
            LimiterXY (x1, y1);
            DeplaceEn (p2^.x, p2^.y);  TraceVers (x1, y1);    { afficher }
            DeplaceEn (x1, y1);        TraceVers (p3^.x, p3^.y);
         until not BoutonSourisEnfonce (BoutonGauche);

         x2   := p^.x;
         y2   := p^.y;
         p^.x := x1;
         p^.y := y1;

         if (not LeModele^.SegmentCoupe (p2, p))
            and (not LeModele^.SegmentCoupe (p3, p))
         then begin { NOUVELLE POSITION OK }

         end else begin  { ON GARDE L'ANCIENNE POSITION (x2,y2) }
            DeplaceEn (p2^.x, p2^.y);  TraceVers (x1, y1);
            DeplaceEn (x1, y1);        TraceVers (p3^.x, p3^.y);
            beep;
            p^.x := x2;
            p^.y := y2;
            x1   := p^.x;
            y1   := p^.y;
         end;

         RocheCourante^.Borner;
         SetWriteMode (0);
         fixecoul (c_poly);
         RocheCourante^.Peindre;
         RocheCourante^.Marquer;
         if affnumero
         then begin
            str (LeModele^.indexof (Rochecourante) + 1, chain);
            RocheCourante^.Afficher (chain, c_texte)
         end else begin
            str (RocheCourante^.densite:4:2, chain);
            RocheCourante^.Afficher (chain, c_texte);
         end;
         MarquerRocheCourante;
      end;

      PleineCloture;
      MontrerSouris;
      modif_modele := true;
   end;

procedure CouperPoly (xs, ys : integer);
   {------------------------------------------------------------------------}
   { simplifie }
   {------------------------------------------------------------------------}
   var
      Point,
      Point2,
      Point3,
      Point4            : PPoint;
      x,  y
                        : real;
      n                 : integer;

   begin
      CacherSouris;
      fenetre (fc1, fc2, fc3, fc4);
      Cloture (cc1, cc2, cc3, cc4);

      if PointDuPoly (XUtilisateur(xs), YUtilisateur(ys), RocheCourante, point2, Point, point3)
      then begin
         DemarquerRocheCourante;
         SetFillStyle (SolidFill, CoulBoite);
         SetColor (c_poly);
         RocheCourante^.Effacer;
         Point4 := New (PPoint, init);
         Point4^.x := (Point^.x + Point3^.x) / 2;
         Point4^.y := (Point^.y + Point3^.y) / 2;
         n := RocheCourante^.indexof (Point3);
         RocheCourante^.AtInsert (n, Point4);
         RocheCourante^.Borner;
      end;

      dess_modele (false);
      PleineCloture;
      MontrerSouris;
      modif_modele := true;
   end;

(*procedure CouperPoly (xs, ys : integer);
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
var
   T                 : PRoche;
   Point, Point2,
   Point3            : PPoint;
   x0, y0,
   x2, y2,
   x,  y,
   D                 : real;
   Ajoute, fin, ok   : boolean;
   n                 : integer;
   RocheBak          : PRoche;

   begin
   CacherSouris;
   Cloture (cc1, cc2, cc3, cc4);

   if PointDuPoly (XUtilisateur(xs), YUtilisateur(ys), RocheCourante, point2, Point, point3) then
   begin
      DemarquerRocheCourante;
      SetFillStyle (SolidFill, CoulBoite);
      SetColor (c_poly);
      RocheCourante^.Effacer;
      RocheCourante^.Dessiner;
      SetWriteMode (xorput);
      SetColor (c_poly xor CoulBoite);
      DeplaceEn (point^.x, point^.y);  TraceVers (Point3^.x, Point3^.y); { effacer }
      SetColor (0);
      Cercle (Point3^.x, Point3^.y, distancelimite);

      DupliquerRoche (RocheCourante, RocheBak);
      x0 := point3^.x;
      y0 := point3^.y;
      {* POUR LES AUTRES POINTS, REPETER }
      repeat
         repeat until not UnBoutonSourisEnfonce;
         Point2 := new (PPoint, init);

         { Tracer le segment avec le dplacement de la souris }
         ok := false;
         Repeat
            LirePositionSouris (xs, ys);
            ChangeRepere (xs, ys, Point2^.x, Point2^.y);

            LimiterXY (Point2^.x, Point2^.y);

            AfficherCoordonnees (Point2^.x, Point2^.y);

            {* AFFICHER MIRE, SEGMENT ET COORDONNEES }
            AfficherMire (Point2^.x, Point2^.y);
            SetWriteMode (XOrPut);
            DeplaceEn (Point^.x, Point^.y);    { affiche }
            TraceVers (Point2^.x, Point2^.y);
            SetWriteMode (NormalPut);

            {* TEST SI BOUTON ENFONCE ET SI SEGMENT NON SECANT }
            if UnBoutonSourisEnfonce and
               LeModele^.SegmentCoupe (Point, Point2) then beep;
            ok := UnBoutonSourisEnfonce and
               ((xs<>0) or (ys<>0)) and
               (not LeModele^.SegmentCoupe (Point, Point2)) and
               ((Point^.x <> Point2^.x) or (Point^.y <> Point2^.y));

            {* SCRUTE LE CLAVIER POUR ESCAPE }
            if ToucheClavier (CodeClavier) then
               if CodeClavier = ESC then
               begin
                  { liberer points, effacer }
                  LeModele^.Free (RocheCourante);
                  LeModele^.insert (RocheBak);
                  RocheCourante := RocheBak;
                  EffacerCoordonnees;
                  dess_modele (false);
                  PleineCloture;
                  MontrerSouris;
                  exit
               end;


            {* EFFACER SEGMENT ET MIRE }
            SetWriteMode (XOrPut);
            DeplaceEn (Point^.x, Point^.y);
            TraceVers (Point2^.x, Point2^.y);   { efface  }
            SetWriteMode (NormalPut);
            EffacerMire (Point2^.x, Point2^.y);
            x2 := Point2^.x; y2 := Point2^.y;

         until ok;
         {* JUSQU'A BOUTON ENFONCE ET SEGMENT NON SECANT }
         zap;

         D := Distance (Point2^.x, Point2^.y, x0, y0); { en pixel }

         ajoute := true;
         fin := false;

         {* TESTE LA DISTANCE AVEC LE PREMIER POINT }
         if (D<DistanceLimite) and (RocheCourante^.count > 2) then begin
            fin := true;
            Point2^.x := x0;
            Point2^.y := y0;
            ajoute := not LeModele^.SegmentCoupe (Point, Point2);
         end;

         if not ajoute then begin
            dispose (Point2, done);
            fin := false;
         end else begin
            DeplaceEn (Point^.x, Point^.y);
            TraceVers (Point2^.x, Point2^.y);
            if fin then
               dispose (point2, done)
            else begin
               n := RocheCourante^.indexof (Point);
               if n < RocheCourante^.count
               then RocheCourante^.contour.atinsert (n+1, Point2)
               else RocheCourante^.Insert (Point2);
               Point := Point2;
            end;
         end;

      until fin;
      Dispose (RocheBak, fini);
{      RocheCourante^.Orienter;}
   end;

   dess_modele (false);
   PleineCloture;
   MontrerSouris;
   modif_modele := true;
end;           *)

procedure Coller (xs, ys : integer);
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      x3, y3,
      x2, y2,
      x1, y1            : real;
      nr, np            : integer;
      Roche             : PRoche;
      p2, p, p3,
      Point             : PPoint;
      FinPoly           : boolean;

   function PointLePlusProche (x, y : real) : PPoint;
      var
         nr, np : integer;
         PLPP,
         Point  : PPoint;

      begin
         PLPP := NIL;
         for nr := 0 to LeModele^.count-1
         do begin
            Roche := LeModele^.at (nr);
            if Roche <> RocheCourante
            then begin
               for np := 0 to Roche^.count-1
               do begin
                  Point := Roche^.at (np);
                  if Distance (x, y, Point^.x, Point^.y) < 2*DistanceLimite
                  then
                     PLPP := Point;
               end;
            end;
         end;
         PointLePlusProche := PLPP;
      end;

   begin

   CacherSouris;
   fenetre (fc1, fc2, fc3, fc4);
   Cloture (cc1, cc2, cc3, cc4);

   if PointDuPoly
      (XUtilisateur(xs), YUtilisateur(ys), RocheCourante, p2, p, p3)
   then begin
      DemarquerRocheCourante;
      SetFillStyle (SolidFill, CoulBoite);
      SetColor (CoulBoite);
      SetColor (c_poly);
      RocheCourante^.Effacer;
      RocheCourante^.Dessiner;

      x1 := p^.x;
      y1 := p^.y;
      FinPoly := false;

      setwritemode (1);
      setcolor (c_poly Xor CoulBoite);

         repeat
            x3 := x1;
            y3 := y1;
            LirePositionSouris (xs, ys);
            x1 := XUtilisateur (xs);
            y1 := YUtilisateur (ys);
            LimiterXY (x1, y1);

            Point := PointLePlusProche (x1, y1);
            if Point <> NIL
            then begin
               x1 := Point^.x;
               y1 := Point^.y;
            end;
            DeplaceEn (p2^.x, p2^.y);  TraceVers (x3, y3); { effacer }
            DeplaceEn (x3, y3);        TraceVers (p3^.x, p3^.y);
            DeplaceEn (p2^.x, p2^.y);  TraceVers (x1, y1);    { afficher }
            DeplaceEn (x1, y1);        TraceVers (p3^.x, p3^.y);
         until not BoutonSourisEnfonce (BoutonGauche);

         x2 := p^.x;
         y2 := p^.y;
         p^.x := x1;
         p^.y := y1;

         if (not LeModele^.SegmentCoupe (p2, p))
            and (not LeModele^.SegmentCoupe (p3, p))
         then begin { NOUVELLE POSITION OK }
         end else begin  { ON GARDE L'ANCIENNE POSITION (x2,y2) }
            DeplaceEn (p2^.x, p2^.y);  TraceVers (x1, y1);  { effacer }
            DeplaceEn (x1, y1);        TraceVers (p3^.x, p3^.y);
            beep;
            p^.x := x2;
            p^.y := y2;
            x1 := p^.x;
            y1 := p^.y;
         end;

      RocheCourante^.Borner;
      SetWriteMode (0);
      fixecoul (c_poly);
      RocheCourante^.Peindre;
      RocheCourante^.Marquer;
      if affnumero
      then begin
         str (LeModele^.indexof (Rochecourante) + 1, chain);
         RocheCourante^.Afficher (chain, c_texte)
      end else begin
         str (RocheCourante^.densite:4:2, chain);
         RocheCourante^.Afficher (chain, c_texte);
      end;
      MarquerRocheCourante;
   end;

   PleineCloture;
   MontrerSouris;
   modif_modele := true;
end;

procedure TirerPoints (xs, ys : integer);
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      nr, np            : integer;
      Points1,
      Points,
      Points2,
      Roche             : PRoche;
      p, p1, p2, p3,
      Point             : PPoint;
      x2, y2,
      x, y              : real;
      sec               : boolean;

   procedure TracerSegs;
      var
         np             : byte;

      begin
         for np := 0 to Points^.count-1
         do begin
            P1 := Points1^.at (np);
            P  := Points^.at (np);
            P2 := Points2^.at (np);
            DeplaceEn (p1^.x, p1^.y);
            TraceVers (p^.x, p^.y);
            TraceVers (p2^.x, p2^.y);
         end;
      end;

   begin
      CacherSouris;
      fenetre (fc1, fc2, fc3, fc4);
      Cloture (cc1, cc2, cc3, cc4);

      x := XUtilisateur (xs);
      y := YUtilisateur (ys);

      Points := new (PRoche, init);
      Points1 := new (PRoche, init);
      Points2 := new (PRoche, init);

      if PointDuModele (X, Y, p)
      then begin
         SetFillStyle (SolidFill, CoulBoite);
         SetColor (c_poly);

         for nr := 0 to LeModele^.count-1
         do begin
            Roche := LeModele^.at (nr);
            if not (PolyFlotte (Roche) and flottefixe)
            then
               for np := 0 to Roche^.count-1
               do begin
                  Point := Roche^.at (np);

                  if Distance (x, y, Point^.x, Point^.y) < DistanceLimite
                  then begin
                     SetColor (CoulBoite);
                     Roche^.Effacer;
                     Point^.x := x;
                     Point^.y := y;

                     Points^.insert (Point);
                     Point := Roche^.at ((np+Roche^.count-1) mod Roche^.count);
                     Points1^.insert (Point);
                     Point := Roche^.at ((np+1) mod Roche^.count);
                     Points2^.insert (Point);

                     SetColor (c_poly);
                     Roche^.Dessiner;
                  end;
               end;
         end;

         {* Effacer segments }
         setcolor (CoulBoite);
         TracerSegs;
         {* Afficher xor }
         SetWriteMode (1);
         SetColor (c_poly Xor CoulBoite);
         TracerSegs;

         repeat
            lirePositionSouris (xs, ys);
            x2 := XUtilisateur (xs);
            y2 := YUtilisateur (ys);
            LimiterXY (x2, y2);

            {* Effacer segments }
            TracerSegs;

            {* Reaffecter position des points }
            for np := 0 to Points^.count-1
            do begin
               P  := Points^.at (np);
               p^.x := x2;
               p^.y := y2;
            end;

            {* Afficher segments }
            TracerSegs;

         until not UnBoutonSourisEnfonce;

         {* Effacer segments }
         TracerSegs;

         {* Tester si segments scants, restaurer si oui }
         Sec := false;
         for np := 0 to Points^.count-1
         do begin
            P1 := Points1^.at (np);
            P  := Points^.at (np);
            P2 := Points2^.at (np);
            if LeModele^.SegmentCoupe (p1, p)
               or LeModele^.SegmentCoupe (p2, p)
            then
               Sec := true;
         end;
         if sec
         then begin
            beep;
            for np := 0 to Points^.count-1
            do begin
               P  := Points^.at (np);
               P^.x := x;
               P^.y := y;
            end;
         end;

         {* liberer les listes de points }
         while Points^.count > 0
         do begin
            Points^.atdelete (0);
            Points1^.atdelete (0);
            Points2^.atdelete (0);
         end;
         dispose (Points, fini);
         dispose (Points1, fini);
         dispose (Points2, fini);
      end;
      SetWriteMode (0);
      LeModele^.Borner;
      dess_modele (false);
      PleineCloture;
      MontrerSouris;
      modif_modele := true;
   end;

procedure SupprimerPoly;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      if RocheCourante <> NIL
      then begin
         if not (PolyFlotte (RocheCourante) and flottefixe)
         then begin
            ok := false;
            Question (q_roche1, q_roche2 , ok);
            if ok
            then begin
               LeModele^.Free (RocheCourante);
               RocheCourante := NIL;
               Dess_Modele (false);
               modif_modele := true;
            end;
         end;
      end;
   end;

procedure SupprimerPoint (xs, ys : integer);
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      p, p2, p3,
      dernier           : PPoint;
      nbi, x, y         : integer;
      xi, yi,
      x1, y1,
      x2, y2            : real;
      boucle, finPoly   : boolean;

   begin
      CacherSouris;
      fenetre (fc1, fc2, fc3, fc4);
      Cloture (cc1, cc2, cc3, cc4);
      if (RocheCourante^.count > 3) and
         PointDuPoly (XUtilisateur (xs), YUtilisateur (ys),
                      RocheCourante, p2, p, p3)
      then begin
         if (not LeModele^.SegmentCoupe (p2, p3))
         then begin
            SetFillStyle (SolidFill, coulboite);
            SetColor (coulboite);
            Cercle (p^.x, p^.y, DistanceLimite);
            RocheCourante^.Effacer;
            RocheCourante^.Contour.Free (p);
            fixecoul (c_poly);
            RocheCourante^.Peindre;
            RocheCourante^.Borner;
            RocheCourante^.Marquer;
            if affnumero
            then begin
               str (LeModele^.indexof (Rochecourante) + 1, chain);
               RocheCourante^.Afficher (chain, c_texte)
            end else begin
               str (RocheCourante^.densite:4:2, chain);
               RocheCourante^.Afficher (chain, c_texte);
            end;
         end;
      end;
      PleineCloture;

      { TESTER SI UN POLY EST INCLUS ( faire) }

      MontrerSouris;
      modif_modele := true;
   end;

procedure AffecterAttribut;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}

   procedure choix_poly (var c : integer; var d : real ;
                                          var change : boolean);
      var
         touche, poscur : integer;
         r1             : real;
         cc1            : byte;
         z1             : pzoneReel;
         zc1            : Pzonecouleur;
         boite          : PBoiteSaisie;

      begin
         change := true;
         r1     := d;
         cc1    := byte (c);
         poscur := 1;
         boite  := new (PBoiteSaisie,
                   init ( milieu, milieu, 15,  fondnorm, txtnorm,
                   t_attributs));

         z1     := new (PZoneReel,
                   init (  0,   0,   4,   2, txtmenu, fondmenu, @d,
                   b_dens, '' ));
         boite^.ajoute (z1);

         Zc1    := new (PZoneCouleur,
                   init (     0,      0,                        @cc1,
                   b_coul, '', pal));
         boite^.ajoute (zc1);

         laide (aidedit);

{         repeat}
         boite^.editeF (1, Poscur, Touche);
         if (d <= 1.031)
         then begin
            d := r1;
            message (m_faible);
         end;
         if (d > 10)
         then begin
            d := r1;
            message (m_eleve);
         end;

{         until (d > 1.03) or (touche = ESC);}
         laide ('');

         boite^.vider;
         dispose (boite, fini);

         if (touche = ESC)
         then begin
            change  := false;
            cc1     := c;
            d       := r1;
         end;
         c     := cc1;
      end;

   begin
      repeat until not UnBoutonSourisEnfonce;
      if RocheCourante <> NIL
      then begin
         if not (PolyFlotte (RocheCourante) and flottefixe)
         then begin
         {  str (RocheCourante^.Densite:5:2, chain);
            repeat
               Saisie ('Densit du polygone : ', chain, 5);
               val (chain, RocheCourante^.densite, err);
               if PolyFlotte (RocheCourante)
               then message ('INTERDIT : cette valeur correspond  l''eau.');
            until (err=0) and not PolyFlotte (RocheCourante);
            c := RocheCourante^.couleur;
            UneCouleur ('Couleur', pal, RocheCourante^.Couleur);  }

            choix_poly (RocheCourante^.couleur, RocheCourante^.densite, ok);

            if ok
            then begin
               modif_modele := true;
               fenetre (fc1, fc2, fc3, fc4);
               Cloture (cc1, cc2, cc3, cc4);
               fixecoul (c_poly);
               RocheCourante^.Peindre;
               if affnumero
               then begin
                  str (LeModele^.indexof (Rochecourante) + 1, chain);
                  RocheCourante^.Afficher (chain, c_texte)
               end else begin
                  str (RocheCourante^.densite:4:2, chain);
                  RocheCourante^.Afficher (chain, c_texte);
               end;
               MarquerRocheCourante;
            end;
         end;
      end;
   end;

function DansLaListe (x, y : integer) : boolean;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      xx, yy            : real;

   begin
      fenetre (fc1, fc2, fc3, fc4);
      Cloture (cc1, cc2, cc3, cc4);
      xx := XUtilisateur (x);
      yy := YUtilisateur (y);
      PleineCloture;
      DansLaListe := LeModele^.Contient (xx, yy);
   end;

procedure zoomer;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   var
      x, y              : integer;
      coefc             : real;

   begin  { ZOOM }
      ChangerCurseur (Croix);
      MontrerSouris;
      Repeat
         until not UnBoutonSourisEnfonce;
      Repeat
         until BoutonSourisEnfonce (BoutonGauche);
      CacherSouris;
      LirePositionSouris (x, y);
      if AppartALaCloture (x, y)
      then begin
         Fenetre (fc1, fc2, fc3, fc4);
         Cloture (cc1, cc2, cc3, cc4);

         (*if {echelle1} false then begin
            cc3 := maxc3;
            coefc := (cc2 - cc1 ) / (cc4 - cc3);
            fc1 := XUtilisateur (x) - (((fc4-fc3)*coefc)/2);
            fc2 := XUtilisateur (x) + (((fc4-fc3)*coefc)/2);

            if fc1 < cor1 then begin
               fc2 := cor1 + (fc2-fc1);
               fc1 := cor1;
            end;
            if fc2 > cor2 then begin
               fc1 := cor2 - (fc2-fc1);
               fc2 := cor2;
            end;
         end else begin *)

            { Si zoom pas trop exagr }
            if ((fc2-fc1) > (cor2-cor1) / 20) and
               ((fc4-fc3) > (cor4-cor3) / 20)
            then begin
               { Si limite basse non plaque en bas, le faire }
               if cc3 <> maxc3
               then begin
                  cc3 := maxc3;
                  coefc := (cc2 - cc1 ) / (cc4 - cc3);
                  fc1 := XUtilisateur (x) - (((fc4-fc3)*coefc)/2);
                  fc2 := XUtilisateur (x) + (((fc4-fc3)*coefc)/2);
               { sinon zoomer normalement }
               end else begin
                  fc1 := XUtilisateur (x) - ((fc2-fc1)/rapz);
                  fc2 := XUtilisateur (x) + ((fc2-fc1)/rapz);
                  fc3 := YUtilisateur (y) - ((fc4-fc3)/rapz);
                  fc4 := YUtilisateur (y) + ((fc4-fc3)/rapz);
               end;

               if fc1 < cor1
               then begin
                  fc2 := cor1 + (fc2-fc1);
                  fc1 := cor1;
               end;
               if fc2 > cor2
               then begin
                  fc1 := cor2 - (fc2-fc1);
                  fc2 := cor2;
               end;
               if fc3 < cor3
               then begin
                  fc4 := cor3 + (fc4-fc3);
                  fc3 := cor3;
               end;
               if fc4 > cor4
               then begin
                  fc3 := cor4 - (fc4-fc3);
                  fc4 := cor4;
               end;
            end;
{         end;}
         Dess_modele (false);
      end;
      changerCurseur (fleche);
      montrersouris;
   end;

procedure Dezoomer;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      fc1 := cor1;
      fc2 := cor2;
      fc3 := cor3;
      fc4 := cor4;
      Cadrer;
      { calculer;}
      Dess_Modele (false);
   end;

procedure redessine_tout;
   begin
      inifondecran;
      iniecran;
   end;

procedure Effacer_Commentaires;
   begin
   {   fond_ecran  (coulecran);
      affichemenu;
      dess_icones;
      ini_titre;
      if LeModele <> nil
      then
         dess_modele (false);}

      inietat;                        { crit infos sur la ligne d'tat    }
   end;

procedure Legende (trac : boolean);
   var
      Numero,
      Densite           : t12;
      i                 : integer;
      Modele            : PModele;
      Roche             : PRoche;

   procedure Afficher (M : PModele);
      var
         px, py,
         y,
         i              : integer;

      begin
         if not trac
         then
            eff_densite;
         fixecoul (c_courbe2);
         setusercharsize (1, 1, 1, 1);
         px := posxbtn +tx;
         py := hauteurmenu+30+ty;
         tTextXY  (px, py, n_numero);
         for i := 0 to M^.count-1
         do begin
            Roche := M^.at (i);
            str ((i+1):2, Numero);
            str (Roche^.Densite:5:2, Densite);
            Chain := Numero + ' : ' + Densite;
            y     := py+ty + i*ty;
            if y < maxy-ty
            then
               tTextXY (px, y, Chain);
         end;
         setusercharsize (3, 2, 3, 2);
      end;

   begin
      if trac
      then begin
         ini_traceur;
         ecran   := false;
         fenetre         (0, trunc (papier_x), 0, trunc (papier_y));
         cloturemilli    (0, trunc (papier_x), 0, trunc (papier_y));
      end else begin
         ecran   := true;
         traceur := false
      end;
      if VisuDensite
      then
         Afficher (LeModele)
      else
         Afficher (Contrastes);
      pleinecrantrac (trac);
   end;

procedure redess_modele (trac : boolean);
   begin
      dess_modele (trac);
      if visucomm
      then
         Dessiner_Commentaires (trac, true, false);
   end;

procedure redess_tout;
   begin
      if copie_en_cours
      then begin
         at1 := traitc1;
         at2 := traitc2;
         if traitc1=traitc2
         then begin
            traitc1 := 2;
            traitc2 := 0;
         end;
         if affnumero
         then
            Legende (false);
      end else begin
         traitc1 := at1;
         traitc2 := at2;
         affichemenu;
         dess_icones;
         MarquerIcone   (Action, 12);
      end;
      ini_titre;
      inietat;
      redess_modele (false);
   end;

procedure Effacer_tout_redessiner;
   begin
      copie_en_cours := false;
      fond_ecran  (coulecran);
      redess_tout;
      modicomm := false;
   end;

END.

{--- GEOCEAN - GRAV_des ---------------------- R.C.- INRP - TOULOUSE - 1995 }

