UNIT GRAV_INI;

   {------------------------------------------------------------------------}
   { logiciel GEOCEAN - module GRAV                                         }
   {                                                                        }
   {                          initialisations                               }
   {------------------------------------------------------------------------}

INTERFACE

{$O+,F+}

USES
   dos, crt, graph,          { TP 70   - units       standard              }
   Lipar,                    { ARX     - gestion fichiers paramtres        }
   Graphism,                 { ARX     - initialisations graphiques         }
   GraphUti,                 { ARX     - utilitaires graphiques             }
   Dirinfo,                  { ARX     - annotations sur les fichiers       }
   Periphs,                  { ARX     - priphriques, impression, palettes}
   Utildivs,                 { ARX     - utilitaires divers                 }
   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   Icones,                   { ARX     - gestion de icnes                  }
   Menus,                    { ARX     - interface menus                    }

   Polygon,                  { ARX     - gestion des objets graphiques      }
   Modele,                   { ARX     - Gestion des "roches"               }

   GEO_var,                  { GEO     - variables globales communes        }
   GEO_des,                  { GEO     - procdures graph. communes         }

   GRAV_var,                 { GRAV    - variables globales du module       }
   GRAV_des;                 { GRAV    - affichages propres au module       }

Procedure iniparam;
   { initialise les paramtres de configuration  du programme.              }

Procedure iniparam2;
   { initialise les paramtres de travail                                   }

Procedure inidonnees;
   { charge les fichiers de donnes                                         }

Procedure inimenus;
   { initialise les paramtres de l'interface MENUS.                        }

Procedure modif_menus;
   { modifie le texte des menus en fonction des paramtres initiaux         }

Procedure iniIcones;
   { initialise les pointeurs sur les icnes                                }

Procedure inversemenus;
   { inverse MENUS LONGS/COURTS                                             }

Procedure iniaide;
   { initialise les paramtres du fichier d'aide.                           }

Procedure fin;
   { restaure l'cran texte.                                                }

Procedure ini_par_trv (nomf : pathstr);
   { initialisation des paramtres de travail                               }

Procedure lire_parametres ;
   { Procedure ini_par_trv (nomf : string); }
   { initialisation des paramtres de travail                               }
   { Procedure ini_par_symb (nomf : string);  }
   { initialisation des paramtres d'un ensemble de symboles reprsentant
     un fichier de donnes }

Procedure ecrire_parametres (resume : boolean);
   { Enregistre les paramtres de travail en cours
                               des symboles
                               des commentaires
        si RESUME   met  jour INFO.DIR                                     }

Procedure voir_ptrav;
   { visualise la liste  complte des paramtres du travail en cours        }

Procedure Sauver_Modele (NomF : pathstr);
   { enregistre les polygones                                               }


{---------------------------------------------------------------------------}

IMPLEMENTATION

procedure voir_ptrav;
   begin
      params.boite;                                                 { lipar }
      bte_compl (t_btepar , -1, -1, nbc, nbo, nbc, 10);{ menu6 }
   end;

procedure nouveau_modele;
   begin
      LeModele := new (PModele, init);
   end;

procedure Lire_Modele (NomF : pathstr);
{--------------------------------------------------------------------}
{--------------------------------------------------------------------}
   var
      Roche             : PRoche;
      Point             : PPoint;
      i, n              : integer;
      x0, y0,
      xp, yp,
      x, y              : real;
      F                 : text;

   begin
      assign (F, NomF);
      reset (F);
      LeModele := new (PModele, init);
      readln (F, n);
      for i := 1 to n
      do begin
         Roche := new (PRoche, init);
         read (F, x); readln (F, y);
         y  := -y;
         x0 := x;      y0 := y;
         xp := 10E20;  yp := 0;
         while (x < finpoly-0.01)
         do begin
            if (x<>xp) or (y<>yp)
            then begin
                Point := new (PPoint, init);
                Point^.x := x;
                Point^.y := y;
                xp := x;  yp := y;
                Roche^.Insert (Point);
            end;
            readln (F, x, y);
            y := -y;
         end;

         { Effacer dernier point si identique au premier }
         if (Point^.x = x0) and (Point^.y=y0)
         then
            Roche^.Contour.free (Point);

         read (F, Roche^.densite);
         readln (F, Roche^.couleur);
(*         if (Roche^.Couleur <8) or (Roche^.Couleur >13)*)
         if (Roche^.Couleur = 0) or (Roche^.Couleur = 15)
         then
            Roche^.Couleur := {random(6)+} 8;
         Roche^.Orienter;
         Roche^.Borner;
         LeModele^.Insert (Roche);
      end;
      close (F);
   end;

procedure ini_par_trv  (nomf : pathstr);
   begin
      params.init (false);
   { configuration donnes : modifiables par l'installateur }
      params.ajoute (Cstring  ('fichiers profils'     , @nomfd    , ''  ));
      params.ajoute (Cstring  ('titre'                , @titre    , ''  ));

   { autres params : modifiables par l'utilisateur }
      params.ajoute (Cinteger ('abs gauche cloture'   , @cc1      ,   0 ));
      params.ajoute (Cinteger ('abs droite cloture'   , @cc2      ,   0 ));
      params.ajoute (Cinteger ('ord basse  cloture'   , @cc3      ,   0 ));
      params.ajoute (Cinteger ('ord haute  cloture'   , @cc4      ,   0 ));
      params.ajoute (Cinteger ('ord basse  clot ano'  , @cc5      ,   0 ));
      params.ajoute (Cinteger ('ord haute  clot ano'  , @cc6      ,   0 ));
      params.ajoute (Creal    ('abs gauche fenetre'   , @cor1     ,   0 ));
      params.ajoute (Creal    ('abs droite fenetre'   , @cor2     ,   0 ));
      params.ajoute (Creal    ('ord basse  fenetre'   , @cor3     , pc3 ));
      params.ajoute (Creal    ('ord haute  fenetre'   , @cor4     ,   0 ));

      params.ajoute (Creal    ('abs gauche fenetre z' , @fc1      , -1000));
      params.ajoute (Creal    ('abs droite fenetre z' , @fc2      ,  3000));
      params.ajoute (Creal    ('ord basse  fenetre z' , @fc3      , -1000));
      params.ajoute (Creal    ('ord haute  fenetre z' , @fc4      ,  100));

   { affichages divers }
      {exo := false;}
      params.ajoute (Cboolean ('commentaires visibles', @visucomm   , false ));
      params.ajoute (Cboolean ('courbes visibles'     , @visucourb  , false ));
      params.ajoute (Cboolean ('grille visible'       , @visugrille , false ));
      params.ajoute (Cboolean ('affichage en densit' , @visudensite, true  ));
      params.ajoute (Cboolean ('sismes visibles'     , @visuseismes, false ));
      params.ajoute (Cboolean ('modle  l''chelle 1', @echelle1   , false ));
      params.ajoute (Cboolean ('correction anomalie'  , @translate  , true ));
      params.ajoute (Cboolean ('affichage des numros', @affnumero  , false ));
      params.ajoute (Creal    ('constante additive'   , @deltaconst ,  0 ));
      params.ajoute (Cword    ('type trait grille'    , @traitgrille,  3 ));
      params.ajoute (Cword    ('couleur calcul'       , @c_courbe1  ,  4 ));
      params.ajoute (Cword    ('couleur observation'  , @c_courbe2  , 14 ));
      params.ajoute (Cword    ('couleur limites'      , @c_couche   , 12 ));
      params.ajoute (Cword    ('couleur erreur'       , @c_err      , 14 ));
      params.ajoute (Cword    ('couleur sismes'      , @c_symb     , 11 ));
      params.ajoute (Cword    ('couleur polygones'    , @c_poly     ,  3 ));
      params.ajoute (Cword    ('couleur numros'      , @c_texte    ,  3 ));
      params.ajoute (Cword    ('couleur valeurs'      , @c_texte2   ,  3 ));
      params.ajoute (Cword    ('trait calcul'         , @traitc1    ,  0 ));
      params.ajoute (Cword    ('trait observation'    , @traitc2    ,  0 ));
      params.ajoute (Cword    ('trait limites couches', @traitlimite,  0 ));
      params.ajoute (Cinteger ('Nb couches'           , @NbCouches  ,  3 ));
      params.ajoute (Creal ('Profondeur couche 1', @Couches[1].Profondeur, pc1));
      params.ajoute (Creal ('Densit couche 1'   , @Couches[1].Densite,    dc1));
      params.ajoute (Creal ('Profondeur couche 2', @Couches[2].Profondeur, pc2));
      params.ajoute (Creal ('Densit couche 2'   , @Couches[2].Densite,    dc2));
      params.ajoute (Creal ('Profondeur couche 3', @Couches[3].Profondeur, pc3));
      params.ajoute (Creal ('Densit couche 3'   , @Couches[3].Densite,    dc3));
      params.ajoute (Creal ('Profondeur couche 4', @Couches[4].Profondeur, -300));
      params.ajoute (Creal ('Densit couche 4'   , @Couches[4].Densite,     3.4));
      params.ajoute (Creal ('Profondeur couche 5', @Couches[5].Profondeur, -300));
      params.ajoute (Creal ('Densit couche 5'   , @Couches[5].Densite,     3.4));
      params.ajoute (Creal ('abs origine'            , @x01         ,  0 ));
      params.ajoute (Creal ('ord origine'            , @y01         ,  0 ));
      params.ajoute (Creal ('abs extrmit'          , @x02         ,  0 ));
      params.ajoute (Creal ('ord extrmit'          , @y02         ,  0 ));

      { commentaires associs }
      params.ajoute (Cstring ('nom fichier commentaires', @nomfcomm, '' ));

      if (ftxt_present (nomf))
      then
         params.lit (nomf) ;

      modif_modele := false   ;         { modif en cours params             }
      nomfc        := nomfpar ;         { nom du fichier corps              }
      rapz         :=  4 ;              { coef zoom                         }
      visugrad     := false   ;         { graduations ext toujours inhibes }
      nbdec_xy     :=  0 ;              { nb dcimales                      }
      codasks      := 32 ;              { carr pour sismes                }
      h_min        :=  2 ;              { h symboles sismes en mm          }
      h_max        :=  6 ;
      exty         :=  2 ;              { graduations extrieure  l'axe    }
      flottefixe   := true;             { pas de modif du corps eau         }
      calculok     := false;            { modle calcul                    }
      deltaanomalie := 0;
   end;

procedure ecrire_parametres (resume : boolean);
   begin
      laide (la_Ecr_par);
      nomfcomm := nomfpar;

      chain := '';
{      if (prof and (nomfpar = nomdumodule))
      then
         chain := chemindonnees;
}
      { tester place disponible  sur le disque courant }

      x01 := x1;
      x02 := x2;
      y01 := y1;
      y02 := y2;
      params .ecrit   (chain +nomfpar  +extpar, datjour+ ' ' +nomutil);

      Sauver_Modele   (chain +nomfpar  +extcor);    { polygones }

      ecrit_par_COMM  (chain +nomfcomm +extcom);    { commentaires }

      if resume
      then
         edite_info (nomfinfo, nomfpar, extpar);
      laide ('');
   end;

procedure lire_parametres;
   begin
      laide (la_lit_par);
      chain := '';
      if (maj (nomfpar) = nomdumodule)
         and not exists (nomfpar+extpar)
      then
         chain := chemindonnees;

         { charger les paramtres de travail }
      (*if exo
      then begin
         chain := cheminexo;
         ini_par_TRV  (chain+nomfpar + extpar) ;
         exo   := true;                { forcer Bool si fichier inexistant  }
      end else*)
         ini_par_TRV  (chain+nomfpar + extpar) ;

      if titre    = ''
      then
         titre    := maj (region);

      if nomfcomm = ''
      then
         nomfcomm := nomfpar;

         { charger les commentaires           }
      (*if exo                  { si EXO dans le rep de travail }
      then begin
         if exists (nomfcomm + extcom)
         then
            ini_par_COMM (nomfcomm+extcom)
         else
            ini_par_comm (cheminexo+nomfcomm+extcom);
      end else*)
         ini_par_COMM (nomfcomm + extcom);

      laide ('');
   end;

procedure iniparam;
   var
      chem, chemp       : dirstr;
      nomf              : namestr;
      ext               : extstr;

   begin
      help_txt_enligne (paramstr (1));

      lire_utilisateur (paramstr (0)); { nomutil=nomutil+groupe, region }

      exempl := numeromaxi (cheminexemples+region+'\*'+extpar) > 0;

      {exo           := false;}
      {cheminexo     := chemindonnees+repexo+'\';}
      chemindonnees := chemindonnees+region+'\';

      chemp         := '';
      nomfpar       := nomdumodule;

      if paramcount > 0
      then
         chemp := paramstr (1);
      if chemp <> ''                { chercher le nom du fichier de travail }
      then begin
         fsplit (chemp, chem, nomf, ext);
         nomfpar := nomf;
      end;

      { charger la configuration d'ensemble de GEOC }
      { sans deuxime paramtre : config GEOCEAN }
      { avec deuxime  si <> geocean chemin et nom ok
                       sinon         config GEOCEAN }

      chemincfg  := cheminmodule;
      nomfcfg    := nomlogiciel;
      if paramcount > 1
      then
         chemp := paramstr (2);
      if chemp <> ''                { chercher le nom du chemin des donnes }
      then begin
         fsplit (chemp, chem, nomf, ext);
         if (nomf <> '') and (maj (nomf) <> nomlogiciel)
         then begin
            nomfcfg := nomf;
            if chem <> ''
            then
               chemincfg := chem
         end;
      end;
      complete    (chemincfg);

      ini_par_cfg (chemincfg+nomfcfg+extcfg);
      { si le fichier n'est pas trouv : paramtres par dfaut }
{reaffiche := false;}
      { affecter rpertoire configuration graphique   }
      repbgi := maj (getenv (NomBgi));
      if repbgi = ''
      then
         repbgi := cheminmodule;
      complete (repbgi);                       { ajoute ventuellement un \ }
   end;

procedure iniparam2;
   begin
      lire_parametres;
      prof       := false;                { dterminer si PROF }
      fini       := false;
      LeModele   := NIL;
      Contrastes := NIL;
   end;

Procedure Sauver_Modele (NomF : pathstr);
   {--------------------------------------------------------------------}
   {--------------------------------------------------------------------}
   var
      Roche             : PRoche;
      Point             : PPoint;
      np,
      i, n              : integer;
      x, y              : real;
      F                 : text;

   begin
      assign  (F, NomF);
      rewrite (F);
      writeln (F, LeModele^.count);
      for i:=1 to LeModele^.count
      do begin
         Roche := LeModele^.at (i-1);
         for np := 0 to Roche^.count-1
         do begin
            Point := Roche^.at (np);
            writeln (F, Point^.x:8:2,    ' ', -Point^.y:8:2);
         end;
         writeln (F, FinPoly,            ' ', FinPoly);
         writeln (F, Roche^.densite:8:2, ' ', Roche^.couleur:2);
      end;
      close (F);
   end;

procedure Lire_Anomalies (NomF : pathstr);
   var
      station           : integer;
      F                 : text;

   begin
      assign (f, NomF);
      {$I-}
      reset (F);
      {$I+}
      if ioResult=0
      then begin
         if anomalie <> NIL then dispose (anomalie);
         if Mesure   <> NIL then dispose (Mesure);
         if Ecart    <> NIL then dispose (Ecart);
         if StationX <> NIL then dispose (StationX);
         if StationY <> NIL then dispose (StationY);
         new (anomalie);
         new (anomalie_t);
         new (Mesure);
         new (Ecart);
         new (stationX);
         new (stationY);

         { COMPTE DU NOMBRE DE STATIONS ET LECTURE }
         cor1 := 10E10;
         cor2 := 0;

         NbStations := 0;
         While (not eof(F)) and (NbStations < NbMaxStations)
         do begin
            inc (NbStations);
            Read   (F, StationX^ [NbStations]);
            Read   (F, StationY^ [NbStations]);
            StationY^ [NbStations] := -StationY^ [NbStations];

            Read   (F, Mesure^ [NbStations]);
            ReadLn (F, Ecart^  [NbStations]);
            Anomalie^ [NbStations] := 0;
            if StationX^ [NbStations] < cor1
            then
               cor1 := StationX^ [NbStations];
            if StationX^ [NbStations] > cor2
            then
               cor2 := StationX^ [NbStations];
         end;
         close (F);

         cor1 := cor1-2*(StationX^[2]-StationX^[1]);
         cor2 := cor2+2*(StationX^[2]-StationX^[1]);
        { fc1  := cor1; fc2  := cor2;fc3  := cor3;fc4  := cor4;}
         retailler;
         inter_xy := stationX^[2]-StationX^[1];
      end;

      { MISE A ZERO DE L'ANOMALIE }
      for station := 1 to NbStations
      do
         Anomalie^[Station] := 0;
   end;

procedure lire_extremites (nomf : pathstr);
   var
      parame            : lipar.liste;

   begin
      parame.init (false);
      parame.ajoute (Creal    ('abs origine'            , @x1       ,    0 ));
      parame.ajoute (Creal    ('ord origine'            , @y1       ,    0 ));
      parame.ajoute (Creal    ('abs extrmit'          , @x2       ,    0 ));
      parame.ajoute (Creal    ('ord extrmit'          , @y2       ,    0 ));
      parame.ajoute (Cboolean ('anomalies airlibre'     , @airlibre , true));
      parame.ajoute (Cboolean ('profil sismique calcul', @sis      , false));
      parame.ajoute (Cstring  ('unit des grilles'      , @unite    , 'degrs'));
      parame.ajoute (Cstring  ('unit longueur profil'  , @unitl    , 'km'));
      parame.ajoute (Cstring  ('unit anomalie'         , @unitg    , 'mgal'));
      if   ftxt_present (nomf)
      then
         parame.lit (nomf)
      else
{         if not exo
         then      }
            message (m_pos_inconnue);

      parame.fini;
   end;

procedure chang_anomalies (chem : pathstr; var nomf : namestr );
   var
      i                 : integer;

   begin
      i := 0;
      repeat
         inc (i);
         dir_info                                                  { dirinfo }
            ('', choix_anomalies, '',
             chem+nomfinfo, '*', extGRA, chain);
          nomf :=  sansext (chain);
      until (nomf <> '') or (i > 2);

      if nomf = ''
      then begin
         message (m_not_anomalies);
         finir;
         halt;
      end else
         lire_anomalies (chem+nomf+extgra);
   end;

procedure inidonnees;
   var
      chem              : dirstr;

   begin
      chem := '';

      {if exo
      then
         chem := cheminexo;}

      { charger les valeurs  reprsenter }
      laide (la_lit_anomalies);
      if ftxt_present   (chem+nomfd+extgra)
      then begin
         lire_anomalies (chem+nomfd+extgra);
         nouveau := false;
      end else begin
         nomfd   := '';
         nomfc   := '';
         chang_anomalies (chem, nomfd);
         nomfc   := nomfd;
         nouveau := true;
      end;

      { charger les parametres du profil }
      lire_extremites  (chem+nomfd+ext_coup);
      profil_coherent := not nouveau
                         and ((x1 = x01) and (x2 = x02)
                         and (y1  = y01) and (y2 = y02));

      { charger les polygones }
      if ftxt_present (nomfc+extcor)   { ds rep travail d'abord }
      then
         lire_modele  (nomfc+extcor);
 (*      else begin
         (*if exo                        { ds rep exo ensuite }
         then begin
            if ftxt_present (chem+nomfc+extcor)
            then
               lire_modele  (chem+nomfc+extcor);
{            else nouveau_modele;}    ;
         end else begin
{            message ('Fichier corps non trouv !');}
{            nouveau_modele;  }
         end;
      end;               *)

      { Charger sismes, grs comme symboles }
      if ftxt_present (chem+nomfd+extvs) and sis
          { and ((nouveau and sis) or (not nouveau and not sis))}
      then begin
         minmaxf (chem+nomfd+extvs, 3, 3, min_v, max_v);
      end else begin
         message (m_not_seismes);
         visuseismes := false;
      end;
      laide ('');
   end;

procedure iniIcones;
   var
      px, py            : integer;

   begin
      laide (la_lit_icones);

      px  := posxbtn;
      py  := maxy - (ty + 30);
      if ftxt_present (cheminmodule+nomdumodule+exticn)
      then begin
         ActiveListeIcones (cheminmodule+nomdumodule+exticn);      { ICONES }
         Bouton_Icone (aidico1,   1, px,    py,     96, 30);
         bouton_icone (aidico2,   2, px+94, py - 2,  2,  2);  { invisible }
         Bouton_Icone (aidico3,   3, px,    py-53,  96, 50);

         py        := hauteurmenu+ 6;
         Bouton_Icone (aidico4,   4, px,    py,     96, 30); { titre rgion }

         py_legend := py + 33;
         py        := py + 33+60+3;

         Bouton_Icone (aidico5,   5, Px,    py,     30, 30);
         Bouton_Icone (aidico16, 16, Px+33, py,     30, 30);
         Bouton_Icone (aidico6,   6, Px+66, py,     30, 30);

         Bouton_Icone (aidico10, 10, Px,    py+33,  30, 30);
         Bouton_Icone (aidico12, 12, Px+33, py+33,  30, 30);
         Bouton_Icone (aidico11, 11, Px+66, py+33,  30, 30);

         Bouton_Icone (aidico7,   7, Px,    py+66,  30, 30);
         Bouton_Icone (aidico8,   8, Px+33, py+66,  30, 30);
         Bouton_Icone (aidico9,   9, Px+66, py+66,  30, 30);

         Bouton_Icone (aidico13, 13, Px,    py+99, 30, 30);
         Bouton_Icone (aidico14, 14, Px+33, py+99, 30, 30);
         Bouton_Icone (aidico15, 15, Px+66, py+99, 30, 30);

         py         := py + 99 + 33 + 8;

         Bouton_Icone (aidico17, 17, Px,    py,     30, 30);
         Bouton_Icone (aidico18, 18, Px,    py+ 33, 30, 30);
         Bouton_Icone (aidico19, 19, Px+33, py,     30, 30);
         Bouton_Icone (aidico20, 20, Px+33, py+ 33, 30, 30);
         Bouton_Icone (aidico21, 21, Px+66, py,     30, 30);
         Bouton_Icone (aidico22, 22, Px+66, py+ 33, 30, 30);

         py_densite := py + 66 ;

         py_xy      := py + 66 + 15;

         icone_etat;
      end else begin
         message (m_not_ICONES);
         halt;
      end;
      laide ('');
   end;

procedure inimenus_prof;
   begin
      textemenufichierprof;
      textemenu (3,  5, txt_mnu35, txt_mnu35a);
   end;

procedure inimenus_eleve;
   begin
      textemenufichier;

      textemenu (2,  1, nomu_grav, '');
    {  textemenu (2,  2, 'Polygones...',
                        'Edite les paramtres des polygones');
      textemenu (2,  3, 'Anomalies...',
                        'Edite les valeurs des anomalies');}
      textemenu (2,  2, txt_mnu22,  txt_mnu22);
      textemenu (2,  3, txt_mnu23,  txt_mnu23a);

      textemenu (2,  5, txt_mnu25,  txt_mnu25a);

      textemenu (3,  2, txt_mnu32,  txt_mnu32a);
      textemenu (3,  3, txt_mnu33,  txt_mnu33a);
   end;

procedure modif_menus;
   var
      i                 : integer;

   begin
      if ((nomfpar <> nomdumodule) or prof)
      then
         active (1, 4, true)
      else
         active (1, 4, false);

      if visucomm
      then begin
         textemenu (4,  2, coche+' '+txt_mnu42, txt_mnu42a);
         active (3, 2, true);
         Dessiner_Commentaires (false, true, false);
      end else begin
         textemenu (4,  2,      '  '+txt_mnu42, txt_mnu42b);
         active (3, 2, false);
      end;

      if annotations^.count = 0
      then begin
         visucomm := false;  { pour permettre la cration du premier lment }
         active (3 , 2, true);
      end;

      if nbcouches > 1
      then begin
         active (4, 7, true);
         If visudensite
         then begin
            textemenu (4,  7, coche+' '+txt_mnu47,  txt_mnu47a);
            Inactive_icone (17);
            if Contrastes <> NIL
            then
               Active_icone   (18)
            else
               Inactive_icone (18);

         end else begin
            textemenu (4,  7, coche+' '+txt_mnu472, txt_mnu47b);
            Inactive_icone (18);
            Active_icone   (17);
         end;
         active (2, 3, true);
      end else begin
         translate := true;
         active (2, 3, false);
         active (4, 7, false);
         inactive_icone (17);
         inactive_icone (18);
      end;

      If not affnumero
      then
         textemenu (4,  3, coche+' '+txt_mnu43, txt_mnu43a)
      else
         textemenu (4,  3,      '  '+txt_mnu43, txt_mnu43b);

      If Echelle1
      then begin
         textemenu (4,  4, coche+' '+txt_mnu44, txt_mnu44a);
         Inactive_icone (20);
         Active_icone   (19);
      end else begin
         textemenu (4,  4,      '  '+txt_mnu44, txt_mnu44b);
         Inactive_icone (19);
         Active_icone   (20);
      end;

      If visugrille
      then
         textemenu (4,  5, coche+' '+txt_mnu45, txt_mnu45a)
      else
         textemenu (4,  5,      '  '+txt_mnu45, txt_mnu45b);

      if sis            { Fichier sismes trouv et cohrent }
      then
         If VisuSeismes
         then begin
            textemenu (4,  6, coche+' '+txt_mnu46, txt_mnu46a
                              );
            Inactive_icone (21);
            Active_icone   (22);
         end else begin
            textemenu (4,  6,      '  '+txt_mnu46, txt_mnu46b);
            Inactive_icone (22);
            Active_icone   (21);
         end
      else begin
         inactive_icone (21);
         inactive_icone (22);
      end;

      if VisuDensite
      then begin
         if RocheCourante <> NIL
         then begin
 {           if not (PolyFlotte (RocheCourante) and flottefixe)
            then begin}
               Active_icone   ( 7);
               Active_icone   ( 8);
               Active_icone   (10);
               Active_icone   (11);
               Active_icone   (12);
               Active_icone   (13);
{            end else begin
               Inactive_icone ( 7);
               Inactive_icone ( 8);
               Inactive_icone (10);
               Inactive_icone (11);
               Inactive_icone (12);
               Inactive_icone (13);
            end;}
         end else begin
            Inactive_icone ( 7);
            Inactive_icone ( 8);
            Inactive_icone (10);
            Inactive_icone (11);
            Inactive_icone (12);
            Inactive_icone (13);
         end;

         if (LeModele <> NIL)
         then begin
            Active_icone   ( 6);
            Active_icone   ( 9);
            Active_icone   (16);
         end else begin
            Inactive_icone ( 6);
            Inactive_icone ( 9);
            Inactive_icone (16);
            nouveau_modele;
         end;
         Active_icone (5);
      end else begin
         if Contrastes <> NIL
         then
            Active_icone   (16)
         else
            Inactive_icone (16);

         for i := 5 to 13
         do
            inactive_icone (i);
      end;

(*      if exo
      then begin
         textemenu (6,  10, coche+' '+txt_mnu610, txt_mnu610a);
         active (1,  2, false);
         active (1,  3, false);
         active (1,  4, false);

      end else begin
         textemenu (6,  10,      '  '+txt_mnu610, txt_mnu610a
                        );
         active (1,  2, true);
         active (1,  3, true);
         active (1,  4, true);
      end;                            *)

      if exempl        { sans bascule }
      then begin
         active (1,  2, false);
         active (1,  4, false);
         active (1,  5, false);
         active (1, 10, false);
         active (1, 11, false);
         active (3,  2, false);
        { active (6, 10, false);       pas d'accs aux exos }
      end;

      ini_titre;
      modif_menu_cfg;
   end;

procedure inimenus;
   begin
      ini_menu      (repbgi, pol_menu);                             { menus }
      posxbtn := 541;
      chargepalette (cheminmodule+nomdumodule + extpal, ok);                  { graphism }
      setcoulmenu   (fondmenu, txtmenu, txtnorm, txtnon,
                     txtoui,  fondnorm, fondoui, fondaide);
      inimenus_eleve;
      if prof
      then
         inimenus_prof;
   end;

procedure inversemenus;
   begin
      if not prof
      then
         inimenus_prof
      else begin
         initmenus;                                                { menus1 }
         inimenus_eleve;
      end;
      prof := not prof;
   end;

procedure iniaide;
   begin
      initaide (cheminmodule+nomdumodule + exthlp, ok);                         { menus6 }
   end;

procedure fin;
   begin
      finir;                                                          { des }
   end;

BEGIN

   DefPolygonePlein (GraphPLT.PolygonePlein);
   DefTraceVers     (GraphPLT.TraceVers);
   DefDeplaceEn     (GraphPLT.DeplaceEn);
   DefCercle        (GraphPLT.Cercle);

END.

{--- GEOCEAN - GRAV_INI ------ --------------- R.C.- INRP - TOULOUSE - 1995 }
