PROGRAM inst;
{---------------------------------------------------------------------------}
{  Logiciel GEOCEAN -  INSTALLATION DES FICHIERS                            }
{  programme principal du  logiciel INST        version 1.x  du  06/04/96   }
{                                                                           }
{---------------------------------------------------------------------------}

{---------------------------------------------------------------------------}
{  Institut National de Recherche Pdagogique : DP 4, N. SALAME  -  PARIS   }
{                          Equipe INRP  TOULOUSE                            }
{  S. DUPOUY, C. GROS, R. CULOS, F. BOULANGER, J. TONNELAT, J. Y. GUCHEREAU }
{ Ralisation :                                                             }
{  A R X - Alain, Roger et Xavier CULOS - 6 avenue de Lagarde 31130 BALMA   }
{ Modifi par F.BORIE pour                                                  }
{         dcompresser les fichiers  copier                                }
{         travailler  partir de la disquette source en mise  jour         }
{         au lieu de travailler depuis le DD                                }
{---------------------------------------------------------------------------}

{---------------------------------------------------------------------------}
{ fichiers spciaux associs ncessaires sur la disquette INSTALL           }
{    INST    .LST            listes des modules et rgions prsents /dk     }
{---------------------------------------------------------------------------}
{ fichiers spciaux associs  ce programme dans le rpertoire dk\ et MNU   }
{    INST    .PAL            palette                                        }
{    INST    .AID            texte d'aide                                   }
{    LISEZMOI.TXT            prsentation de la livraison                   }
{---------------------------------------------------------------------------}
{ fichiers  sauvegarder sur disquette  part                                 }
{    INST    .NST            chemins, mod. et rg. aprs install ou maj     }
{    *       .MNU            description du menu d'accueil                  }
{    *       .CFG            options pour les modules                       }
{    *       .BAT            fichiers de lancement                          }
{---------------------------------------------------------------------------}

   (*      {$M 32000,0,131072}   paramtrage pour PKUNZIP             *)

{$I-,S+}
{$M 8192,0,655360}
{$L IMPLODE.OBJ}

USES
   crt,
   dos,
   graph,                    { TP7     - units standard  Borland           }
   Messarx,                  { ARX     - Textes des Messages de Base        }
   Graphism,                 { ARX     -                                    }
   Souris,                   { ARX     - gestion de la  souris              }
   Clavier,                  { ARX     - gestion du clavier                 }
   Lipar,                    { ARX     - gestion fichiers paramtres        }
   Graphplt,                 { ARX     - graphisme 2D cran/traceur         }
   Menus,                    { ARX     - interface  menus droulants        }
   Utildivs,                 { ARX     - utilitaires divers                 }
   Edition,                  { ARX     - saisie/dition paramtres          }
   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   Periphs,                  { ARX     - priphriques, impression, palettes}

   MENU_FIC,                 { MENU    - Initialisations fichiers           }
   MENU_INS,                 { CONF    - procdures propres                 }
   BGIDriv,BGIFont,
{   decomp,                   { Procedure de dcompression PkWare}
   MENU_VAR;                 { MENU    - variables globales du module       }

CONST
   extlst               = '.lst';         { ext. liste lments installables}
   extins               = '.NST';         { Params  installation            }
   extbat               = '.bat';         { ext. fichier bat                }
   extdk                = '._dk';          { ext. identificateur disquette   }

   nomlisezmoi          = 'lisez_mo.txt'; { dernires infos                 }
   nomlogic_bat         = 'geocean.bat';  { lance menuex depuis rep GEOCEAN }
   installe_bat         = 'misajour.bat'; { lance INST depuis geoc_mnu      }
   configur_bat         = 'configur.bat'; { lance CONF depuis geoc_mnu      }
   titrexe              = 'geoc_tit';     { nom page accueil furtive  .EXE  }
   nbelem               =       5;        { nombre d'lments installables  }

TYPE
   tab_s                = array [1..Nbelem] of t12;
   tab_b                = array [1..Nbelem] of boolean;
   tab_t                = array [1..Nbelem] of longint;

   tab_p                = array [1..nboptions-1]
                             of record
                                nom      : namestr;
                                volume   : longint;    { taille / lment   }
                                choisi   : boolean;    { ok }
                             end;

   tab_r                = array [1..nboptions-1]
                             of record
                                nom      : namestr;
                                volume   : longint;    { taille / lment   }
                                choisi   : boolean;    { ok }
                                dki,                   { premire ... et    }
                                dkf,                   { dernire disquette }
                                nbf      : integer;    { nombre de fichiers }
                             end;

   tab_d                = array [1..24]                { disques maxi }
                             of record
                                nom      : byte;       { 3..26 }
                                volume   : longint;    {       }
                                reso     : boolean;    { RW    }
                             end;
VAR
   disques                    { disques RW locaux ou distants ;
                                substitus exclus                           }

                        : tab_d;
   elem_noms                  { lments  installer : possibilits misaj   }

                        : tab_s;

   elem_ok,                   { lments installs avec succs              }
   elem_inst                  { lments  installer : choix                }
                        : tab_b;

   elem                       { lments  installer :  tailles             }
                        : tab_r;

   base_el,                   { place mini                                  }
   total_el,                  { total place ncessaire                      }
   place_mnu,
   place_doc
                        : longint;

   menu_pro_t                 { taille de chaque module                     }
                        : tab_p ;

   menu_xpl_t,                { taille, di, df, nbf  de chaque rp exemple  }
   menu_dnn_t                 { taille, di, df, nbf  de chaque rp donnes  }
                        : tab_r;

   u_mnu                      { unit rpert menu                           }
                        : string [2];

   n_prg,                     { noms des rpertoires                        }
   n_mnu,
   n_dnn,
   n_xpl,
   n_doc
                        : namestr;

   r_mnu                      { chemin  menu sans l'unit                   }

                        : dirstr;

   ch_aide,                   { fichier aide                                }
   cheminb,                   { chemin but      fichiers  D et P            }
   cheminm,                   {     "                     Menus             }

   chemins,                   { chemin source   fichiers Zip/nonzip         }
   chemini                    { chemin source   fichier INST.LST            }
                              {      premire disquette                     }
                        : pathstr;

   nbd,                       { }
   numex,                     { numro exemple }
   nbreg,                     { nombre rgions livraison }
   nbmod,                     { nombre modules livraison }

   n_cfg,                     { n type installation                        }
   z                          { n zone icone                               }
                        : integer;

   NstOk,                     { install ok                                  }
   reso,                      { il existe au moins un disque distant RW     }
   preminst,                  { premire installation                       }
   misaj                      { mise  jour                                 }
                        : boolean;

   l_ele,                     { liste lments = gds ensembles              }
   l_prg,                     { listes des modules                          }
   l_reg,                     { liste des rgions                           }
   l_xpl                      { liste des exemples                          }
                        : lst_chn;

   parzip                     { paramtres disquette mise  jour ou install }
                        : lipar.liste;

  elemencours,                { lment en cours de copie                   }
  { numdd,}                     { disque choisi pour installation             }
   numdk_ct                   { numro disquette courante                   }
                        : integer;

   totale,                    { volume lments en octets                   }
   totalp,                    {        modules                              }
   totald,                    {        donnes                              }
   totalx                     {        exemples                             }
                        : real;

   ZR                   : PZoneReel;

   b                    : array [1..NbOptions]   { temporaire pour choix    }
                                   of boolean;
const
  CMP_BINARY = 0;
  CMP_ASCII  = 1;

type
  BuffType = packed array [1..35256] of char;
  IntFunc = function(var Buff:BuffType; var bSize:Word): Word;

var
  DictionarySize:  Word;
  CompressionType: Word;
  FromFile:        File;
  ToFile:          File;
  Buffer:          Bufftype;
  Result:          Integer;
  Exploding:       Integer;
  OrigFile:        SearchRec;

function Implode(Read:IntFunc;
                 Write:IntFunc;
                 var Buf:BuffType;
                 var Ctype:Word;
                 var bSize:Word): Integer; far; external;

function Explode(Read:IntFunc;
                 Write:IntFunc;
                 var Buf:BuffType): Integer; far; external;


function ReadData(var Buffer : BuffType; var BufferSize : Word): Word; far;
var BytesRead:Word;
begin
   BlockRead(FromFile, Buffer, BufferSize, BytesRead);
   ReadData := BytesRead;
end;


function WriteData(var Buffer : BuffType; var BytesRead : Word): Word; far;
var byteswritten:Word;
begin
  BlockWrite(ToFile, Buffer, BytesRead, BytesWritten);
  WriteData := BytesWritten;
end;

procedure ExtractFile           (nomf1, nomf2 : pathstr; var ok : boolean);

   begin
        Assign(FromFile,nomf1);     { Open input file        }
        Reset(FromFile,1);
        Assign(ToFile,  nomf2);      { Create output file     }
        Rewrite(ToFile,1);
        DictionarySize  := 4096;
        CompressionType := CMP_BINARY;
        result := explode(ReadData, WriteData, Buffer);
        Close(FromFile);
        Close(ToFile);
        OK:=result=0;
   end;


procedure Copier_fichiers_ex (paths, pathb : Pathstr;
                              var nbf      : integer);
   VAR
      F                 : SearchRec;
      Ds, Db            : DirStr;
      N                 : NameStr;
      E                 : ExtStr;
      ok                : boolean;

   BEGIN
      FSplit    (Pathb, Db, N, E);
     {If (N<>'INST')and(N<>'METAJOUR') then begin}
         FindFirst (Paths, ReadOnly + Archive, F);
         nbf  := 0;
         ok   := true;
         WHILE (DosError = 0) and ok DO BEGIN
           FSplit (Paths, Ds, N, E);
           If (f.name<>'INST.EXE')and(f.name<>'METAJOUR.BAT') then
              ExtractFile (Ds+f.name, Db+f.name, ok);
           if ok then begin
              Inc   (nbf);
              laide ('Dcompression de '+Ds+f.name);
              FindNext (F);
           end;{if ok}
         END;{While}
     {end;{If (N<>'INST')and(N<>'METAJOUR')}
   END;


{---------------------------------------------------------------------------}
procedure inietat               (ci, cf         : pathstr);
   begin
      letat ('Source '      +ci,  0, 32);
      letat ('--->',             33,  4);
      letat ('Destination ' +cf, 38, 33);
   end;

{procedure ecr_par_zip           (nomf  : pathstr);
   begin
      parzip.ecrit  (nomf, 'Mise  jour le : '+datjour);
   end;  }

procedure ini_par_zip           (nomf  : pathstr);
   begin
      parzip.init   (false);
      parzip.ajoute (Clst_chn (n_geocean,              @l_ele,    nil   ));
      parzip.ajoute (Clst_chn (n_Modules,              @l_prg,    nil   ));
      parzip.ajoute (Clst_chn (n_Donnees,              @l_reg,    nil   ));
      parzip.ajoute (Clst_chn (n_Exemples,             @l_xpl,    nil   ));

      if ftxt_present  (nomf)
      then
         parzip.lit    (nomf);  {  }
   end;

function rang_don               (nom            : t12)          : word;
   { rend 1..11    rend 0 si non trouv,  }
   var
      i                 : word;
      trouve            : boolean;

   begin
       i := 0;
       repeat
          inc (i);
          trouve := nom = menu_dnn_t [i].nom
       until trouve or (i >= nboptions-1);
       if trouve
       then
          rang_don := i
       else
          rang_don := 0;
   end;

procedure extr_noms             (l_e, l_m, l_r, l_x     : lst_chn);
   { met  jour les tableaux : donnes, rgions, tailles donnes et rgions ;
     met  jour nbmod et nbreg }
   var
      nbf,
      ndi, ndf,
      plass             : t12;
      p_ct              : lst_chn;
      i                 : integer;
      n                 : namestr;

   begin
{      for i := 1 to nboptions-1 do menu_pro   [i] := '';   nom modules }
      for i := 1 to nboptions-1
      do begin
         menu_pro_t [i].nom    := '';   { noms  modules }
         menu_pro_t [i].volume := 0;     { tailles modules }
         menu_pro_t [i].choisi := false;
      end;

{      for i := 1 to nboptions-1 do menu_don   [i] := '';   nom rgions }
      for i := 1 to nboptions-1                           { tailles rgions }
      do begin
         menu_dnn_t [i].nom    := '';
         menu_dnn_t [i].volume := 0;
         menu_dnn_t [i].choisi := false;
         menu_dnn_t [i].dki    := 0;
         menu_dnn_t [i].dkf    := 0;
         menu_dnn_t [i].nbf    := 0;
      end;

      for i := 1 to nboptions-1                         { tailles exemples }
      do
         menu_xpl_t [i].volume := 0;

      p_ct  := l_e;
      for i := 1 to nbelem
      do begin
         if p_ct <> nil
         then begin
            if element_existe (l_e, elem_noms [i])
            then begin
               if elem_noms [i] = p_ct^.nom^
               then begin
                  elem_inst  [i] := true;
                  if p_ct^.elements <> nil
                  then begin
                     plass  := p_ct^.elements^.nom^;
                     val (plass,     elem [i].volume, err);
                     ndi    := p_ct^.elements^.suivant^.nom^;
                     val (ndi,       elem [i].dki, err);
                     ndf    := p_ct^.elements^.suivant^.suivant^.nom^;
                     val (ndf,       elem [i].dkf, err);
                     nbf    := p_ct^.elements^.suivant^.suivant^.suivant^.nom^;
                     val (nbf,       elem [i].nbf, err);
                  end;
               end else begin
                  elem [i].volume := 0;
                  elem_inst  [i] := false;
               end;
               p_ct                   := p_ct^.suivant;
            end else begin
               elem [i].volume := 0;
               elem_inst  [i] := false;
            end;
         end else begin
            elem [i].volume := 0;
            elem_inst  [i] := false;
         end;
      end;

      nbmod := 0;
      p_ct      := l_m;
      while p_ct <> nil
      do begin
         plass := '0';
         inc (nbmod);
{         menu_pro   [nbmod] := p_ct^.nom^;}
         menu_pro_t [nbmod].nom    := p_ct^.nom^;
         menu_pro_t [nbmod].choisi := true;
         if p_ct^.elements <> nil
         then begin
            plass  := p_ct^.elements^.nom^;
            val (plass,     menu_pro_t [nbmod].volume, err);
         end;
         p_ct                   := p_ct^.suivant;
      end;

      nbreg := 0;
      p_ct      := l_r;
      while p_ct <> nil
      do begin
         plass := '0';
         inc (nbreg);
{         menu_don   [nbreg] := p_ct^.nom^;}
         menu_dnn_t [nbreg].nom := p_ct^.nom^;
         if p_ct^.elements <> nil
         then begin
            plass  := p_ct^.elements^.nom^;
            val (plass,     menu_dnn_t [nbreg].volume, err);
            ndi    := p_ct^.elements^.suivant^.nom^;
            val (ndi,       menu_dnn_t [nbreg].dki, err);
            ndf    := p_ct^.elements^.suivant^.suivant^.nom^;
            val (ndf,       menu_dnn_t [nbreg].dkf, err);
            nbf    := p_ct^.elements^.suivant^.suivant^.suivant^.nom^;
            val (nbf,       menu_dnn_t [nbreg].nbf, err);
            menu_dnn_t [nbreg].choisi := true;
         end;
         p_ct                   := p_ct^.suivant;
      end;

      numex := 0;
      p_ct       := l_x;
      while p_ct <> nil
      do begin
         plass := '0';
         { rechercher la position dans dnn  pour aligner les tableaux }
         numex := rang_don (p_ct^.nom^);
         { 0 si non trouv }
         if p_ct^.elements <> nil
         then
            if numex <> 0
            then begin
               menu_xpl_t [numex].nom := p_ct^.nom^;
               plass  := p_ct^.elements^.nom^;
               val (plass,     menu_xpl_t [numex].volume, err);
               ndi    := p_ct^.elements^.suivant^.nom^;
               val (ndi,       menu_xpl_t [numex].dki, err);
               ndf    := p_ct^.elements^.suivant^.suivant^.nom^;
               val (ndf,       menu_xpl_t [numex].dkf, err);
               nbf    := p_ct^.elements^.suivant^.suivant^.suivant^.nom^;
               val (nbf,       menu_xpl_t [numex].nbf, err);
               menu_xpl_t [numex].choisi := true;
            end;
         p_ct  := p_ct^.suivant;
      end;

      total_el := base_el;
      for i := 1 to nbelem
      do
         inc (total_el, elem [i].volume);
   end;

procedure extr_chemins;
   var
      D                 : DirStr;
      N                 : NameStr;
      E                 : ExtStr;

   begin
      fsplit (ch_prg, d, n, e);
      cheminb := d;
      n_prg   := n;

      fsplit (ch_mnu, d, n, e);
      cheminm := d;
      enleve_antislash (cheminm);
      r_mnu   := copy (d+n, 3, length (d+n));
      n_mnu   := n;
      ch_mnu  := cheminm+'\'+n_mnu;
      u_mnu   := copy (d, 1, 2);

      fsplit (ch_dnn, d, n, e);
      n_dnn   := n;

      fsplit (ch_xpl, d, n, e);
      n_xpl   := n;

      fsplit (ch_doc, d, n, e);
      n_doc   := n;
   end;

procedure iniparam              (var ok : boolean);
   var
      chemp             : pathstr;
      chem              : dirstr;
      nomf              : namestr;
      ext               : extstr;
      nb                : integer;
      pkok              : boolean;

   begin
      { paramtres par dfaut de l'installation }
 {chdir ('e:\exocean\geoc_mnu');}
      chemin_courant   (ch_ct, ok);      { chemin absolu explicite }
      enleve_antislash (ch_ct);

      chemini  := ch_ct;

      if not ok
      then begin
         writeln ('Pb disque ?');
         halt;
      end;

      chemp    := '';
      if paramcount > 0
      then
         chemp := paramstr (1);

      if (chemp [1] = '.') and (chemp [2] = '.')
      then begin   { il faut reconstituer le chemin }
         fsplit (ch_ct, chemini, nomf, ext);
         fsplit (chemp, chain, nomf, ext);
         chemini := chemini+nomf;
         enleve_antislash (chemini);
      end;

      if (length (chemp) >= 2)
         and (chemp [2] = ':')
      then begin
         fsplit (chemp, chem, nomf, ext);
         enleve_antislash (chem);
         chemini := chem;
      end;

      ch_par    := paramstr (2);
      complete (ch_par);
      nomfpar   := nommenu;

      misaj     := exists (ch_par+nomfpar+extpar);
      modipar   := false;
      c_icone   :=  2;
      coulboite :=  7;
      coulecran := 15;

      { affecter rpertoire configuration graphique   }

      if misaj
      then
         repbgi    := ch_par
      else
{         repbgi    := ch_par+'\geoc_mnu';}
         repbgi    := chemini+'\geoc_mnu';
   end;

procedure ini_src               (var ok : boolean);
   var
      nb                : integer;

   begin
      if not exists (chemini+'\'+nominst+extlst)
      then begin
         nb := 0;
         repeat
            inc (nb);
            maxy := maxy + 8*ty;
            nom_repert (n_chemin_dk1, chemini, ok);
            maxy := getmaxy;
            enleve_antislash (chemini);
            ok := exists (chemini+'\'+nominst+extlst)
         until ok or (nb > 2);
      end;
      chemins := chemini;
   end;

procedure inimenus;
   var
      ok                : boolean;

   begin
      complete      (repbgi);
      ini_menu      (repbgi, 2);
      chargepalette (repbgi+nominst+extpal, ok);
      setcoulmenu   ( 15 ,      0,        3,      6,
                        0,      1,        2,      6);
   end;

procedure affiche_titre         (ny, c          : word;
                                 t              : chainecar;
                                 p              : longint;
                                 ec,
                                 ok             : boolean);
   var
      d,
      px, py            : integer;
      t1, t2, t3        : chainecar;
      nd                : string;

   begin
      t1 := '';
      t2 := '';
      t3 := '';

      str (p:7, t2);

      if elemencours > 0
      then begin
         d := elem [elemencours].dki;
         str (d  , nd);

         if ok
         then
            t3 := '- '+coche
         else
            if ec
            then
               t3 := nd;
      end;

      py := hauteurmenu+ ty + ty*ny;
      setcolor   (c);
      outtextxy  ( 20, py, t1+t);
      outtextxy  (150, py, t2);
      outtextxy  (210, py, ' '+n_octets);

      setcolor   (9);
      outtextxy  (280, py, t3);
   end;

procedure efface_infos;
   begin
      SetFillStyle (SolidFill, coulecran);
      bar       (5,  hauteurmenu+5, maxx div 2 -5, maxy div 2 +10);
                { couleur fond cran }
   end;

procedure affiche_infos ;
   var
      nb, nc            : word;
      t                 : longint;
      tip               : chainecar;

   begin
      efface_infos;
      setcolor  (10);
      rectangle (5,  hauteurmenu+5, maxx div 2 -5, maxy div 2 + 10);
      if misaj
      then
         tip := n_Misajour
      else
         tip := n_Prem_install;
      setcolor (11);
      outtextxy  (15, hauteurmenu+ty div 2, tip);
      for nb := 1 to nbelem
      do
         if  elem_inst [nb]
         then begin
            nc := nb;
            case nb of
               2 : nc  := 3;
               3 : nc  := 5;
               4 : nc  := 7;
               5 : nc  := 9;
            end;
            affiche_titre
                (nc, 11, elem_noms [nb], elem [nb].volume, (elemencours=nb) , elem_ok [nb]);
         end;
      t := base_el;
      for nb := 1 to nbelem
      do
         if elem_inst [nb]
         then
            inc (t, elem [nb].volume);
      affiche_titre (11 , 14 {coul}, n_Total,  t,   false , false );
   end;

procedure fond_ecran            (cfe, cfi       : integer);
   begin
      SetFillStyle (SolidFill, cfe);
      bar       (0, 0,  maxx, maxy-ty);     { couleur fond cran }
  end;

procedure dess_bandeau (c : word);
   var
      lx, py            : integer;

   begin
      nouveau_style (1, 0, 1);
      lx := (posxbtn-1) div 2;
      setfillstyle  (1, coulboite);
      bar        (0, 0,   posxbtn-1, hauteurmenu);

      setcolor   (c);
      py := hauteurmenu div 2 - 2;
      settextjustify (1, 1);
      outtextxy  (lx, py, 'G E O C E A N - I N S T A L L A T I O N');
      ancien_style;
   end;

procedure iniecran;
   begin
      posxbtn     := 639;
      fond_ecran   (coulecran, 11); { vert f }
      dess_bandeau (11);
     { grand_titre  (4);}
   end;

procedure affiche_disque (i, n : byte; v : longint; r, s : boolean );
   { numro d'ordre ; numro disque ; volume dispo; rseau; slectionn }
   var
      px, py         : integer;
      t1, t2, t3     : chainecar;

   begin
      t2 := '';
      t1 := chr (n+64)+':';

      if v > 0
      then
         str (v:10, t2);

      t3 := n_local;

      if r
      then
        t3 := n_reseau;

      py := hauteurmenu+ ty*i;
      setcolor   (11);
      outtextxy  (maxx div 2+5+ 20, py, t1);   { nom unit disque }
      outtextxy  (maxx div 2+5+ 40, py, t2);   { volume }
      outtextxy  (maxx div 2+5+130, py, ' '+n_octets);   { volume }
      setcolor   (9);
      outtextxy  (maxx div 2+5+200, py, t3);   { local / rseau }
      if s
      then
         outtextxy  (maxx div 2+5+260, py, coche);   { slection }
   end;

procedure affiche_disques (nbd : byte);
   var
      i                 : byte;

   begin
      setcolor  (10);
      rectangle (maxx div 2 + 5,  hauteurmenu+5, maxx -5, maxy div 2 + 10);
      setcolor  (11);

      if nbd > 12
      then
         nbd := 12;

      for i := 1 to nbd
      do
         affiche_disque
         (i, disques [i].nom, disques [i].volume, disques [i].reso, false);
   end;

procedure liste_places (var nbd : integer);
   var
      pl                : longint;
      pls               : chainecar;
      i                 : integer;
      d                 : byte;

   begin
      nbd  := 0;
      reso := false;
      { F = disques tous locaux;
        V = Il existe au moins un disque distant en criture }
      for i := 3 to 26
      do begin
         if i in liste_disques
         then begin
            inc (nbd);
            disques [nbd].nom := i;

            d := naturedisque (i);
            if (d >= 0) and (d < 2)
            then
               disques [nbd].volume := diskfree (i);
            disques [nbd].reso := false {disque_rw (i)} ;

            if d = 1                                      { distant }
            then begin
               disques [nbd].reso := disque_rw (i);       { et RW }
               if disques [nbd].reso
               then
                  reso := true                       { donc rseau }
               else
                  dec (nbd);                          { non RW non utile }
            end;
         end;
      end;
   end;

procedure finir;
   begin
      liberer_liste_chaine (list_prg);
      liberer_liste_chaine (list_reg);
      parins.fini;
      liberer_liste_chaine (l_prg);
      liberer_liste_chaine (l_reg);
      parzip.fini;
      chdir (ch_ct);
      ecrantexte;
   end;

procedure voir_pins;
   begin
      parins.boite;                                                 { lipar }
      bte_compl
         (t_Param_install, -1, -1, maxcar, nbo, 57, 10);
   end;

procedure extrait_liste_prg     (var ld         : lst_chn);
   var
      nb                : integer;

   begin
      for nb := 1 to Nbmod
      do
         if not element_existe (ld, menu_pro_t [nb].nom)
            and (menu_pro_t [nb].choisi)
         then
            ajouter_nom_chaine (ld, menu_pro_t [nb].nom );
   end;

procedure extrait_liste_dnn     (var ld         : lst_chn);
   var
      nb                : integer;

   begin
      for nb := 1 to Nbreg
      do
         if not element_existe (ld, menu_dnn_t [nb].nom)
            and (menu_dnn_t [nb].choisi)
         then
            ajouter_nom_chaine (ld, menu_dnn_t [nb].nom );
   end;

procedure iniplace;
{ La taille disque ncessaire en octets est calcule pour chaque sous-ensemble }
   begin
      elem [1].volume :=         0;       { menus }
      elem [2].volume :=         0;       { prg :  fichiers hors modules }
      elem [3].volume :=         0;       { dnn :  fichiers hors modules }
      elem [4].volume :=         0;       { xpl :   }
      elem [5].volume :=         0;       { documentation }
   end;

procedure ini_elem_install;
   var
      i                 : word;

   begin
      iniplace;
      total_el := 0;
      for i := 1 to nbelem
      do
         inc (base_el, elem [i].volume);
      total_el := base_el;
      elem_noms [1] := n_Interface;
      elem_noms [2] := n_Modules;
      elem_noms [3] := n_Donnees;
      elem_noms [4] := n_Exemples;
      elem_noms [5] := n_Documents;

      for i := 1 to nbelem
      do
         elem_inst [i] :=  true;

      for i := 1 to nbelem
      do
         elem_ok [i] := false;
   end;

procedure iniparam2             (var ok         : boolean);
   procedure ini_menu_inst (bte : lst_chn; var t : t_noms);
      var
         i              : integer;
         p_ct           : lst_chn;

      begin
         for i := 1 to nboptions-1
         do
             t [i] := '';

         i := 0;
         if bte = nil then exit;
         p_ct  := bte;
         p_ct  := p_ct^.suivant;
         while (p_ct <> nil)          { rechercher les lments du  1er niveau }
         do begin
            inc (i);                   { 2.. 12    nb maxi  de lignes au menu }
            t [i] := p_ct^.elements^.suivant^.nom^;             { nom rgion  }
            p_ct  := p_ct^.suivant;
         end;
      end;

   begin
           { initialiser var menu.mnu }
      ini_par_trv   (ch_par+nomfpar+extpar);
      nbregions :=  compte_elements (boite2)-1; { dj connues dans .mnu}
      nbmodules :=  compte_elements (boite3)-1;
      ini_menu_inst (boite2, menu_don);
      ini_menu_inst (boite3, menu_pro);

           { lire les listes dcrivant la livraison sur dk install }
      enleve_antislash (chemins);
      ini_par_zip (chemins+'\'+nominst+extlst);

      { lire les paramtres install prcdente pour recommencer id }
      if misaj
      then begin
         { lire les listes dj installes dans le rpertoire ct }
         ch_aide := ch_ct;
         ini_par_ins (ch_mnu+'\'+nominst + extins)
      end else begin
         { nouvelle installation  }
         ch_aide := chemins+'\geoc_mnu';
         ini_par_ins (chemins+'\'+nominst + extins);
      end;
      nstok    := false;
      extr_chemins;
      ini_elem_install;

      modipar  := false;
      ok       := true;
   end;

procedure MAJTotale ; far;
   var
      i                 : word;

   begin
      totale := base_el;
      for i := 1 to Nbelem
      do
         if elem_inst [i]
         then
            totale :=  totale + elem [i].volume;
      ZR^.Afficher;
   end;

procedure choisir_elements_install (var lt      : lst_chn);
   var
      ok                : boolean;
      li                : lst_chn;
      s                 : t20;
      deb,
      nb,     i         : word;

      touche, poscur    : integer;
      boite             : PBoiteSaisie;

      ZB
                        : PZoneBooleen;

      b                 : tab_b;
      t                 : longint;

   begin
      ok := false;
      repeat until not unboutonsourisenfonce;
      li     := lt;
      b      := elem_inst;  {  installer }
      t      := total_el;
      totale := total_el;
      poscur := 1;
      laide (aidedit);
      boite  := new (PBoiteSaisie,
                     init ( 8 + maxx div 2, milieu, 11,  7, 11,
                     t_Choisir_elem));
      deb := 1;
      if not misaj
      then
         deb := 4;
      for nb := deb to Nbelem
      do begin
          if elem_inst [nb]
          then begin
             ok := true;
             str (elem [nb].volume:7, s);
             s  := s+ ' '+n_octets;
             ZB := new (PZoneBooleen,
                        init (15*tx, 0,      8, 2, @elem_inst [nb],
                              ' '+elem_noms [nb], s));
             Boite^.Ajoute (ZB);
             ZB^.MiseAJour (MAJTotale);
          end
      end;
      if ok
      then begin
         ZR := new (PZoneReel,
                    init (15*tx, 0, 8, 0, 8, 2, @totale,
                          n_Total, ' '+n_octets));
         Boite^.Ajoute (ZR);

         boite^.editeF (1, Poscur, Touche);
      end;
      boite^.vider;
      dispose (boite, fini);

      laide ('');
      if touche = ESC
      then begin
         elem_inst := b;
         total_el  := t;
         lt        := li;
      end else begin
         for nb := 1 to Nbelem
         do begin
            if not elem_inst [nb]
            then begin
               supprimer_nom_chaine (lt, elem_noms [nb]);
               total_el :=  total_el + elem [nb].volume;
            end;
         end;
      end;
   end;

procedure MAJTotalp ; far;
   var
      i                 : word;

   begin
      totalp := 0;
      for i := 1 to Nbmod
      do
         if b [i]
         then
            totalp :=  totalp + menu_pro_t [i].volume;
      ZR^.Afficher;
   end;

procedure MAJTotald ; far;
   var
      i                 : word;

   begin
      totalx := 0;
      totald := 0;
      for i := 1 to Nbreg
      do
         if b [i]
         then begin
            totald :=  totald + menu_dnn_t [i].volume;
            totalx :=  totalx + menu_xpl_t [i].volume;
         end;
      ZR^.Afficher;
   end;

(*procedure choisir_prg   (var lt, ld     : lst_chn;
                         var ts         : boolean);
   var
      li                : lst_chn;
      s                 : t20;
      nb,     i         : word;
      touche, poscur    : integer;
      boite             : PBoiteSaisie;

      ZB
                        : PZoneBooleen;

   begin
      ts   := false;
      Li   := ld;
      for nb := 1 to NbOptions
      do
         b [nb] := true;

      totalp  := elem [2].volume;
      poscur := 1;
      laide (aidedit);
      boite  := new (PBoiteSaisie,
                     init ( maxx div 2, milieu, 11,  7, 11,
                     'Choisir les modules  installer'));
      for nb := 1 to Nbmod
      do begin
         str (menu_pro_t [nb].volume:7, s);
         s  := s+ ' octets';
         ZB := new (PZoneBooleen,
                    init (10*tx, 0,    8, 2, @b [nb], ' '+menu_pro_t [nb].nom, s));
         Boite^.Ajoute (ZB);
         ZB^.MiseAJour (MAJTotalp);
      end;
      ZR := new (PZoneReel,
                    init (10*tx, 0, 8, 0, 8, 2, @totalp, 'Total', 'octets'));
      Boite^.Ajoute (ZR);

      boite^.editeF (1, Poscur, Touche);
      boite^.vider;
      dispose (boite, fini);

      laide ('');
      if touche = ESC
      then begin
         ld := li;
         ts := true;
      end else begin
         elem [2].volume :=  trunc (totalp);
         for nb := 1 to Nbmod
         do begin
            if b [nb]
            then begin
               ajouter_nom_chaine   (ld, menu_pro_t [nb].nom)
               menu_pro_t [nb].choisi := true;
            end else begin
               supprimer_nom_chaine (lt, menu_pro_t [nb].nom);
               menu_pro_t [nb].choisi := false;
            end;
         end;
      end;
   end; *)

procedure choisir_dnn           (var lt, ld     : lst_chn) ;
   var
      li                : lst_chn;
      s                 : t20;
      nb,     i         : word;
      touche, poscur    : integer;
      boite             : PBoiteSaisie;

      ZB
                        : PZoneBooleen;

   begin
      Li   := ld;
      for nb := 1 to NbOptions
      do
         b [nb] := true;
      totald := elem [3].volume;
      totalx := elem [4].volume;

      poscur := 1;
      laide (aidedit);
      boite  := new (PBoiteSaisie,
                     init ( 8 + maxx div 2, milieu, 11,  7, 11,
                     t_choisir_regions));
      for nb := 1 to Nbreg
      do begin
         str (menu_dnn_t [nb].volume:7, s);
         s   := s+ ' '+n_octets;
         ZB  := new (PZoneBooleen,
                     init (10*tx, 0,    8, 2, @b [nb], ' '+menu_dnn_t [nb].nom, s));
         Boite^.Ajoute (ZB);
         ZB^.MiseAJour (MAJTotald);
      end;
      ZR     := new (PZoneReel,
                     init (10*tx, 0, 8, 0, 8, 2, @totald, n_Total, n_octets));
      Boite^.Ajoute (ZR);

      boite^.editeF (1, Poscur, Touche);
      boite^.vider;
      dispose (boite, fini);

      laide ('');
      if touche = ESC
      then begin
         ld := li;
      end else begin
         elem [3].volume := trunc (totald);
         elem [4].volume := trunc (totalx);
         for nb := 1 to Nbreg
         do begin
            if b [nb]
            then begin
               if not element_existe (ld, menu_dnn_t [nb].nom)
               then
                  ajouter_nom_chaine (ld, menu_dnn_t [nb].nom );
               menu_dnn_t [nb].choisi := true;
               menu_xpl_t [nb].choisi := true;
            end else begin
               supprimer_nom_chaine (lt, menu_dnn_t [nb].nom);
               menu_dnn_t [nb].choisi := false;
               menu_xpl_t [nb].choisi := false;
            end;
         end;
      end;
   end;

procedure copie_fichiers_mn0    (ci, cf         : pathstr;
                                 var ok         : boolean);
   var
      nb                : integer;

   begin
      complete (ci);
      complete (cf);
      copier_fichiers_ex (ci+'*.'+extmn0, cf, nb);
      ok := true;
   end;

procedure copie_inst            (ci, cf         : pathstr;
                                 var ok         : boolean);
   var
      nb                : integer;

   begin
      complete (ci);
      complete (cf);
      copier_fichiers_ex (ci+nomINST+'*.exe', cf, nb);
      ok := nb = 1;
   end;

procedure copie_fichiers_annexes (ci, cf        : pathstr;
                                  var ok        : boolean);
   var
      nb                : integer;

   begin
      complete (ci);
      complete (cf);
      copier_fichiers_ex (ci+'*.'+exttxt,          cf, nb);
      copier_fichiers_ex (ci+nomlogiciel+'.*', cf, nb);
      ok := true;
   end;

procedure chemin_nouveau        (fff,
                                 nomdk          : namestr;
                                 var ci         : pathstr;
                                 var ok         : boolean);
   { fff   : repert ou fichier recherch
     nomdk : numro d'identification de la disquette
     ci    : chemin de la disquette
     ok    : chemin trouv }
   var
      nb                : word;

   begin
{      if     (not exists (ci+'\'+fff+'\nul') )
          or (not exists (ci+'\geoc'+nomdk+extdk))
      then begin }
         message (Veuillez_mettre+' '+nomdk);
         modipar := true;
         ok      := true;
         laide   (la_changer_dk);
         nb := 1;
(*         repeat
            inc (nb);
          { parcourir l'arborescence :
            nom_repert_existant ('Chemin / '+fff+' :', ci, ok);  }
            maxy := maxy + 8* ty;
            nom_repert (Chemin_dk+' '+nomdk+' :', ci, ok);
            maxy := getmaxy;

            enleve_antislash (ci);
            ok := exists (ci+'\'+fff+'\nul')
                  and exists (ci+'\geoc'+nomdk+extdk);
            val (nomdk, numdk_ct, err);
         until ok or (nb > 2); *)

         ok := exists (ci+'\'+fff+'\nul')
               and exists (ci+'\geoc'+nomdk+extdk);
         while not ok and (nb < 3)
         do begin
            inc (nb);
          { parcourir l'arborescence :
            nom_repert_existant ('Chemin / '+fff+' :', ci, ok);  }

            maxy := maxy + 8* ty;
            nom_repert (Chemin_dk+' '+nomdk+' :', ci, ok);
            maxy := getmaxy;
            enleve_antislash (ci);
            ok :=     exists (ci+'\'+fff+'\nul')
                  and exists (ci+'\geoc'+nomdk+extdk);
         end;

         ok := ok and (nb <= 3);
         if ok
         then
            val (nomdk, numdk_ct, err)
         else
            fini := true;

         laide ('');
{      end;        }
   end;

procedure copie_fichiers_menus  (var ci         : pathstr;
                                 cf             : pathstr ;
                                 var ok         : boolean);        { COPY }
   var
      nb                : integer;
      nomdk             : namestr;

   begin
      elemencours := 1;
      enleve_antislash (ci);
      nomdk     := '1';
      numdk_ct  := 1;
{      numdk   := elem [1].dki;  str (numdk, nomdk);}
      ok        := exists (ci+'\'+n_mnu+'\nul')
                   and exists (ci+'\geoc'+nomdk+extdk);
      if not ok
      then
         chemin_nouveau (n_mnu, nomdk, ci , ok);

      if not fini
      then begin
         if ok
         then begin
            creer_repert (cf, elem [1].volume, ok);
            complete (cf);
            affiche_infos;
            copier_fichiers_ex (ci+'\'+n_mnu+'\*.*', cf, nb);
            chdir (ch_ct);
         end else begin
            message (n_Fichiers+' '+elem_noms [1]+' '+not_fic);
            ch_mnu := '';
            ci     := ch_ct;
         end;
         elem_ok  [1] := ok;
         affiche_infos;
      end;
   end;

procedure copier_rep_etendu (var ci             : pathstr;
                             nomr               : pathstr;
                             cf                 : pathstr;
                             di, df, nb         : integer;
                             var ok             : boolean);

   { ci : chemin "disquette" , nomr : chemin rpertoire, }
   var
      n,
      nbt,
      numdk             : integer;
      nomdk             : namestr;

   begin
      numdk := di;
      n     := 0;
      nbt   := 0;
      repeat
         str (numdk, nomdk);
         ok        := exists (ci+'\'+nomr+'\nul')
                      and exists (ci+'\geoc'+nomdk+extdk);
         if not ok and not fini
         then
            chemin_nouveau  (nomr, nomdk, ci , ok);
                         { rep cherch, comm, ch modifi, succs}
         if ok and not fini
         then begin
            affiche_infos;
            copier_fichiers_ex (ci+'\'+nomr+'\*.*', cf+'\'+nomr+'\', n);
            nbt := nbt+n;
            inc (numdk);
            ok := false;
         end;
      until (numdk > df) or fini;
      ok := (nbt >= nb)
   end;

procedure extraire_objets       (var ci         : pathstr;
                                 nomr,
                                 cf             : pathstr;
                                 var e          : tab_r;
                                 var ok         : boolean);
   var
      nomdk,
      nomobj            : namestr;      { ici = un rpertoire }
      i                 : integer;

   begin
      for i := 1 to nboptions-1
      do begin
         if e [i].choisi and not fini
         then begin
            creer_repert (cf+'\'+nomr+'\'+e[i].nom, e [i].volume, ok);
            chdir (ch_ct);

            if (e [i].dki <> numdk_ct)
            then begin
               str (e [i].dki, nomdk);
               ok        := exists (ci+'\'+nomr+'\nul')
                            and exists (ci+'\geoc'+nomdk+extdk);

               if not ok and not fini
               then
                  chemin_nouveau  (nomr, nomdk, ci , ok);
            end;

            if ok and not fini
            then
                copier_rep_etendu (ci, nomr+'\'+e [i].nom, cf,
                                   e [i].dki, e [i].dkf, e [i].nbf,
                                   ok);
         end;
      end;
   end;

(*procedure extraire_objets       (lr             : lst_chn;
                                 var ci         : pathstr;
                                 nomr,
                                 cf             : pathstr;
                                 var e          : tab_r;
                                 var ok         : boolean);
   var
      nomdk,
      nomobj            : namestr;      { ici = un rpertoire }
      i                 : integer;

   begin
      i := 0;
      while (lr <> nil) and ok
      do begin
         inc (i);
         nomobj := lr^.nom^;
         i      := rang_don (lr^.nom^);
         if e [i].choisi
         then begin
            creer_repert (cf+'\'+nomr+'\'+nomobj, e [i].volume, ok);
            chdir (ch_ct);

            if (e [i].dki <> numdk_ct)
            then begin
               str (e [i].dki, nomdk);
               chemin_nouveau  (nomr, nomdk, ci , ok);
            end;
            copier_rep_etendu (ci, nomr+'\'+nomobj, cf,
                               e [i].dki, e [i].dkf, e [i].nbf,
                               ok);
         end;
         lr     := lr^.suivant;
      end;
   end; *)

procedure copie_fichiers_prg    (l              : lst_chn ;
                                 var ci         : pathstr ;
                                 cf             : pathstr ;
                                 var ok         : boolean);

   begin
      elemencours := 2;

      enleve_antislash (ci);

      creer_repert (cf+'\'+n_prg, elem [2].volume, ok);
      chdir (ch_ct);
      copier_rep_etendu (ci, n_prg, cf,
                         elem [2].dki, elem [2].dkf, elem [2].nbf,
                         ok);
      if not ok
      then begin
         message (not_modules);
         ci     := ch_ct;
      end;

      enleve_antislash (ci);
      elem_ok [2] := ok;
      affiche_infos;
   end;

procedure copie_fichiers_region ( l             : lst_chn;
                                  var ci        : pathstr;
                                  cf            : pathstr;
                                  var ok        : boolean);
   begin
      elemencours := 3;
      enleve_antislash (ci);
      creer_repert (cf+'\'+n_dnn, elem [3].volume, ok);
      chdir (ch_ct);

      extraire_objets (ci, n_dnn, cf, menu_dnn_t, ok);

      if not ok
      then begin
         message (not_donnees);
         ci     := ch_ct;
         ch_dnn := '';
      end;

      enleve_antislash (ci);
      elem_ok  [3] := ok;
      affiche_infos;
   end;

procedure extraire_ex           (lr             : lst_chn;
                                 ci,
                                 nomr,
                                 cf             : pathstr;
                                 var e          : tab_r;
                                 var ok         : boolean);
   var
      nomdk,
      nomobj            : namestr;      { ici = un rpertoire }
      num               : integer;

   begin
      while (lr <> nil) and not fini
      do begin
         nomobj := lr^.nom^;
         num    := rang_don (lr^.nom^);
         if (num > 0) and (e [num].choisi)
         then begin
            creer_repert (cf+'\'+nomr+'\'+nomobj, e [num].volume, ok);
            chdir (ch_ct);

            if (e [num].dki <> numdk_ct)
            then begin
               str (e [num].dki, nomdk);
               ok        := exists (ci+'\'+nomr+'\nul')
                            and exists (ci+'\geoc'+nomdk+extdk);

               if not ok and not fini
               then
                   chemin_nouveau  (nomr, nomdk, ci , ok);
            end;

            if ok and not fini
            then
               copier_rep_etendu (ci, nomr+'\'+nomobj, cf,
                                  e [num].dki, e [num].dkf, e [num].nbf,
                                  ok);
         end;
         lr     := lr^.suivant;
      end;
   end;

procedure copie_fichiers_exemples  (l           : lst_chn;
                                    var ci      : pathstr;
                                        cf      : pathstr;
                                    var ok      : boolean);
   begin
      elemencours := 4;

      enleve_antislash (ci);
      creer_repert (cf+'\'+n_xpl, elem [4].volume, ok);
      chdir (ch_ct);

      extraire_ex (l, ci, n_xpl, cf, menu_xpl_t, ok);

      if not ok
      then begin
         message (not_exemples);
         ci     := ch_ct;
         ch_xpl := '';
      end;

      enleve_antislash (ci);
      elem_ok  [4] := ok;
      affiche_infos;
   end;

procedure copie_fichiers_doc    (var ci         : pathstr;
                                 cf             : pathstr;
                                 var ok         : boolean);        { COPY   }
   var
      nb                : integer;

   begin
      elemencours := 5;

      enleve_antislash (ci);
      creer_repert (cf+'\'+n_doc, elem [5].volume, ok);
      chdir (ch_ct);
      copier_rep_etendu (ci, n_doc, cf,
                         elem [5].dki, elem [5].dkf, elem [5].nbf,
                         ok);
      if not ok
      then begin
         message (not_doc);
         ch_doc := '';
         ci     := ch_ct;
      end;

      enleve_antislash (ci);
      elem_ok  [5] := ok;
      affiche_infos;
   end;

{function tous_m                                                 : boolean;
   begin
      repeat until not unboutonsourisenfonce;
      chain  := '';
      entier := 1;
      creeliste ('Tous les modules',       1);
      creeliste ('Choisir les modules',    2);
      liste     ('Choisir les modules',
                 ' installer',
                 '',
                 18, chain, entier);
      tous_m := entier=1;
   end;}

function toutes_r                                               : boolean;
   begin
      repeat until not unboutonsourisenfonce;
      chain  := '';
      entier := 1;
      creeliste (c_toutes_r,     1);
      creeliste (c_choisir_r,    2);

      maxy := maxy+8 *ty;
      liste     (l1_choisir_r, l2_choisir_r, l3_choisir_r, 18, chain, entier);
      maxy := getmaxy;
      toutes_r := entier = 1;
   end;

procedure change_chemins;
   var
      nb                : integer;
      f                 : file;

   begin
      repbgi    := ch_mnu;
      complete  (repbgi);

      ch_ct     := cheminm;
      {$I-}
      chdir (ch_ct);
      {$I+}
   end;

(* procedure copie_misaj;
   var
      nb                : integer;

   begin
       { fichiers gnrs aprs premire CONF }
       copier_fichiers (chemini+'\bis\'+nommenu    +extpar, ch_mnu +'\', nb);
       copier_fichiers (chemini+'\bis\*'           +extcfg, ch_prg +'\', nb);

       copier_fichiers (chemini+'\bis\'+nomlogiciel+extins, ch_mnu +'\', nb);
   end;

procedure copie_bis;
   var
      nb                : integer;

   begin
       copie_misaj;
       { fichiers gnrs par premire INST }
       copier_fichiers (chemini+'\bis\'+nomlogiciel+extbat, cheminm+'\', nb);
       copier_fichiers (chemini+'\bis\'+configurb  +extbat, cheminm+'\', nb);
       copier_fichiers (chemini+'\bis\'+installeb  +extbat, cheminm+'\', nb);
       copier_fichiers (chemini+'\bis\'+menufinib  +extbat, ch_mnu +'\', nb);
   end;*)

procedure controler (u : byte; var ok : boolean);
   begin
      ok := disque_rw (u);
        { and ((instreso and (naturedisque (u) = 1 ) ) or  (not instreso))}
      if not ok
      then
         message (not_w_dk);

      if ok and (diskfree (u) < total_el)
      then
         message (not_place);
   end;

function ordre_disques (i : byte) : byte;
   var
      nom, num : byte;

   begin
       num := 0;
       repeat
          inc (num);
          nom := disques [num].nom
       until nom = i;
       ordre_disques := num;
   end;

procedure cfg_perso             (var ok         : boolean);
   { utilisable la premire fois ...             misaj= F    }
   var
      nb,
      n, i              : integer;
      chemi             : pathstr;

   begin
      chemi   := cheminm;

      nb := 0;
      ok := false;
      while not ok and (nb < 3)
      do begin
         inc (nb);
         maxy := maxy+ 8 *ty;
         nom_repert (n_chem_geo+' :', cheminm, ok); {  saisie dest }
         maxy := getmaxy;
         i    := byte (upcase (cheminm [1]))-64;
         if ok
         then
            controler (i, ok);

         if ok
         then begin
            n := ordre_disques (i);
            affiche_disque
               (n, disques [n].nom, disques [n].volume, disques [n].reso, true)
         end else begin
            cheminm := chemi;
            exit;
         end;
      end;

      modipar := (cheminm <> chemi) or modipar;
      if ok
      then begin
         creer_repert (cheminm, elem [1].volume, ok);        { MD     }
         chdir (ch_ct);
         if ok
         then
            inietat   (chemins, cheminm);
         chdir (ch_ct);
         ch_mnu := cheminm+'\'+n_mnu;
         r_mnu  := copy (ch_mnu, 3, length (ch_mnu)-2);
         u_mnu  := copy (ch_mnu, 1, 2);
      end;

      cheminb := cheminm;
      if ok
      then begin
         ch_prg := cheminb+'\'+n_prg;
         ch_dnn := cheminb+'\'+n_dnn;
         ch_xpl := cheminb+'\'+n_xpl;
         ch_doc := cheminb+'\'+n_doc;
      end;

    {  choisir_elements_install (l_ele);}

      affiche_infos;

      extrait_liste_prg      (list_prg);

      if instreso and (nbreg > 1) and not toutes_r
      then
         choisir_dnn         (l_reg, list_reg)
      else
         extrait_liste_dnn      (list_reg);

      efface_infos;
      affiche_infos;
   end;

procedure cfg_misaj             (var ok         : boolean);
   begin
      choisir_elements_install (l_ele) ;
      efface_infos;
      affiche_infos;

      if elem_inst [2]
      then
         extrait_liste_prg         (list_prg);

      if elem_inst [3]
      then begin
         if (nbreg > 1) and not toutes_r
         then
            choisir_dnn            (l_reg, list_reg)
         else
            extrait_liste_dnn      (list_reg);
      end;
      if elem_inst [4]
      then
         if n_xpl = ''
         then begin
            n_xpl := 'geoc_xpl';
            ch_xpl := cheminb+n_xpl;
         end;
      if elem_inst [5]
      then
         if n_doc = ''
         then begin
            n_doc := 'geoc_doc';
            ch_doc := cheminb+n_doc;
         end;
      affiche_infos;
   end;

procedure cfg_reso              (var ok         : boolean);
   var
      i                 : integer;
      chemin            : pathstr;

   begin
      instreso  := true;
      cfg_perso (ok);
   end;

procedure tout_copier;
   begin
      if elem_inst [1]
      then begin
         copie_fichiers_menus             (chemins, ch_mnu, ok);

         if ok and not misaj
         then
            copie_fichiers_annexes        (chemins, cheminm, ok);

         if ok and not misaj
         then
            copie_inst                    (chemins, ch_mnu,  ok);
      end;

      if ok and not misaj
      then
         change_chemins;

      if elem_inst [2] and not fini
      then begin
         copie_fichiers_prg        (l_prg, chemins, cheminm, ok);
      end;

      if elem_inst [3] and not fini
      then begin
       {  copie_fichiers_mn0               (chemins, ch_mnu,  ok);}
         copie_fichiers_region     (l_reg, chemins, cheminm, ok);
      end;
      nstok := ok and not fini;

      if nstok and elem_inst [4]
      then
         copie_fichiers_exemples   (l_xpl, chemins, cheminm, ok)
      else
         if not misaj
         then
            ch_xpl := '';

      nstok := ok and not fini;
      if nstok and elem_inst [5]
      then
         copie_fichiers_doc        (chemins, cheminm, ok)
      else
         if not misaj
         then
            ch_doc := '';
   end;

procedure refaire_geoc_bat      (nomf           : pathstr;
                                 var ok         : Boolean);
   var
      fbat              : text;

   begin
      assign  (fbat, nomf);
      rewriteTxterr (fbat, nomf, ok);
      writeln (fbat, '@echo off');          { retour dans le rp initial }
      writeln (fbat, '      rem '+nomlogiciel+extBAT+' - '+datjour);
      writeln (fbat, '      rem lance '+nomlogiciel+' install sur le DD '+u_mnu);
      writeln (fbat, '      rem ce programme devrait tre log dans le rpertoire qui contient les');
      writeln (fbat, '      rem autres fichiers BAT ( condition qu''il figure dans le PATH...)');
      writeln (fbat, '');
      writeln (fbat, u_mnu);
      writeln (fbat, 'CD '+r_mnu);
      writeln (fbat, '');
      writeln (fbat, titrexe);
      writeln (fbat, '');
      writeln (fbat, 'Menuex %1 %2'  { +nommenu +nomcfg });
      writeln (fbat, '');
      close   (fbat)
   end;

procedure refaire_inst_bat      (nomf           : pathstr;
                                 var ok         : Boolean);
   var
      fbat              : text;

   begin
      assign  (fbat, nomf);
      rewriteTxterr (fbat, nomf, ok);
      writeln (fbat, '@echo off');
      writeln (fbat, '      rem '+nominst+extBAT+' - '+datjour);
      writeln (fbat, '      rem lance '+nomINST+' install sur le DD '+u_mnu+r_mnu);
      writeln (fbat, '      rem puis enchane avec CONF');
      writeln (fbat, '      rem ce programme pourrait tre log dans le rpertoire qui contient les');
      writeln (fbat, '      rem autres fichiers BAT ( condition qu''il figure dans le PATH...)');
      writeln (fbat, '');
      writeln (fbat, u_mnu);
      writeln (fbat, 'CD '+r_mnu);
      writeln (fbat, '');
      writeln (fbat, nomINST+' a:');
      writeln (fbat, u_mnu);
      writeln (fbat, 'CD '+ cheminm);
      close   (fbat )
   end;

procedure refaire_conf_bat      (nomf           : pathstr;
                                 var ok         : Boolean);
   var
      fbat              : text;

   begin
      assign  (fbat, nomf);
      rewriteTxterr (fbat, nomf, ok);
      writeln (fbat, '@echo off');          { retour dans le rp initial }
      writeln (fbat, '      rem '+nomconf+extBAT+' - '+datjour);
      writeln (fbat, '      rem lance  '+nomCONF+' install sur le DD '+u_mnu+r_mnu);
      writeln (fbat, '      rem ce programme pourrait tre log dans le rpertoire qui contient les');
      writeln (fbat, '      rem autres fichiers BAT ( condition qu''il figure dans le PATH...)');
      writeln (fbat, '');
      writeln (fbat, u_mnu);
      writeln (fbat, 'CD '+r_mnu);
      writeln (fbat, '');
      writeln (fbat, nomCONF);
      writeln (fbat, 'menufini');
      close   (fbat)
   end;

procedure refaire_fini_bat      (nomf           : pathstr;
                                 var ok         : Boolean);
   var
      fbat              : text;

   begin
      enleve_antislash (r_mnu);
      assign        (fbat, nomf);
      rewriteTxterr (fbat, nomf, ok);
      writeln (fbat, '@echo off');          { retour dans le rp initial }
      writeln (fbat, '      rem menufini.BAT  - '+datjour);
      writeln (fbat, '      rem sortie de MENU/'+nomlogiciel);
      writeln (fbat, 'mode co80');
{      writeln (fbat, 'set repbgi=');}
      writeln (fbat, u_mnu);
      writeln (fbat, 'CD '+ cheminm);
      close   (fbat)
   end;

(*procedure redemander_dk         (cf             : pathstr;
                                 var ok         : boolean);
   var
      nb                : integer;

   begin
      if not exists (cf+'\'+nomlogiciel+'0'+extlst)
      then begin
         message3 ('Veuillez introduire la',
                   'disquette bis formate',
                    'en '+cf);
         nb := 0;

         ok := exists (cf+'\'+nomlogiciel+'0'+extlst);
         while not ok and (nb < 2)
         do begin
            inc (nb);
            nom_repert ('Chemin de la disquette Bis', cf, ok);
            enleve_antislash (cf);
            ok := exists (cf+'\'+nomlogiciel+'0'+extlst);
         end;

         if not ok
         then begin
            message ('Pas de disquette pour Bis!');
         end;
      end else
         ok := true;
   end;  *)

procedure maj_fichiers_inst     (var ok         : boolean);
   var
      winok             : boolean;
      nb                : integer;

   begin
      { ok est V en entre }
      if misaj
      then begin
        { prparer misaj auto }
  {   chdir (ch_ct);}
         { ecr_par_zip     (ch_mnu +'\' +nomlogiciel+extlst);}
         ecr_par_ins      (ch_mnu +'\' +nominst+extins);
      end else begin
        { premire installation : std/perso/reso }
         { ecr_par_zip     (ch_mnu +'\' +nomlogiciel+extlst); }
         ecr_par_ins      (ch_mnu +'\' +nominst+extins);

         { fichiers de lancement }
         refaire_geoc_bat (cheminm+'\'+nomlogic_BAT, ok);
         refaire_inst_bat (cheminm+'\'+installe_BAT, ok);
         refaire_conf_bat (cheminm+'\'+Configur_BAT, ok);
         refaire_fini_bat (ch_mnu +'\'+menufini_bat, ok);
      end;
   end;

procedure voir_params;
   begin
      voir_pins;
   end;

procedure rep_co (var ok : boolean);
   var
      chemint,
      d                 : dirstr;
      n                 : namestr;
      e                 : extstr;

   begin
      chemint := ch_mnu;
      enleve_antislash (chemint);
      fsplit  (chemint, d, n, e);
      enleve_antislash (d);
      chemint := d;

      enleve_antislash (ch_grp);
                                             { racine du rpert de travail   }
      fsplit  (ch_grp, d, n, e);
      ch_grp := chemint+'\'+n;

      creer_repert (ch_grp,  place_trv, ok); { rpertoire geoc_trv }
      if ok
      then
         creer_repert (ch_grp+'\'+gcommun, place_trv, ok);  { public }

{      complete (ch_grp);}
      chdir    (ch_ct);
   end;

procedure tableau_liste (list  : lst_chn; t_e : t_noms; nbe : integer;
                         var t : t_noms; var nbnouv : word);
   var
      nom            : namestr;
      trouve         : boolean;
      p_l            : lst_chn;
      j              : word;

   begin
      for j := 1 to nboptions-1
      do
         t [j] := '';

      if list = nil
      then
         exit;

      p_l    := list;
      nbnouv      := 0;
      repeat             { pour chaque lment de la liste }
         trouve := false;
         nom :=  maj (p_l^.nom^);
         for j := 1 to nbe
         do begin
            if nom = maj (t_e [j] )
            then
               trouve := true;  { nom rgion /boite = nom /liste }
         end;
         if not trouve
         then begin
            inc (nbnouv);
            t [nbnouv] := nom;
         end;
         p_l    := p_l^.suivant;
      until (p_l = nil);
   end;

procedure modifier_menu_donnees ;
                                  { met  jour la liste DNN  installes }
   var
      nouv_lst          : t_noms;       { noms des nouveaux items
                                                  rfrencer dans menu.mnu }
      nbnouv            : word;         { nombre       "                    }

      i, li             : integer;
      rep_r             : namestr;

   procedure ajouter_regions_nouv;
      var
         li,
         i              : word;
         n_reg          : lst_chn;

      begin
         i := 0;
         while (i <= nbnouv-1) and (nbreg < nboptions-1)
         do begin
             { rechercher si existe un texte associ dans ch_dnn     }
             inc (i);
             rep_r := nouv_lst [i];
{             if ftxt_present (ch_mnu+'\'+rep_r+extmn0)}
             if ftxt_present (ch_dnn+'\'+rep_r+'\'+rep_r+extmn0)
             then begin
                inc (nbregions);
              {  lire_par_region (ch_mnu+'\'+rep_r+extmn0, n_reg);}
                lire_par_region (ch_dnn+'\'+rep_r+'\'+rep_r+extmn0, n_reg);
                { complter boite2     li := nbregions;}
                inserer_nouv_entree_bte (n_reg, boite2, nbregions);
                modipar  := true;
             end;
         end;

         if (nbregions > nboptions-1)
         then
            message3 (m1_ajoute_trop_r,
                      m2_ajoute_trop_r,
                      m3_ajoute_trop_r);
      end;

   begin
      if not misaj
      then
         nbregions := 0;
      tableau_liste (l_reg, menu_don, nbregions, nouv_lst, nbnouv);
                            { tableau et nb rgions dj installes  }
      if nbnouv > 0
      then begin
         nouv_bte2;                  { new p^ }
         ajouter_regions_nouv; { au menu boite2 }
      end;
   end;           { fin modif menu rgion }

procedure modifier_menu_modules;  { met  jour les listes PRG  installs }
   var
      nouv_lst          : t_noms;       { noms des nouveaux items
                                                  rfrencer dans menu.mnu }
      nbnouv            : word;         { nombre       "                    }

      i, li             : integer;
      fic_p             : namestr;

   procedure ajouter_modules_nouv;
      var
         li,
         i              : word;
         n_mod          : lst_chn;

      function pos_module (nom : namestr) : word;
         { ok si le module existe }
         var
            i           : word;

         begin
             i := 0;
             repeat
                inc (i);
             until nom = menu_ico [i];
             pos_module := i;
         end;

      begin
         i := 0;
         while (i <= nbnouv-1) and (nbmodules < nboptions-1)
         do begin
            inc (i);
            fic_p := nouv_lst [i];
            { rechercher si existe un texte associ dans ch_dnn     }
            if ftxt_present (ch_prg+'\'+fic_p+extmn0)
            then begin
               inc (nbmodules);
               lire_par_module (ch_prg+'\'+fic_p+extmn0, n_mod);
               { complter boite3  : li }
               li := pos_module (fic_p);
               if li > nbmodules
               then
                  inserer_nouv_entree_bte (n_mod, boite3, 0) { en queue}
               else
                  inserer_nouv_entree_bte (n_mod, boite3, li);

               modipar  := true;
            end;
         end;

         if (nbmodules > nboptions-1)
         then
            message3 (m1_ajoute_trop_m,
                      m2_ajoute_trop_r,
                      m3_ajoute_trop_r);
      end;

   begin     { modifier le menu activit }
      if not misaj then nbmodules := 0;
      tableau_liste (l_prg, menu_pro, nbmodules, nouv_lst, nbnouv);
      if nbnouv > 0
      then  begin
         nouv_bte3;
         ajouter_modules_nouv; { au menu boite3 }
      end;
   end;

procedure salut;
   begin
      if nstok
      then begin
         modifier_menu_donnees; { met  jour les listes DNN installes      }
         modifier_menu_modules; { met  jour les listes PRG installs       }

         if not misaj
         then begin
            if instreso
            then
               completer_inst (ok) { maj chemins pour les espaces de travail   }
            else begin
               rep_co (ok);
               teste_groupes (ok);
            end;
         end;

         if exists (ch_mnu+'\'+nomfpar+extpar)
         then
            copyfile (ch_mnu+'\'+nomfpar+extpar, ch_mnu+'\'+nomfpar+'.000', ok);

         params.ecrit  (ch_mnu+'\'+nomfpar+extpar, ' - '+datjour);

         maj_fichiers_inst (ok);
      end;

      if ok
      then begin
         if misaj
         then
            message  (misaj_ok)
         else
            message  (install_ok);
         message3 (lance_geocean1, lance_geocean2, lance_geocean3);
      end else begin
         message  (not_install_ok);
         chdir (ch_ct);
      end;
   end;

procedure aide                  (x, y           : integer);
   begin
      aff_aide (ch_aide+'\'+nominst + exthlp, x, y);
   end;

procedure lisez_moi;
   begin
      aide_txt (der_info, chemini+'\'+nomlisezmoi);
   end;

procedure consulter_aides;
   var
      lg,
      n                 : integer;

   begin
      chain  := '';
      n      := 1;
      repeat
         creeliste (c_install,          1);
         creeliste (c_mono,             2);
         creeliste (c_reso,             3);
         creeliste (c_lire,             4);
         creeliste (c_quitter,          5);
         lg := length (c_quitter)-2;

         maxy := maxy + 11* ty;
         liste     ('', b_Aide, '', lg, chain, n);
         maxy := getmaxy;
         case n of
            1..3 : aide (1, n);
            4    : lisez_moi;
         end;
      until (n = 5) or (n < 1);
   end;

procedure choisir_cfg_mono     (var  numcfg    : integer);
   var
      lg                : integer;

   begin
      chain  := '';
      numcfg := 1;
      laide (la_choisir_l);
      repeat
         creeliste (c_ins_mono,  1);
         creeliste (c_aide,      2);
         creeliste (c_quitter2,  3);
         lg := length (c_quitter2)-2;

         maxy := maxy + 9 *ty;
         liste     ('', l2_c_inst+' : ', '', lg, chain, numcfg);
         maxy := getmaxy;

         if numcfg = 2
         then
            consulter_aides;
      until ((numcfg =1)) or (numcfg = 3);

      if numcfg= 3
      then
         numcfg := 4;
   end;

procedure choisir_cfg           (var  numcfg    : integer);
   var
      lg                : integer;

   begin
      chain  := '';
      numcfg := 1;
      laide (la_choisir_l);
      repeat
         creeliste (c_Mono,      1);
         creeliste (c_Reso,      2);
         creeliste (c_aide,      3);
         creeliste (c_quitter2,  4);
         lg := length (c_quitter2)+1;
         maxy := maxy + 11 *ty;
         liste     ('', l2_c_instt, '', lg, chain, numcfg);
         maxy := getmaxy;
         if numcfg = 3
         then
            consulter_aides;
      until ((numcfg > 0) and (numcfg < 3)) or (numcfg = 4)
   end;

{--------------------------------   INST   ---------------------------------}

PROCEDURE Abort(Msg : STRING);
BEGIN
  Writeln(Msg, ': ', GraphErrorMsg(GraphResult));
  Halt(1);
END;


BEGIN
  { Enregistrement des pilotes de priphrique graphiques. }
     IF RegisterBGIdriver(@EGAVGADriverProc) < 0 THEN Abort('EGA/VGA');
  { Enregistrement des polices de caractres graphiques. }
     IF RegisterBGIfont(@SansSerifFontProc) < 0 THEN  Abort('SansSerif');
     IF RegisterBGIfont(@SmallFontProc)     < 0 THEN  Abort('Small');
     IF RegisterBGIfont(@TriplexFontProc)   < 0 THEN  Abort('Triplex');
   nomdumodule := nominst;
   iniparam       (ok);
   if ok
   then begin
      inimenus;
      iniecran;
   end;

   if ok
   then
      ini_src        (ok);   { localise la disquette initiale }

   if ok
   then
      iniparam2      (ok);   { initialise les params de ce progr }

   if ok
   then begin
      initaide (ch_aide+'\'+nominst + exthlp, ok);
      ok := true;    { aide non obligatoire }
      extr_noms (l_ele, l_prg, l_reg, l_xpl);
      affiche_infos;
      liste_places    (nbd);
      affiche_disques (nbd);
      inietat   (chemins, cheminm);
   end;

   if ok
   then begin
      fini := false;
      repeat
         if misaj                      { mise  jour    }
         then begin
            aide (1, 6);
            lisez_moi;
            cfg_misaj      (ok);
         end else begin                { installation : std/perso/reso
            if reso
            then
               choisir_cfg      (n_cfg)
            else
               choisir_cfg_mono (n_cfg);

            case n_cfg of
               1 : cfg_perso    (ok);
               2 : cfg_reso     (ok);
               4 : begin
                      ok := false;
                      fini := true;
                   end;
            end;
            Toute cette partie est enleve car cette
            version de Inst ne sert que pour une mise  jour.}
            Message3('Placez-vous dans le rpertoire contenant',
                    'la premire installation de Geocean',
                    'puis relancez la mise  jour');
            ok:=false;fini:=true;
         end;
      until ok or fini;
   end;
   if ok
   then
      tout_copier
{   else
      nettoyer_install};

   salut ;
   finir;

END.    { programme principal }

{--- GEOCEAN - INST -------------------------- R.C.- INRP - TOULOUSE - 1995 }


