Unit MathBase;

Interface
(*{$M 65500, 0, 300000}            {Supprimer cette ligne si Turbo-Pascal 3.0}
USES Crt, Dos, Printer, Graph;   {Supprimer cette ligne si Turbo-Pascal 3.0}*)

{}
{                                                                         }
{               NOTIONS DE BASE pour un programme de MATHS                }
{                                                                         }
{     (Module  inclure systmatiquement dans un programme utilisant      }
{                    une routine de mathmatique)                         }
{Ĳ}
{ MAINTENANCE :                                                           }
{Ĳ}
{              @Alain Reverchon et Marc Ducamp, 1987, France              }
{}

{}
{             CONSTANTES ET TYPES GENERAUX                }
{}
CONST  MAXDONNEES = 800;
       MAXTAMPON  = 3;
       MAXREAL    = 1E37;
       PI         = 3.14159265359;

TYPE

  POINTEUR    = ^BYTE;
  MAXSTRING   = STRING [255];
  CHAINE      = STRING [80];

  DONNEES     = ARRAY  [0..MAXDONNEES] OF real;
  UNTAMPON    = RECORD
                  x, y  : DONNEES;
                  n     : integer;
                END;

{}
{                  VARIABLES GLOBALES                     }
{}
VAR
  err             : boolean;
  tampon          : ARRAY [1..MAXTAMPON] OF UNTAMPON;
  param           : ARRAY [0..99] OF real;

{}
{                  PROCEDURES GLOBALES                    }
{}
PROCEDURE Bip;
PROCEDURE Pause;
FUNCTION ArretDemande : boolean;
{}
{         TRANSFORMATION D'UN NOMBRE EN CHAINE            }
{}
FUNCTION  CHreel (r:real; long,deci:integer) : CHAINE;
FUNCTION  CHint (i:integer; long:integer) : CHAINE;
{}
{                   ENTREE D'UN ENTIER                    }
{}
FUNCTION EntreeEntier (tx:CHAINE; mx:integer) : integer;
{}
{                  ENTREE D'UN BOOLEEN                    }
{}
FUNCTION EntreeBooleen (tx:CHAINE) : boolean;
{}
{    CALCUL DE L'APPROXIMATION RATIONNELLE D'UN REEL      }
{}
PROCEDURE CalculeRationnel (r : real; VAR p,q : real);
{}
{   AFFICHAGE DE L'APPROXIMATION RATIONNELLE D'UN REEL    }
{}
PROCEDURE AfficheRationnel (r : real);
{}
{ AFFICHAGE D'UN NOMBRE (AVEC APPROXIMATION RATIONNELLE)  }
{}
PROCEDURE AfficheNombre (tx:CHAINE; r:real; rat:boolean);
PROCEDURE AfficheNombreln (tx:CHAINE; r:real; rat:boolean);

Implementation

PROCEDURE Bip;
BEGIN
  {sound (400);
  delay (50);
  nosound;}
END;

PROCEDURE Pause;
VAR cc:char;
BEGIN
  (*writeln;
  write ('Appuyez sur une touche ');
  cc := ReadKey;  {Remplacer par read (kbd, cc) si Turbo-Pascal 3.0}
  writeln;*)
END;

FUNCTION ArretDemande : boolean;
VAR cc:char;
BEGIN
  (*ArretDemande := FALSE;
  IF NOT Keypressed THEN exit;
  cc := ReadKey;  {Remplacer par read (kbd, cc) si Turbo-Pascal 3.0}
  IF ord (cc) IN [0, 27] THEN ArretDemande := TRUE;*)
END;

{}
{         TRANSFORMATION D'UN NOMBRE EN CHAINE            }
{}
FUNCTION  CHreel (r:real; long,deci:integer) : CHAINE;
VAR prov : CHAINE;
BEGIN
  CASE long OF
    -1 : BEGIN
           str (r:25:10, prov);
           WHILE (prov [1] = ' ') DO
             prov := copy (prov, 2, length (prov) - 1);
           WHILE (prov [length(prov)] = '0') DO
             prov := copy (prov, 1, length (prov) - 1);
           IF (prov [length(prov)] = '.') THEN
             prov := copy (prov, 1, length (prov) - 1);
         END;
    0  : str (r, prov);
    else str (r:long:deci, prov)
  END;
  IF (r >= 0) THEN prov := ' ' + prov;
  CHreel := prov;
END;

FUNCTION  CHint (i:integer; long:integer) : CHAINE;
VAR prov : CHAINE;
BEGIN
  IF (long > 0)
    THEN str (i:long, prov)
    ELSE str (i, prov);
  CHint := prov;
END;

{}
{                   ENTREE D'UN ENTIER                    }
{}
FUNCTION EntreeEntier (tx:CHAINE; mx:integer) : integer;
VAR cc       : CHAINE;
    i, j, n  : integer;
BEGIN
  FOR i:=1 TO 3 DO
  BEGIN
    write (tx);
    readln (cc);
    val (cc, n, j);
    EntreeEntier := n;
    IF (j = 0) THEN
      IF (n <= mx)
        THEN exit
        ELSE writeln ('Valeur trop grande');
    bip;
  END;
  EntreeEntier := 0;
  writeln (tx, 0);
END;

{}
{                  ENTREE D'UN BOOLEEN                    }
{}
FUNCTION EntreeBooleen (tx:CHAINE) : boolean;
VAR cc : char;
    ok : boolean;
BEGIN
 REPEAT
  write (tx);
  readln (cc);
  ok := TRUE;
  CASE cc OF
   'o', 'O', 'y', 'Y' : EntreeBooleen := TRUE;
   'n', 'N'           : EntreeBooleen := FALSE;
   else ok := FALSE;
  END;
  IF NOT ok THEN bip;
 UNTIL ok;
END;

{}
{    CALCUL DE L'APPROXIMATION RATIONNELLE D'UN REEL      }
{}
PROCEDURE CalculeRationnel (r : real; VAR p,q : real);
VAR ab, ac, af, ar, ax, ay : real;
    dg                    : integer;
BEGIN
 p := 0; q := 1;
 IF (r <> 0) THEN
  BEGIN
   ax := abs (r); ab := ax; ac := INT (ab); p := ac;
   ar := 1; af := 0; dg := 0;
   WHILE (1E6 * abs (ax*q-p) > ax * q) DO
    BEGIN
     ab := 1 / (ab - ac);
     ac := INT (ab);
     ay := ac * p + ar; ar := p; p := ay;
     ay := ac * q + af; af := q; q := ay;
     IF (q>1E7) OR (p*q>1E9) THEN
      BEGIN
       dg := 1;
       p  := ar / af;
       q  := 1;
       ax := p;
      END;
    END;
  END;
 IF (r < 0) THEN p := -p;
END;

{}
{   AFFICHAGE DE L'APPROXIMATION RATIONNELLE D'UN REEL    }
{}
PROCEDURE AfficheRationnel (r : real);
VAR p, q : real;
    i    : integer;
BEGIN
 CalculeRationnel (r, p, q);
 IF (q <> 1) AND (abs (p) < 32700.0) AND (abs (q) < 32700.0) THEN
 BEGIN
   i := ROUND (p);
   write ('  # ', i);
   i := ROUND (q);
   write (' / ', i);
 END;
END;

{}
{ AFFICHAGE D'UN NOMBRE (AVEC APPROXIMATION RATIONNELLE)  }
{}
PROCEDURE AfficheNombre (tx:CHAINE; r:real; rat:boolean);
BEGIN
 write (tx, r:21:10);
 IF rat THEN AfficheRationnel (r)
END;

PROCEDURE AfficheNombreln (tx:CHAINE; r:real; rat:boolean);
BEGIN
 AfficheNombre (tx, r, rat);
 writeln;
END;

end.