UNIT NUAG_1;

   {------------------------------------------------------------------------}
   { logiciel GEOCEAN - module NUAG                                         }
   {                      module NUAGES :   menu FICHIERS                   }
   {                                             version 1.0 du  22/01/95   }
   {------------------------------------------------------------------------}

INTERFACE

{$O+,F+}

USES
   Dos,
   Utildivs,                 { ARX     - utilitaires divers                 }
   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   Dirinfo,                  { ARX     - gestion fichier INFO.DIR           }
   Periphs,                  { ARX     - priphriques, impression, palettes}
   Menus,                    { ARX     - interface menus                    }

   GEO_var,                  { GEO     - variables globales communes        }
   GEO_des,                  { GEO     - procdures graph. communes         }

   NUAG_var,                 { NUAG    - variables globales du module       }
   NUAG_ini,                 { NUAG    - initialisation                     }
   NUAG_des;                 { NUAG    - affichages propres au module       }

Procedure voir_parametres;
   { afficher les listes dans une bote  dfilement                        }

Procedure modifier_lien;
   { slectionner les noms des fichiers de donnes utiles au module NUAG    }
   { pas de changement de la rgion dfinie lors de l'appel (var dos)       }

Procedure supprimer_lien;
   { slectionner les noms des fichiers de donnes utiles au module NUAG    }

Procedure ouvrir_fichier;
   { slectionner un nom de fichier de paramtres existant dans le          }
   { rpertoire de travail (en cours) et rtablir l'environnement de        }
   { travail associ.                                                       }

Procedure nouveau_fichier;
   { slectionner un nouveau nom pour un nouveau fichier de paramtres      }
   { et rtablir l'environnement standard, vt  partir de NUAG.CRT         }

Procedure enregistrer_fichier;
   { enregistre les paramtres en cours sans changer l'tat de l'cran.     }
   { enregistre aussi les donnes                                           }

Procedure enregistrer_sous;
   { copie les paramtres en cours dans un autre fichier                    }
   { copie aussi les donnes                                                }

Procedure quitter;
   { demander confirmation avant de stopper l'excution                     }


{---------------------------------------------------------------------------}

IMPLEMENTATION

procedure voir_parametres;
   begin
      entier := 1;
      creeliste (c_travail, 1);
      creeliste (c_Config , 2);

      liste     (l_params1, l_params2, l_params3, 35, chain, entier);
      case entier of
         1 : voir_ptrav;
         2 : voir_penv;
      end
   end;

procedure modifier_lien;
   begin
 {     chain := nomfcomm;  }
      chang_comm (nomfcomm);
 {     nomfcomm := chain;}
      effacer_tout_redessiner;
      inietat ;
      modipar := true;
   end;

procedure supprimer_lien;
   begin
      { librer la collection }
      liberer_commentaires;

      { effacer}
      nomfcomm := '';
      if visucomm
      then
         effacer_commentaires;
      visucomm := false;
      ini_par_COMM (nomfcomm + extcom); { commentaires }
      modipar  := true;
      inietat;
   end;

procedure verif;
   begin
      ok := true;
      if modipar and not exempl
      then begin
         question (q_verif1, q_verif2, ok);
         if ok
         then
            if ((nomfpar <> nomdumodule))
            then begin
               ecrire_parametres (true);               { sauver_fichiers }
               modipar:= false;
            end else begin
               message (m_donner_nom);
               enregistrer_sous;
            end;
      end;
   end;

procedure ouvrir_fichier;
   var
      ok                : boolean;

   begin
      ok := visucomm;
      verif;
      efftout;                                                      { des }
      dir_info                                                  { dirinfo }
         (choix_nuage, '' , nomutil,
          nomfinfo, '*', extPAR, nomfpar);
      nomfpar :=  sansext (nomfpar);
      if nomfpar = ''
      then
         nomfpar := nomdumodule;
      lire_parametres;
      inidonnees;
      if ok
      then
         effacer_tout_redessiner
      else
         iniecran;                                                    { des }
   end;

procedure nouveau_fichier;
   var
      ok                : boolean;

   begin
      ok := visucomm;
      verif;
      efftout;
      nomfpar := nomdumodule;
      lire_parametres;
      inidonnees;
      if ok
      then
         effacer_tout_redessiner
      else
         iniecran;
   end;

procedure enregistrer_fichier;
   begin
      inietat ;
      if nomfpar = nomdumodule
      then
         nomfpar  := nomfdefo (nomdumodule, nomfpar, nomutil);

      if ((nomfpar <> nomdumodule))
      then begin
         ecrire_parametres (true);
         modipar := false
      end else
         message (m_donner_nom);
   end;

procedure enregistrer_sous;
   var
     ext                : extstr;

   begin
      inietat ;
      ext     := extpar;
      ok      := false;
      if nomfpar = nomdumodule
      then
         nomfpar  := nomfdefo (nomdumodule, nomfpar, nomutil);

      nomfichier_sortie                                    { menus5 }
         (nomf_nouveau+'(' +extpar+ ')', '', nomfpar, ext, ok);

      if (nomfpar = nomdumodule) and prof
      then begin
         ok := false;
         question (q_creer1, q_creer2, ok);
      end;

      if ((nomfpar <> nomdumodule) or prof) and ok
      then begin
         nomfcomm := nomfpar;
         inietat  ;
         ecrire_parametres (true);
         modipar := false
      end else
         message (m_lefichier+' '+nomfpar+' '+m_lefichiers);
   end;

procedure quitter;
   begin
      question (q_quitter1, q_quitter2, fini);
      if fini
      then
         verif;
   end;


END.

{--- GEOCEAN - NUAG_1 ------------------------ R.C.- INRP - TOULOUSE - 1995 }
