UNIT NUAG_VAR;

   {------------------------------------------------------------------------}
   {      logiciel GEOCEAN                                                  }
   {               variables globales du module  NUAGES                     }
   {------------------------------------------------------------------------}

INTERFACE

{$O+,F+}

USES
   dos,
   graph,
   lipar,
   graphism,
   math3d_c,

   GEO_VAR;

CONST
   coefpi               = 0.01745329252; { pi/180 }
   infini               =   1e38;

   xg                   =      0;
   yh                   =      0;

   nmax                 =  10921;
   nsmax                =   nmax;
   nsbloc6              =    128;              { 128 sommets pour 64 lignes }
   nsbloc4              =     40; { !! non fait  80 sommets pour 40 lignes }
   nsbloc2              =     40;              {  40 sommets pour 20 lignes }
   nsbloc1              =     18;              {  18 sommets pour  6 lignes }

   {$I nuag_msg.pas}                           { messages en Franais       }

TYPE
   points               =  record
                              x,
                              y,
                              z         : integer
                           end;

   liste_de_points      =  array  [0..nmax]  of points;

   liste_pts            =  record
                              pts       : ^liste_de_points;
                              debut,
                              fin       : integer;
                              contours,
                              bloc      : boolean;
                            end;

   liste_de_reels       =  array  [0..nmax]  of real;

   liste_r              =  ^liste_de_reels;

VAR
   mx, my, mz,
   mr, mr0,
   mx1, my1, mz1        : mat;
   org                  : vect;

   mxx, mxy, mxz,
   myx, myy, myz,
   mzx, mzy, mzz,
   azimut, site,
   zoom,
   zoom_z,
   zoom_max_abs,
   zoom_max,
   zoom_z_max,

   xmin,  xmax,
   ymin,  ymax,
   zmin,  zmax,
   xlmax, ylmax,
   zlmax,

   diametre,
   echelle,
   echelle_z,
   ech_z_init,
   coefblz                 { coef pour adapter courbes en relief  la donne
                             principale }
                        : real;

   c_est,                  { couleurs du  tridre }
   c_nord,
   c_ciel               : word;

   nsbloc,                 { nombre sommets bloc }
   minzvue,                { min et max : loignement calcul des points }
   maxzvue,
   nbpoints,
   nbseismes,
   ray,
   debut, fin,
   demi_dim,
   pas_r,
   xxg, xxd,
   yyh, yyb,
   xxm, yym
                        : integer;

   quatrieme_donnee,
   seismes_x,
   seismes_y,
   seismes_z            : liste_r;

   reference,
   vue0,
   vue1, vue2           : liste_pts;

   visubloc,
   fils_seuls,
   axes_ecran,
   inversion_z,
   bln                  : boolean;

   fichier              : text;

 (*  format_z,               { format zoom }
   unite_a_z            : t12;
*)
   nomfpal,
   nomfcart             : namestr;

   extcart              : extstr;


IMPLEMENTATION

BEGIN

   nomdumodule := 'NUAG';
   extpar      := '.NGS';

END.

{ GEOCEAN - NUAG_VAR ------------------------- R.C.- INRP - TOULOUSE - 1995 }

