UNIT SYMBOLES;

{---------------------------------------------------------------------------}
{         ARX                                                               }
{                          Unite SYMBOLES et ZONES                          }
{                                                                           }
{---------------------------------------------------------------------------}
(*
   Symboles,                 { ARX     - Affichage des valeurs ponctuelles  }
*)

INTERFACE

{$O+,F+}

USES
   dos,
   graph,                    { TP 70   - units standard Borland            }
   Souris,                   { ARX     - gestion de la souris               }
   Clavier,                  { ARX     - gestion du clavier                 }
   Graphism,                 { ARX     - initialisations graphiques         }
   Messarx,                  { ARX     - Textes des Messages de Base        }
   Graphplt,                 { ARX     - graphisme 2D cran/traceur         }
   Graphsg,                  { ARX     - symboles et graduations            }
   Lipar,                    { ARX     - gestion fichiers paramtres        }
   Edition,                  { ARX     - saisie/dition paramtres          }
   Utildivs,                 { ARX     - utilitaires divers                 }
   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   Periphs;                  { ARX     - priphriques, impression, palettes}


CONST
   q_zone1              = 'Quelle zone ?';
   q_zone2              = '         ';
   q_zone3              = 'zones';
   n_ensemble           = 'ensemble';
   n_Symboles           = 'Symboles';
   t_zone               = 'Dfinir une zone';
   b_nom                = 'Nom de la zone  '; {"}
   b_binf               = 'Borne infrieure '; {"}
   b_couleur            = 'Couleur          '; {"}
   b_colonne            = 'Colonne/couleur  ';
   b_colcode            = 'Colonne/code     ';
   b_colangle           = 'Colonne/angle    ';
   b_trait              = 'Trait            ';
   b_smb                = 'Symbole          '; {"}
   b_haut               = 'Hauteur          '; {"}
   b_angle              = 'Angle            '; {"}
   b_haut_min           = 'Hauteur min      ';
   b_haut_max           = 'Hauteur max      ';
   choix_rang           = 'Quelle valeur reprsenter ?';

   t_detruire           = 'Dtruire cette zone';
   ch_z_coul            = 'Zones de couleur';
   ch_z_smb             = 'Zones de symboles';
   c_z1                 = 'Ajouter   ';   {"}
   c_z2                 = 'Modifier  ';   {"}
   c_z3                 = 'Supprimer ';   {"}
   l_zone               = 'zones';
   t_nombre             = 'FORMAT NOMBRE';
   b_chiffres           = 'Nbre chiffres  '; {"}
   b_deci               = 'Nbre dcimales '; {"}
   c_entier             = 'entier         '; {"}
   c_1deci              = 'une dcimale   '; {"}
   c_2deci              = 'deux dcimales '; {"}
   c_autref             = 'autre format   '; {"}
   l_nb1                = '';
   l_nb2                = 'FORMAT NOMBRE :';
   l_nb3                = 'cadrs  gauche';
   c_aucune             = 'aucune';
   n_fixe               = 'fixe';
   t_points             = 'Reprsentation des valeurs ponctuelles';


   extps                = '.SMP'; {                                symboles }
   extvs                = '.DAT'; {              donnes ponctuelles        }
   hcarmin              =  1;     { hauteur mini symbole                    }
   hcarmax              = 50;     {         maxi                            }
   nbmaxzones           = 10;

TYPE
   tabstr12             = array [1..nbmaxzones]
                             of t12;

VAR
   parsymbd,
   parsymb                           {            symboles                  }
                        : lipar.liste;

   strufic                           { image de la structure du fichier     }
                        : string;

   entier,
   typedat                 { type de reprsentation des valeurs ponctuelles }
                        : integer;

   visuzonesmb,                        { zones de symboles visibles         }
   ok,
   VISUSYMB,                           {symboles affichs qqsoit le mode    }
   aff_u,                              { affichage uniforme                 }
   taille_u,                           { taille unique                      }
   coul_u,                             { couleur unique                     }
   angle_u                             { angle unique                       }
                        : boolean;

   reel,
   borne_inf,                          { bornes infrieure et suprieure    }
   borne_sup,
   dist_x,                             { dcalage en X et Y                 }
   dist_y,
   haut_s,                             { hauteur en mm                      }
   angl_s,                             { angle direction symbole en degrs  }
   h_min, h_max,                       { min et max si h proportionnelle    }
   min_v, max_v,                       { min et max des valeurs             }
   coefc3, coefc4, coefvs,             { coef. appliqu sur les donnes     }
   pasc3,  pasc4,  pasvs               { pas d'affichage des limites valeur }
                        : real;

   align_s,                            { justification / point              }
   nbdcs,                              { nombres de chiffres                }
   nbdds,                              { nombre de dcimales                }
   codaski,                            { code ASCII pour valeur unique      }
   rang_v,                             { rang de la valeur  reprsenter    }
   rang_a,                             { rang de l'angle de rotation        }
   rang_c,                             { rang de la couleur                 }
   rang_k,                             { rang du code ASCII                 }
   coul_s,                             { couleur                            }
   nbnum                               { nb. col. numriques du fichier 1-5 }
                        : integer;

{   coulsymb                             = coul_s
                        : couleur_palette;
}
   fdp                                 { Format donnes ponctuelles         }
                        : string [3];
   libcol,
   unitval              : t12;

   z_smb                               { zones de symboles                  }
                        : lst_chn;

   nomfvs,                             { valeurs ponctuelles en cours  .DAT }
   nomfps                              { paramtres v. ponctuelles     .SMP }
                        : namestr;

   zs1, zs2                            { zones bote dition                }
                        : PZoneSymboles;

   format_3d,
   format_4d,
   format_5d
                        : string [3];
   libcol_3,
   libcol_4,
   libcol_5,                           { libells des valeurs du fichier DAT}
   unitval3,
   unitval4,
   unitval5
                        : t12;
{---------------------------------------------------------------------------}

Procedure initextes_titres;
   { }

Procedure voir_un         (police       : byte;
                           c, k         : integer;
                           h, a, xs, ys : real);
   { dessine un symbole                                                     }

Procedure DessinerTraits  (px, py, kod  : integer);

Procedure DessinerTraits2 (px, py, kod  : integer);
   { Dessine les types de traits disponibles dans une boite dition         }

Function  nom_element     (p_ct         : lst_chn;
                           num          : integer)     : t12;
   { Rend le nom de l'lment NUM                                           }

Procedure ini_par_symbd   (nomf         : pathstr);
   { initialisation des paramtres des symboles / DONNEES                   }

Procedure ini_par_symb    (nomf         : pathstr);
   { initialisation des paramtres des symboles / utilisateur               }

Procedure liberer_zones   (var z_coul   : lst_chn);
   { libre tous les pointeurs sur une zone                                 }

Function  nb_zones        (p_ct         : lst_chn )    : integer;
   { rend le nombre de zones                                                }

Function  altmaxi_zone    (p_ct         : lst_chn ;
                           numz         : integer;
                           maxc         : real)        : real;
   { rend la valeur maxi d'une zone                                         }

Function  alt_mini_zone   (p_ct         : lst_chn ;
                           alt, minc, maxc : real)     : boolean;
   { rend VRAI si alt = minimum d'une zone de couleurs                      }

Function  couleur_zone    (p_ct         : lst_chn ;
                           alt, minc, maxc : real)     : integer;
   { rend le nom de la couleur de base pour la courbe ALT                   }

Function  altmini_zone    (p_ct         : lst_chn ;
                           numz         : integer;
                           minc         : real)        : real;
   { rend la borne infrieure de la zone                                    }

Function  trait_zone      (p_ct         : lst_chn ;
                           alt, minc, maxc : real)     : integer;
   { rend le N du type de trait pour la courbe ALT                         }

Function  code_zone       (p_ct         : lst_chn ;
                           alt, minc, maxc : real)     : integer;
   { rend le N du code ASCII de la zone qui contient la valeur ALT         }

Function  taille_zone     (p_ct         : lst_chn ;
                           alt, minc, maxc : real)     : real;
   { rend la hauteur du symbole en mm  de la zone qui contient la valeur    }

Function  angle_zone      (p_ct         : lst_chn ;
                           alt, minc, maxc : real)     : real;
   { rend la direction du symbole de la zone qui contient la valeur ALT     }

Function  num_zone        (p_ct         : lst_chn ;
                           alt, minc, maxc : real)     : integer;
   { rend le N de la zone qui contient la courbe ALT                       }

Procedure ini_zone_1      (nbv,
                           coulz        : word;
                           txtz         : t12;
                           var z        : lst_chn;
                           min, max     : real);
   { }

Procedure modifie_z       (nbv, numz    : integer;
                           txtz, uz     : t12;
                           var z_coul   : lst_chn;
                           minc, maxc   : real;
                           var ok, suppr : boolean);
   { }

Procedure ajoute_z        (nbv          : integer;
                           txtz, uz     : t12;
                           var z_coul   : lst_chn;
                           minc, maxc   : real;
                           var ok       : boolean);
   { }

Procedure supprime_z      (numz         : integer;
                           var z_coul   : lst_chn);
   {}

Procedure choix_zones     (nbv          : integer;
                           txtz, uz     : t12 ;
                           var z_coul   : lst_chn ;
                           minc, maxc   : real);
   { LISTE : Appel des procdures Modifie_z, Ajoute_z, supprime_z ci-dessus }
   { nbv  = nombre valeurs; txtz : titre; z_coul : pointeur de la liste     }
   { minc = minimum valeur; maxc = maxi valeur                              }

{---------------------------------------------------------------------------}

Procedure choix_symboles   (var change  : boolean);
   { Saisie caractritiques des symboles sans changer de type               }

Procedure ini_valeurs_symb (nomf        : pathstr ;
                            rg          : byte);
   { Teste la structure du fichier                                          }
   { rg > 0 :  colonne choisie  priori ; rien si colonne rg absente        }

Procedure ecrire_par_symb  (nomf        : pathstr);
   { Met  jour les paramtres du fichier symboles courant                  }

{Procedure choix_type_aff_symboles (var change : boolean);}
   { saisie type d'affichages des symboles                                  }

Procedure voir_symboles    (nomf        : pathstr ;
                            eff         : boolean);
   { Affiche les symboles dans la fentre/clture courante                  }

Procedure choix_format_nombre
                           (var nb_chi,
                            nb_dec      : integer);
   { Saisie nombre de chiffres et dcimales                                 }


{---------------------------------------------------------------------------}

IMPLEMENTATION

TYPE
   TxtSymb              = string [12];

VAR

   chain                : chainecar;
   min                  : real;
   nbco                 : integer;
   l1                   : tabstr12;   { 10 zones max }

{---------------------------------------------------------------------------}

procedure voir_un (police : byte; c, k : integer; h, a, xs, ys : real);
   begin
      fixecoul (c);
      initialiser_parametres_courants (police, h, a, 0, k);
      deplaceenl      (xs, ys);
      dessine_un_symb (k);
   end;

procedure DessinerTraits (px, py, kod : integer);
   begin
      case kod of
         0 : begin
                setlinestyle (0, 0, 1);
                line (px-zs1^.lx div 2, py-zs1^.lx div 2,
                      px+zs1^.lx div 2, py-zs1^.lx div 2);
              end;
         1 : begin
                setlinestyle (1, 0, 1);
                line (px-zs1^.lx div 2, py-zs1^.lx div 2,
                      px+zs1^.lx div 2, py-zs1^.lx div 2);
             end;
         2 : begin
                setlinestyle (2, 0, 1);
                line (px-zs1^.lx div 2, py-zs1^.lx div 2,
                      px+zs1^.lx div 2, py-zs1^.lx div 2);
             end;
         3 : begin
                setlinestyle (3, 0, 1);
                line (px-zs1^.lx div 2, py-zs1^.lx div 2,
                      px+zs1^.lx div 2, py-zs1^.lx div 2);
             end;
      end;
      setlinestyle (0, 0, 1);
   end;

procedure DessinerTraits2 (px, py, kod : integer);
   begin
      case kod of
         0 : begin
                setlinestyle (0, 0, 1);
                line (px-zs2^.lx div 2, py-zs2^.lx div 2,
                      px+zs2^.lx div 2, py-zs2^.lx div 2);
             end;
         1 : begin
                setlinestyle (1, 0, 1);
                line (px-zs2^.lx div 2, py-zs2^.lx div 2,
                      px+zs2^.lx div 2, py-zs2^.lx div 2);
             end;
         2 : begin
                setlinestyle (2, 0, 1);
                line (px-zs2^.lx div 2, py-zs2^.lx div 2,
                      px+zs2^.lx div 2, py-zs2^.lx div 2);
             end;
         3 : begin
                setlinestyle (3, 0, 1);
                line (px-zs2^.lx div 2, py-zs2^.lx div 2,
                      px+zs2^.lx div 2, py-zs2^.lx div 2);
             end;
      end;
      setlinestyle (0, 0, 1);
   end;

procedure ini_par_symbd (nomf : pathstr);
   begin
      parsymbd.init (false);
      parsymbd.ajoute (Cstring  ('nom des valeurs col 3' , @libcol_3, 'Profondeur'));
      parsymbd.ajoute (Cstring  ('units des valeurs c3' , @unitval3,  'Km' ));
      parsymbd.ajoute (Creal    ('coefficient        c3' , @coefc3,    -1 ));
      parsymbd.ajoute (Creal    ('pas                c3' , @pasc3,     10 ));
      parsymbd.ajoute (Cstring  ('format nombre      c3' , @format_3d, '4:0'));

      parsymbd.ajoute (Cstring  ('nom des valeurs col 4' , @libcol_4, 'Magnitude'));
      parsymbd.ajoute (Cstring  ('units des valeurs c4' , @unitval4,  '' ));
      parsymbd.ajoute (Creal    ('coefficient        c4' , @coefc4,     1 ));
      parsymbd.ajoute (Creal    ('pas                c4' , @pasc4,    0.5 ));
      parsymbd.ajoute (Cstring  ('format nombre      c4' , @format_4d,  '3:1'));

      parsymbd.ajoute (Cstring  ('structure du fichier'  , @strufic,  'rrrr.' ));

      parsymbd.ajoute (Cinteger ('nombre colonnes nombres', @nbnum,      4 ));

      if ftxt_present (nomf)
      then
         parsymbd.lit (nomf);
   end;

procedure initextes_titres;
   begin
      fdp := '6:0';
      case rang_v of
         3 : begin
                libcol  := libcol_3;
                unitval := unitval3;
                fdp     := format_3d;
             end;
         4 : begin
                libcol  := libcol_4;
                unitval := unitval4;
                fdp     := format_4d;
             end;
         5 : begin
                libcol  := libcol_5;
                unitval := unitval5;
                fdp     := format_5d;
             end;
      end;
   end;

procedure ini_par_symb (nomf : pathstr);
   begin
      parsymb.init (false);
      {parsymb.ajoute (Cstring  ('donnes symboles'      , @nomfvs,    ''));}
      { version 1 seule srie : nom srie = nom du fichier valeurs
      parsymb.ajoute (Cstring  ('srie   symboles'      , @nomfs,     ''));}
      parsymb.ajoute (Cinteger ('type de reprsentation', @typedat,   1 ));
      parsymb.ajoute (Cboolean ('code unique'           , @aff_u,      true));
      parsymb.ajoute (Cboolean ('taille unique'         , @taille_u,    true));
      parsymb.ajoute (Cinteger ('justification '        , @align_s,   1 ));
      parsymb.ajoute (Creal    ('distance x'            , @dist_x,    0 ));
      parsymb.ajoute (Creal    ('distance y'            , @dist_y,    0 ));
      parsymb.ajoute (Cinteger ('Nombre de chiffres'    , @nbdcs,     0 ));
      parsymb.ajoute (Cinteger ('Nombre de dcimales'   , @nbdds,     0 ));
      parsymb.ajoute (Cinteger ('code ascii'            , @codaski,  32 ));
      parsymb.ajoute (Creal    ('hauteur texte'         , @haut_s,    3 ));
      parsymb.ajoute (Creal    ('hauteur min texte'     , @h_min,     1 ));
      parsymb.ajoute (Creal    ('hauteur max texte'     , @h_max,     5 ));
      parsymb.ajoute (Cinteger ('rang_valeur'           , @rang_v,    0 ));
   {   parsymb.ajoute (Cinteger ('rang_angle'            , @rang_a,    2 ));
      parsymb.ajoute (Cinteger ('rang_couleur'          , @rang_c,    2 ));
      parsymb.ajoute (Cinteger ('rang_code'             , @rang_k,    2 ));}
      parsymb.ajoute (Creal    ('valeur minimum'        , @borne_inf, 0 ));
      parsymb.ajoute (Creal    ('valeur maximum'        , @borne_sup, 0 ));
      parsymb.ajoute (Creal    ('direction criture'    , @angl_s,    0 ));
      parsymb.ajoute (Cword    ('couleur symboles'      , @coul_s,    8 ));
      parsymb.ajoute (Clst_chn ('zones de symboles'     , @z_smb,   nil ));
      parsymb.ajoute (Creal    ('valeur minimum fichier', @min_v,     0 ));
      parsymb.ajoute (Creal    ('valeur maximum fichier', @max_v,     0 ));
      parsymb.ajoute (Creal    ('pas d''affichage'      , @pasvs,     1 ));
      parsymb.ajoute (Creal    ('coefficient donnes'   , @coefvs,    1 ));

      if ftxt_present (nomf)
      then
         parsymb.lit (nomf);
 {     coulsymb    := nomcouleur (coul_s);}
      rang_a := 2;
      rang_c := 2;
      rang_k := 2;
      visuzonesmb := (typedat = 5) and (z_smb <> nil);
  end;

procedure ecrire_par_symb         (nomf : pathstr);
   { Met  jour les paramtres du fichier symboles courant                  }
   begin
      parsymb.ecrit (nomf, '');
   end;

procedure liberer_zones (var z_coul : lst_chn);
   begin
      liberer_liste_chaine (z_coul);
   end;

procedure Supprimer_zone  (var z_coul    : lst_chn;
                               numz      : integer);
   { z_coul <> nil , nbz > 0 et numz > 0 }
   { si nbz = 1 alors numz = 1 }
   var
      p_suiv,
      p_sup, prem,
      p_ct, p_pre    : lst_chn;
      i              : integer;

   begin
      if z_coul = nil then exit;
      if z_coul^.suivant <> nil  { nbz > 1}
      then begin
         p_ct   := z_coul;
         p_pre  := z_coul;
         p_suiv := z_coul^.suivant;

         i     := 1;
         while i < numz
         do begin          { i > 1 ; recherche la zone  supprimer }
            inc (i);
            p_pre  := p_ct;
            p_ct   := p_ct^.suivant;
            p_suiv := p_ct^.suivant;
         end;
         p_sup          := p_ct;
         p_sup^.suivant := nil;

         if i = 1
         then
            z_coul := p_suiv
         else
            p_pre^.suivant := p_suiv;
      end else begin
         { supprimer le seul lment prsent }
         p_sup  := z_coul;
         z_coul := nil;
      end;
      liberer_liste_chaine (p_sup);
   end;

procedure ajoute_zone (var z_coul : lst_chn;
                           nbelem : integer);
   var
      p_ct, p_pre,
      z_nouv            : lst_chn;

   procedure cree_2_elemzone;
      begin
         new (z_nouv^.elements^.elements);  { val 1 }
         cree_nom_chn
             (z_nouv^.elements^.elements, '');
              z_nouv^.elements^.elements^.elements     := nil;

         new (z_nouv^.elements^.elements^.suivant);  { val 2}
         cree_nom_chn
             (z_nouv^.elements^.elements^.suivant, '');
              z_nouv^.elements^.elements^.suivant^.elements := nil;
              z_nouv^.elements^.elements^.suivant^.suivant  := nil;
      end;

   procedure cree_4_elemzone;
      begin
         cree_2_elemzone;
         new (z_nouv^.elements^.elements^.suivant^.suivant); { val 3 }
         cree_nom_chn
             (z_nouv^.elements^.elements^.suivant^.suivant, '');
              z_nouv^.elements^.elements^.suivant^.suivant^.elements := nil;
              z_nouv^.elements^.elements^.suivant^.suivant^.suivant  := nil;

         new (z_nouv^.elements^.elements^.suivant^.suivant^.suivant); { val 4 }
         cree_nom_chn
             (z_nouv^.elements^.elements^.suivant^.suivant^.suivant, '');
              z_nouv^.elements^.elements^.suivant^.suivant^.suivant^.elements := nil;
              z_nouv^.elements^.elements^.suivant^.suivant^.suivant^.suivant  := nil;
      end;

   begin
      new (z_nouv);
           cree_nom_chn (z_nouv, '');
                         z_nouv^.suivant := nil;

      new (z_nouv^.elements);
           cree_nom_chn (z_nouv^.elements, '');
                         z_nouv^.elements^.suivant := nil;

      case nbelem of
         2 : cree_2_elemzone;
         4 : cree_4_elemzone;
      end;
      p_ct  := z_coul;
      p_pre := z_coul;
      while p_ct <> nil
      do begin
         p_pre := p_ct;
         p_ct  := p_ct^.suivant;
      end;

{      inc (nbz);
      if nbz = 1
         then z_coul         := z_nouv
         else p_pre^.suivant := z_nouv; }

      if z_coul = nil
      then
         z_coul         := z_nouv
      else
         p_pre^.suivant := z_nouv;
   end;

procedure modifie_zone     (nbv ,
                            numz   : word;
                            p_ct   : lst_chn;
                            altz   : real;
                           { nbz,}
                            coulz,
                            v2     : integer;
                            v3,
                            v4     : real;
                            nomz   : t12);
   var
      p_pre                  : lst_chn;
      num                    : integer;
      alts, couls,
      v2s, v3s, v4s          : t12;

   begin
      if p_ct = nil then exit;                  { la liste n'est pas vide }
      str (altz:10:2, alts);
      str (coulz,     couls);
      str (v2,        v2s);  { ou code }
      str (v3,        v3s);
      str (v4,        v4s);

      p_pre := p_ct;
      num   := 0;
      while num < numz
      do begin
         inc (num);
         p_pre := p_ct;
         p_ct  := p_ct^.suivant;
      end;
      modif_nom_chn (p_pre, nomz);
      modif_nom_chn (p_pre^.elements, alts);
      modif_nom_chn (p_pre^.elements^.elements, couls);
      if nbv > 2
      then begin
         modif_nom_chn
                 (p_pre^.elements^.elements^.suivant, v2s);
         modif_nom_chn
                 (p_pre^.elements^.elements^.suivant^.suivant, v3s);
         modif_nom_chn
                 (p_pre^.elements^.elements^.suivant^.suivant^.suivant, v4s);
      end else
         modif_nom_chn
                 (p_pre^.elements^.elements^.suivant, v2s);
   end;

procedure ini_zone_1       (nbv,
                            coulz    : word;
                            txtz     : t12;
                            var z    : lst_chn;
                            min, max : real);
   var
      v2                : word;

   begin
      if z = nil
      then begin
         if nbv = 2
         then
            v2  :=  0
         else
            v2  := 32;

         ajoute_zone   (z, nbv);
         modifie_zone  (nbv, 1, z, min,
                        coulz, v2, haut_s, angl_s, n_ensemble);
      end;
   end;

function nb_zones (p_ct : lst_chn) : integer;
   var
      nbz               : integer;

   begin
      nbz  := 0;
      while p_ct <> nil
      do begin
         p_ct := p_ct^.suivant;
         inc (nbz)
      end;
      nb_zones := nbz;
   end;

function altmini_zone (p_ct : lst_chn ; numz : integer; minc : real) : real;
   var
      num, err          : integer;
      altz              : real;
      alts              : t12;

   begin
      if p_ct = nil
      then begin
         altmini_zone := minc;
         exit
      end;

      { la liste n'est pas vide }
      num   := 1;
      while num < numz
      do begin
         inc (num);
         p_ct  := p_ct^.suivant;
      end;
      alts := p_ct^.elements^.nom^ ;
      val (alts, altz, err);
      altmini_zone := altz;
   end;

function alt_mini_zone (p_ct : lst_chn ; alt, minc, maxc : real) : boolean;
   var
      numz              : integer;

   begin
      numz := num_zone (p_ct, alt, minc, maxc);
      alt_mini_zone := (alt = altmini_zone (p_ct, numz, minc));
   end;

function altmaxi_zone (p_ct : lst_chn ; numz : integer; maxc : real) : real;
   var
      num, err          : integer;
      altz              : real;
      alts              : t12;

   begin
      if p_ct = nil
      then begin
         altmaxi_zone := maxc;
         exit
      end;

      { la liste n'est pas vide }
      num   := 1;
      while num < numz
      do begin
         inc (num);
         p_ct  := p_ct^.suivant;
      end;

      if p_ct^.suivant <> nil          { il y a une autre zone }
      then begin
         alts := p_ct^.suivant^.elements^.nom^;
         val (alts, altz, err);
         altmaxi_zone := altz;
      end else
         altmaxi_zone := maxc;
   end;

function val_zone (numv : integer; p_ct : lst_chn ; alt, minc, maxc : real): integer;
   var
      alts, alts2,
      vals         : t12;
      valz         : integer;
      altz, altz2  : real;
      err          : integer;
      dans_zone_c  : boolean;

   begin
      dans_zone_c := false;
      while (p_ct <> nil) and (not dans_zone_c)
      do begin
         alts   := p_ct^.elements^.nom^;
         case numv of
          1 : vals := p_ct^.elements^.elements^.nom^;
          2 : vals := p_ct^.elements^.elements^.suivant^.nom^;
{          3 : vals := p_ct^.elements^.elements^.suivant^.suivant^.nom^;
          4 : vals := p_ct^.elements^.elements^.suivant^.suivant^.suivant^.nom^;}
         end;
         val (alts, altz, err);
         p_ct := p_ct^.suivant;
         if p_ct <> nil
         then begin
            alts2 := p_ct^.elements^.nom^;
            val (alts2, altz2, err)
         end else
            altz2 := maxc  ;
         dans_zone_c := (not dans_zone_c) and
                        (alt >= altz) and (alt < altz2);
      end;

      if not dans_zone_c
      then
         val_zone := -1
      else begin
         val (vals, valz, err);
         val_zone := valz;
      end
   end;

function val_zone_r (numv : integer; p_ct : lst_chn ; alt, minc, maxc : real): real;
   var
      alts, alts2,
      vals         : t12;
      valz,
      altz, altz2  : real;
      err          : integer;
      dans_zone_c  : boolean;

   begin
      dans_zone_c := false;
      while (p_ct <> nil) and (not dans_zone_c)
      do begin
         alts   := p_ct^.elements^.nom^;
         case numv of
{          1 : vals := p_ct^.elements^.elements^.nom^;
          2 : vals := p_ct^.elements^.elements^.suivant^.nom^; }
          3 : vals := p_ct^.elements^.elements^.suivant^.suivant^.nom^;
          4 : vals := p_ct^.elements^.elements^.suivant^.suivant^.suivant^.nom^;
         end;
         val (alts, altz, err);
         p_ct := p_ct^.suivant;
         if p_ct <> nil
         then begin
            alts2 := p_ct^.elements^.nom^;
            val (alts2, altz2, err)
         end else
            altz2 := trunc (maxc) ;
         dans_zone_c := (not dans_zone_c) and
                        (alt >= altz) and (alt < altz2);
      end;

      if not dans_zone_c
      then
         val_zone_r := -1
      else begin
         val (vals, valz, err);
         val_zone_r := valz;
      end
   end;

function couleur_zone (p_ct : lst_chn ; alt, minc, maxc : real) : integer;
   begin
      entier := val_zone ( 1, p_ct, alt, minc, maxc );
      if entier < 0
      then
         couleur_zone := coul_s
      else
         couleur_zone := entier;
   end;

function trait_zone (p_ct : lst_chn ; alt, minc, maxc : real): integer;
   begin
      trait_zone := val_zone ( 2, p_ct, alt, minc, maxc );
   end;

function code_zone (p_ct : lst_chn ; alt, minc, maxc : real): integer;
   begin
      entier := val_zone ( 2, p_ct, alt, minc, maxc );
      if entier < 0
      then
         code_zone := codaski
      else
         code_zone := entier;
   end;

function taille_zone (p_ct : lst_chn ; alt, minc, maxc : real): real;
   begin
      reel := val_zone_r ( 3, p_ct, alt, minc, maxc );
      if reel < 0
      then
         taille_zone := haut_s
      else
         taille_zone := reel;
   end;

function angle_zone (p_ct : lst_chn ; alt, minc, maxc : real): real;
   begin
      reel := val_zone_r ( 4, p_ct, alt, minc, maxc );
      if reel < 0
      then
         angle_zone := angl_s
      else
         angle_zone := reel;
   end;

function num_zone (p_ct : lst_chn ; alt, minc, maxc : real) : integer;
   var
      nomz,
      alts, alts2  : t12;
      altz, altz2  : real;
      numz, err    : integer;
      dans_zone_c  : boolean;

   begin
      numz := 0;
      dans_zone_c := false;
      while (p_ct <> nil) and (not dans_zone_c)
      do begin
         inc (numz);
         nomz   := p_ct^.nom^;
         alts   := p_ct^.elements^.nom^;
         val (alts, altz, err);
         p_ct := p_ct^.suivant;
         if p_ct <> nil
         then begin
            alts2 := p_ct^.elements^.nom^;
            val (alts2, altz2, err)
         end else
            altz2 := maxc ;
         dans_zone_c := (not dans_zone_c) and (alt >= altz) and (alt < altz2);
      end;
      num_zone := numz;
   end;

function nom_element (p_ct : lst_chn ; num : integer) : t12;
   var
      numz              : integer;
      nomz              : t12;

   begin
      numz := 0;
      while (p_ct <> nil) and (numz < num)
      do begin
         inc (numz);
         nomz   := p_ct^.nom^;
         p_ct   := p_ct^.suivant;
      end;
      nom_element := nomz;
   end;

function quelnumero (l1 : tabstr12 ; nb : integer ;
                     tz, tz2, tb        : t12)
                                                                : integer;
   var
      num            : byte;
      i,
      touche, poscur : integer;
      boite          : PBoiteSaisie;
      zl1            : PZoneliste;

   begin
      num     := 1;
      Zl1     := new (PZoneListe,
                 init ( 0, 0,  c_f_boite_norm, c_t_boite_norm, @num,
                 tz, tz2));
      Zl1^.cnom := colorf;
      for i := 1 to nb
      do
         ZL1^.Liste.insert (@l1 [i]);

      boite   := new (PBoiteSaisie,
                 init (milieu, milieu, 15, c_f_boite_norm, c_t_boite_norm,
                 tb));
      poscur := 1;
      laide (aidedit);
      boite^.ajoute (zl1);
      boite^.editeF (1, Poscur, Touche);
      laide ('');
      boite^.vider;
      dispose (boite, fini);

      if (touche = ESC) {or (touche = 0)}
      then
         num := 1;
      quelnumero := num;
   end;

function quellezone  (l1 : tabstr12 ; nb : integer; txtz : t12) : integer;
   begin
      quellezone := quelnumero (l1, nb,
                    q_zone1, q_zone2, q_zone3 +txtz);
   end;

procedure affi_un_symb_edit ( px, py, kod : integer);
   begin
      moveto (px, py-ty div 2);
      dessine_un_symb (kod+32);
   end;

procedure choix_param_z (nbv, numz  : integer ;
                         txtz, uz   : t12;
                         minc, maxc : real;
                         var nomz   : t12;
                         var v0     : real;        { altz mini              }
                         var v1,                   { couleur   0..15        }
                             v2     : integer;     { code      0..3 ou 0..7 }
                         var v3,                   { taille    0   50 mm    }
                             v4     : real;        { direction 0   360     }
                         var ok,                   { sortie sans ESC        }
                             suppr  : boolean);    { E/S  avec suppression  }
                        { NBV = 2 ... coulz, traitz                  }
                        { ou                                         }
                        { NBV = 4 ... coul_s, codaski, taille, angle }

                      { suppr = true en entre inhibe le bouton suppression }
   var
      i,
      touche, poscur,
      e2                : integer;
      ch1               : t12;
      r0, r3, r4        : real;
      tt1, cc1, sy1     : byte;
      boite             : PBoiteSaisie;
      z0, z3, z4        : PZoneReel;
      zc                : PZoneChaine;
      zc1               : PzoneCouleur;
      zy1               : PZoneSymboles;
      zb1               : PZoneBooleen;
      nums              : string;

   begin
      ok      := true;          { VALIDATION active }
      cc1     := byte (v1);
      r0      := v0;
      r3      := v3;
      e2      := v2;
      r4      := v4;
      ch1     := nomz;

    {  if nbv > 2
      then
         chain := unitval
      else
         chain := uz;}

      boite   := new (PBoiteSaisie,
                 init (milieu, milieu,  15,    c_f_boite_norm, c_t_boite_norm,
                 t_zone+' : '+ txtz));

      { nom }
      str (numz, nums);
      zc      := new (PZoneChaine,
                 init ( 0,     0,  str12,    colorf, colord, @nomz,
                 b_nom + nums, ''));
      boite^.ajoute (zc);

      { borne inf }
      z0      := new (PZoneReel,
                 init ( 0,     0,   7, 0,    colorf, colord, @v0,
                 b_binf, uz));
      boite^.ajoute (z0);

      { couleur }
      Zc1     := new (PZoneCouleur,
                 init ( 0,     0,                      @cc1,
                 b_couleur, '', pal));
      Zc1^.cnom := colorf;
      boite^.ajoute (zc1);

      if nbv = 2
      then begin
         { trait }
         tt1     := byte (v2);
         Zs1  := new (PZoneSymboles,
                 init ( 0,     0,         colorf, coulboite, @tt1,
                 b_Trait, '', DessinerTraits, @cc1));
         Zs1^.NbSmb := 3;
         boite^.ajoute (Zs1);
      end else begin
         { codaski }
         sy1   := byte (v2)-32;
         initialiser_parametres_courants (3, 0, 0, 0, 32);
         zy1   := new (PZoneSymboles,
                  init ( 0,    0,  colorf, coulboite, @sy1,
                  b_Smb, '', affi_un_symb_edit, @cc1));
         boite^.ajoute (zy1);

         { taille }
         z3 :=    new (PZoneReel,
                  init ( 0,    0,  4, 1, colorf, colord, @v3,
                  b_Haut, 'mm'));
         boite^.ajoute (z3);

         { angle }
         z4    := new (PZoneReel,
                  init ( 0,    0,  4, 1,  colorf, colord, @v4,
                  b_Angle, u_angle));
         boite^.ajoute (z4);
      end;

      if not suppr
      then begin
         Zb1 := new (PZoneBooleen,
                init ( 0,    0, c_t_boite_inve, c_f_boite_inve, @suppr,
                t_detruire, ''));
         boite^.ajoute (zb1);
      end;

      { diter le tout  }
      poscur  := 1;

      laide (aidedit);
      boite^.editeF (1, Poscur, Touche);
      laide ('');

      boite^.vider;
      dispose (boite, fini);

      if (touche = ESC)
      then begin
         nomz  := ch1;
         v0    := r0;
         cc1   := byte (v1);
         if nbv = 2
         then
            tt1  := byte (v2)
         else
            sy1  := byte (v2)-32;
         v3    := r3;
         v4    := r4;
         ok    := false;
         suppr := false;
      end;
      { ok=V  et  suppr=V/F }
      v1    := cc1;

      if nbv = 2
      then
         v2      := tt1
      else
         v2      := sy1+32;

      if v0 > maxc then v0 := maxc;
      if v0 < minc then v0 := minc;
   end;

procedure modifie_z  (    nbv, numz  : integer;
                          txtz, uz   : t12;
                      var z_coul     : lst_chn;
                          minc, maxc : real;
                      var ok, suppr  : boolean);
   var
      v3, v4,                    { v3 taille }
      altz                       { altmini ct }
                                 : real;

      nbz,                       { nombre de zones  }
      coulz,                     { v1 couleur       }
      v2                         { v2 trait ou code }
                                 : integer;
      nomz                       : t12;

      begin
         suppr := false;
         if numz <= 0 then exit;

         altz    := altmini_zone  (z_coul, numz, minc);
         coulz   := couleur_zone  (z_coul, altz, minc, maxc);
         nomz    := nom_element   (z_coul, numz);
         if nbv > 2       { symboles }
         then begin
            v2      := code_zone  (z_coul, altz, minc, maxc);
            v3      := taille_zone(z_coul, altz, minc, maxc);
            v4      := angle_zone (z_coul, altz, minc, maxc);
         end else begin   { couleurs }
            v2      := trait_zone (z_coul, altz, minc, maxc);
            v3      := haut_s;
            v4      := angl_s;
         end;

         choix_param_z (nbv, numz, txtz, uz,  minc, maxc, nomz, altz, coulz, v2, v3, v4,
                        ok, suppr);

         { affecter les valeurs  la structure ZONE }
         if ok   { bote valide }
         then begin
            if suppr
            then
               supprime_z (numz, z_coul)
            else begin
               modifie_zone  (nbv, numz, z_coul, altz, coulz, v2, v3, v4, nomz);
               trier_elements_liste (z_coul);
            end;
         end;
      end;

procedure ajoute_z (    nbv        : integer;
                        txtz, uz   : t12;
                    var z_coul     : lst_chn;
                        minc, maxc : real;
                    var ok         : boolean);
   var
      altz                       { altmini ct  }
                        : real;
      nbz,                       {nombre zones }
      coulz,                     { v1 couleur  }
      v2                         { v2 trait ou code }
                        : integer;
      nomz
                        : t12;
      suppr             : boolean;

      begin
         suppr  := true;
         nbz    := nb_zones (z_coul);
         nomz   := '...';
         coulz  := 2;
         if nbv = 2
         then
            v2  :=  0
         else
            v2  := 32;

         if nbz > 0
         then
            altz := altmini_zone (z_coul, nbz, minc)
         else
            altz := minc;

         choix_param_z (nbv, nbz+1, txtz, uz, minc, maxc, nomz,  altz,
                        coulz, v2, haut_s, angl_s, ok, suppr);

         if ok   { boite valide - suppression sans signification }
         then begin
            ajoute_zone   (z_coul, nbv);
            modifie_zone  (nbv, (nbz+1), z_coul, altz,
                           coulz, v2, haut_s, angl_s, nomz );
            trier_elements_liste (z_coul);
         end;
      end;

procedure supprime_z (numz       : integer;
                      var z_coul : lst_chn);
      begin
         supprimer_zone (z_coul, numz);
      end;

procedure choix_zones (nbv        : integer;
                       txtz, uz   : t12;
                       var z_coul : lst_chn;
                       minc, maxc : real);
   var
      altz                       { altmini ct }
                        : real;
      nbz,                       { nombre de zones }
      coulz,                     { v1 couleur }
      i                 : integer;
      nomz,
      nbzs, pl          : t12;
      l1                : tabstr12;   { 10 zones max }
      suppr             : boolean;

   begin
      suppr   := true;
      altz    := minc;
      nbz     := nb_zones (z_coul);
      str (nbz, nbzs);
      entier  := 0;

      if nbv = 2
      then
         chain := ch_Z_coul
      else
         chain := ch_Z_smb;

      if nbz > 0
      then begin
         if nbz > 1 then pl := 's';
         creeliste  (c_z1, 1);
         creeliste  (c_z2, 2);                        { utildivs }
         creeliste  (c_z3, 3);
         liste ('',  chain, '('+nbzs+' '+l_zone+pl+')', 15, chain, entier);
         for i := 1 to nbz
         do
            l1 [i] := nom_element (z_coul, i);
      end else
         entier := 1;

      case entier of
         1 : ajoute_z (nbv, txtz, uz, z_coul, minc, maxc, ok);
         2 : if nbz > 1
             then
                modifie_z  (nbv, (quellezone (l1, nbz, txtz)),
                                    txtz, uz, z_coul, minc, maxc, ok, suppr )
             else
                modifie_z  (nbv, 1, txtz, uz, z_coul, minc, maxc, ok, suppr );
         3 : if nbz > 1
             then
                supprime_z (quellezone (l1, nbz, txtz), z_coul)
             else
                supprime_z (1, z_coul);
      end;
     {  if entier > 0
      then trier_elements_liste (z_coul);    ralis dans ajoute et modifie }
   end;

{---------------------------------------------------------------------------}
{  SYMBOLES }
{---------------------------------------------------------------------------}

procedure autre_format_nombre (var nb_chi, nb_dec : integer);
   var
      touche, poscur    : integer;
      z1, z2            : PZoneEntier;
      boite             : PBoiteSaisie;

   begin
      poscur := 1;
      boite := new (PBoiteSaisie,
                    init ( milieu, milieu, 15, c_f_boite_norm, c_t_boite_norm,
                    t_nombre));
      z1    := new (PZoneEntier,
                    init (  0,   0,   2,   colorf, colord, @nb_chi,
                    b_chiffres, ''));
      z2    := new (PZoneEntier,
                    init (  0,   0,   2,   colorf, colord, @nb_dec,
                    b_deci, ''));
      boite^.ajoute (z1);
      boite^.ajoute (z2);
      laide (aidedit);
      boite^.editeF (1, Poscur, Touche);
      laide ('');

      boite^.vider;
      dispose (boite, fini);
   end;

procedure choix_format_nombre (var nb_chi, nb_dec : integer);
   begin
      entier  := 1;
      creeliste  (c_entier, 1);                        { utildivs }
      creeliste  (c_1deci,  2);
      creeliste  (c_2deci,  3);
      creeliste  (c_autref, 4);
      liste      (l_nb1, l_nb2, l_nb3, 16, chain, entier);
      nb_chi := 0;
      case entier of
         1 : nb_dec := 0;
         2 : nb_dec := 1;
         3 : nb_dec := 2;
         4 : autre_format_nombre (nb_chi, nb_dec);
      end;
   end;

procedure choisir_rang (comm : chainecar ; var rang : integer);
   begin
      entier := 1;
      creeliste (c_aucune, 1);                        { utildivs }
      creeliste (libcol_3, 2);                        { utildivs }
      if nbnum > 3
      then
         creeliste (libcol_4, 3);
      if nbnum > 4
      then
         creeliste (libcol_5, 4);

      liste ('', comm, '('+nomfvs+')', 15, chain, entier);

      if entier > 0
      then
         rang := entier +1;
      if entier < 2
      then
         rang := 0;
   end ;

procedure paramaff;
   var
      chmin, chmax      : t20;
      cc1, sy1,
      sc1, sc2 , sc3    : byte;                 { rangs dans liste 0..2}
      i,
      touche, poscur    : integer;
      r2,
      r3, r4, r5        : real;
      z1                : PZoneEntier;
      z2,
      z3, z4, z5        : PZoneReel;
      zl1, zl2, zl3     : Pzoneliste;
      zc1, zc2          : Pzonecouleur;
      zy1               : PzoneSymboles;
      boite             : PBoiteSaisie;
      co                : word;
      l1                : tabstr12;

   begin
      l1 [1] := n_fixe;
      l1 [2] := libcol_3;
      l1 [3] := libcol_4;
      l1 [4] := libcol_5;

      sc1 := 0;
      sc2 := 0;
      sc3 := 0;

      r2  := angl_s;
      r3  := haut_s;
      r4  := h_min;
      r5  := h_max;
      cc1 := coul_s;
      sy1 := codaski-32;
      poscur := 1;
      boite  := new (PBoiteSaisie,
                    init (milieu, milieu, 15,  c_f_boite_norm, c_t_boite_norm,
                         t_points));
      if coul_u
      then begin                                    { demander coulsymb }
         Zc1    := new (PZoneCouleur,
                   init (     0,      0,       @cc1,
                   b_Couleur, '', pal));
         Zc1^.cnom := colorf;
         boite^.ajoute (zc1);
      end else begin
         sc1 := byte (rang_c-1);
         Zl1 := new (PZoneListe,
                   init (     0,      0,           c_f_boite_norm, c_t_boite_norm , @sc1,
                   b_colonne, ''));
         Zl1^.cnom := colorf;
         for i := 1 to nbnum-1
         do
            ZL1^.Liste.insert (@l1 [i]);
         boite^.ajoute (zl1);
      end;

      if (typedat <> 2) and (typedat <> 3)
      then begin
         if aff_u or (typedat = 6)
         then begin                                { demander code ASCII }
            initialiser_parametres_courants (3, 0, 0, 0, 32);
            zy1 := new (PZoneSymboles,
                   init (  0,   0,  colorf, coulboite, @sy1,
                   b_Smb, '', affi_un_symb_edit , @cc1));
            boite^.ajoute (zy1);
         end else begin
            sc2 := byte (rang_k-1);
            Zl2 := new (PZoneListe,
                   init (     0,      0,          c_f_boite_norm, c_t_boite_norm, @sc2,
                   b_colcode, ''));
            Zl2^.cnom := colorf;
            for i := 1 to nbnum-1
            do
               ZL2^.Liste.insert (@l1 [i]);
            boite^.ajoute (zl2);
         end;

         if angle_u
         then begin                                   { demander angle }
            z2  := new (PZoneReel,
                   init (  0,   0,  3, 0, colorf, colord, @angl_s,
                   b_Angle, u_angle));
            boite^.ajoute (z2);
         end else begin
            sc3 := byte (rang_a-1);
            Zl3 := new (PZoneListe,
                   init (     0,      0,         c_t_boite_norm, c_t_boite_norm, @sc3,
                   b_Colangle, ''));
            Zl3^.cnom := colorf;
            for i := 1 to nbnum-1
            do
               ZL3^.Liste.insert (@l1 [i]);
            boite^.ajoute (zl3);
         end;

      end else begin
                                      {! demander justification/coordonnes }
{        align_s  := 0;}
                              {! demander dcalages en X et Y (? units mm )}
         dist_x   := 0;
         dist_y   := 0;
      end;

      if taille_u
      then begin                                   { demander hauteur en mm }
         z3    :=  new (PZoneReel,
                   init (  0,   0,  4, 1, colorf, colord, @haut_s,
                   b_haut, 'mm'));
         boite^.ajoute (z3);
      end else begin          { ! demander taille mini et maxi des symboles }
         if coefvs > 0
         then begin
            chmin := b_haut_min;
            chmax := b_haut_max;
         end else begin
            chmin := b_haut_max;
            chmax := b_haut_min;
         end;
         z4    :=  new (PZoneReel,
                   init (  0,   0,  4, 1, colorf, colord, @h_min,
                   chmin, 'mm'));
         boite^.ajoute (z4);
         z5    :=  new (PZoneReel,
                   init (  0,   0,  4, 1, colorf, colord, @h_max,
                   chmax, 'mm'));
         boite^.ajoute (z5);
      end;

      laide (aidedit);
      boite^.editeF (1, Poscur, Touche);
      laide ('');

      boite^.vider;
      dispose (boite, fini);

      if (haut_s < hcarmin) or (haut_s > hcarmax) then haut_s  := r3;
      if (h_min  < hcarmin) or (h_min  > hcarmax) then h_min   := r4;
      if (h_max  < hcarmin) or (h_max  > hcarmax) then h_max   := r5;

      if (touche = ESC)  {or (touche = 0)}
      then begin
         sy1      := codaski-32;
         angl_s   := r2;
         haut_s   := r3;
         h_min    := r4;
         h_max    := r5;
         cc1      := coul_s;
         sc1      := byte (rang_c)-2+1;
         sc2      := byte (rang_k)-2+1;
         sc3      := byte (rang_a)-2+1;
      end;                          { rtablir les valeurs initiales }

    {  coulsymb := nomcouleur (cc1);}
      coul_s   := cc1;
      codaski  := sy1+32;
      rang_c   := sc1+1;
      rang_k   := sc2+1;
      rang_a   := sc3+1;
      aff_u    := rang_k < 3;
      angle_u  := rang_a < 3;
      coul_u   := rang_c < 3;
   end;

procedure paramdat;
      { choix des paramtres pour le type d'affichage "uniforme"
             avec ou sans slection,
             sans indexation taille /angle /couleur }
   begin
      aff_u    := true;

      coul_u   := true;
      angle_u  := true;
      taille_u := true;
      paramaff;
   end;

procedure paramvar ;
   { choix des paramtres pour le type d'affichage "variable"
             mme code
             avec ou sans slection,
             avec ou sans indexation de la taille ou de l'angle de rotation }
   begin
      aff_u    := false;

      coul_u   := true;
      angle_u  := true;
      taille_u := false;
     { ! pour simplifier ...
      paramaffv;}
      paramaff ;
   end;

procedure paramtxt;  { choix des paramtres pour le type TEXTE ou NOMBRE }
   begin
      aff_u       := true;

      taille_u    := true;
      coul_u      := true;
      angle_u     := true;
      angl_s      := 0;

      if (typedat = 2)
      then begin
         if (strufic [nbnum+1] = 's')
         then
            rang_v  := 0
         else
            typedat := 3;
      end;

      if (typedat = 3)
      then begin
         { demander format des nombres : liste des formats }
         nbdcs    := 0;      { 0 = alignement  gauche }
         nbdds    := 0;
         choix_format_nombre (nbdcs, nbdds);
      end;
      { demander autres paramtres }
      paramaff ;
   end;

procedure paramasc;     { choix des paramtres pour le type ASCII }
   begin
      aff_u     := false;

      coul_u    := false;
      angle_u   := false;
      taille_u  := rang_v < 3;
{      choisir_rang ('rang du code', rang_k);}
{      aff_u    := rang_k < 3;}
{      paramaffv ;}
      borne_sup := borne_sup+1;
      paramaff  ;
   end;

procedure paramzon;     { choix des paramtres pour le type ZONES }
   begin
      aff_u   := false;
      coul_u  := false;
      angle_u := false;
      choix_zones (4, n_Symboles, unitval, z_smb, {borne_inf, borne_sup} min_v, max_v);
   end;

procedure choix_symboles (var change : boolean);
   begin
      change := true;
      if nbnum > 2
      then
         case typedat of
            0    : begin
                      change := false;
                      exit
                   end;
            1    : paramdat ;
            2, 3 : paramtxt ;
            4    : paramasc ;
            5    : paramzon ;
            6    : paramvar ;
         end
      else
         if (strufic [nbnum+1] = 's')
         then
            case typedat of
               0 : begin
                      change := false;
                      exit
                   end;
               1 : paramdat ;
               2 : paramtxt ;
            end
         else begin
            change := false;
            paramdat
         end;
   end;

procedure ini_valeurs_symb (nomf : pathstr; rg : byte);
   var
      min               : real;

   begin
      stru5   (nomf, 10, strufic, nbco, nbnum);
      { fichier, nombre d'essais , stucture, nbcolonnes, nb col numriques  }
      { si strufic contient un '.' entre e, r ou s alors erreur !!!         }
      {                            aprs           alors ignorer !          }

      { NBNUM = nombre de colonnes numriques compltes
                                             (sur l'chantillon examin)    }
      { TYPEDAT
      { 0 : structure non reconnue                                          }
      { 1 : VALEURS ponctuelles X, Y, Z1, [Z2], [Z3]                        }
      {               affichage uniforme code et couleur                    }

      {               slection simple inf/sup sur Z1 ou Z2 ou Z3           }
      {               taille uniforme ou proportionnelle  Z1, Z2 ou Z3     }
      {                                  entre taille min et max (mm)       }

      { 2 : NOMBRES                                                         }
      {               taille uniforme, format variable choisi               }

      { 3 : TEXTES         X, Y, [z|angle], [couleur], nom                  }
      {               taille uniforme                  dernier champ        }

      { 4 : code ascii     X, Y, [z|angle], [couleur], code                 }
      {               taille uniforme                                       }

      { demander rang de la valeur  reprsenter             0 pour ignorer }
      { s'il existe une colonne de valeurs ...              3 ou 4          }

      { 5 : ZONES  (code, angle, couleur, taille )                          }
      { 6 : INDEXE     }

      { recharger le fichier  des paramtres symboles associs }

      if nbnum >= rg then rang_v := rg;
      if (nbnum > 3) and not ((rg <= nbnum) and (rg > 0))
                       { (rang_v < 3) { pas encore choisie }
      then
         choisir_rang (choix_rang, rang_v);   { RANG }

      if (rang_v >= 3)
      then begin
         case rang_v of
            3 : begin
                   pasvs  := pasc3 {10}; {    10 km         }
                   coefvs := coefc3;
                end;
            4 : begin
                   pasvs  := pasc4 {0.5};
                   coefvs := coefc4;
                end;
         end;
         typedat  :=   6;
         aff_u    := false;
         coul_u   := true;
         angle_u  := true;
         taille_u := false;
         minmaxf (nomf, nbnum, rang_v, min_v, max_v);
         if coefvs > 0
         then begin      { ordre inchang }
            min_v := min_v*coefvs;
            max_v := max_v*coefvs;
         end else begin  { ordre invers }
            min   := min_v;
            min_v := max_v*coefvs;
            max_v := min  *coefvs;
            h_min := 5;
            h_max := 1;
         end;
      end;
      if (min_v >= max_v)
      then begin
         rang_v := 0;
      end;

      if (rang_v < 3)
      then begin
         typedat  :=   1;
         aff_u    := true;
         coul_u   := true;
         angle_u  := true;
         taille_u := true;
         min_v    := -1000000000;
         max_v    :=  1000000000;
      end;

      borne_inf := min_v;
      if strufic [rang_v] = 'e'       { cas des entiers }
      then
         max_v := max_v+1;
      borne_sup := max_v;
      initextes_titres;
   end;

procedure voir_symboles (nomf : pathstr ; eff : boolean);
   { paramtres globaux utiliss :
        fentre et clture
        traceur / cran

     symboles
        typedat    type de fichier de donnes
        nbnum      nombre de colonnes numriques
        borne_inf  bornes inf et sup de la slection
        borne_sup
        min_v      limites valeur  reprsenter
        max_v

        codaski    code du symbole unique
        haut_s     hauteur car
        angl_s     angle de rotation
        coul_s  ... coulsymb
        aff_u      affichage simplifi O/n
        taille_u   taille    unique    O/n
        rang_v     rang de la valeur  reprsenter
        rang_a     rang de l'angle de rotation du symbole
        rang_c     rang       couleur
        rang_k     rang du code ascii
        align_s    justification texte
        nbcs       nombre de chiffres
        nbds                 dcimales
        h_min      intervalle taille variable
        h_max
                   }
   var
      stop              : boolean;

      fdat              : text;
      t,
      err,
      coul_sv,
      codaskiv
                        : integer;
      h, v              : byte;

      binf,                                          { bornes provisoires }
      bsup,
      angl_sv,
      haut_sv,
      xs, ys,
      vs                                              { valeur en cours }
                        : real;
      es                : txtsymb;
      lign              : array [1..5] of real;

   function hauteur_c (v : real) : real;
      begin
         hauteur_c := h_min + (h_max - h_min)
                              * (v         - borne_inf)
                              / (borne_sup - borne_inf);
      end;

   procedure prepare_label (es : txtsymb);
      var
         mx, my : real;

      begin
         case align_s of
            1 : begin h := 0; v := 0 end;
            2 : begin h := 0; v := 1 end;
            3 : begin h := 0; v := 2 end;
            4 : begin h := 1; v := 0 end;
            5 : begin h := 1; v := 1 end;
            6 : begin h := 1; v := 2 end;
            7 : begin h := 2; v := 0 end;
            8 : begin h := 2; v := 1 end;
            9 : begin h := 2; v := 2 end;
         end;
         justifie_texte (es, h, v, mx, my);
         xs := xs + dist_x + mx/xrap ;
         ys := ys + dist_y + my/xrap;
      end;

   procedure dessine_label (es : txtsymb);
      begin
         e_b_devant (es);               { enlve les espaces inutiles    }
         prepare_label (es);
         if dans_fenetre (xs, ys)
         then begin
            deplaceenl      (xs, ys);
            ecrire_texte    (es);
         end;
      end;

   begin
  {    if not ftxt_present (nomfvs+extvs)
      then begin
         message ('Fichier '+nomfvs+extvs+'non trouv');
         exit
      end;}
      if visuzonesmb
      then begin
         typedat  := 5;
         aff_u    := false;
         coul_u   := false;
         angle_u  := false;
      end;
      assign (fdat, nomf);
      resetTxtErr (fdat, nomf, ok);
      lign [1] := 0;
      lign [2] := 0;
      setlinestyle (0, 0, 1);
      if (typedat = 2) or (typedat = 3)
      then begin
         if eff then fixecoul (coulboite)
                else fixecoul (coul_s);
         initialiser_parametres_courants (1, haut_s, angl_s,   0,   65);
      end else
         if aff_u
         then begin
            codaskiv := codaski;
            if eff then fixecoul (coulboite)
                   else fixecoul (coul_s);
            initialiser_parametres_courants (3, haut_s, angl_s,   0,   32);
         end;

      t := 0;
      stop := false;
      repeat
         { charger les valeurs d'une ligne dans un tableau }
         taille_u := taille_u or (rang_v < 3);
         vs := 0;
         read   (fdat, xs);
         read   (fdat, ys);
         lign [3] := 0;
         lign [4] := 0;
         lign [5] := 0;

         if nbnum > 2
         then
            read  (fdat, lign [3]);

         if nbnum > 3
         then
            read  (fdat, lign [4]);

         if nbnum > 4
         then
            read  (fdat, lign [5]);
         lign [3] := lign [3]*coefc3;
         lign [4] := lign [4]*coefc4;

         read (fdat, es);                  { dernier champ = texte possible }

         if (typedat = 2)
         then
            dessine_label (es)

         else begin
            if rang_v > 2
            then
               vs := lign [rang_v] ;

            binf := borne_inf;
            if visuzonesmb
            then begin
               binf := altmini_zone (z_smb, 1, borne_inf);
               if binf < borne_inf
               then
                  binf := borne_inf;
            end;
            if  (rang_v < 2)
               or
                ({not visuzonesmb and }(vs >= binf) and (vs < borne_sup))
             {  or
                (    visuzonesmb and (vs >= altmini_zone (z_smb, 1, borne_inf)))}
            then begin
               if (typedat <> 1) {not aff_u} or (typedat = 6) { ou textes }
               then begin           { reinitialiser les paramtres courants }
                  if (typedat = 5) and (z_smb <> NIL)  { visuzonesmb }
                  then begin
                     coul_sv  := couleur_zone (z_smb, vs, borne_inf, borne_sup);
                     codaskiv := code_zone    (z_smb, vs, borne_inf, borne_sup);
                     haut_sv  := taille_zone  (z_smb, vs, borne_inf, borne_sup);
                     angl_sv  := angle_zone   (z_smb, vs, borne_inf, borne_sup);
                  end else begin
                     if rang_c > 2
                     then
                        coul_sv := round (lign [rang_c])
                     else
                        coul_sv := coul_s;

                     if rang_a > 2
                     then
                        angl_sv := lign [rang_a]
                     else
                        angl_sv := angl_s;

                     if rang_k > 2
                     then
                        codaskiv := round (lign [rang_k])
                     else
                        codaskiv := codaski;

                     if taille_u
                     then
                        haut_sv  := haut_s
                     else                  { recalculer la taille }
                        haut_sv  := hauteur_c (lign [rang_v]);
                  end;
                  if eff
                     then fixecoul (coulboite)
                     else fixecoul (coul_sv);
                  initialiser_parametres_courants
                           (3, haut_sv, angl_sv,   0,   32);
               end;

               if typedat = 3
               then begin
                  str (lign [rang_v]:nbdcs:nbdds, es);
                  prepare_label (es);
               end;

               if dans_fenetre (xs, ys)
               then begin
                  if codaskiv = 0
                  then
                     deplaceen (xs, ys)         { un point seulement    }
                                                  { pour affichage rapide }
                  else begin
                     deplaceenl      (xs, ys);
                     case typedat of
                        3          : ecrire_texte    (es);
                        1, 4, 5, 6 : dessine_un_symb (codaskiv);
                     end;
                  end;
               end;
            end;
         end;
         montrersouris;
         cachersouris;
         readln (fdat);
         stop := toucheclavier (t);
         stop := (t = ESC) ;
      until eof (fdat) or stop;
      close (fdat);
   end;

END.

{--- ARX ----- SYMBOLES ---------------------- R.C.-------- TOULOUSE - 1994 }
