UNIT BLOC_INI;

   {------------------------------------------------------------------------}
   { logiciel GEOCEAN - module BLOC                                         }
   {                                                                        }
   {                          initialisations                               }
   {                                                       10/10/93         }
   {------------------------------------------------------------------------}

INTERFACE

{$O+,F+}

USES
   dos, {crt,} graph,          { TP 70   - units  standard Borland           }
   Lipar,                    { ARX     - gestion fichiers paramtres        }
   Graphism,                 { ARX     - initialisations graphiques         }
   Graph3d,                  { ARX     - Calcul projections 3D              }
   GraphUti,                 { ARX     - utilitaires graphiques             }
   DirInfo,                  { ARX     - Gestion des fichiers ressources    }
   Periphs,                  { ARX     - Gestion des priphriques          }
   Utildivs,                 { ARX     - utilitaires divers                 }
   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   Icones,                   { ARX     - gestion de icnes                  }
   Menus,                    { ARX     - interface menus                    }
   GRILLES,                  { GEO     - lecture des grilles                }

   GEO_var,                  { GEO     - variables globales communes        }
   GEO_des,                  { GEO     - procdures graph. communes         }

   BLOC_var,                 { BLOC    - variables globales du module       }
   BLOC_des;                 { BLOC    - affichages propres au module       }

Procedure iniparam;
   { initialise les paramtres de configuration  du programme.              }

Procedure iniparam2;
   { initialise les paramtres de travail                                   }

Procedure inidonnees;
   { charge les fichiers de donnes                                         }

Procedure inimenus;
   { initialise les paramtres de l'interface MENUS.                        }

Procedure modif_menus;
   { modifie le texte des menus en fonction des paramtres initiaux         }

Procedure iniIcones;
   { initialise les pointeurs sur les icnes                                }

Procedure inversemenus;
   { inverse MENUS LONGS/COURTS                                             }

Procedure iniaide;
   { initialise les paramtres du fichier d'aide.                           }

Procedure fin;
   { restaure l'cran texte.                                                }

Procedure lire_parametres;
   { Procedure ini_par_trv (nomf : string); }
   { initialisation des paramtres de travail                               }

Procedure ecrire_parametres (resume : boolean);
   { Enregistre les paramtres de travail en cours
                               des commentaires
        si RESUME   met  jour INFO.DIR    }

Procedure ini_par_trv (nomf : pathstr);
   { initialisation des paramtres de travail                               }

Procedure voir_ptrav;
   { visualise la liste  complte des paramtres du travail en cours        }

Procedure chang_noms_3d ;
   { choisir un fichier de toponymie et l'adapter pour le 3d                }

Procedure ini_noms_3d;
   { initialise la liste des noms 3d                                        }

{---------------------------------------------------------------------------}

IMPLEMENTATION

procedure chang_noms_3d ;
   var
      local             : boolean;
      d                 : dirstr;
      nomf,
      n                 : namestr;
      e                 : extstr;
      c                 : integer;

   begin
      nomf := nomftop;
      chang_nom_trav_donnees (t_choix_trv_dnn,
                               local, nomf, exttop);
      nomftop := nomf;
      if (nomf <> '')
      then begin                 { else pas de changement }
         liberer_noms;
         ini_par_noms;
         if not local
         then begin
            append_noms_3d (chemindonnees+nomftop+exttop);
            Noms^.modifier (nbpg_t, coul_t, haut_t);
         end else begin
            Noms^.lit                    (nomftop+exttop, false);
            Noms^.modifier (nbpg_t, coul_t, haut_t);

            if nomftop <> nomfpar
            then begin                   { peut tre un fichier 2d }
               recalc_Noms_3d (true);
               nomftop := nomfpar;       { aprs recalc }
            end;
         end;
      end;
   end;

procedure iniIcones;
   begin
      laide (la_lit_icones);
      if ftxt_present (cheminmodule+nomdumodule+exticn)
      then begin
         ActiveListeIcones (cheminmodule+nomdumodule+exticn);              { ICONES }
         def_icones;
      end  else begin
         message (m_not_icones);
         halt;
      end;
      laide ('');
   end;

procedure voir_ptrav;
   begin
      params.boite;                                                 { lipar }
      bte_compl (t_btepar, -1, -1, nbc, nbo, 0, 10);{ menu6 }
   end;

procedure ini_par_trv  (nomf : pathstr);
   begin
      params.init (false);

   { configuration donnes : modifiables par l'installateur }
      params.ajoute (Cstring  ('fichier de donnes'     , @nomfd    , ''));
      params.ajoute (Creal    ('abs g carte'            , @cor1     , 0 ));
      params.ajoute (Creal    ('abs d carte'            , @cor2     , 0 ));
      params.ajoute (Creal    ('ord b carte'            , @cor3     , 0 ));
      params.ajoute (Creal    ('ord h carte'            , @cor4     , 0 ));
      params.ajoute (Cstring  ('titre'                  , @titre    , ''));
      params.ajoute (Cstring  ('titr1'                  , @titr1    , 'LONGITUDE'));
      params.ajoute (Cstring  ('titr2'                  , @titr2    , 'LATITUDE' ));
      params.ajoute (Cstring  ('texte grad. intrieure' , @unitxy   , 'degrs'  ));

   { autres params : modifiables par l'utilisateur }
      params.ajoute (Creal    ('direction observateur'  , @theta    , 290 ));
      params.ajoute (Creal    ('hauteur observateur'    , @phi      ,  25 ));
      params.ajoute (Creal    ('distance cran'         , @rho      ,   0 ));
      params.ajoute (Creal    ('coef hauteurs'          , @divz     ,   0 ));

      params.ajoute (Cinteger ('direction du soleil'    , @thetasol , 215 ));
      params.ajoute (Cinteger ('hauteur du soleil'      , @phisol   ,  35 ));

   { bloc }
      params.ajoute (Cinteger ('abs gauche cloture'     , @cc1      ,    0 ));
      params.ajoute (Cinteger ('abs droite cloture'     , @cc2      ,    0 ));
      params.ajoute (Cinteger ('ord basse  cloture'     , @cc3      ,    0 ));
      params.ajoute (Cinteger ('ord haute  cloture'     , @cc4      ,    0 ));
      params.ajoute (Creal    ('abs gauche fenetre'     , @fc1      , -190 ));
      params.ajoute (Creal    ('abs droite fenetre'     , @fc2      , +190 ));
      params.ajoute (Creal    ('ord basse  fenetre'     , @fc3      ,  -90 ));
      params.ajoute (Creal    ('ord haute  fenetre'     , @fc4      ,  +90 ));
      params.ajoute (Creal    ('abs gauche bloc'        , @fb1      ,    0 ));
      params.ajoute (Creal    ('abs droite bloc'        , @fb2      ,    0 ));
      params.ajoute (Creal    ('ord basse  bloc'        , @fb3      ,    0 ));
      params.ajoute (Creal    ('ord haute  bloc'        , @fb4      ,    0 ));

   { affichages divers }
      params.ajoute (Cboolean ('graduations extrieure' , @visugrad   , false));
      params.ajoute (Cboolean ('commentaires visibles'  , @visucomm   , false));
      params.ajoute (Cboolean ('Toponymie visible'      , @visutoponym, false));
      params.ajoute (Cinteger ('couleur lignes grille'  , @c_grille   , 13   ));
      params.ajoute (Cinteger ('pas du fils de fer'     , @PasF       ,  2   ));
      params.ajoute (Cboolean ('fil de fer visible'     , @horiz      , false));
      params.ajoute (Cboolean ('gradient de couleurs'   , @grad       , true));
      params.ajoute (Cboolean ('ombres'                 , @ombre      , true));
      params.ajoute (Cinteger ('rpartition couleurs'   , @ModeAff    ,  1   ));

   { graduations externes }
     {params.ajoute (Creal    ('interv entre graduations', @inter_xy,  1 ));
      params.ajoute (Cinteger ('nb dcimales'            , @nbdec_xy,  0 ));
      params.ajoute (Cinteger ('nb tirets intermdiaires', @nbti_xy ,  4 ));
      params.ajoute (Cinteger ('hauteur tirets en mm'    , @htir_xy ,  3 ));
      params.ajoute (Cinteger ('hauteur tiquettes grad.', @hcar_xy ,  3 )); }
      params.ajoute (Cinteger ('couleur axex'           , @c_axex   ,   2 ));
      params.ajoute (Cinteger ('couleur axey'           , @c_axey   ,   2 ));

   { toponymie }
      params.ajoute (Cstring  ('nom fichier toponymie'  , @nomftop  , region));
      params.ajoute (Creal    ('hauteur texte'          , @haut_t   ,   3 ));
      params.ajoute (Cinteger ('couleur symboles'       , @coul_t   ,   2 ));
      params.ajoute (Cboolean ('fond tiquettes effac' , @fond_t,    false));
     {params.ajoute (Cinteger ('couleur lignes rappel'  , @c_lrappel,   2 ));
      params.ajoute (Cinteger ('longueur lignes rappel' , @Lrappel  ,   2 ));
      params.ajoute (Cinteger ('hauteur des tiquettes' , @Htxt     ,   2 ));}

   { commentaires associs }
      params.ajoute (Cstring  ('nom fichier commentaires', @nomfcomm,  '' ));

   { Fonction de traitement au chargement des donnes d'une grille}
      params.ajoute (Cstring  ('traitement sur grille   ', @TexteFonction,''));
      params.ajoute (Cinteger ('code de modle          ', @ChoixModele  , 0));

      if ftxt_present (nomf)
      then
         params.lit (nomf);

      deux_d        := false;
      visutoponym   := (nomftop <> '') and visutoponym;
      modipar       := false   ;           { modif en cours params           }
      NbClasses     := 7 ;

      align_t       := 5;
     { angl_t  := 0;}
      nbpg_t        := 0;
   end;

procedure ecrire_parametres (resume : boolean);
   begin
      laide (la_ecr_par);
      nomfcomm := nomfpar;
      nomftop  := nomfpar;
      chain := '';

      params .ecrit   (chain+nomfpar + extpar, datjour+ ' ' +nomutil);
         { travail en cours }

      ecrit_par_COMM  (chain+nomfcomm + extcom);
         { commentaires }

      ecrit_par_noms  (chain+nomftop  + exttop);
         { toponymie }

      if resume
      then
         edite_info (nomfinfo, nomfpar, extpar);             { dirinfo }
      laide ('');
   end;

procedure lire_parametres;
   begin
      laide (la_lit_par);
      chain := '';
      if (maj (nomfpar) = nomdumodule)
         and not exists (nomfpar+extpar)
      then
         chain := chemindonnees;

      ini_par_TRV  (chain+nomfpar + extpar) ;
         { charger les paramtres de travail }

      nomfpal := copy (nomdumodule, 1, 4)+copy (nomfd, 5, length (nomfd)-4);
{      if nomfd    = ''
      then
         nomfpal  := nomdumodule;}

      if titre    = ''
      then
         titre    := maj (region);

      if nomfcomm = ''
      then
         nomfcomm := nomfpar;

      ini_par_COMM   (chain+nomfcomm + extcom); { commentaires }
      laide ('');
  end;

procedure iniparam;
   var
      chem, chemp       : dirstr;
      nomf              : namestr;
      ext               : extstr;

   begin
      help_txt_enligne (paramstr (1));
      { charger la configuration d'ensemble de GEOC }

      lire_utilisateur (paramstr (0));                    { nomutil=nomutil+groupe, region }

      exempl := numeromaxi (cheminexemples+region+'\*'+extpar) > 0;

      chemindonnees := chemindonnees+region+'\';
      chemp   := '';
      nomfpar := nomdumodule;
      if paramcount > 0
      then
         chemp := paramstr (1);
      if chemp <> ''                { chercher le nom du fichier de travail }
      then begin
         fsplit (chemp, chem, nomf, ext);
         nomfpar := nomf;
      end;

      { charger la configuration d'ensemble de GEOC                         }
      {         sans deuxime paramtre : config GEOCEAN                    }
      {         avec deuxime  si <> geocean chemin et nom ok
                               sinon         config GEOCEAN                 }

      chemincfg  := cheminmodule;
      nomfcfg    := nomlogiciel;
      if paramcount > 1
      then
         chemp := paramstr (2);
      if chemp <> ''                { chercher le nom du chemin des donnes }
      then begin
         fsplit (chemp, chem, nomf, ext);
         if (nomf <> '') and (maj (nomf) <> nomlogiciel)
         then begin
            nomfcfg := nomf;
            if chem <> ''
            then
               chemincfg := chem
         end;
      end;
      complete (chemincfg);
      ini_par_cfg (chemincfg+nomfcfg+extcfg);
      coulboite := coulecran;
      { si le fichier n'est pas trouv : paramtres par dfaut }

      { affecter rpertoire configuration graphique   }
      repbgi    := maj (getenv (NomBgi));
      if repbgi = ''
      then
         repbgi := cheminmodule;
      complete (repbgi);                       { ajoute ventuellement un \ }
   end;

procedure iniparam2;
   var
      chem, chemp       : dirstr;
      nomf              : namestr;
      ext               : extstr;

   begin
      lire_parametres;
      inipalette;
      fini     := false;
      prof     := false;
   end;

procedure inidonnees;
   var
      i                 : integer;

   begin
      chain := '';
      if (maj (nomfpar) = nomdumodule)
      then
         chain := chemindonnees;

      { charger les valeurs  reprsenter }
      if ftxt_present (chemindonnees+nomfd+extgrd)
      then
         lire_grille (Lagrille, nomfd, False)
      else begin
         i := 0;
         repeat
            inc (i);
            chang_grille (donnees_ini,
                          '',
                          choix_grille,
                          '',
                          Lagrille, nomfd,TraitementAutorise);
         until (nomfd <> '') or (i>2);

         if nomfd = ''
         then begin
            message (m_not_donnees);
            finir;
            halt;
         end else
            nomfpal := copy (nomdumodule, 1, 4)+copy (nomfd, 5, length (nomfd)-4);
      end;
      inipalette;
   end;

procedure ini_noms_3d;
   begin
      ini_par_noms;                                 { liste new }
      if  (ftxt_present (nomftop+exttop))           { perso d'abord }
      then begin
         Noms^.lit      (nomftop+exttop, false);
         Noms^.modifier (nbpg_t, coul_t, haut_t);   { = deux_d }
      end else begin
         if nomftop <> ''
         then
            chang_noms_3d;                       { rech donnees ou travail }
      end;
   end;

procedure inimenus_prof;
   begin
      textemenufichierprof;
      { textemenu (3,  6, 'Autres paramtres...',
                        'graduation ');         }
   end;

procedure inimenus_eleve;
   begin
      textemenufichier;

      textemenu (2,  1, nomu_bloc,  '');
      textemenu (2,  2, txt_mnu22,  txt_mnu22a);
      textemenu (2,  3, txt_mnu23,  txt_mnu23a);
      textemenu (2,  5, txt_mnu25,  txt_mnu25a);

      textemenu (3,  2, txt_mnu32,  txt_mnu32a);
      textemenu (3,  3, txt_mnu33,  txt_mnu33a);
      textemenu (3,  4, txt_mnu34,  txt_mnu34a);
   end;

procedure modif_menus;
   begin
      if ((nomfpar <> nomdumodule) or prof)
      then
         active (1, 4, true)
      else
         active (1, 4, false);

      if exempl        { sans bascule }
      then begin
         active (1,  2, false);
         active (1,  4, false);
         active (1,  5, false);
         active (1, 10, false);
         active (1, 11, false);
         active (3,  2, false);
      end;

      if visucomm
      then begin
         textemenu (4,  2, coche+' '+txt_mnu42, txt_mnu42a);
         active (3, 2, true);
         Dessiner_Commentaires (false, true, false);
      end else begin
         textemenu (4,  2,      '  '+txt_mnu42, txt_mnu42b);
         active (3, 2, false);
      end;

      if annotations^.count = 0
      then begin
         visucomm := false;  { pour permettre la cration du premier lment }
         active (3 , 2, true);
      end;

      if visugrad
      then
         textemenu (4,  3, coche+' '+txt_mnu43, txt_mnu43a)
      else
         textemenu (4,  3,      '  '+txt_mnu43, txt_mnu43a);

      if visutoponym
      then begin
         textemenu (4,  4, coche+' '+txt_mnu44, txt_mnu44a);
         active    (3,  6, true);
      end else begin
         textemenu (4,  4,      '  '+txt_mnu44, +txt_mnu44b);
         active    (3,  6, false);
      end;

      if horiz
      then
         textemenu (4,  5, coche+' '+txt_mnu45, txt_mnu45a)
      else
         textemenu (4,  5,      '  '+txt_mnu45, txt_mnu45b);

      if grad
      then
         textemenu (4,  6, coche+' '+txt_mnu46, txt_mnu46a)
      else
         textemenu (4,  6,      '  '+txt_mnu46, txt_mnu46b);
      if ombre
      then
         textemenu (4,  7, coche+' '+txt_mnu47, txt_mnu47a)
      else
         textemenu (4,  7,      '  '+txt_mnu47, txt_mnu47b);

      if nomftop = ''
      then begin
         active    (3,  4, false);
         active    (4,  4, false);
      end else begin
         active    (3,  4, true);
         active    (4,  4, true);
      end;

      ini_titre;
      modif_menu_cfg; { modifie le menu SORTIES }
   end;

procedure inimenus;
   begin
      ini_menu      (repbgi, pol_menu);                             { menus }
      posxbtn := 541;
      chargepalette (cheminmodule+nomdumodule + extpal, ok);                  { graphism }
      setcoulmenu   (fondmenu, txtmenu, txtnorm, txtnon,
                     txtoui,  fondnorm, fondoui, fondaide);

      inimenus_eleve;
      if prof
      then
         inimenus_prof;
   end;

procedure inversemenus;
   begin
      if not prof
      then
         inimenus_prof
      else begin
         initmenus;                                                { menus1 }
         inimenus_eleve;
      end;
      prof := not prof;
   end;

procedure iniaide;
   begin
      initaide (cheminmodule+nomdumodule + exthlp, ok);                         { menus6 }
   end;

procedure fin;
   begin
      finir;                                                          { des }
   end;


END.

{--- GEOCEAN - BLOC_INI ------ --------------- R.C.- INRP - TOULOUSE - 1993 }
