UNIT COMMENT;

{---------------------------------------------------------------------------}
{         bibliothque                                                      }
{                          Commentaires dynamiques                          }
{                            Toponymie dynamique                            }
{                                                               10/04/95    }
{---------------------------------------------------------------------------}
(*
   Comment,                  { ARX     - gestion des textes/page            }

   pourrait utiliser FICHIERS pour contrler compltement les erreurs ES...
   Il suffit en gnral de tester la faisabilit avant d'appeler les
   procdures LISTE.LIT et LISTE.ECRIT
                   prsence du fichier et accessibilit
                   place en criture
*)

{$O+,F+}

INTERFACE

USES

   Dos,
{   Crt,}
   Graph,
   Objects,                  { TP 70   - units  standard Borland           }
   Souris,                   { ARX     - gestion de la  souris              }
   Clavier,                  { ARX     - gestion du clavier                 }
   Graphism,                 { ARX     - initialisations graphiques         }
   Utildivs,                 { ARX     - utilitaires divers                 }
   Graphplt,                 { ARX     - graphisme 2D cran/traceur         }
   Graphsg,                  { ARX     - symboles et graduations            }
   Polygon;                  { ARX     - gestion des objets graphiques      }

CONST
   Deplace              = 1;
   Tourne               = 2;
   Incline              = 3;
   Dimensionne          = 4;
   Dehors               = 5;
   r                    = 1;         { proximit en mm }

TYPE
   PCommentaire         = ^TCommentaire;
   TCommentaire         = object (TObject)
      Texte          { commentaire proprement dit                           }
                  : t30;
      x1, y1,
      x2, y2,
      x3, y3,
      x4, y4,
      x,  y,         { position txt               repre feuille papier mm  }
      x0, y0,        { position accrochage ligne de rappel              mm  }
      xu, yu,        { position carte             repre  carte             }
      taille,        { hauteur en mm                                        }
      direct,        { direction criture                                  }
      inclin,        { inclinaison  caractres      Non Utilis            }
      ht,            { hauteur txt                                          }
      LgT            { longueur txt                                         }
                  : real;

      poign,         { nb de "poignes" }
      couleur,       { du texte }
      police,        { du texte }
      c_def          { mmo couleur  cte }
                  : word;

      xs, ys         { position cran souris }
                  : integer;

   {   aplat,    2 dimensions       }
      lr             { ligne de rappel    }
                  : boolean;

      Constructor Init     (xx, yy,
                            xo, yo,
                            xk, yk,
                            tail, dir, inc   : real;
                            coul, pol, nbpg  : integer;
                            r                : boolean;
                            t                : t30);
      Procedure   Initsmb;

      Procedure   Calcpoints;

      Destructor  Done;                                         virtual;

      Procedure   Editer   (var Touche       : integer;
                            px, py, lx, ly   : integer;
                            lier             : boolean);
                  { Le texte doit tre effac en entre }

      Procedure   Afficher (cadre, fond      : boolean);

      Procedure   Tracer   (c                : word;
                            cadre, fond      : boolean);

      Function    Contient (xx, yy           : real)         : boolean;

      Function    PtChaud                                    : byte;

      Function    Poignee                                    : integer;

      Procedure   AfficherCadre;

      Procedure   EffacerCadre;

      Procedure   Deplacer;

      Procedure   ChangerPointeur;

      Procedure   Dimensionner;

      Procedure   Tourner;

      Procedure   Incliner;
   end;

   PListeComment = ^TListeComment;
   TListeComment = object  (TCollection)
      Constructor Init;
      Procedure   Modifier (nbpg,                          { nb poignes   }
                            co                : word;      { couleur texte }
                            tail              : real);      { taille        }
      Procedure   Recadrer ;
      Procedure   Afficher (cadre, fond       : boolean);
      Procedure   Effacer;
      Procedure   Tracer   (Co                : word;
                            cadre, fond       : boolean);
      Procedure   Lit      (NomF              : pathstr; d2d : boolean);
      Procedure   Ecrit    (NomF              : pathstr; d2d : boolean);
      Procedure   Ecritp   (NomF              : pathstr);
      Function    Contient (xx, yy            : real;
                            var comm          : PCommentaire)  : boolean;
      Destructor  Done;                                          virtual;
   end;
(*
CONST
   {$I TOURNE.CUR}
   {$I FL_BGHD.CUR}
   {$I MAIN.CUR}
 *)

{---------------------------------------------------------------------------}

IMPLEMENTATION

constructor TCommentaire.init;
   begin
      Inherited init;
      Texte    := t;
      x        := xx;
      y        := yy;
      taille   := tail;
      direct   := dir;
      inclin   := inc;
      couleur  := coul;
      police   := pol;
      x0       := xo;
      y0       := yo;
      xu       := xk;
      yu       := yk;
      lr       := r;
      poign    := nbpg;
  {    aplat    := d2;}
   end;

destructor TCommentaire.done;
   begin
      Inherited done;
   end;

procedure TCommentaire.InitSmb;
   begin
      initialiser_parametres_courants (1, Taille, Direct, inclin, 65);
      LgT := Longueur_texte (texte) / xrap;
      ht  := Hauteur_texte / yrap;
   end;

procedure TCommentaire.CalcPoints;
   begin
      x1 := -1;
      y1 := 1;
      calc_point_suivant (x1, y1);
      x1 := x + x1;
      y1 := y + y1;

      x2 := lgt+2;
      y2 := 0;
      calc_point_suivant (x2, y2);
      x2 := x2 + x1;
      y2 := y2 + y1;

      x4 :=  sin (inclin) * (ht+2);
      y4 := -cos (inclin) * (ht+2);
      calc_point_suivant (x4, y4);
      x4 := x4 + x1;
      y4 := y4 + y1;

      x3 := lgt+2;
      y3 := 0;
      calc_point_suivant (x3, y3);
      x3 := x3 + x4;
      y3 := y3 + y4;
   end;

function TCommentaire.PtChaud : byte;
   begin
      PtChaud := byte ((x0 <= x)     and (y0 <= y))
           + 2 * byte ((x0 >  x)     and (y0 <= y+ht/2) and (x0 < x+lgt))
           + 3 * byte ((x0 >= x+lgt) and (y0 <= y))
           + 4 * byte ((x0 <= x)     and (y0 > y) and (y0 < y+ht))
{          + 5 * byte ((x0 >  x)     and (y0 > y) and (y0 < y+ht) and (x0 < x+lgt))}
           + 6 * byte ((x0 >= x+lgt) and (y0 > y) and (y0 < y+ht))
           + 7 * byte ((x0 <= x)     and (y0 >= y+ht/2))
           + 8 * byte ((x0 >  x)     and (y0 >= y+ht)    and (x0 < x+lgt))
           + 9 * byte ((x0 >= x+lgt) and (y0 >= y+ht))
   end;

function TCommentaire.Poignee : integer;
   var
      xp, yp            : real;

   function Proches (dx, dy : real) : boolean;
      begin
         Proches := dx*dx + dy*dy <= r*r;
      end;

   begin
      xp := XUtilisateur (xs);
      yp := YUtilisateur (ys);

      if proches ((x2+x3) / 2 - xp, (y2+y3) / 2 - yp){ or
         proches (xp, yp, (x1+x4) / 2, (y1+y4) / 2) }
      then
         Poignee := Tourne
      else
         if proches (x2-xp, y2-yp)
         then
            Poignee := Dimensionne
         else
            if contient (XUtilisateur (xs), YUtilisateur (ys))
            then
               Poignee := Deplace
            else
               Poignee := Dehors;
   end;

procedure TCommentaire.AfficherCadre;
   var
      mx1, mx2, mx3, mx4,
      my1, my2, my3, my4 : real;

   begin
      CalcPoints;
      mx1 := (x1+x2) /2;
      my1 := (y1+y2) /2;
      mx2 := (x2+x3) /2;
      my2 := (y2+y3) /2;
      mx3 := (x3+x4) /2;
      my3 := (y3+y4) /2;
      mx4 := (x1+x4) /2;
      my4 := (y1+y4) /2;

      if lr
      then begin
         DeplaceEn (x0, y0);
         case ptchaud of
            1 :  tracevers (x1, y1);
            2 :  tracevers (mx1, my1);
            3 :  tracevers (x2, y2);

            4 :  tracevers (mx4, my4);
                 { 5 :  tracevers ( centrer ...?);}
            6 :  tracevers (mx2, my2);

            7 :  tracevers (x4, y4);
            8 :  tracevers (mx3, my3);
            9 :  tracevers (x3, y3);
         end;
      end;
      DeplaceEn (x1, y1);
      TraceVers (x2, y2);
      TraceVers (x3, y3);
      TraceVers (x4, y4);
      TraceVers (x1, y1);

      if poign > 0
      then begin
         DeplaceEn (x2 - r, y2 - r);
         TraceVers (x2 - r, y2 + r);
         TraceVers (x2 + r, y2 + r);
         TraceVers (x2 + r, y2 - r);
         TraceVers (x2 - r, y2 - r);
      end;

      if poign > 1
      then begin
         DeplaceEn (mx2 - r, my2 - r);
         TraceVers (mx2 - r, my2 + r);
         TraceVers (mx2 + r, my2 + r);
         TraceVers (mx2 + r, my2 - r);
         TraceVers (mx2 - r, my2 - r);
      end;

   {   DeplaceEn (x1 - r, y1 - r);
      TraceVers (x1 - r, y1 + r);
      TraceVers (x1 + r, y1 + r);
      TraceVers (x1 + r, y1 - r);
      TraceVers (x1 - r, y1 - r);}

{      DeplaceEn (x3 - r, y3 - r);
      TraceVers (x3 - r, y3 + r);
      TraceVers (x3 + r, y3 + r);
      TraceVers (x3 + r, y3 - r);
      TraceVers (x3 - r, y3 - r); }

 {     DeplaceEn (x4 - r, y4 - r);
      TraceVers (x4 - r, y4 + r);
      TraceVers (x4 + r, y4 + r);
      TraceVers (x4 + r, y4 - r);
      TraceVers (x4 - r, y4 - r);}
   end;

procedure TCommentaire.EffacerCadre;
   begin
      AfficherCadre;
   end;

procedure TCommentaire.Deplacer;
   var
      dx, dy            : real;
      xe, ye            : integer;

   begin
      LirePositionSouris (xs, ys);
      dx := XUtilisateur (xs) - x;
      dy := YUtilisateur (ys) - y;
      cacherSouris;
      Tracer (C_def, true, false);
      repeat
         LirePositionSouris (xs, ys);
         EffacerCadre;
         x := XUtilisateur (xs) - dx;
         y := YUtilisateur (ys) - dy;
         AfficherCadre;
      until not UnboutonSourisEnfonce;

      Tracer (C_def, true, false);
      MontrerSouris;
   end;

procedure TCommentaire.Tourner;
   var
      xx0, yy0,
      dx,  dy           : real;

   begin
      cacherSouris;
      Tracer (C_def, true, false);
      calcpoints;
      xx0 := (x1+x3) / 2;
      yy0 := (y1+y3) / 2;
      repeat
         lirepositionsouris (xs, ys);
         dx := XUtilisateur (xs) - xx0;
         dy := YUtilisateur (ys) - yy0;

         EffacerCadre;
         calculer_direction (dx, dy, direct);
         direct := (direct * 180 / pi);

         x := - (lgt / 2) ;
         y := ht / 2;
         calc_point_suivant (x, y);
         x := x + xx0;
         y := y + yy0;

         AfficherCadre;
      until not UnboutonSourisEnfonce;
      Tracer (C_def, true, false);
      MontrerSouris;
   end;

procedure TCommentaire.Incliner;
   var
      dx, dy            : real;

   begin
      LirePositionSouris (xs, ys);
      dx := XUtilisateur (xs) - x;
      dy := YUtilisateur (ys) - y;
      cacherSouris;
      Tracer (C_def, true, false);
      repeat
         LirePositionSouris (xs, ys);
         EffacerCadre;
         x := XUtilisateur (xs) - dx;
         y := YUtilisateur (ys) - dy;
         AfficherCadre;
      until not UnboutonSourisEnfonce;
      Tracer (C_def, true, false);
      MontrerSouris;
   end;

procedure TCommentaire.Dimensionner;
   var
      xx0, yy0,
      rap0,
      dx0,
      dx, dy            : real;

   begin
      cacherSouris;
      Tracer (C_def, true, false);
      calcpoints;
      xx0 := (x1+x3) / 2;
      yy0 := (y1+y3) / 2;
      lirepositionsouris (xs, ys);
      dx := XUtilisateur (xs) - xx0;
      dy := YUtilisateur (ys) - yy0;
      if dy = 0 then dy := 1;
      rap0 := Taille/dx;
      dx0  := dx;

      repeat
         lirepositionsouris (xs, ys);
         dx := XUtilisateur (xs) - xx0;
         dy := YUtilisateur (ys) - yy0;
         if dy = 0 then dy := 1;
         EffacerCadre;

         Taille := dx * rap0;
         if taille <  2 then taille := 2;
         if taille > 50 then taille := 50;

         initialiser_parametres_courants (1, Taille, Direct, inclin, 65);
         LgT := Longueur_texte (texte) / xrap;
         ht  := Hauteur_texte / yrap;

         x := - (lgt / 2) ;
         y := ht / 2;
         calc_point_suivant (x, y);
         x := x + xx0;
         y := y + yy0;

         AfficherCadre;
      until not UnboutonSourisEnfonce;
      Tracer (C_def, true, false);
      MontrerSouris;
   end;

procedure TCommentaire.ChangerPointeur;
    var
       xp, yp           : real;

    begin
       lirepositionsouris (xs, ys);
       xp := XUtilisateur (xs);
       yp := YUtilisateur (ys);
       { case poignee  of
          tourne       : ChangerCurseur (fl_Tourne);
          dimensionne  : ChangerCurseur (Fl_bghd);
          deplace      : ChangerCurseur (main);
          dehors       : ChangerCurseur (Fleche);
       end;}
   end;

procedure TCommentaire.Editer ;
   { Le texte doit tre effac en entre }
   var
      fin               : boolean;

    begin
       c_def   := getcolor;
       fin     := false;
       Touche  := 0;
       SetWriteMode (XorPut);

       Tracer  (c_def, true, false);
       AfficherCadre;
       LimiterDeplacementSouris (px, py, lx ,ly);
       MontrerSouris;
       repeat
          repeat
             ChangerPointeur;
          until UnBoutonSourisEnfonce or ToucheClavier (Touche);

          if BoutonSourisEnfonce (BoutonGauche)
          then begin
             if lier
             then
             Case Poignee of
                Deplace     : Deplacer;
                Dehors      : fin := true;
             end
             else
             Case Poignee of
                Deplace     : Deplacer;
                Tourne      : Tourner;
                Incline     : Incliner;
                Dimensionne : Dimensionner;
                Dehors      : fin := true;
             end;
             repeat until not unboutonsourisenfonce;
          end;
          fin := (Touche = ESC) or (Touche = CR) or (Touche = DEL) or fin;
       until fin;
       CalcPoints;
       CacherSouris;
       LibererDeplacementSouris;
       EffacerCadre;
       Tracer (C_def, true, false);
       SetWriteMode (NormalPut);
    end;

procedure TCommentaire.Tracer;
   var
      poly              : polygone;
      mx1, mx2,
      mx3, mx4,
      my1, my2,
      my3, my4          : real;

   begin
      FixeCoul (C);
      initSMB;
      if cadre or fond
      then begin
         calcpoints;
         mx1 := (x1+x2) /2;
         my1 := (y1+y2) /2;
         mx2 := (x2+x3) /2;
         my2 := (y2+y3) /2;
         mx3 := (x3+x4) /2;
         my3 := (y3+y4) /2;
         mx4 := (x1+x4) /2;
         my4 := (y1+y4) /2;

         if lr     { ligne de rappel }
         then begin
            DeplaceEn (x0, y0);
            case ptchaud of
               1 :  tracevers (x1,  y1);
               2 :  tracevers (mx1, my1);
               3 :  tracevers (x2,  y2);

               4 :  tracevers (mx4, my4);
                    { 5 :  tracevers ( centrer ...?);}
               6 :  tracevers (mx2, my2);

               7 :  tracevers (x4,  y4);
               8 :  tracevers (mx3, my3);
               9 :  tracevers (x3,  y3);
            end;
         end;
         poly [1].x := x1;   poly [1].y := y1;
         poly [2].x := x2;   poly [2].y := y2;
         poly [3].x := x3;   poly [3].y := y3;
         poly [4].x := x4;   poly [4].y := y4;
         poly [5].x := x1;   poly [5].y := y1;

         if fond and ecran
         then begin
            fixecoul      (coulboite);
            setfillstyle  (solidfill, coulboite);
            Polygoneplein (5, poly);   { nb sommets }
            fixecoul (C);
         end;
      end;
      deplaceent   (x, y);
      ecrire_texte (Texte);
   end;

procedure TCommentaire.Afficher;
   begin
      Tracer (Couleur, cadre, fond);
   end;

function TCommentaire.Contient;
   var
      P                 : PPoly;
      pt                : PPoint;

   begin
      CalcPoints;
      P     := new (PPoly,  init);
      pt    := new (PPoint, init);
      pt^.x := x1;
      pt^.y := y1;
      P^.insert (pt);
      pt    := new (PPoint, init);
      pt^.x := x2;
      pt^.y := y2;
      P^.insert (pt);
      pt    := new (PPoint, init);
      pt^.x := x3;
      pt^.y := y3;
      P^.insert (pt);
      pt    := new (PPoint, init);
      pt^.x := x4;
      pt^.y := y4;
      P^.insert (pt);
      Contient := p^.contient (xx, yy);
      dispose   (p, fini);
   end;

constructor TListeComment.init;
   begin
      TCollection.init (0, 1);
   end;

procedure TListeComment.Lit;
   var
      f                 : text;
      Com               : PCommentaire;
      x,  y,
      xk, yk,
      xr, yr,                      { }
      h,  d,
      i                 : real;
      r,
      c,  j             : integer;

      t,
      ligne             : string;
      f2                : boolean;  { marque de fichier produit par CART }

   begin
      assign (f, NomF);
      {$I-} reset (f); {$I+}
      if ioresult = 0
      then begin
         readln (f, ligne);
         f2 := ligne [2] = '2';
         repeat
            read (f, x);         read (f, y);
            { coord objet dans repre       mm }
            read (f, xr);        read (f, yr);
            read (f, xk);        read (f, yk);
            read (f, h);         read (f, d);
            read (f, i);         read (f, c);
            read (f, j);         read (f, r);   {  rappel = 1         }
            if (d2d and not f2)
            then
                r := 0;
            { dans CART/COUP/EXOC il faut inhiber lignes de rappel gnres
            par BLOC }
            if (not d2d and f2)
            then
                r := 1;
            readln  (f, t);
            e_b_devant (t);
            e_b        (t);
            if not ((x = 0) and (y = 0) and (h = 0) and (t = ''))
            then begin
               Com := new (PCommentaire,
                           init (x,  y,  xr,  yr,  xk,  yk,
                                 h,  d,  i,   c,   j,   2, (r=1), t ));
                                 {                      2 poignes }
               insert (Com);
            end;
         until eof (f);
         close (f);
      end;
   end;

procedure TListeComment.Ecrit;
   var
      f                 : text;
      Comm              : PCommentaire;
      r, k,
      i                 : integer;
      ligne             : string;
      ok                : boolean;

   begin
      assign  (f, nomf);
      rewrite (f);
      {rewriteTxtErr   (f, nomf, ok);}
      ligne :=  'x   y     x0    y0     xu    yu    h   d   i  c  j r texte';
      for i := 0 to count-1
      do begin
         Comm := at (i);
         if i = 0
         then begin
            if d2d
            then
               ligne := ';2'+ligne
            else
               ligne := '; '+ligne;
            writeln (f, ligne);
         end;
         if Comm^.lr then r := 1 else r := 0;
         write   (f, Comm^.x:5:1,      ' ', Comm^.y:5:1,      ' ');
         write   (f, Comm^.x0:5:1,     ' ', Comm^.y0:5:1,     ' ');
         write   (f, Comm^.xu:5:1,     ' ', Comm^.yu:5:1,     ' ');
         write   (f, Comm^.Taille:3:1, ' ', Comm^.Direct:4:1, ' ');
         write   (f, Comm^.Inclin:4:1, ' ', Comm^.Couleur:2,  ' ');
         write   (f, Comm^.police:2,   ' ');
         write   (f, r,                ' ');
         writeln (f, Comm^.Texte);
      end;
      close (f);
   end;

procedure TListeComment.Ecritp;
   var
      f                 : text;
      Comm              : PCommentaire;
      r, k,
      i                 : integer;
      ok                : boolean;

   begin
      assign  (f, nomf);
      rewrite (f);
      {rewriteTxtErr   (f, nomf, ok);}
     { writeln (f, '; x   y     texte');}

      for i := 0 to count-1
      do begin
         Comm := at (i);
         write   (f, Comm^.xu:5:1,     ' ', Comm^.yu:5:1,     ' ');
         writeln (f, Comm^.Texte);
      end;
      close (f);
   end;

procedure TListeComment.Tracer;
   procedure AppelTracer (C : PCommentaire); far;
      begin
         C^.Tracer (co, cadre, fond);
      end;

   begin
      ForEach (@AppelTracer);
   end;

procedure TListeComment.Afficher;
   procedure AppelAfficher (C : PCommentaire); far;
      begin
         C^.Afficher (cadre, fond);
      end;

   begin
      ForEach (@AppelAfficher);
   end;

procedure TListeComment.Effacer;
   procedure AppelEffacer (C : PCommentaire); far;
      begin
         C^.Tracer (coulboite, true, false);
      end;

   begin
      ForEach (@AppelEffacer);
   end;

procedure TListeComment.Modifier;
   procedure AppelModifier (C : PCommentaire); far;
      begin
         C^.poign   := nbpg;
         C^.couleur := co;
         C^.taille  := tail;
      end;

   begin
      ForEach (@AppelModifier);
   end;

procedure TListeComment.Recadrer;
   procedure AppelRecadrer (C : PCommentaire); far;
      var
         xiu, yiu       : real;

      begin
         { cloture carte }
          C^.x0  := xpapier (C^.xu);
          C^.y0  := ypapier (C^.yu);
          if c^.lr
          then begin
          {  xiu    := xpapier_ut (C^.x);
             yiu    := ypapier_ut (C^.y);
             C^.x   := xpapier (xiu);
             C^.y   := ypapier (yiu);}
          end else begin
             C^.x := C^.x0;
             C^.y := C^.y0;
          end;
      end;

   begin
      ForEach (@AppelRecadrer);
   end;

function TListeComment.contient;
   var
      ct                : boolean;

   procedure AppelContient (C : PCommentaire); far;
      begin
         C^.initSMB;
         if C^.contient (xx, yy)
         then begin
            comm := c;
            ct   := true;
         end;
      end;

   begin
      ct   := false;
      comm := NIL;
      ForEach (@AppelContient);
      Contient := ct;
   end;

destructor TListeComment.done;
   begin
      TCollection.done;
   end;

END.

{--- COMMENT --------------------------------- XC -- ARX ----------- - 1995 }
