&&**********************************************************************
&&                       Example to interface the
&&                 PKWARE Data Compression Library (TM)
&&                                with
&&                 Clipper Summer '87 and Clipper 5.01
&&        Copyright 1990-91, By PKWARE Inc.  All Rights Reserved.
&&**********************************************************************
&&
&&  This program will use PKWARE's Data Compression Library to compress
&&  the file TEST.IN into a file called TEST.CMP.  The file TEST.CMP is
&&  then expanded to it's normal size in a file called TEST.EXT.
&&
&&  LINK line: link example+interfce+implode,,,extend.lib;
&&  Note: If you are using BLINKER, you need version 1.5 or later.

public inhandle, outhandle

COMPRESS( 'TEST.IN' )                            && Compress file TEST.IN
UNCOMPRESS( 'TEST.CMP', 'TEST.EXT' )             && Extract TEST.CMP
return

FUNCTION COMPRESS
   parameters fname
   inhandle = fopen( fname, 0 )                  && Open file

   if ( inhandle == -1 )                         && Error opening file ??
      ? "Error opening " + fname
      return .f.
   endif

   outhandle = fcreate( "TEST.CMP" )             && Create file

   ? "Imploding  TEST.IN  => TEST.CMP"

   &&   Call the 'C' function with the Dictionary Size, and the Compression
   &&   type.  We will use a 4K dictionary, and ASCII compression.

   pk_implode(4096 , 1)

   fclose( inhandle )                            && Close files
   fclose( outhandle )
return .t.

FUNCTION UNCOMPRESS
   parameters inname, outname
   inhandle = fopen( inname, 0 )                 && Open file

   if ( inhandle == -1 )
      ? "Error opening " + inname
      return .f.
   endif

   outhandle = fcreate( outname )                && Create file

   ? "Exploding  TEST.CMP => TEST.EXT"

   pk_explode()

   ? "Done Exploding"

   fclose( inhandle )                            && Close files
   fclose( outhandle )
return .t.

FUNCTION R_DATA
   private buff, bytesread, size
   size = pk_getsize()                           && Number of bytes to read
   buff = space( size )                          && Get temporary buffer
   bytesread = fread( inhandle, @buff, size )    && Read data from file
   pk_setbuf( @buff, bytesread )                 && Copy buffer contents
return bytesread

FUNCTION W_DATA
   fwrite( outhandle, pk_getbuf(), pk_getsize()) && Write to disk
return .t.
