{************************************************}
{   FVIEWER.PAS                                  }
{   Turbo Pascal 6.0 TVDEMOS Accessoire          }
{   Copyright (c) 1990 by Borland International  }
{************************************************}
{ modifie par T.O. pour les besoins de Leman 2 }

UNIT FViewer;

{ Accessoire Visionneur de fichier texte (unit utilise par TVDEMO.PAS). }

INTERFACE

USES Objects, Views, Dos, LmnVue4;

TYPE

  { TLineCollection }

  PLineCollection = ^TLineCollection;
  TLineCollection = object(TCollection)
    procedure FreeItem(P: Pointer); virtual;
  end;

  { TFileViewer }

  PFileViewer = ^TFileViewer;
  TFileViewer = object(TScroller)
    FileName: PString;
    FileLines: PCollection;
    IsValid: Boolean;
    constructor Init(var Bounds: TRect; AHScrollBar, AVScrollBar: PScrollBar;
      var AFileName: PathStr);
    destructor Done; virtual;
    procedure Draw; virtual;
    procedure ReadFile(var FName: PathStr);
    procedure SetState(AState: Word; Enable: Boolean); virtual;
    function Valid(Command: Word): Boolean; virtual;
  end;

  { TFileWindow }

  PFileWindow = ^TFileWindow;
  TFileWindow = object(TLmnWindow)
    Texte : PCollection; { pointe FileLines de FileViewer }
    constructor Init(var FileName: PathStr);
    procedure  ActiveCommandes; virtual;
    procedure Imprime(NoLC:Boolean); virtual;
  end;

IMPLEMENTATION

USES Drivers, Memory, Msgbox, App,
     LmnVue0, LmnPrt0, LmnPrt2;

{ TLineCollection }
procedure TLineCollection.FreeItem(P: Pointer);
begin
  DisposeStr(P);
end;

{ TFileViewer }
constructor TFileViewer.Init(var Bounds: TRect; AHScrollBar,
  AVScrollBar: PScrollBar; var AFileName: PathStr);
begin
  TScroller.Init(Bounds, AHScrollbar, AVScrollBar);
  GrowMode := gfGrowHiX + gfGrowHiY;
  FileName := nil;
  ReadFile(AFileName);
end;

destructor TFileViewer.Done;
begin
  Dispose(FileLines, Done);
  if FileName<>nil then DisposeStr(FileName);
  TScroller.Done;
end;

procedure TFileViewer.Draw;
var
  B: TDrawBuffer;
  C: Byte;
  I: Integer;
  S: String;
  P: PString;
begin
  C := GetColor(1);
  for I := 0 to Size.Y - 1 do
  begin
    MoveChar(B, ' ', C, Size.X);
    if Delta.Y + I < FileLines^.Count then
    begin
      P := FileLines^.At(Delta.Y + I);
      if P <> nil then S := Copy(P^, Delta.X + 1, Size.X)
      else S := '';
      MoveStr(B, S, C);
    end;
    WriteLine(0, I, Size.X, 1, B);
  end;
end;

procedure TFileViewer.ReadFile(var FName: PathStr);
var
  FileToView: Text;
  Line: String;
  MaxWidth: Integer;
  E: TEvent;
begin
  IsValid := True;
  if FileName <> nil then DisposeStr(FileName);
  FileName := NewStr(FName);
  FileLines := New(PLineCollection, Init(5,5));
  {$I-}
  Assign(FileToView, FName);
  FileMode:=64;
  Reset(FileToView);
  if IOResult <> 0 then
  begin
    MessageBox(^C'Ne peut ouvrir le fichier '+FName+'.', nil, mfError + mfOkButton);
    IsValid := False;
  end
  else
  begin
    MaxWidth := 0;
    while not Eof(FileToView) and not LowMemory do
    begin
      Readln(FileToView, Line);
      if Length(Line) > MaxWidth then MaxWidth := Length(Line);
      FileLines^.Insert(NewStr(Line));
    end;
    Close(FileToView);
  end;
  {$I+}
  Limit.X := MaxWidth;
  Limit.Y := FileLines^.Count;
end;

procedure TFileViewer.SetState(AState: Word; Enable: Boolean);
begin
  TScroller.SetState(AState, Enable);
  if Enable and (AState and sfExposed <> 0) then
     SetLimit(Limit.X, Limit.Y);
end;

function TFileViewer.Valid(Command: Word): Boolean;
begin
  Valid := IsValid;
end;

{ *** Mthodes de TFileWindow *** }

constructor TFileWindow.Init(var FileName: PathStr);
var
  Rep:DirStr; Nom:NameStr; Ext:ExtStr;
  R: TRect;
  FV:PFileViewer;
begin
  FSplit(FileName,Rep,Nom,Ext);
  R.Assign(0,0,70,20);
  inherited Init(R,'Scnario '+Nom);
  Palette:=wpGrayWindow;
  GetExtent(R);
  R.Grow(-1, -1);
  FV:=New(PFileViewer, Init(R,
    StandardScrollBar(sbHorizontal + sbHandleKeyboard),
    StandardScrollBar(sbVertical + sbHandleKeyboard), Filename));
  Insert(FV);
  Texte:=FV^.FileLines;
  Valide:=FV^.IsValid;
end;

procedure TFileWindow.ActiveCommandes;
begin
  EnableCommands([cmImprimerDonnees]);
end;

procedure TFileWindow.Imprime;
var
  Largeur,Hauteur:Integer;
  Doc:PLmnDoc;
procedure AjouteLigne(Item:Pointer); far;
  begin
    if ((Doc^.Count-1) mod Hauteur)=0
    then Doc^.Insert(NewStr(FormFeed));
    if Item=nil
    then Doc^.Insert(nil)
    else Doc^.Insert(NewStr(Copy(PString(Item)^,1,Largeur)));
  end;
begin
  Largeur:=Imprimante^.NbMaxCar;
  Hauteur:=Imprimante^.NbMaxLig;
  Doc:=New(PLmnDoc,Init(16,16));
  Doc^.Insert(NewStr(Title^));
  Doc^.Insert(nil);
  Texte^.ForEach(@AjouteLigne);
  Imprimante^.Print(Doc);
  Dispose(Doc,Done);
end;

END.

{   EOS FVIEWER.PAS                                  }
