Unit Fonction;
{}
{                                                                        }
{   PROCEDURES DE COMPILATION ET D'EVALUATION DES FONCTIONS UTILISATEUR  }
{                                                                        }
{     (Module  inclure systmatiquement dans un programme utilisant     }
{                    une fonction mathmatique)                          }
{Ĳ}
{ FUNCTION  Evalue                                                       }
{ PROCEDURE RecopieFonction                                              }
{ PROCEDURE DetruitFonction                                              }
{ FUNCTION  CompileFonction                                              }
{ PROCEDURE DecompileFonction                                            }
{ PROCEDURE EntreeFonction                                               }
{ FUNCTION  EntreeNombre                                                 }
{ FUNCTION  DigitaliseFonction                                           }
{                                                                        }
{Ĳ}
{ MAINTENANCE :                                                          }
{Ĳ}
{              @Alain Reverchon et Marc Ducamp, 1987, France             }
{}

{}
{                   TYPES ET CONSTANTES SPECIFIQUES                      }
{}
Interface

uses MathBase;
TYPE
  TypeNoeud      = (CTE, VARIABLE, OPUNAIRE, OPBINAIRE);
  UneOperUnaire  =
    (FMOINS, FPLUS, FSIN, FCOS, FTAN, FARCSIN, FARCCOS,
     FARCTAN, FSH,  FCH, FTH, FARGSH, FARGCH, FARGTH,
     FABS, FINT, FFRAC, FFACT, FEXP, FLOG, FSQR);
  UneOperBinaire = (FSUM, FSUB, FMUL, FDIV, FPUI);

  PtrNoeud = ^noeud;
  noeud =
    RECORD
      gauche, droite : PtrNoeud;
      CASE tip : TypeNoeud OF
        CTE        : (valeur : real);
        VARIABLE   : (rang   : integer);
        OPUNAIRE   : (oper1  : UneOperUnaire);
        OPBINAIRE  : (oper2  : UneOperBinaire);
    END;

  FONC    = noeud;
  DIXFONC = ARRAY [1..10] OF FONC;
  MAXSTRING = String;
  CHAINE  = String[80];
  DONNEES = Array[0..{MAXDONNEES}800] of real;
  UNTAMPON = Record
                x,y : Donnees;
                n : integer;
             end;

CONST
  OperationsUnaires : ARRAY [UneOperUnaire] OF STRING [6] =
     ('-', '+',
      'SIN','COS','TAN','ARCSIN','ARCCOS','ARCTAN',
      'SH', 'CH', 'TH', 'ARGSH', 'ARGCH', 'ARGTH',
      'ABS','INT','FRAC', 'FACT', 'EXP','LN','SQR');

  lastfonc : CHAINE = '';

  VAR f1, f2, f3, f4 : FONC;
      err            : BOOLEAN;
      param          : Array [0..99] of real;

         FUNCTION  Evalue (f : FONC; x : real) : real;
         PROCEDURE RecopieFonction (f:FONC; VAR g:FONC);
         PROCEDURE DetruitFonction (VAR f:FONC);
         FUNCTION  CompileFonction (ch:MAXSTRING; VAR f:FONC) : boolean;
         PROCEDURE DecompileFonction (f:FONC; VAR ch:MAXSTRING);
         FUNCTION  EntreeFonction (tx:CHAINE; VAR f:FONC) : boolean;
         FUNCTION  EntreeNombre (tx:CHAINE) : real;
         FUNCTION  DigitaliseFonction (f:FONC; VAR t:UNTAMPON;
                                      a,b:real; n:integer; aff:boolean) : boolean;

Implementation
{}
{                      FONCTION D'EVALUATION                             }
{}
FUNCTION Evalue (f : FONC; x : real) : real;
VAR  i, j : integer;
     r, s : real;
BEGIN
  err    := FALSE;
  evalue := 0;
  CASE f.tip OF
    CTE       : evalue := f.valeur;
    VARIABLE  : IF (f.rang = -1)
                   THEN evalue := x
                   ELSE evalue := param [f.rang];
    OPUNAIRE  : BEGIN
                   r := evalue (f.gauche^, x);
                   IF err THEN exit;
                   CASE f.oper1 OF
                     FMOINS : evalue := - r;
                     FPLUS  : evalue := r;
                     FABS   : evalue := abs  (r);
                     FINT   : evalue := int  (r);
                     FFRAC  : evalue := frac (r);
                     FSQR   : IF (r >= 0)
                                 THEN evalue := sqrt (r)
                                 ELSE err    := TRUE;
                     FEXP   : evalue := exp (r);
                     FLOG   : IF (r > 0)
                                 THEN evalue := ln (r)
                                 ELSE err    := TRUE;
                     FSIN : evalue := sin (r);
                     FCOS : evalue := cos (r);
                     FTAN : BEGIN
                              s := cos (r);
                              IF (s <> 0)
                                 THEN evalue := sin (r) / s
                                 ELSE err    := TRUE;
                            END;
                     FSH  : evalue := (exp (r) - exp (-r)) / 2;
                     FCH  : evalue := (exp (r) + exp (-r)) / 2;
                     FTH  : evalue := (exp (2 * r) - 1) / (exp (2 * r) + 1);
                  FARCSIN : IF (r = -1)
                             THEN evalue := -PI/2
                             ELSE
                              IF (r = 1)
                               THEN evalue := PI/2
                               ELSE
                                IF (r > -1) AND (r < 1)
                                 THEN evalue := ArcTan (r / Sqrt (1 - Sqr(r)))
                                 ELSE err    := TRUE;
                  FARCCOS : IF (r = -1)
                             THEN evalue := PI
                             ELSE
                              IF (r = 1)
                               THEN evalue := 0
                               ELSE
                                IF (r > -1) AND (r < 1)
                                 THEN evalue := PI/2 - ArcTan (r / Sqrt (1 - Sqr(r)))
                                 ELSE err    := TRUE;
                  FARCTAN : evalue := Arctan (r);
                   FARGSH : evalue := ln (r + SQRT (1 + r * r));
                   FARGCH : IF (r >= 1)
                                 THEN evalue := ln (r + SQRT (-1 + r * r))
                                 ELSE err    := TRUE;
                   FARGTH : IF (r > -1) AND (r < 1)
                                 THEN evalue := ln ((1 + r) / (1 - r)) / 2
                                 ELSE err    := TRUE;
                    FFACT : IF (abs (r) < 32)
                              THEN
                                BEGIN
                                s := 1;
                                FOR i:=1 TO ROUND (r) DO s := s * i;
                                evalue := s;
                                END
                              ELSE err    := TRUE;
                 END; {CASE}
                 END;
    OPBINAIRE : BEGIN
                   r := evalue (f.gauche^, x);
                   IF err THEN exit;
                   s := evalue (f.droite^, x);
                   IF err THEN exit;
                   CASE f.oper2 OF
                     FSUM : evalue := r + s;
                     FSUB : evalue := r - s;
                     FMUL : evalue := r * s;
                     FDIV : IF (s <> 0)
                               THEN evalue := r / s
                               ELSE err    := TRUE;
                     FPUI : IF (f.droite^.tip IN [CTE, VARIABLE])
                              AND (int (s) = s) THEN
                               BEGIN
                                 j := ROUND (s);
                                 IF (j < 10)
                                  THEN
                                  BEGIN
                                    s := 1;
                                    FOR i:=1 TO j DO s := s * r;
                                    evalue := s;
                                  END
                                  ELSE
                                  IF (r = 0)
                                   THEN evalue := 0
                                   ELSE
                                   IF odd (j)
                                     THEN
                                      IF (r > 0)
                                        THEN evalue := exp (ln (r) * s)
                                        ELSE evalue := - exp (ln (-r) * s)
                                     ELSE  evalue := exp (ln (abs (r)) * s);
                               END
                               ELSE
                               IF (r = 0) THEN evalue := 0
                               ELSE
                                 IF (r > 0) THEN evalue := exp (s * ln (r))
                                            ELSE err    := TRUE;
                 END; {CASE oper2}
          END; {cas des operations binaires}
    END; {CASE}
END;


{}
{                   FONCTION DE RECOPIE DE LA FONCTION                   }
{}
PROCEDURE RecopieFonction (f:FONC; VAR g:FONC);
BEGIN
  g := f;
  CASE f.tip OF
    OPUNAIRE  : BEGIN
                   new (g.gauche);
                   RecopieFonction (f.gauche^, g.gauche^);
                 END;
    OPBINAIRE : BEGIN
                   new (g.gauche);
                   RecopieFonction (f.gauche^, g.gauche^);
                   new (g.droite);
                   RecopieFonction (f.droite^, g.droite^);
                 END;
  END;
END;

{}
{                  FONCTION D'EFFACEMENT DE LA FONCTION                  }
{}
PROCEDURE DetruitFonction (VAR f:FONC);
BEGIN
  WITH f DO
  CASE tip OF
    OPBINAIRE : BEGIN
                   DetruitFonction (droite^);
                   dispose (droite);
                   DetruitFonction (gauche^);
                   dispose (gauche);
                 END;
    OPUNAIRE  : BEGIN
                   DetruitFonction (gauche^);
                   dispose (gauche);
                 END;
  END;
END;

{}
{        FONCTION DE CREATION DE L'ARBRE A PARTIR DE LA FONCTION         }
{}
FUNCTION CreeArbre (ch:MAXSTRING; VAR n:noeud) : boolean;

VAR  i, j, l     : integer;
     r           : real;
     k           : UneOperUnaire;
     p1, p2      : Ptrnoeud;

FUNCTION SauteParentheses (VAR i: integer; sens:integer) : boolean;
VAR  np : integer;
BEGIN
  np  := 0;
  REPEAT
    CASE ch [i] OF
      '(' : np := np + 1;
      ')' : np := np - 1;
    END;
    i := i + sens;
  UNTIL (np = 0) OR (i > l) OR (i < 1);
  i := i - sens;
  SauteParentheses := (np = 0);
END;

PROCEDURE Coupe (c:CHAINE; x:UneOperUnaire);
BEGIN
  n.tip   := OPUNAIRE;
  n.oper1 := x;
  new (p1);
  n.gauche := p1;
  CreeArbre := CreeArbre (c, n.gauche^);
END;

PROCEDURE CoupeBi (x : UneOperBinaire);
BEGIN
  n.tip   := OPBINAIRE;
  n.oper2 := x;
  new (p1); new (p2);
  n.gauche := p1; n.droite := p2;
  IF NOT CreeArbre (copy (ch, 1,   i-1), n.gauche^) THEN exit;
  IF NOT CreeArbre (copy (ch, i+1, l-i), n.droite^) THEN exit;
  CreeArbre := TRUE;
END;

FUNCTION recherche (c1,c2:char; x1,x2:UneOperBinaire) : boolean;
BEGIN
  recherche := FALSE;
  i := l;
  REPEAT
     IF (ch [i] = ')') THEN
       IF NOT SauteParentheses (i, -1) THEN
         BEGIN
         recherche := TRUE;
         exit;
         END;
     IF (ch [i] = c1) THEN
       IF (i > 1) AND (i < l) AND NOT (ch [i-1] IN ['(', 'E', '*', '/', '^']) THEN
          BEGIN
          CoupeBi (x1);
          recherche := TRUE;
          exit;
          END;
     IF (ch [i] = c2) THEN
       IF (i > 1) AND (i < l) AND NOT (ch [i-1] IN ['(', 'E', '*', '/', '^']) THEN
          BEGIN
          CoupeBi (x2);
          recherche := TRUE;
          exit;
          END;
     i := i - 1;
   UNTIL (i <= 1);
END;

BEGIN
   {------------------------ 1: Initialisations }
   CreeArbre := FALSE;
   n.tip     := CTE;
   l := length (ch);
   IF (l = 0) THEN exit;

   {------------------------ 2: Recherche des oprations binaires }
   IF recherche ('-', '+', FSUB, FSUM) THEN exit;
   IF recherche ('/', '*', FDIV, FMUL) THEN exit;
  {------------------------ 4: Recherche du - et du + unaires }
  IF (ch [1] = '-') THEN
    BEGIN
    Coupe (copy (ch, 2, l-1), FMOINS);
    exit;
    END;
  IF (ch [1] = '+') THEN
    BEGIN
    Coupe (copy (ch, 2, l-1), FPLUS);
    exit;
    END;

   IF recherche ('^', '^', FPUI, FPUI) THEN exit;

  {------------------------ 3: Recherche des parenthses }
   i := 1;
   IF (ch [1] = '(') THEN
     BEGIN
       IF SauteParentheses (i, 1) THEN
          IF (i = l) THEN CreeArbre := CreeArbre (copy (ch, 2, l-2), n);
       exit;
     END;

  {------------------------ 5: Recherche de ! }
  IF (ch [l] = '!') THEN
    BEGIN
    Coupe (copy (ch, 1, l-1), FFACT);
    exit;
    END;

  {------------------------ 6: Recherche des fonctions unaires }
   FOR k := FSIN TO FSQR DO
   BEGIN
     j := length (OperationsUnaires [k]);
     IF (OperationsUnaires [k] = copy (ch, 1, j)) THEN
       BEGIN
       IF (ch [j + 1] = '(') THEN Coupe (copy (ch, j+1, l-j), k);
       exit;
       END;
   END;

  {------------------------ 7: Recherche des sous-fonctions }
   IF (ch = 'U') OR (ch = 'U''') OR (ch = 'V') OR (ch = 'V''') THEN
     BEGIN
     IF (ch = 'U')   THEN RecopieFonction (f1, n);
     IF (ch = 'U''') THEN RecopieFonction (f2, n);
     IF (ch = 'V')   THEN RecopieFonction (f3, n);
     IF (ch = 'V''') THEN RecopieFonction (f4, n);
     CreeArbre := TRUE;
     exit;
     END;

  {------------------------ 8: Recherche des inconnues }
   IF (ch = 'X') OR (ch = 'T') OR (ch = 'I') OR (ch = 'N') THEN
    BEGIN
     n.tip      := VARIABLE;
     n.rang     := -1;
     CreeArbre := TRUE;
     exit;
    END;
   IF (ch [1] = 'Y') THEN
    BEGIN
      IF (l = 1)
       THEN n.rang := 0
       ELSE
        BEGIN
         IF (ch [2] = '''')
          THEN
           BEGIN
             n.rang := l - 1;
             FOR j := 2 TO l DO
              IF (ch [j] <> '''') THEN exit;
           END
          ELSE
           BEGIN
            val (copy (ch, 2, l-1), i, j);
            IF (j <> 0) THEN exit;
            n.rang := i;
           END;
        END;
      n.tip      := VARIABLE;
      CreeArbre := TRUE;
      exit;
    END;

  {------------------------ 9: Recherche des ctes prdfinies }
   IF (ch = 'PI') THEN
   BEGIN
     n.tip      := CTE;
     n.valeur   := PI;
     CreeArbre := TRUE;
     exit;
   END;

  {------------------------ 10: Recherche des ctes numriques }
   val (ch, r, i);
   IF (i = 0) THEN
   BEGIN
     n.tip      := CTE;
     n.valeur   := r;
     CreeArbre := TRUE;
   END;

END; {FUNCTION CreeArbre}

{}
{                 FONCTION DE COMPILATION DE LA FONCTION                 }
{}
FUNCTION CompileFonction (ch:MAXSTRING; VAR f:FONC) : boolean;
VAR  i, j : integer;
BEGIN
   CompileFonction := FALSE;
   j := 0;
   FOR i:=1 TO length (ch) DO
    IF (ch [i] <> ' ') THEN
     BEGIN
       j:= j + 1;
       ch [j] := upcase (ch [i]);
     END;
   {ch [0] := chr (j);}
   ch:=copy(ch,1,j);
   IF CreeArbre (ch, f)
      THEN CompileFonction := TRUE
      ELSE DetruitFonction (f);
END;

{}
{                 FONCTION DE DECOMPILATION D'UNE FONCTION               }
{}
PROCEDURE DecompileFonction (f:FONC; VAR ch:MAXSTRING);

VAR  ch1, ch2 : MAXSTRING;
     r, s     : real;
     par      : boolean;
     i        : integer;

BEGIN
  CASE f.tip OF
    CTE        :
      BEGIN
        str (f.valeur:20:10, ch);
        WHILE (ch[1]=' ') DO ch := copy (ch, 2, length (ch)-1);
        WHILE (ch[length(ch)]='0') DO ch := copy (ch, 1, length (ch)-1);
        IF    (ch[length(ch)]='.') THEN ch := copy (ch, 1, length (ch)-1);
      END;
    VARIABLE   : CASE f.rang OF
                   -1 : ch := 'X';
                   else ch := 'Y' + CHint (f.rang, 0);
                 END;
    OPUNAIRE  : BEGIN
                   DecompileFonction (f.gauche^, ch1);
                   IF length (ch1) > 245 THEN exit;
                   IF (f.oper1 = FMOINS)
                     THEN ch := '-' + ch1
                     ELSE
                   IF (f.oper1 = FPLUS)
                     THEN ch := ch1
                     ELSE
                      IF ch1 [1] = '('
                        THEN ch := OperationsUnaires [f.oper1] + ch1
                        ELSE ch := OperationsUnaires [f.oper1] + '(' + ch1 + ')';
                 END;
    OPBINAIRE : BEGIN
                   DecompileFonction (f.gauche^, ch1);
                   DecompileFonction (f.droite^, ch2);
                   IF length (ch1) + length (ch2) > 250 THEN exit;

                   par := TRUE; { A priori, on entourera de parenthses }
                   {Mais pas de parenthses si succession d'oprations identiques}
                   IF  ((f.droite^.tip = OPBINAIRE) AND (f.droite^.oper2 = f.oper2))
                    OR ((f.gauche^.tip = OPBINAIRE) AND (f.gauche^.oper2 = f.oper2))
                        THEN par := FALSE;

                   CASE f.oper2 OF
                     FSUM : ch := ch1 + ' + ' + ch2;
                     FSUB : ch := ch1 + ' - ' + ch2;
                     FMUL : ch := ch1 + ' * ' + ch2;
                     FDIV : ch := ch1 + ' / ' + ch2;
                     FPUI : BEGIN
                              ch := ch1 + ' ^ ' + ch2;
                              par := FALSE;
                            END;
                   END; {CASE oper2}
                   IF par THEN ch := '(' + ch + ')';
                 END; {cas des operations binaires}
  END; {CASE}
END;


{}
{                FUNCTION D'ENTREE D'UNE FONCTION                        }
{}
FUNCTION EntreeFonction (tx:CHAINE; VAR f:FONC) : boolean;
VAR  i  : integer;
     ch : CHAINE;
BEGIN
  EntreeFonction := TRUE;
  FOR i:=1 TO 3 DO
  BEGIN
    {write (tx);
    readln (ch);}
    IF (ch = '')
      THEN writeln (tx, lastfonc)
      ELSE lastfonc := ch;
    IF CompileFonction (lastfonc, f) THEN exit;
    {bip;
    writeln ('Erreur de Syntaxe');}
  END;
  EntreeFonction := FALSE;
END;

{}
{                FUNCTION D'ENTREE SYMBOLIQUE D'UN REEL                  }
{}
FUNCTION EntreeNombre (tx:CHAINE) : real;
VAR ch : CHAINE;
    bb : boolean;
    f  : FONC;
    i  : integer;
BEGIN
  FOR i := 1 TO 3 DO
  BEGIN
    write (tx);
    readln (ch);
    IF CompileFonction (ch, f) THEN
    BEGIN
      EntreeNombre := evalue (f, 0);
      IF NOT err THEN exit;
    END;
    bip;
  END;
  EntreeNombre := 0;
  writeln (tx, 0);
END;

{}
{                FONCTION DE DIGITALISATION D'UNE FONCTION               }
{}
FUNCTION DigitaliseFonction (f:FONC; VAR t:UNTAMPON;
                 a,b:real; n:integer; aff:boolean) : boolean;
VAR s : real;
    i : integer;
BEGIN
  DigitaliseFonction := FALSE;
  IF (n > MAXDONNEES) THEN exit;
  t.n := n;
  FOR i:=0 TO n DO
   BEGIN
     s       := a + (b-a) * i / n;
     t.x [i] := s;
     t.y [i] := evalue (f, s);
     IF aff AND (NOT err) THEN
       BEGIN
       AfficheNombre ('X'+CHint(i, 0)+'=',   t.x [i], FALSE);
       AfficheNombreln ('  Y'+CHint(i, 0)+'=', t.y [i], TRUE);
       END;
     {IF Keypressed THEN exit;}
   END;
  DigitaliseFonction := TRUE;
END;
end.