{**************************************************************************}
{                              S I E - C N D P                             }
{**************************************************************************}
{ Nom du programme  : IMAGUNIT                                             }
{ Auteur            : Daniel Levrard et Robert Lagoutte                    }
{ Date de rvision  : 24/04/94                                             }
{ Numro de Version : 1                                                    }
{ Langage           : TurboPascal 7                                        }
{ Commentaire       : programme d'affichage d'images                       }
{**************************************************************************}

{$O+} {$F+}

UNIT ImagUnit;

INTERFACE
uses Dos,crt;


const
mg_Auto=0;              {mode automatique}
mg_Text40=1;            {texte 40 colonnes}
mg_Text80=3;            {texte 80 colonnes}
mg_CGA4=4;              {graphique 320x200 2 couleurs}
mg_CGAm=6;              {graphique 640x200 2 couleurs}
mg_Herc=8;              {Hercules}
mg_EGAb=13;             {graphique 320x200 16 couleurs}
mg_VGAm=14;             {graphique 640x200 16 couleurs}
mg_EGAm=15;             {graphique 640x350 1 couleur}
mg_EGAh=16;             {graphique 640x350 16 couleurs}
mg_VGA16=17;            {graphique 640x480 16couleurs}
mg_VGA2=18;             {graphique 320x480 2 couleurs}
mg_VGA256=19;           {graphique 320x200 256 couleurs}
mg_Superpose=128;       {superposition  image existante}

im_Inconnu=0;
im_PCX=1;           {format PCX}
im_BMP=2;           {format Bit-Map}
im_GIF=3;           {format GIF}
im_TIFF=4;          {format TIFF}
im_BMX=170;         {format interne, 170=$AA, facile  reconnatre en en-tte !}

NbBuffersImage=4;

type

TColor = record
              Red,
              Green,
              Blue:byte
            end;


TAPalette=array[0..255] of TColor ;

TPalette = record
             pa_Etendue:byte;
             pa_Couleurs:TAPalette;
           end;

TImage_EnTete = record
                   ih_Nature:byte;
                   ih_Largeur:word;
                   ih_Hauteur:word;
                   ih_Plans:word;
                   ih_Palette:TPalette;
                 end;

TRImage = record
            Pointeur:pointer;
            Taille:word
          end;

TAImage = array[0..NbBuffersImage] of TRImage;

TImage = record
           En_Tete:TImage_EnTete;
           Pixels:TAImage;
         end;

function Get_Mode_Graphique:byte;
procedure Set_Mode_Graphique(n:byte);
procedure Const_Graphique_Mode(mode:byte;var Largeur,Hauteur:word;var Plans:byte);
function Load_Image(g_nom_fichier:pathstr;var Image:TImage):integer;
function Save_Image(g_nom_fichier:pathstr;var Image:TImage):integer;
function Get_Image_Screen(var Image:TImage;Palette:TPalette;a_x,a_y,d_x,d_y:word):integer;
function Extract_Image(var ISource,IBut:TImage;a_x,a_y,d_x,d_y:word):integer;
procedure Dispose_Image(var Image:TImage);
function Size_Image(Image:TImage):longint;
procedure Display_Image(g_mode:byte;Image:TImage;a_x,a_y:word);
procedure Get_Palette(var Palette:TPalette);
procedure Put_PaletteVGA16_Standard(var Palette:TPalette);
procedure Put_PaletteVGAMono_Standard(var Palette:TPalette);

IMPLEMENTATION

type
TPalette16=array[0..15] of TColor;
TPaletteMono=array[0..1] of TColor;

const
Palette_VGA16_Standard:TPalette16=(
          (Red:$00;Green:$00;Blue:$00),
          (Red:$80;Green:$00;Blue:$00),
          (Red:$00;Green:$80;Blue:$00),
          (Red:$80;Green:$80;Blue:$00),
          (Red:$00;Green:$00;Blue:$80),
          (Red:$80;Green:$00;Blue:$80),
          (Red:$00;Green:$80;Blue:$80),
          (Red:$80;Green:$80;Blue:$80),
          (Red:$90;Green:$90;Blue:$90),
          (Red:$ff;Green:$00;Blue:$00),
          (Red:$00;Green:$ff;Blue:$00),
          (Red:$ff;Green:$ff;Blue:$00),
          (Red:$00;Green:$00;Blue:$ff),
          (Red:$ff;Green:$00;Blue:$ff),
          (Red:$00;Green:$ff;Blue:$ff),
          (Red:$ff;Green:$ff;Blue:$ff));

Palette_VGAMono_Standard:TPaletteMono=
     ((Red:$00;Green:$00;Blue:$00),(Red:$ff;Green:$ff;Blue:$ff));

type
TColorBMP = record
              Blue,
              Green,
              Red,
              Dummy:byte;
            end;

TPal_BMP = array[0..15] of TColorBMP;
TPal_PCX = array[0..15] of TColor;

TBuffer_BM = array[1..80,1..8] of char;

TEn_Tete_PCX=record
               Manufacturer:byte ;
               Version:byte ;
               Encoding:byte ;
               Bits_per_pixel:byte ;
               x_min, y_min, x_max, y_max: integer ;
               Hres,Vres:integer ;
               Palette:TPal_PCX;
               Reserved: byte ;
               Colour_Planes: byte ;
               bytes_per_line: integer ;
               palette_type: integer ;
               remplissage: array[0..57] of byte
             end;

TEn_Tete_BM = record
                bfType:array[0..1] of char;
                bfSize:longint;
                bfReserved:longint;
                bfOffBits:longint;
                biSize:longint;
                biWidth:longint;
                biHeight:longint;
                biPlanes:word;
                biBitCount:word;
                biCompression:longint;
                biSizeImage:longint;
                biXPelsPerMeter:longint;
                biYPelsPerMeter:longint;
                biClrUsed:longint;
                biClrImportant:longint;
                biPalette:TPal_BMP;
                remplissage:array[1..1024] of char;
             end;

const
MaxWord:word=1024*63;
Longueur_Tampon=1024*16;

var
Ligne:array[0..90] of byte;
ColonneFin:array[0..500,1..8] of byte;

procedure modgraph(n : integer);
var
registre:Registers;
begin
registre.AH:=0;
registre.AL:=n;
intr($10,registre);
end;

procedure Put_PaletteVGA16_Standard(var Palette:TPalette);
var
i:integer;
begin
Palette.pa_Etendue:=255;
for i:=0 to 15 do
  begin
    Palette.pa_Couleurs[i].Red:=Palette_VGA16_Standard[i].Red;
    Palette.pa_Couleurs[i].Green:=Palette_VGA16_Standard[i].Green;
    Palette.pa_Couleurs[i].Blue:=Palette_VGA16_Standard[i].Blue;
  end;
for i:=16 to 255 do
  begin
    Palette.pa_Couleurs[i].Red:=0;
    Palette.pa_Couleurs[i].Green:=0;
    Palette.pa_Couleurs[i].Blue:=0;
  end;
end;

procedure Put_PaletteVGAMono_Standard(var Palette:TPalette);
var
i:integer;
begin
Palette.pa_Etendue:=255;
for i:=0 to 1 do
  begin
    Palette.pa_Couleurs[i].Red:=Palette_VGAMono_Standard[i].Red;
    Palette.pa_Couleurs[i].Green:=Palette_VGAMono_Standard[i].Green;
    Palette.pa_Couleurs[i].Blue:=Palette_VGAMono_Standard[i].Blue;
  end;
for i:=2 to 255 do
  begin
    Palette.pa_Couleurs[i].Red:=0;
    Palette.pa_Couleurs[i].Green:=0;
    Palette.pa_Couleurs[i].Blue:=0;
  end;
end;

procedure PCX2BMX(var g_Buffer:TAImage;var Tampon;c:word;
                  var ses,sdi:word;
                  var a_x,a_y,PlanCour,BlocCour,saut:word;
                  Largeur,Hauteur,Plans:word);assembler;
var
Taille,Paquet,OBloc,OPlan,Compteur,x,y,s,DiMini,DiMaxi:word;
asm
      push      ds
      push      es
      jmp       @deb


@Bloc:
      push      ax
      push      bx                    {cration nouveau bloc image}
      push      cx
      push      dx
      push      si
      push      ds
      lds       si,g_buffer
      mov       ax,6
      mov       bx,OBloc
      mul       bx
      add       si,ax
      lodsw
      mov       bx,ax
      mov       DiMini,bx
      lodsw
      mov       cx,ax
      lodsw
      mov       dx,ax
      mov       Taille,ax
      mov       ax,cx
      mov       es,ax
      mov       di,bx
      add       bx,dx
      mov       DiMaxi,bx
      pop       ds
      pop       si
      pop       dx
      pop       cx
      pop       bx
      pop       ax
      retn

@deb:
      cld
      mov       ax,largeur
      inc       ax
      mov       bx,Plans
      mul       bx
      mov       Paquet,ax
      lds       si,BlocCour
      lodsw
      mov       OBloc,ax
      call      near ptr @Bloc
      lds       si,sdi
      lodsw
      mov       di,ax
      lds       si,ses
      lodsw
      mov       es,ax
      lds       si,a_x
      lodsw
      mov       x,ax
      lds       si,a_y
      lodsw
      mov       y,ax
      lds       si,PlanCour
      lodsw
      mov       Oplan,ax
      mov       ax,c
      mov       Compteur,ax
      lds       si,saut
      lodsw
      mov       S,ax
      lds       si,sdi
      lodsw
      mov       di,ax
      lds       si,ses
      lodsw
      mov       es,ax
      lds       si,Tampon
      cmp       s,0
      je        @Boucle
      cmp       s,1000
      je        @b3
      mov       cx,S
      jmp       @Milieu

@Boucle:
      cmp       x,0
      jne       @b1
      mov       al,0
      stosb
      cmp       di,diMaxi
      jbe       @b1
      inc       OBloc
      call      near ptr @Bloc
@b1:  lodsb
      mov       ah,al
      and       ah,$c0
      cmp       ah,$c0
      jne       @b2
      and       al,$3f
      sub       cx,cx
      mov       cl,al
      sub       bl,al
      dec       Compteur
      jnz       @Milieu
      mov       s,cx
      jmp       @Sortie

@Milieu:
      lodsb
      mov       bx,di
      add       bx,cx
      cmp       DiMaxi,bx
      jbe       @BLong
      add       x,cx
      rep       stosb
      jmp       @b4

@b2:  mov       cx,1

@BLong:
      stosb
      cmp       di,diMaxi
      jne       @bl1
      inc       OBloc
      call      near ptr @Bloc
@bl1: inc       x
      dec       cx
      jnz       @BLong
      jmp       @b4

@b4:
      dec       Compteur
      jnz       @b3
      mov       S,1000
      jmp       @Sortie

@b3:
      mov       ax,Largeur
      cmp       x,ax
      jne       @Boucle
      mov       x,0
      dec       OPlan
      jnz       @Boucle
      mov       ax,Plans
      mov       OPlan,ax
      inc       y
      mov       ax,Hauteur
      cmp       ax,y
      je        @Sortie
      mov       bx,diMini
      add       bx,Paquet
      cmp       di,bx
      jbe       @b5
      sub       di,Paquet
      jmp       @b6
@b5:  dec       OBloc
      mov       bx,Paquet
      sub       bx,di
      call      near ptr @Bloc
      add       di,taille
      sub       di,bx
@b6:  mov       bx,diMini
      add       bx,Paquet
      cmp       di,bx
      jbe       @b7
      sub       di,Paquet
      jmp       @b8
@b7:  dec       OBloc
      mov       bx,Paquet
      sub       bx,di
      call      near ptr @Bloc
      add       di,Taille
      sub       di,bx
@b8:  jmp       @Boucle                   {si ligne plan non finie}

@Sortie:
      mov       bx,di
      mov       ax,es
      mov       cx,ax
      les       di,sdi
      mov       ax,bx
      stosw
      les       di,ses
      mov       ax,cx
      stosw
      les       di,a_x
      mov       ax,x
      stosw
      les       di,a_y
      mov       ax,y
      stosw
      les       di,BlocCour
      mov       ax,OBloc
      stosw
      les       di,PlanCour
      mov       ax,Oplan
      stosw
      les       di,Saut
      mov       ax,S
      stosw

      pop       es
      pop       ds
end;

procedure BMP2BMX(var g_Buffer:TAImage;var Tampon;
                           Largeur,Hauteur:word;Plans:byte);assembler;
var
Decal,Savedi,SavTaille,SiDeb,DsDeb,DiDes,EsDes,TailleS,TailleD,Paquet,Colonne,Ligne:word;
OctetsParLigne,Complement,OBlocS,OBlocD:byte;
asm
      push      ds
      push      es
      jmp       @deb


@BlocS:
      push      ax
      push      bx                    {cration nouveau bloc image}
      push      cx
      push      dx
      lds       si,g_buffer
      mov       ax,6
      mov       bl,OBlocS
      mov       bh,0
      mul       bx
      add       si,ax
      lodsw
      mov       bx,ax
      lodsw
      mov       cx,ax
      lodsw
      sub       ax,word ptr Decal
      mov       word Ptr TailleS,ax
      mov       ax,cx
      mov       ds,ax
      mov       si,bx
      add       si,word Ptr Decal
      inc       OBlocS
      pop       dx
      pop       cx
      pop       bx
      pop       ax
      retn

@BlocD:
      push      ax
      push      bx                    {cration nouveau bloc image}
      push      cx
      push      dx
      push      si
      push      ds
      lds       si,g_buffer
      mov       ax,6
      mov       bl,OBlocD
      mov       bh,0
      mul       bx
      add       si,ax
      lodsw
      mov       bx,ax
      lodsw
      mov       cx,ax
      lodsw
      mov       word Ptr TailleD,ax
      mov       ax,cx
      mov       es,ax
      mov       di,bx
      inc       OBlocD
      pop       ds
      pop       si
      pop       dx
      pop       cx
      pop       bx
      pop       ax
      retn

@Decode4Bits:
      push      di
      ror       al,cl
      mov       dl,byte Ptr OctetsParLigne
      mov       dh,0
      ror       al,1
      mov       bl,al
      and       bl,bh
      or        es:[di],bl
      add       di,dx
      ror       al,1
      mov       bl,al
      and       bl,bh
      or        es:[di],bl
      add       di,dx
      ror       al,1
      mov       bl,al
      and       bl,bh
      or        es:[di],bl
      add       di,dx
      ror       al,1
      mov       bl,al
      and       bl,bh
      or        es:[di],bl
      pop       di
      retn

@Decode8Bits:   {a a l'air long mais c'est 2 fois plus rapide qu'une boucle !}
      push      di
      ror       al,cl
      mov       dl,byte Ptr OctetsParLigne
      mov       dh,0
      ror       al,1
      mov       bl,al
      and       bl,bh
      or        es:[di],bl
      add       di,dx
      ror       al,1
      mov       bl,al
      and       bl,bh
      or        es:[di],bl
      add       di,dx
      ror       al,1
      mov       bl,al
      and       bl,bh
      or        es:[di],bl
      add       di,dx
      ror       al,1
      mov       bl,al
      and       bl,bh
      or        es:[di],bl
      add       di,dx
      ror       al,1
      mov       bl,al
      and       bl,bh
      or        es:[di],bl
      add       di,dx
      ror       al,1
      mov       bl,al
      and       bl,bh
      or        es:[di],bl
      add       di,dx
      ror       al,1
      mov       bl,al
      and       bl,bh
      or        es:[di],bl
      add       di,dx
      ror       al,1
      mov       bl,al
      and       bl,bh
      or        es:[di],bl
      pop       di
      retn

@deb:
      mov       ax,Largeur
      mov       bl,8
      div       bl
      cmp       ah,0
      je        @d1
      inc       al
@d1:  mov       byte Ptr OctetsparLigne,al         {nombre d'octets par ligne}
      cld
      mov       ax,Hauteur
      mov       word Ptr Ligne,ax
      mov       al,byte Ptr OctetsParLigne
      mov       ah,0
      mov       bh,0
      mov       bl,Plans
      mul       bx
      mov       word Ptr Paquet,ax
      mov       ax,Hauteur
      mul       bx
      mov       word Ptr Decal,ax
      mov       ax,Largeur
      mov       bl,byte Ptr Plans
      mul       bx
      mov       bx,ax
      shr       ax,1
      shr       ax,1
      shr       ax,1
      mov       cx,ax
      shl       ax,1
      shl       ax,1
      shl       ax,1
      cmp       bx,ax
      je        @d2
      inc       cx
@d2:  mov       ax,cx
      mov       bl,4
      div       bl
      sub       bl,ah
      and       bl,$03
      mov       byte Ptr Complement,bl

      mov       OBlocS,0
      mov       OBlocD,0
      call      near Ptr @BlocD
      mov       DiDes,di
      mov       ax,es
      mov       EsDes,ax
      call      near ptr @BlocS
      mov       word Ptr Decal,0

@Newligne:
      les       di,Tampon                       {prparation tampon ligne}
      push      di
      mov       al,byte Ptr Plans
      mov       ah,0
      mov       bx,80
      mul       bx
      mov       cx,ax
      mov       al,$0
      rep       stosb
      pop       di
      mov       ax,Largeur
      mov       word Ptr Colonne,ax

@1Octet:
      mov       cl,0                    {dcodage d'un pixel sur les 8 plans}
      mov       bh,$80
      cmp       Plans,4
      je        @4Plans
      cmp       Plans,1
      je        @1Plans

@8Plans:
      lodsb
      dec	word Ptr TailleS
      jnz       @8
      call      near Ptr @BlocS
@8:   call      near Ptr @Decode8Bits
      dec       word Ptr Colonne
      jz        @Recopie
      shr       bh,1
      inc       cl
      cmp       cl,8
      jne       @8Plans
      inc       di
      jmp       @1Octet

@4Plans:
      lodsb
      dec	word Ptr TailleS
      jnz       @4
      call      near Ptr @BlocS
@4:   push      ax
      shr       al,1
      shr       al,1
      shr       al,1
      shr       al,1
      call      near Ptr @Decode4Bits
      dec       word Ptr Colonne
      jz        @Recopie
      shr       bh,1
      inc       cl
      pop       ax
      call      near Ptr @Decode4Bits
      dec       word Ptr Colonne
      jz        @Recopie
      shr       bh,1
      inc       cl
      cmp       cl,8
      jne       @4Plans
      inc       di
      jmp       @1Octet

@1Plans:
      lodsb
      dec	word Ptr TailleS
      jnz       @1
      call      near Ptr @BlocS
@1:   stosb
      dec       word Ptr Colonne
      jnz       @1Plans
      jmp       @Recopie

@Recopie:
      push      si
      push      ds
      lds       si,Tampon
      mov       di,DiDes
      mov       ax,EsDes
      mov       es,ax
      mov       bh,Plans
@B1:  mov       al,0
      stosb
      dec       word Ptr TailleD
      jnz       @B2
      call      near Ptr @BlocD
@B2:  mov       ch,0
      mov       cl,byte Ptr OctetsparLigne
      cmp       TailleD,cx
      jb        @CopieLong
      sub       TailleD,cx
@Copie:
      rep       movsb
      cmp       TailleD,0
      jne       @B3
      call      near Ptr @BlocD
@B3:  jmp       @FinR

@CopieLong:
      lodsb
      stosb
      dec       TailleD
      jnz       @R1
      call      near Ptr @BlocD
@R1:  dec       cx
      jnz       @CopieLong
@FinR:
      dec       bh
      jnz       @B1
      mov       DiDes,di
      mov       ax,es
      mov       EsDes,ax
      pop       ds
      pop       si

@Deblayage:
      mov       cl,byte Ptr Complement
@R3:  cmp       cl,0
      je        @R5
      lodsb
      dec	word Ptr TailleS
      jnz       @R4
      call      near Ptr @BlocS
@R4:  dec       cl
      jmp       @R3

@R5:  dec       word Ptr Ligne
      jnz       @NewLigne

@Sortie:
      pop       es
      pop       ds

end;


procedure Dispose_Image(var Image:TImage);
var
i:integer;
begin
for i:=0 to NbBuffersImage do
if Image.Pixels[i].Pointeur<>nil then
  begin
    FreeMem(Image.Pixels[i].Pointeur,Image.Pixels[i].Taille);
    Image.Pixels[i].Pointeur:=nil
  end;
end;

function Load_Image(g_nom_fichier:pathstr;var Image:TImage):integer;
type
TSignature=array[0..1] of char;
const
SignatureBMP:TSignature=('B','M');
SignatureTIFF:TSignature=('I','I');
SignatureGIF:TSignature=('G','I');
SignatureBMX:TSignature=(chr(170),#0);
SignaturePCX:TSignature=(chr($0a),#0);
var
S:SearchRec;
l_fichier:file;
OldFileMode,PaletteSize:byte;
Paquet,sdi,ses,saut,x_c,y_c,t_c,b_c,p_c,c,i,j,resultat,TailleOff:word;
TailleInt,Actuel:longint;
Signature:TSignature;
Type_Image:byte;
EnTetePCX:TEn_Tete_PCX;
EnTeteBM:TEn_Tete_BM;
Tampon:TBuffer_BM;
Bidon:pointer;
BlocPCX:array[1..Longueur_Tampon] of char;

begin
OldFileMode:=FileMode;Load_Image:=0;
for i:=0 to NbBuffersImage do
  with Image.Pixels[i] do begin Pointeur:=nil;Taille:=0 end;
FindFirst(g_nom_fichier,$3f,S);resultat:=DosError;
if Resultat<>0 then
  begin
    Load_Image:=Resultat;
    exit;
  end
else
  begin
    FileMode:=0+64;
    assign(l_fichier,g_nom_fichier);reset(l_fichier,1);
    blockRead(l_Fichier,Signature,2);
    Type_Image:=im_Inconnu;
    if byte(Signature[0])=$0a then Type_Image:=im_PCX
    else if byte(Signature[0])=$aa then Type_Image:=im_BMX
    else if Signature=SignatureBMP then Type_Image:=im_BMP
    else if Signature=SignatureGIF then Type_Image:=im_GIF
    else if Signature=SignatureTIFF then Type_Image:=im_TIFF;
    case Type_Image of
      im_BMX:
        begin
          reset(l_fichier,1);
          blockread(l_Fichier,Image.En_Tete,SizeOf(Image.En_Tete));
          TailleOff:=SizeOf(Image.En_Tete);
          Actuel:=S.Size-longint(TailleOff);
          i:=0;
          if MaxAvail>Actuel then with Image.En_Tete do
            begin
              reset(l_Fichier,1);blockRead(l_Fichier,EnTeteBM,TailleOff);
              repeat
                tailleint:=actuel;
                if tailleint>Maxword then tailleint:=Maxword;
                Actuel:=Actuel-Tailleint;
                with Image.Pixels[i] do
                  begin
                    GetMem(Pointeur,tailleint);Taille:=Tailleint;
                    blockread(l_fichier,Pointeur^,tailleint);
                  end;
                inc(i)
              until (Actuel<=0) or (i>NbBuffersImage);
            end else Load_Image:=101
        end;
      im_PCX:
        begin
          reset(l_fichier,1);
          blockread(l_Fichier,EnTetePCX,SizeOf(EnTetePCX));
          with Image.En_tete do with EnTetePCX do
            begin
              ih_Hauteur:=y_max-y_min+1;ih_Largeur:=x_max-x_min+1;
              ih_Plans:=Colour_planes;ih_Nature:=im_BMX;
              ih_Palette.pa_Etendue:=byte((word(1) shl (ih_Plans))-1);
              if ih_Plans<=4 then for i:=0 to ih_Palette.pa_Etendue do
              ih_Palette.pa_Couleurs[i]:=Palette[i];
              j:=ih_Hauteur*ih_Plans;
            end;
          TailleOff:=128;
          i:=0;
          with Image.En_tete do Actuel:=longint(ih_Hauteur)*longint(ih_Plans)*longint((((ih_Largeur+7) div 8)+1));
          if MaxAvail>=Actuel then with Image.En_Tete do
            begin
              repeat
                tailleint:=Actuel;
                if tailleint>Maxword then tailleint:=Maxword;
                Actuel:=Actuel-Tailleint;
                with Image.Pixels[i] do
                  begin
                    Taille:=word(Tailleint);GetMem(Pointeur,Taille);
                  end;
                inc(i)
              until (Actuel<=0) or (i>NbBuffersImage);
              reset(l_Fichier,1);blockRead(l_Fichier,EnTeteBM,TailleOff);
              x_c:=0;y_c:=0;p_c:=ih_Plans;saut:=0;
              b_c:=NbBuffersImage+1;repeat dec(b_c) until Image.Pixels[b_c].Taille>0;
              t_c:=Image.Pixels[b_c].Taille;Paquet:=(((ih_Largeur+7) div 8)+1)*ih_Plans;
              if t_c>=Paquet then
                begin
                  sdi:=Ofs((Image.Pixels[b_c].Pointeur)^)+t_c-Paquet;
                  ses:=Seg((Image.Pixels[b_c].Pointeur)^)
                end
              else
                begin
                  dec(b_c);
                  sdi:=Ofs((Image.Pixels[b_c].Pointeur)^)
                  +Image.Pixels[b_c].Taille-(Paquet-t_c);
                  ses:=Seg((Image.Pixels[b_c].Pointeur)^)
                end;
              repeat
                BlockRead(l_Fichier,BlocPCX,Longueur_Tampon,c);
                if c>0 then PCX2BMX(Image.Pixels,BlocPCX,
                                    c,ses,sdi,
                                    x_c,y_c,p_c,b_c,saut,
                                    (ih_Largeur+7) div 8,ih_Hauteur,ih_Plans)
              until c<=0
            end
          else Load_Image:=101;
        end;
      im_BMP:
        begin
          reset(l_fichier,1);
          blockread(l_Fichier,EnTeteBM,SizeOf(EnTeteBM));
          with Image.En_tete do with EnTeteBM do
            begin
              ih_Hauteur:=word(biHeight);ih_Largeur:=word(biWidth);
              ih_Plans:=byte(biBitCount);ih_Nature:=im_BMP;
              ih_Palette.pa_Etendue:=byte((word(1) shl (ih_Plans))-1);
              if ih_Plans=1 then ih_Palette.pa_Etendue:=2;
              TailleOff:=word(bfOffBits);
              for i:=0 to ih_Palette.pa_Etendue do
                begin
                  ih_Palette.pa_Couleurs[i].Red:=biPalette[i].Red;
                  ih_Palette.pa_Couleurs[i].Green:=biPalette[i].Green;
                  ih_Palette.pa_Couleurs[i].Blue:=biPalette[i].Blue;
                end;
              j:=longint(ih_Hauteur*ih_Plans);
            end;
          Actuel:=S.Size-longint(TailleOff)+j;
          i:=0;
          if MaxAvail>Actuel then with Image.En_Tete do
            begin
              reset(l_Fichier,1);blockRead(l_Fichier,EnTeteBM,TailleOff);
              repeat
                tailleint:=actuel;
                if tailleint>Maxword then tailleint:=Maxword;
                Actuel:=Actuel-Tailleint;
                with Image.Pixels[i] do
                  begin
                    Taille:=word(TailleInt);GetMem(Pointeur,Taille);
                    blockread(l_fichier,ptr(Seg(Pointeur^),
                                            Ofs(Pointeur^)+j)^,Taille-j);
                  end;
                inc(i);j:=0
              until (Actuel<=0) or (i>NbBuffersImage);
              BMP2BMX(Image.Pixels,Tampon,ih_Largeur,ih_Hauteur,ih_Plans);
            end else Load_Image:=101
        end
    else Load_Image:=103
    end;
    close(l_fichier);
  end;
FileMode:=OldFileMode;
end;

function Save_Image(g_nom_fichier:pathstr;var Image:TImage):integer;
var
Fichier:file;
i,Res:integer;
begin
assign(Fichier,g_nom_fichier);
{$I-} rewrite(Fichier,1) {$I+};
Res:=IOResult;
if Res=0 then with Image do
  begin
    {$I-}
    Image.En_Tete.ih_Nature:=170;
    blockWrite(Fichier,En_Tete,SizeOf(En_Tete));
    for i:=0 to NbBuffersImage do
      if Pixels[i].Taille<>0 then blockWrite(Fichier,(Pixels[i].Pointeur)^,Pixels[i].Taille);
    {$I+} Res:=IOResult;
   close(Fichier);
  end;
Save_Image:=IOResult
end;

procedure Const_Graphique_Mode(mode:byte;var Largeur,Hauteur:word;var Plans:byte);
begin
Largeur:=0;Hauteur:=0;Plans:=0;
case mode of
  mg_EGAb:begin Largeur:=320;Hauteur:=200;Plans:=4 end;
  mg_VGAm:begin Largeur:=640;Hauteur:=200;Plans:=4 end;
  mg_EGAm:begin Largeur:=640;Hauteur:=350;Plans:=1 end;
  mg_EGAh:begin Largeur:=640;Hauteur:=350;Plans:=4 end;
  mg_VGA16:begin Largeur:=640;Hauteur:=480;Plans:=4 end;
  mg_VGA2:begin Largeur:=320;Hauteur:=480;Plans:=1 end;
  mg_VGA256:begin Largeur:=320;Hauteur:=200;Plans:=8 end;
  end
end;

function Size_Image(Image:TImage):longint;
var
i:integer;
l:longint;
begin
l:=0;
for i:=0 to NbBuffersImage do l:=l+longint(Image.Pixels[i].Taille);
Size_Image:=l
end;

procedure Get_Palette(var Palette:TPalette);
begin
(*Palette:=Palette_VGA_Standard*)
end;

procedure Recup_Image(var g_Buffer:TAImage;
                      a_x,a_y,d_x,d_y:word;MaxiPlans:byte;
                      TailleLigne:word);assembler;
var
MaxiEcran,SaveSi,Savedi,Taille:word;
MaskF,MaskG,OfsG,OfsD,OctetsaCopier,
DernierPlan,OBloc,OctetInutile:byte;

asm
      push      ds
      push      es
      jmp       @deb

@Bloc:
      push      ax
      push      bx                    {cration nouveau bloc image}
      push      cx
      push      dx
      push      si
      push      ds
      lds       si,g_buffer
      mov       ax,6
      mov       bl,OBloc
      mov       bh,0
      mul       bx
      add       si,ax
      lodsw
      mov       bx,ax
      lodsw
      mov       cx,ax
      lodsw
      mov       word Ptr Taille,ax
      mov       ax,cx
      mov       es,ax
      mov       di,bx
      inc       OBloc
      pop       ds
      pop       si
      pop       dx
      pop       cx
      pop       bx
      pop       ax
      retn

@deb: mov       ax,$a000       {prparatif mmoire cran}
      mov       ds,ax
      mov       ax,a_x
      mov       cl,3
      shr       ax,cl
      mov       si,ax
      mov       ax,TailleLigne
      mul       a_y
      add       si,ax
      mov       ax,d_y
      mul       TailleLigne
      add       si,ax
      mov       Savesi,si

      mov       ax,d_x
      mov       bl,8
      div       bl
      cmp       ah,0
      je        @D1
      inc       al
@D1:  mov       OctetsaCopier,al

      mov       ax,a_x
      mov       bl,8
      div       bl
      mov       OfsG,ah
      mov       al,8
      sub       al,ah
      and       al,$7
      mov       OfsD,al

      mov       bl,$ff
@D12: cmp       ah,0
      je        @D11
      shr       bl,1
      dec       ah
      jmp       @D12
@D11: mov       MaskG,bl

      mov       ax,a_x
      add       ax,d_x
      mov       bl,8
      div       bl
      mov       bl,0
@D14: cmp       ah,0
      je        @D13
      stc
      rcr       bl,1
      dec       ah
      jmp       @D14
@D13: mov       MaskF,bl
      cmp       bl,0
      je        @D15
      dec       OctetsaCopier

@D15: mov       OBloc,0
      call      near Ptr @Bloc
      mov       dx,d_y

@UneLigne:
      mov       al,MaxiPlans
      mov       byte Ptr DernierPlan,al

@LignePlan:                                     {changement de plan}
      push      dx
      mov       al,4
      mov       dx,$3ce
      out       dx,al
      inc       dx
      mov       al,MaxiPlans
      sub       al,byte Ptr DernierPlan
      out       dx,al
      pop       dx
      mov       si,SaveSi
      mov       al,0
      cmp       OfsG,0
      je        @L1
      lodsb
      and       al,MaskG
@L1:  stosb
      dec       Taille
      jnz       @L2
      call      near Ptr @Bloc
@L2:  mov       cl,byte Ptr OctetsaCopier
      mov       ch,0
      cmp       word Ptr Taille,cx
      jb        @CopieLong
@Copie:
      sub       word Ptr Taille,cx
      rep       movsb
      cmp       word Ptr Taille,0
      jne       @C1
      call      near Ptr @Bloc
@C1:  jmp       @FinC

@CopieLong:
      lodsb
      stosb
      dec       word Ptr Taille
      jnz       @11
      call      near Ptr @Bloc
@11:  dec       cx
      jnz       @CopieLong

@FinC:
      cmp       MaskF,0
      je        @F1
      lodsb
      and       al,MaskF
      stosb
      dec       word Ptr Taille
      jnz       @F1
      call      near Ptr @Bloc

@F1:  dec       DernierPlan
      jnz       @LignePlan
      mov       si,SaveSi
      mov       ax,TailleLigne
      sub       SaveSi,ax
      dec       dx
      jnz       @UneLigne

      clc                      {remise en place de tout le monde}
      mov       bl,OfsD
      cmp       bl,0
      je        @Final
@D80: mov       OBloc,0
@D50: call      near Ptr @Bloc
      cmp       Taille,0
      je        @D70
      mov       cx,Taille
@D60: mov       al,es:[di]
      rcr       al,1
      mov       es:[di],al
      inc       di
      loop      @D60
      jmp       @D50
@D70: dec       bl
      jnz       @D80

@Final:
      pop       es
      pop       ds

end;

function Get_Image_Screen(var Image:TImage;Palette:TPalette;a_x,a_y,d_x,d_y:word):integer;
var
Largeur,Hauteur,i,cMax:word;
TailleInt,Actuel:longint;
ModeV,Plans:byte;
begin
ModeV:=Get_Mode_Graphique;
Const_Graphique_Mode(modeV,Largeur,Hauteur,Plans);
if (modeV<mg_EGAb) or (modeV>mg_VGA256) then
  begin Get_Image_Screen:=103;exit end;
cMax:=Largeur;Largeur:=Largeur div 8;
if (d_x<0) or (d_y<0) or (a_x<0) or (a_y<0) or (a_x>=cMax) or (a_y>=Hauteur) then
  begin Get_Image_Screen:=102;exit end;
if a_x+d_x>cMax then d_x:=cMax-a_x;
if a_y+d_y>Hauteur then d_y:=Hauteur-a_y;
with Image.En_Tete do
  begin
    ih_Largeur:=d_x;ih_Hauteur:=d_y;
    ih_Nature:=im_BMX;ih_Plans:=Plans;
    ih_Palette:=Palette
  end;
cMax:=(d_x div 8);if (d_x mod 8)<>0 then inc(cMax);inc(cMax);
Actuel:=longint(cMax)*longint(Image.En_Tete.ih_Plans)*longint(d_y);
for i:=0 to NbBuffersImage do
  with Image.Pixels[i] do begin Pointeur:=nil;Taille:=0 end;
if Actuel>MaxAvail then begin Get_Image_Screen:=101;exit end;
i:=0;
repeat
  tailleint:=Actuel;
  if tailleint>Maxword then tailleint:=Maxword;
  Actuel:=Actuel-Tailleint;
  with Image.Pixels[i] do
    begin
      GetMem(Pointeur,tailleint);Taille:=Tailleint;
    end;
  inc(i)
until (Actuel<=0) or (i>NbBuffersImage);
Recup_Image(Image.Pixels,a_x,a_y,d_x,d_y,Image.En_Tete.ih_Plans,Largeur);
Get_Image_Screen:=0
end;

procedure Extrait_Image(var Source,But:TAImage;
                            BlocS,Depart,a_x,a_y,d_x,d_y,Largeur,Hauteur,Plans:word);assembler;
var
Taille,y,p,Paquet,SiMax,DiMax,OBlocS,OBlocB,ACopier:word;
Decal:byte;
asm
      push      ds
      push      es
      jmp       @deb

@BlocS:
      push      ax
      push      bx
      push      cx
      push      dx
      lds       si,Source
      mov       ax,6
      mov       bx,OBlocS
      mul       bx
      add       si,ax
      lodsw
      mov       bx,ax
      lodsw
      mov       cx,ax
      lodsw
      mov       dx,ax
      mov       ax,cx
      mov       ds,ax
      mov       si,bx
      add       bx,dx
      mov       SiMax,bx
      inc       OBlocS
      pop       dx
      pop       cx
      pop       bx
      pop       ax
      retn

@BlocB:
      push      ax
      push      bx
      push      cx
      push      dx
      push      si
      push      ds
      lds       si,But
      mov       ax,6
      mov       bx,OBlocB
      mul       bx
      add       si,ax
      lodsw
      mov       bx,ax
      lodsw
      mov       cx,ax
      lodsw
      mov       dx,ax
      mov       ax,cx
      mov       es,ax
      mov       di,bx
      add       bx,dx
      mov       DiMax,bx
      mov       Taille,dx
      inc       OBlocB
      pop       ds
      pop       si
      pop       dx
      pop       cx
      pop       bx
      pop       ax
      retn

@deb:
      mov       ax,BlocS
      mov       OBlocS,ax
      mov       OBlocB,0
      call      near ptr @BlocS
      call      near ptr @BlocB
      add       si,depart
      mov       ax,d_x
      mov       bl,8
      div       bl
      cmp       ah,0
      je        @d1
      inc       al
@d1:  mov       ah,0
      mov       ACopier,ax

      mov       ax,a_x
      and       ax,7
      mov       byte ptr Decal,al

      mov       ax,Largeur
      add       ax,7
      div       bl
      inc       al
      mov       ah,0
      mov       Paquet,ax

      mov       y,0
      mov       p,0

@Boucle:
      push      SiMax
      push      OBlocS
      push      ds
      push      si
      cmp       Decal,0
      jne       @b1
      mov       al,0
      jmp       @b3
@b1:  lodsb
      cmp       si,siMax
      jne       @b3
      call      @BlocS
@b3:  stosb
      cmp       di,diMax
      jne       @b2
      call      @BlocB
@b2:  mov       cx,ACopier
@l:   lodsb
      cmp       si,siMax
      jne       @b4
      call      @BlocS
@b4:  stosb
      cmp       di,diMax
      jne       @b5
      call      @BlocB
@b5:  loop      @l
      pop       si
      pop       ds
      pop       OBlocS
      pop       siMax
      mov       bx,si
      add       bx,Paquet
      cmp       bx,Simax
      jb        @b6
      mov       bx,SiMax
      sub       bx,si
      call      near ptr @blocS
      sub       si,bx
@b6:  add       si,Paquet
      inc       p
      mov       ax,Plans
      cmp       p,ax
      jne       @Boucle
      mov       p,0
      inc       y
      mov       ax,d_y
      cmp       y,ax
      jne       @Boucle

      cmp       byte ptr Decal,0
      je        @Sortie
      mov       bl,8
      sub       bl,byte ptr Decal
@D80: mov       OBlocB,0
@D50: call      near Ptr @BlocB
      cmp       Taille,0
      je        @D70
      mov       cx,Taille
@D60: mov       al,es:[di]
      rcr       al,1
      mov       es:[di],al
      inc       di
      loop      @D60
      jmp       @D50
@D70: dec       bl
      jnz       @D80



@Sortie:
      pop       es
      pop       ds
end;


function Extract_Image(var ISource,IBut:TImage;a_x,a_y,d_x,d_y:word):integer;
var
Bloc,Depart,i,c:word;
Cumul,CumulP,Posit,TailleInt,Actuel:longint;
begin
Extract_Image:=0;
with ISource.En_Tete do
  begin
    if a_x+d_x>ih_Largeur then d_x:=ih_Largeur-a_x;
    if a_y+d_y>ih_Hauteur then d_y:=ih_Hauteur-a_y;
    IBut.En_tete.ih_Nature:=im_BMX;
    IBut.En_Tete.ih_Largeur:=d_x;
    IBut.En_Tete.ih_Hauteur:=d_y;
    IBut.En_Tete.ih_Plans:=ih_Plans;
    IBut.En_Tete.ih_Palette:=ih_Palette;
    for i:=0 to NbBuffersImage do
    with IBut.Pixels[i] do begin Pointeur:=nil;Taille:=0 end;
    c:=((d_x+7) div 8)+1;
    Actuel:=longint(c)*longint(ih_Plans)*longint(d_y);
    if Actuel>MaxAvail then begin Extract_Image:=101;exit end;
    Posit:=longint(ih_Plans)*longint(((ih_Largeur+7) div 8)+1)
                            *longint(ih_Hauteur-(a_y+d_y))
                            +longint((a_x div 8)+1);
    i:=0;Cumul:=0;
    repeat
      if Posit>=Cumul then begin Bloc:=i;CumulP:=Cumul end;
      Cumul:=Cumul+longint(ISource.Pixels[i].Taille);
      inc(i)
    until i>NbBuffersImage;
    depart:=word(Posit-CumulP);
    i:=0;
    repeat
      tailleint:=Actuel;
      if tailleint>Maxword then tailleint:=Maxword;
      Actuel:=Actuel-Tailleint;
      with IBut.Pixels[i] do
        begin
          GetMem(Pointeur,tailleint);Taille:=Tailleint;
        end;
      inc(i)
    until (Actuel<=0) or (i>NbBuffersImage);
    Extrait_Image(ISource.Pixels,IBut.Pixels,Bloc,depart,a_x,a_y,d_x,d_y,
                                          ih_Largeur,ih_Hauteur,ih_Plans)
  end;
end;

function Get_Mode_Graphique:byte;
var
reg : registers;
old_mode,res : integer;

function ega_installe : boolean;
var
res : integer;
begin
reg.AX:=$1200;
reg.BX:=$0010;
reg.CX:=$ffff;
intr($10,reg);
ega_installe:=(reg.CX<>$ffff);
end;

function vga_installe : boolean;
var
res1,res2 : byte;
begin
reg.AX := $1a00;
intr( $10,reg );
res1:=reg.AL;res2:=reg.BL;
if res1<>$1a then vga_installe:= false
else vga_installe:=((res2=7) or (res2=8)  or (res2=$0b) or (res2=$0c));
end;

begin {detect_Image_mode}
res:=0;
reg.AH:=$0f;
intr($10,reg);
old_mode:=reg.AL;
if (old_mode<>7) then
  if ega_installe then
    if vga_installe then res:=mg_VGA16
    else res:=mg_EGAb
  else res:=mg_CGA4
else res:=mg_Herc;
Get_Mode_Graphique:=res;
end;


procedure Remplit_Ecran_BM(var g_Buffer:TAImage;
                           Largeur,Hauteur,MaxiPlans,TailleLigne:word;
                           a_x,a_y:word);assembler;

var
MaxiEcran,SaveSi,Savedi,Taille:word;
MaskF,MaskG,OfsG,OfsD,OctetsaLire,OctetsaCopier,
PlanCourant,DernierPlan,OBloc,OctetInutile:byte;

asm
      push      ds
      push      es
      jmp       @deb

@BlocI:
      push      ax
      push      bx                    {cration nouveau bloc image}
      push      cx
      push      dx
      lds       si,g_buffer
      mov       ax,6
      mov       bl,OBloc
      mov       bh,0
      mul       bx
      add       si,ax
      lodsw
      mov       bx,ax
      lodsw
      mov       cx,ax
      lodsw
      mov       word Ptr Taille,ax
      mov       ax,cx
      mov       ds,ax
      mov       si,bx
      pop       dx
      pop       cx
      pop       bx
      pop       ax
      retn

@Bloc:
      call      near Ptr @BlocI
      inc       OBloc
      retn

@deb: mov       ax,$a000       {prparatif mmoire cran}
      mov       es,ax
      mov       ax,a_x
      mov       cl,3
      shr       ax,cl
      mov       di,ax
      mov       ax,TailleLigne
      mul       a_y
      add       di,ax
      mov       ax,Hauteur
      mul       TailleLigne
      add       di,ax
      mov       Savedi,di

      mov       ax,TailleLigne
      shl       ax,1
      shl       ax,1
      shl       ax,1
      mov       MaxiEcran,ax
      mov       ax,a_x        {calcul de OfsG et OfsD}
      mov       bl,8
      div       bl
      mov       OfsG,ah
      mov       al,8
      sub       al,ah
      and       al,$07
      mov       OfsD,al

      mov       bl,0          {calcul de MaskG}
@D30: cmp       ah,0
      je        @D40
      stc
      rcr       bl,1
      dec       ah
      jmp       @D30
@D40: mov       MaskG,bl

      mov       ax,Largeur    {nombre d'octets par ligne dans l'image source}
      mov       bl,8
      div       bl
      cmp       ah,0
      je        @D41
      inc       al
@D41: mov       byte Ptr OctetsaLire,al

      mov       ax,Largeur
      add       ax,a_x
      cmp       ax,MaxiEcran
      jbe       @43
      mov       ax,MaxiEcran
@43:  mov       cx,ax

      mov       ax,cx    {calcul de MaskF}
      mov       bl,8
      div       bl
      mov       bl,$00
@D3:  cmp       ah,0
      je        @D4
      stc
      rcr       bl,1
      dec       ah
      jmp       @D3
@D4:  mov       MaskF,bl

      mov       ax,cx
      sub       ax,a_x     {nombre d'octets par ligne dans l'image cran}
      mov       bl,OfsD
      mov       bh,0
      sub       ax,bx
      mov       bl,8
      div       bl
@D42: mov       byte Ptr OctetsaCopier,al

      mov       al,OctetsaLire
      sub       al,OctetsaCopier
      cmp       MaskF,0
      je        @D43
      dec       al
@D43: mov       OctetInutile,al

@D44: cmp       OfsD,0
      je        @PreLigne

      clc
      mov       bl,OfsD               {dcalage  gauche de tout le monde}
@D8:  mov       OBloc,NbBuffersImage
      dec       OBloc
@D5:  call      near Ptr @BlocI
      dec       OBloc
      cmp       Taille,0
      je        @D5
      mov       cx,Taille
      dec       Taille
      add       si,Taille
@D6:  mov       al,ds:[si]
      rcl       al,1
      mov       ds:[si],al
      dec       si
      loop      @D6
      cmp       OBloc,$ff
      jne       @D5
@D7:  dec       bl
      jnz       @D8

@PreLigne:
      cld
      mov       OBloc,0
      call      near ptr @Bloc
      mov       dx,Hauteur

@Ligne:                                      {affichage ligne}
      mov       ax,MaxiPlans
      mov       byte Ptr DernierPlan,al
      mov       byte ptr PlanCourant,1

@LignePlan:                                     {changement de plan}
      mov       SaveSi,si
      lodsb                              {dbut ligne plan}
      dec       word Ptr Taille
      jnz       @LP1
      call      near Ptr @Bloc
@LP1: mov       di,Savedi
      cmp       OfsG,0
      je        @L1

      mov       bl,MaskG       {si mise  jour colonne gauche}
      not       bl
      and       al,bl
      mov       cl,al
      push      dx
      mov       al,4
      mov       dx,$3ce
      out       dx,al
      inc       dx
      mov       ax,MaxiPlans
      sub       al,byte Ptr DernierPlan
      out       dx,al
      mov       ch,es:[di]
      not       bl
      and       ch,bl
      or        cl,ch
      mov       al,2
      mov       dx,$3c4
      out       dx,al
      inc       dx
      mov       al,byte ptr planCourant
      out       dx,al
      pop       dx
      mov       al,cl
      stosb
      jmp       @L2
@L1:
      push      dx              {copie des octets normaux}
      mov       al,2
      mov       dx,$3c4
      out       dx,al
      inc       dx
      mov       al,byte ptr planCourant
      out       dx,al
      pop       dx
@L2:  mov       cl,byte Ptr OctetsaCopier
      mov       ch,0
      cmp       word Ptr Taille,cx
      jb        @CopieLong
@Copie:
      sub       word Ptr Taille,cx
      rep       movsb
      cmp       word Ptr Taille,0
      jne       @C1
      call      near Ptr @Bloc
@C1:  jmp       @FinC

@CopieLong:
      lodsb
      stosb
      dec       word Ptr Taille
      jnz       @11
      call      near Ptr @Bloc
@11:  dec       cx
      jnz       @CopieLong

@FinC:
      cmp       MaskF,0   {si mise  jour colonne droite}
      je        @F1
      lodsb
      dec       word Ptr Taille
      jnz       @F2
      call      near Ptr @Bloc
@F2:  mov       bl,MaskF
      and       al,bl
      mov       cl,al
      push      dx
      mov       al,4
      mov       dx,$3ce
      out       dx,al
      inc       dx
      mov       ax,MaxiPlans
      sub       al,byte Ptr DernierPlan
      out       dx,al
      mov       ch,es:[di]
      not       bl
      and       ch,bl
      or        cl,ch
      mov       al,2
      mov       dx,$3c4
      out       dx,al
      inc       dx
      mov       al,byte ptr planCourant
      out       dx,al
      pop       dx
      mov       al,cl
      stosb

@F1:  mov       cl,OctetInutile
@F12: cmp       cl,0
      je        @F10
      lodsb
      dec       word Ptr Taille
      jnz       @F11
      call      near Ptr @Bloc
@F11: dec       cl
      jnz       @F12

@F10: mov       al,byte ptr PlanCourant
      shl       al,1
      mov       byte Ptr PlanCourant,al
      dec       byte ptr DernierPlan
      jnz       @LignePlan                      {si encore un plan }
      mov       di,Savedi
      sub       di,TailleLigne
      mov       Savedi,di
      dec       dx
      jnz       @Ligne                     {si plus d'images}
@Fin:
      cmp       OfsD,0
      je        @Final

      clc                      {remise en place de tout le monde}
      mov       bl,OfsD
@D80: mov       OBloc,0
@D50: call      near Ptr @Bloc
      cmp       Taille,0
      je        @D70
      mov       cx,Taille
@D60: mov       al,ds:[si]
      rcr       al,1
      mov       ds:[si],al
      inc       si
      loop      @D60
      jmp       @D50
@D70: dec       bl
      jnz       @D80

@Final:
      pop       es
      pop       ds
end;


procedure Set_VGA_Palette(var Palette:TPalette);assembler;
var
fl:byte;
asm

      push      ds
      push      es
      lds       si,Palette
      lodsb
      mov       ah,0
      mov       cx,ax
      inc       cx
      mov       fl,0
      push      cx
      push      si
      mov       ax,cx
      mov       bl,3
      mul       bl
      mov       cx,ax
      mov       al,0
      rep       stosb
      pop       si
      pop       cx
@b4:  mov       ah,$10
      mov       al,$12
      mov       ax,ds
      mov       es,ax
      mov       dx,si
      mov       bx,0
      int       $10
      pop       es
      pop       ds
end;

procedure Set_EGA_Palette(i,rouge,vert,bleu:byte);

procedure Set_Couleur(clogique,cphysique : byte);
var
registre:Registers;
begin
registre.ah:=$10;
registre.al:=0;
registre.bh:=cphysique;
registre.bl:=clogique;
intr($10,registre);
end;

var
cphysique : byte;
begin                  (*Set_EGA_Palette*)
cphysique:= ((bleu shr 7) and 1) or ((bleu shr 3) and 8) ;
cphysique:= cphysique or (((vert shr 6) and 2) or ((vert shr 2) and 16));
cphysique:= cphysique or (((rouge shr 5) and 4) or ((rouge shr 1) and 32));
Set_Couleur(i,cphysique);
end;

procedure Display_Image(g_mode:byte;Image:TImage;a_x,a_y:word);
var
Largeur,Hauteur:word;
i,Plans:byte;
begin
Const_Graphique_Mode(g_mode,Largeur,Hauteur,Plans);
if (0<=a_x) and (a_x<Largeur) and (0<=a_y) and (a_y<Hauteur) then
with Image.En_Tete do
  begin
    Largeur:=Largeur div 8;
    for i:=0 to ih_Palette.pa_Etendue do
    Set_EGA_palette(i,ih_Palette.pa_Couleurs[i].Red,ih_Palette.pa_Couleurs[i].Green,
                                             ih_Palette.pa_Couleurs[i].Blue);
    Remplit_Ecran_BM(Image.Pixels,ih_Largeur,ih_Hauteur,ih_Plans,Largeur,a_x,a_y);
  end
end;

procedure Set_Mode_Graphique(n:byte);
var
registre:Registers;
begin
registre.AH:=0;
registre.AL:=n;
intr($10,registre);
end;

END.
