PROGRAM MENU;

{---------------------------------------------------------------------------}
{  Logiciel GEOCEAN -  INTERFACE UTILISATEUR                                }
{  programme principal du  logiciel MENUS       version 1.x du  06/04/96    }
{                                                                           }
{---------------------------------------------------------------------------}
{---------------------------------------------------------------------------}
{  Institut National de Recherche Pdagogique : DP 4, N. SALAME  -  PARIS   }
{                          Equipe INRP  TOULOUSE                            }
{  S. DUPOUY, C. GROS, R. CULOS, F. BOULANGER, J. TONNELAT, J. Y. GUCHEREAU }
{ Ralisation :                                                             }
{  A R X - Alain, Roger et Xavier CULOS - 6 avenue de Lagarde 31130 BALMA   }
{---------------------------------------------------------------------------}

{---------------------------------------------------------------------------}
{ fichiers spciaux associs  ce programme dans le rpertoire MNU          }
{    MENU    .ICN            images, icnes                                 }
{    MENU    .PAL            palette     (isolation possible dans rep BGI)  }
{    MENU    .TXT            prsentation du module                         }
{    MENU    .AID            texte d'aide                                   }
{    *       .MNU            paramtres du menu en cours                    }
{    UTILISAT.EUR            temporaire : tat des variables en cours (TEMP)}
{---------------------------------------------------------------------------}
{ fichiers spciaux associs  ce programme dans le rpertoire PRG          }
{    modules .TXT            prsentation de chaque module                  }
{---------------------------------------------------------------------------}
{ fichiers spciaux associs  ce programme dans le rpertoire DNN\rgion   }
{    rgions .TXT            prsentation gologique de chaque rgion       }
{---------------------------------------------------------------------------}

   {$M 48000,0,655360}

USES
   Protect,                  { FB      - protection}
   Periphs,                  { ARX     - priphriques, impression, palettes}
   CSI,                      { ARX     - gestion Clavier, Souris et Icnes  }
   MENUS,                    { ARX     - interface  menus droulants        }

   MENU_VAR,                 { MNU     - variables globales du module       }
   MENU_FIC,                 { MNU     - Initialisations fichiers           }
   MENU_MNU,                 { MNU     - initialisations                    }
   MENU_INS;                 { CONF    - procdures propres                 }
{---------------------------------------------------------------------------}

procedure CasMenus;
   var
      Choix             : integer;

   begin
      if changemenus then exit;
      menus.menu (a, b, codeclavier);        { MENU2 }
                               { acquisition d'un choix valide dans un menu }

      if FF1 (codeclavier)                   { CSI }
      then begin               { appui sur la touche F1 dans un sous-menu   }
         case a of
            1 : Aide (a, b);                         { MENU_INI }
            2 : Aide_region (b-1);
            3 : Aide_module (b-1);
            4 : Aide (6, b);
         end;
      end else begin
         if b > 1
         then
            Choix := 100*a+b;
         case choix of         { validation d'une option dans un sous-menu  }
          { menu FICHIERS }
            102  : Voir_Catalogue_Trv;                    { menus 5 }
            103  : Editinfo;
            104  : Copier;
            105  : Nettoyer;
            106  : Transferer;
            107  : Mode_exemples;
            108  : Change_connexion;
            109  : Mode_echanges;
            110  : Menu_fic.Quitter  (false);             {    }
            112  : Palettes (nommenu);

          { menu REGION }
            202..212 :
               begin
                  zi := b-1+der_icn;             { quiv zone cran }
                  Choix_region   (b-1);
                  if not exempl
                  then
                     Creer_repert_region;
               end;

          { menu ACTIVITES }
            302..312 :
               begin
                  zi := b-1+3+ of7ico [b-1];              { quiv zone cran }
                  Choix_activite  (b-1);
                  Lancer;         { enchaner aprs confirmation }
               end;

          { menu AIDES }
            402  : Aide_Menus_b;                        { ini }
            403  : Aide (6, b);
            404  : Aide_geoc;
            405  : Aide_mnu;
            406  : Infos_systeme;
            408  : A_propos;
            409  : Ref_image;
         end;
      end;
   end;

procedure CasIcones;
   begin
      if changemenus then exit;
      if affichetexte            { appui sur F1 au niveau d'une icne       }
      then
         case zi of                                { CSI }
             2     : A_propos2;                         { }
             4..14 : Aide_module (zi - 3 - of7ico [zi-3]);
            15..25 : Aide_region (zi - der_icn);
         end
      else begin
         case zi of                                { CSI }
          { icne INRP     }
             2     : Aide_geoc;

          { icne ACTIVITE }
             4..14 :
               begin
                  Choix_activite (zi - 3 - of7ico [zi-3]);
                  Lancer;
               end;
          { icne REGION }
            15..25 :
               begin
                  Choix_region   (zi - der_icn);
                  if not exempl
                  then
                     Creer_repert_region;
               end;
         end;
      end;
   end;


BEGIN                { programme principal }

   iniparam ;                 { initialisation des paramtres par dfaut    }
   inimenus ;                 { initialisation de l'interface menus         }
   inifondecran;              {                                             }
   UtilisateurAutorise(false);
   iniparam2;                 { initialisation des paramtres par dfaut    }
   lire_menus ;               { initialise les tableaux MENUS               }

   inimenus_menu;             { initialise les options du menu              }

   rech_precedents;           { recherche l'tat session prcdente         }
   iniicones;                 { initialisation des icnes                   }
   iniecran;                  { initialisation de l'cran/MENU              }

   complete_install_auto (ok);
   identifier_util;           { comparer util et liste --Groupe ou individu }
   choix_reg_act;             { initialiser rgion et activit              }
   iniaide;                   { initialisation de l'aide en ligne           }
                              {      lecture de   fic.AID                   }

   repeat
      modif_menus;            { modifications fonction des paramtres PAR   }
      aff_l_aide;
      case ZoneDuClick (maxc1, maxc2, maxc3, maxc4) of
         1 : CasMenus  ;
         2 : CasIcones ;
     {    else  aide (6, 3);}
      end;
      if changemenus
      then
         inversemenus;
   until fini;
   fin;                                                          { MENU_INI }

END.               { programme principal }


{--- GEOCEAN - MENU -------------------------- R.C.- INRP - TOULOUSE - 1995 }
