UNIT MENU_INS;

   {------------------------------------------------------------------------}
   { logiciel GEOCEAN - module CONF                                         }
   {                                                                        }
   {                          Configuration                                 }
   {                                                       10/10/94         }
   {------------------------------------------------------------------------}

INTERFACE

{$O+,F+}

USES
   dos, crt, graph,          { TP 70   - units standard Borland            }
   Souris,                   { ARX     - gestion de la  souris              }
   Clavier,                  { ARX     - gestion du clavier                 }
   Messarx,                  { ARX     - Textes des Messages de Base        }
   Graphism,                 { ARX     - initialisations graphiques         }
   Graphplt,                 { ARX     - graphisme 2D cran/traceur         }
   Lipar,                    { ARX     - gestion fichiers paramtres        }
   Edition,                  { ARX     - saisie/dition paramtres          }
   Utildivs,                 { ARX     - utilitaires divers                 }
   Utiledi,                  { ARX     - utilitaires dition                }
   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   DirInfo,                  { ARX     - Gestion des fichiers ressources    }
   Icones,                   { ARX     - gestion de icnes                  }
   Menus,                    { ARX     - interface menus                    }
   Periphs,                  { ARX     - priphriques, impression, palettes}

   MENU_FIC,                 { MENU    - Initialisations fichiers           }
   MENU_VAR;                 { MENU    - variables globales du module       }

CONST
   {$I Croix.cur}
   {$I Main.cur}

   {------------------------------------------------------------------------}

Procedure Autoriser;
   { Contle les options du menu Fichier                                    }

Procedure Gerer_Utilisateurs;
   { Gre les pseudonymes de "connexion"  de la liste GROUPES               }
   { ajout / suppression d'un pseudo dans un groupe existant                }

   { Le NOM reconnu sert  placer l'utilisateur dans un rpertoire de
     travail.                                                               }
   { On ne peut associer aucun pseudo au groupe PUBLIC qui hberge les
     utilisateurs inconnus du systme                                       }
   { Fonction inactive si ce groupe seul existe.                            }

Procedure Gerer_Groupes;
   { Gre les noms des groupes : espaces collectifs pour les fichiers de
     travail }
   { ajout/suppression d'un groupe }
   { le rpertoire n'est pas cre, ni supprim, ni nettoy }

   { il est impossible de supprimer PUBLIC }

Procedure Nettoyer_travail;
   { Efface les fichiers des utilisateurs  }

Procedure Teste_rep_perso       (var ok : boolean);
   { Vrifie l'existence de la variable d'environnement "USERNAME"
     et l'existence du rpert perso  }

Procedure Teste_groupes         (var ok : boolean);
   { Complte silencieusement les rpertoires des groupes }

Procedure Complete_install_auto (var ok : boolean);
   { Complte silencieusement }

Procedure Completer_inst        (var ok : boolean);
   { Complte la premire installation }

Procedure Ouvrir_Config_geocean;
   { Lit les infos d'un fichier CFG dans geoc_prg }

Procedure Enr_config_geocean;
   { Ecrit les infos du fichier CFG dans geoc_prg}

Procedure Enr_sous_config_geocean;
   { Ecrit les infos sur un nouveau fichier CFG dans geoc_prg}

Procedure Options_Periphs;
   { Choix Imprimante et traceur }

Procedure Preferences;
   { Choix
        option Rapide, Raffichages immdiats,
        surfaces lisses,
        limites monochromes (nuages) }

{Procedure Nouveau_menu;}
   { }

Procedure Ouvrir_menu ;
   { Lit infos autre .MNU }

Procedure Enregistrer_menu;
   { Ecrit infos menu en cours }

Procedure Enregistrer_menu_sous;
   { Ecrit infos nouveau fichier .MNU }

(*Procedure ajouter_region;                        { au menu }
   { Insre une ligne au menu rgion et une icne }

Procedure modifier_region;
   { Modifie les textes lis au menu et  l'icne, modifie l'icne (cadre)
     Supprime ventuellement l'entre au menu sans effacer les fichiers     }

Procedure effacer_region ;
   { Supprime les fichiers d'un rpertoire de donnes }

Procedure ajouter_module;
   { INsre une ligne au menu activit et active l'icne du module }

Procedure modifier_module;
   { Modifie les textes lis au menu et  l'icne,
     Supprime ventuellement l'entre au menu sans effacer les fichiers     }

Procedure effacer_module;
   { Supprime les fichiers modu*.* }
*)

Procedure Mod_Menu_Region;
Procedure Mod_Menu_Activ;
   { Cre ou met  jour automatiquement le menu  aprs installation         }

{Procedure modifier_menu_donnees (l_r : lst_chn);
Procedure modifier_menu_modules;}
   { met  jour les listes DNN et PRG  lors de l'installation               }

Procedure Parametres_Menu;
Procedure Parametres_Cfg;
   { Affiche les paramtres dans une bote  dfilement                     }
   {                              ou sur une imprimante texte quelconque    }

Procedure Quitter (f : boolean);
   { Retour au DOS                                                          }

{---------------------------------------------------------------------------}

IMPLEMENTATION

VAR
   li
                        : integer;

   nom_r,
   nom_p                : chaine;

   aide_r,
   aide_p               : Longchaine;

   rep_r,
   fic_p                : Namestr;

   extini               : Extstr;

   interdits,
   xst, yst,
   lst, hst
                        : t12;

   {------------------------------------------------------------------------}

procedure rep_collectif (var ok : boolean);
   var
      chemint,
      d                 : dirstr;
      n                 : namestr;
      e                 : extstr;

   begin
      chemint := ch_mnu;
      enleve_antislash (chemint);
      fsplit  (chemint, d, n, e);
      enleve_antislash (d);
      chemint := d;

      nom_repert (t_reptrv, chemint, ok);
                                 { saisie dest }

      if chemint <> d
      then
         creer_repert (chemint, place_trv, ok);
                                             { racine du rpert de travail }
      enleve_antislash (ch_grp);
      fsplit  (ch_grp, d, n, e);
      ch_grp := chemint+'\'+n;

      if ok
      then
         creer_repert (ch_grp,  place_trv, ok);       { rpert geoc_trv }

      if ok
      then
         creer_repert (ch_grp+'\'+gcommun, place_trv, ok);  { public }

      complete (ch_grp);
      chdir    (ch_ct);
   end;

procedure teste_rep_collectif (var ok : boolean);
   { re cre les rpertoires minimaux / memu }
   var
      chemint,
      d                 : dirstr;
      n                 : namestr;
      e                 : extstr;

   begin
      chemint := ch_grp;
      enleve_antislash (chemint);
      fsplit  (chemint, d, n, e);
      enleve_antislash (d);
      chemint := d;

      enleve_antislash (ch_grp);
      fsplit  (ch_grp, d, n, e);

      creer_repert    (chemint,  place_trv, ok);
                      { racine du rpert de travail }

      ch_grp := chemint+'\'+n;

      if ok
      then
         creer_repert (ch_grp,  place_trv, ok);       { rpert geoc_trv }

      if ok
      then
         creer_repert (ch_grp+'\'+gcommun, place_trv, ok);  { public }

      complete (ch_grp);
      chdir    (ch_ct);
   end;

procedure rep_perso (var ok : boolean);
   begin
      nom_repert (t_repperso, ch_grp, ok);
                                 { saisie dest }
      if ok
      then begin
         creer_repert (ch_grp, place_trv, ok);
         chdir (ch_ct);
      end;
      complete (ch_grp);
   end;

procedure rep_echanges (var ok : boolean);
   begin
      ch_ech := reptemp;
      enleve_antislash (ch_ech);
      nom_repert (t_repech, ch_ech, ok);
                                 { saisie dest }
      if ok
      then begin
         creer_repert (ch_ech, place_trv, ok);
         chdir (ch_ct);
      end;
      complete (ch_ech);
   end;

procedure supprimer_entree_bte (var bte : lst_chn; li : integer);
   var
      p_sup, p_suiv,
      p_pre, p_ct       : lst_chn;
      i                 : integer;

   begin
      if bte = nil then exit;
      if bte^.suivant <> nil
      then begin
         p_ct   := bte;
         p_pre  := bte;
         p_suiv := bte^.suivant;
         i      := 0;
         while (i < li)    { >= 1 et <= nbregions }
         do begin
            inc (i);                   { 2.. 12   nb maxi  de lignes au menu }
            p_pre  := p_ct;
            p_ct   := p_ct^.suivant;
            p_suiv := p_ct^.suivant;
         end;
         p_sup           := p_ct;

         if i = 1
         then begin
            p_sup := bte;
            bte   := p_suiv;
         end else begin
            p_pre^.suivant := p_suiv;
            p_sup := p_ct;
         end;
      end else begin
         p_sup := bte;
         bte   := nil;
      end;
      p_sup^.suivant := nil;
      liberer_liste_chaine (p_sup);
   end;

procedure supprimer_entree_liste (var lste : lst_chn; nm : string);
   { supprime l'lment nm de la liste }

   var
      p_sup, p_suiv,
      p_pre, p_ct       : lst_chn;
      trouve            : boolean;

   begin
      if lste = nil
      then
         exit;    { liste compltement vide... pas de modif }

                  { tester la premire entre }
      if nm = lste^.elements^.suivant^.nom^
      then
         lste := lste^.suivant
      else begin  { tester les autres }
         p_ct   := lste^.suivant;
         p_pre  := lste;
         trouve := nm = p_ct^.elements^.suivant^.nom^;
         while not trouve and (p_ct <> nil)
         do begin
            p_pre  := p_ct;
            p_ct   := p_ct^.suivant;
            trouve := nm = p_ct^.elements^.suivant^.nom^;
         end;

         if trouve             { liminer l'entre correspondante }
         then begin
            p_pre^.suivant  := p_ct^.suivant;
         end ;
      end;
   end;

procedure inserer_entree_bte (bte          : lst_chn ;
                              numbte, li   : integer;
                              sousm,
                              taide,
                              lign3, lign4,
                              xs,    ys,
                              ls,    hs    : t12);
   { insre une ligne donnes dans BTE en positon li
     var globales modifies : BOITE2/BOITE3}

   var
      p_pre, p_ct,
      p_ico,
      n_bte          : lst_chn;
      nb             : integer;

   begin
      { affecter une "ligne" de la bte menu REGION }
      new          (n_bte);
      cree_nom_chn (n_bte, sousm);
                    n_bte^.suivant := nil;

      new          (n_bte^.elements);
      cree_nom_chn (n_bte^.elements, taide);
                    n_bte^.elements^.elements := nil;

      new          (n_bte^.elements^.suivant);
      cree_nom_chn (n_bte^.elements^.suivant, lign3);
                    n_bte^.elements^.suivant^.elements := nil;

      new          (n_bte^.elements^.suivant^.suivant);
      cree_nom_chn (n_bte^.elements^.suivant^.suivant, lign4);
                    n_bte^.elements^.suivant^.suivant^.elements := nil;

      new          (n_bte^.elements^.suivant^.suivant^.suivant);

      p_ico     :=  n_bte^.elements^.suivant^.suivant^.suivant;
      cree_nom_chn (p_ico, xs);
                    p_ico^.elements := nil;

      new          (p_ico^.suivant);
      cree_nom_chn (p_ico^.suivant, ys);
                    p_ico^.suivant^.elements := nil;

      new          (p_ico^.suivant^.suivant);
      cree_nom_chn (p_ico^.suivant^.suivant, ls);
                    p_ico^.suivant^.suivant^.elements := nil;

      new          (p_ico^.suivant^.suivant^.suivant);
      cree_nom_chn (p_ico^.suivant^.suivant^.suivant, hs);
                    p_ico^.suivant^.suivant^.suivant^.elements := nil;
                    p_ico^.suivant^.suivant^.suivant^.suivant  := nil;
      { fin new + affecter}

      { chaner }
      p_ct  := bte;
      p_pre := bte;

      nb    := 0;
      while (nb < li)    { infrieur  nbregions }
      do begin
         inc (nb);                   { 2.. 12   nb maxi  de lignes au menu }
         p_pre  := p_ct;
         p_ct   := p_ct^.suivant;
      end;
      n_bte^.suivant := p_ct;
      p_pre^.suivant := n_bte;
   end;

procedure  valeurs_entree_bte (bte               : lst_chn;
                               numbte, li        : integer;
                               var sousm         : chaine;
                               var taide         : longchaine;
                               var lign3, lign4  : namestr;
                               var xs,    ys,
                                   ls,    hs     : t12);
   { rend la ligne BTE en positon li }
   var
      p_ct,
      p_ico,
      n_bte             : lst_chn;
      nb                : integer;

   begin
      { rechercher }
      p_ct  := bte;

      nb    := 0;
      while (nb < li)    { infrieur  nbregions }
      do begin
         inc (nb);                   { 2.. 12   nb maxi  de lignes au menu }
         p_ct   := p_ct^.suivant;
      end;

      { affecter une "ligne" de la bte menu REGION }
      n_bte := p_ct;
      sousm := n_bte^.nom^;
      taide := n_bte^.elements^.nom^;
      lign3 := n_bte^.elements^.suivant^.nom^;
      lign4 := n_bte^.elements^.suivant^.suivant^.nom^;

      p_ico := n_bte^.elements^.suivant^.suivant^.suivant;
      xs    := p_ico^.nom^;
      ys    := p_ico^.suivant^.nom^;
      ls    := p_ico^.suivant^.suivant^.nom^;
      hs    := p_ico^.suivant^.suivant^.suivant^.nom^;
   end;

procedure remplacer_entree_bte (bte                   : lst_chn ;
                                numbte, li            : integer;
                                sousm                 : chaine;
                                taide                 : longchaine;
                                lign3, lign4          : namestr;
                                xs,    ys,    ls,  hs : t12);
   { remplace une ligne donnes dans BTE en positon li
     var globales modifies : BOITE2 }
   var
      p_ct,
      p_ico,
      n_bte             : lst_chn;
      nb                : integer;

   begin
      { rechercher }
      p_ct  := bte;

      nb    := 0;
      while (nb < li)    { infrieur  nbregions }
      do begin
         inc (nb);                   { 2.. 12   nb maxi  de lignes au menu }
         p_ct   := p_ct^.suivant;
      end;

      { affecter une "ligne" de la bte menu REGION }
      n_bte := p_ct;
      modif_nom_chn (n_bte, sousm);
      modif_nom_chn (n_bte^.elements, taide);
      modif_nom_chn (n_bte^.elements^.suivant, lign3);
      modif_nom_chn (n_bte^.elements^.suivant^.suivant, lign4);

      p_ico     :=  n_bte^.elements^.suivant^.suivant^.suivant;
      modif_nom_chn (p_ico, xs);
      modif_nom_chn (p_ico^.suivant, ys);
      modif_nom_chn (p_ico^.suivant^.suivant, ls);
      modif_nom_chn (p_ico^.suivant^.suivant^.suivant, hs);
   end;

procedure inhiber_entree_bte   (li : integer);
   var
      i, p              : integer;
      c                 : string [1];

   begin
      { supprimer li des listes 'autorises'
      for i := 1 to nboptions-1
      do begin
          menu_prg [i, li] := false;
      end;                                   }

      for i := 1 to nbregions
      do begin
         valeurs_entree_bte   (boite2, 2, i,
                               nom_r, aide_r, rep_r, interdits,
                               xst,   yst,    lst,   hst);

         str (li, c);
         if interdits [1] ='0'
         then                 { remplacer le caractre }
            interdits := c
         else begin
            if pos (c, interdits) = 0
            then
               interdits := interdits +c;  { ajouter le car }
         end;                              { sinon : il y est dj }

         remplacer_entree_bte (boite2, 2, i,
                               nom_r, aide_r, rep_r, interdits,
                               xst,   yst,    lst,   hst);
      end;
   end;

procedure testemenu;
   begin
      affiche_image;
      libereicone (der_icn);

      initmenus;
      inimenus_menu;
      inimenus_conf;

      lire_menus;              { maj tableaux divers }
      def_icones_modules (3);
      def_icones_region  (der_icn);
      dess_icones;
   end;

procedure choisir_entree (numbte : integer; var li : integer);
 {     li := nbregions + 1;  li > 0 obligatoire }
                           { li := 1           insertion en tte         }
                           { li <= nbregions   insertion en position LI  }
                           { li = nbregions+1  insertion en queue  }
   var
      xm, ym, code      : integer;

   begin
      laide (la_modi_option);
      ym := hauteurmenu+2;    { duplication hmenu }
      repeat
         until not unboutonsourisenfonce;
      xm := (trunc (maxx / nbboites))* (numbte-1); { var lmenu pour MENUS }
      MontrerSouris;
      sousmenu    (xm, ym, numbte, li, Code);
      CacherSouris;
      laide ('');
      li := li-1;
      if li < 1
      then
         li := 1;
   end;

procedure saisir_region (var nom             : chaine;
                         var t               : chainecar;
                         var rep             : namestr;
                         var i4              : t12 ;
                         nouvelle            : boolean;
                         var supp            : boolean );
   var
      t1, t2,
      s,
      s1, s2, s3, s4    : string;
      nb,
      i,
      touche, poscur    : integer;
      z1, z2, z3, z4    : pzoneChaine;
      boite             : PBoiteSaisie;

      ZB, ZB0
                        : PZoneBooleen;
      b
                        : array [1..NbOptions] of boolean;

   begin
      s1 := nom;
      s2 := t;
      t1 := copy (t,  1, 25);
      t2 := copy (t, 26, 25);

      s3 := rep;
      s4 := i4;
      supp := false;
      if s4 = '0'
      then
         for nb := 1 to NbOptions
         do
            b [nb] := true
      else
         for nb := 1 to NbModules
         do
            b [nb] := menu_prg [ndonnees, nb];


      poscur := 1;
      laide (aidedit);

      boite  := new (PBoiteSaisie,
                     init (milieu, milieu, 15, 7,  0, t_menu_region));

      z1     := new (PZoneChaine,
                     init ( 0,   2*ty,     25, 0, 15, @nom,  b_nom, ''));
      boite^.ajoute (z1);

      if nouvelle
      then begin
         z4  := new (PZoneChaine,
                     init ( 0,      0,       8, 0, 15, @rep, b_repert, ''));
         boite^.ajoute (z4);
      end;

      if not nouvelle
      then begin
         zB0 := new (PZoneBooleen,
                     init ( 0,      0,       4, 6,     @supp, b_supprime, ''));
         Boite^.Ajoute (ZB0);
      end;

      z2     := new (PZoneChaine,
                     init ( 0,      0,      32, 0, 15, @t1,   b_aide, ''));
      boite^.ajoute (z2);
      z3     := new (PZoneChaine,
                     init ( 0, 12*ty div 2, 32, 0, 15, @t2,   ' ...', ''));
      boite^.ajoute (z3);

      s  := b_autorise;
      for nb := 1 to NbModules
      do begin
         ZB := new (PZoneBooleen,
                    init (0, 13*ty div 2 +ty *nb, 4, 6, @b [nb],
                                             s+' : '+menu_pro [nb], ''));
         Boite^.Ajoute (ZB);
      end;

      boite^.editeF (1, Poscur, Touche);
      boite^.vider;
      dispose (boite, fini);

      laide ('');
      i4 := '';
      for nb := 1 to NbModules
      do begin
         str (nb, chain);
         if not b [nb]
         then
            i4 := i4 + chain;
      end;

      if i4 =''
      then
         i4 := '0';

      if touche = ESC
      then begin
         supp  := false;
         nom   := s1;
         t     := s2;
         rep   := s3;
         i4    := s4;
      end else
         t := t1+t2;
   end;

procedure  choisir_zone_icone (var xst, yst, lst, hst : t12);
   var
      x0, y0,
      x1, y1, lx, ly    : integer;

   begin
      message (m_choix_zone);
      laide   (la_def_cadre);
      repeat
         changercurseur (croix);
         ok := false;
         fenetre (maxc1, maxc2, maxc3, maxc4);
         cloture (maxc1, maxc2, maxc3, maxc4);
         def_zone (1, 3, 0,
                   maxc1, maxy-maxc4, maxc2, maxy-maxc3,
                   x0, y0, x1, y1);
         lx := x1-x0;
         ly := y1-y0;
         setcolor  (colord);
         rectangle (x0, y0, x1, y1);
         changercurseur (fleche);
         pleinecloture;
         question   (q_rect1, q_rect2, ok);
         if not ok
         then begin
            fenetre (maxc1, maxc2, maxc3, maxc4);
            cloture (maxc1, maxc2, maxc3, maxc4);
            setcolor  (colorf);
            rectangle (x0, y0, x1, y1);
            pleinecloture;
            message (m_encore);
            laide   (la_def_cadre);
         end;
      until ok;
      str (x0, xst);
      str (y0, yst);
      str (lx, lst);
      str (ly, hst);
      laide ('');
      zed := li+ der_icn ;
   end;

function rech_region (rep : pathstr) : namestr;
      var
         r              : string;
         p, lg          : integer;

      begin
         lg     := length (rep);
         if lg > 0
         then
            if rep  [1]  = '\'
            then
               rep := copy (rep, 2, lg);

         lg     := length (rep);
         p      := 1;
         repeat
            sousch (rep, p, '\', r, p )
         until p > lg;
         rech_region := r;
      end;

procedure choisir_repert_region (var rep_r : pathstr);
   var
      nf                : pathstr;

   begin
      nf    := ch_dnn;
      repertoire (t_rep_donnees, nf , ok );
      rep_r := rech_region (nf);
   end;

procedure ajouter_region;     { inserer une ligne au menu }
   { ex ELEMENT    ANDES
                   ( subduction Cordillre des Andes ;
                     ANDESS ; 0 ;
                     15; 260 ;  30 ;  30 ) )  }
   var
      supp              : boolean;
      n_reg             : lst_chn;

   begin
      supp      := false;
      choisir_repert_region (rep_r);
      if rep_r = '' then exit;
      nom_r     := rep_r;
      if ftxt_present (ch_dnn+rep_r+'\'+rep_r+extmn0)
      then begin                       { insertion automatique }
         lire_par_region (ch_dnn+rep_r+'\'+rep_r+extmn0, n_reg);
         { complter boite2 }
         li := nbregions;
         inserer_nouv_entree_bte (n_reg, boite2, li);
      end else begin                   { insertion manulelle }
   (*      aide_r    := n_nouv_region;
         interdits := '0';
         saisir_region        (nom_r, aide_r, rep_r, interdits, true, supp);
         DemarquerIconeg (zed, picod);           { p_ico en entre }
         choisir_zone_icone   (xst, yst, lst, hst);
         message (m_choisir_pos);
         choisir_entree       (2, li);
         inserer_entree_bte   (boite2, 2, li,
                               nom_r, aide_r, rep_r, interdits,
                               xst,   yst,    lst,   hst);
*)
         message (n_fichier+' '+ch_dnn+rep_r+'\'+rep_r+extmn0+' '+not_fic1);
      end;
      ndonnees := li;
      testemenu;
      choix_region (ndonnees);
      zed      := der_icn+li;
      MarquerIconeg   (zed, cod, picod);  { p_ico en sortie }
      modipar  := true;
   end;

procedure modifier_region;
   var
      supp              : boolean;

   begin
      (*      message ('Choisir la ligne  modifier');
              choisir_entree       (2, li);  *)
      supp := false;
      valeurs_entree_bte   (boite2, 2, ndonnees,
                            nom_r, aide_r, rep_r, interdits,
                            xst,   yst,    lst,   hst);
      saisir_region        (nom_r, aide_r, rep_r, interdits, false, supp);

      demarquericoneg (zed, picod);  { p_ico en sortie }
      if supp
      then begin
         supprimer_entree_bte (boite2, ndonnees);
         raz_option_menu (2, nbregions);
      end else begin
         ok := false;
         question (q1_icone, q2_icone, ok);
         if ok
         then
            choisir_zone_icone   (xst, yst, lst, hst);

         remplacer_entree_bte (boite2, 2, ndonnees,
                               nom_r, aide_r, rep_r, interdits,
                               xst,   yst,    lst,    hst);
      end;
      testemenu;
      if supp
      then
         choix_region (0);
      zed := ndonnees + der_icn;
      marquericoneg (zed, cod, picod);
      modipar := true;
   end;

procedure effacer_region ;
   var
      nomregion         : namestr;

   begin
      nomregion := n_region;
      saisie (s_eff_region, nomregion, 8);
{ !! contrle }
      if nomregion = '' then exit;
      ok := false;
      question (q1_effacer , q2_effacer, ok);
      if ok
      then begin
         effacer_fichiers (ch_dnn+nomregion+'\*.*', entier );
         message (m_supp_entree+' '+nomregion+' '+m_au_menu);
         modipar := true;
      end;
   end;

(* procedure copier_region ;     { rpertoire }
   var
      nomregion      : namestr;

   begin
      { -d  reconstituer rpertoires
        -o  craser
        -n  nouveaux
        -f  raffraichir
        @liste  liste.txt noms de fichiers           }
      { changer de rpert ou donner destination }
      nomregion := '';
      saisie ('Rgion : ', nomregion, 8);

      if nomregion = '' then exit;
      message ('Introduire dk donnes en a: ');
      if ftxt_present ('a:zdnn.zip')
      then begin
         extraire_fichiers_zip ('a:', 'a:zdnn', '-d -o',
                                 nomregion+'\*.*', ch_dnn, ok);
         { revenir rpert ct }
         message ('Ajouter l''entre '+nomregion+'au menu');
      end else
         message ('Fichier non trouv !');
   end;

procedure copier_eff_region ;                        { fichiers }
   begin
      entier := 1;
      creeliste ('Effacer...',  1);
      creeliste ('Copier...',  2);
      liste ('','Action','', 18, chain, entier);
      case entier of
         1 : effacer_region;
         2 : copier_region;
      end;
   end;                 *)

procedure mod_menu_region;
   begin
      entier := 1;
      creeliste (l1_region,    1);
      creeliste (l2_region,    2);
      if prof and (nomutil = 'ARX')
      then
          creeliste (l3_region,    3);
      liste     (ll1_region, ll2_region, ll3_region, 23, chain, entier);
      case entier of
         1 : Ajouter_Region;                      { au menu }
         2 : Modifier_Region;
         3 : Effacer_Region;
      end;
   end;

   {------------------------------------------------------------------------}

procedure  choisir_icone_prg ( var x0, y0 : integer);
   var
      xx, yy, lx, ly    : integer;

   begin
      lx := x0+licop;
      ly := y0+hicop;
      laide   (la_depl_rect);
      xx := x0;
      yy := y0;
      setcolor  (colord);
      setwritemode (1);
      rectangle (x0, y0, lx, ly);
      changercurseur (main);
      ok := false;
      repeat
         setcolor (15);
         depl_rec (xx, yy, licop, hicop);
         question (q1_c_icone, q2_c_icone, ok);
      until ok;
      if ok
      then begin
         x0 := xx;
         y0 := yy;
      end;
      setcolor  (colord);
      rectangle (x0, y0, x0+licop, y0+hicop);
      laide ('');
      changercurseur (fleche);
   end;

procedure saisir_prog           (var nom     : chaine;
                                 var t       : longchaine;
                                 var f       : namestr;
                                 var e       : string;
                                 nouv        : boolean;
                                 var supp    : boolean  );
   var
      t1, t2,
      s1, s2, s3, s4    : string;
      touche, poscur    : integer;
      z1, z2,
      z3, z4, z5        : pzoneChaine;
      boite             : PBoiteSaisie;
      ZB0
                        : PZoneBooleen;

   begin
      s1 := nom;
      s2 := t;
      s3 := f;
      s4 := e;
      t1 := copy (s2,  1, 25);
      t2 := copy (s2, 26, 25);
      supp := false;
      poscur := 1;
      laide (aidedit);
      z1     := new (PZoneChaine,
                     init ( 0,      0,   25,  0, 15, @nom,  b_nom_menu, ''));

      if not nouv
      then begin
         zB0 := new (PZoneBooleen,
                     init ( 0,      0,        4,  6, @supp, b_Supprime, ''));
         zB0^.Cnom := colorf;
      end;

      z2     := new (PZoneChaine,
                     init ( 0,      0,   32,  0, 15, @t1,   b_Aide,     ''));
      z3     := new (PZoneChaine,
                     init ( 0,      0,   32,  0, 15, @t2,   ' ...',      ''));
      if nouv
      then begin
         z4  := new (PZoneChaine,
                     init ( 0,      0,    8,  0, 15, @f,   b_module,    ''));
         z5  := new (PZoneChaine,
                     init (31*tx, 7*ty,   5,  0, 15, @e,   b_Extension, ''));
      end;

      boite  := new (PBoiteSaisie,
                     init (milieu, milieu, 15, 7, 0,       t_activite));

      boite^.ajoute (z1);
      if not nouv
      then
         Boite^.Ajoute (ZB0);
      boite^.ajoute (z2);
      boite^.ajoute (z3);
      if nouv
      then begin
         boite^.ajoute (z4);
         boite^.ajoute (z5);
      end;
      boite^.editeF (1, Poscur, Touche);
      boite^.vider;

      dispose (boite, fini);
      laide ('');
      if touche = ESC
      then begin
         nom   := s1;
         t     := s2;
         f     := s3;
         e     := s4;
         supp  := false;
      end else
         t := t1+t2;
   end;

function pos_ico (n : namestr) : integer;
   var
      i                 : integer;
      trouve            : boolean;

   begin
      i := 0;
      trouve := false;
      while not trouve and (i < nboptions-1)
      do begin
         inc (i) ;
         trouve := maj (n) = maj (menu_ico [i])
      end;

      if trouve
      then
         pos_ico := i
      else
         pos_ico := 0;
   end;

function pos_module (n : namestr) : integer;
   var
      i                 : integer;
      trouve            : boolean;

   begin
      i := 0;
      trouve := false;
      while not trouve and (i < nboptions-1)
      do begin
         inc (i) ;
         trouve := maj (n) = maj (menu_pro [i])
      end;

      if trouve
      then
         pos_module := i
      else
         pos_module := 0;
   end;

function module_valide          (fic : namestr) : boolean;
   begin
      module_valide :=     (pos_ico    (fic) > 0)
                       and (pos_module (fic) = 0)
                       and ftxt_present (ch_prg+fic+'.Exe')
   end;

procedure ajouter_module ;
   var
      supp              : boolean;
      x0 , y0 ,i        : integer;
      n_mod             : lst_chn;

   begin
      fic_p := '';
      saisie (n_module+' : ' , fic_p, 4);
      fic_p := maj (fic_p);

      if (fic_p = '') or not module_valide (fic_p)
      then
         exit;

      if ftxt_present (ch_prg+fic_p+extmn0)
      then begin
         lire_par_module (ch_prg+fic_p+extmn0, n_mod);

         { complter boite3 }
         inc (nbmodules);
         li := pos_ico (fic_p) ;
         inserer_nouv_entree_bte (n_mod, boite3, li);
      end else begin
(*         aide_p    := '...';
         saisir_prog (nom_p, aide_p, fic_p , extini, true, supp); { saisie NOM }
         if (nom_p = '') or (aide_p = '') or (fic_p = '') or (extini = '')
         then begin
            message (m_complete);
            { pour viter Pb dans liste_chn }
            exit;
         end;
         inc (nbmodules);
         li := pos_ico (fic_p) ;
         inserer_entree_bte  (boite3, 2, li,
                              nom_p, aide_p, fic_p, extini,
                              xst,    yst,     lst,    hst);
         x0 :=  0;
         y0 := 30;
         choisir_icone_prg (x0, y0); { position icne }
         str (x0, xst);
         str (y0, yst);
         str (licop, lst);
         str (hicop, hst);
*)
         message (n_fichier+' '+ch_prg+fic_p+extmn0+' '+not_fic1);
         fic_p := '';
      end;

      DemarquerIconeg (zea, picoa);           { p_ico en entre }
      nactivite := li;
      zea       := 3 +1+nbmodules;
      modi_bouton (aide_p, nactivite+3, x0, y0, licop, hicop);

      testemenu;

      choix_activite  (nactivite);
      MarquerIconeg   (zea, coa, picoa);  { p_ico en sortie }
      modipar := true;
   end;

procedure modifier_module;
   var
      supp              : boolean;
      chain             : namestr;
      x0, y0 ,i         : integer;

   begin
      valeurs_entree_bte   (boite3, 2, nactivite,
                            nom_p, aide_p, fic_p, extini,
                            xst,    yst,     lst,    hst);
      chain := fic_p;
      saisir_prog          (nom_p, aide_p, fic_p, extini, false, supp);
      fic_p := maj (fic_p);
      Demarquericoneg (zea, picoa);  { p_ico en sortie }
      if supp
      then begin
         supprimer_entree_bte (boite3, nactivite);
          { ok ou seulement ::  inhiber_entree_bte   (nactivite); }
      end else begin
         ok := false;
         question (q1_d_icone, q2_d_icone, ok);
         if ok
         then begin
            x0 := menu_ico3 [nactivite, 1];
            y0 := menu_ico3 [nactivite, 2];
            choisir_icone_prg (x0, y0);       { position icne }
            str (x0, xst);
            str (y0, yst);
            modi_bouton (aide_p, nactivite+3, x0, y0, licop, hicop);
         end;
         remplacer_entree_bte (boite3, 2, nactivite,
                               nom_p, aide_p, chain, extini,
                               xst,    yst,     lst,    hst);
      end;
      testemenu;
      if supp
      then begin
         choix_region   (0);
         choix_activite (0);
      end else begin
         zea := nactivite + 3;
         Marquericoneg  (zea, coa, picoa);
      end;
      modipar := true;
   end;

(*procedure effacer_module;               {  revoir !!! }
   var
      nomprog           : namestr;

   begin
      nomprog := '';
      saisie (s_eff_mod+ ' : ', nomprog, 4);
      if (nomprog = '') or (pos_module (nomprog) < 1)
      then
         exit;

      ok := false;
      question (q1_effacer , q2_effacer, ok);
      if ok
      then begin
         effacer_fichiers (ch_prg+nomprog+'*.*', entier);
         message (m_supp_entree+' '+nomprog+' '+m_au_menu);
         modipar := true;
      end;
   end;
*)
(*  procedure copier_module ;
   var
      nomprog        : namestr;

   begin
      nomprog := '';
      saisie ('Module : ', nomprog, 8);
      if nomprog = '' then exit;
      message ('Introduire la dk prog en a: ');
      if ftxt_present ('a:zprg.zip')
      then begin
         extraire_fichiers_zip ('a:', 'a:zprg.zip', '-d -o',
                                 nomprog+'.*', reptemp{ch_prg}, ok);
         { revenir  }
         message ('Ajouter l''entre '+nomprog+' au menu');
      end else
         message ('Fichier non trouv !');
   end;

procedure copier_eff_module ;                        { fichiers }
   begin
      entier := 1;
      creeliste ('Effacer...',  1);
      creeliste ('Copier...',  2);
      liste ('','Action','', 18, chain, entier);
      case entier of
         1 : effacer_module;
         2 : copier_module;
      end;
   end;                         *)

procedure mod_menu_activ;
   begin
      entier := 1;
      creeliste (l1_activ,    1);
      creeliste (l2_activ,    2);
 {     if prof and (nomutil = 'ARX')
      then
          creeliste (l3_activ,    3);}
      liste     (ll1_activ, ll2_activ, ll3_activ, 23, chain, entier);

      case entier of
         1  : Ajouter_Module;
         2  : Modifier_Module;
{         3  : Effacer_Module ;  }
      end;
   end;

function element_liste (nom : t12 ; list : lst_chn) : boolean;
   { rend V si nom est dans list }
   var
      trouve            : boolean;
      p_l               : lst_chn;

   begin
      if list = nil
      then
         element_liste := false;

      p_l    := list;
      repeat
         trouve :=  maj (nom)              = maj (p_l^.nom^) ;
                   { nom rgion-prg /boite = nom /liste }
         p_l    := p_l^.suivant;
      until (p_l = nil) or trouve;
      element_liste := trouve;
   end;

procedure ouvrir_config_geocean;
   var
      ext               : extstr;

   begin
      { choisir le fichier de cfg }
      dir_info
         ('',
          d2_choisir_cfg,
          '',
          ch_prg, '*', extcfg, chain);        { au moins geocean0 }
      nomfcfg :=  sansext (chain);
      if nomfcfg = ''                         { ESC }
      then
         nomfcfg := nomlogiciel;

      { charger     }
      lire_config   (ch_prg+nomfcfg+extcfg);
      modini := false;
   end;

procedure enr_config_geocean;
   begin
      { enregistrer_sous }
      ecrire_config (ch_prg+nomfcfg+extcfg );
      modini := false;
   end;

procedure enr_sous_config_geocean;
   var
      ext               : extstr;

   begin
      ok      := false;
      chain   := nomfcfg;
      nomfichier_sortie                                    { menus5 }
         (' : (' +extcfg+ ')', '', chain, ext, ok);
      nomfcfg :=  chain;
      if ok
      then
         ecrire_config (ch_prg+nomfcfg+extcfg );
      modini := false;
   end;

procedure options_periphs;
   begin
      config_periph;
      modini := true;
   end;

procedure preferences;
   var
      touche, poscur    : integer;
      boite             : PBoiteSaisie;
      ZB1, zb2, zb3, ZB4
                        : PZoneBooleen;
      b1, b2, b3, b4    : boolean;

   begin
      poscur := 1;
      laide (aidedit);
      zB1   := new (PZoneBooleen,
                    init ( 0,      0,           4,  6, @reaffiche,
                           b_immediat, ''));

      zB2   := new (PZoneBooleen,
                    init ( 0,      0,           4,  6, @rapide,
                           b_surfaces, 'BLOCS'));

      zB3   := new (PZoneBooleen,
                    init ( 0,      0,           4,  6, @unicolore,
                           b_limite,   'NUAGES'));

      zB4   := new (PZoneBooleen,
                    init ( 0,      0,           4,  6, @TraitementAutorise,
                           b_traitements,   'CART, BLOC, COUP'));

      boite := new (PBoiteSaisie,
                    init ( milieu, milieu, 15,  7, 0,
                           t_Preferences));
      Boite^.Ajoute (ZB1);
      boite^.ajoute (zb2);
      boite^.ajoute (zb3);
      boite^.ajoute (zb4);
      boite^.editeF (1, Poscur, Touche);
      boite^.vider;

      dispose (boite, fini);
      laide ('');
      if touche = ESC
      then begin
         reaffiche := b1;
         rapide    := b2;
         unicolore := b3;
      end else
         modini := true;
   end;


procedure autoriser {(var i4 : string )};
   var
      c                 : string [1];
      i, li             : integer;
      ok                : boolean;

   begin
      message (m_choisir_option);
      choisir_entree   (1, li);
      str (li, c);
      ok  := menu_autorise [li];
      if menu_autorise [li]
      then begin
         question (q1_interdire,
                   q2_option+' '+titremenu (1, li+1),
                   ok);
         if ok
         then begin
         { c'tait autoris... on ajoute  la liste des oprations interdites  }
            if (ope_fic [1] = '0') or (ope_fic = '')
            then                          { remplacer le caractre }
               ope_fic := c
            else begin
               if pos (c, ope_fic) = 0
               then
                  ope_fic := ope_fic +c;  { ajouter le car }
            end;                          { sinon : il y est dj }
            menu_autorise [li] := false;
            modipar := true;
         end;
      end else begin
         question (q1_autoriser,
                   q2_option+' '+titremenu (1, li+1),
                   ok);
         if ok
         then begin
         { c'tait interdit... on retire de la liste des oprations interdites  }
            menu_autorise [li] := true;
            ope_fic := '';
            for i := 1 to nboptions-1
            do begin
               if not menu_autorise [i]
               then begin
                  str ( i, c);
                  ope_fic := ope_fic + c;
               end;
            end;
            modipar := true;
         end;
      end;
   end;

procedure ajouter_groupe (groupu : namestr);
   begin
      { si nouveau Ajouter nom  }
      ok := (nbgroupes < nboptions) and (not groupexist (groupu));
{      if ok
      then
         question ('Faut-il crer le groupe', groupu, ok);
}
      if ok
      then begin
         ajouter_nom_chaine (list_grp, groupu);
         inc (nbgroupes);
      end else
         message (m_not_ajout);
   end;

procedure retirer_groupe (groupu : namestr);
   begin
      ok := (groupu <> gcommun) and (nbgroupes > 1);
      if ok
      then
         question (q1_supprimer, q2_groupe, ok);

      if ok
      then begin
         { supprimer dans le tableau  menu_grp }
         supprimer_nom_chaine (list_grp, groupu);
         modipar := true;
         dec (nbgroupes);
      end;
   end;

procedure lister_existant (p : lst_chn);
   var
      i                 : integer;

   begin
      i := 0;
      while p <> nil
      do begin
         inc (i);
         creeliste ( p^.nom^,    i);
         p := p^.suivant;
      end;
   end;

procedure lister_groupe_existants;
   begin
      lister_existant (list_grp);
      liste     (lv1_grp, lv2_grp, lv3_grp, 18, chain, entier);
   end;

procedure choisir_groupe_existant (var groupu : namestr; var ok: boolean);
   begin
      lister_existant (list_grp);
      liste     (l1_grp, l2_grp, l3_grp, 18, groupu, entier);
      ok := entier > 0;
   end;

procedure gerer_groupes;
   var
      ok                : boolean;
      choix, numu,
      i                 : integer;
      groupu            : namestr;

   begin
      { saisir action }
      choix    := 1;
      laide     (la_grp);
      creeliste (c_voir,            1);
      creeliste (c_ajouter,         2);
      creeliste (c_Supprimer,       3);
      liste     ('', l2_grpg, '', 20, chain, choix);
      if choix = 0 then exit;

      { saisir nom du groupe }
      groupu := '';
      case choix of
         1 : begin
                lister_groupe_existants ; { <> public}
                ok := false;
                groupu := '';
             end;
         2 : begin  { ajouter }
                saisie (s_nom_grp, groupu, 8);
                filtrer_indesirables    (groupu);
                groupu := maj (groupu);
                if groupu <> ''
                then
                   ajouter_groupe       (groupu);
                modipar := true;
             end;

         3 : begin  { supprimer }
                choisir_groupe_existant (groupu, ok); { <> public}
                if ok
                then
                   retirer_groupe (groupu)
                else
                   message (m_not_retrait);
                modipar := true;
             end;
      end;
      laide     ('');
   end;

procedure retirer_nom_groupe      (nomu, groupu : namestr);
   var
      g                 : lst_chn;

   begin
      { chercher le premier des ELEMENTS de la liste GROUPU }
      g  := p_element      (list_grp, groupu);

      { supprimer un des SUIVANT dans cette liste }
      supprimer_nom_chaine (g^.elements, nomu);
   end;

procedure ajouter_nom_groupe      (nomu, groupu : namestr);
   { en queue }
   var
      g                 : lst_chn;

   begin
      g  := p_element    (list_grp, groupu);

      ok := (not element_existe (g^.elements, nomu))
            and (compte_elements (g^.elements) < nboptions);
      if ok
      then
         { ajouter un suivant  la liste GROUPU }
         ajouter_nom_chaine (g^.elements, nomu) ;
    {  else
         message ('Pas d''ajout !');}
   end;

procedure choisir_nom_existant     (var nomu, groupu : namestr; var ok : boolean);
   { listes des nom de tous les groupes }
   var
      g, n              : lst_chn;
      nesp,
      i, j              : integer;

      nm, grp,
      nomgr             : namestr;
      comm1,
      comm2, comm3      : string;

   begin
      comm1 := '';
      comm2 := '';
      comm3 := '';
      if ok
      then begin
         comm1 := lv1_pseudo;
         comm2 := lv2_pseudo;
         comm3 := lv3_pseudo;
      end else begin
         comm2 := l2_grp;
         comm3 := l3_pseudo;
      end;
      i := 0;
      g := list_grp;
      while g <> nil
      do begin
         n := g^.elements;
         while n <> nil
         do begin
            chain := '' ;
            inc (i);
            nm   := n^.nom^;
            grp  := g^.nom^;
            nesp := 10 - length (nm);
            for j := 1 to nesp
            do
               chain := chain+' ';
            creeliste (nm +chain+grp,    i);
            n := n^.suivant;
         end;
         g := g^.suivant;
      end;

      liste     (comm1, comm2, comm3, 18, nomgr, i);
      sousch (nomgr, 1, ' ', nomu, j);
      e_b_devant (nomu);
      groupu := copy (nomgr, 10, length (nomgr));
      e_b_devant (groupu);
      ok := i > 0;
   end;

procedure gerer_utilisateurs;
   { Gre les pseudonymes de "connexion"  de la liste  GROUPES              }
   var
      utilexist         : boolean;
      choix             : integer;
      nomu, groupu      : namestr;

   begin
      { saisir action }
      nomu  := '';
      laide  (la_pseudo);
      choix := 1;
      creeliste ( c_Voir,       1);
      creeliste ( c_Ajouter,    2);
      creeliste ( c_Supprimer,  3);
      liste ('', l2_pseudo, '', 20, chain, choix);
      if choix = 0 then exit;

      { saisir nom }
      case choix of
         1 : begin
                choisir_nom_existant    (nomu, groupu, ok);
                groupu := '';
                ok := false;
             end;
         2 : begin { ajouter }
                saisie (s_1pseudo, nomu, 8);
                filtrer_indesirables    (nomu);
                nomu  := maj (nomu);
                ok := (nomu <> nomutil) and (nomu <> '');
                if ok
                then
                   choisir_groupe_existant (groupu, ok)
                else
                   message (m_autre_ps);
                if ok
                then
                   ajouter_nom_groupe   (nomu, groupu);
                modipar := true;
             end;
         3 : begin  { supprimer }
                choisir_nom_existant    (nomu, groupu, ok);

                ok := (nomu <> nomutil)
                      and (nomu <> ninconnu)
                      and ok;
                if ok
                then
                   retirer_nom_groupe   (nomu, groupu)
                else
                   message (m_not_retrait);
                modipar := true;
             end;
      end;
      laide  ('');
   end;

procedure Nettoyer_travail;
   var
      nb                : integer;
      groupu            : namestr;

   procedure supprimer_groupes_old;
      var
         r, g           : lst_chn;
         r_inutile      : namestr;

      begin
         r := liste_repert (ch_grp+'*.');
         { liste_repert parcourt et mmorise les rpertoires de travail :
           si rep <> groupe alors supprimer le rpert }
         if r = nil then exit;

         g := list_grp;
         repeat
            r_inutile := r^.nom^;
            if not element_existe (g, r_inutile)
            then begin
               effacer_fichiers (ch_grp+r_inutile+'\*.*', nb);
               tuer_repert (ch_grp+r_inutile, ok);
            end;
            r := r^.suivant;
         until r = nil;
      end;

   procedure effacer_groupe;
      begin
         ok := false;
         choisir_groupe_existant (groupu, ok);
         ok := ok and (groupu <> groupe);

         if ok
         then
            question (q1_eff_grp, q2_eff_grp+' '+groupu +'?',
                      ok);

         if ok
         then
            effacer_fichiers (ch_grp+groupu+'*.*', nb );
      end;

   procedure effacer_groupes;
      var
         r, g           : lst_chn;
         r_inutile      : namestr;

      begin
         r := liste_repert (ch_grp+'*.');
         g := list_grp;
         repeat
            r_inutile := r^.nom^;
            effacer_fichiers (ch_grp+'\'+r_inutile+'\*.*', nb);
            r := r^.suivant;
         until r = nil;
      end;

   procedure changer_repert_t;
      var
         ok             : boolean;

      begin
         ok := false;
         question (q_changer1, q_changer2, ok);
         Completer_inst (ok);
      end;

   begin
      complete (ch_grp);
      entier := 1;
      creeliste (c_supp_inutile,            1);
      creeliste (c_eff_rep,                 2);
      creeliste (c_eff_rep_tous,            3);
      creeliste (c_change_repert,           4);
      liste (l1_eff, l2_eff, l3_eff, 36, chain, entier);
      case entier of
         1 : supprimer_groupes_old;
         2 : effacer_groupe;
         3 : effacer_groupes;
         4 : changer_repert_t;
      end;
      modipar := true;
   end;

procedure teste_rep_perso (var ok : boolean);
   begin
      tester_repert (ch_grp, place_trv, ok);
   end;

procedure teste_groupes (var ok : boolean);
   var
      p_pre, p_ct       : lst_chn;
      nom               : namestr;

   begin
      if  not groupexist (gcommun) or (list_grp = nil) { PUBLIC obligatoire }
      then
         ajouter_groupe (gcommun);

      ajouter_nom_groupe   (ninconnu, gcommun);

      p_ct  := list_grp;
      p_pre := list_grp;
      while p_ct <> nil
      do begin
         nom   := p_ct^.nom^;
         tester_repert (ch_grp+nom, 10000, ok);
         p_pre := p_ct;
         p_ct  := p_ct^.suivant;
      end;
      nbgroupes := compte_elements (list_grp);
   end;

procedure Completer_inst (var ok : boolean);
   var
      cfg_ok            : boolean;

   begin
      cfg_ok    := false;
      tousperso := false;

      { message ('L''installation est encore incomplte...');}
      if instreso
      then
         question (q1_perso, q2_perso, tousperso );

      if tousperso
      then begin
         message3 (m1_util_esp, m2_util_esp,  m3_util_esp);
         rep_perso     (cfg_ok);     { rechercher nom , vrifier existe, crer }
         rep_echanges  (cfg_ok);     { tousperso peut basculer }
      end;

      if not tousperso
      then begin
{         message3 (m1_grp_esp, m2_grp_esp ,m3_grp_esp);  silence !! }
         rep_collectif (cfg_ok);
                       { conserver ou initialiser la liste des groupes }
         if cfg_ok
         then
            teste_groupes  (cfg_ok);
      end;

      { installation complte russie }
      modipar := cfg_ok;             { modif si russite }

      ok := cfg_ok;
      if not cfg_ok
      then begin
         message (m_not_install);   {rpertoires de travail }
(*         fini := true;
         if nomdumodule = nomconf
         then begin
            menu_ins.quitter (true);    { gnre le fichier QUIT }
            halt;
         end;   *)
      end;
   end;

procedure complete_install_auto (var ok: boolean);
   begin
      if tousperso
      then
         teste_rep_perso     (ok)
      else begin
         teste_rep_collectif (ok);
         if ok
         then
            teste_groupes    (ok);
      end;

      if not ok
      then begin
         message (m_not_install);
         fini := true;
         menu_fic.quitter (true);    { gnre le fichier QUIT }
         halt;
      end;
   end;

procedure verif;
   begin
      ok := true;
      if modipar or modini { and prof and (maj (nomutil) = 'INRP')}
      then begin
         question (q_verif1, q_verif2, ok);
         if tousperso
         then begin { thoriquement inutile puisque la liste est dj  nil }
            liberer_liste_chaine (list_grp);
            list_grp := nil;
         end;
         if ok
         then begin
            if modipar
            then
               params.ecrit  (ch_par+nomfpar+extpar, nomutil+' '+groupe+' '+datjour);
            if modini
            then
               ecrire_config (ch_prg+nomfcfg+extcfg );
         end;
         modipar:= false;
      end;
   end;

procedure ouvrir_menu;
   begin
      verif;
      dir_info
         ('', d2_ouvrir_mnu, '', ch_par, '*', extPAR, chain);
      nomfpar :=  sansext (chain);
      if nomfpar = ''
      then begin
         nomfpar := nommenu;
         exit;
      end;
      ini_par_trv (ch_par+nomfpar+extpar);
      affiche_image;
      initmenus;                                                { menus1 }
      inimenus_menu;
      inimenus_conf;
      lire_menus;
      iniecran;
   end;

procedure enregistrer_menu;
   begin
      params.ecrit  (ch_par+nomfpar+extpar, nomutil+' '+groupe+' '+datjour);
      modipar := false;
   end;

procedure ENREGISTRER_menu_sous;
   var
      ext               : extstr;

   begin
      ext     := extpar;
      ok      := false;
      chain   := nomfpar;
      nomfichier_sortie                                    { menus5 }
         (Nomf_nouveau+' (' +extpar+ ')', '', chain, ext, ok);
      nomfpar :=  chain;
      if ok
      then begin
         params.ecrit  (ch_par+nomfpar+extpar, nomutil+' '+groupe+' '+datjour);
         modipar := false
      end ;
   end;

procedure parametres_menu;
   begin
      entier := 1;
      creeliste (l1_params, 1);
      creeliste (l2_params, 2);
      liste     ('', c1_params, '', 36, chain, entier);
      case entier of
         1 : voir_ptrav  (nomfpar);
         2 : impr_params (t_bte_params, params);
      end
   end;

procedure parametres_cfg;
   begin
      creeliste (l1_params, 1);
      creeliste (l2_params, 2);
      liste     ('', c2_params, '', 36, chain, entier);
      case entier of
         1 : voir_penv  (nomfcfg);
         2 : impr_params (t_bte_cfg, parini);
      end;
   end;

procedure quitter (f : boolean);
   begin
      chain := q2_quitter;
      if not f
      then
         question (q1_quitter, chain, fini);

      if fini
      then
         verif
   end;

END.


{--- GEOCEAN - MENU_INS ------ --------------- R.C.- INRP - TOULOUSE - 1995 }
