PROGRAM NUAG;

{---------------------------------------------------------------------------}
{  Logiciel GEOCEAN                                                         }
{             programme principal du  module  NUAGES                        }
{                                                version 1.x du  06/04/96   }
{---------------------------------------------------------------------------}
{---------------------------------------------------------------------------}
{  Institut National de Recherche Pdagogique : DP 4, N. SALAME  -  PARIS   }
{  Equipe INRP  TOULOUSE :                                                  }
{  F. BOULANGER, R. CULOS, S. DUPOUY, C. GROS, J-Y. GUCHEREAU, J. TONNELAT  }
{  Ralisation :  93-96                                                     }
{  A R X - Alain, Roger et Xavier CULOS - 6 avenue de Lagarde 31130 BALMA   }
{---------------------------------------------------------------------------}

{---------------------------------------------------------------------------}
{ fichiers spciaux associs au logiciels GEOCEAN                           }
{ *  GEOCEAN .CFG            paramtres de configuration      dans rep PRG  }

{ fichiers spciaux associs  ce programme                                 }
{ *  NUAG    .ICN            images, icnes                   dans rep PRG  }
{ *  NUAG    .PAL            palette                          dans rep PRG  }
{    NUAG    .TXT            mini documentation du programme  dans rep PRG  }
{ *  NUAG    .AID            texte d'aide                     dans rep PRG  }

{---------------------------------------------------------------------------}
{ fichiers associs aux donnes utilises                                   }
{    *       .DAT            Valeurs ponctuelles  reprsenter              }
{    *       .BLN            Contours 2 D format surfer                     }
{    *       .BLF            Contours 2 D format geocean/cart/fond de cartes}
{    *       .BLZ            Contours 3 D format geocean/cart/enr. courbes  }
{                                avec utilisateur ARX (mono) ou RC (reseau) }
{---------------------------------------------------------------------------}
{ fichiers associs  utiliser                                              }
{    *       .NGS            paramtres du travail en cours   dans rep ct   }
{    *       .DXT            Commentaires associs/carte               ct   }
{    *       .PLT            Code HPGL ou imprimante                        }
{    *       .PCX            Copie cran PCX  N&B                           }
{---------------------------------------------------------------------------}

{$M 65520,0,655360}

USES
   NUAG_REC,         { gestion des recouvrements                            }

   CSI,              { gestion du Clavier, de la Souris et des Icnes       }
   MENUS,            { interface  menus droulants                          }

   GEO_VAR,          { variables globales communes                          }
   GEO_DES,          { procedures div communes                              }

   NUAG_VAR,         { variables globales propres au module                 }
   NUAG_DES,         { graphisme du module                                  }
   NUAG_INI,         { initialisations                                      }

   NUAG_5,           { menu : SORTIES                                       }
   NUAG_1;           { menu : FICHIERS  gestion des rpertoires             }

{$O nuag_var}        { dfinition des units en recouvrement                }
{$O nuag_ini}
{$O nuag_des}
{$O nuag_1}
{$O nuag_5}

{$O geo_var}
{$O geo_des}

{$O Menus}
{$O CSI}
{$O Icones}
{$O Curseurs}
{$O symboles}
{$O periphs}
{$O comment}
{$O dirinfo}
{$O lipar}

{$O graphplt}
{$O edition}
{$O utildivs}
{$O fichiers}
{$O graphism}
{$O rs2322}
{$O sekoplt}
{$O imprim}
{$O fctmath}
{$O math3d_c}

{---------------------------------------------------------------------------}

procedure CasMenus;
   var
      Choix             : integer;

   begin
      if changemenus then exit;
      menu (a, b, codeclavier);{ MENU2 }
                               { acquisition d'un choix valide dans un menu }

      if FF1 (codeclavier)     { CSI }
      then                     { appui sur la touche F1 dans un sous-menu   }
         aide (a, b)           { NUAG_INI }
      else begin
         if b > 1
         then
            Choix := 100*a+b;
         case Choix of         { validation d'une option dans un sous-menu  }
          { menu FICHIERS }
            102  : NOUVEAU_FICHIER;                   { 1 }
            103  : OUVRIR_FICHIER;                    { 1 }
            104  : ENREGISTRER_FICHIER;               { 1 }
            105  : ENREGISTRER_SOUS;                  { 1 }
            106  : VOIR_CATALOGUE;                    { menus5 }

            108  : QUITTER;                           { 1 }

            110  : SUPPRIMER_LIEN;                    { 1  p }
            111  : MODIFIER_LIEN;                     { 1  p }
            112  : VOIR_PARAMETRES;                   { 1  p }

          { menu NUAGES  }
            202  : REPERE;
            205  : CALCULER;                          { 2 }

          { menu LEGENDES }
            302  : COMMENTAIRES;                      { 3 }
            303  : couleurs_xyz;

          { menu  ECRAN }
            402  : visu_commentaires;                 { 4 }
            404  : visu_bloc;
            405  : visu_contours;

          { menu SORTIES }
            502  : COPECRAN;                          { 5 }
            504  : TRACE_GRAPH;                       { 5 }
            507  : geo_PALETTES (nomfd);                  { Geo_des }
            508  : CONFIG_PERIPH;                     { Geo_des }
            509  : IMPR_PARAM;                        { 5 prof }

          { menu AIDES }
            602  : AIDE_MENUS_boites (cheminmodule+nomdumodule+exthlp);                        { ini }
            603  : aide (6, 3);
            604  : aide_geoc;
            605  : aide_module;
            606  : aide_region;
            608  : a_propos;
         end;
      end;
   end;

procedure CasIcones;
   var
      PosCur,
      Touche            : integer;

   begin
      if changemenus then exit;
      PosCur := 11;
      if affichetexte            { appui sur F1 au niveau d'une icne       }
      then
         case Zi of                                                   { CSI }
             1 : aide_geoc;      {}
             2 : version_logiciel;
             3 : aide (2, 5);           {  }
             4 : aide_module;          {  }
         end
      else
         case Zi of                                                   { CSI }
             1 : A_PROPOS;
             3 : CALCULER;                                       { NUAG_2  }
             4 : aide_region;
         5..16 : tourne (Zi);
            17 : visu_bloc;
            18 : visu_contours;
            19 : Centrer;
           100 : edi_min_max;
         end;
   end;

procedure CasFenetre;
   begin
      if changemenus then exit;
      if visucomm
      then Editer_Commentaires (xs, ys, db);
   end;


BEGIN                { programme principal }

   iniparam ;        { initialisation des paramtres par dfaut    NUAG_INI }
                     { lecture de fic.CFG                                   }
   inimenus ;        { initialisation de l'interface menus         NUAG_INI }
   iniparam2 ;       { initialisation des paramtres par dfaut    NUAG_INI }
                     { lecture des fichiers .CPS, .SMP, .TXP                }
   iniicones;        { initialisation des icnes                   NUAG_DES }
   inifondecran;
   inisymboles;      { initialisation des symboles                 NUAG_DES }
   inidonnees;       { initialisation des donnes                  NUAG_INI }
   iniecran ;        { initialisation de l'cran/NUAG              NUAG_DES }
   iniaide  ;        { initialisation de l'aide en ligne           NUAG_INI }
                     {      lecture de   fic.AID                            }

   repeat
      modif_menus;   { modifications fonction des paramtres PAR   NUAG_INI }
      case ZoneDuClick (maxc1, maxc2, maxc3, maxc4) of                                       { GEO_CSI }
         1 : CasMenus  ;
         2 : CasIcones ;
         3 : CasFenetre;
      end;
      if changemenus then inversemenus;
   until fini;
   fin;                                                          { NUAG_INI }

END.                      { programme principal }


{--- GEOCEAN - NUAG -------------------------- R.C.- INRP - TOULOUSE - 1995 }
