UNIT NUAG_INI;

   {------------------------------------------------------------------------}
   {      logiciel GEOCEAN                                                  }
   {                initialisations du module NUAGES                        }
   {                                             version 1.1 du  12/02/95   }
   {------------------------------------------------------------------------}

INTERFACE

{$O+,F+}

USES
   dos, crt, graph,          { TP 70   - units  standard Borland           }
   Lipar,                    { ARX     - gestion fichiers paramtres        }
   Graphism,                 { ARX     - initialisations graphiques         }
   Messarx,                  { ARX     - Textes des Messages de Base        }

   Math3d_c,                 { ARX     - fonctions math 3d                  }
   DirInfo,                  { ARX     - Gestion des fichiers ressources    }
   Periphs,                  { ARX     - priphriques, impression, palettes}
   Utildivs,                 { ARX     - utilitaires divers                 }
   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   Icones,                   { ARX     - gestion de icnes                  }
   Menus,                    { ARX     - interface menus                    }
   Curseurs,                 { ARX     - Potentiomtres simples et doubles  }
   Symboles,                 { ARX     - Affichage des valeurs ponctuelles  }

   GEO_var,                  { GEO     - variables globales communes        }
   GEO_des,                  { GEO     - procdures graph. communes         }

   NUAG_var,                 { NUAG    - variables globales du module       }
   NUAG_des;                 { NUAG    - affichages propres au module       }

Procedure inipalette;
   { initialisation des palettes de GRIS                                    }

Procedure inverse_palette;

Procedure iniparam;
   { initialise les paramtres de configuration  du programme.              }

Procedure iniparam2;
   { initialise les paramtres de travail                                   }

Procedure inidonnees;
   { charge les fichiers de donnes                                         }

Procedure inimenus;
   { initialise les paramtres de l'interface MENUS.                        }

Procedure modif_menus;
   { modifie le texte des menus en fonction des paramtres initiaux         }

Procedure iniIcones;
   { initialise les pointeurs sur les icnes                                }

Procedure inversemenus;
   { inverse MENUS LONGS/COURTS                                             }

Procedure iniaide;
   { initialise les paramtres du fichier d'aide.                           }

Procedure fin;
   { restaure l'cran texte.                                                }

Procedure lire_parametres;
   { Procedure ini_par_trv (nomf : string); }
   { initialisation des paramtres de travail                               }

Procedure ecrire_parametres (resume : boolean);
   { Enregistre les paramtres de travail en cours
                               des commentaires
        si RESUME   met  jour INFO.DIR    }

Procedure ini_par_trv (nomf : Pathstr);
   { initialisation des paramtres de travail                               }

Procedure voir_ptrav;
   { visualise la liste  complte des paramtres du travail en cours        }

Procedure inverse_pal_gris;
   { inverse la palette dgrade /points/contours/blocs                     }

Procedure inversetoutescouleurs;
   { inverse les couleurs pour afficher fond blanc                          }

{---------------------------------------------------------------------------}

IMPLEMENTATION

procedure iniIcones;
   begin
     { laide ('Lecture des Icnes en cours ...');}
      if ftxt_present (cheminmodule+nomdumodule+exticn)
      then begin
         ActiveListeIcones (cheminmodule+nomdumodule+exticn);              { ICONES }
         def_icones;
      end  else begin
         message (m_not_icones);
         halt;
      end;
    { laide ('');                                 }
   end;

procedure voir_ptrav;
   begin
      params.boite;                                                 { lipar }
      bte_compl (t_btepar, -1, -1, nbc, nbo, 0, 10);{ menu6 }
   end;

procedure ini_par_trv  (nomf : Pathstr);
   begin
      params.init (false);
      params.ajoute (Cstring  ('fichier valeurs ponctuelles', @nomfvs, 'SEISMES'));
      params.ajoute (Cstring  ('titre',                 @titre,    ''));
      params.ajoute (Cstring  ('fichier contours',      @nomfcart, ''));
      params.ajoute (Cstring  ('extension',             @extcart,  '.BLN'));
{      params.ajoute (Cboolean ('fils seuls',            @fils_seuls,  false   ));}
      fils_seuls :=  false;
      params.ajoute (Cinteger ('rayon du repere',       @ray,         40    ));
      params.ajoute (Cboolean ('inversion de l''axe z', @inversion_z, true  ));
      params.ajoute (Creal    ('echelle z initiale',    @ech_z_init,  1     ));
{      params.ajoute (Cstring  ('format zoom'      ,    @format_z,    '4:1'));   }

     { affichages divers }
      params.ajoute (Cboolean ('repre cran',          @axes_ecran  , true));
      params.ajoute (Cboolean ('bloc visible',          @visubloc    , true));
      params.ajoute (Cboolean ('contours visibles',     @visucontours, true));
      params.ajoute (Cword    ('couleur axe est',             @c_est ,    4 ));
      params.ajoute (Cword    ('couleur axe nord',            @c_nord,    5 ));
      params.ajoute (Cword    ('couleur axe ciel',            @c_ciel,    6 ));
      params.ajoute (Cword    ('couleur carte',               @c_carte,   3 ));
      params.ajoute (Cword    ('couleur titre',               @c_titr,    5 ));

     { quatrime valeur }
      rang_v := 4;   { obligatoire !! }
      params.ajoute (Creal    ('pas d''affichage V. 4',       @pasvs,     0.5 ));
      params.ajoute (Creal    ('coefficient donnes',         @coefvs,    1   ));

     { position }
      params.ajoute (Creal    ('azimut',                      @azimut,    0 ));
      params.ajoute (Creal    ('site',                        @site,     90 ));

     { commentaires associs }
      params.ajoute (Cboolean ('commentaires visibles',       @visucomm, false));
      params.ajoute (Cstring  ('nom fichier commentaires',    @nomfcomm,   '' ));

     { position : MR  = matrice de rotation courante }
      params.ajoute (Creal    ('xx', @mxx,     1 ));
      params.ajoute (Creal    ('yx', @myx,     0 ));
      params.ajoute (Creal    ('zx', @mzx,     0 ));

      params.ajoute (Creal    ('xy', @mxy,     0 ));
      params.ajoute (Creal    ('yy', @myy, 9.0949470177E-13));
      params.ajoute (Creal    ('zy', @mzy,    -1 ));

      params.ajoute (Creal    ('xz', @mxz,     0 ));
      params.ajoute (Creal    ('yz', @myz,     1 ));
      params.ajoute (Creal    ('zz', @mzz, 9.0949470177E-13));

      if ftxt_present (nomf)
      then
         params.lit (nomf);

      if unicolore
      then
         nsbloc :=  nsbloc1
      else
         if rapide
         then
            nsbloc := nsbloc4
         else
            nsbloc := nsbloc2;

      modipar      := false   ;           { modif en cours params           }
   end;

procedure ecrire_parametres (resume : boolean);
   begin
      laide (la_ecr_par);
      chain := '';
      init_v_sortie;
      params .ecrit (chain+nomfpar + extpar, datjour+ ' ' +nomutil);
      { travail en cours }

      ecrit_par_COMM  (chain+nomfcomm + extcom);             { commentaires }

      if resume
      then
         edite_info (nomfinfo, nomfpar, extpar);                { dirinfo }
      laide ('');
   end;

procedure lire_parametres;
   begin
      laide (la_lit_par);
      chain := '';
      if (maj (nomfpar) = nomdumodule)
         and not exists (nomfpar+extpar)
      then
         chain := chemindonnees;

      ini_par_TRV  (chain+nomfpar + extpar) ; { charger les paramtres de travail }

      if nomfpal  = '' then nomfpal := nomdumodule;
      if titre    = '' then titre   := maj (region);

      if nomfcomm = '' then nomfcomm := nomfpar;
      ini_par_COMM (chain+nomfcomm + extcom); { commentaires }

      laide ('');
  end;

procedure iniparam;
   var
      chem, chemp       : dirstr;
      nomf              : namestr;
      ext               : extstr;

   begin
      help_txt_enligne (paramstr (1));

      lire_utilisateur (paramstr (0));
         { nomutil=nomutil+groupe, region }

      exempl := numeromaxi (cheminexemples+region+'\*'+extpar) > 0;
      chemindonnees := chemindonnees+region+'\';

      chemp   := '';
      nomfpar := nomdumodule;
      if paramcount > 0
      then
         chemp := paramstr (1);
      if chemp <> ''                { chercher le nom du fichier de travail }
      then begin
         fsplit (chemp, chem, nomf, ext);
         nomfpar := nomf;
      end;

      { charger la configuration d'ensemble de GEOC }
      { sans deuxime paramtre : config GEOCEAN }
      { avec deuxime  si <> geocean chemin et nom ok
                       sinon         config GEOCEAN }

      chemincfg  := cheminmodule;
      nomfcfg    := nomlogiciel;

      if paramcount > 1
      then chemp := paramstr (2);

      if chemp <> ''                { chercher le nom du chemin des donnes }
      then begin
         fsplit (chemp, chem, nomf, ext);
         if (nomf <> '') and (maj (nomf) <> nomlogiciel)
         then begin
            nomfcfg := nomf;
            if chem <> ''
            then
               chemincfg := chem
         end;
      end;
      complete (chemincfg);
      ini_par_cfg (chemincfg+nomfcfg+extcfg);
      { si le fichier n'est pas trouv : paramtres par dfaut }
      { affecter rpertoire configuration graphique   }
      repbgi    := maj (getenv (NomBgi));
      if repbgi = ''
      then
         repbgi := cheminmodule;
      complete (repbgi);                       { ajoute ventuellement un \ }
   end;

procedure inversetoutescouleurs;
   var
      c                 : couleur_palette;

   begin
      for c := jaune to gris_clair
      do begin
         couleur_b [c, ecr] := 0;
      end;
      couleur_b [noir, ecr] :=  15;
      couleur_b [bleu, ecr] :=  15;
      couleur_b [blanc, ecr] :=  0;
   end;

procedure inverse_pal_gris;
   var
      i                 : integer;

   begin
      for i := 6 downto 0
      do
         SetRGBPalette (14-i, 10+8*i, 10+8*i, 10+8*i);
   end;

procedure inverse_palette;
   var
      i, c              : integer;

   begin
      c := 3;
      if maxcolor <= 2
      then begin
         if maxcolor = 2
         then
            c := 1
         else
            c := 0;
         coulboite := 15-15*c;
         coulecran := 15-15*c;
         c_icone   := 15-15*c;
 {        couleur_b [noir, ecr] := 0;}
      end else begin
         coulboite := 15;
         coulecran := 11;
         c_icone   :=  9;
{         couleur_b [noir, ecr] := 15;}
      end;
      if c <> 1
      then
         for i := 6 downto 0
         do
            SetRGBPalette (14-i, 10+8*i, 10+8*i, 10+8*i);
   end;

procedure inipalette;
   var
      i                 : integer;

   begin
      fcouleur (1, 0, 0, 0);
      { rechercher la palette  }
      if ftxt_present (cheminmodule+nomfpal+extpal)
      then
         chargepalette (cheminmodule+nomfpal+extpal, ok)             { graphism }
      else
         for i := 8 to 14
         do
            SetRGBPalette (i, 10+8*(i-8), 10+8*(i-8), 10+8*(i-8));
      coulboite  :=  0;
      coulecran  := 11;
      c_icone    := 13;
   end;

procedure iniparam2;
   var
      chem, chemp    : dirstr;
      nomf           : namestr;
      ext            : extstr;

   begin
      lire_parametres;
      inipalette;
      fini     := false;
      prof     := false;
   end;

procedure chang_contours;
   var
      d                 : dirstr;
      n                 : namestr;
      e                 : extstr;

{      nomf              : t12;       }

   begin
      dir_info                                                    { dirinfo }
         (Donnees_ini,
          '',
          choix_Contour,
          chemindonnees+nomfinfod, '*', extcart, chain{nomf});
      fsplit (chain, d, n, e );
   {   extcart  := extension (nomf);
      nomf     := sansext (nomf);
      nomfcart := nomf;
      if nomfcart = ''              }
      if n = ''
      then
         visucontours := false;
      nomfcart := n;
      extcart  := e;
   end;

procedure inidonnees;
   begin
      { charger les valeurs  reprsenter }
      ini_par_SYMBd    (chemindonnees+nomfvs+extps);  { libells colonnes }

      if not ftxt_present (chemindonnees+nomfvs+extvs)
      then
         change_points;

      if maj (copy (nomfvs, 1, 4)) = 'VOLC'
      then
         inversion_z := false;

      { charger le fichier contours     }
      if not ftxt_present (chemindonnees+nomfcart+extcart)
      then
         chang_contours;

      bln := (maj (extcart) = extbln) or (maj (extcart) = extblf);
      coefblz := 1 / 100;

      laide (La_lit_points);
      lecture_fichier (ok) ;
      laide ('');
      if not ok
      then begin
         message (M_not_memoire);
         finir;
         halt
      end;
   end;

procedure inimenus_prof;
   begin
      textemenufichierprof;
   end;

procedure inimenus_eleve;
   begin
      textemenufichier;

      textemenu (2,  1, nomu_nuag, '');
{      textemenu (2,  2, txt_mnu22, txt_mnu22a );}

      textemenu (2,  5, txt_mnu25, txt_mnu25a);

      textemenu (3,  2, txt_mnu32, txt_mnu32a);

      textemenu (3,  3, txt_mnu33, txt_mnu33a);
   end;

procedure modif_menus;
   begin
      if ((nomfpar <> nomdumodule) or prof)
      then
         active (1, 4, true)
      else
         active (1, 4, false);

      if exempl        { sans bascule }
      then begin
         active (1,  2, false);
         active (1,  4, false);
         active (1,  5, false);
         active (1, 10, false);
         active (1, 11, false);
         active (3,  2, false);
      end;

      if visucomm
      then begin
         textemenu (4,  2, coche+' '+txt_mnu42, txt_mnu42a);
         active (3, 2, true);
         Dessiner_Commentaires (false, true, false);
      end else begin
         textemenu (4,  2,      '  '+txt_mnu42, txt_mnu42b);
         active (3, 2, false);
      end;

      if axes_ecran
      then begin
         textemenu (2,  2, coche+' '+txt_mnu22, txt_mnu22a);
      end else begin
         textemenu (2,  2,      '  '+txt_mnu22, txt_mnu22b);
      end;

      if visubloc
      then begin
         textemenu (4,  4, coche+' '+txt_mnu44, txt_mnu44a
                           );
         marquericone (17, c_nord);
      end else begin
         textemenu (4,  4,      '  '+txt_mnu44, txt_mnu44b
                           );
         demarquericone (17);
      end;

      if visucontours
      then begin
         textemenu (4,  5, coche+' '+txt_mnu45, txt_mnu45a);
         marquericone (18, c_nord);
      end else begin
         textemenu (4,  5,      '  '+txt_mnu45, txt_mnu45b);
         demarquericone (18);
      end;
      if nomfcart = ''
      then
         inactive_icone (18);

      if annotations^.count = 0
      then begin
         visucomm := false;  { pour permettre la cration du premier lment }
         active (3 , 2, true);
      end;
      ini_titre;
      modif_menu_cfg; { modifie le menu SORTIES }
   end;

procedure inimenus;
   begin
      ini_menu      (repbgi, pol_menu);                             { menus }
      posxbtn    := 541;
      chargepalette (repbgi+nomdumodule + extpal, ok);                  { graphism }
      coulboite  :=  0;
      coulecran  := 11;
      c_icone    := 13;
      fondaide   := 11;
      txtnon     := 11;
      setcoulmenu   (fondmenu, txtmenu, txtnorm, txtnon,
                     txtoui,  fondnorm, fondoui, fondaide);
      inimenus_eleve;
      if prof
      then
         inimenus_prof;
   end;

procedure inversemenus;
   begin
      if not prof
      then
         inimenus_prof
      else begin
         initmenus;                                                { menus1 }
         inimenus_eleve;
      end;
      prof := not prof;
   end;

procedure iniaide;
   begin
      initaide (cheminmodule+nomdumodule + exthlp, ok);                         { menus6 }
   end;

procedure fin;
   begin
      finir;                                                          { des }
   end;


END.

{--- GEOCEAN - NUAG_INI ---------------------- R.C.- INRP - TOULOUSE - 1995 }
