UNIT POLYGON;

{---------------------------------------------------------------------------}
{         bibliothque                                                      }
{                          Gestion objets graphiques                        }
{                                                               10/06/94    }
{---------------------------------------------------------------------------}
(*
   Polygon,                  { ARX     - gestion des objets graphiques      }
*)
{---------------------------------------------------------------------------}

{$O+,F+}

INTERFACE

USES
   Objects,
   graph,                    { TP 70   - units  standard                   }
   GraphPlt;                 { ARX     - graphisme 2D cran/traceur         }

TYPE
   {------------------------------------------------------------------------}
   PObjetGraphique = ^TObjetGraphique;
   TObjetGraphique = Object (TObject) { N 499 }
      x, y : real;
      constructor Init;
      constructor Load (var S : TStream);
      destructor Done; virtual;
      procedure Store (var S : TStream);
      procedure Dessiner; virtual;
      procedure Peindre; virtual;
      procedure Marquer; virtual;
      function XMax : real; virtual;
      function XMin : real; virtual;
      function YMax : real; virtual;
      function YMin : real; virtual;
   end;

   { Objet point }
   PPoint = ^TPoint;   { Recensement N 500 }
   TPoint = object (TObjetGraphique)
      constructor Init;
      constructor Load (var S : TStream);
      procedure Store (var S : TStream);
      procedure Dessiner; virtual;
      procedure Peindre; virtual;
      procedure TraceVers;
      procedure DeplaceEn;
      destructor fini;
   end;

   {------------------------------------------------------------------------}
   { Objet ligne ouverte }
   PLigne = ^TLigne;     { Recensement N 506 }
   TLigne = object(TObjetGraphique)
      Nom            {}
                     : string;
      XMini, XMaxi,  {}
      YMini, YMaxi   {}
                     : real;
      Contour     { Collection de PPoint }
                  : TCollection;
      Longueur    { Longueur totale (cumul des segments) }
                  : real;

      constructor Init (LeNom : string);
      constructor load  (var S : TStream);
      procedure Store (var S : TStream);

      procedure insert (Item : PPoint);
      procedure atinsert (Index : integer ; Item : PPoint);
      function at (Index : integer) : PPoint;
      function IndexOf (Item : PPoint) : integer;
      function Count : integer;
      procedure AtDelete (Index : integer);

      procedure   Borner;
      function    DroiteCoupe  (Point1, Point2 : PPoint) : boolean;
      function    SegmentCoupe (Point1, Point2 : PPoint; var xx, yy : real)
                  : boolean;
      procedure Dessiner; virtual;
      procedure Peindre; virtual;
      function XMax : real; virtual;
      function XMin : real; virtual;
      function YMax : real; virtual;
      function YMin : real; virtual;
      destructor  fini;
   end;


   {------------------------------------------------------------------------}
   { Objet polygone }
   PPoly = ^TPoly;     { N 506 }
   TPoly = object(TLigne)
      Surface                      { Surface du polygone }
                  : real;

      constructor Init;
      constructor load  (var S : TStream);
      procedure   Store (var S : TStream);
      function    Angle (Point1 : PPoint) : real;
      Function    SommeAngles : real;
      procedure   Borner;
      procedure   Orienter;
      function    Contient     (xx, yy : real) : boolean;
      function    Aligne (xx, yy : real): boolean;
      function    DroiteCoupe  (Point1, Point2 : PPoint) : boolean;
      function    SegmentCoupe (Point1, Point2 : PPoint; var xx, yy : real)
                  : boolean;
      function    PolygoneCoupe (Poly : PPoly) : boolean;
      procedure   CalcSurface;
      procedure   Peindre; virtual;
      procedure   Dessiner; virtual;
      destructor  fini;
   end;

type
   { Dclaration des types de procdures redfinissables. }
   TTraceVers     = Procedure (x, y : real);
   TDeplaceEn     = Procedure (x, y : real);
   TPolygonePlein = Procedure (n : integer; var p : graphplt.polygone);

const
   Epsilon  = 1.2345E-30;
   Epsilon2 = 5.4321E-30;


procedure Recensement;
   {------------------------------------------------------------------------}
   { ROLE Recenser les objets pour la gestion de flux.                      }
   {------------------------------------------------------------------------}

procedure DefTraceVers (PTraceVers : TTraceVers);
   {------------------------------------------------------------------------}
   { ROLE Dfinir la procdure de trac utilise dans l'objet Point.        }
   {------------------------------------------------------------------------}

procedure DefDeplaceEn (PDeplaceEn : TDeplaceEn);
   {------------------------------------------------------------------------}
   { ROLE Dfinir la procdure de trac utilise dans l'objet Point.        }
   {------------------------------------------------------------------------}

procedure DefPolygonePlein (PPolygonePlein : TPolygonePlein);
   {------------------------------------------------------------------------}
   { ROLE Dfinir la procdure de dessin de polygone utilise dans l'objet  }
   {  MODELE.                                                               }
   {------------------------------------------------------------------------}

function secants (x1,y1,xx1,yy1, x2, y2, xx2, yy2 : real; var x, y : real)
         : boolean;

function AngleR (x1, y1, x2, y2, x3, y3 : real) : real;

function coupe (x1, y1, xx1, yy1, x2, y2, xx2, yy2 : real) : boolean;

IMPLEMENTATION
{=========================================================================}

const

   {* DEFINITION DES CONSTANTES DE RECENSEMENT }
   RObjetGraphique : TStreamRec = (
      ObjType : 499;
      VmtLink : Ofs (TypeOf(TObjetGraphique)^);
      Load  : @TObjetGraphique.Load;
      Store : @TObjetGraphique.Store );

   RPoint : TStreamRec = (
      ObjType : 500;
      VmtLink : Ofs (TypeOf(TPoint)^);
      Load  : @TPoint.Load;
      Store : @TPoint.Store );

   RLigne : TStreamRec = (
      ObjType : 517;
      VmtLink : Ofs (TypeOf(TLigne)^);
      Load  : @TLigne.Load;
      Store : @TLigne.Store );

   RPoly : TStreamRec = (
      ObjType : 506;
      VmtLink : Ofs (TypeOf(TPoly)^);
      Load  : @TPoly.Load;
      Store : @TPoly.Store );

var
   { Variables pointant sur les procdures de trac redfinissables. }
   { Pointent sur des procdures locales vides au dpart.            }
   VTraceVers : TTraceVers;
   VDeplaceEn : TDeplaceEn;
   VPolygonePlein : TPolygonePlein;
   texte2,
   texte : string;

procedure Recensement;
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
begin
   RegisterType (RObjetGraphique);
   RegisterType (RPoint);
   RegisterType (RLigne);
   RegisterType (RPoly);
end;

procedure DefTraceVers (PTraceVers : TTraceVers);
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
begin
   VTraceVers := PTraceVers;
end;

procedure DefDeplaceEn (PDeplaceEn : TDeplaceEn);
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
begin
   VDeplaceEn := PDeplaceEn;
end;

procedure DefPolygonePlein (PPolygonePlein : TPolygonePlein);
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
begin
   VPolygonePlein := PPolygonePlein;
end;

procedure  TraceVersNul (x, y : real); far;
{-------------------------------------------------------------------------}
{ ROLE C'est la procdure vide affecte par dfaut  TraceVers.           }
{-------------------------------------------------------------------------}
begin end;

procedure  DeplaceEnNul (x, y : real); far;
{-------------------------------------------------------------------------}
{ ROLE C'est la procdure vide affecte par dfaut  DeplaceEn.           }
{-------------------------------------------------------------------------}
begin end;

procedure  PolygonePleinNul (n : integer; var p : polygone); far;
{-------------------------------------------------------------------------}
{ ROLE C'est la procdure vide affecte par dfaut  PolygonePlein.       }
{-------------------------------------------------------------------------}
begin end;

function secants (x1,y1,xx1,yy1, x2, y2, xx2, yy2 : real; var x, y : real)
         : boolean;
{-------------------------------------------------------------------------}
{ ROLE tester si les segments 1 et 2 sont squents.                       }
{-------------------------------------------------------------------------}
   var
      Sec : boolean;
      a1, b1, a2, b2    : real;  {Cof. pour les quations de droites }

   begin
      Secants := false;

      {* si un segment est  droite ou  gauche de l'autre, fini }
      if ((x1<=x2) and (x1<=xx2) and (xx1<=x2) and (xx1< xx2)) or
         ((x1>=x2) and (x1>=xx2) and (xx1>=x2) and (xx1> xx2))
      then exit;

      {* si un segment est au dessus ou au dessous de l'autre, fini }
      if ((y1<=y2) and (y1<=yy2) and (yy1<=y2) and (yy1< yy2)) or
         ((y1>=y2) and (y1>=yy2) and (yy1>=y2) and (yy1> yy2))
      then exit;

      {* si deux points sont confondus, les segments ne sont pas sq. }
      if ((x1 =xx1) and (y1 =yy1)) or ((x1 =x2 ) and (y1 =y2 )) or
         ((x1 =xx2) and (y1 =yy2)) or ((xx1=x2 ) and (yy1=y2 )) or
         ((xx1=xx2) and (yy1=yy2)) or ((x2 =xx2) and (y2 =yy2))
      then exit;

      if (xx1=x1) then begin
         a2 := (yy2-y2)/(xx2-x2);
         b2 := y2-a2*x2;
         Secants :=  (    ( (y1  > a2*x1+b2) xor (yy1 > a2*xx1+b2) )
                 and ( (x2  < x1      ) xor (xx2 < x1       ) )  );
         x := x1;
         y := b2+a2*x;
         exit;
      end;

      if (xx2=x2) then begin
         a1 := (yy1-y1)/(xx1-x1);
         b1 := y1-a1*x1;
         Secants := (((y2 > a1*x2+b1) xor (yy2 > a1*xx2+b1))
                and ((x1 < x2) xor (xx1 < x2)));
         x := x2;
         y := b1+a1*x;
         exit;
      end;

      a1 := (yy1-y1)/(xx1-x1);
      b1 := y1-a1*x1;
      a2 := (yy2-y2)/(xx2-x2);
      b2 := y2-a2*x2;
      if a1=a2 then sec := false
      else begin
         Sec := (((y2  > a1*x2+b1) xor (yy2 > a1*xx2+b1))
                 and ((y1  > a2*x1+b2) xor (yy1 > a2*xx1+b2)));
         if Sec then begin
            if a2 = 0 then y := y2
            else y := ((-a1*b2/a2)+(b1))/(1-a1/a2);
            if a1 = 0
            then x := (y-b2)/a2
            else x := (y-b1)/a1;
         end;
      end;
      Secants := Sec;
   end;

function coupe (x1, y1, xx1, yy1, x2, y2, xx2, yy2 : real) : boolean;
{-------------------------------------------------------------------------}
{ ROLE Tester si la droite 1 est coupe par le segment 2.                 }
{-------------------------------------------------------------------------}
   var
      a1, b1    : real;     { Cof. pour quation de droite }
      coup      : boolean;  { }

   begin
      Coup := false;

      {* si deux points sont confondus, les segments ne sont pas sq. }
      if not (((x1=xx1) and (y1=yy1)) or ((x1=x2 ) and (y1=y2 )) or
         ((x1=xx2) and (y1=yy2)) or ((xx1=x2 ) and (yy1=y2 )) or
         ((xx1=xx2) and (yy1=yy2)) or ((x2=xx2) and (y2=yy2)))
      then begin
         x2 := x2+epsilon;
         xx2 := xx2+epsilon;
         y2 := y2-epsilon2;
         yy2 := yy2-epsilon2;
         if xx1=x1 then begin
            Coup :=  ( (x2 < x1) xor (xx2 < x1) );
         end else begin
            a1 := (yy1-y1)/(xx1-x1);
            b1 := y1-a1*x1;
            Coup := ((y2  > a1*x2+b1) xor (yy2 > a1*xx2+b1));
         end;
      end;
      coupe := coup;
   end;

function AngleR (x1, y1, x2, y2, x3, y3 : real) : real;
{--------------------------------------------------------------------}
{ ROLE Calculer l'angle en radian entre les deux segments dfinis    }
{    par trois points.                                               }
{--------------------------------------------------------------------}
var
   dx1, dy1,    {}
   dx2, dy2,    {}
   alpha, beta, {}
   A            {}
                : real;
   texte : string;

begin
   dx1 := x2-x1;
   dy1 := y2-y1;
   dx2 := x3-x2;
   dy2 := y3-y2;

   if dx1=0 then alpha:=(abs(dy1)/dy1) * (pi/2)
            else alpha:=ArcTan (dy1/dx1);
   if dx1<0 then alpha := pi+alpha;
   if dx2=0 then beta:=(abs(dy2)/dy2) * (pi/2)
            else beta:=ArcTan (dy2/dx2);
   if dx2<0 then beta := pi+beta;
   A := beta-alpha;
   if A > Pi then A := -2*Pi+A
   else if A <= -Pi then A := 2*Pi+A;
   AngleR := A;
end;

constructor TObjetGraphique.Init;
{-------------------------------------------------------------------------}
{ ROLE Initialiser l'objet.                                               }
{-------------------------------------------------------------------------}
begin
   TObject.Init;
   x := 0;
   y := 0;
end;

constructor TObjetGraphique.Load (var S : TStream);
{-------------------------------------------------------------------------}
{ ROLE Charger l'objet  partir du flux S.                                }
{-------------------------------------------------------------------------}
begin
   TObject.Init;
   S.read (x, sizeof (x));
   S.read (y, sizeof (y));
end;

procedure TObjetGraphique.Store (var S : TStream);
{-------------------------------------------------------------------------}
{ ROLE Sauver l'objet dans le flux S.                                     }
{-------------------------------------------------------------------------}
begin
   {* SAUVEGARDE DES DONNEES DE L'OBJET }
   S.write (x, sizeof (x));
   S.write (y, sizeof (y));
end;

procedure TObjetGraphique.Dessiner;
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
begin
end;

procedure TObjetGraphique.Peindre;
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
begin
end;

procedure TObjetGraphique.Marquer;
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
begin
end;

function TObjetGraphique.XMax : real;
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
begin
   XMax := x;
end;

function TObjetGraphique.XMin : real;
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
begin
   XMin := x;
end;

function TObjetGraphique.YMax : real;
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
begin
   YMax := y;
end;

function TObjetGraphique.YMin : real;
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
begin
   YMin := y;
end;

destructor TObjetGraphique.done;
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
begin
   TObject.Done;
end;

constructor TPoint.Init;
{-------------------------------------------------------------------------}
{ ROLE Initialiser l'objet.                                               }
{-------------------------------------------------------------------------}
begin
   TObjetGraphique.Init;
end;

constructor TPoint.Load (var S : TStream);
{-------------------------------------------------------------------------}
{ ROLE Charger l'objet  partir du flux S.                                }
{-------------------------------------------------------------------------}
begin
   TObjetGraphique.Load (S);
end;

procedure TPoint.Store (var S : TStream);
{-------------------------------------------------------------------------}
{ ROLE Sauver l'objet dans le flux S.                                     }
{-------------------------------------------------------------------------}
begin
   TObjetGraphique.Store (S);
end;

procedure   TPoint.TraceVers;
{-------------------------------------------------------------------------}
{ ROLE Executer la procedure pointe par la variable VTraceVers.          }
{    Au dpart, cette variable pointe sur une procdure locale vide.      }
{-------------------------------------------------------------------------}
begin
   VTraceVers (x, y);
end;

procedure TPoint.DeplaceEn;
{-------------------------------------------------------------------------}
{ ROLE Executer la procedure pointe par la variable VDeplaceEn.          }
{    Au dpart, cette variable pointe sur une procdure locale vide.      }
{-------------------------------------------------------------------------}
begin
   VDeplaceEn (x, y);
end;

procedure TPoint.Dessiner;
{-------------------------------------------------------------------------}
{ ROLE Executer la procedure pointe par la variable VDeplaceEn.          }
{    Au dpart, cette variable pointe sur une procdure locale vide.      }
{-------------------------------------------------------------------------}
begin
   DeplaceEn;
   TraceVers;
end;

procedure TPoint.Peindre;
{-------------------------------------------------------------------------}
{ ROLE Executer la procedure pointe par la variable VDeplaceEn.          }
{    Au dpart, cette variable pointe sur une procdure locale vide.      }
{-------------------------------------------------------------------------}
begin
   Dessiner;
end;

destructor TPoint.Fini;
{-------------------------------------------------------------------------}
{ ROLE Dtruire l'objet, liberer la mmoire (le tas).                     }
{-------------------------------------------------------------------------}
begin
   TObjetGraphique.done;
end;

constructor TLigne.Init;
{-------------------------------------------------------------------------}
{ ROLE Initialiser l'objet.                                               }
{-------------------------------------------------------------------------}
var
   i : integer;

begin
   {* INITIALISATION DE L'ANCETRE }
   TObjetGraphique.Init;
   Nom := LeNom;
   Xmini := 0;   Xmaxi := 0;
   Ymini := 0;   Ymaxi := 0;
   Contour.Init (10, 10);
   {* INITIALISATION DES VALEURS }
   Longueur := 0;
end;

constructor TLigne.load (var S : TStream);
{-------------------------------------------------------------------------}
{ ROLE Charger l'objet  partir du flux S.                                }
{-------------------------------------------------------------------------}
begin
   TObjetGraphique.Load (S);
   S.read (Nom, sizeof (Nom));
   S.read (Xmini, sizeof (Xmini));
   S.read (Xmaxi, sizeof (Xmaxi));
   S.read (Ymini, sizeof (Ymini));
   S.read (Ymaxi, sizeof (Ymaxi));
   Contour.Load (S);
   {* LECTURE DES DONNEES PROPRES A L'OBJET }
   S.read (Longueur, sizeof (Longueur));
end;

procedure  TLigne.Store (var S : TStream);
{-------------------------------------------------------------------------}
{ ROLE Sauver l'objet dans le flux S.                                     }
{-------------------------------------------------------------------------}
begin
   TObjetGraphique.Store (S);
   S.write (Nom, sizeof (Nom));
   S.write (Xmini, sizeof (Xmini));
   S.write (Xmaxi, sizeof (Xmaxi));
   S.write (Ymini, sizeof (Ymini));
   S.write (Ymaxi, sizeof (Ymaxi));
   Contour.Store (S);
   {* SAUVEGARDE DES DONNEES }
   S.write (Longueur, sizeof (Longueur));
end;

procedure TLigne.insert (Item : PPoint);
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
begin
   Contour.insert (Item);
end;

procedure TLigne.atinsert;
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
begin
   Contour.atinsert (Index, Item);
end;

function TLigne.at (Index : integer) : PPoint;
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
var p : PPoint;
begin
   p := Contour.at (Index);
   at := Contour.at (Index);
end;

function TLigne.IndexOf (Item : PPoint) : integer;
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
begin
   IndexOf := Contour.IndexOf (Item);
end;

function TLigne.count : integer;
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
begin
   count := Contour.count;
end;

procedure TLigne.AtDelete (Index : integer);
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
begin
   Contour.AtDelete (Index);
end;

procedure TLigne.Borner;
{-------------------------------------------------------------------------}
{ ROLE Determiner les coordonnes limites du troupeau, le centre de grav.,}
{    calculer la surface, la longueur.                                    }
{-------------------------------------------------------------------------}
   procedure MaxiMini (P : PPoint); far;
   {----------------------------------------------------------------------}
   { ROLE Mettre  jour les limites si le point test est en dehors.      }
   {    La procdure est dclare FAR car elle est appele par ForEach.   }
   {----------------------------------------------------------------------}
   begin
      if P^.x > xmax then xmaxi := P^.x;
      if P^.x < xmin then xmini := P^.x;
      if P^.y > ymax then ymaxi := P^.y;
      if P^.y < ymin then ymini := P^.y;
   end;

   function d (P1, P2 : PPoint) : real;
   {----------------------------------------------------------------------}
   { ROLE Calculer la distance entre le point P1 et le point P2.          }
   {----------------------------------------------------------------------}
   var
      dx, dy : real;
   begin
      dx := P2^.x-P1^.x;
      dx := dx * dx;
      dy := P2^.y-P1^.y;
      dy := dy * dy;
      d := sqrt ( dx + dy );
   end;

var
   i                      : integer;
   sp, p                  : real;
   PointA, PointB         : PPoint;

begin
   {* RECHERCHE DES COORDONNEES MINI ET MAXI }
   PointA := at (0);
   xmaxi := PointA^.x;
   xmini := xmaxi;
   ymaxi := PointA^.y;
   ymini := ymaxi;
   Contour.ForEach (@MaxiMini);

   {* CALCUL DU CENTRE DE GRAVITE ET DE LA LONGUEUR }
   {* Chaque milieu d'un segment  un poids fonction de la long. du seg.  }

   x := 0;
   y := 0;
   sp := 0;
   Longueur := 0;

   for i:=0 to count-1 do begin
      PointA := at (i);
      PointB := at ((i+1) mod count);
      p := d (PointA, PointB)/100;
      Longueur := Longueur + ( sqrt ( sqr(PointB^.x - PointA^.x) +
                                      sqr (PointB^.y - PointA^.y)
                                    )
                             );
      sp := sp+p;
      x := x + ((PointA^.x + PointB^.x)/2) * p;
      y := y + ((PointA^.y + PointB^.y)/2) * p;
   end;
   x := x/sp;
   y := y/sp;
end;

function TLigne.SegmentCoupe (Point1, Point2: PPoint; var xx, yy : real)
         : boolean;
{-------------------------------------------------------------------------}
{ ROLE Tester si le segment coupe le polygone et renvoyer les coordonnes }
{    de la premire intersection trouve.                                 }
{ ENTREE                                                                  }
{-------------------------------------------------------------------------}
var
   Coup                  : boolean;
   Point, PointA, PointB : PPoint;
   i                     : integer;

begin
   Coup := false;
   for i := 0 to count-2 do begin
      PointA := at (i);
      PointB := at (i+1);

      Coup := Secants (Point1^.x, Point1^.y, Point2^.x, Point2^.y,
                  PointA^.x, PointA^.y, PointB^.x, PointB^.y, xx, yy);

      if Coup then begin
         SegmentCoupe := Coup;
         exit;
      end;

   end;
   Segmentcoupe := Coup;
end;

function TLigne.DroiteCoupe (Point1, Point2: PPoint) : boolean;
{-------------------------------------------------------------------------}
{ ROLE }
{-------------------------------------------------------------------------}
var
   Coup                  : boolean;
   PointA, PointB        : PPoint;
   i                     : integer;

begin
   DroiteCoupe := false;
   for i := 0 to count-2 do begin
      PointA := at (i);
      PointB := at (i+1);

      Coup := Coupe   (Point1^.x, Point1^.y, Point2^.x, Point2^.y,
                       PointA^.x, PointA^.y, PointB^.x, PointB^.y);

      if Coup then begin
         DroiteCoupe := true;
         exit;
      end;

   end;
end;

procedure TLigne.Dessiner;
{-------------------------------------------------------------------------}
{ ROLE }
{-------------------------------------------------------------------------}
var
   Point1 : PPoint;

   procedure AppelTraceVers (P : PPoint); far;
   {----------------------------------------------------------------------}
   {----------------------------------------------------------------------}
   begin
      P^.TraceVers;
   end;

begin
   Point1 := at (0);
   if Point1 <> NIL
   then begin
      Point1^.DeplaceEn;
      Contour.ForEach (@AppelTraceVers);
   end;
end;

procedure TLigne.Peindre;
{-------------------------------------------------------------------------}
{ ROLE }
{-------------------------------------------------------------------------}
begin
   Dessiner;
end;

function TLigne.XMax : real;
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
begin
   XMax := XMaxi;
end;

function TLigne.XMin : real;
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
begin
   XMin := XMini;
end;

function TLigne.YMax : real;
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
begin
   YMax := YMaxi;
end;

function TLigne.YMin : real;
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
begin
   YMin := YMini;
end;

destructor TLigne.Fini;
{-------------------------------------------------------------------------}
{ ROLE Dtruire l'objet, liberer la mmoire (le tas).                     }
{-------------------------------------------------------------------------}
begin
   Contour.done;
   TObjetGraphique.Done;
end;



{=========================================================================}

constructor TPoly.Init;
{-------------------------------------------------------------------------}
{ ROLE Initialiser l'objet.                                               }
{-------------------------------------------------------------------------}
var
   i : integer;

begin
   {* INITIALISATION DE L'ANCETRE }
   TLigne.Init ('');
   {* INITIALISATION DES VALEURS }
   Surface := 0;
end;

constructor TPoly.load (var S : TStream);
{-------------------------------------------------------------------------}
{ ROLE Charger l'objet  partir du flux S.                                }
{-------------------------------------------------------------------------}
begin
   {* LECTURE DE L'ANCETRE }
   TLigne.Load (S);
   {* LECTURE DES DONNEES PROPRES A L'OBJET }
   S.read (Surface, sizeof (Surface));
end;

procedure  TPoly.Store (var S : TStream);
{-------------------------------------------------------------------------}
{ ROLE Sauver l'objet dans le flux S.                                     }
{-------------------------------------------------------------------------}
begin
   {* SAUVEGARDE DE L'ANCETRE }
   TLigne.Store (S);
   {* SAUVEGARDE DES DONNEES }
   S.write (Surface, sizeof (Surface));
end;

function TPoly.Angle (Point1 : PPoint) : real;
{--------------------------------------------------------------------}
{ ROLE Calculer l'angle en radian entre les deux segments dfinis    }
{    par trois points. (P et les deux suivants)                      }
{--------------------------------------------------------------------}
var
   Point2, Point3                   : PPoint;
   NumPoint1, NumPoint2, NumPoint3  : integer;

begin
   NumPoint1 := indexof (Point1);
   NumPoint2 := (NumPoint1+1) mod count;
   NumPoint3 := (NumPoint2+1) mod count;

   Point2 := at (NumPoint2);
   Point3 := at (NumPoint3);

   Angle := AngleR ( Point1^.x, Point1^.y,
                     Point2^.x, Point2^.y,
                     Point3^.x, Point3^.y );
end;

Function TPoly.SommeAngles : real;
{--------------------------------------------------------------------}
{ ROLE Retourner la somme des angles que forment chaque segment.     }
{    2*pi -> le polygone est dans le sens trigonomtrique,           }
{    -2*pi -> le poygone est dans l'autre sens.                      }
{--------------------------------------------------------------------}
var
   NumPoint : integer;  { N du point test }
   P        : PPoint;   { Point test }
   S        : real;     { Somme des angles }

begin
   S :=0;
   for NumPoint := 0 to count-1 do begin
      P := at (NumPoint);
      S := S + Angle (P);
   end;
   SommeAngles := S;
end;

procedure TPoly.Orienter;
{--------------------------------------------------------------------}
{ ROLE Inverser l'ordre des points si le polygone n'est pas dans le  }
{    sens trigonomtrique.                                           }
{--------------------------------------------------------------------}
var
   NumPoint,    { N du point test }
   N            { Nombre de points }
                : integer;

begin
   {* SI LA SOMME DES ANGLES EST NEGATIVE ALORS }
   if SommeAngles < 0 then begin
      N := count;

      {* DUPLICATION DES POINTS EN PARTANT DU DERNIER ET EN INSERANT }
      {* EN FIN (INVERSION)                                          }
      for NumPoint := N-1 downto 0 do
         Insert (at (NumPoint));

      {* DESTRUCTION DE LA PREMIERE MOITIE }
      for NumPoint := 1 to N do
         AtDelete (0);
   end;
end;

procedure TPoly.Borner;
{-------------------------------------------------------------------------}
{-------------------------------------------------------------------------}
var
   PointA, PointB         : PPoint;

begin
   TLigne.Borner;
   {* RAMENER LE POINT LE PLUS A GAUCHE EN PREMIERE POSITION }
   PointA := at (0);
   while (PointA^.x <> xmin) do begin
      insert (PointA);
      AtDelete (0);
      PointA := at (0);
   end;
end;

function TPoly.Aligne (xx, yy : real): boolean;
{-------------------------------------------------------------------------}
{ ROLE Retourner vrai si le point (x, y) est align avec un des segments. }
{-------------------------------------------------------------------------}
var
   a, b   : real;     { quation de droite }
   i      : integer;  { compteur }
   Ali    : boolean;  { Aligne local }
   p1, p2 : PPoint;   { segment test }

begin
   Aligne := false;
   {* POUR CHAQUE POINT }
   for i:=0 to count-1 do begin
      p1 := at (i);
      p2 := at ((i+1) mod count);

      {* SI POINTS CONFONDUS, ALIGNEMENT VRAI }
      if ((p1^.x = xx) and (p1^.y = yy)) or
         ((p2^.x = xx) and (p2^.y = yy))
      then begin
         Aligne := true;
         exit;
      end;

      {* CAS DU SEGMENT VERTICAL }
      if (p1^.x = p2^.x) then
         Ali := (xx = p1^.x)
      else
      {* CAS DU SEGMENT HORIZONTAL }
      if (p1^.y = p2^.y) then
         Ali := (yy = p1^.y)
      else begin
      {* CAS GENERAL }
         a := (p2^.y-p1^.y)/(p2^.x-p1^.x);
         b := p1^.y-a*p1^.x;
         Ali := (yy = a*xx+b);
      end;
      if Ali then begin
         Aligne := true;
         exit;
      end;
   end;
end;

function TPoly.Contient (xx, yy : real): boolean;
{-------------------------------------------------------------------------}
{ ROLE Retourner vrai si le point (x, y) appartient au polygone, bords    }
{    exclus.                                                              }
{ ENTREE x, y : rels, coordonnes du point test.                        }
{ PRINCIPE On calcule le segment form par le point (x, y) et un point    }
{    extrieur. On compte le nombre d'intersections entre ce segment      }
{    et le polygone, si la valeur est impaire, le point est inclus.       }
{    Le point extrieur est un point  la verticale de (x, y) et avec une }
{    ordonne gale  l'ordonne minimale du polygone - 1 (dehors).       }
{-------------------------------------------------------------------------}
var
   PointA, PointB { segment du polygone test }
                  : PPoint;
   i, ni          { compteur - nombre d'intersections }
                  : integer;
   Secants        { }
                  : boolean;
   ax, bx,        { coordonnes temporaires }
   a2, b2         { quation de droite }
                  : real;

begin
   Contient := false;
   {* SI LE POLYGONE A DES POINTS (permet de faire le test sur un poly.
      en construction, sinon erreur). }
   if count > 0 then begin
      ni     := 0;
      {* POUR CHAQUE SEGMENT }
      for i := 0 to count-1 do begin
         PointA := at (i);
         PointB := at ((i+1) mod count);
         {* ajout de epsilon pour viter les cas de points aligns }
         Ax     := PointA^.x + epsilon;
         Bx := PointB^.x + epsilon2;

         {* SI UN POINT DE CHAQUE COTE DE X (optimisation) }
         if ((Ax > xx) xor (Bx > xx)) then begin
            Secants := false;

            {* SI POINTS NON CONFONDUS }
            if not (((xx =Ax ) and  (yy =PointA^.y )) or
               ((xx =bx) and  (yy =pointb^.y))
                or ((ax =bx) and (pointa^.y =pointb^.y)))
            then begin
               {* SEGMENT SECANTS FONCTION DE L'EQUATION DE DROITE }
               a2 := (pointb^.y-pointa^.y)/(bx-ax);
               b2 := pointa^.y-a2*ax;
               Secants :=  (yy  > a2*xx+b2);
            end;

            {* SI SECANTS, INCREMENTER Nb D'INTERSECTIONS }
            if Secants then inc (ni);

         end;
      end;

      {* Contient si Nb Intersections impair }
      Contient := (Ni mod 2) = 1;

   end;
end;

function TPoly.SegmentCoupe (Point1, Point2: PPoint; var xx, yy : real)
         : boolean;
{-------------------------------------------------------------------------}
{ ROLE Tester si le segment coupe le polygone et renvoyer les coordonnes }
{    de la premire intersection trouve.                                 }
{ ENTREE                                                                  }
{-------------------------------------------------------------------------}
var
   Coup                  : boolean;
   Point, PointA, PointB : PPoint;
   i                     : integer;

begin
   Coup := false;
   for i := 0 to count-1 do begin
      PointA := at (i);
      PointB := at ((i+1) mod count);

      Coup := Secants (Point1^.x, Point1^.y, Point2^.x, Point2^.y,
                  PointA^.x, PointA^.y, PointB^.x, PointB^.y, xx, yy);

      if Coup then begin
         SegmentCoupe := Coup;
         exit;
      end;

   end;
   Segmentcoupe := Coup;
end;

function TPoly.DroiteCoupe (Point1, Point2: PPoint) : boolean;
{-------------------------------------------------------------------------}
{ ROLE }
{-------------------------------------------------------------------------}
var
   Coup                  : boolean;
   PointA, PointB        : PPoint;
   i                     : integer;

begin
   DroiteCoupe := false;
   for i := 0 to count-1 do begin
      PointA := at (i);
      PointB := at ((i+1) mod count);

      Coup := Coupe   (Point1^.x, Point1^.y, Point2^.x, Point2^.y,
                       PointA^.x, PointA^.y, PointB^.x, PointB^.y);

      if Coup then begin
         DroiteCoupe := true;
         exit;
      end;

   end;
end;

function TPoly.PolygoneCoupe (Poly : PPoly) : boolean;
{-------------------------------------------------------------------------}
{ ROLE Retourner vrai si le polygone Poly coupe.                          }
{-------------------------------------------------------------------------}
var
   i               : integer;
   Coup            : boolean;
   PointA, PointB  : PPoint;
   xx, yy          : real;

begin
   Coup := false;
   for i:=0 to Poly^.count-1 do begin
      PointA := Poly^.at (i);
      PointB := Poly^.at ((i+1) mod Poly^.count);
      if SegmentCoupe (PointA, PointB, xx, yy) then Coup := true;
   end;

   PolygoneCoupe := Coup;
end;

procedure TPoly.CalcSurface;
{-------------------------------------------------------------------------}
{ ROLE Retourner la surface du polygone.                                  }
{-------------------------------------------------------------------------}
var
   i              { Compteur }
                  : integer;
   Point1,        { }
   Point2         { }
                  : PPoint;
   S              { }
                  : real;

begin
   S := 0;
   for i := 0 to count-1 do begin
      Point1 := at (i);
      Point2 := at ((i+1) mod count);
      S := S + (Point2^.x-Point1^.x)
                            *((Point1^.y+Point2^.y)/2);
   end;

   Surface := abs (S);
end;

procedure TPoly.Dessiner;
{-------------------------------------------------------------------------}
{ ROLE }
{-------------------------------------------------------------------------}
var
   Point1 : PPoint;

   procedure AppelTraceVers (P : PPoint); far;
   {----------------------------------------------------------------------}
   {----------------------------------------------------------------------}
   begin
      P^.TraceVers;
   end;

begin
   Point1 := at (0);
   if Point1 <> NIL then begin
      Point1^.DeplaceEn;
      Contour.ForEach (@AppelTraceVers);
      Point1^.TraceVers;
   end;
end;

procedure TPoly.Peindre;
{-------------------------------------------------------------------------}
{ ROLE Executer la procedure pointe par la variable VPolygonePlein.      }
{    Au dpart, cette variable pointe sur une procdure locale vide.      }
{-------------------------------------------------------------------------}
var
   Poly  : Polygone;
   npt   : integer;
   texte : string;

   procedure Affecte (P : PPoint); far;
   {----------------------------------------------------------------------}
   {----------------------------------------------------------------------}
   begin
      Poly [npt+1].x := P^.x;
      Poly [npt+1].y := P^.y;
      inc (npt);
   end;

begin
   npt := 0;
   Contour.ForEach (@Affecte);
   VPolygonePlein (count, Poly);
end;

destructor Tpoly.Fini;
{-------------------------------------------------------------------------}
{ ROLE Dtruire l'objet, liberer la mmoire (le tas).                     }
{-------------------------------------------------------------------------}
begin
   TLigne.fini;
end;


{=========================================================================}
BEGIN
   DefDeplaceEn (DeplaceEnNul);
   DefTraceVers (TraceVersNul);
   DefPolygonePlein (PolygonePleinNul);
END.
{--- ARX - POLYGON --------------------------- R.C.- INRP - TOULOUSE - 1993 }
