   (*
   Souris,                   { ARX     - gestion de la  souris              }
   *)
{$I SOURIS.INT}

IMPLEMENTATION
{-------------}

{Sources:
      Revue de l'utilisateur de l'IBM PC n37 de NOV 1987 pp 34-42
 	     "            "             "     n38    DEC 1987     6-17
 	     "            "             "     n56    OCT 1989    16-21
      Bibliothque de procdures Turbo-Pascal, T & J-E Lachand-Robert
                                Ed. Sybex, 1990
      La Bible PC, M. Tischer, Ed. Micro-Application, 1989            }

CONST
   SourisInit           =  0;
   SourisMontre         =  1;
   SourisCache          =  2;
   SourisEtat           =  3;
   SourisGoto           =  4;
   SourisEnfonce        =  5;
   SourisRelache        =  6;
   SourisLimiteH        =  7;
   SourisLimiteV        =  8;
   SourisFormeGraph     =  9;
   SourisFormetexte     = 10;                                   {! non gr!}
   SourisVitesse        = 11;
   SourisEvenements     = 12;          {n38 corrig dans n56} {! non gr!}
   SourisCrayonOn       = 13;
   SourisCrayonOff      = 14;
   SourisSensibilite    = 15;
   SourisMasqueZone     = 16;

VAR
    Xpas,
    Ypas,                   { nombre de pixels pour chaque "pas" de souris }
    Xresolution,
    Yresolution,            { nombre total de pixels sur chaque axe        }
    CurseurSouris       :integer;
    Visible             : boolean;
  {toutes ces variables sont affectes par la procdure ReinitialiserSouris}

FUNCTION SourisPresente : Boolean;
{}
   BEGIN SourisPresente := SourisEstPresente END;

FUNCTION XpasSouris :integer;
{}
   BEGIN XpasSouris := Xpas END;

FUNCTION YpasSouris :integer;
{}
   BEGIN YpasSouris := Ypas END;

FUNCTION XresolutionSouris :integer;
{}
   BEGIN XresolutionSouris := Xresolution END;

FUNCTION YresolutionSouris :integer;
{}
   BEGIN YresolutionSouris := Yresolution END;

PROCEDURE ExecuterFonctionSouris
            (Fonction : Word; VAR RegistresCPU : Registers);
{}
{ ROLE   : Excute une fonction de la souris.                          }
{ ENTREE : Fonction : code de fonction li  l'interruption-souris.    }
{ MAJ    : RegistresCPU : registres internes avant et aprs excution. }
{}
   CONST
      IntSouris         = 51; {=$33}

   BEGIN
      RegistresCPU.AX := Fonction;
      Intr (IntSouris, RegistresCPU)
   END;

Procedure ReinitialiserSouris;
{}
{ ROLE   : Initialise le driver de la souris s'il est install.         }
{ SORTIE GLOBALE: SourisEstPresente est vrai si un driver est install. }
{                 Paramtres de rsolution graphique (pas et rsolution)}
{}

   PROCEDURE FixerXpasSouris;
      CONST
         Yfixe          = 0;

      VAR
         P, X, Y        : integer;

      BEGIN
         P := 0;
         REPEAT
            Inc (P);
            FixerPositionSouris (P,Yfixe);
            LirePositionSouris (X,Y)
         UNTIL P = X;
         Xpas := X
      END;

   PROCEDURE FixerYpasSouris;
      CONST
         Xfixe          = 0;

      VAR
         P, X, Y        :integer;

      BEGIN
         P := 0;
         REPEAT
            Inc (P);
            FixerPositionSouris (Xfixe, P);
            LirePositionSouris (X, Y)
         UNTIL P = Y;
         Ypas := Y
      END;

   PROCEDURE FixerXresolutionSouris;
    { ENTREE GLOBALE Xpas }
      CONST
         Yfixe          = 0;

      VAR
         R, X, Y        : integer;

      BEGIN
         R := 0;
         REPEAT Inc (R, Xpas);
            FixerPositionSouris (R, Yfixe);
            LirePositionSouris  (X, Y)
         UNTIL R <> X;
         Xresolution := R
      END;

   PROCEDURE FixerYresolutionSouris;
     { ENTREE GLOBALE Ypas }
      CONST
         Xfixe          = 0;

      VAR
         R, X, Y        : integer;

      BEGIN
        R := 0;
        REPEAT Inc (R, Ypas);
           FixerPositionSouris (Xfixe, R);
           LirePositionSouris  (X, Y)
        UNTIL R <> Y;
        Yresolution := R
      END;

   VAR
      RegCPU            : Registers;
      Xinitial,
      Yinitial          : integer;

   BEGIN {ReinitialiserSouris}
      ExecuterFonctionSouris (SourisInit, RegCPU);
      CurseurSouris := 0;
      SourisEstPresente := RegCPU.AX = $FFFF;
      IF SourisEstPresente
      THEN BEGIN
         LirePositionSouris (Xinitial, Yinitial);
         FixerXpasSouris; FixerXresolutionSouris;
         FixerYpasSouris; FixerYresolutionSouris;
         FixerPositionSouris (Xinitial, Yinitial);
         Visible := false;
      END ELSE BEGIN
         Xpas := 1;
         Xresolution := 1;
         Ypas := 1;
         Yresolution := 1
      END;
   END;

PROCEDURE CompteurSouris (var nx, ny : integer);
{}
   VAR
      RegCPU            : Registers;

   BEGIN
      IF SourisEstPresente
      THEN
         ExecuterFonctionSouris (SourisVitesse, RegCpu);
      nx := integer (RegCPU.CX);
      ny := integer (RegCPU.DX);
   END;

PROCEDURE MontrerSouris;
{}
   VAR
      RegCPU            : Registers;

   BEGIN
      if not Visible
      then
         IF SourisEstPresente
         THEN
            ExecuterFonctionSouris (SourisMontre, RegCpu);
      Visible := true;
   END;

PROCEDURE CacherSouris;
{}
   VAR
      RegCPU            : Registers;

   BEGIN
      if Visible
      then
         IF SourisEstPresente
         THEN
            ExecuterFonctionSouris (SourisCache, RegCPU);
       Visible := false;
   END;

FUNCTION BoutonSourisEnfonce (NomBouton : UnBoutonSouris) : Boolean;
{}
   CONST
      MasqueGauche      = 1;     {0000000000000001}
      MasqueDroit       = 2;     {0000000000000010}
      MasqueCentre      = 4;     {0000000000000100}
           { REM : les bits 3  15 n'ont pas de signification (0) }
   VAR
      RegCPU            : Registers;

   BEGIN
      BoutonSourisEnfonce := False;
      IF SourisEstPresente
      THEN BEGIN
         ExecuterFonctionSouris (SourisEtat, RegCpu);
         CASE NomBouton OF
            BoutonGauche :
             BoutonSourisEnfonce := RegCPU.BX and MasqueGauche = MasqueGauche;
            BoutonDroit  :
             BoutonSourisEnfonce := RegCPU.BX and MasqueDroit  = MasqueDroit;
            BoutonCentre :
             BoutonSourisEnfonce := RegCPU.BX and MasqueCentre = MasqueCentre;
         END
      END
   END;

FUNCTION UnBoutonSourisEnfonce : Boolean;
{}
   VAR
      RegCPU            : Registers;

   BEGIN
      UnBoutonSourisEnfonce := false;
      IF SourisEstPresente
      THEN BEGIN
         ExecuterFonctionSouris (SourisEtat, RegCpu);
         UnBoutonSourisEnfonce := RegCPU.BX <> 0
      END
   END;

PROCEDURE LirePositionSouris (VAR xSouris, ySouris : Integer);
{}
   VAR
      RegCPU : Registers;

   BEGIN
      IF SourisEstPresente
      THEN BEGIN
         ExecuterFonctionSouris (SourisEtat, RegCPU);
         WITH RegCPU
         DO BEGIN
            xSouris := CX;
            ySouris := DX
         END
      END ELSE BEGIN
         xSouris := 0;
         ySouris := 0
      END
   END;

PROCEDURE FixerPositionSouris (xSouris, ySouris : Integer);
{}
   VAR
      RegCPU            : Registers;

   BEGIN
      IF SourisEstPresente
      THEN BEGIN
         IF xSouris < 0 THEN xSouris := 0;
         IF ySouris < 0 THEN ySouris := 0;
         WITH RegCPU
         DO BEGIN
            CX := xSouris;
            DX := ySouris
         END;
         ExecuterFonctionSouris (SourisGoTo, RegCPU)
      END
   END;

PROCEDURE DernierClicSouris (NomBouton : UnBoutonSouris;
            CodeFonction : Integer; VAR NbClics, xSouris, ySouris : Integer);
{}
{ ENTREE NomBouton: BoutonGauche, BoutonCentre ou BoutonDroit.  }
{        CodeFonction: Enfoncement ou relachement.              }
{ SORTIE NbClics : depuis le dernier appel  cette fonction.    }
{        xSouris, ySouris : coordonnes de la souris lors du    }
{                           dernier enfoncement ou relachement. }
{}
   VAR
      RegCPU            : Registers;

   BEGIN
      IF SourisEstPresente
      THEN
         WITH RegCPU
         DO BEGIN
            CASE NomBouton OF
               BoutonGauche : BX := 0;
               BoutonDroit  : BX := 1;
               BoutonCentre : BX := 2;
            END;
            ExecuterFonctionSouris (CodeFonction, RegCPU);
            NbClics := BX;
            xSouris := CX;
            ySouris := DX
         END
      ELSE BEGIN
         NbClics := 0;
         xSouris := 0;
         ySouris := 0
      END
   END;

PROCEDURE LireDernierEnfoncementSouris (NomBouton : UnBoutonSouris;
              VAR NbClics, xSouris, ySouris : Integer);
{}
   BEGIN
      DernierClicSouris (NomBouton, SourisEnfonce, NbClics, xSouris, ySouris)
   END;

PROCEDURE LireDernierRelachementSouris (NomBouton : UnBoutonSouris;
              VAR NbClics, xSouris, ySouris : Integer);
{}
   BEGIN
      DernierClicSouris (NomBouton, SourisRelache, NbClics, xSouris, ySouris)
   END;

PROCEDURE LimiterSouris (Sens, Mini, Maxi : Integer);
{}
{ ENTREE Sens : vaut SourisLimiteH ou SourisLimiteV }
{        Mini, Maxi : intervalle de limitation      }
{}
   VAR
      RegCPU            : Registers;

   BEGIN
      IF SourisEstPresente
      THEN BEGIN
        WITH RegCPU
        DO BEGIN
           CX := Mini;
           DX := Maxi
        END;
        ExecuterFonctionSouris (Sens, RegCPU)
      END
   END;

PROCEDURE LimiterDeplacementSouris (Xgauche,Yhaut,Largeur,Hauteur: Integer);
{}
   BEGIN
      LimiterSouris (SourisLimiteH, Xgauche, Xgauche+Pred(Largeur));
      LimiterSouris (SourisLimiteV, Yhaut,   Yhaut  +Pred(Hauteur));
   END;

PROCEDURE LibererDeplacementSouris;
{}
   BEGIN
      LimiterDeplacementSouris
         (0, 0, XResolutionSouris-1, YResolutionSouris-1)
   END;

PROCEDURE MasquerZoneSouris (xGauche, yHaut, Largeur, Hauteur: Integer);
{}
   VAR
      RegCPU            : Registers;

   BEGIN
      IF SourisEstPresente
      THEN BEGIN
         WITH RegCPU
         DO BEGIN
            CX := xGauche;                DX := yHaut;
            SI := Xgauche+Pred(Largeur);  DI := Yhaut+Pred(Hauteur)
         END;
         ExecuterFonctionSouris (SourisMasqueZone, RegCPU)
      END
   END;

PROCEDURE DemasquerZoneSouris;
{}
    BEGIN MontrerSouris END;

PROCEDURE EmulationCrayon;
{}
   VAR
      RegCPU            : Registers;

   BEGIN
      IF SourisEstPresente
      THEN
         ExecuterFonctionSouris (SourisCrayonOn, RegCPU)
   END;

PROCEDURE FinEmulationCrayon;
{}
   VAR
      RegCPU            : Registers;

   BEGIN
      IF SourisEstPresente
      THEN
         ExecuterFonctionSouris (SourisCrayonOff, RegCPU)
   END;

PROCEDURE VitesseDeplacement (Horiz, Vert : Integer);
{}
   VAR
      RegCPU            : Registers;

   BEGIN
      IF SourisEstPresente
      THEN BEGIN
         WITH RegCPU
         DO BEGIN CX := Horiz; DX := Vert END;
         ExecuterFonctionSouris (SourisVitesse, RegCPU)
      END
   END;

(*PROCEDURE ChangerCurseurSouris (NouvForme : Integer);
{}

  FUNCTION Entre0et15 (Valeur :integer) :integer;
    CONST Mini = 0; Maxi = 15;
    BEGIN
      Entre0et15 := Valeur;
      IF      Valeur < Mini THEN Entre0et15 := Mini
      ELSE IF Valeur > Maxi THEN Entre0et15 := Maxi
    END;


  VAR RegCPU      : Registers;
      FormeValide : Boolean;
      SurCurseurSouris : ^UnCurseurSouris;

  BEGIN
    IF SourisEstPresente THEN
      IF NouvForme <> CurseurSouris THEN BEGIN
        FormeValide := True;

        CASE NouvForme of
          Fleche       : SurCurseurSouris := @CurseurFleche;
          Croix        : SurCurseurSouris := @CurseurCroix;
          Main         : SurCurseurSouris := @CurseurMain;
          Sablier      : SurCurseurSouris := @CurseurSablier;
          DoubleFleche : SurCurseurSouris := @CurseurDoubleFleche;
          PetitDe      : SurCurseurSouris := @CurseurPetitDe;
          Crayon       : SurCurseurSouris := @CurseurCrayon;
        ELSE FormeValide := False
        end;

        IF FormeValide THEN BEGIN
          CurseurSouris := NouvForme;
          WITH RegCPU, SurCurseurSouris^ DO BEGIN
            WITH PointChaud DO BEGIN
              BX := Entre0et15(x);  CX := Entre0et15(y)
            END;
            DX := Ofs(MasqueEcran); ES := Seg(MasqueEcran);
          END;
          ExecuterFonctionSouris (SourisFormeGraph,RegCPU)
        END
      END
  END;
  *)

PROCEDURE ChangerCurseur (Curseur : UnCurseurSouris);
{}

   FUNCTION Entre0et15 (Valeur :integer) :integer;
      CONST
         Mini           = 0;
         Maxi           = 15;

      BEGIN
         Entre0et15 := Valeur;
         IF      Valeur < Mini THEN Entre0et15 := Mini
         ELSE IF Valeur > Maxi THEN Entre0et15 := Maxi
      END;


   VAR
      RegCPU            : Registers;
      SurCurseurSouris  : ^UnCurseurSouris;

   BEGIN
      IF SourisEstPresente
      THEN BEGIN
         SurCurseurSouris := @Curseur;
         curseursouris := 0;

         WITH RegCPU, SurCurseurSouris^
         DO BEGIN
            WITH PointChaud
            DO BEGIN
              BX := Entre0et15 (x);
              CX := Entre0et15 (y)
            END;
            DX := Ofs (MasqueEcran);
            ES := Seg (MasqueEcran);
         END;
         ExecuterFonctionSouris (SourisFormeGraph, RegCPU)
      END;
   END;

BEGIN

   ReinitialiserSouris;

END.
