PROGRAM BLOC;

{---------------------------------------------------------------------------}
{  Logiciel GEOCEAN - module BLOC                                           }
{  programme principal du  logiciel BLOCS        version 1.x du  06/04/96   }
{---------------------------------------------------------------------------}
{---------------------------------------------------------------------------}
{  Institut National de Recherche Pdagogique : DP 4, N. SALAME  -  PARIS   }
{  Equipe INRP  TOULOUSE :                                                  }
{  F. BOULANGER, R. CULOS, S. DUPOUY, C. GROS, J-Y. GUCHEREAU, J. TONNELAT  }
{  Ralisation :    93-96                                                        }
{  A R X - Alain, Roger et Xavier CULOS - 6 avenue de Lagarde 31130 BALMA   }
{---------------------------------------------------------------------------}

{---------------------------------------------------------------------------}
{ fichiers spciaux associs aux logiciels GEOCEAN                          }
{ *  GEOCEAN .CFG            paramtres de configuration      dans rep PRG  }

{ fichiers spciaux associs  ce programme                                 }
{ *  BLOC    .ICN            images, icnes                   dans rep PRG  }
{ *  BLOC    .PAL            palette                          dans rep PRG  }
{ *  BLOC    .TXT            mini documentation du programme  dans rep PRG  }
{ *  BLOC    .AID            texte d'aide                     dans rep PRG  }

{---------------------------------------------------------------------------}
{ fichiers associs aux donnes utilises                                   }
{    *       .GRD            Grille rgulire des valeurs     dans rep DNN  }
{                             cartographier (format INRP/BGI)              }
{    *       .DAP            informations/toponymie CART  dans DNN ou TRV   }
{---------------------------------------------------------------------------}
{ fichiers associs  utiliser                                              }
{    *       .BLC            paramtres du travail en cours   dans rep ct   }
{    *       .DXT            Commentaires associs/carte               ct   }
{    *       .DAP            informations/toponymie CART  dans DNN ou TRV   }
{    *       .PLT            Code HPGL ou imprimante                        }
{    *       .PCX            Copie cran PCX  N&B                           }
{---------------------------------------------------------------------------}

{$M 65520,0,655360}

USES
   BLOC_REC,         { gestion des recouvrements                            }

   CSI,              { gestion du Clavier, de la Souris et des Icnes       }
   MENUS,            { interface  menus droulants                          }

   GEO_VAR,          { variables globales communes                          }
   GEO_DES,          { procedures div communes                              }

   BLOC_VAR,         { variables globales propres au module                 }
   BLOC_DES,         { graphisme du module                                  }
   BLOC_INI,         { initialisations                                      }

   BLOC_5,           { menu : SORTIES                                       }
   BLOC_4,           { menu : ECRAN                                         }
   BLOC_3,           { menu : LEGENDES                                      }
   BLOC_2,           { menu : BLOC                                          }
   BLOC_1;           { menu : FICHIERS  gestion des rpertoires             }

{$O bloc_var}        { dfinition des units en recouvrement                }
{$O bloc_ini}

{$O geo_var}
{$O geo_des}

{$O Grilles}
{$O Menus}
{$O CSI}
{$O Icones}

{$O symboles}
{$O periphs}
{$O comment}
{$O dirinfo}
{$O graphuti}
{$O lipar}

{$O graphplt}
{$O edition}
{$O utildivs}
{$O fichiers}
{$O graphism}
{$O rs2322}
{$O sekoplt}
{$O imprim}
{$O fctmath}
{---------------------------------------------------------------------------}

procedure CasMenus;
   var
      Choix             : integer;

   begin
      if changemenus then exit;
      menu (a, b, codeclavier);{ MENU2 }
                               { acquisition d'un choix valide dans un menu }

      if FF1 (codeclavier)     { CSI }
      then                     { appui sur la touche F1 dans un sous-menu   }
         aide (a, b)           { BLOC_INI }
      else begin
         if b > 1
         then
            Choix := 100*a+b;
         case Choix of         { validation d'une option dans un sous-menu  }
          { menu FICHIERS }
            102  : NOUVEAU_FICHIER;                   { 1 }
            103  : OUVRIR_FICHIER;                    { 1 }
            104  : ENREGISTRER_FICHIER;               { 1 }
            105  : ENREGISTRER_SOUS;                  { 1 }
            106  : VOIR_CATALOGUE;                    { menus5 }

            108  : QUITTER;                           { 1 }

            110  : SUPPRIMER_LIEN;                    { 1  p }
            111  : MODIFIER_LIEN;                     { 1  p }
            112  : VOIR_PARAMETRES;                   { 1  p }

          { menu BLOC  }
            {202  : d_params; }                         { 2 }
            202  : D_FIL_DE_FER;                      { 2 }
            203  : D_GRADIENT;                        { 2 }
            205  : CALCULER;                          { 2 }

          { menu LEGENDES }
            302  : COMMENTAIRES;                      { 3 }
            303  : AXES;                              { 3 }
            304  : D_TOPONYMIE;                       { 3 }
            306  : AUTRES_PARAMS_LEGENDES;            { 3  prof }

          { menu  ECRAN }
            402  : visu_commentaires;                 { 4 }
            403  : visu_graduations;                  { 4 }
            404  : visu_toponymie;                    { 4 }
            405  : visu_horiz;                        { 4 }
            406  : visu_grad;                         { 4 }
            407  : visu_ombre;                        { 4 }

          { menu SORTIES }
            502  : COPECRAN;                          { 5 }
            504  : TRACE_GRAPH;                       { 5 }
            507  : geo_PALETTES (nomfd);              { Geo_des }
            508  : CONFIG_PERIPH;                     { Geo_des }
            509  : IMPR_PARAM;                        { 5 prof }

          { menu AIDES }
            602  : AIDE_MENUS_boites (cheminmodule+nomdumodule+exthlp);                        { ini }
            603  : aide (6, 3);
            604  : aide_geoc;
            605  : aide_module;
            606  : aide_region;
            608  : a_propos;
         end;
      end;
   end;

procedure CasIcones;
   var
      PosCur,
      Touche            : integer;

   begin
      if changemenus then exit;
      PosCur := 11;
      if affichetexte            { appui sur F1 au niveau d'une icne       }
      then
         case Zi of                                                   { CSI }
             1 : aide_geoc;      {}
             2 : version_logiciel;
             3 : aide (2, 6);   {  }
             4 : aide_module;   {  }
         end
      else
         case Zi of                                                   { CSI }
             1 : A_propos;
             3 : CALCULER;                                        { BLOC_2  }
             4 : aide_region;
             5..21 : ModifierParams3D (Zi);
         end;
   end;

procedure CasFenetre;
   begin
      if changemenus then exit;
      if visucomm    then Editer_Commentaires (xs, ys, db);
      if visutoponym then Editer_Noms_3d      (xs, ys, db);
   end;

procedure AutreCas;
   begin
      if changemenus then exit;
   end;

BEGIN                { programme principal }

   iniparam ;        { initialisation des paramtres par dfaut    BLOC_INI }
                     { lecture de fic.CFG                                   }
   inimenus ;        { initialisation de l'interface menus         BLOC_INI }
   iniparam2 ;       { initialisation des paramtres par dfaut    BLOC_INI }
                     { lecture des fichiers .CPS, .SMP, .TXP                }
   iniicones;        { initialisation des icnes                   BLOC_DES }
   inifondecran;
   inisymboles;      { initialisation des symboles                 BLOC_DES }
   inidonnees;       { initialisation des donnes                  BLOC_INI }
   iniecran ;        { initialisation de l'cran/BLOC              BLOC_DES }
   ini_noms_3d;      { initialisation des coord des noms des lieux BLOC_INI }
   iniaide  ;        { initialisation de l'aide en ligne           BLOC_INI }
                     {      lecture de   fic.AID                            }
   redess_bloc (false);
   repeat
      modif_menus;   { modifications fonction des paramtres PAR   BLOC_INI }
      case ZoneDuClick (maxc1, maxc2, maxc3, maxc4) of                                       { GEO_CSI }
         1 : CasMenus  ;
         2 : CasIcones ;
         3 : CasFenetre;
         4 : autreCas  ;
      end;
      if changemenus then inversemenus;
   until fini;
   fin;                                                          { BLOC_INI }

END.                      { programme principal }


{--- GEOCEAN - BLOC -------------------------- R.C.- INRP - TOULOUSE - 1996 }
