UNIT BLOC_DES;

   {------------------------------------------------------------------------}
   {      logiciel GEOCEAN                                                  }
   {                      procdures graphiques du module                   }
   {                                             version 1.1 du  01/05/93   }
   {------------------------------------------------------------------------}

INTERFACE

USES

   crt, dos,
   Graph,                    { TP 70   - units standard Borland            }
   Souris,                   { ARX     - gestion de la  souris              }
   Clavier,                  { ARX     - gestion du clavier                 }
   Edition,                  { ARX     - saisie/dition paramtres          }
   Graphism,                 { ARX     - initialisations graphiques         }
   Messarx,                  { ARX     - Textes des Messages de Base        }

   Utildivs,                 { ARX     - utilitaires divers                 }
   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   Graphplt,                 { ARX     - graphisme 2D cran/traceur         }
   Graph3D,                  { ARX     - procdures graphiques 3D           }
   Graphsg,                  { ARX     - symboles et graduations            }
   Periphs,                  { ARX     - priphriques, impression, palettes}
   Menus,                    { ARX     - interface menus                    }
   Icones,                   { ARX     - gestion de icnes                  }
   Comment,                  { ARX     - Commentaires                       }

   GRILLES,                  { ARX     - lecture des grilles                }

   GEO_var,                  { GEO     - variables globales communes        }
   GEO_des,                  { GEO     - procdures graph. communes         }

   BLOC_var;                 { BLOC    - variables globales du module       }

{---------------------------------------------------------------------------}

Procedure choix_fil_de_fer;
   { Saisie paramtres des lignes                                           }

Procedure choix_axes3 ;
   { Saisie paramtres des axes                                             }

Procedure efface_bloc;
   { efface la carte si possible                                            }

Procedure efftout;
   { efface la carte                                                        }
   { et libre les pointeurs sur la griile                                  }

Procedure recalc_ecran;
   { recalcule les coordonnes pour un cran autre que VGA                  }

Procedure def_icones;
   { affecte les zones sensibles                                            }

Procedure dess_icones;
   { affiche les icnes                                                     }

Procedure IniFondEcran;
   { affecte couleur                                                        }

Procedure iniecran;
   { initialise l'tat de l'cran en fonction du fichier param par dfaut   }

Procedure finir;
   { sort en rtablissant l'cran texte                                     }

Procedure graduer_exterieur_xy (trac, eff : boolean);
   { dessine les graduations externes en X et Y                             }

Procedure dess_bloc (trac : boolean);
   { dessine le Bloc                                                        }

Procedure cadrer3D (f1, f2, f3, f4 : real);
   {------------------------------------------------------------------------}
   { ROLE Dfinir la fentre et la clture                                  }
   { ENTREE f1, f2 abscisse mini et maxi des coordonnes utilisateur        }
   {        f3, f4 ordonnes  "                  "                          }
   {        c1, c2 abscisse mini et maxi de la clture cran                }
   {        c3, c4 ordonnes                                                }
   {------------------------------------------------------------------------}

Procedure FixerAltitudeBase (z : real);
   {------------------------------------------------------------------------}
   { ROLE Fixer l'altitude de la base du socle                              }
   { ENTREE z                                                               }
   {------------------------------------------------------------------------}

Procedure AfficherMode3D;
   {------------------------------------------------------------------------}
   { ROLE                                                                   }
   {------------------------------------------------------------------------}

Procedure DessinerBloc;
   {------------------------------------------------------------------------}
   { ROLE dessiner les limites du bloc et ses attributs                     }
   {------------------------------------------------------------------------}

Procedure tracer3D;
   {------------------------------------------------------------------------}
   { ROLE tracer la grille sur table traante                               }
   {------------------------------------------------------------------------}

Procedure DefinirParamsMode3D;
   {------------------------------------------------------------------------}
   { ROLE }
   {------------------------------------------------------------------------}

Procedure ModifierParams3D (Icone : integer);
   {------------------------------------------------------------------------}
   { ROLE }
   {------------------------------------------------------------------------}

Procedure esquisse;
   { Dessine la premire esquisse du bloc au dmarrage                      }

Procedure ajoute_toponymie_3d (trac, eff : boolean);
   { Dessine toponymie en 3D                                                }

Procedure ajoute_graduations_3d;
   { Dessine graduations simples                                            }

Procedure inipalette;
   { Initialise la palette correspondant aux donnes                        }

Procedure redess_bloc (trac : boolean);
   { Redessine le bloc  complet                                             }

Procedure redess_tout;
   { R affiche aprs une inversion de couleurs                             }

Procedure append_Noms_3d (nomf  : dirstr);
   { Lit le fichier .DAP et calcule les projections                         }

Procedure recalc_Noms_3d (auto : boolean);
   { Recalcule les projections                                              }

Procedure Editer_Noms_3d (x, y : integer; dblclc : boolean);
   { Edite la toponymie                                                     }

{---------------------------------------------------------------------------}

IMPLEMENTATION

CONST
{$I croix.cur}
   llr                  = 20;  { long ligne de rappel en mm }

(*
procedure choix_topobloc (var change : boolean);
   var
      cc1, cc2       : byte;                 { rangs dans liste 0..2}
      i,
      touche, poscur : integer;
      e1, e2         : integer;
      r3             : real;
      z1, z2         : PZoneentier;
      z3             : PZonereel;
      zc1, zc2       : Pzonecouleur;
      boite          : PBoiteSaisie;

   begin
      change := true;
      e1     := htxt;
      e2     := lrappel;
      r3     := coefdispersion;
      cc1    := coul_t;
      cc2    := c_lrappel;
      poscur := 1;
      boite  := new (PBoiteSaisie,
                init (milieu, milieu, 15,  c_f_boite_norm, c_t_boite_norm,
                'Toponymie'));
      Zc1    := new (PZoneCouleur,
                init (     0,      0,       @cc1,
                'Couleur texte      ', '', pal));
      boite^.ajoute (zc1);

      Zc2    := new (PZoneCouleur,
                init (     0,      0,       @cc2,
                'Couleur lignes     ', '', pal));
      boite^.ajoute (zc2);
      { angle_t  := 0;}
      { align_t  := 0;}
                              {! demander dcalages en X et Y (? units mm )}
      z1    :=  new (PZoneentier,
                init (  0,   0,  1, colorf, colord, @htxt,
                'Hauteur texte      ', '1..3'));
      boite^.ajoute (z1);
      z2    :=  new (PZoneentier,
                init (  0,   0,  1, colorf, colord, @lrappel,
                'Lignes rappel      ', '1..3'));
      boite^.ajoute (z2);

      z3    :=  new (PZoneReel,
                init (  0,   0,  3,  1, colorf, colord, @coefdispersion,
                'Dispersion Lignes  ', '0..1'));
      boite^.ajoute (z3);

      laide ('TAB change de champ/ESC annule tout/ENTREE valide tout');
      boite^.editeF (1, Poscur, Touche);
      laide ('');

      boite^.vider;
      dispose (boite, fini);

      if (touche = ESC)  {or (touche = 0)}
      then begin                           { rtablir les valeurs initiales }
         htxt     := e1;
         lrappel  := e2;
         coefdispersion := r3;
         cc1      := coul_t;
         cc2      := c_lrappel;
         change   := false;
      end;
      {coultopo := nomcouleur (cc1);         affecter var globales          }
      coul_t   := cc1;
      c_lrappel:= cc2;
      if coefdispersion > 1 then coefdispersion := 1;
      if coefdispersion < 0 then coefdispersion := 0;
   end;
*)
procedure choix_fil_de_fer ;
   var
      e1,
      touche, poscur    : integer;
      z                 : PZoneEntier;
      cc1, cc2          : byte;
      zc1, zc2          : Pzonecouleur;
      boite             : PBoiteSaisie;

   begin
      e1  := PasF;
      cc1 := byte (c_grille);
      cc2 := byte (c_bord);
      z      := new (PZoneEntier,
                init (0,   0,   1,   0, 15, @PasF,
                'Afficher une ligne sur', '1..4'));
      Zc1    := new (PZoneCouleur,
                init (0,   0,               @cc1,
                'Couleur des lignes   ', '', pal));
      Zc2    := new (PZoneCouleur,
                init (0,   0,               @cc2,
                'Couleur base du bloc ', '', pal));
      poscur := 1;
      boite  := new (PBoiteSaisie,
                init ( milieu, milieu, 15,  7, 0,
                'Lignes et bloc'));

      boite^.ajoute (z);
      boite^.ajoute (zc1);
      boite^.ajoute (zc2);

      laide (aidedit);
      boite^.editeF (1, Poscur, Touche);
      laide ('');

      boite^.vider;
      dispose (boite, fini);

      if touche = ESC
      then begin
         PasF     := e1;

      end else begin
         c_grille := cc1;
         c_bord   := cc2;
         if pasf < 1 then pasf := 1;
         if pasf > 4 then pasf := 5;
      end;
   end;

procedure choix_axes3 ;
   var
      touche, poscur    : integer;
      cc1, cc2          : byte;
      zc1, zc2          : Pzonecouleur;
      boite             : PBoiteSaisie;

   begin
      cc1 := byte (c_axex);
      cc2 := byte (c_axey);
      poscur := 1;
      boite  := new (PBoiteSaisie,
                init ( milieu, milieu, 15,  fondnorm, txtnorm,
                'Axes X  Y  Z'));

      { couleur }
      Zc1     := new (PZoneCouleur,
                 init (     0,      0,                         @cc1,
                 'Couleur  axes X & Y ', '', pal));
      boite^.ajoute (zc1);

      { couleur }
      Zc2     := new (PZoneCouleur,
                 init (     0,      0,                         @cc2,
                 'Couleur  axe Z      ', '', pal));
      boite^.ajoute (zc2);

      laide (aidedit);
      boite^.editeF (1, Poscur, Touche);
      laide ('');

      boite^.vider;
      dispose (boite, fini);

      if (touche = ESC)
      then begin
         cc1     := c_axex;
         cc2     := c_axey;
      end;
      { ajuster en fonction des limites }
      c_axex     := cc1;
      c_axey     := cc2;
   end;

procedure recalc_ecran;
   begin
      if (coef_x <> 1)
      then begin
         maxc1   := round (maxc1   * coef_x);
         maxc2   := round (maxc2   * coef_x);
         cc1     := round (cc1     * coef_x);
         cc2     := round (cc2     * coef_x);
      end;
      if (coef_y <> 1)
      then begin
         maxc3   := round (maxc3   * coef_y);
         maxc4   := round (maxc4   * coef_y);
         cc3     := round (cc3     * coef_y);
         cc4     := round (cc4     * coef_y);
      end;
      coef_c := (cc2-cc1) / (cc4-cc3);
   end;

procedure cadrer;
   { SI cc2<= cc1 ou cc4<=cc3 ou hors limites...
     calcule cc2 et cc4 en fonction
         de la position du coin bas-gauche ( cc1, cc3 dans .PAR)
         et de l'extension maxi clture (maxC2, maxC4 dans .CFG)            }

   var
      coeff, coefc      : real;

   begin
      if cc1 < maxc1 then cc1 := maxc1;
      if cc2 > maxc2 then cc2 := maxc2;
      if cc3 < maxc3 then cc3 := maxc3;
      if cc4 > maxc4 then cc4 := maxc4;

      if (cc2 <= cc1) or (cc4 <= cc3)
      then begin
         cc2 := maxc2;
         cc4 := maxc4;
      end;
   end;

procedure libere_mem;
   begin
      LaGrille.Liberer;
      liberer_jeu_symb (1);
{      liberer_jeu_symb (jeu2);}
      liberer_jeu_symb (3);
      liberericones;
      params.fini;
      parini.fini;
      liberer_commentaires;
      liberer_noms;
   end;

procedure finir;
   begin
     { restorecrtmode;
      ecrantexte;}
      libere_mem;
   end;

procedure effcart;
  begin
      pleinecloture;
      coulbar (SolidFill, coulecran);
      bar (0, hauteurmenu, maxc2, maxy-maxc3);         { couleur fond cran }
   end;

procedure efface_bloc;
   begin
      if ecran then effcart
   end;

procedure efftout;
   begin
      ecran := true;
      effcart;

      LaGrille.Liberer;
      params.fini;
      liberer_commentaires;
      liberer_noms;
   end;

(*procedure dess_symb_3d;
   var
      Rx, Ry,
      coefl       : integer;
      Rz,
      Ex, Ey, Ez,
      x, y        : real;
      fichier     : text;

   procedure  calculer_extremites_ligne ;
      var
          dist,
          mx, my            { milieu de la grille }
                    : real;

      begin
         case lrappel of
           1 : coefl := 15;
           2 : coefl := 10;
           3 : coefl :=  5;
         end;

         with LaGrille
         do begin
            Rx := RangX  (x);
            Ry := Rangy  (y);
            Rz := Valeur (Rx, Ry );
            mx := nbcog / 2;
            my := nblig / 2;
            ex := rx + (rx-mx) * coefdispersion;
            ey := ry + (ry-my) * coefdispersion;
            dist := sqrt (sqr (rx-mx)+sqr(rx-my));
            ez := rz + DivZ * NbLig/coefl - divz * dist * coefdispersion;
            { divz = coef aplatissement
              DivZ := (LaGrille.Maxzg-LaGrille.Minzg)/LaGrille.nbcog*4;}
         end;
      end;

   begin
      if Ftxt_Present (chemindonnees+nomftop+exttop)
      then begin
         assign      (fichier, chemindonnees+nomftop+exttop);
         resettxterr (fichier, chemindonnees+nomftop+exttop, ok);
         fenetre (fb1, fb2, fb3, fb4);
         cloture (cc1, cc2, cc3, cc4);
         repeat
            readln (fichier, x, y, chain);
            calculer_extremites_ligne;
            { ancrage de la ligne de rappel }
            deplaceEn3D  (Rx, Ry, Rz);

            { tracer longueur de la ligne de rappel }
            fixecoul (c_lrappel);
            TraceVers3D  (Ex, Ey, Ez);
         until eof (fichier);
         close (fichier);

         resettxterr (fichier, chemindonnees+nomftop+exttop, ok);
         case htxt of
            1 : setusercharsize (1, 2, 1, 2);
            2 : setusercharsize (1, 1, 1, 1);
            3 : setusercharsize (3, 2, 3, 2);
         end;
         repeat
            readln     (fichier, x, y, chain);
            e_b_devant                (chain);
            calculer_extremites_ligne;
            { dpacer pointeur pour texte }
            DeplaceEn3DT (Ex, Ey, Ez);

            { crire le texte }
            fixecoul    (coul_t);
            ttextePlein (chain, 1, 0, coulecran);
         until eof (fichier);
         setusercharsize (3, 2, 3, 2);
         PleineCloture;
         close (fichier);
      end;
   end;
*)
procedure fenetrecloturecrantrac_b (trac : boolean);
   begin
      ecrantrac (trac);
      fenetre   (fb1, fb2, fb3, fb4);
      cloture   (cc1, cc2, cc3, cc4);
   end;

procedure append_Noms_3d (nomf  : dirstr);
   var
      fdat              : text;
      nom               : PCommentaire;
      xp, yp,
      rx, ry,
      xe, ye            : integer;
      rz,
      mx,  my,
      x0,  y0,
      xc , yc           : real;
      t                 : t30;

   begin
      if Ftxt_Present (nomf)
      then begin
         assign (fdat, nomf);
         resetTxtErr  (fdat, nomf, ok);
         repeat
            read   (fdat, xc);
            read   (fdat, yc);
            read   (fdat, t);            { dernier champ = texte possible }
            e_b_devant   (t);

            with LaGrille
            do begin
               Rx := RangX  (xc);
               Ry := Rangy  (yc);
               Rz := Valeur (Rx, Ry);
            end;
            fenetrecloturecrantrac_b (false);
            d3_d2 (rx, ry, rz, xp, yp);
            xe  := xecran (xp);
            ye  := yecran (yp);

            fenetrecloturemilli;
            x0  := xutilisateur (xe);
            y0  := yutilisateur (ye);

            mx := 0;
            my := 0;
            if align_t > 1
            then
               prepare_label (x0, y0+llr, mx, my, t);

            Nom := new (PCommentaire,
                        init (X0+mx, Y0+my+llr, x0, y0, xc, yc,
                              Haut_t, 0, 0, coul_t, 1, 0, true, t));
            Noms^.insert (Nom);

            readln (fdat);
         until eof (fdat);
         close (fdat);
         pleinecloture;
      end;
   end;

procedure recalc_Noms_3d (auto : boolean);
   procedure AppelRecadrer3d (C : PCommentaire); far;
      var
         xp, yp,
         xe, ye,
         rx, ry         : integer;
         mx, my,
         rz             : real;

      begin
         with LaGrille
         do begin
            Rx := RangX  (C^.xu);          { recherche le rang ds la grille }
            Ry := Rangy  (C^.yu);
            Rz := Valeur (Rx, Ry);         { valeur au noeud }
         end;
         fenetrecloturecrantrac_b (false);
         d3_d2 (rx, ry, rz, xp, yp);       { projection dans fentre 2d }
         xe  := xecran (xp);               { repre ECRAN               }
         ye  := yecran (yp);

         fenetrecloturemilli;
         C^.x0   := Xutilisateur (xe);     { repre UTILISATEUR mm      }
         C^.y0   := Yutilisateur (ye);

         if auto    { chargement fichier cr avec CART }
         then begin
            mx := 0;
            my := 0;
            if align_t > 1
            then
               prepare_label (C^.x0, C^.y0+llr, mx, my, C^.texte);
            C^.x := C^.x0+mx;
            C^.y := C^.y0+my+llr;
         end;

         if not C^.lr                      { pas de ligne de rappel     }
         then begin
            C^.x  := C^.x0;
            C^.y  := C^.y0+llr;
         end;
      end;

   begin
      noms^.ForEach (@AppelRecadrer3d);
      pleinecloture;
   end;

procedure Editer_Noms_3d (x, y : integer; dblclc : boolean);
   var
      nom               : PCommentaire;
      texte             : t30;
      coult             : word;
      Touche            : integer;
      lier              : boolean;
      xp, yp            : real;

   begin
      lier   := true;
      ok     := false;
      nom    := nil;
      fenetrecloturemilli;
      if Noms^.Contient (XUtilisateur (x), YUtilisateur (y), nom)
      then begin
         if dblclc
         then begin
            Nom^.Tracer (CoulBoite, true, fond_t);
            ok := false;
            saisir_commentaire (nom^.texte, nom^.couleur, ok, nom^.lr, lier);
            if not ok
            then
               Nom^.Afficher (true, fond_t);
                                         { cadre, fond}
         end else
            if Nom <> NIL
            then begin
               pleinecloture;
               laide (la_comment);
               fenetrecloturemilli;
               Nom^.Tracer (CoulBoite, true, fond_t);
               SetColor (15 xor coulboite);
               Nom^.Editer
                  (touche, maxc1, maxy-maxc4, maxc2-maxc1 ,maxc4-maxc3, lier);
               ok := (touche = DEL);
               if not ok
               then
                  Nom^.Afficher (true, fond_t);
               laide ('');
            end;
      end;

      { coordonnes carte & origine des lignes de rappel inchanges   }

      if Nom <> nil
      then
         if ok or (nom^.texte='')
         then
            Noms^.free (nom);
      PleineCloture;
      modicomm := true;
   end;

procedure ini_par_ecr;
   begin
      maxc1        := 1;           { extension maxi clture }
      maxc2        := posxbtn-2;
      maxc3        := 2*ty+4;
      maxc4        := maxy - hauteurmenu -ty div 3;
   end;

procedure def_icones;
   var
      px, py            : integer;

    begin
      px  := posxbtn;
      py  := maxy - 30 - ty;
      bouton_icone (aidico1,  1, px,    py,     96, 30);
      bouton_icone (aidico2,  2, px+94, py - 2,  4,  2);
      bouton_icone (aidico3,  3, px,    py -53, 96, 50);

      py :=  hauteurmenu+9;
      bouton_icone (aidico4,  4, px,    py,     96, 30);

      py := py + 9;
      bouton_icone (aidico5,  5, px+33, py +33, 30, 30);
      bouton_icone (aidico6,  6, px   , py +66, 30, 30);
      bouton_icone (aidico7,  7, px+33, py +66, 30, 30);
      bouton_icone (aidico8,  8, px+66, py +66, 30, 30);
      bouton_icone (aidico9,  9, px+33, py +99, 30, 30);

      bouton_icone (aidico10, 10, px   , py+144, 30, 30);
      bouton_icone (aidico11, 11, px+33, py+144, 30, 30);
      bouton_icone (aidico12, 12, px+66, py+144, 30, 30);
      bouton_icone (aidico13, 13, px   , py+177, 30, 30);
      bouton_icone (aidico14, 14, px+33, py+177, 30, 30);
      bouton_icone (aidico15, 15, px+66, py+177, 30, 30);

      bouton_icone (aidico16, 16, px+33, py+220, 30, 30);
      bouton_icone (aidico17, 17, px   , py+253, 30, 30);
      bouton_icone (aidico18, 18, px+33, py+253, 30, 30);
      bouton_icone (aidico19, 19, px+66, py+253, 30, 30);
      bouton_icone (aidico20, 20, px+33, py+286, 30, 30);

      bouton_icone (aidico21, 21, px   , py+99,  30, 30);
      icone_etat;
   end;

procedure dess_icones;
   var
      i                 : integer;

   begin
      for i := 1 to 21
      do
         active_dess_icone (i);
   end;

procedure IniEcran;
   begin
      cadrer;
      recalc_ecran;                       { recalculer les cltures /coef_y }
      DefinirParamsMode3D;
      inietat;                            { crit infos sur la ligne d'tat }
   end;

procedure IniFondEcran;
   begin
      ini_par_ecr;
      ini_format (formatpapier) ;   { initialise format de papier / traceur }
      inicoul_cfg;
      fond_ecran (coulecran);         { = coulecran=coulboite  }
      affichemenu;
      dess_icones;
      ini_titre;                                     { affiche titre rgion }
   end;

procedure graduer_exterieur_xy (trac, eff : boolean);
   var
      ixy,
      denom,
      px,   py,                                { v t }
      dx,   dy,
      DXG,  DYG         : real;  { mm }        { dcalages du cartouche }
      ctir,
      cetiqx, cetiqy    : couleur_palette;     { var temporaires }
      nbdec             : word;

   begin
(*      ctir   := coulbord;
      cetiqx := coulaxex;
      cetiqy := coulaxey;
      if trac
      then begin
         ini_traceur;
         ecran   := false
      end else begin
         if eff
         then begin
            ctir    :=  coulfond_e;
            cetiqx  :=  coulfond_e;
            cetiqy  :=  coulfond_e;
            setcolor (numcouleur (coulfond_e));
         end;
         ecran   := true;
         traceur := false
      end;
      fenetre (fc1, fc2, fc3, fc4);
      pleinecloture;
      cloture (cc1, cc2, cc3, cc4);

      ixy   := inter_xy;
      nbdec := nbdec_xy;
      if gradauto
      then begin
         ixy := 0;
         recalculerunitx (ixy, nbdec);
      end;

      prep_graduation_2d (px, py, dx, dy);
                                    { calculer position et dimensions en mm }
      fenetre         (0, trunc (papier_x), 0, trunc (papier_y));
      cloturemilli    (0, trunc (papier_x), 0, trunc (papier_y));
                              { en millimtres position x, y, taille   x, y }

      denom :=   (fc2-fc1) * degkm *10       { 1cm ---> n Km }
              / dx    ;

      dxg     := 1;         { initialiser les dcalages : modifier px et py }
      dyg     := 1;

      graduer_xy ( 1,                      { sens }
                   px,                     { coin g graphe mm }
                   py-dyg,                 { coin g           }
                   dx,                     { largeur cartouche mm }
                   0,                      { hauteur cartouche (0 si 2d) }
                   fc1,                    { min fentre graduation      }
                   fc2,                    { max                         }
                   ixy,                    { intervalle entre tiquettes }
                   htir_xy,                { hauteur tiret mm }
                   nbti_xy,                { nb tirets intermdiaires }
                   nbdec,                  { nb dcimales }
                   cetiqx,
                   cetiqx,
                   1,
                   hcar_xy,
                   titr1);

      graduer_xy ( -1,                     { sens }
                   px-dxg,                 { coin g graphe mm }
                   py,                     { coin g }
                   0.001,                  { largeur cartouche mm }
                   dy,                     { hauteur cartouche (0 si 2d) }
                   fc3,                    { min fentre graduation }
                   fc4,                    { max                    }
                   ixy,                    { intervalle entre tiquettes }
                   htir_xy,                { hauteur tiret mm }
                   nbti_xy,                { nb tirets intermdiaires }
                   nbdec,                  { nb dcimales }
                   cetiqy,                   { }
                   cetiqy,                 { }
                   1,                   { police pour graduations }
                   hcar_xy,
                   titr2);                 { }

      if trac
      then begin
         libere_traceur;
         ecran   := true
      end;
      fenetre (fc1, fc2, fc3, fc4);
      pleinecloture;
  *) end;

procedure fond_boite ;
   begin
      if ecran
      then begin
         coulbar (1, coulboite);
         bar (0, 0, cc2-cc1, cc4-cc3);
      end;
   end;

procedure DefinirParamsMode3D;
   {------------------------------------------------------------------------}
   { A excuter aprs liregrille ou par raz                                 }
   {------------------------------------------------------------------------}
   begin
      if LaGrille.nbcog > LaGrille.nblig
      then begin
         if rho = 0
         then
            rho := 3.5*LaGrille.nbcog;
         if (fb1=0) or (fb2=0) or (fb3=0) or (fb4=0)
         then
            Cadrer3D (-5*LaGrille.nbcog, 5*LaGrille.nbcog,
                      -5*LaGrille.nbcog, 5*LaGrille.nbcog);
         if Divz = 0
         then
            DivZ := (LaGrille.Maxzg-LaGrille.Minzg) /LaGrille.nbcog*4;
      end else begin
         if rho = 0
         then
            rho := 3.5*LaGrille.nblig;
         if (fb1=0) or (fb2=0) or (fb3=0) or (fb4=0)
         then
            Cadrer3D (-5*LaGrille.nblig, 5*LaGrille.nblig,
                      -5*LaGrille.nblig, 5*LaGrille.nblig);
         if Divz = 0
         then
            DivZ := (LaGrille.Maxzg-LaGrille.Minzg) /LaGrille.nbcog*4;
      end;

      de    := 7*Rho;

      projection := perspective;
      initialiseProjection;
      place_centre (LaGrille.nbcog/2, LaGrille.nblig/2, 0);
      direc_soleil (ThetaSol, PhiSol);
      base  := true;

      ZBase := LaGrille.MinZG - (LaGrille.Maxzg-LaGrille.minzg)/4;
   end;

procedure cadrer3D (f1, f2, f3, f4 : real);
   {------------------------------------------------------------------------}
   { ROLE                                                                   }
   {------------------------------------------------------------------------}
   var
      coefc             : real;

   begin
      fb1   := f1;
      fb2   := f2;
      fb3   := f3;
      fb4   := f4;

      coefc := (maxc2 - cc1 ) / (maxc4 - cc3);
      fb1   := fb1 * coefc;
      fb2   := fb2 * coefc;
   end;

procedure FixerAltitudeBase (z : real);
   {------------------------------------------------------------------------}
   { ROLE                                                                   }
   {------------------------------------------------------------------------}
   begin
      Zbase := z;
   end;

procedure determiner_sens;
   {------------------------------------------------------------------------}
   { ROLE dtermine le sens de balayage de la grille                        }
   {------------------------------------------------------------------------}
   begin
      if theta < 45
      then begin
         Xdabord := false;
         sensX   := -1;
         sensY   := 1;
      end else
         if theta <= 135
         then begin
            Xdabord := true;
            sensX   := -1;
            sensY   := -1;
         end else
            if theta < 225
            then begin
               Xdabord := false;
               sensX   := 1;
               sensY   := -1;
            end else
               if theta <= 315
               then begin
                  Xdabord := true;
                  sensX   := 1;
                  sensY   := 1;
               end else
                  if theta < 360
                  then begin
                     Xdabord := false;
                     sensX   := -1;
                     sensY   := 1;
                  end;

      if Xdabord
      then begin
         b := LaGrille.NbCog;
         a := LaGrille.NbLig
      end else begin
         b := LaGrille.NbLig;
         a := LaGrille.NbCog
      end;

      if Xdabord
      then begin
         x1 := b;
         y1 := 1;
         x2 := 1;
         y2 := a
      end else begin
         x1 := a;
         y1 := 1;
         x2 := 1;
         y2 := b
      end;
      x1 := -(LaGrille.NbCog+1)*((sensX-1) div 2)+x1*sensX;
      y1 := -(LaGrille.NbLig+1)*((sensY-1) div 2)+y1*sensY;
      x2 := -(LaGrille.NbCog+1)*((sensX-1) div 2)+x2*sensX;
      y2 := -(LaGrille.NbLig+1)*((sensY-1) div 2)+y2*sensY;
   end;

procedure trame (a, b, c, d, e, f, g, h, i, j, k, l : real);
   {------------------------------------------------------------------------}
   { ROLE                                                                   }
   {------------------------------------------------------------------------}
   var
      px,  py,  pz,
      px1, py1, pz1,
      px2, py2, pz2,
      co                : real;

   begin
      px1 := b*f-c*e;
      py1 := c*d-a*f;
      pz1 := a*e-b*d;
      px2 := h*l-i*k;
      py2 := i*j-g*l;
      pz2 := g*k-h*j;
      if pz1 < 0
      then begin
         pz1 := -pz1;
         px1 := -px1;
         py1 := -py1
      end;
      if pZ2 < 0
      then begin
         pz2 := -pz2;
         px2 := -px2;
         py2 := -py2
      end;
      px := px1+px2;
      py := py1+py2;
      pz := pz1+pz2;
      co := px*Xsoleil+py*Ysoleil+pz*Zsoleil;
      d  := (sqrt (px*px +py*py +pz*pz)
            *sqrt (sqr (Xsoleil) +sqr (Ysoleil) +sqr (Zsoleil)));
      co := -co/d;
      if co < 0
      then
         setfillpattern (gris [trunc (7* (1+co))], getcolor)
      else
         setfillpattern (gris [7], getcolor);

      setfillstyle (12, getcolor)
   end;

procedure trame3 (px1, py1, pz1, px2, py2, pz2, px3, py3, pz3 : real);
   {------------------------------------------------------------------------}
   { ROLE                                                                   }
   {------------------------------------------------------------------------}
   var
      px,  py,  pz,
      d,
      co                : real;

      coul : word;
   begin
      px1 := px3-px1;
      py1 := py3-py1;
      pz1 := pz3-pz1;

      px2 := px3-px2;
      py2 := py3-py2;
      pz2 := pz3-pz2;

      { il faut calculer la perpendiculaire (px, py, pz) aux 2 vecteurs... }
      if pz1 < 0
      then begin
         pz1 := -pz1;
         px1 := -px1;
         py1 := -py1
      end;
      if pZ2 < 0
      then begin
         pz2 := -pz2;
         px2 := -px2;
         py2 := -py2
      end;
      px := py1*pz2 - pz1*py2;
      py := pz1*px2 - px1*pz2;
      pz := px1*py2 - py1*px2;

      {...et calculer l'angle de cette normale avec la direction du soleil }
      co := px*Xsoleil+py*Ysoleil+pz*Zsoleil;
      if co < 0
      then
         co := -co;

      d  := (sqrt (px*px +py*py +pz*pz)
            * sqrt (sqr (Xsoleil) + sqr (Ysoleil) + sqr (Zsoleil)));
      co := -co/d;
  coul := getcolor;
      { ... pour affecter la trame }
      if co < 0
      then
         setfillpattern (gris [trunc(7*(1+co))], getcolor)
      else
         setfillpattern (gris [7], getcolor);

      setfillstyle (12, getcolor)
   end;

procedure TracerNord;
   {------------------------------------------------------------------------}
   { ROLE                                                                   }
   {------------------------------------------------------------------------}
   var
      dl, dl2           : real;

   begin
      dl  := (y2+y1)/40;
      dl2 := 2*dl;
      with LaGrille
      do begin
         { flche nord gauche }
         deplaceen3d (1 - dl,        - dl2 + Nblig, Zbase);
         tracevers3d (1,             Nblig,         Zbase);
         tracevers3d (1 + dl,        - dl2 + Nblig, Zbase);
         { N }
         deplaceen3d (1 - 2 * dl2,   - dl2 + Nblig, Zbase);
         TraceVers3d (1 - 2 * dl2,           Nblig, Zbase);
         TraceVers3d (1 -     dl2,   - dl2 + Nblig, Zbase);
         TraceVers3d (1 -     dl2,           Nblig, Zbase);

         { flche nord gauche }
         deplaceen3d (NbCog - dl,    - dl2 + Nblig, Zbase);
         tracevers3d (NbCog,         Nblig,         Zbase);
         tracevers3d (NbCog + dl,    - dl2 + Nblig, Zbase);
         { N }
         deplaceen3d (NbCog + dl2,   - dl2 + Nblig, Zbase);
         TraceVers3d (NbCog + dl2,           Nblig, Zbase);
         TraceVers3d (NbCog + 2*dl2, - dl2 + Nblig, Zbase);
         TraceVers3d (NbCog + 2*dl2,         Nblig, Zbase);
      end;
   end;

procedure DessinerPlus;
   {------------------------------------------------------------------------}
   { ROLE                                                                   }
   {------------------------------------------------------------------------}
   begin
      co := coulecran;
      with LaGrille
      do begin
         setcolor (15 Xor co);

         deplaceen3d (x1, y1, MaxZg);
         tracevers3d (x1, y2, MaxZg);
         tracevers3d (x2, y2, MaxZg);
         tracevers3d (x2, y1, MaxZg);
         tracevers3d (x1, y1, MaxZg);

         { Bton }
         setcolor (3 Xor Co);
         direc_soleil(ThetaSol, PhiSol);
         deplaceen3d ((x2+x1)/2, (y2+y1)/2, Zbase);
         TraceVers3d ((x2+x1)/2, (y2+y1)/2, Zbase+DivZ*zsoleil*NbLig/6);

         { Ombre }
         SetColor (0 Xor Co);
         deplaceen3d ((x2+x1)/2, (y2+y1)/2, Zbase);
         tracevers3d ((x2+x1)/2 - xsoleil*NbLig/6,
                      (y2+y1)/2 - ysoleil*NbLig/6,
                      ZBase);

         { Rayon }
         SetLineStyle (Dashedln, 0, 1);
         SetColor (2 Xor Co);
         tracevers3d ((x2+x1)/2 + xsoleil*NbLig/6,
                      (y2+y1)/2 + ysoleil*NbLig/6,
                       ZBase+divZ*zsoleil*NbLig/3 );
         Projette    ((x2+x1)/2 + xsoleil*NbLig/6,
                      (y2+y1)/2 + ysoleil*NbLig/6,
                       ZBase+divZ*zsoleil*NbLig/3 );

         SetLineStyle (0, 0, 1);
      end;
   end;

procedure DessinerBase (mode : byte);
   {------------------------------------------------------------------------}
   { ROLE                                                                   }
   {------------------------------------------------------------------------}
   begin
      co := Coulecran;
      with LaGrille
      do begin
         if mode = 0
         then
            setcolor (numcouleur (nomcouleur (c_BORD)))
         else
            setcolor (numcouleur (nomcouleur (c_BORD)) xor Co);

         TracerNord;
         deplaceen3d (x1, y1, Valeur (x1, y1));
         tracevers3d (x1, y1, Zbase);
         tracevers3d (x1, y2, Zbase);
         tracevers3d (x1, y2, Valeur (x1, y2));
         deplaceen3d (x1, y2, Zbase);
         tracevers3d (x2, y2, Zbase);
         tracevers3d (x2, y2, Valeur (x2, y2));
         deplaceen3d (x2, y2, Zbase);
         tracevers3d (x2, y1, Zbase);
         tracevers3d (x2, y1, Valeur (x2, y1));
         deplaceen3d (x2, y1, Zbase);
         tracevers3d (x1, y1, Zbase);
      end;
   end;

procedure DessinerBloc;
   {------------------------------------------------------------------------}
   {------------------------------------------------------------------------}
   begin
      fenetre (fb1, fb2, fb3, fb4);
      cloture (cc1, cc2, cc3, cc4);
      determiner_sens;
      SetWriteMode (1);
      DessinerBase (1);
      DessinerPlus;
      SetWriteMode (0);
      PleineCloture;
   end;

procedure Graduer3D;
   {------------------------------------------------------------------------}
   { ROLE                                                                   }
   {    DterminerSens doit dj tre excute.                             }
   {------------------------------------------------------------------------}
   var
      Ux, Uy, Uz,       { Unit de graduation en coordonnes carte          }
      Ux2, Uy2, Uz2,    { Unit de graduation en coordonnes grille         }
      x, y, z,          {                                                   }
      x0, y0,           { Axes de graduation en X et Y                      }
      xz0, yz0,         { Coordonnes de l'axe de graduation en Z           }
      xz3, yz3,
      xz1, yz1, zi,
      sx, sy,
      xx,
      v                 {  }
                        : real;

      bo,
      NbDX, NbDY,
      NbDZ              {  }
                        : word;

      texte             {  }
                        : t12;

      divxy             { diviseur nblignes ou col pour calculer tiret }
                        : integer;

   begin
      fenetre (fb1, fb2, fb3, fb4);
      cloture (cc1, cc2, cc3, cc4);

      setusercharsize (1, 1, 1, 1);

      divxy := 25;
      fixecoul (c_axex);
      Ux := 0;
      Uy := 0;
      Uz := 0;
      UniteDeGraduation (LaGrille.MinXG, LaGrille.MaxXG, Ux, NbDX);
      UniteDeGraduation (LaGrille.MinYG, LaGrille.MaxYG, Uy, NbDY);
      UniteDeGraduation (ZBase,          LaGrille.MaxZg, Uz, NbDZ);
      uz  := 2 * uz;
      ux2 := (LaGrille.NbCog * Ux) / (LaGrille.MaxXG-LaGrille.MinXG);
      uy2 := (LaGrille.NbLig * Uy) / (LaGrille.MaxYG-LaGrille.MinYG);

      {* RECHERCHE DES AXES PORTEURS DE GRADUATIONS }
      y := cc4;
      x := cc2;
      projette (1, 1, 0);
      if Ordonnee < y
      then begin
         y   := ordonnee;
         x0  := 1;
         y0  := 1;
         sx  := -1;                                     { sens }
         sy  := -1                                      {  "   }
      end;
      if abscisse < x
      then begin
         x   := abscisse;
         xz0 := 1;
         yz0 := 1;
      end;

      projette (1, LaGrille.nblig, 0);
      if Ordonnee < y
      then begin
         y   := ordonnee;
         x0  := 1;
         y0  := LaGrille.nblig;
         sx  := -1; sy := 1
      end;
      if abscisse < x
      then begin
         x   := abscisse;
         xz0 := 1;
         yz0 := LaGrille.nblig;
      end;

      projette (LaGrille.nbcog, LaGrille.nblig, 0);
      if Ordonnee < y
      then begin
         y   := ordonnee;
         x0  := LaGrille.nbcog;
         y0  := LaGrille.nblig;
         sx  := 1;
         sy  := 1
      end;
      if abscisse < x
      then begin
         x   := abscisse;
         xz0 := LaGrille.nbcog;
         yz0 := LaGrille.nblig;
      end;

      projette (LaGrille.nbcog, 1, 0);
      if Ordonnee < y
      then begin
         y   := ordonnee;
         x0  := LaGrille.nbcog;
         y0  := 1;
         sx  := 1;
         sy  := -1
      end;
      if abscisse < x
      then begin
         x   := abscisse;
         xz0 := LaGrille.nbcog;
         yz0 := 1;
      end;

      x := 1;                        { Valeurs en X }
      repeat
         v := LaGrille.MinXG+
             (LaGrille.MaxXG-LaGrille.MinXG)*(x-1)/(LaGrille.nbcog-1);
         str (v:0:NbDX, texte);
         DeplaceEn3D  (x, y0,                           ZBase);
         TraceVers3D  (x, y0+sy*LaGrille.nblig/divxy,   ZBase);
         DeplaceEn3DT (x, y0+2*sy*LaGrille.nblig/divxy, ZBase);
         TTexte (texte, 1, 1);
         x := x + Ux2;
      until x > LaGrille.NbCog;

      y := 1;
      repeat                         { VAleurs en Y }
         v := LaGrille.MinYG+
             (LaGrille.MaxYG-LaGrille.MinYG)*(y-1)/(LaGrille.nblig-1);
         str (v:0:NbDY, texte);
         DeplaceEn3D  (x0,                           y, ZBase);
         TraceVers3D  (x0+Sx*LaGrille.nbcog/divxy,   y, ZBase);
         DeplaceEn3DT (x0+2*Sx*LaGrille.nbcog/divxy, y, ZBase);
         TTexte (texte, 1, 1);
         y := y + Uy2;
      until y > LaGrille.NbLig;

      xz1 := xz0-sensx*(LaGrille.nbcog)/divxy;
      yz1 := yz0-sensy*(LaGrille.nblig)/divxy;
      xz3 := xz0-sensx*(LaGrille.nbcog)/divxy/2;
      yz3 := yz0-sensy*(LaGrille.nblig)/divxy/2;

      if not traceur and not copie_en_cours
      then begin                           { lgende sur l'axe Z }
         zi := LaGrille.Minzg;
         for bo := 1 to NbClasses
         do begin
            z := bornes [bo];
            setfillstyle (1, 8+bo-1);
            Carre3D (xz0, yz0, zi, xz0, yz0, z,
                     xz3, yz3, z,  xz3, yz3, zi, 8+bo-1);
            zi := z;
         end;
         fixecoul (c_axex);
      end;

      fixecoul (c_axey);
      z := uz;
      repeat                                  { valeurs > 0 en Z }
         str (z:0:NbDZ, texte);
         DeplaceEn3D  (xz0, yz0, z);
         TraceVers3D  (xz1, yz1, z);
         DeplaceEn3DT (xz1, yz1, z);
         TTexte (texte, 2, 1);
         z := z + Uz;
      until z > LaGrille.maxZg;

      z := 0;
      repeat                                  { valeurs < 0 en Z }
         str (z:0:NbDZ, texte);
         DeplaceEn3D (xz0, yz0, z);
         TraceVers3D (xz1, yz1, z);
         TTexte (texte, 2, 1);
         z := z - Uz;
      until z < LaGrille.MinZg;

      setusercharsize (3, 2, 3, 2);
      pleinecloture;
   end;

procedure CalculerBornes;
   {------------------------------------------------------------------------}
   { ROLE                                                                   }
   {------------------------------------------------------------------------}

   procedure BornesEquidistantes;
      {---------------------------------------------------------------------}
      { ROLE Calculer la valeur des bornes quidistantes (intervalle const.)}
      {---------------------------------------------------------------------}
   var
      n              : integer;  { Compteur des bornes }

   begin
      with LaGrille
      do begin
         for n := 1 to NbClasses
         do begin
            Bornes [n] := MinZg + n * ((MaxZg-MinZg)
                      / (NbClasses));
         end;
      end;
   end;

   procedure BornesAutourDeZero;
      {---------------------------------------------------------------------}
      { Calculer 3 classes sous 0 et 4 au dessus                            }
      {---------------------------------------------------------------------}
   var
      n              : integer;  { Compteur des bornes }

   begin
      with LaGrille
      do begin
         for n := 1 to (NbClasses div 2)
         do begin
            Bornes [n] := minzg + n * ((0-MinZg)
                          / (NbClasses div 2));
         end;
         for n := 1 + (NbClasses div 2) to NbClasses
         do begin
            Bornes [n] := 0 + (n- NbClasses div 2) * ((maxzg)
                          / (NbClasses - (NbClasses div 2)));
         end;
      end;
   end;

   procedure ClassesEquiprobables;
      {---------------------------------------------------------------------}
      { ROLE Calculer la valeur des bornes telles que il y ai autant de     }
      {    points dans chaque classe.                                       }
      {---------------------------------------------------------------------}
   type
      THisto         = Array [0..255] of integer;

   var
      Histo            { histogramme des valeurs (255 classes)              }
                     : ^THisto;

      Cumul,           { Cumul du nombre de points pour recherche de bornes }
      b,               { Classe de l'histogramme                            }
      n,               { Compteur des bornes                                }
      i, j,            { Compteurs de colonnes et lignes                    }
      NbP              { Nombre de points diffrents de zro                }
                     : longint;

   begin
      {* RECHERCHE DU NB DE PTS <> 0 }
      with LaGrille
      do begin
         NbP := NbLig * NbCog;

         {* CALCUL DU NOMBRE DE POINTS PAR CLASSE }
         n := NbP div (NbClasses);

         {* CONSTRUCTION HISTOGRAMME }
         new (Histo);
         for i := 0 to 255
         do
            Histo^[i] := 0;
         for j := 1 to nblig
         do
            for i := 1 to nbcog
            do begin
               if Valeur (i, j) <> 0
               then begin
                  b := trunc ( 255 * ((Valeur (i, j) - Minzg) / (Maxzg-Minzg)));
                  inc (Histo^[b]);
               end;
            end;

         {* RECHERCHE DES BORNES }
         b := 1;
         cumul := 0;
         for i := 0 to 255
         do begin
            Cumul := Cumul + Histo^[i];
            if (b <= NbClasses) and (Cumul > n * (b) )
            then begin
               Bornes [b] := Minzg + (i/255) * (MaxZg-MinZg);
               inc (b);
            end;
         end;
         Bornes [NbClasses] := MaxZg;
         dispose (histo);
      end;
   end;

   begin
      {* CALCUL DES BORNES }
      case ModeAff of
         {* CAS DE L'EQUIDISTANCE }
         1 : BornesEquidistantes;
         {* CAS DE L'EQUIPOPULATION }
         2 : ClassesEquiprobables;
         {* 3 cl < 0 et 4 cl > 0 }
         3 : BornesAutourDeZero;
      end;
   end;

function CouleurClasse (v : real) : integer;
   {------------------------------------------------------------------------}
   { ROLE }
   {------------------------------------------------------------------------}
   var
      n                 : integer;

   begin
      n := 0;
      repeat
         inc (n);
      until (n = NbClasses) or (v <= Bornes[n]);

      if v <= Bornes[n]
      then
         CouleurClasse := 8 + n - 1
      else
         CouleurClasse := 8;
   end;

procedure AfficherAngles (trac : boolean);
   {------------------------------------------------------------------------}
   { ROLE }
   {------------------------------------------------------------------------}
   var
      x0, y0            : real;
      xe, ye,
      px1, px2,
      py,
      a,   s            : integer;
      cha, chs          : t20;

   begin
      px1 := maxc1 + 2;
      px2 := maxc2 - 2;
      py  := maxy - maxc3 - 2;

      { Direction de l'observateur par rapport au centre du bloc
      et non direction du regard }
      a := (360 + 180 - (round (Theta) + 90)) mod 360;

      (*   { Direction du regard l'observateur }
            a := (360 + 360 - (round (Theta) + 90)) mod 360; *)

      s := round (Phi);
      str (a, cha);
      str (s, chs);
      if (a = 0) and (s = 0)
      then
         cha := '?';
      cha := 'azimut  : ' + cha;
      chs := 'hauteur : ' + chs;
      if trac
      then begin
         fenetrecloturecrantrac_b (false);
         xe  := xecran (fb1);
         ye  := yecran (fb3);

         fenetrecloturemilli;
         x0  := xutilisateur (xe);
         y0  := yutilisateur (ye);
         deplaceenT (x0, y0);
         ttexte (cha, 2, 0);

         fenetrecloturecrantrac_b (false);
         xe  := xecran (fb2);

         fenetrecloturemilli;
         x0  := xutilisateur (xe);

         deplaceenT (x0, y0);
         ttexte (chs, 0, 2);
         pleinecloture;
      end else begin
         setusercharsize (1, 1, 1, 1);
         coulbar (1, coulboite);
         bar       (px1, py-textheight (chs), px1+textwidth (chs+' '), py);
         fixecoul  (coul_t);
         settextjustify (0, 0);
         outtextxy (px1, py, chs);
         bar       (px2-textwidth (cha+' ')-1, py -textheight (cha), px2, py);
         fixecoul  (coul_t);
         settextjustify (2, 0);
         outtextxy (px2, py, cha);
         settextjustify (0, 2);
         setusercharsize (3, 2, 3, 2);
      end;
   end;

procedure AfficherMode3D;
   {------------------------------------------------------------------------}
   { ROLE                                                                   }
   {------------------------------------------------------------------------}
   var
      code,
      i,   j, co,
      x,   y            : integer;
      v11, v12,
      v21, v22, vg,
      vg1, vg2,
      vg3, vg4,
      xg,  yg, zg       : real;

   begin
      with LaGrille
      do begin
         if BlocVisible
         then
            BlocVisible := false;
         Coulbar (SolidFill, coulecran);
         bar (0, hauteurmenu, maxc2, maxy-maxc3);     { couleur fond cran }
         fenetre (fb1, fb2, fb3, fb4);
         cloture (cc1, cc2, cc3, cc4);
         { EffacerCloture;}
         determiner_sens;
         DessinerBase (0);
         CalculerBornes;
         if not grad and not ombre
         then begin
            pleinecloture;
            exit;
         end;
         for j := a-1 downto 1
         do begin
            for i := 1 to b-1
            do begin
               if Xdabord
                  then begin
                     x := i;
                     y := j
                  end else begin
                     x := j;
                     y := i
                  end;

               x   := -(NbCog+1)*((sensX-1) div 2)+x*sensX;
               y   := -(NbLig+1)*((sensY-1) div 2)+y*sensY;

               v11 := valeur (x, y);
               v12 := valeur (x, y+sensy);
               v21 := valeur (x+sensx, y);
               v22 := valeur (x+sensx, y+sensy);

               { rapide := true;}

               if not Rapide     { machine lente : trame carre conserve }
               then begin
                  if grad
                  then begin
                     co := CouleurClasse (V11);
                     setcolor (co);
                  end else
                     setcolor (coulecran);

                  if ombre
                  then begin
                     if copie_en_cours
               {      then
                        setcolor (0) ;}
                     then begin
                        if qual = 4
                        then setcolor (15)
                        else setcolor (0);
                     end;

                     trame (sensX,  0,       (V21 -V11)/divZ,
                            0,      sensY,   (V12 -V11)/divZ,
                            -sensX, 0,       (V12 -V22)/divZ,
                            0,      -sensY,  (V21 -V22)/divZ)
                  end else
                        setfillstyle (1, getcolor);

                  carre3d ( x,       y,       V11,
                            x+sensX, y,       V21,
                            x+sensX, y+sensY, V22,
                            x,       y+sensY, V12, co);

               end else begin
                  { machine rapide : chaque carr est dcoup en 4 triangles }

                  { le centre du carr }
                  xg  := x + sensx / 2;
                  yg  := y + sensy / 2;
                  zg  := (V11 + V12 + V21 + V22) / 4;
                  vg  := (v11 + v12 + v21 + v22) / 4;

                  { les centres des 4 triangles }
                  vg1 := (vg + v11 + v21) / 3;
                  vg2 := (vg + v21 + v22) / 3;
                  vg3 := (vg + v12 + v22) / 3;
                  vg4 := (vg + v12 + v11) / 3;

                  co := coulecran;
                  setfillstyle (1, getcolor);

                  if grad                           { triangle 1 }
                  then
                     co := CouleurClasse (vg1);
                  setcolor (co);

                  if ombre
                  then begin
                     if copie_en_cours
                     then begin
                        if qual = 4
                        then setcolor (15)
                        else setcolor (0);
                     end;
                     trame3  (xg,      yg,      zg  / DivZ,
                              x,       y,       v11 / DivZ,
                              x+sensx, y,       v21 / DivZ);
                  end;
                  triangle3D (xg,      yg,      zg,
                              x,       y,       v11,
                              x+sensx, y,       v21,        co);

                  if grad                           { triangle 2 }
                  then
                     co := CouleurClasse (Vg2);
                  setcolor (co);

                  if ombre
                  then begin
                     if copie_en_cours
                  {   then
                        setcolor (0) ;}
                     then begin
                        if qual = 4
                        then setcolor (15)
                        else setcolor (0);
                     end;
                     trame3  (xg,      yg,      zg  / DivZ,
                              x+sensx, y,       v21 / DivZ,
                              x+sensx, y+sensy, v22 / DivZ);
                  end;
                  Triangle3D (xg,      yg, zg,
                              x+sensx, y, v21,
                              x+sensx, y+sensy, v22,        co);

                  if grad                           { triangle 3 }
                  then
                     co := CouleurClasse (Vg3);
                  setcolor (co);

                  if ombre
                  then begin
                     if copie_en_cours
                    { then
                        setcolor (0) ;}
                     then begin
                        if qual = 4
                        then setcolor (15)
                        else setcolor (0);
                     end;
                     trame3  (xg,      yg,      zg  / DivZ,
                              x,       y+sensy, v12 / DivZ,
                              x+sensx, y+sensy, v22 / DivZ);
                  end;
                  Triangle3D (xg,      yg,      zg,
                              x,       y+sensy, v12,
                              x+sensx, y+sensy, v22,        co);

                  if grad                           { triangle 4 }
                  then
                     co := CouleurClasse (Vg4);
                  setcolor (co);

                  if ombre
                  then begin
                    if copie_en_cours
                  {   then
                        setcolor (0) ;}
                     then begin
                        if qual = 4
                        then setcolor (15)
                        else setcolor (0);
                     end;
                     trame3  (xg,      yg,      zg  / DivZ,
                              x,       y+sensy, v12 / DivZ,
                              x,       y,       v11 / DivZ);
                  end;
                  Triangle3D (xg,      yg,      zg,
                              x,       y+sensy, v12,
                              x,       y,       v11,        co);

               end; { fin else "rapide" }
            end;

            if ToucheClavier (Code)
            then begin
               if Code = ESC
               then begin
                  PleineCloture;
                  exit;
               end;
            end;
         end;
         pleinecloture;
      end;
{      AfficherAngles;      }
   end;

procedure tracer3D;
   {------------------------------------------------------------------------}
   { ROLE                                                                   }
   { dessine le terrain en relief sur table traante Sekonic                }
   {------------------------------------------------------------------------}
   const
      maxk  = 500;

   var
      code,
      x, y,
      xmini, xmaxi,
      j, k, k1, k2,
      nbpts, nbcou,
      p, p1, i       : integer;

      x0, y0, z0,
      xx,  yy,
      xd,  yd,
      vx,  vy,
      vx2, vy2       : real;

      bord_gauche,
      bord_droit,
      trouve,
      dep            : boolean;

      lcou, lsup,
      ls2            : array [1..maxk] of
                           record x, y : real; end;

      function secants (var x, y : real;
                        x1, y1, xx1, yy1,
                        x2, y2, xx2, yy2 : real) : boolean;
         {---------------------------------------------------------------------}
         { ROLE   teste si les segments 1 et 2 sont scants                    }
         {              et renvoie ventuellement le point d'intersection (x,y)}
         {---------------------------------------------------------------------}

      var
         p1, p2, p3, p4,
         verti1, verti2    : boolean;

         a1, b1, a2, b2    : real;

         v                 : real;

      begin
         { si deux points sont confondus, les segments ne sont pas scants     }
         if ((x1 = xx1) and (y1 = yy1)) or ((x1 = x2 ) and (y1 = y2 )) or
            ((x1 = xx2) and (y1 = yy2)) or ((xx1= x2 ) and (yy1= y2 )) or
            ((xx1= xx2) and (yy1= yy2)) or ((x2 = xx2) and (y2 = yy2))
         then begin
            secants := false;
            exit
         end;

         v := xx1-x1;
         if v <> 0
         then begin
            a1 := (yy1-y1)/(xx1-x1);
            b1 := y1-a1*x1;
            verti1 := false;
         end else
            verti1 := true;

         v := xx2-x2;
         if v <> 0
         then begin
            a2 := (yy2-y2)/(xx2-x2);
            b2 := y2-a2*x2;
            verti2 := false;
         end else
            verti2 := true;

         secants := true;
         if verti1
         then begin
            p1 := y1  > (a2*x1+ b2); { point 1 au dessus  }
            p2 := yy1 > (a2*xx1+b2); { point 2 au dessous }
            p3 := x2  < x1;          { point 3   gauche  }
            p4 := xx2 < x1;
            x  := x1;
            y  := a2*x1+b2;
         end else
            if verti2
            then begin
               p1 := y2  > (a1*x2+ b1); { point 1 au dessus  }
               p2 := yy2 > (a1*xx2+b1); { point 2 au dessous }
               p3 := x1  < x2;          { point 3   gauche  }
               p4 := xx1 < x2;
               x  := x2;
               y  := a1*x2+b1;
            end else begin
               p1 := y2  > (a1*x2+ b1); { point 1 au dessus }
               p2 := yy2 > (a1*xx2+b1); { point 2 au dessous }
               p3 := y1  > (a2*x1+ b2);
               p4 := yy1 > (a2*xx1+b2);
               if (a1-a2)<>0
               then begin
                  x := (b2-b1)/(a1-a2);
                  y := a1*x+b1;
               end
            end;
         if (p1 and p2) or (not p1 and not p2) or
            (p3 and p4) or (not p3 and not p4)
         then
            secants := false;
      end;

      procedure init_crete;
         {---------------------------------------------------------------------}
         { ROLE    Initialise les 2 tableaux de gestion de crte               }
         {---------------------------------------------------------------------}
      var
         i           : integer;

      begin
         for i := 1 to 500
         do begin
            lsup [i].x := 0;        lsup [i].y := ybfen;
            ls2  [i].x := 0;        ls2  [i].y := ybfen;
         end;
         lsup [1].x := ((xmaxi+xmini) div 2) -1;
         lsup [2].x := ((xmaxi+xmini) div 2) +1;
         nbpts := 2;
      end;

      procedure init_crete2;
         {---------------------------------------------------------------------}
         { ROLE    Initialise les 2 tableaux de gestion de crte               }
         {---------------------------------------------------------------------}
      var
         i           : integer;

      begin
         for i := 1 to 500
         do begin
            lsup [i].x := 0;        lsup [i].y := ybfen;
            ls2  [i].x := 0;        ls2  [i].y := ybfen;
         end;
         lsup [1].x := ((lcou[1].x + lcou[nbcou].x) / 2) - 1;
         lsup [2].x := ((lcou[1].x + lcou[nbcou].x) / 2) + 1;
         nbpts := 2;
      end;

      procedure dessiner_base;
         {---------------------------------------------------------------------}
         { ROLE                                                                }
         {---------------------------------------------------------------------}

      type
         segment        = record
                             x1, y1, x2, y2 : integer
                          end;

      var
         points         : array [1..4] of segment;
         i, pp          : integer;

      begin
         with LaGrille
         do begin
            bord_gauche := false;
            bord_droit  := false;
            projette (1, 1, Zbase);
                     points [1].x1 := abscisse;
                     points [1].y1 := ordonnee;

            projette (1, 1, Valeur (1,1));
                     points [1].x2 := abscisse;
                     points [1].y2 := ordonnee;

            projette (NbCog, 1, Zbase);
                     points [2].x1 := abscisse;
                     points [2].y1 := ordonnee;

            projette (NbCog, 1, Valeur (nbcog, 1));
                     points [2].x2 := abscisse;
                     points [2].y2 := ordonnee;

            projette (NbCog, NbLig, Zbase);
                     points [3].x1 := abscisse;
                     points [3].y1 := ordonnee;

            projette (NbCog, NbLig, Valeur (nbcog,nblig));
                     points [3].x2 := abscisse;
                     points [3].y2 := ordonnee;

            projette (1, NbLig, Zbase);
                     points [4].x1 := abscisse;
                     points [4].y1 := ordonnee;

            projette (1, NbLig, Valeur (1, nblig));
                     points [4].x2 := abscisse;
                     points [4].y2 := ordonnee;

            xmini := 10000;
            for i := 1 to 4
            do
               if points [i].x1 < xmini then xmini := points [i].x1;
            xmaxi :=0;
            for i :=1 to 4
            do
               if points [i].x1 > xmaxi then xmaxi := points [i].x1;

            i := 0;
            repeat
               inc (i);
            until points [i].x1 = xmini;
            { i correspond au point le plus  gauche }

            if (points [i].x1 <  points[1+ (i+4) mod 4].x1) and
               (points [i].y1 >  points[1+ (i+4) mod 4].y1)
            then
               bord_gauche := true;

            deplaceen (points [i].x2, points [i].y2);
            tracevers (points [i].x1, points [i].y1);
            repeat
               i := 1+ (i+4) mod 4;
               tracevers (points [i].x1, points [i].y1);
               deplaceen (points [i].x2, points [i].y2);
               tracevers (points [i].x1, points [i].y1);
            until points [i].x1 = xmaxi; {point le plus  droite }

            if (points [i].x1 > points [1+ (i+2) mod 4].x1) and
               (points [i].y1 < points [1+ (i+2) mod 4].y1)
            then
               bord_droit := true;
         end;
      end;

      procedure deplace;
         {---------------------------------------------------------------------}
         { ROLE                                                                }
         {---------------------------------------------------------------------}
      begin
         if not dep
         then
            deplaceenl (xd, yd);
         dep := true;
      end;

      procedure trace;
         {---------------------------------------------------------------------}
         { ROLE                                                                }
         {---------------------------------------------------------------------}
         begin
            if dep
            then
               deplaceen (xd, yd);
            tracevers (ls2 [k2].x, ls2 [k2].y);
            dep := false;
            inc (k2);
         end;

   begin
      with LaGrille
      do begin
         fenetre (fb1, fb2, fb3, fb4);
         cloture (cc1, cc2, cc3, cc4);
         determiner_sens;
         FixeCoul (c_BORD);
         if base
         then
            dessiner_base;
         Fixecoul (c_grille);
    {     init_crete;}

         dep := false;
         for j := 1 to a
         do
            if ((j mod PasF) = 0)
            then begin
               nbcou := 0;
               for i := 1 to b
               do begin
                  if Xdabord
                  then begin
                     x := i;
                     y := j
                  end else begin
                     x := j;
                     y := i
                  end;
                  x := -(NbCog+1)*((sensX-1) div 2)+x*sensX;
                  y := -(NbLig+1)*((sensY-1) div 2)+y*sensY;

                  projette (x,y,Valeur(x, y));

                  lcou [i].x := abscisse;
                  lcou [i].y := ordonnee;

                  nbcou := nbcou+1;
               end;

               { Initialisation de la crte sup en fonction des limites x
                 de la premire crte }
               init_crete2;

               { projection des points de lcou sur lsup }
               k1 := 1;
               for k := 1 to b
               do begin
                  if lsup[k1].x < lcou[k].x
                  then begin
                     while (k1 = 1) or ((lcou[k].x > lsup[k1].x)
                                    and (k1 <= nbpts))
                     do
                        k1 := k1+1;

                     if (k1 <= nbpts) and (lcou[k].x <> lsup[k1].x)
                                      and (lcou[k].x >  lsup[k1-1].x)
                     then begin
                        vx := lsup[k1].x;
                        vy := lsup[k1].y;
                        if (vx-lsup[k1-1].x) <> 0
                        then begin
                           lsup[k1].x := lcou[k].x;
                           lsup[k1].y := vy+(vx-lcou[k].x)*(vy-lsup[k1-1].y)
                                            /(lsup[k1-1].x-vx);

                           for p1 := k1 to nbpts
                           do begin
                              vx2 := lsup[p1+1].x;
                              vy2 := lsup[p1+1].y;
                              lsup[p1+1].x := vx;
                              lsup[p1+1].y := vy;
                              vx  := vx2;
                              vy  := vy2;
                           end;
                           nbpts := nbpts+1;
                        end;
                     end;
                  end;
               end;

               trouve := (lsup[nbpts].x <= lcou[nbcou].x);
               while not trouve do begin
                  trouve := (lsup[nbpts].x <= lcou[nbcou].x);
                  dec (nbpts);
                  trouve := trouve or (nbpts = 0)
               end;

       {        while (lsup[nbpts].x > lcou[nbcou].x) and (nbpts > 1) do
                  dec (nbpts);}

               { projection des points de lsup sur lcou }
               k := 1;
               for k1 := 1 to nbpts
               do begin
                  if lsup[k1].x > lcou[k].x
                  then begin
                     while (k = 1) or ((lsup[k1].x > lcou[k].x)
                                  and (k <= nbcou))
                     do
                        k := k+1;
                     if (k <= nbcou) and (lsup[k1].x <> lcou[k].x)
                                     and (lsup[k1].x >  lcou[k-1].x)
                     then begin
                        vx := lcou[k].x;
                        vy := lcou[k].y;
                        if (vx-lcou[k-1].x) <> 0
                        then begin
                           lcou[k].x := lsup[k1].x;
                           lcou[k].y := vy+(vx-lsup[k1].x)*(vy-lcou[k-1].y)
                                              /(lcou[k-1].x-vx);
                           for p := k to nbcou
                           do begin
                              vx2 := lcou[p+1].x;
                              vy2 := lcou[p+1].y;
                              lcou[p+1].x := vx;
                              lcou[p+1].y := vy;
                              vx := vx2;
                              vy := vy2;
                           end;
                           nbcou := nbcou+1;
                        end;
                     end;
                  end;
               end;

               { calcul et dessin de la nouvelle ligne de crete }

               k2 := 1;
               k  := 1;
               k1 := 1;

               {bout seul  gauche }

               xd := lcou[1].x;
               yd := lcou[1].y;
               {  if (j<a) and bord_gauche then begin
                  if Xdabord
                     then begin x:=1; y:=j+1; end
                     else begin x:=j+1; y:=1 end;
                  x:=-(NbCog+1)*((sensX-1) div 2)+x*sensX;
                  y:=-(NbLig+1)*((sensY-1) div 2)+y*sensY;
                  projette (x,y,Valeur(x, y));
                  deplaceen (abscisse,ordonnee);
                  tracevers (xd,yd);
                  dep := false;
               end else}
                  deplace;
               if lcou[1].x < lsup[1].x
               then begin
                  while lcou[k].x <> lsup[1].x
                  do begin
                     ls2[k2].x := lcou[k].x;
                     ls2[k2].y := lcou[k].y;
                     trace;
                     inc (k);
                  end;
               end else
                  if lcou[1].x > lsup[1].x
                  then begin
                     xd := lsup[1].x;
                     yd := lsup[1].y;
                     deplace;
 {err 201}                    while (lsup[k1].x <> lcou[1].x)
                     do begin
                        ls2[k2].x := lsup[k1].x;
                        ls2[k2].y := lsup[k1].y;
                        xd := ls2[k2].x;
                        yd := ls2[k2].y;
                        deplace;
                        inc (k2);
                        inc (k1);
                     end;
                  end;

               { brin commun }
               repeat
                  if lcou[k].y > lsup[k1].y
                  then begin
                     ls2[k2].x := lcou[k].x;
                     ls2[k2].y := lcou[k].y;
                     trace;
                  end else begin
                     ls2[k2].x := lsup[k1].x;
                     ls2[k2].y := lsup[k1].y;
                     xd := ls2[k2].x;
                     yd := ls2[k2].y;
                     deplace;
                     inc (k2);
                  end;
                  inc (k);
                  inc (k1);

                  if secants (xx, yy,
                              lcou[k -1].x, lcou[k -1].y,
                              lcou[k ].x,   lcou[k ].y,
                              lsup[k1-1].x, lsup[k1-1].y,
                              lsup[k1].x,   lsup[k1].y)
                  then begin
                     if lcou[k].y <= lsup[k1].y
                     then begin
                        ls2[k2].x := xx;
                        ls2[k2].y := yy;
                        trace;
                     end else begin
                        ls2[k2].x := xx;
                        ls2[k2].y := yy;
                        xd := ls2[k2].x;
                        yd := ls2[k2].y;
                        deplace;
                        inc (k2);
                     end;
                  end;

               until (k > nbcou) or (k1 > nbpts);

               { bout seul  droite }
               while (k <= nbcou) or (k1 <= nbpts)
               do begin
                  if k <= nbcou
                  then begin
                     ls2[k2].x := lcou[k].x;
                     ls2[k2].y := lcou[k].y;
                     trace;
                     inc (k);
                  end else begin
                     ls2[k2].x := lsup[k1].x;
                     ls2[k2].y := lsup[k1].y;
                     trace;
                     inc (k1);
                  end;
               end;

               if (j < a) and bord_droit
               then begin
                  if Xdabord
                  then begin
                     x := b;
                     y := j+1
                  end else begin
                     x := j+1;
                     y := b
                  end;
                  x := -(NbCog+1)*((sensX-1) div 2)+x*sensX;
                  y := -(NbLig+1)*((sensY-1) div 2)+y*sensY;
                  projette (x,y,Valeur(x, y));
                  deplaceen (abscisse,ordonnee);
                  if Xdabord
                  then begin
                     x := b;
                     y := j
                  end else begin
                     x := j;
                     y := b
                  end;
                  x := -(NbCog+1)*((sensX-1) div 2)+x*sensX;
                  y := -(NbLig+1)*((sensY-1) div 2)+y*sensY;
                  projette (x,y,Valeur(x, y));
                  tracevers (abscisse,ordonnee);
                  dep := false;
               end;

               { recopie de la ligne de crte et optimisation }
               nbpts := k2-1;

               k2 := 1;
               lsup[k2].x := ls2[1].x;
               lsup[k2].y := ls2[1].y;
               inc (k2);
               for k := 2 to nbpts-1
               do begin
                  if   ((ls2[k  ].x-ls2[k-1].x) = 0) or
                       ((ls2[k+1].x-ls2[k-1].x) = 0)
                  then begin
                     lsup[k2].x := ls2[k].x;
                     lsup[k2].y := ls2[k].y;
                     inc (k2);
                  end else
                     if abs(((ls2[k].y  -ls2[k-1].y)/(ls2[k].x  -ls2[k-1].x))-
                            ((ls2[k+1].y-ls2[k-1].y)/(ls2[k+1].x-ls2[k-1].x)))
                         > 0.01
                     then begin
                        lsup[k2].x := ls2[k].x;
                        lsup[k2].y := ls2[k].y;
                        inc (k2);
                     end;
               end;
               lsup[k2].x := ls2[nbpts].x;
               lsup[k2].y := ls2[nbpts].y;

               nbpts := k2;

               { ESCAPE }
               if ToucheClavier (Code)
               then begin
                  if Code = ESC
                  then begin
                     PleineCloture;
                     exit;
                  end;
               end;

            end;         { J mos PasF }

         pleinecloture;
      end;
   end;

procedure PlacerCentre;
   var
      dx, dy, fb     : real;

   begin
      ChangerCurseur (croix);
      fenetre (fb1, fb2, fb3, fb4);
      cloture (cc1, cc2, cc3, cc4);
      DessinerBloc;                            { Effacer }
      MontrerSouris;
      repeat
         until not UnBoutonSourisEnfonce;
      repeat
         until BoutonSourisEnfonce (BoutonGauche);
      cachersouris;
      ChangerCurseur (fleche);
      LirePositionSouris (xs, ys);
      fenetre (fb1, fb2, fb3, fb4);
      cloture (cc1, cc2, cc3, cc4);
      SetColor (coulecran);
      DessinerBloc;                            { Effacer }

      dx := XUtilisateur (xs) - XUtilisateur ((cc2+cc1) div 2);
      dy := YUtilisateur (ys) - YUtilisateur ((maxy - ((cc4+cc3) div 2)));

      fb  := -(fb2-fb1)/2 - dx;
      fb2 :=  (fb2-fb1)/2 - dx;
      fb1 := fb;
      fb  := -(fb4-fb3)/2 - dy;
      fb4 :=  (fb4-fb3)/2 - dy;
      fb3 := fb;

      fenetre (fb1, fb2, fb3, fb4);
      cloture (cc1, cc2, cc3, cc4);
      repeat
         until not UnBoutonSourisEnfonce;
   end;

procedure ModifierParams3D (Icone : integer);
   const
      PasTheta          = 5;
      PasPhi            = 5;

   begin
      repeat
         if BlocVisible
         then begin
            SetColor (coulecran);
            DessinerBloc;                            { Effacer }
            BlocVisible := false;
         end else begin
            fenetre (fb1, fb2, fb3, fb4);
            cloture (cc1, cc2, cc3, cc4);
            EffCart;
         end;
         Case Icone of
             6 : Theta := Theta + PasTheta;
             7 : begin
                    theta    := 290;
                    Phi      := 25;
                    ThetaSol := 215;
                    PhiSol   := 35;
                    Rho      := 0;
                    DivZ     := 0;
                    Cadrer3D (-5*LaGrille.nbcog, 5*LaGrille.nbcog,
                              -5*LaGrille.nbcog, 5*LaGrille.nbcog);
                    DefinirParamsMode3D;
                 end;
             8 : Theta := Theta - PasTheta;
             9 : Phi   := Phi   + PasPhi;
             5 : Phi   := Phi   - PasPhi;
            10 : begin
                    rho := rho * 1.1;
                    de  := 7 * rho
                 end;
            11 : begin
                    DivZ := DivZ * 0.9;
                    if DivZ < (LaGrille.Maxzg-LaGrille.Minzg)
                              /LaGrille.nbcog*4 / 5
                    then
                       DivZ := (LaGrille.Maxzg-LaGrille.Minzg)
                               /LaGrille.nbcog*4 / 5;
                 end;
            12 : begin
                    if (fb2-fb1) > maxx div 5
                    then begin
                       fb1 := fb1+(fb2-fb1)/100;
                       fb2 := fb2-(fb2-fb1)/100;
                       fb3 := fb3+(fb4-fb3)/100;
                       fb4 := fb4-(fb4-fb3)/100;
                       fenetre (fb1, fb2, fb3, fb4);
                       cloture (cc1, cc2, cc3, cc4);
                    end;
                 end;
            13 : begin
                    if rho > 0.34 * 3.5 * LaGrille.NbCog
                    then
                       rho := rho*0.9;
                    de := 7*rho
                 end;
            14 : begin
                    DivZ := DivZ*1.1;
                    if DivZ > (LaGrille.Maxzg-LaGrille.Minzg)
                              /LaGrille.nbcog*4 * 5
                    then
                       DivZ := (LaGrille.Maxzg-LaGrille.Minzg)
                               /LaGrille.nbcog*4 * 5;
                 end;
            15 : begin
                    if fb2-fb1 <  maxx*5
                    then begin
                       fb1 := fb1-(fb2-fb1)/100;
                       fb2 := fb2+(fb2-fb1)/100;
                       fb3 := fb3-(fb4-fb3)/100;
                       fb4 := fb4+(fb4-fb3)/100;
                       fenetre (fb1, fb2, fb3, fb4);
                       cloture (cc1, cc2, cc3, cc4);
                    end;
                 end;
            16 : PhiSol   := (PhiSol+5);
            19 : ThetaSol := (ThetaSol+5)   mod 360;
            17 : ThetaSol := (ThetaSol+355) mod 360;
            20 : PhiSol   := (PhiSol-5);
            21 : PlacerCentre;
         end;
         if theta  <   0 then theta := 360+theta;
         if theta  > 360 then theta := theta-360;
         if phi    >  90 then phi   := 90;
         if phi    <   0 then phi   := 0;
         if phiSol >= 90 then phiSol:= 89;
         if phiSol <   0 then phiSol:= 0;
         initialiseprojection;
         direc_soleil (ThetaSol, PhiSol);
         DessinerBloc; { Afficher }
         AfficherAngles (false);
         BlocVisible := true;
         modipar := true;
         delay (10);
      until not unboutonsourisenfonce;
      if (icone < 16) or (icone > 20)
      then
         recalc_Noms_3d (true);
   end;

procedure esquisse;
   begin
      fenetre (fb1, fb2, fb3, fb4);
      cloture (cc1, cc2, cc3, cc4);
      if theta  <   0 then theta  := 360+theta;
      if theta  > 360 then theta  := theta-360;
      if phi    >  90 then phi    := 90;
      if phi    <   0 then phi    := 0;
      if phiSol >= 90 then phiSol := 89;
      if phiSol <   0 then phiSol := 0;
      initialiseprojection;
      direc_soleil (ThetaSol, PhiSol);
      DessinerBloc; { Afficher }
      BlocVisible := true;
   end;

{procedure redessine_tout;
   begin
      inifondecran;
      iniecran;
   end;  }

procedure dess_bloc (trac : boolean);
   begin
      fenetrecloturecrantrac (trac);
      if not trac
      then begin
         Efface_bloc;
         AfficherMode3D;
         { fixecoul  (coulcarte);}
         fixetrait (0);
      end;

      if visugrad
      then begin
         CalculerBornes;
         Graduer3D;
      end;

      if horiz or trac or copie_en_cours
      then
         Tracer3d;       { lignes horizontales }

      AfficherAngles (trac);

      pleinecrantrac (trac);
   end;

procedure ajoute_graduations_3d ;
   begin
      fenetrecloturecrantrac_b (false);
      CalculerBornes;
      Graduer3D;
      pleinecrantrac           (false);
   end;

procedure ajoute_toponymie_3d (trac, eff : boolean);
   begin
      if eff
      then
         effacer_noms
      else
         {  fenetrecloturecrantrac_b (trac );
            dess_symb_3d;
            pleinecrantrac           (trac);}
         dessiner_noms (false, true, fond_t);
      modicomm := true;
   end;

procedure pal_noir;
   var
      i                 : integer;

   begin
      for i := 8 to 14
      do
         SetRGBPalette (i, 10+5*(i-7), 10+5*(i-7), 10+5*(i-7));
   end;

procedure inipalette;
   begin
      { rechercher la palette  }
      if ftxt_present (cheminmodule+nomfpal+extpal)
      then
         chargepalette (cheminmodule+nomfpal+extpal, ok)         { graphism }
      else begin
         nomfpal := nomdumodule;
         if ftxt_present (cheminmodule+nomfpal+extpal)
         then
            chargepalette (cheminmodule+nomfpal+extpal, ok)         { graphism }
      end;
   end;

procedure redess_bloc (trac : boolean);
   begin
      dess_bloc                     (trac);
      if visutoponym
      then
         dessiner_noms         (trac, true, not copie_en_cours
                                                 and fond_t );
      if visucomm
      then
         dessiner_commentaires (trac, true, false);
   end;

procedure redess_tout;
   begin
      if copie_en_cours
      then begin
         if qual = 4
         then
            pal_noir;
      end else begin
         if qual = 4
         then
            inipalette;
         fond_ecran (coulecran);         {= coulecran=coulboite  }
         affichemenu;
         dess_icones;
      end;
      ini_titre;
      inietat;
      redess_bloc (false);
      modicomm := false;
   end;

END.

{--- GEOCEAN - BLOC_DES ---------------------- R.C.- INRP - TOULOUSE - 1995 }

