UNIT CART_1;

   {------------------------------------------------------------------------}
   { logiciel GEOCEAN - module CART                                         }
   {                                                                        }
   {                         menu FICHIERS                                  }
   {                                                                        }
   {------------------------------------------------------------------------}

INTERFACE

{$O+,F+}

USES
   Dos,
   Utildivs,                 { ARX     - utilitaires divers                 }
   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   Periphs,                  { ARX     - priphriques, impression, palettes}
   Dirinfo,                  { ARX     - gestion fichier INFO.DIR           }
   Graphuti,                 { ARX     - utilitaires graphiques             }
   Symboles,                 { ARX     - traitement des donnes ponctuelles }

   GEO_var,                  { GEO     - variables globales communes        }
   GEO_des,                  { GEO     - procdures graph. communes         }

   CART_var,                 { CART    - variables globales du module       }
   CART_ini,                 { CART    - initialisations du module          }
   CART_des;                 { CART    - affichages propres au module       }


Procedure sauver_toponymie;
   { Saisit un nom de fichier et sauve la toponymie brute dans le rpertoire
     des donnes de la REGION en cours ( si droits d'criture )             }

Procedure visu_fond;
   { affiche le fond de carte en cours                                      }

Procedure SAUVER_COURBES;
   { redessine et gnre un fichier BLN ou BLZ                              }

Procedure CHARGER_COURBES;
   { charge et redessine un fichier BLN ou BLZ                              }

Procedure CHARGER_fond;
   { charge et redessine un fichier BLF                                     }

Procedure voir_parametres;
   { afficher les listes dans une bote  dfilement                        }

Procedure supprimer_lien;
   { Supprimer une rfrence  un fichier "accessoire"                      }

Procedure modifier_lien;
   { Changer une rfrence  un fichier "accessoire"                        }

Procedure ouvrir_fichier;
   { slectionner un nom de fichier de paramtres existant dans le          }
   { rpertoire de travail (en cours) et rtablir l'environnement de        }
   { travail associ.                                                       }

Procedure nouveau_fichier;
   { slectionner un nouveau nom pour un nouveau fichier de paramtres      }
   { et rtablir l'environnement standard, vt  partir de CART.CRT         }

Procedure enregistrer_fichier;
   { enregistre les paramtres en cours sans changer l'tat de l'cran.     }
   { enregistre aussi les donnes                                           }

Procedure enregistrer_sous;
   { copie les paramtres en cours dans un autre fichier                    }
   { copie aussi les donnes                                                }

Procedure quitter;
   { demander confirmation avant de stopper l'excution                     }


{---------------------------------------------------------------------------}

IMPLEMENTATION


procedure sauver_toponymie;
   var
      nomf              : t12;
      ext               : extstr;
      ok                : boolean;

   begin
      ext     := exttop;
      ok      := false;
      nomf    := region;
      nomfichier_sortie                                    { menus5 }
         (nomf_lieux, '', nomf, ext, ok);
      if ok and (nomf <> '')
      then begin                    { nouveau nom }
         ecrit_toponymie (chemindonnees+nomf+exttop);
         edite_info      (chemindonnees+nomfinfod, nomftop, exttop);
      end;
   end;

procedure voir_parametres;
   begin
      creeliste (c_travail,    1);
      creeliste (c_symboles  , 2);
      creeliste (c_config    , 3);

      liste     (l_params1, l_params2, l_params3, 35, chain, entier);
      case entier of
         1 : voir_ptrav;
         2 : voir_psymb;
         3 : voir_penv;
      end
   end;

procedure visu_fond;
   begin
      visufond := not visufond;
      modipar := true;
      if visufond
      then begin
         fenetrecloturecrantrac (false);
         dess_fond (nomffond+extblf, c_crb, c_etiqs, h_etiq);
         pleinecrantrac (false);
      end else
         effacer_tout_redessiner;
   end;

procedure  SAUVER_COURBES;
   var
      nomf              : t12;
      ext               : extstr;
      ok                : boolean;

   begin
{      sauver  := true;        utilis dans construire courbes }
       { demander nom fichier sans extension }
      ext     := extblf;
      ok      := false;
      nomf    := nomfd;
      nomfichier_sortie                                    { menus5 }
         (nomf_fond1, '', nomf, ext, ok);

      if ok and (nomf <> '')
      then begin                    { nouveau nom }
         nomfcrb := nomf;
         { demander format }
         blz := false;
         if ((copy (nomutil, length (nomutil)-2, 3) = 'ARX')
               or  (copy (nomutil, 1, 2) = 'RC'))
            and prof
         then
            question ('','Format .BLZ  ?', BLZ);

    { utile pour modif de NUAG !}
         if blz
         then
            extcrb := extblz
         else
            extcrb := extblf;
      end else
         exit;                                { sinon on garde l'ancien }

      { tester place, estimer possibilits, informer }
      cree_fichier (nomfcrb+extcrb);       { pour accumulation des courbes }
      dess_courbes (false, true);          { crera aussi le fichier ETI   }
      edite_info   (nomfinfo, nomfcrb, extcrb);             { dirinfo }
      { afficher infos rsultat compter vecteurs, place, ....}
   end;

procedure  CHARGER_COURBES;
   var
      ext               : extstr;
      nomf              : t12;

   begin
      dir_info                                                  { dirinfo }
         ('', nomf_bln, '',
          nomfinfo, '*', extblf, nomf);           { fonds uniquement..}
      ext  :=  extension (nomf);
      nomf :=  sansext   (nomf);

      if nomf <> ''
      then begin
         nomfcrb := nomf;
         extcrb  := ext;
         blz     := extcrb = extblz;
         reconstruire_courbes (false)    { false obligatoire }
      end;
     { afficher infos rsultat compter vecteurs, place, ....}
      inietat;
   end;

procedure  CHARGER_fond;
   var
      ext               : extstr;
      nomf              : t12;

   begin
      dir_info                                                  { dirinfo }
         ('', choix_fond, '',
          nomfinfo, '*', extblf, nomf);           { fonds uniquement..}
      ext  :=  extension (nomf);
      nomf :=  sansext   (nomf);

      if nomf <> ''
      then begin
         nomfcrb := nomf;
         extcrb  := ext;
         fenetrecloturecrantrac (false);
         dess_fond          (nomfcrb+extblf, c_crb, c_etiqs, h_etiq);
         pleinecrantrac         (false)
      end;
   end;

procedure  FIC_DONNEES_contours;              { 1 }
   begin
      if visucontours
      then
         ajoute_contours (false, true);

      liberercontour;
      chang_contour;

      if visucontours
      then
         ajoute_contours (false, false);
   end;

procedure  FIC_DONNEES_fond;              { 1 }
   begin
      chang_fondcarte ('', nomffond);

      if visufond
      then begin
         fenetrecloturecrantrac (false);
         dess_fond          (nomffond+extblf, c_crb, c_etiqs, h_etiq);
         pleinecrantrac         (false)
      end
   end;

procedure  FIC_DONNEES_noms;                  { 1 }
   begin
      chang_noms;
      recalculer_toponymie_2d;
      effacer_tout_redessiner;
      nomftop  := nomfpar;
   end;

procedure  FIC_DONNEES_comm;                   { 1 }
   begin
      chang_comm (nomfcomm);
      effacer_tout_redessiner;
  end;

procedure modifier_lien;
   begin
      entier := 1;
      creeliste (c_contours      , 1);
      creeliste (c_toponymie     , 2);
      creeliste (c_comment       , 3);
      liste (l_lien1, l_lien2, l_lien3, 15, chain, entier);
      case entier of
         1 : FIC_DONNEES_contours;              { 1 }
         2 : FIC_DONNEES_noms;                  { 1 }
         3 : FIC_DONNEES_comm;                  { 1 }
      end;
      modipar := true;
      inietat ;
   end;

procedure  s_FIC_DONNEES_contours;              { 1 }
   begin
      visucontours := false;
      nomfcart     := '';
      liberercontour;
   end;

procedure  s_FIC_DONNEES_fond;                  { 1 }
   begin
      visufond     := false;
      nomffond     := '';
   end;

procedure  s_FIC_DONNEES_noms;                  { 1 }
   begin
      { librer la collection }
      liberer_noms;
      nomftop     := '';
      visutoponym := false;
      ini_par_noms;
      redess_tout ;
   end;

procedure  s_FIC_DONNEES_comm;                  { 1 }
   begin
      { librer la collection }
      liberer_commentaires;

      { effacer}
      nomfcomm := '';
      visucomm := false;
      ini_par_COMM (nomfcomm + extcom); { commentaires }
      effacer_tout_redessiner;
   end;

procedure supprimer_lien;
   begin
      creeliste (c_contours,  1);
      creeliste (c_toponymie, 2);
      creeliste (c_comment,   3);
          liste (s_lien1, s_lien2, s_lien3, 15, chain, entier);
      case entier of
         1 : s_FIC_DONNEES_contours;              { 1 }
         2 : s_FIC_DONNEES_noms;                  { 1 }
         3 : s_FIC_DONNEES_comm;                  { 1 }
      end;
      modipar := true;
      inietat;
   end;

procedure verif;
   begin
      ok := true;
      if modipar and not exempl
      then begin
         question (q_verif1, q_verif2, ok);
         if ok
         then
            if ((nomfpar <> nomdumodule))
            then begin
               ecrire_parametres (true);               { sauver_fichiers }
               modipar:= false;
            end else begin
               message (m_donner_nom);
               enregistrer_sous;
            end;
      end;
   end;

procedure ouvrir_fichier;
   var
      ok                : boolean;

   begin
      ok := visucomm or visutoponym;
      verif;
      efftout;                                                      { des }
      dir_info
         (choix_carte, '', nomutil,
          nomfinfo, '*', extPAR, nomfpar);
      nomfpar :=  sansext (nomfpar);
      if nomfpar = ''
      then
         nomfpar := nomdumodule;
      lire_parametres;
      inidonnees;
      iniecran;                                                    { des }
      ini_noms;
      if ok
      then
         effacer_tout_redessiner
      else
         redess_carte (false);
   end;

procedure nouveau_fichier;
   var
      ok                : boolean;

   begin
      ok := visucomm or visutoponym;
      verif;
      efftout;
      nomfpar := nomdumodule;
      lire_parametres;
      inidonnees;
      iniecran;
      ini_noms;
      if ok
      then
         effacer_tout_redessiner
      else
         redess_carte (false);
   end;

procedure enregistrer_fichier;
   begin
      inietat;
      if nomfpar = nomdumodule
      then
         nomfpar  := nomfdefo (nomdumodule, nomfpar, nomutil);

      if ((nomfpar <> nomdumodule))
      then begin
         nomftop  := nomfpar;
         ecrire_parametres (true);
         modipar := false
      end else
         message (m_Donner_nom);
   end;

procedure enregistrer_sous;
   var
      ext               : extstr;

   begin
      inietat;
      ext     := extpar;
      ok      := false;
      if (nomfpar = nomdumodule)
      then
          nomfpar  := nomfdefo (nomdumodule, nomfpar, nomutil);

      nomfichier_sortie (nomf_nouveau+' ('+extpar+ ') ', '', nomfpar, ext, ok);

      if (nomfpar = nomdumodule) and prof
      then begin
         ok := false;
         question (q_creer1, q_creer2, ok);
      end;

      if ((nomfpar <> nomdumodule) or prof) and ok
      then begin
        { enregistrer aussi les fichiers de donnes dfinitifs }
        { nomfcomm := nomfpar;}
        { if moditop
         then   }
            nomftop  := nomfpar;
         inietat;
         ecrire_parametres (true);
         modipar := false;
{         moditop := false;     }
      end else
         message (m_lefichier+' '+nomfpar+' '+m_lefichiers );
   end;

procedure quitter;
   begin
      question (q_quitter1, q_quitter2, fini);
      if fini
      then
         verif;
   end;


END.

{--- GEOCEAN - CART_1 ------------------------ R.C.- INRP - TOULOUSE - 1995 }
