UNIT COURBCAL;

   {------------------------------------------------------------------------}
   { Calcul       des courbes de niveau (cf  TOPO) commence       10/07/92 }
   {                                     dernire rvision le      05/06/93 }
   {                                                                        }
   {------------------------------------------------------------------------}
   { A R X - Alain, Roger et Xavier CULOS - 6 avenue de Lagarde 31130 BALMA }
   {------------------------------------------------------------------------}

   { Utilise une grille BGI au format maxi NBMAXCOL*NBMAXLIG

     Cet algorithme recherche d'abord des segments et modifie la
     valeur des sommets s'il y a galit avec le niveau en cours.

     Les valeurs indfinies ( > maxzg ) sont ignores : pas d'interpolation
     ni donc de courbe dans toute case dont un sommet est inconnu.
     -----------------------------------------------------------------------}

INTERFACE

{$O+,F+}

USES
   Fctmath,                  { ARX     - fonctions mathmatiques      }
   GRILLES;                  { ARX     - Lecture des grilles          }

CONST
   memmini         = 4096;

TYPE
   surbrin         = ^t_point;             { pointe sur une liste de points }
   t_point         = record                { liste des points d'un brin     }
                        x, y   : real;     { coordonnes                    }
                        etat   : boolean;  { V trait suivant dessin        }
                        suiv   : surbrin;  { point suivant                  }
                     end;

   surcourbe       = ^t_courbe;
   t_courbe        = record                 { pointe sur une liste de brins }
                        nbp    : integer;   { nombre de points (sommets +1) }
                        br     : surbrin;   { brin                          }
                        suiv   : surcourbe; { brin suivant                  }
                     end;

{---------------------------------------------------------------------------}
Procedure ini_brin           (var br : surbrin ; a, b : real);
   { cre un point initialis  0                                           }

Function c_x                 (br : surbrin ; n : integer)       : real;

Function c_y                 (br : surbrin ; n : integer)       : real;
            { br <> nil      n > 0                                          }
   { rendent coordonnes du point n                                         }

Function eta                 (br : surbrin ; n : integer)       : boolean;
            { br <> nil      n > 0                                          }
   { rend tat du point n                                                   }
Procedure change_etat        (br : surbrin ; d, f : integer);
   { inverse l'tat du point de d  f inclus                                }

Procedure ajoute_pt_tete     (var br : surbrin ; a, b : real);
   { cre un point en tte de liste BRIN                                    }

Procedure ajoute_pt_queue    (br : surbrin ; a, b : real);
   { cre un point en queue de liste BRIN                                   }

Procedure lib_brins          (var br : surbrin);
   { libre les pointeurs sur les tableaux de coordonnes                   }

Procedure ajoute_brins       (c : surcourbe; br : surbrin);
   { Chane un double brin en fin de liste COURBE                           }

Procedure init_courbe        (var c : surcourbe);
   { Cre une liste pour les donnes d'un niveau (n brins = COURBE)         }

Procedure libere_courbe      (var c : surcourbe);
   { Libre les pointeurs sur la liste COURBE                               }

Procedure calcule_courbe     (alt : real; var courbe : surcourbe);
   { Recherche la courbe de niveau dans une grille complte ou non          }

Procedure lisser_courbe      (c : surcourbe; nbpi : integer);
   { lisse tous les brins d'un niveau                                       }
   {  spline d'ordre 2 avec nbpi variable                                   }

{---------------------------------------------------------------------------}

IMPLEMENTATION

VAR
   nbpts,                         { nombre points enregistrs par courbe    }
   nbpl                           { nombre de point par ligne = double brin }
                        : integer;

   segments             : array [1..nbmaxcol,
                                 1..nbmaxlig,
                                 1..3]
                             of boolean;
                                              { 1 = entre noeuds en x,
                                                2 = entre noeuds en y,
                                                3 = bout 1er brin }

procedure ini_brin (var br : surbrin ; a, b : real);
   begin
      new (br);
      br^.x    := a;
      br^.y    := b;
      br^.etat := true;     { crayon baiss }
      br^.suiv := nil;
   end;

procedure lib_brins (var br : surbrin);
   var
      p_ct, p_sui       : surbrin;

   begin
      p_sui  := br;
      p_ct   := br;
      while p_ct <> nil
      do begin
         p_sui := p_ct^.suiv;
         dispose   (p_ct);
         p_ct  := p_sui;
      end;
      br := nil;
   end;

procedure ajoute_pt_tete (var br : surbrin ; a, b : real);
   var
      p_ct, p           : surbrin;

   begin
      ini_brin (p, a, b);
      p_ct := br;
      if p_ct <> nil
      then begin
         p_ct := p;
         p_ct^.suiv := br;
      end;
      br := p;
   end;

procedure ajoute_pt_queue (br : surbrin ; a, b : real);
   var
      p_ct, p           : surbrin;

   begin
      ini_brin (p, a, b);
      if br = nil
         then
            br := p
         else begin
            p_ct := br;
            while p_ct^.suiv <> nil
            do
               p_ct := p_ct^.suiv;
            p_ct^.suiv := p;
         end
   end;

function c_x (br : surbrin ; n : integer) : real;
            { br <> nil      n > 0 }
   var
      i                 : integer;
      p_ct              : surbrin;

   begin
      p_ct := br;
      i    := 1;
      while i < n
      do begin
         inc (i);
         p_ct := p_ct^.suiv;
      end;
      c_x := p_ct^.x;
   end;

function c_y (br : surbrin; n : integer) : real;
            { br <> nil      n > 0 }
   var
      i                 : integer;
      p_ct              : surbrin;

   begin
      p_ct := br;
      i    := 1;
      while i < n
      do begin
         inc (i);
         p_ct := p_ct^.suiv;
      end;
      c_y := p_ct^.y;
   end;

function eta                 (br : surbrin ; n : integer) : boolean;
   var
      i                 : integer;
      p_ct              : surbrin;

   begin
      p_ct := br;
      i    := 1;
      while i < n
      do begin
         inc (i);
         p_ct := p_ct^.suiv;
      end;
      eta := p_ct^.etat;
   end;

procedure change_etat        (br : surbrin ; d, f : integer);
   { inverse l'tat du point de d  f inclus                                }
   var
      i                 : integer;
      p_ct              : surbrin;

   begin
      p_ct := br;
      i    := 1;
      while i < d
      do begin
         inc (i);
         p_ct := p_ct^.suiv;
      end;
      for i := d to f
      do begin
         p_ct^.etat := not p_ct^.etat;
         p_ct := p_ct^.suiv;
      end;
   end;

procedure init_courbe   (var c : surcourbe);
   begin
      new (c);
      c^.nbp    := 0;
      c^.br     := nil;
      c^.suiv   := nil;
   end;

procedure libere_courbe (var c : surcourbe);
   var
      p_ct, p_sui  : surcourbe;

   begin
      p_sui  := c;
      p_ct   := c;
      while p_ct <> nil
      do begin
         p_sui := p_ct^.suiv;
         if p_ct^.br <> nil
         then
            lib_brins (p_ct^.br);
         dispose   (p_ct);
         p_ct  := p_sui;
      end;
      c := nil;
   end;

procedure ajoute_brins (c : surcourbe; br : surbrin);
   begin
      c^.nbp  := nbpl;
      c^.br   := br;
      nbpts   := nbpts+nbpl;
   end;

procedure init_segments (alt : real);   { tous libres }
   var
         i, j           : integer;
         z              : real ;

   begin
      with LaGrille
      do begin
         for i := 1 to nbcog
         do begin
            z := valeur (i, 1);
            if z >= indefini
            then begin
               segments [i, 1, 1] := false ;
               segments [i, 1, 2] := false
            end else begin
               segments [i, 1, 1] := true ;
               segments [i, 1, 2] := true ;
            end;
            segments [i, 1, 3] := false ;
            if z = alt
            then
               affecter (i, 1, valeur (i, 1) + 1)
         end;
         for j := 1 to nblig
         do begin
            z := valeur (1, j);
            if z >= indefini
            then begin
               segments [1, j, 1] := false ;
               segments [1, j, 2] := false
            end else begin
               segments [1, j, 1] := true ;
               segments [1, j, 2] := true ;
            end;
            segments [1, j, 3] := false ;
            if z = alt
               then affecter (1, j, valeur (1, j) + 1)
         end;
         for j := 2 to nblig
         do
            for i := 2 to nbcog
            do begin
               z := valeur (i, j);
               if z >= indefini
               then begin
                  segments [i, j, 1] := false;
                  segments [i, j, 2] := false;
                  segments [i-1, j, 1] := false;
                  segments [i, j-1, 2] := false;
               end else begin
                  segments [i, j, 1] := true;
                  segments [i, j, 2] := true;
               end;
               segments [i, j, 3] := false;
               if z = alt
               then
                  affecter (i, j, valeur (i, j) + 1)
            end;
      end;
   end;

{$R-}
function caselibre (i, j : integer) : boolean;
   begin
      with LaGrille
      do begin
         caselibre := (segments [i,   j,   1] or
                       segments [i,   j,   2] or
                       segments [i+1, j,   2] or
                       segments [i,   j+1, 1] or
                       segments [i,   j,   3] or
                       segments [i,   j+1, 3])

                     and (i >= 1) and (i < nbcog)
                     and (j >= 1) and (j < nblig)

                     and not ((valeur (i  , j)   >= indefini) or
                              (valeur (i+1, j)   >= indefini) or
                              (valeur (i  , j+1) >= indefini) or
                              (valeur (i+1, j+1) >= indefini))
      end;
   end;
{$R+}

function termine : boolean;         { V = plus de case  explorer }
   var
         i, j           : integer;
         ok             : boolean;

   begin
      with LaGrille
      do begin
         ok := false;
         j  := 1;
         while not ok and (j <= nblig-1)
         do begin
            i  := 1;
            while not ok and (i <= nbcog-1)
            do begin
               ok  := caselibre (i, j)  ;
               inc (i);
            end;
            inc (j);
         end;
         termine := not ok;
      end;
   end;

function dans_interv (z, z1, z2 : real ) : boolean;
   { test appartenance  l'intervalle [ z1, z2 ]    }
   begin
      dans_interv :=  ((z > z1) and (z < z2))
                   or ((z > z2) and (z < z1));
   end;

procedure calcule_courbe (alt : real ; var courbe : surcourbe);
   var
      crbe_cte                  { brin_courant }
                        : surcourbe;
      brin_ct                   { liste des coord. des points d'un brin }
                        : surbrin;

      i,  j,                        { noeud pivot                      }
      i2, j2,                       { premire case 2ime partie brin  }
      direction,                    { direction en cours               }
      direc2,                       { direction 2ime partie brin      }
      nbcle                         { var temporaire                   }
                        : integer;

      existe,                       { premier point trouv      }
      brin1,
      bout                          { brin1 non ferm           }
                        : boolean;
      xx, yy,                       { point suivant             }
      x, y,                         { coordonnes repre carte  }
      x1, y1
                        : real;

   procedure interpoler (a, b , z1, z2 : real;
                        var xy         : real);
      begin
          xy := abs ( (alt-z1) / (z2-z1) ) * (b-a) +a;
      end;

   procedure ajoute_point (alafin : boolean ; a, b, c : real;
                           var br : surbrin);
      { mmorise les coordonnes d'un point d'un brin }
      { nbpl   = nb de points dj enregistrs sur l'ensemble du brin }

      var
         i              : integer;

      begin
         inc (nbpl);
         if alafin
         then begin       {  la fin du brin ...}

            ajoute_pt_queue (br, a, b);

         end else begin             { en tte de la liste }

            ajoute_pt_tete  (br, a, b);

         end;
      end;

   procedure construire_premier_point (var x, y      : real ;
                                       var direction : integer;
                                       var trouve    : boolean);
      { global courbes : i, j,   i2, j2 }
      var
         x1,  x2,                   { coord des noeuds   }
         z1,  z2                    { valeurs aux noeuds }
                        : real;

      begin                                   { construire premier }
         with LaGrille
         do begin
            trouve := false;
            j      := 1;
            while (j <= nblig) and (not trouve)
            do begin
               i   := 1;
               while (i < nbcog) and (not trouve)
               do begin
                  if segments [i, j, 1]
                  then begin
                     z1 := valeur (i, j);
                     z2 := valeur (i+1, j);
                     trouve := dans_interv (alt, z2, z1);
                     segments [i, j, 1] := false;
                  end;
                  inc (i);
               end;
               inc (j);
            end;
            if trouve
            then begin
               j := j-1;               { ligne   }   { premier pivot }
               i := i-1;               { colonne }
               segments [i, j, 3] := true;
            end else
               exit;
            y  := ordy (j);            { ordonne du premier point }
            x1 := absx (i);
            x2 := absx (i+1);
            interpoler (x1, x2,
                        valeur (i, j), valeur (i+1, j),
                        x);            { abscisse du premier point }

            direction := 1;            { prparer pt suivant brin 1 }
            direc2    := 3;
            j2  := j-1;                { prvoir brin 2  }
            i2  := i;

            xx  := x;
            yy  := y;
         end;
      end;

   procedure ajoute_suivant (i, j       : integer;  { pivot en haut  g  }
                             direction  : integer;  { direction courante }
                             var x,  y  : real ;    { coord repre carte }
                             var direcs,            { direction suivante }
                                 is, js : integer); { pivot suivant      }

      { rech coord du point  la mme altitude dans la case courante
        en fonction de la DIRECTION en entre dans la case ; le recherche
        est effectue sur les segments libres. }

      var
         z1, z2,
         x1, x2,
         y1, y2         : real;
         nok            : boolean;

      procedure sor1 (var nok : boolean);
         begin
            with LaGrille
            do begin
               nok := true;
               is  := i;
               js  := j;
               direcs := direction;
               if (not segments [i, j, 1]) and (not segments [i, j, 3])
                  { on y est passe          et  ce n'est pas un bout }
                  then exit;
               z1  := valeur (i,     j);
               z2  := valeur (i+1,   j);
               if dans_interv (alt, z1, z2)
               then begin
                  interpoler  (x1, x2, z1, z2, x);
                  y      := y1;
                  direcs := 3;
                  is     := i;
                  nok    := false;
                  js     := j-1;
               end;
               segments [i, j, 1] := false; { segment explor }
               segments [i, j, 3] := false;
            end;
         end;

      procedure sor2 (var nok : boolean);
         begin
            with LaGrille
            do begin
               nok := true;
               is  := i;
               js  := j;
               direcs := direction;
               if (not segments [i, j, 2]) then exit;
               z1  := valeur (i,   j);
               z2  := valeur (i, j+1);
               if dans_interv (alt, z1, z2)
               then begin
                  interpoler  (y1, y2, z1, z2, y);
                  x      := x1;
                  direcs := 4;
                  js     := j;
                  nok    := false;
                  is     := i-1;
               end;
               segments [i, j, 2] := false;
            end;
         end;

      procedure sor3 (var nok : boolean);
         begin
            with LaGrille
            do begin
               nok := true;
               is  := i;
               js  := j;
               direcs := direction;
               if (not segments [i, j+1, 1]) and (not segments [i, j+1, 3])
                  then exit;

               z1  := valeur (i,   j+1);
               z2  := valeur (i+1, j+1);
               if dans_interv (alt, z1, z2)
               then begin
                  interpoler  (x1, x2, z1, z2, x);
                  y      := y2;
                  direcs := 1;
                  is     := i;
                  nok    := false;
                  js     := j+1;
               end;
               segments [i, j+1, 1] := false;
               segments [i, j+1, 3] := false;
            end;
         end;

      procedure sor4 (var nok : boolean);
         begin
            with LaGrille
            do begin
               nok := true;
               is  := i;
               js  := j;
               direcs := direction;
               if (not segments [i+1, j, 2]) then exit;
               z1  := valeur (i+1, j   );
               z2  := valeur (i+1, j+1 );
               if dans_interv (alt, z1, z2)
               then begin
                  interpoler  (y1, y2, z1, z2, y);
                  x      := x2;
                  direcs := 2;
                  js     := j;
                  nok    := false;
                  is     := i+1;
               end;
               segments [i+1, j, 2] := false;
            end;
         end;

     begin                          { ajouter suivant }
        with LaGrille
        do begin
           x1  := absx (i); x2  := absx (i+1);
           y1  := ordy (j); y2  := ordy (j+1);

           if dans_interv (alt, valeur (i, j+1), valeur (i+1, j))
                             { altitude comprise dans la diagonale }
           then             { rechercher sortie cots opposs }
              case direction of
                 1,2 : begin
                          sor3 (nok);
                          if nok then sor4 (nok);
                       end;
                 3,4 : begin;
                          sor1 (nok);
                          if nok then sor2 (nok);
                       end;
              end
           else             { rechercher sortie cots adjacents }
              case direction of
                 1  : sor2 (nok);
                 2  : sor1 (nok);
                 3  : sor4 (nok);
                 4  : sor3 (nok);
              end;
         end; { with }
      end;

   procedure brin (    x, y           : real;
                       i, j, direc    : integer;
                   var b              : surbrin);
      { coord pt dpart, pivot en cours, direction, brin1 V }

      var
         is, js,
         direcs         : integer;
         bout1,
         bout2          : boolean;

      begin
         bout := true;
         while bout and caselibre (i, j)
         do begin { la case contient un seg. libre }
            bout1 := segments [i, j,   3];
            bout2 := segments [i, j+1, 3];

            ajoute_suivant (i, j, direc, x, y, direcs, is, js);
            ajoute_point   (brin1, x, y, alt, b);
                                     { mmoriser pt }
            bout := (bout1 = segments [i, j,   3]) and
                    (bout2 = segments [i, j+1, 3]);

            j              := js;
            i              := is;
            direc          := direcs;
         end;
      end;

                          { CONSTRUIRE la COURBE NBC }
   BEGIN                  { une courbe  : n lignes Ouvertes ou Fermes }
      nbpts   := 0;                 { nb pts sur une courbe }
      init_segments (alt);
      crbe_cte := courbe;
      nbcle := 0;
      while not  termine  and (memavail > memmini)
      do begin             { ENCORE UN TRONCON DE COURBE }
         inc (nbcle);
         nbpl    := 0;              { nb pts sur une ligne  }
         construire_premier_point (x, y, direction, existe);
         if not existe then exit;

         if nbcle = 1
         then
            courbe := crbe_cte;
         ini_brin    (brin_ct, x, y) ;
         inc (nbpl);
         x1 := x; y1 := y;
                                                 { mmoriser premier point  }
                                                 { dans le brin_xy          }
         brin1 := true;
         BRIN (x,  y,  i,  j,  direction, brin_ct);
                                                 { premier brin             }
         segments [i2, j2+1, 3] := false;        { prparer raccord brin 2  }
         if bout
         then begin
            brin1 := false;                      { c'est le deuxime        }
            BRIN (xx, yy, i2, j2, direc2, brin_ct);
                                                 {                    brin  }
         end;
         ajoute_brins (crbe_cte, brin_ct);
                                               { allonge la liste des brins }
         init_courbe  (crbe_cte^.suiv);
         crbe_cte   := crbe_cte^.suiv;
      end;
   END;

procedure lisser_courbe (c : surcourbe; nbpi : integer);
   var
      p_ct, p_sui       : surcourbe;

   procedure lisser_brins (b : surcourbe);
         { lissage de chaque tronon de courbe : spline du premier degr }
         { nbpi > 1 }
      var
         br_ct,
         tr                  : surbrin;
         l_ouverte           : boolean;
         npi, npf            : integer;
         px,  py,
         pmx, pmy            : real;

      procedure spline2 (np1, np2, np3 : integer; var px, py : real);
         var
            i                : integer;
            pix,  piy,
            pfx,  pfy,
            p2mx, p2my,
            alfa,
            cp2x, cp2y               { coord np2 }
                             : real;

         begin
            cp2x  :=  c_x (b^.br, np2);
            cp2y  :=  c_y (b^.br, np2);
            p2mx  := (c_x (b^.br, np3) + cp2x) /2;   { milieu }
            p2my  := (c_y (b^.br, np3) + cp2y) /2;

            for i := 1 to nbpi-1
            do begin
               alfa := 1 / nbpi * i;
               pix  := pmx  + (cp2x - pmx)  * alfa;
               piy  := pmy  + (cp2y - pmy)  * alfa;
               pfx  := cp2x + (p2mx - cp2x) * alfa;
               pfy  := cp2y + (p2my - cp2y) * alfa;
               px   := pix  + (pfx  - pix)  * alfa;
               py   := piy  + (pfy  - piy)  * alfa;
               inc (npf);
               ajoute_pt_queue (br_ct, px, py);
            end;
            px := p2mx;
            py := p2my;
            inc (npf);
            ajoute_pt_queue (br_ct, px, py);
         end;

      begin                      { lisser_brins }
         nbpl := b^.nbp;
         if nbpi < 2 then exit;
         if nbpl < 3 then exit;

         l_ouverte  := (c_x (b^.br, 1) <> c_x (b^.br, nbpl))
                    or (c_y (b^.br, 1) <> c_y (b^.br, nbpl));

         pmx := ( c_x (b^.br, 1) + c_x (b^.br, 2)) /2;  { milieu }
         pmy := ( c_y (b^.br, 1) + c_y (b^.br, 2)) /2;
         npi    := 1;                                   { ligne initiale }
         if l_ouverte
         then begin
            ini_brin        (br_ct, c_x (b^.br, 1), c_y (b^.br, 1));
            ajoute_pt_queue (br_ct, pmx, pmy);
            npf    := 2;                                { ligne calcule }
         end else begin
            npf    := 1;
            ini_brin        (br_ct, pmx, pmy);
         end;
         repeat
            spline2 (npi, npi+1, npi+2, px, py);  { calculer point suivant }
            pmx := px;
            pmy := py;
            inc (npi);
         until     (    l_ouverte  and  (npi = nbpl-1)) or
                   (not l_ouverte  and  (npi = nbpl-1));

         if l_ouverte
         then begin
            inc (npf);
            ajoute_pt_queue (br_ct, c_x (b^.br, nbpl), c_y (b^.br, nbpl)) ;
         end else
            spline2 (npi, npi+1, 2, px, py);

         tr     := b^.br ;     { tr pointeur temporaire }
         b^.br  := br_ct ;     { change }
         b^.nbp := npf;
         lib_brins (tr);
      end;

   begin                               { lisser courbe }
      p_sui  := c;
      p_ct   := c;
      while p_ct <> nil
      do begin
         p_sui := p_ct^.suiv;
         lisser_brins (p_ct);
         p_ct  := p_sui;
      end;
   end;

END.

{ GEOCEAN - COURBCAL -------------------------------- INRP - TOULOUSE - ARX }

