{************************************************}
{   GRAPHAPP.PAS                                 }
{   Turbo Pascal 6.0 TVDEMOS Accessoire BGI      }
{                                                }
{   Unit utilise par:                          }
{     TVBGI   .PAS                               }
{   Units rfrences:                          }
{     OBJECTS .PAS                               }
{     GRAPH   .TPU (implementation)              }
{     APP     .PAS (implementation)              }
{     DRIVERS .PAS (implementation)              }
{     MEMORY  .PAS (implementation)              }
{                                                }
{   Copyright (c) 1990 by Borland International  }
{************************************************}

UNIT GraphApp;

{$F+,O+,S-,D+}

{ Unit de support du systme graphique BGI pour Turbo Vision. }
{ Utilise par le programme d'exemple TVBGI.PAS.               }

INTERFACE

USES Objects;

function GraphAppInit(ADriver, AMode: Integer; ABGIPath: PString;
  LoadAtInit: Boolean): Boolean;
procedure GraphAppDone;
function GraphicsStart: Boolean;
procedure GraphicsStop;
function GraphicsActive: Boolean;

IMPLEMENTATION

USES Graph, Mouse, Drivers, Memory, App;

CONST
  GraphActive: Boolean = False;
  DriverPtr:   Pointer = nil;
  DriverSize:  Word = 0;
  EmptyString: string[1] = '';
  BGIPath:     PString = @EmptyString;
  Driver:      Integer = Detect;
  Mode:        Integer = 0;

  LastDriver = 10;
  DriverName: array[1..LastDriver] of string[8] =
    ('CGA',                {  1. CGA      }
     'CGA',                {  2. MCGA     }
     'EGAVGA',             {  3. EGA      }
     'EGAVGA',             {  4. EGA64    }
     'EGAVGA',             {  5. EGAMONO  }
     'IBM8514',            {  6. IBM8514  }
     'HERC',               {  7. HercMono }
     'ATT',                {  8. ATT400   }
     'EGAVGA',             {  9. VGA      }
     'PC3270');            { 10. PC3270   }


{ Mthodes utilitaires. }
procedure FreeDriverMem(var P: Pointer; var S: Word);
begin
  if P <> nil then FreeMem(P, S);
  P := nil;
  S := 0;
end;

function GraphAppLoadDriver(DriverNum: Integer): Boolean;
var
  F: File;
  S: string[1];
begin
  GraphAppLoadDriver := False;
  if DriverNum <= LastDriver then
  begin
    if BGIPath^[Length(BGIPath^)] = '\' then S := ''
    else S := '\';
    Assign(F, BGIPath^ + S + DriverName[Driver] + '.BGI');
    {$I-}
    FileMode:=64;
    Reset(F, 1);
    {$I+}
    if IOResult = 0 then
    begin
      DriverSize := FileSize(F);
      if (DriverSize < 64 * 1024 - $F) and (DriverSize <= MaxAvail) then
      begin
        GetMem(DriverPtr, DriverSize);
        BlockRead(F, DriverPtr^, DriverSize);
        if (IOResult = 0) and (RegisterBGIdriver(DriverPtr) >= 0) then
          GraphAppLoadDriver := True
        else
          FreeDriverMem(DriverPtr, DriverSize);
      end;
      Close(F);
    end;
  end;
end;

{ Initialisation du BGI. Si LoadAtInit est Vrai, tentative de recherche 
  et de chargement du pilote. Renvoie Vrai si LoadAtInit russit ou 
  s'il renvoie Faux. Le chemin d'accs au BGI (BGIPath) n'est pas fig 
  mais reu en paramtre de type pointeur sur chane renseign ailleurs.
  Ne libre pas BGIPath en fin d'utilisation.
}

function GraphAppInit(ADriver, AMode: Integer;
  ABGIPath: PString; LoadAtInit: Boolean): Boolean;
begin
  GraphAppInit := True;
  if ABGIPath <> nil then BGIPath := ABGIPath;
  Driver := ADriver;
  Mode := AMode;
  FreeDriverMem(DriverPtr, DriverSize);
  if LoadAtInit then
  begin
    if Driver = 0 then DetectGraph(Driver, Mode);
    if (Driver > 0) then GraphAppInit := GraphAppLoadDriver(Driver)
    else GraphAppInit := False;
  end;
end;

procedure GraphAppDone;
begin
  if GraphActive then CloseGraph;
  FreeDriverMem(DriverPtr, DriverSize);
  GraphActive := False;
  BGIPath := @EmptyString;
  Driver := Detect;
  Mode := 0;
end;


function GraphicsStart: Boolean;
begin
  GraphicsStart := True;
  if GraphActive then Exit;
  DoneSysError;
  DoneEvents;
  DoneVideo;
  DoneMemory;
{ Driver:=EGA; Mode:=EGAHi; } { pour forcer le mode EGA 640x350x16 2 pages }
  InitGraph(Driver, Mode, BGIPath^);

  if Driver < 0 then
  begin
    GraphicsStart := False;
    GraphicsStop;
  end
  else
  begin
    GraphActive := True;
    MousePresent:=(InitMouse>0);
  end;
end;

function GraphicsActive: Boolean;
begin
  GraphicsActive := GraphActive;
end;

procedure GraphicsStop;
begin
  if GraphActive
  then begin
    CloseGraph;
  end;
  GraphActive := False;
  InitMemory;
  InitVideo;
  InitEvents;
  InitSysError;
  Application^.Redraw;
end;

end.

{   EOS GRAPHAPP.PAS                                 }
